/*
 * Decompiled with CFR 0.152.
 */
package com.google.prefab.cmake;

import com.google.prefab.api.Android;
import com.google.prefab.api.BuildSystemInterface;
import com.google.prefab.api.LibraryReference;
import com.google.prefab.api.Module;
import com.google.prefab.api.NoMatchingLibraryException;
import com.google.prefab.api.Package;
import com.google.prefab.api.PlatformDataInterface;
import com.google.prefab.api.PrebuiltLibrary;
import com.google.prefab.cmake.CMakePluginKt;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0003H\u0002J(\u0010\u0011\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u00062\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0010\u001a\u00020\u0003H\u0002J\u0018\u0010\u0017\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u00062\u0006\u0010\u0018\u001a\u00020\u0003H\u0002J\u0016\u0010\u0019\u001a\u00020\r2\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00160\u001aH\u0016J\u0018\u0010\u001b\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u00062\u0006\u0010\u0015\u001a\u00020\u0016H\u0002R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u001a\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u001c"}, d2={"Lcom/google/prefab/cmake/CMakePlugin;", "Lcom/google/prefab/api/BuildSystemInterface;", "outputDirectory", "Ljava/io/File;", "packages", "", "Lcom/google/prefab/api/Package;", "(Ljava/io/File;Ljava/util/List;)V", "getOutputDirectory", "()Ljava/io/File;", "getPackages", "()Ljava/util/List;", "emitDependency", "", "dep", "", "configFile", "emitModule", "pkg", "module", "Lcom/google/prefab/api/Module;", "requirements", "Lcom/google/prefab/api/PlatformDataInterface;", "emitVersionFile", "versionFile", "generate", "", "generatePackage", "cmake-plugin"})
public final class CMakePlugin
implements BuildSystemInterface {
    @NotNull
    private final File outputDirectory;
    @NotNull
    private final List<Package> packages;

    public CMakePlugin(@NotNull File outputDirectory, @NotNull List<Package> packages2) {
        Intrinsics.checkNotNullParameter(outputDirectory, "outputDirectory");
        Intrinsics.checkNotNullParameter(packages2, "packages");
        this.outputDirectory = outputDirectory;
        this.packages = packages2;
    }

    @Override
    @NotNull
    public File getOutputDirectory() {
        return this.outputDirectory;
    }

    @Override
    @NotNull
    public List<Package> getPackages() {
        return this.packages;
    }

    @Override
    public void generate(@NotNull Collection<? extends PlatformDataInterface> requirements) {
        Intrinsics.checkNotNullParameter(requirements, "requirements");
        PlatformDataInterface platformDataInterface = (PlatformDataInterface)CollectionsKt.singleOrNull((Iterable)requirements);
        if (platformDataInterface == null) {
            throw new UnsupportedOperationException("CMake cannot generate multiple targets to a single directory");
        }
        PlatformDataInterface requirement = platformDataInterface;
        this.prepareOutputDirectory(this.getOutputDirectory());
        for (Package pkg : this.getPackages()) {
            this.generatePackage(pkg, requirement);
        }
    }

    private final void generatePackage(Package pkg, PlatformDataInterface requirements) {
        File file2;
        boolean useArchSpecificLayout;
        boolean bl = useArchSpecificLayout = !(requirements instanceof Android) || ((Android)requirements).getNdkMajorVersion() >= 19;
        if (useArchSpecificLayout) {
            File file3 = FilesKt.resolve(this.getOutputDirectory(), "lib/" + requirements.getTargetTriple() + "/cmake/" + pkg.getName());
            boolean bl2 = false;
            boolean bl3 = false;
            File $this$generatePackage_u24lambda_u2d0 = file3;
            boolean bl4 = false;
            $this$generatePackage_u24lambda_u2d0.mkdirs();
            file2 = file3;
        } else {
            file2 = this.getOutputDirectory();
        }
        File pkgDirectory = file2;
        File configFile = FilesKt.resolve(pkgDirectory, Intrinsics.stringPlus(pkg.getName(), "Config.cmake"));
        for (String dep : CollectionsKt.sorted((Iterable)pkg.getDependencies())) {
            this.emitDependency(dep, configFile);
        }
        Iterable $this$sortedBy$iv = pkg.getModules();
        boolean $i$f$sortedBy = false;
        boolean bl5 = false;
        for (Module module : CollectionsKt.sortedWith($this$sortedBy$iv, new Comparator<T>(){

            public final int compare(T a, T b) {
                boolean bl = false;
                Module it = (Module)a;
                boolean bl2 = false;
                Comparable comparable = (Comparable)((Object)it.getName());
                it = (Module)b;
                Comparable comparable2 = comparable;
                bl2 = false;
                String string = it.getName();
                return ComparisonsKt.compareValues(comparable2, (Comparable)((Object)string));
            }
        })) {
            this.emitModule(pkg, module, requirements, configFile);
        }
        if (pkg.getVersion() != null) {
            this.emitVersionFile(pkg, FilesKt.resolve(pkgDirectory, Intrinsics.stringPlus(pkg.getName(), "ConfigVersion.cmake")));
        }
    }

    private final void emitDependency(String dep, File configFile) {
        FilesKt.appendText$default(configFile, StringsKt.trimIndent("\n            find_package(" + dep + " REQUIRED CONFIG)\n\n\n        "), null, 2, null);
    }

    /*
     * WARNING - void declaration
     */
    private final void emitModule(Package pkg, Module module, PlatformDataInterface requirements, File configFile) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        void $this$filterIsInstanceTo$iv$iv;
        Iterable $this$filterIsInstance$iv;
        void $this$mapTo$iv$iv2;
        void $this$map$iv2;
        void $this$filterIsInstanceTo$iv$iv2;
        Iterable $this$filterIsInstance$iv2;
        String string;
        Collection collection;
        void $this$mapTo$iv$iv3;
        void $this$map$iv3;
        void $this$filterIsInstanceTo$iv$iv3;
        Iterable $this$filterIsInstance$iv3;
        Iterable iterable = module.linkLibsForPlatform(requirements);
        boolean $i$f$filterIsInstance = false;
        void var8_8 = $this$filterIsInstance$iv3;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv3) {
            if (!(element$iv$iv instanceof LibraryReference.Literal)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filterIsInstance$iv3 = (List)destination$iv$iv;
        boolean $i$f$map22 = false;
        $this$filterIsInstanceTo$iv$iv3 = $this$map$iv3;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv3, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv3) {
            void it;
            LibraryReference.Literal literal = (LibraryReference.Literal)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            string = it.getArg();
            collection.add(string);
        }
        List ldLibs = (List)destination$iv$iv;
        Iterable $i$f$map22 = module.linkLibsForPlatform(requirements);
        boolean $i$f$filterIsInstance2 = false;
        destination$iv$iv = $this$filterIsInstance$iv2;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterIsInstanceTo2 = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv2) {
            if (!(element$iv$iv instanceof LibraryReference.Local)) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        $this$filterIsInstance$iv2 = (List)destination$iv$iv2;
        boolean $i$f$map32 = false;
        $this$filterIsInstanceTo$iv$iv2 = $this$map$iv2;
        destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv2, 10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            void it;
            LibraryReference.Local bl = (LibraryReference.Local)item$iv$iv;
            collection = destination$iv$iv2;
            boolean bl2 = false;
            string = pkg.getName() + "::" + it.getName();
            collection.add(string);
        }
        List localReferences = (List)destination$iv$iv2;
        Iterable $i$f$map32 = module.linkLibsForPlatform(requirements);
        boolean $i$f$filterIsInstance3 = false;
        destination$iv$iv2 = $this$filterIsInstance$iv;
        Collection destination$iv$iv3 = new ArrayList();
        boolean $i$f$filterIsInstanceTo3 = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof LibraryReference.External)) continue;
            destination$iv$iv3.add(element$iv$iv);
        }
        $this$filterIsInstance$iv = (List)destination$iv$iv3;
        boolean $i$f$map = false;
        $this$filterIsInstanceTo$iv$iv = $this$map$iv;
        destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo3 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            LibraryReference.External bl2 = (LibraryReference.External)item$iv$iv;
            collection = destination$iv$iv3;
            boolean bl = false;
            string = it.getPkg() + "::" + it.getModule();
            collection.add(string);
        }
        List externalReferences = (List)destination$iv$iv3;
        String libraries = CollectionsKt.joinToString$default(CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)ldLibs, (Iterable)localReferences), (Iterable)externalReferences), ";", null, null, 0, null, null, 62, null);
        String target = pkg.getName() + "::" + module.getName();
        if (module.isHeaderOnly()) {
            String escapedHeaders = CMakePluginKt.sanitize(module.getIncludePath());
            FilesKt.appendText$default(configFile, StringsKt.trimIndent("\n                if(NOT TARGET " + target + ")\n                add_library(" + target + " INTERFACE IMPORTED)\n                set_target_properties(" + target + " PROPERTIES\n                    INTERFACE_INCLUDE_DIRECTORIES \"" + escapedHeaders + "\"\n                    INTERFACE_LINK_LIBRARIES \"" + libraries + "\"\n                )\n                endif()\n\n\n                "), null, 2, null);
        } else {
            try {
                String string2;
                PrebuiltLibrary prebuilt = module.getLibraryFor(requirements);
                String escapedLibrary = CMakePluginKt.sanitize(prebuilt.getPath());
                String escapedHeaders = CMakePluginKt.sanitize(prebuilt.getIncludePath());
                File file2 = prebuilt.getPath().toFile();
                Intrinsics.checkNotNullExpressionValue(file2, "prebuilt.path.toFile()");
                String extension = FilesKt.getExtension(file2);
                if (Intrinsics.areEqual(extension, "so")) {
                    string2 = "SHARED";
                } else if (Intrinsics.areEqual(extension, "a")) {
                    string2 = "STATIC";
                } else {
                    throw new RuntimeException(Intrinsics.stringPlus("Unrecognized library extension: ", extension));
                }
                String prebuiltType = string2;
                FilesKt.appendText$default(configFile, StringsKt.trimIndent("\n                    if(NOT TARGET " + target + ")\n                    add_library(" + target + ' ' + prebuiltType + " IMPORTED)\n                    set_target_properties(" + target + " PROPERTIES\n                        IMPORTED_LOCATION \"" + escapedLibrary + "\"\n\n                    "), null, 2, null);
                if (CMakePluginKt.directoryNotEmpty(prebuilt.getIncludePath())) {
                    FilesKt.appendText$default(configFile, "    INTERFACE_INCLUDE_DIRECTORIES \"" + escapedHeaders + "\"\n", null, 2, null);
                }
                FilesKt.appendText$default(configFile, StringsKt.trimIndent("\n                        INTERFACE_LINK_LIBRARIES \"" + libraries + "\"\n                    )\n                    endif()\n\n\n                    "), null, 2, null);
            }
            catch (NoMatchingLibraryException ex) {
                System.err.println(ex);
            }
        }
    }

    private final void emitVersionFile(Package pkg, File versionFile) {
        FilesKt.writeText$default(versionFile, StringsKt.trimIndent("\n            set(PACKAGE_VERSION " + pkg.getVersion() + ")\n            if(\"${PACKAGE_VERSION}\" VERSION_LESS \"${PACKAGE_FIND_VERSION}\")\n                set(PACKAGE_VERSION_COMPATIBLE FALSE)\n            else()\n                set(PACKAGE_VERSION_COMPATIBLE TRUE)\n                if(\"${PACKAGE_VERSION}\" VERSION_EQUAL \"${PACKAGE_FIND_VERSION}\")\n                    set(PACKAGE_VERSION_EXACT TRUE)\n                endif()\n            endif()\n            "), null, 2, null);
    }

    @Override
    public void prepareOutputDirectory(@NotNull File output) {
        BuildSystemInterface.DefaultImpls.prepareOutputDirectory(this, output);
    }
}

