/*
 * Decompiled with CFR 0.152.
 */
package com.google.prefab.api;

import com.google.prefab.api.Android;
import com.google.prefab.api.CompatibleLibrary;
import com.google.prefab.api.IncompatibleLibrary;
import com.google.prefab.api.InvalidDirectoryNameException;
import com.google.prefab.api.LibraryReference;
import com.google.prefab.api.LibraryUsabilityResult;
import com.google.prefab.api.MissingArtifactIDException;
import com.google.prefab.api.MissingPlatformIDException;
import com.google.prefab.api.ModuleMetadata;
import com.google.prefab.api.ModuleMetadataV1;
import com.google.prefab.api.NoMatchingLibraryException;
import com.google.prefab.api.Package;
import com.google.prefab.api.PlatformDataInterface;
import com.google.prefab.api.PlatformFactoryInterface;
import com.google.prefab.api.PlatformRegistry;
import com.google.prefab.api.PrebuiltLibrary;
import com.google.prefab.api.SchemaVersion;
import com.google.prefab.api.UnsupportedPlatformException;
import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u000e\u0010!\u001a\u00020\u00152\u0006\u0010\"\u001a\u00020#J\u000e\u0010$\u001a\u00020\n2\u0006\u0010%\u001a\u00020#J\u0014\u0010&\u001a\b\u0012\u0004\u0012\u00020'0\u00142\u0006\u0010%\u001a\u00020#R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\r\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0012R\u0017\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0014\u0010\u0018\u001a\u00020\u0019X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0011\u0010\u001c\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u000fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 \u00a8\u0006("}, d2={"Lcom/google/prefab/api/Module;", "", "path", "Ljava/nio/file/Path;", "pkg", "Lcom/google/prefab/api/Package;", "loadSchemaVersion", "Lcom/google/prefab/api/SchemaVersion;", "(Ljava/nio/file/Path;Lcom/google/prefab/api/Package;Lcom/google/prefab/api/SchemaVersion;)V", "canonicalName", "", "getCanonicalName", "()Ljava/lang/String;", "includePath", "getIncludePath", "()Ljava/nio/file/Path;", "isHeaderOnly", "", "()Z", "libraries", "", "Lcom/google/prefab/api/PrebuiltLibrary;", "getLibraries", "()Ljava/util/List;", "metadata", "Lcom/google/prefab/api/ModuleMetadataV1;", "getMetadata$api", "()Lcom/google/prefab/api/ModuleMetadataV1;", "name", "getName", "getPath", "getPkg", "()Lcom/google/prefab/api/Package;", "getLibraryFor", "platformData", "Lcom/google/prefab/api/PlatformDataInterface;", "libraryNameForPlatform", "platform", "linkLibsForPlatform", "Lcom/google/prefab/api/LibraryReference;", "api"})
public final class Module {
    @NotNull
    private final Path path;
    @NotNull
    private final Package pkg;
    @NotNull
    private final ModuleMetadataV1 metadata;
    @NotNull
    private final String name;
    @NotNull
    private final String canonicalName;
    @NotNull
    private final Path includePath;
    @NotNull
    private final List<PrebuiltLibrary> libraries;
    private final boolean isHeaderOnly;

    /*
     * WARNING - void declaration
     */
    public Module(@NotNull Path path2, @NotNull Package pkg, @NotNull SchemaVersion loadSchemaVersion) {
        List list;
        Intrinsics.checkNotNullParameter(path2, "path");
        Intrinsics.checkNotNullParameter(pkg, "pkg");
        Intrinsics.checkNotNullParameter((Object)loadSchemaVersion, "loadSchemaVersion");
        this.path = path2;
        this.pkg = pkg;
        this.metadata = ModuleMetadata.Companion.loadAndMigrate(loadSchemaVersion, this.path);
        this.name = ((Object)this.path.getFileName()).toString();
        this.canonicalName = "//" + this.pkg.getName() + '/' + this.name;
        Path path3 = this.path.resolve("include");
        Intrinsics.checkNotNullExpressionValue(path3, "path.resolve(\"include\")");
        this.includePath = path3;
        Module module = this;
        File[] fileArray = this.path.resolve("libs").toFile().listFiles();
        if (fileArray == null) {
            list = null;
        } else {
            Collection<PrebuiltLibrary> collection;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            File[] fileArray2 = fileArray;
            Module module2 = module;
            boolean $i$f$map = false;
            void var8_9 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(((void)$this$map$iv).length);
            boolean $i$f$mapTo = false;
            void var11_12 = $this$mapTo$iv$iv;
            int n = ((void)var11_12).length;
            for (int i = 0; i < n; ++i) {
                Object object;
                void directory;
                void item$iv$iv;
                void var15_16 = item$iv$iv = var11_12[i];
                collection = destination$iv$iv;
                boolean bl = false;
                String basename = ((Object)directory.toPath().getFileName()).toString();
                List components = StringsKt.split$default((CharSequence)basename, (String[])(object = new String[]{"."}), false, 2, 2, null);
                if (components.size() != 2) {
                    object = directory.toPath();
                    Intrinsics.checkNotNullExpressionValue(object, "directory.toPath()");
                    throw new InvalidDirectoryNameException(this, (Path)object);
                }
                object = (CharSequence)components.get(0);
                boolean bl2 = false;
                if (object.length() == 0) {
                    object = directory.toPath();
                    Intrinsics.checkNotNullExpressionValue(object, "directory.toPath()");
                    throw new MissingPlatformIDException(this, (Path)object);
                }
                object = (CharSequence)components.get(1);
                bl2 = false;
                if (object.length() == 0) {
                    object = directory.toPath();
                    Intrinsics.checkNotNullExpressionValue(object, "directory.toPath()");
                    throw new MissingArtifactIDException(this, (Path)object);
                }
                Object object2 = object = components;
                boolean bl3 = false;
                String platformName = (String)object2.get(0);
                Object object3 = PlatformRegistry.INSTANCE.find(platformName);
                if (object3 == null) {
                    throw new UnsupportedPlatformException(this, platformName);
                }
                PlatformFactoryInterface platformFactory = object3;
                object3 = directory.toPath();
                Intrinsics.checkNotNullExpressionValue(object3, "directory.toPath()");
                PrebuiltLibrary prebuiltLibrary = platformFactory.prebuiltLibraryFromDirectory((Path)object3, this, loadSchemaVersion);
                collection.add(prebuiltLibrary);
            }
            collection = (List)destination$iv$iv;
            module = module2;
            list = collection;
        }
        path3 = list;
        module.libraries = path3 == null ? CollectionsKt.emptyList() : path3;
        this.isHeaderOnly = this.libraries.isEmpty();
    }

    @NotNull
    public final Path getPath() {
        return this.path;
    }

    @NotNull
    public final Package getPkg() {
        return this.pkg;
    }

    @NotNull
    public final ModuleMetadataV1 getMetadata$api() {
        return this.metadata;
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    @NotNull
    public final String getCanonicalName() {
        return this.canonicalName;
    }

    @NotNull
    public final Path getIncludePath() {
        return this.includePath;
    }

    @NotNull
    public final List<PrebuiltLibrary> getLibraries() {
        return this.libraries;
    }

    public final boolean isHeaderOnly() {
        return this.isHeaderOnly;
    }

    @NotNull
    public final PrebuiltLibrary getLibraryFor(@NotNull PlatformDataInterface platformData) {
        Intrinsics.checkNotNullParameter(platformData, "platformData");
        boolean bl = false;
        List compatible = new ArrayList();
        boolean bl2 = false;
        Map rejections = new LinkedHashMap();
        for (PrebuiltLibrary library : this.libraries) {
            LibraryUsabilityResult result = platformData.checkIfUsable(library);
            if (result instanceof CompatibleLibrary) {
                compatible.add(library);
                continue;
            }
            if (!(result instanceof IncompatibleLibrary)) continue;
            Map map = rejections;
            String string = ((IncompatibleLibrary)result).getReason();
            boolean bl3 = false;
            map.put(library, string);
        }
        if (compatible.isEmpty()) {
            boolean bl4 = false;
            throw new NoMatchingLibraryException(this, MapsKt.toSortedMap(rejections, new Comparator<T>(){

                public final int compare(T a, T b) {
                    boolean bl = false;
                    PrebuiltLibrary it = (PrebuiltLibrary)a;
                    boolean bl2 = false;
                    Comparable comparable = it.getPath().getParent().getFileName();
                    it = (PrebuiltLibrary)b;
                    Comparable comparable2 = comparable;
                    bl2 = false;
                    Comparable comparable3 = it.getPath().getParent().getFileName();
                    return ComparisonsKt.compareValues(comparable2, comparable3);
                }
            }));
        }
        return platformData.findBestMatch(compatible);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<LibraryReference> linkLibsForPlatform(@NotNull PlatformDataInterface platform) {
        Object object;
        LibraryReference libraryReference;
        Collection collection;
        List list;
        List<String> platformSpecificLibs;
        Intrinsics.checkNotNullParameter(platform, "platform");
        PlatformDataInterface platformDataInterface = platform;
        if (!(platformDataInterface instanceof Android)) {
            throw new IllegalArgumentException(Intrinsics.stringPlus("Unrecognized platform: ", platform));
        }
        List<String> list2 = platformSpecificLibs = this.metadata.getAndroid().getExportLibraries();
        if (list2 == null) {
            list = null;
        } else {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = list2;
            boolean $i$f$map2 = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv2 : $this$mapTo$iv$iv) {
                void it;
                String string = (String)item$iv$iv2;
                collection = destination$iv$iv;
                boolean bl = false;
                libraryReference = LibraryReference.Companion.fromString((String)it);
                collection.add(libraryReference);
            }
            list = (List)destination$iv$iv;
        }
        platformDataInterface = list;
        if (platformDataInterface == null) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = this.metadata.getExportLibraries();
            boolean $i$f$map = false;
            Iterable $i$f$map2 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Object item$iv$iv2;
                item$iv$iv2 = (String)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                libraryReference = LibraryReference.Companion.fromString((String)it);
                collection.add(libraryReference);
            }
            object = (List)destination$iv$iv;
        } else {
            object = platformDataInterface;
        }
        return object;
    }

    @NotNull
    public final String libraryNameForPlatform(@NotNull PlatformDataInterface platform) {
        Intrinsics.checkNotNullParameter(platform, "platform");
        Object object = platform;
        if (!(object instanceof Android)) {
            throw new IllegalArgumentException(Intrinsics.stringPlus("Unrecognized platform: ", platform));
        }
        String string = this.metadata.getAndroid().getLibraryName();
        return string == null ? ((object = this.metadata.getLibraryName()) == null ? Intrinsics.stringPlus("lib", this.name) : object) : string;
    }
}

