/*
 * Decompiled with CFR 0.152.
 */
package com.github.ajalt.clikt.output;

import com.github.ajalt.clikt.mpp.MppImplKt;
import com.github.ajalt.clikt.output.TermUi;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u0000\u0016\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\u001a\b\u0010\u0000\u001a\u00020\u0001H\u0000\u001a\u001c\u0010\u0002\u001a\u00020\u00012\u0012\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00050\u0004H\u0000\u001a\u0018\u0010\u0006\u001a\u00020\u00012\u0006\u0010\u0007\u001a\u00020\u00012\u0006\u0010\b\u001a\u00020\u0001H\u0000\u00a8\u0006\t"}, d2={"getWhichCommand", "", "inferEditorPath", "commandExists", "Lkotlin/Function1;", "", "normalizeEditorText", "editor", "text", "clikt"})
public final class EditorKt {
    @NotNull
    public static final String inferEditorPath(@NotNull Function1<? super String, Boolean> commandExists) {
        String[] editors;
        String[] stringArray;
        String[] stringArray2;
        Intrinsics.checkNotNullParameter(commandExists, "commandExists");
        String[] stringArray3 = new String[]{"VISUAL", "EDITOR"};
        String[] stringArray4 = stringArray3;
        int n = stringArray4.length;
        for (int i = 0; i < n; ++i) {
            String key = stringArray4[i];
            String string = MppImplKt.readEnvvar(key);
            if (string == null) continue;
            return string;
        }
        if (TermUi.INSTANCE.isWindows()) {
            stringArray2 = new String[]{"vim", "nano", "notepad"};
            stringArray = stringArray2;
        } else {
            stringArray2 = new String[]{"vim", "nano"};
            stringArray = stringArray2;
        }
        for (String editor : editors = stringArray) {
            if (!commandExists.invoke(editor).booleanValue()) continue;
            return editor;
        }
        return TermUi.INSTANCE.isWindows() ? "notepad" : "vi";
    }

    @NotNull
    public static final String normalizeEditorText(@NotNull String editor, @NotNull String text) {
        String string;
        Intrinsics.checkNotNullParameter(editor, "editor");
        Intrinsics.checkNotNullParameter(text, "text");
        String string2 = editor;
        if (Intrinsics.areEqual(string2, "notepad")) {
            CharSequence charSequence = text;
            Regex regex = new Regex("(?<!\r)\n");
            String string3 = "\r\n";
            boolean bl = false;
            string = regex.replace(charSequence, string3);
        } else {
            string = StringsKt.replace$default(text, "\r\n", "\n", false, 4, null);
        }
        return string;
    }

    @NotNull
    public static final String getWhichCommand() {
        return MppImplKt.isWindowsMpp() ? "where" : "which";
    }
}

