/*
 * Decompiled with CFR 0.152.
 */
package com.google.ortools.init;

import com.google.ortools.init.CppFlags;
import com.google.ortools.init.mainJNI;

public class CppBridge {
    private transient long swigCPtr;
    protected transient boolean swigCMemOwn;

    protected CppBridge(long cPtr, boolean cMemoryOwn) {
        this.swigCMemOwn = cMemoryOwn;
        this.swigCPtr = cPtr;
    }

    protected static long getCPtr(CppBridge obj) {
        return obj == null ? 0L : obj.swigCPtr;
    }

    protected static long swigRelease(CppBridge obj) {
        long ptr = 0L;
        if (obj != null) {
            if (!obj.swigCMemOwn) {
                throw new RuntimeException("Cannot release ownership as memory is not owned");
            }
            ptr = obj.swigCPtr;
            obj.swigCMemOwn = false;
            obj.delete();
        }
        return ptr;
    }

    protected void finalize() {
        this.delete();
    }

    public synchronized void delete() {
        if (this.swigCPtr != 0L) {
            if (this.swigCMemOwn) {
                this.swigCMemOwn = false;
                mainJNI.delete_CppBridge(this.swigCPtr);
            }
            this.swigCPtr = 0L;
        }
    }

    public static void initLogging(String usage) {
        mainJNI.CppBridge_initLogging(usage);
    }

    public static void shutdownLogging() {
        mainJNI.CppBridge_shutdownLogging();
    }

    public static void setFlags(CppFlags flags) {
        mainJNI.CppBridge_setFlags(CppFlags.getCPtr(flags), flags);
    }

    public static boolean logGurobiSharedLibrary(String full_library_path) {
        return mainJNI.CppBridge_logGurobiSharedLibrary(full_library_path);
    }

    public CppBridge() {
        this(mainJNI.new_CppBridge(), true);
    }
}

