/*
 * Decompiled with CFR 0.152.
 */
package com.google.ortools.graph;

import com.google.ortools.graph.mainJNI;

public class MaxFlow {
    private transient long swigCPtr;
    protected transient boolean swigCMemOwn;

    protected MaxFlow(long cPtr, boolean cMemoryOwn) {
        this.swigCMemOwn = cMemoryOwn;
        this.swigCPtr = cPtr;
    }

    protected static long getCPtr(MaxFlow obj) {
        return obj == null ? 0L : obj.swigCPtr;
    }

    protected static long swigRelease(MaxFlow obj) {
        long ptr = 0L;
        if (obj != null) {
            if (!obj.swigCMemOwn) {
                throw new RuntimeException("Cannot release ownership as memory is not owned");
            }
            ptr = obj.swigCPtr;
            obj.swigCMemOwn = false;
            obj.delete();
        }
        return ptr;
    }

    protected void finalize() {
        this.delete();
    }

    public synchronized void delete() {
        if (this.swigCPtr != 0L) {
            if (this.swigCMemOwn) {
                this.swigCMemOwn = false;
                mainJNI.delete_MaxFlow(this.swigCPtr);
            }
            this.swigCPtr = 0L;
        }
    }

    public MaxFlow() {
        this(mainJNI.new_MaxFlow(), true);
    }

    public int addArcWithCapacity(int tail, int head, long capacity) {
        return mainJNI.MaxFlow_addArcWithCapacity(this.swigCPtr, this, tail, head, capacity);
    }

    public int getNumNodes() {
        return mainJNI.MaxFlow_getNumNodes(this.swigCPtr, this);
    }

    public int getNumArcs() {
        return mainJNI.MaxFlow_getNumArcs(this.swigCPtr, this);
    }

    public int getTail(int arc) {
        return mainJNI.MaxFlow_getTail(this.swigCPtr, this, arc);
    }

    public int getHead(int arc) {
        return mainJNI.MaxFlow_getHead(this.swigCPtr, this, arc);
    }

    public long getCapacity(int arc) {
        return mainJNI.MaxFlow_getCapacity(this.swigCPtr, this, arc);
    }

    public Status solve(int source, int sink) {
        return Status.swigToEnum(mainJNI.MaxFlow_solve(this.swigCPtr, this, source, sink));
    }

    public long getOptimalFlow() {
        return mainJNI.MaxFlow_getOptimalFlow(this.swigCPtr, this);
    }

    public long getFlow(int arc) {
        return mainJNI.MaxFlow_getFlow(this.swigCPtr, this, arc);
    }

    public void setArcCapacity(int arc, long capacity) {
        mainJNI.MaxFlow_setArcCapacity(this.swigCPtr, this, arc, capacity);
    }

    public static enum Status {
        OPTIMAL,
        POSSIBLE_OVERFLOW,
        BAD_INPUT,
        BAD_RESULT;

        private final int swigValue;

        public final int swigValue() {
            return this.swigValue;
        }

        public static Status swigToEnum(int swigValue) {
            Status[] swigValues = (Status[])Status.class.getEnumConstants();
            if (swigValue < swigValues.length && swigValue >= 0 && swigValues[swigValue].swigValue == swigValue) {
                return swigValues[swigValue];
            }
            for (Status swigEnum : swigValues) {
                if (swigEnum.swigValue != swigValue) continue;
                return swigEnum;
            }
            throw new IllegalArgumentException("No enum " + Status.class + " with value " + swigValue);
        }

        private Status() {
            this.swigValue = SwigNext.next++;
        }

        private Status(int swigValue) {
            this.swigValue = swigValue;
            SwigNext.next = swigValue + 1;
        }

        private Status(Status swigEnum) {
            this.swigValue = swigEnum.swigValue;
            SwigNext.next = this.swigValue + 1;
        }

        private static class SwigNext {
            private static int next = 0;

            private SwigNext() {
            }
        }
    }
}

