/*
 * Decompiled with CFR 0.152.
 */
package com.google.ortools.sat;

import com.google.ortools.sat.AllDifferentConstraintProto;
import com.google.ortools.sat.AutomatonConstraint;
import com.google.ortools.sat.AutomatonConstraintProto;
import com.google.ortools.sat.BoolArgumentProto;
import com.google.ortools.sat.BoolVar;
import com.google.ortools.sat.CircuitConstraint;
import com.google.ortools.sat.Constraint;
import com.google.ortools.sat.CpModelProto;
import com.google.ortools.sat.CpObjectiveProto;
import com.google.ortools.sat.CpSatHelper;
import com.google.ortools.sat.CumulativeConstraint;
import com.google.ortools.sat.CumulativeConstraintProto;
import com.google.ortools.sat.DecisionStrategyProto;
import com.google.ortools.sat.DoubleLinearExpr;
import com.google.ortools.sat.ElementConstraintProto;
import com.google.ortools.sat.FloatObjectiveProto;
import com.google.ortools.sat.IntVar;
import com.google.ortools.sat.IntervalVar;
import com.google.ortools.sat.InverseConstraintProto;
import com.google.ortools.sat.LinearArgument;
import com.google.ortools.sat.LinearArgumentProto;
import com.google.ortools.sat.LinearConstraintProto;
import com.google.ortools.sat.LinearExpr;
import com.google.ortools.sat.LinearExprBuilder;
import com.google.ortools.sat.LinearExpressionProto;
import com.google.ortools.sat.Literal;
import com.google.ortools.sat.MultipleCircuitConstraint;
import com.google.ortools.sat.NoOverlap2dConstraint;
import com.google.ortools.sat.NoOverlapConstraintProto;
import com.google.ortools.sat.ReservoirConstraint;
import com.google.ortools.sat.ReservoirConstraintProto;
import com.google.ortools.sat.TableConstraint;
import com.google.ortools.sat.TableConstraintProto;
import com.google.ortools.util.Domain;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;

public final class CpModel {
    private final CpModelProto.Builder modelBuilder = CpModelProto.newBuilder();
    private final Map<Long, Integer> constantMap = new LinkedHashMap<Long, Integer>();

    public CpModel getClone() {
        CpModel clone = new CpModel();
        clone.modelBuilder.mergeFrom(this.modelBuilder.build());
        clone.constantMap.clear();
        clone.constantMap.putAll(this.constantMap);
        return clone;
    }

    public IntVar newIntVar(long lb, long ub, String name) {
        return new IntVar(this.modelBuilder, new Domain(lb, ub), name);
    }

    public IntVar newIntVarFromDomain(Domain domain, String name) {
        return new IntVar(this.modelBuilder, domain, name);
    }

    public BoolVar newBoolVar(String name) {
        return new BoolVar(this.modelBuilder, new Domain(0L, 1L), name);
    }

    public IntVar newConstant(long value) {
        if (this.constantMap.containsKey(value)) {
            return new IntVar(this.modelBuilder, this.constantMap.get(value));
        }
        IntVar cste = new IntVar(this.modelBuilder, new Domain(value), "");
        this.constantMap.put(value, cste.getIndex());
        return cste;
    }

    public Literal trueLiteral() {
        if (this.constantMap.containsKey(1L)) {
            return new BoolVar(this.modelBuilder, this.constantMap.get(1L));
        }
        BoolVar cste = new BoolVar(this.modelBuilder, new Domain(1L), "");
        this.constantMap.put(1L, cste.getIndex());
        return cste;
    }

    public Literal falseLiteral() {
        if (this.constantMap.containsKey(0L)) {
            return new BoolVar(this.modelBuilder, this.constantMap.get(0L));
        }
        BoolVar cste = new BoolVar(this.modelBuilder, new Domain(0L), "");
        this.constantMap.put(0L, cste.getIndex());
        return cste;
    }

    public BoolVar getBoolVarFromProtoIndex(int index) {
        return new BoolVar(this.modelBuilder, index);
    }

    public IntVar getIntVarFromProtoIndex(int index) {
        return new IntVar(this.modelBuilder, index);
    }

    public Constraint addBoolOr(Literal[] literals) {
        return this.addBoolOr(Arrays.asList(literals));
    }

    public Constraint addBoolOr(Iterable<Literal> literals) {
        Constraint ct = new Constraint(this.modelBuilder);
        BoolArgumentProto.Builder boolOr = ct.getBuilder().getBoolOrBuilder();
        for (Literal lit : literals) {
            boolOr.addLiterals(lit.getIndex());
        }
        return ct;
    }

    public Constraint addAtLeastOne(Literal[] literals) {
        return this.addBoolOr(Arrays.asList(literals));
    }

    public Constraint addAtLeastOne(Iterable<Literal> literals) {
        return this.addBoolOr(literals);
    }

    public Constraint addAtMostOne(Literal[] literals) {
        return this.addAtMostOne(Arrays.asList(literals));
    }

    public Constraint addAtMostOne(Iterable<Literal> literals) {
        Constraint ct = new Constraint(this.modelBuilder);
        BoolArgumentProto.Builder atMostOne = ct.getBuilder().getAtMostOneBuilder();
        for (Literal lit : literals) {
            atMostOne.addLiterals(lit.getIndex());
        }
        return ct;
    }

    public Constraint addExactlyOne(Literal[] literals) {
        return this.addExactlyOne(Arrays.asList(literals));
    }

    public Constraint addExactlyOne(Iterable<Literal> literals) {
        Constraint ct = new Constraint(this.modelBuilder);
        BoolArgumentProto.Builder exactlyOne = ct.getBuilder().getExactlyOneBuilder();
        for (Literal lit : literals) {
            exactlyOne.addLiterals(lit.getIndex());
        }
        return ct;
    }

    public Constraint addBoolAnd(Literal[] literals) {
        return this.addBoolAnd(Arrays.asList(literals));
    }

    public Constraint addBoolAnd(Iterable<Literal> literals) {
        Constraint ct = new Constraint(this.modelBuilder);
        BoolArgumentProto.Builder boolAnd = ct.getBuilder().getBoolAndBuilder();
        for (Literal lit : literals) {
            boolAnd.addLiterals(lit.getIndex());
        }
        return ct;
    }

    public Constraint addBoolXor(Literal[] literals) {
        return this.addBoolXor(Arrays.asList(literals));
    }

    public Constraint addBoolXor(Iterable<Literal> literals) {
        Constraint ct = new Constraint(this.modelBuilder);
        BoolArgumentProto.Builder boolXOr = ct.getBuilder().getBoolXorBuilder();
        for (Literal lit : literals) {
            boolXOr.addLiterals(lit.getIndex());
        }
        return ct;
    }

    public Constraint addImplication(Literal a, Literal b) {
        return this.addBoolOr(new Literal[]{a.not(), b});
    }

    public Constraint addLinearExpressionInDomain(LinearArgument expr, Domain domain) {
        Constraint ct = new Constraint(this.modelBuilder);
        LinearConstraintProto.Builder lin = ct.getBuilder().getLinearBuilder();
        LinearExpr e = expr.build();
        for (int i = 0; i < e.numElements(); ++i) {
            lin.addVars(e.getVariableIndex(i)).addCoeffs(e.getCoefficient(i));
        }
        long offset = e.getOffset();
        for (long b : domain.flattenedIntervals()) {
            if (b == Long.MIN_VALUE || b == Long.MAX_VALUE) {
                lin.addDomain(b);
                continue;
            }
            lin.addDomain(b - offset);
        }
        return ct;
    }

    public Constraint addLinearConstraint(LinearArgument expr, long lb, long ub) {
        return this.addLinearExpressionInDomain(expr, new Domain(lb, ub));
    }

    public Constraint addEquality(LinearArgument expr, long value) {
        return this.addLinearExpressionInDomain(expr, new Domain(value));
    }

    public Constraint addEquality(LinearArgument left, LinearArgument right) {
        LinearExprBuilder difference = LinearExpr.newBuilder();
        difference.addTerm(left, 1L);
        difference.addTerm(right, -1L);
        return this.addLinearExpressionInDomain(difference, new Domain(0L));
    }

    public Constraint addLessOrEqual(LinearArgument expr, long value) {
        return this.addLinearExpressionInDomain(expr, new Domain(Long.MIN_VALUE, value));
    }

    public Constraint addLessOrEqual(LinearArgument left, LinearArgument right) {
        LinearExprBuilder difference = LinearExpr.newBuilder();
        difference.addTerm(left, 1L);
        difference.addTerm(right, -1L);
        return this.addLinearExpressionInDomain(difference, new Domain(Long.MIN_VALUE, 0L));
    }

    public Constraint addLessThan(LinearArgument expr, long value) {
        return this.addLinearExpressionInDomain(expr, new Domain(Long.MIN_VALUE, value - 1L));
    }

    public Constraint addLessThan(LinearArgument left, LinearArgument right) {
        LinearExprBuilder difference = LinearExpr.newBuilder();
        difference.addTerm(left, 1L);
        difference.addTerm(right, -1L);
        return this.addLinearExpressionInDomain(difference, new Domain(Long.MIN_VALUE, -1L));
    }

    public Constraint addGreaterOrEqual(LinearArgument expr, long value) {
        return this.addLinearExpressionInDomain(expr, new Domain(value, Long.MAX_VALUE));
    }

    public Constraint addGreaterOrEqual(LinearArgument left, LinearArgument right) {
        LinearExprBuilder difference = LinearExpr.newBuilder();
        difference.addTerm(left, 1L);
        difference.addTerm(right, -1L);
        return this.addLinearExpressionInDomain(difference, new Domain(0L, Long.MAX_VALUE));
    }

    public Constraint addGreaterThan(LinearArgument expr, long value) {
        return this.addLinearExpressionInDomain(expr, new Domain(value + 1L, Long.MAX_VALUE));
    }

    public Constraint addGreaterThan(LinearArgument left, LinearArgument right) {
        LinearExprBuilder difference = LinearExpr.newBuilder();
        difference.addTerm(left, 1L);
        difference.addTerm(right, -1L);
        return this.addLinearExpressionInDomain(difference, new Domain(1L, Long.MAX_VALUE));
    }

    public Constraint addDifferent(LinearArgument expr, long value) {
        return this.addLinearExpressionInDomain(expr, Domain.fromFlatIntervals(new long[]{Long.MIN_VALUE, value - 1L, value + 1L, Long.MAX_VALUE}));
    }

    public Constraint addDifferent(LinearArgument left, LinearArgument right) {
        LinearExprBuilder difference = LinearExpr.newBuilder();
        difference.addTerm(left, 1L);
        difference.addTerm(right, -1L);
        return this.addLinearExpressionInDomain(difference, Domain.fromFlatIntervals(new long[]{Long.MIN_VALUE, -1L, 1L, Long.MAX_VALUE}));
    }

    public Constraint addAllDifferent(LinearArgument[] expressions) {
        return this.addAllDifferent(Arrays.asList(expressions));
    }

    public Constraint addAllDifferent(Iterable<? extends LinearArgument> expressions) {
        Constraint ct = new Constraint(this.modelBuilder);
        AllDifferentConstraintProto.Builder allDiff = ct.getBuilder().getAllDiffBuilder();
        for (LinearArgument linearArgument : expressions) {
            allDiff.addExprs(this.getLinearExpressionProtoBuilderFromLinearArgument(linearArgument, false));
        }
        return ct;
    }

    public Constraint addElement(IntVar index, IntVar[] variables, IntVar target) {
        Constraint ct = new Constraint(this.modelBuilder);
        ElementConstraintProto.Builder element = ct.getBuilder().getElementBuilder().setIndex(index.getIndex());
        for (IntVar var : variables) {
            element.addVars(var.getIndex());
        }
        element.setTarget(target.getIndex());
        return ct;
    }

    public Constraint addElement(IntVar index, long[] values, IntVar target) {
        Constraint ct = new Constraint(this.modelBuilder);
        ElementConstraintProto.Builder element = ct.getBuilder().getElementBuilder().setIndex(index.getIndex());
        for (long v : values) {
            element.addVars(this.newConstant(v).getIndex());
        }
        element.setTarget(target.getIndex());
        return ct;
    }

    public Constraint addElement(IntVar index, int[] values, IntVar target) {
        Constraint ct = new Constraint(this.modelBuilder);
        ElementConstraintProto.Builder element = ct.getBuilder().getElementBuilder().setIndex(index.getIndex());
        int[] nArray = values;
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            long v = nArray[i];
            element.addVars(this.newConstant(v).getIndex());
        }
        element.setTarget(target.getIndex());
        return ct;
    }

    public CircuitConstraint addCircuit() {
        return new CircuitConstraint(this.modelBuilder);
    }

    public MultipleCircuitConstraint addMultipleCircuit() {
        return new MultipleCircuitConstraint(this.modelBuilder);
    }

    public TableConstraint addAllowedAssignments(IntVar[] variables) {
        return this.addAllowedAssignments(Arrays.asList(variables));
    }

    public TableConstraint addAllowedAssignments(Iterable<IntVar> variables) {
        TableConstraint ct = new TableConstraint(this.modelBuilder);
        TableConstraintProto.Builder table = ct.getBuilder().getTableBuilder();
        for (IntVar var : variables) {
            table.addVars(var.getIndex());
        }
        table.setNegated(false);
        return ct;
    }

    public TableConstraint addForbiddenAssignments(IntVar[] variables) {
        return this.addForbiddenAssignments(Arrays.asList(variables));
    }

    public TableConstraint addForbiddenAssignments(Iterable<IntVar> variables) {
        TableConstraint ct = new TableConstraint(this.modelBuilder);
        TableConstraintProto.Builder table = ct.getBuilder().getTableBuilder();
        for (IntVar var : variables) {
            table.addVars(var.getIndex());
        }
        table.setNegated(true);
        return ct;
    }

    public AutomatonConstraint addAutomaton(IntVar[] transitionVariables, long startingState, long[] finalStates) {
        AutomatonConstraint ct = new AutomatonConstraint(this.modelBuilder);
        AutomatonConstraintProto.Builder automaton = ct.getBuilder().getAutomatonBuilder();
        for (IntVar var : transitionVariables) {
            automaton.addVars(var.getIndex());
        }
        automaton.setStartingState(startingState);
        for (long c : finalStates) {
            automaton.addFinalStates(c);
        }
        return ct;
    }

    public Constraint addInverse(IntVar[] variables, IntVar[] inverseVariables) {
        if (variables.length != inverseVariables.length) {
            throw new MismatchedArrayLengths("CpModel.addInverse", "variables", "inverseVariables");
        }
        Constraint ct = new Constraint(this.modelBuilder);
        InverseConstraintProto.Builder inverse = ct.getBuilder().getInverseBuilder();
        for (IntVar var : variables) {
            inverse.addFDirect(var.getIndex());
        }
        for (IntVar var : inverseVariables) {
            inverse.addFInverse(var.getIndex());
        }
        return ct;
    }

    public ReservoirConstraint addReservoirConstraint(long minLevel, long maxLevel) {
        if (minLevel > 0L) {
            throw new IllegalArgumentException("CpModel.addReservoirConstraint: minLevel must be <= 0");
        }
        if (maxLevel < 0L) {
            throw new IllegalArgumentException("CpModel.addReservoirConstraint: maxLevel must be >= 0");
        }
        ReservoirConstraint ct = new ReservoirConstraint(this);
        ReservoirConstraintProto.Builder reservoir = ct.getBuilder().getReservoirBuilder();
        reservoir.setMinLevel(minLevel).setMaxLevel(maxLevel);
        return ct;
    }

    public void addMapDomain(IntVar var, Literal[] booleans, long offset) {
        for (int i = 0; i < booleans.length; ++i) {
            this.addEquality((LinearArgument)var, offset + (long)i).onlyEnforceIf(booleans[i]);
            this.addDifferent((LinearArgument)var, offset + (long)i).onlyEnforceIf(booleans[i].not());
        }
    }

    public Constraint addMinEquality(LinearArgument target, LinearArgument[] exprs) {
        Constraint ct = new Constraint(this.modelBuilder);
        LinearArgumentProto.Builder linMax = ct.getBuilder().getLinMaxBuilder();
        linMax.setTarget(this.getLinearExpressionProtoBuilderFromLinearArgument(target, true));
        for (LinearArgument expr : exprs) {
            linMax.addExprs(this.getLinearExpressionProtoBuilderFromLinearArgument(expr, true));
        }
        return ct;
    }

    public Constraint addMinEquality(LinearArgument target, Iterable<? extends LinearArgument> exprs) {
        Constraint ct = new Constraint(this.modelBuilder);
        LinearArgumentProto.Builder linMax = ct.getBuilder().getLinMaxBuilder();
        linMax.setTarget(this.getLinearExpressionProtoBuilderFromLinearArgument(target, true));
        for (LinearArgument linearArgument : exprs) {
            linMax.addExprs(this.getLinearExpressionProtoBuilderFromLinearArgument(linearArgument, true));
        }
        return ct;
    }

    public Constraint addMaxEquality(LinearArgument target, LinearArgument[] exprs) {
        Constraint ct = new Constraint(this.modelBuilder);
        LinearArgumentProto.Builder linMax = ct.getBuilder().getLinMaxBuilder();
        linMax.setTarget(this.getLinearExpressionProtoBuilderFromLinearArgument(target, false));
        for (LinearArgument expr : exprs) {
            linMax.addExprs(this.getLinearExpressionProtoBuilderFromLinearArgument(expr, false));
        }
        return ct;
    }

    public Constraint addMaxEquality(LinearArgument target, Iterable<? extends LinearArgument> exprs) {
        Constraint ct = new Constraint(this.modelBuilder);
        LinearArgumentProto.Builder linMax = ct.getBuilder().getLinMaxBuilder();
        linMax.setTarget(this.getLinearExpressionProtoBuilderFromLinearArgument(target, false));
        for (LinearArgument linearArgument : exprs) {
            linMax.addExprs(this.getLinearExpressionProtoBuilderFromLinearArgument(linearArgument, false));
        }
        return ct;
    }

    public Constraint addDivisionEquality(LinearArgument target, LinearArgument num, LinearArgument denom) {
        Constraint ct = new Constraint(this.modelBuilder);
        ct.getBuilder().getIntDivBuilder().setTarget(this.getLinearExpressionProtoBuilderFromLinearArgument(target, false)).addExprs(this.getLinearExpressionProtoBuilderFromLinearArgument(num, false)).addExprs(this.getLinearExpressionProtoBuilderFromLinearArgument(denom, false));
        return ct;
    }

    public Constraint addAbsEquality(LinearArgument target, LinearArgument expr) {
        Constraint ct = new Constraint(this.modelBuilder);
        LinearArgumentProto.Builder linMax = ct.getBuilder().getLinMaxBuilder();
        linMax.setTarget(this.getLinearExpressionProtoBuilderFromLinearArgument(target, false));
        linMax.addExprs(this.getLinearExpressionProtoBuilderFromLinearArgument(expr, false));
        linMax.addExprs(this.getLinearExpressionProtoBuilderFromLinearArgument(expr, true));
        return ct;
    }

    public Constraint addModuloEquality(LinearArgument target, LinearArgument var, LinearArgument mod) {
        Constraint ct = new Constraint(this.modelBuilder);
        ct.getBuilder().getIntModBuilder().setTarget(this.getLinearExpressionProtoBuilderFromLinearArgument(target, false)).addExprs(this.getLinearExpressionProtoBuilderFromLinearArgument(var, false)).addExprs(this.getLinearExpressionProtoBuilderFromLinearArgument(mod, false));
        return ct;
    }

    public Constraint addModuloEquality(LinearArgument target, LinearArgument var, long mod) {
        Constraint ct = new Constraint(this.modelBuilder);
        ct.getBuilder().getIntModBuilder().setTarget(this.getLinearExpressionProtoBuilderFromLinearArgument(target, false)).addExprs(this.getLinearExpressionProtoBuilderFromLinearArgument(var, false)).addExprs(this.getLinearExpressionProtoBuilderFromLong(mod));
        return ct;
    }

    public Constraint addMultiplicationEquality(LinearArgument target, LinearArgument[] exprs) {
        Constraint ct = new Constraint(this.modelBuilder);
        LinearArgumentProto.Builder intProd = ct.getBuilder().getIntProdBuilder();
        intProd.setTarget(this.getLinearExpressionProtoBuilderFromLinearArgument(target, false));
        for (LinearArgument expr : exprs) {
            intProd.addExprs(this.getLinearExpressionProtoBuilderFromLinearArgument(expr, false));
        }
        return ct;
    }

    public Constraint addMultiplicationEquality(LinearArgument target, LinearArgument left, LinearArgument right) {
        Constraint ct = new Constraint(this.modelBuilder);
        LinearArgumentProto.Builder intProd = ct.getBuilder().getIntProdBuilder();
        intProd.setTarget(this.getLinearExpressionProtoBuilderFromLinearArgument(target, false));
        intProd.addExprs(this.getLinearExpressionProtoBuilderFromLinearArgument(left, false));
        intProd.addExprs(this.getLinearExpressionProtoBuilderFromLinearArgument(right, false));
        return ct;
    }

    public IntervalVar newIntervalVar(LinearArgument start, LinearArgument size, LinearArgument end, String name) {
        this.addEquality((LinearArgument)LinearExpr.newBuilder().add(start).add(size), end);
        return new IntervalVar(this.modelBuilder, this.getLinearExpressionProtoBuilderFromLinearArgument(start, false), this.getLinearExpressionProtoBuilderFromLinearArgument(size, false), this.getLinearExpressionProtoBuilderFromLinearArgument(end, false), name);
    }

    public IntervalVar newFixedSizeIntervalVar(LinearArgument start, long size, String name) {
        return new IntervalVar(this.modelBuilder, this.getLinearExpressionProtoBuilderFromLinearArgument(start, false), this.getLinearExpressionProtoBuilderFromLong(size), this.getLinearExpressionProtoBuilderFromLinearArgument(LinearExpr.newBuilder().add(start).add(size), false), name);
    }

    public IntervalVar newFixedInterval(long start, long size, String name) {
        return new IntervalVar(this.modelBuilder, this.getLinearExpressionProtoBuilderFromLong(start), this.getLinearExpressionProtoBuilderFromLong(size), this.getLinearExpressionProtoBuilderFromLong(start + size), name);
    }

    public IntervalVar newOptionalIntervalVar(LinearArgument start, LinearArgument size, LinearArgument end, Literal isPresent, String name) {
        this.addEquality((LinearArgument)LinearExpr.newBuilder().add(start).add(size), end).onlyEnforceIf(isPresent);
        return new IntervalVar(this.modelBuilder, this.getLinearExpressionProtoBuilderFromLinearArgument(start, false), this.getLinearExpressionProtoBuilderFromLinearArgument(size, false), this.getLinearExpressionProtoBuilderFromLinearArgument(end, false), isPresent.getIndex(), name);
    }

    public IntervalVar newOptionalFixedSizeIntervalVar(LinearArgument start, long size, Literal isPresent, String name) {
        return new IntervalVar(this.modelBuilder, this.getLinearExpressionProtoBuilderFromLinearArgument(start, false), this.getLinearExpressionProtoBuilderFromLong(size), this.getLinearExpressionProtoBuilderFromLinearArgument(LinearExpr.newBuilder().add(start).add(size), false), isPresent.getIndex(), name);
    }

    public IntervalVar newOptionalFixedInterval(long start, long size, Literal isPresent, String name) {
        return new IntervalVar(this.modelBuilder, this.getLinearExpressionProtoBuilderFromLong(start), this.getLinearExpressionProtoBuilderFromLong(size), this.getLinearExpressionProtoBuilderFromLong(start + size), isPresent.getIndex(), name);
    }

    public Constraint addNoOverlap(IntervalVar[] intervalVars) {
        return this.addNoOverlap(Arrays.asList(intervalVars));
    }

    public Constraint addNoOverlap(Iterable<IntervalVar> intervalVars) {
        Constraint ct = new Constraint(this.modelBuilder);
        NoOverlapConstraintProto.Builder noOverlap = ct.getBuilder().getNoOverlapBuilder();
        for (IntervalVar var : intervalVars) {
            noOverlap.addIntervals(var.getIndex());
        }
        return ct;
    }

    public NoOverlap2dConstraint addNoOverlap2D() {
        return new NoOverlap2dConstraint(this.modelBuilder);
    }

    public CumulativeConstraint addCumulative(LinearArgument capacity) {
        CumulativeConstraint ct = new CumulativeConstraint(this);
        CumulativeConstraintProto.Builder cumul = ct.getBuilder().getCumulativeBuilder();
        cumul.setCapacity(this.getLinearExpressionProtoBuilderFromLinearArgument(capacity, false));
        return ct;
    }

    public CumulativeConstraint addCumulative(long capacity) {
        CumulativeConstraint ct = new CumulativeConstraint(this);
        CumulativeConstraintProto.Builder cumul = ct.getBuilder().getCumulativeBuilder();
        cumul.setCapacity(this.getLinearExpressionProtoBuilderFromLong(capacity));
        return ct;
    }

    public void addHint(IntVar var, long value) {
        this.modelBuilder.getSolutionHintBuilder().addVars(var.getIndex());
        this.modelBuilder.getSolutionHintBuilder().addValues(value);
    }

    public void clearHints() {
        this.modelBuilder.clearSolutionHint();
    }

    public void addAssumption(Literal lit) {
        this.modelBuilder.addAssumptions(lit.getIndex());
    }

    public void addAssumptions(Literal[] literals) {
        for (Literal lit : literals) {
            this.addAssumption(lit);
        }
    }

    public void clearAssumptions() {
        this.modelBuilder.clearAssumptions();
    }

    public void minimize(LinearArgument expr) {
        this.clearObjective();
        CpObjectiveProto.Builder obj = this.modelBuilder.getObjectiveBuilder();
        LinearExpr e = expr.build();
        for (int i = 0; i < e.numElements(); ++i) {
            obj.addVars(e.getVariableIndex(i)).addCoeffs(e.getCoefficient(i));
        }
        obj.setOffset(e.getOffset());
    }

    public void minimize(DoubleLinearExpr expr) {
        this.clearObjective();
        FloatObjectiveProto.Builder obj = this.modelBuilder.getFloatingPointObjectiveBuilder();
        for (int i = 0; i < expr.numElements(); ++i) {
            obj.addVars(expr.getVariableIndex(i)).addCoeffs(expr.getCoefficient(i));
        }
        obj.setOffset(expr.getOffset()).setMaximize(false);
    }

    public void maximize(LinearArgument expr) {
        this.clearObjective();
        CpObjectiveProto.Builder obj = this.modelBuilder.getObjectiveBuilder();
        LinearExpr e = expr.build();
        for (int i = 0; i < e.numElements(); ++i) {
            obj.addVars(e.getVariableIndex(i)).addCoeffs(-e.getCoefficient(i));
        }
        obj.setOffset(-e.getOffset());
        obj.setScalingFactor(-1.0);
    }

    public void maximize(DoubleLinearExpr expr) {
        this.clearObjective();
        FloatObjectiveProto.Builder obj = this.modelBuilder.getFloatingPointObjectiveBuilder();
        for (int i = 0; i < expr.numElements(); ++i) {
            obj.addVars(expr.getVariableIndex(i)).addCoeffs(expr.getCoefficient(i));
        }
        obj.setOffset(expr.getOffset()).setMaximize(true);
    }

    public void clearObjective() {
        this.modelBuilder.clearObjective();
        this.modelBuilder.clearFloatingPointObjective();
    }

    public boolean hasObjective() {
        return this.modelBuilder.hasObjective() || this.modelBuilder.hasFloatingPointObjective();
    }

    public void addDecisionStrategy(IntVar[] variables, DecisionStrategyProto.VariableSelectionStrategy varStr, DecisionStrategyProto.DomainReductionStrategy domStr) {
        DecisionStrategyProto.Builder ds = this.modelBuilder.addSearchStrategyBuilder();
        for (IntVar var : variables) {
            ds.addVariables(var.getIndex());
        }
        ds.setVariableSelectionStrategy(varStr).setDomainReductionStrategy(domStr);
    }

    public String modelStats() {
        return CpSatHelper.modelStats(this.model());
    }

    public String validate() {
        return CpSatHelper.validateModel(this.model());
    }

    public Boolean exportToFile(String file) {
        return CpSatHelper.writeModelToFile(this.model(), file);
    }

    LinearExpressionProto.Builder getLinearExpressionProtoBuilderFromLinearArgument(LinearArgument arg, boolean negate) {
        LinearExpressionProto.Builder builder = LinearExpressionProto.newBuilder();
        LinearExpr expr = arg.build();
        int numVariables = expr.numElements();
        long mult = negate ? -1L : 1L;
        for (int i = 0; i < numVariables; ++i) {
            builder.addVars(expr.getVariableIndex(i));
            builder.addCoeffs(expr.getCoefficient(i) * mult);
        }
        builder.setOffset(expr.getOffset() * mult);
        return builder;
    }

    LinearExpressionProto.Builder getLinearExpressionProtoBuilderFromLong(long value) {
        LinearExpressionProto.Builder builder = LinearExpressionProto.newBuilder();
        builder.setOffset(value);
        return builder;
    }

    public CpModelProto model() {
        return this.modelBuilder.build();
    }

    public int negated(int index) {
        return -index - 1;
    }

    public CpModelProto.Builder getBuilder() {
        return this.modelBuilder;
    }

    public static class WrongLength
    extends CpModelException {
        public WrongLength(String methodName, String msg) {
            super(methodName, msg);
        }
    }

    public static class MismatchedArrayLengths
    extends CpModelException {
        public MismatchedArrayLengths(String methodName, String array1Name, String array2Name) {
            super(methodName, array1Name + " and " + array2Name + " have mismatched lengths");
        }
    }

    static class CpModelException
    extends RuntimeException {
        public CpModelException(String methodName, String msg) {
            super(methodName + ": " + msg);
        }
    }
}

