/*
 * Decompiled with CFR 0.152.
 */
package com.google.ortools.sat;

import com.google.ortools.sat.CpModelProto;
import com.google.ortools.sat.IntVar;
import com.google.ortools.sat.Literal;
import com.google.ortools.sat.NotBoolVar;
import com.google.ortools.util.Domain;

public final class BoolVar
extends IntVar
implements Literal {
    private NotBoolVar negation = null;

    BoolVar(CpModelProto.Builder builder, Domain domain, String name) {
        super(builder, domain, name);
    }

    BoolVar(CpModelProto.Builder builder, int index) {
        super(builder, index);
    }

    @Override
    public Literal not() {
        if (this.negation == null) {
            this.negation = new NotBoolVar(this);
        }
        return this.negation;
    }

    @Override
    public String toString() {
        if (this.varBuilder.getName().isEmpty()) {
            if (this.varBuilder.getDomainCount() == 2 && this.varBuilder.getDomain(0) == this.varBuilder.getDomain(1)) {
                if (this.varBuilder.getDomain(0) == 0L) {
                    return "false";
                }
                return "true";
            }
            return String.format("boolvar_%d(%s)", this.getIndex(), this.displayBounds());
        }
        if (this.varBuilder.getDomainCount() == 2 && this.varBuilder.getDomain(0) == this.varBuilder.getDomain(1)) {
            if (this.varBuilder.getDomain(0) == 0L) {
                return String.format("%s(false)", this.varBuilder.getName());
            }
            return String.format("%s(true)", this.varBuilder.getName());
        }
        return String.format("%s(%s)", this.getName(), this.displayBounds());
    }
}

