/*
 * Decompiled with CFR 0.152.
 */
package com.google.ortools.modelbuilder;

import com.google.ortools.modelbuilder.AffineExpression;
import com.google.ortools.modelbuilder.LinearArgument;
import com.google.ortools.modelbuilder.LinearExpr;
import com.google.ortools.modelbuilder.ModelBuilderHelper;

public class Variable
implements LinearArgument {
    protected final ModelBuilderHelper helper;
    protected final int index;

    Variable(ModelBuilderHelper helper, double lb, double ub, boolean isIntegral, String name) {
        this.helper = helper;
        this.index = helper.addVar();
        this.helper.setVarName(this.index, name);
        this.helper.setVarIntegrality(this.index, isIntegral);
        this.helper.setVarLowerBound(this.index, lb);
        this.helper.setVarUpperBound(this.index, ub);
    }

    Variable(ModelBuilderHelper helper, int index) {
        this.helper = helper;
        this.index = index;
    }

    public int getIndex() {
        return this.index;
    }

    @Override
    public LinearExpr build() {
        return new AffineExpression(this.index, 1.0, 0.0);
    }

    public double getLowerBound() {
        return this.helper.getVarLowerBound(this.index);
    }

    public void setLowerBound(double lowerBound) {
        this.helper.setVarLowerBound(this.index, lowerBound);
    }

    public double getUpperBound() {
        return this.helper.getVarUpperBound(this.index);
    }

    public void setUpperBound(double upperBound) {
        this.helper.setVarUpperBound(this.index, upperBound);
    }

    public boolean getIntegrality() {
        return this.helper.getVarIntegrality(this.index);
    }

    public void setIntegrality(boolean isIntegral) {
        this.helper.setVarIntegrality(this.index, isIntegral);
    }

    public double getObjectiveCoefficient() {
        return this.helper.getVarObjectiveCoefficient(this.index);
    }

    public void setObjectiveCoefficient(double objectiveCoefficient) {
        this.helper.setVarObjectiveCoefficient(this.index, objectiveCoefficient);
    }

    public String getName() {
        return this.helper.getVarName(this.index);
    }

    public void setName(String name) {
        this.helper.setVarName(this.index, name);
    }

    public String toString() {
        if (this.getName().isEmpty()) {
            if (this.getLowerBound() == this.getUpperBound()) {
                return String.format("%f", this.getLowerBound());
            }
            return String.format("var_%d(%f, %f)", this.getIndex(), this.getLowerBound(), this.getUpperBound());
        }
        return String.format("%s(%f, %f)", this.getName(), this.getLowerBound(), this.getUpperBound());
    }
}

