/*
 * Decompiled with CFR 0.152.
 */
package com.google.ortools.constraintsolver;

import com.google.ortools.constraintsolver.Assignment;
import com.google.ortools.constraintsolver.IntVar;
import com.google.ortools.constraintsolver.ModelVisitor;
import com.google.ortools.constraintsolver.SWIGTYPE_p_std__vectorT_bool_t;
import com.google.ortools.constraintsolver.SearchMonitor;
import com.google.ortools.constraintsolver.Solver;
import com.google.ortools.constraintsolver.mainJNI;

public class ObjectiveMonitor
extends SearchMonitor {
    private transient long swigCPtr;

    protected ObjectiveMonitor(long cPtr, boolean cMemoryOwn) {
        super(mainJNI.ObjectiveMonitor_SWIGUpcast(cPtr), cMemoryOwn);
        this.swigCPtr = cPtr;
    }

    protected static long getCPtr(ObjectiveMonitor obj) {
        return obj == null ? 0L : obj.swigCPtr;
    }

    protected static long swigRelease(ObjectiveMonitor obj) {
        long ptr = 0L;
        if (obj != null) {
            if (!obj.swigCMemOwn) {
                throw new RuntimeException("Cannot release ownership as memory is not owned");
            }
            ptr = obj.swigCPtr;
            obj.swigCMemOwn = false;
            obj.delete();
        }
        return ptr;
    }

    @Override
    protected void finalize() {
        this.delete();
    }

    @Override
    public synchronized void delete() {
        if (this.swigCPtr != 0L) {
            if (this.swigCMemOwn) {
                this.swigCMemOwn = false;
                mainJNI.delete_ObjectiveMonitor(this.swigCPtr);
            }
            this.swigCPtr = 0L;
        }
        super.delete();
    }

    public ObjectiveMonitor(Solver solver, SWIGTYPE_p_std__vectorT_bool_t maximize, IntVar[] vars, long[] steps) {
        this(mainJNI.new_ObjectiveMonitor(Solver.getCPtr(solver), solver, SWIGTYPE_p_std__vectorT_bool_t.getCPtr(maximize), vars, steps), true);
    }

    public IntVar ObjectiveVar(int index) {
        long cPtr = mainJNI.ObjectiveMonitor_ObjectiveVar(this.swigCPtr, this, index);
        return cPtr == 0L ? null : new IntVar(cPtr, false);
    }

    public IntVar MinimizationVar(int index) {
        long cPtr = mainJNI.ObjectiveMonitor_MinimizationVar(this.swigCPtr, this, index);
        return cPtr == 0L ? null : new IntVar(cPtr, false);
    }

    public long Step(int index) {
        return mainJNI.ObjectiveMonitor_Step(this.swigCPtr, this, index);
    }

    public boolean Maximize(int index) {
        return mainJNI.ObjectiveMonitor_Maximize(this.swigCPtr, this, index);
    }

    public long BestValue(int index) {
        return mainJNI.ObjectiveMonitor_BestValue(this.swigCPtr, this, index);
    }

    public int Size() {
        return mainJNI.ObjectiveMonitor_Size(this.swigCPtr, this);
    }

    @Override
    public void enterSearch() {
        mainJNI.ObjectiveMonitor_enterSearch(this.swigCPtr, this);
    }

    @Override
    public boolean atSolution() {
        return mainJNI.ObjectiveMonitor_atSolution(this.swigCPtr, this);
    }

    @Override
    public boolean acceptDelta(Assignment delta, Assignment deltadelta) {
        return mainJNI.ObjectiveMonitor_acceptDelta(this.swigCPtr, this, Assignment.getCPtr(delta), delta, Assignment.getCPtr(deltadelta), deltadelta);
    }

    @Override
    public void accept(ModelVisitor visitor) {
        mainJNI.ObjectiveMonitor_accept(this.swigCPtr, this, ModelVisitor.getCPtr(visitor), visitor);
    }
}

