/*
 * Decompiled with CFR 0.152.
 */
package com.google.ortools.sat;

import com.google.ortools.sat.ConstraintProto;
import com.google.ortools.sat.CpModelProto;
import com.google.ortools.sat.Literal;

public class Constraint {
    private final int constraintIndex;
    private final ConstraintProto.Builder constraintBuilder;

    public Constraint(CpModelProto.Builder builder) {
        this.constraintIndex = builder.getConstraintsCount();
        this.constraintBuilder = builder.addConstraintsBuilder();
    }

    public void onlyEnforceIf(Literal lit) {
        this.constraintBuilder.addEnforcementLiteral(lit.getIndex());
    }

    public void onlyEnforceIf(Literal[] lits) {
        for (Literal lit : lits) {
            this.constraintBuilder.addEnforcementLiteral(lit.getIndex());
        }
    }

    public int getIndex() {
        return this.constraintIndex;
    }

    public ConstraintProto.Builder getBuilder() {
        return this.constraintBuilder;
    }
}

