/*
 * Decompiled with CFR 0.152.
 */
package com.google.ortools.linearsolver;

import com.google.ortools.linearsolver.MPSolver;
import com.google.ortools.linearsolver.MPVariable;
import com.google.ortools.linearsolver.mainJNI;

public class MPConstraint {
    private transient long swigCPtr;
    protected transient boolean swigCMemOwn;

    protected MPConstraint(long cPtr, boolean cMemoryOwn) {
        this.swigCMemOwn = cMemoryOwn;
        this.swigCPtr = cPtr;
    }

    protected static long getCPtr(MPConstraint obj) {
        return obj == null ? 0L : obj.swigCPtr;
    }

    protected static long swigRelease(MPConstraint obj) {
        long ptr = 0L;
        if (obj != null) {
            if (!obj.swigCMemOwn) {
                throw new RuntimeException("Cannot release ownership as memory is not owned");
            }
            ptr = obj.swigCPtr;
            obj.swigCMemOwn = false;
            obj.delete();
        }
        return ptr;
    }

    protected void finalize() {
        this.delete();
    }

    public synchronized void delete() {
        if (this.swigCPtr != 0L) {
            if (this.swigCMemOwn) {
                this.swigCMemOwn = false;
                mainJNI.delete_MPConstraint(this.swigCPtr);
            }
            this.swigCPtr = 0L;
        }
    }

    public String name() {
        return mainJNI.MPConstraint_name(this.swigCPtr, this);
    }

    public void setCoefficient(MPVariable var, double coeff) {
        mainJNI.MPConstraint_setCoefficient(this.swigCPtr, this, MPVariable.getCPtr(var), var, coeff);
    }

    public double getCoefficient(MPVariable var) {
        return mainJNI.MPConstraint_getCoefficient(this.swigCPtr, this, MPVariable.getCPtr(var), var);
    }

    public double lb() {
        return mainJNI.MPConstraint_lb(this.swigCPtr, this);
    }

    public double ub() {
        return mainJNI.MPConstraint_ub(this.swigCPtr, this);
    }

    public void setLb(double lb) {
        mainJNI.MPConstraint_setLb(this.swigCPtr, this, lb);
    }

    public void setUb(double ub) {
        mainJNI.MPConstraint_setUb(this.swigCPtr, this, ub);
    }

    public void setBounds(double lb, double ub) {
        mainJNI.MPConstraint_setBounds(this.swigCPtr, this, lb, ub);
    }

    public boolean isLazy() {
        return mainJNI.MPConstraint_isLazy(this.swigCPtr, this);
    }

    public void setIsLazy(boolean laziness) {
        mainJNI.MPConstraint_setIsLazy(this.swigCPtr, this, laziness);
    }

    public int index() {
        return mainJNI.MPConstraint_index(this.swigCPtr, this);
    }

    public double dualValue() {
        return mainJNI.MPConstraint_dualValue(this.swigCPtr, this);
    }

    public MPSolver.BasisStatus basisStatus() {
        return MPSolver.BasisStatus.swigToEnum(mainJNI.MPConstraint_basisStatus(this.swigCPtr, this));
    }
}

