/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.client.extensions.servlet.auth;

import com.google.api.client.extensions.auth.helpers.Credential;
import com.google.api.client.extensions.auth.helpers.ThreeLeggedFlow;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.util.Beta;
import java.io.IOException;
import java.util.logging.Logger;
import javax.jdo.JDOObjectNotFoundException;
import javax.jdo.PersistenceManager;
import javax.jdo.PersistenceManagerFactory;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

@Deprecated
@Beta
public abstract class AbstractCallbackServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = Logger.getLogger(AbstractCallbackServlet.class.getName());
    private static final String ERROR_PARAM = "error";
    private PersistenceManagerFactory pmf = this.getPersistenceManagerFactory();
    private Class<? extends ThreeLeggedFlow> flowType = this.getConcreteFlowType();
    private String redirectUrl = this.getSuccessRedirectUrl();
    private String deniedRedirectUrl = this.getDeniedRedirectUrl();
    private String completionCodeQueryParam = this.getCompletionCodeQueryParam();
    private final HttpTransport httpTransport = this.newHttpTransportInstance();
    private final JsonFactory jsonFactory = this.newJsonFactoryInstance();

    protected final JsonFactory getJsonFactory() {
        return this.jsonFactory;
    }

    protected final HttpTransport getHttpTransport() {
        return this.httpTransport;
    }

    protected abstract PersistenceManagerFactory getPersistenceManagerFactory();

    protected abstract Class<? extends ThreeLeggedFlow> getConcreteFlowType();

    protected abstract String getSuccessRedirectUrl();

    protected abstract String getDeniedRedirectUrl();

    protected abstract String getCompletionCodeQueryParam();

    protected abstract String getUserId();

    protected abstract HttpTransport newHttpTransportInstance();

    protected abstract JsonFactory newJsonFactoryInstance();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void doGet(HttpServletRequest req, HttpServletResponse resp) throws IOException, ServletException {
        String completionCode = req.getParameter(this.completionCodeQueryParam);
        String errorCode = req.getParameter(ERROR_PARAM);
        if ((completionCode == null || "".equals(completionCode)) && (errorCode == null || "".equals(errorCode))) {
            resp.setStatus(400);
            resp.getWriter().print("Must have a query parameter: " + this.completionCodeQueryParam);
            return;
        }
        if (errorCode != null && !"".equals(errorCode)) {
            resp.sendRedirect(this.deniedRedirectUrl);
            return;
        }
        String userId = this.getUserId();
        try (PersistenceManager manager = this.pmf.getPersistenceManager();){
            ThreeLeggedFlow flow = null;
            try {
                flow = (ThreeLeggedFlow)manager.getObjectById(this.flowType, (Object)userId);
            }
            catch (JDOObjectNotFoundException e) {
                LOG.severe("Unable to locate flow by user: " + userId);
                resp.setStatus(404);
                resp.getWriter().print("Unable to find flow for user: " + userId);
                manager.close();
                return;
            }
            flow.setHttpTransport(this.getHttpTransport());
            flow.setJsonFactory(this.getJsonFactory());
            Credential c = flow.complete(completionCode);
            manager.makePersistent((Object)c);
            manager.deletePersistent((Object)flow);
            resp.sendRedirect(this.redirectUrl);
        }
    }
}

