/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.client.extensions.auth.helpers.oauth;

import com.google.api.client.auth.oauth.OAuthAuthorizeTemporaryTokenUrl;
import com.google.api.client.auth.oauth.OAuthCredentialsResponse;
import com.google.api.client.auth.oauth.OAuthGetAccessToken;
import com.google.api.client.auth.oauth.OAuthGetTemporaryToken;
import com.google.api.client.auth.oauth.OAuthHmacSigner;
import com.google.api.client.extensions.auth.helpers.Credential;
import com.google.api.client.extensions.auth.helpers.ThreeLeggedFlow;
import com.google.api.client.extensions.auth.helpers.oauth.OAuthHmacCredential;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.common.base.Preconditions;
import java.io.IOException;
import javax.jdo.JDOObjectNotFoundException;
import javax.jdo.PersistenceManager;
import javax.jdo.annotations.NotPersistent;
import javax.jdo.annotations.PersistenceCapable;
import javax.jdo.annotations.Persistent;
import javax.jdo.annotations.PrimaryKey;

@PersistenceCapable
public class OAuthHmacThreeLeggedFlow
implements ThreeLeggedFlow {
    @PrimaryKey
    private String userId;
    @Persistent
    private String tempToken;
    @Persistent
    private String tempTokenSecret;
    @Persistent
    private String consumerSecret;
    @Persistent
    private String consumerKey;
    @Persistent
    private String authorizationServerUrl;
    @Persistent
    private final String authorizationUrl;
    @NotPersistent
    private HttpTransport transport;

    public OAuthHmacThreeLeggedFlow(String userId, String consumerKey, String consumerSecret, String authorizationServerUrl, String temporaryTokenUrl, String callbackUrl, HttpTransport transport) throws IOException {
        this.userId = userId;
        this.consumerSecret = consumerSecret;
        this.consumerKey = consumerKey;
        this.transport = transport;
        this.authorizationServerUrl = authorizationServerUrl;
        OAuthGetTemporaryToken temporaryToken = new OAuthGetTemporaryToken(callbackUrl);
        OAuthHmacSigner signer = new OAuthHmacSigner();
        signer.clientSharedSecret = consumerSecret;
        temporaryToken.signer = signer;
        temporaryToken.consumerKey = consumerKey;
        temporaryToken.callback = callbackUrl;
        temporaryToken.transport = this.transport;
        OAuthCredentialsResponse tempCredentials = temporaryToken.execute();
        this.tempToken = tempCredentials.token;
        this.tempTokenSecret = tempCredentials.tokenSecret;
        OAuthAuthorizeTemporaryTokenUrl authorizeUrl = new OAuthAuthorizeTemporaryTokenUrl(temporaryTokenUrl);
        authorizeUrl.temporaryToken = tempCredentials.token;
        this.authorizationUrl = authorizeUrl.build();
    }

    public String getAuthorizationUrl() {
        return this.authorizationUrl;
    }

    public Credential complete(String authorizationCode) throws IOException {
        Preconditions.checkNotNull((Object)this.transport, (Object)"Must call setHttpTransport before calling complete.");
        OAuthGetAccessToken accessToken = new OAuthGetAccessToken(this.authorizationServerUrl);
        accessToken.temporaryToken = this.tempToken;
        accessToken.transport = this.transport;
        OAuthHmacSigner signer = new OAuthHmacSigner();
        signer.clientSharedSecret = this.consumerSecret;
        signer.tokenSharedSecret = this.tempTokenSecret;
        accessToken.signer = signer;
        accessToken.consumerKey = this.consumerKey;
        accessToken.verifier = authorizationCode;
        OAuthCredentialsResponse credentials = accessToken.execute();
        signer.tokenSharedSecret = credentials.tokenSecret;
        OAuthHmacCredential accessCredential = new OAuthHmacCredential(this.userId, this.consumerKey, this.consumerSecret, credentials.tokenSecret, credentials.token);
        return accessCredential;
    }

    public Credential loadCredential(PersistenceManager pm) {
        try {
            return (Credential)pm.getObjectById(OAuthHmacCredential.class, (Object)this.userId);
        }
        catch (JDOObjectNotFoundException e) {
            return null;
        }
    }

    public void setHttpTransport(HttpTransport transport) {
        this.transport = (HttpTransport)Preconditions.checkNotNull((Object)transport);
    }

    public void setJsonFactory(JsonFactory jsonFactory) {
    }
}

