/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.client.extensions.auth.helpers.oauth2.draft10;

import com.google.api.client.auth.oauth2.draft10.AccessTokenRequest;
import com.google.api.client.auth.oauth2.draft10.AccessTokenResponse;
import com.google.api.client.auth.oauth2.draft10.AuthorizationRequestUrl;
import com.google.api.client.extensions.auth.helpers.Credential;
import com.google.api.client.extensions.auth.helpers.ThreeLeggedFlow;
import com.google.api.client.extensions.auth.helpers.oauth2.draft10.OAuth2Credential;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.common.base.Preconditions;
import java.io.IOException;
import javax.jdo.JDOObjectNotFoundException;
import javax.jdo.PersistenceManager;
import javax.jdo.annotations.NotPersistent;
import javax.jdo.annotations.PersistenceCapable;
import javax.jdo.annotations.Persistent;
import javax.jdo.annotations.PrimaryKey;

@Deprecated
@PersistenceCapable
public class OAuth2ThreeLeggedFlow
implements ThreeLeggedFlow {
    @PrimaryKey
    private String userId;
    @Persistent
    private String tokenEndpoint;
    @Persistent
    private String authorizationUrl;
    @Persistent
    private String clientId;
    @Persistent
    private String clientSecret;
    @Persistent
    private String callbackUrl;
    @NotPersistent
    private HttpTransport transport;
    @NotPersistent
    private JsonFactory jsonFactory;

    public OAuth2ThreeLeggedFlow(String userId, String clientId, String clientSecret, String scope, String callbackUrl, String authorizationEndpoint, String tokenEndpoint) {
        this.userId = userId;
        this.clientId = clientId;
        this.clientSecret = clientSecret;
        this.callbackUrl = callbackUrl;
        this.tokenEndpoint = tokenEndpoint;
        AuthorizationRequestUrl authorizeUrl = new AuthorizationRequestUrl(authorizationEndpoint);
        authorizeUrl.clientId = clientId;
        authorizeUrl.redirectUri = callbackUrl;
        authorizeUrl.scope = scope;
        this.authorizationUrl = authorizeUrl.build();
    }

    public Credential complete(String authorizationCode) throws IOException {
        Preconditions.checkNotNull((Object)this.transport, (Object)"Must call setHttpTransport before calling complete.");
        AccessTokenRequest.AuthorizationCodeGrant request = new AccessTokenRequest.AuthorizationCodeGrant(this.transport, this.jsonFactory, this.tokenEndpoint, this.clientId, this.clientSecret, authorizationCode, this.callbackUrl);
        AccessTokenResponse response = request.execute();
        OAuth2Credential cred = new OAuth2Credential(this.userId, response.accessToken, response.refreshToken);
        cred.initializeForRefresh(this.clientId, this.clientSecret, this.tokenEndpoint, this.jsonFactory, this.transport);
        return cred;
    }

    public String getAuthorizationUrl() {
        return this.authorizationUrl;
    }

    public Credential loadCredential(PersistenceManager pm) {
        Preconditions.checkNotNull((Object)this.jsonFactory, (Object)"Must call setJsonFactory before calling loadCredential.");
        Preconditions.checkNotNull((Object)this.transport, (Object)"Must call setHttpTransport before calling complete.");
        try {
            OAuth2Credential cred = (OAuth2Credential)pm.getObjectById(OAuth2Credential.class, (Object)this.userId);
            cred.initializeForRefresh(this.clientId, this.clientSecret, this.tokenEndpoint, this.jsonFactory, this.transport);
            return cred;
        }
        catch (JDOObjectNotFoundException e) {
            return null;
        }
    }

    public void setHttpTransport(HttpTransport transport) {
        this.transport = (HttpTransport)Preconditions.checkNotNull((Object)transport);
    }

    public void setJsonFactory(JsonFactory jsonFactory) {
        this.jsonFactory = (JsonFactory)Preconditions.checkNotNull((Object)jsonFactory);
    }
}

