/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.client.extensions.auth.helpers.oauth2.draft10;

import com.google.api.client.auth.oauth2.draft10.AccessProtectedResource;
import com.google.api.client.extensions.auth.helpers.Credential;
import com.google.api.client.http.HttpExecuteInterceptor;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.http.HttpUnsuccessfulResponseHandler;
import com.google.api.client.json.JsonFactory;
import com.google.common.base.Preconditions;
import java.io.IOException;
import javax.jdo.InstanceCallbacks;
import javax.jdo.annotations.NotPersistent;
import javax.jdo.annotations.PersistenceCapable;
import javax.jdo.annotations.Persistent;
import javax.jdo.annotations.PrimaryKey;

@Deprecated
@PersistenceCapable
public final class OAuth2Credential
implements Credential,
InstanceCallbacks {
    @PrimaryKey
    private String userId;
    @Persistent
    private volatile String accessToken;
    @Persistent
    private String refreshToken;
    @NotPersistent
    AccessProtectedResource authInterceptor;

    public OAuth2Credential(String userId, String accessToken, String refreshToken) {
        this.userId = (String)Preconditions.checkNotNull((Object)userId);
        this.accessToken = (String)Preconditions.checkNotNull((Object)accessToken);
        this.refreshToken = refreshToken;
        this.initializeAfterConstruction();
    }

    public OAuth2Credential(String userId, String accessToken) {
        this(userId, accessToken, null);
    }

    private void initializeAfterConstruction() {
        this.authInterceptor = new AccessProtectedResource(this.accessToken, AccessProtectedResource.Method.AUTHORIZATION_HEADER);
    }

    public boolean refresh(HttpTransport transport, JsonFactory factory) throws IOException {
        return this.authInterceptor.refreshToken();
    }

    public void initialize(HttpRequest request) throws IOException {
        request.setInterceptor((HttpExecuteInterceptor)this.authInterceptor);
        request.setUnsuccessfulResponseHandler((HttpUnsuccessfulResponseHandler)this.authInterceptor);
    }

    public void intercept(HttpRequest request) throws IOException {
        this.authInterceptor.intercept(request);
    }

    public boolean handleResponse(HttpRequest request, HttpResponse response, boolean retrySupported) {
        return this.authInterceptor.handleResponse(request, response, retrySupported);
    }

    public void initializeForRefresh(String clientId, String clientSecret, String refreshUrl, JsonFactory jsonFactory, HttpTransport transport) {
        this.authInterceptor = new AccessProtectedResource(this.accessToken, AccessProtectedResource.Method.AUTHORIZATION_HEADER, transport, jsonFactory, refreshUrl, clientId, clientSecret, this.refreshToken){

            protected void onAccessToken(String accessToken) {
                OAuth2Credential.this.setAccessToken(accessToken);
            }
        };
    }

    public String getAccessToken() {
        return this.authInterceptor.getAccessToken();
    }

    public void setAccessToken(String accessToken) {
        this.accessToken = accessToken;
    }

    public String getRefreshToken() {
        return this.refreshToken;
    }

    public void jdoPreClear() {
    }

    public void jdoPreDelete() {
    }

    public void jdoPostLoad() {
        this.initializeAfterConstruction();
    }

    public void jdoPreStore() {
    }

    public boolean isInvalid() {
        return this.accessToken == null;
    }
}

