/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.client.extensions.java6.auth.oauth2;

import com.google.api.client.auth.oauth2.Credential;
import com.google.api.client.auth.oauth2.CredentialStore;
import com.google.api.client.extensions.java6.auth.oauth2.FilePersistedCredentials;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.JsonGenerator;
import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class FileCredentialStore
implements CredentialStore {
    private final JsonFactory jsonFactory;
    private final Lock lock = new ReentrantLock();
    private FilePersistedCredentials credentials = new FilePersistedCredentials();
    private final File file;

    public FileCredentialStore(File file, JsonFactory jsonFactory) throws IOException {
        this.file = (File)Preconditions.checkNotNull((Object)file);
        this.jsonFactory = (JsonFactory)Preconditions.checkNotNull((Object)jsonFactory);
        File parentDir = file.getCanonicalFile().getParentFile();
        if (parentDir != null && !parentDir.exists() && !parentDir.mkdirs()) {
            throw new IOException("unable to create parent directory");
        }
        if (!file.createNewFile()) {
            this.loadCredentials(file);
        } else {
            if (!(file.setReadable(false, false) && file.setWritable(false, false) && file.setExecutable(false, false) && file.setReadable(true) && file.setWritable(true))) {
                throw new IOException("unable to set file permissions");
            }
            this.save();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void store(String userId, Credential credential) throws IOException {
        this.lock.lock();
        try {
            this.credentials.store(userId, credential);
            this.save();
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete(String userId, Credential credential) throws IOException {
        this.lock.lock();
        try {
            this.credentials.delete(userId);
            this.save();
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean load(String userId, Credential credential) {
        this.lock.lock();
        try {
            boolean bl = this.credentials.load(userId, credential);
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadCredentials(File file) throws IOException {
        FileInputStream is = new FileInputStream(file);
        try {
            this.credentials = (FilePersistedCredentials)((Object)this.jsonFactory.fromInputStream((InputStream)is, FilePersistedCredentials.class));
        }
        finally {
            is.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void save() throws IOException {
        FileOutputStream fos = new FileOutputStream(this.file);
        try {
            JsonGenerator generator = this.jsonFactory.createJsonGenerator((OutputStream)fos, Charsets.UTF_8);
            generator.serialize((Object)this.credentials);
            generator.close();
        }
        finally {
            fos.close();
        }
    }
}

