/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.client.extensions.appengine.auth;

import com.google.appengine.api.appidentity.AppIdentityService;
import com.google.appengine.api.appidentity.AppIdentityServiceFactory;
import java.security.SecureRandom;
import java.security.SignatureException;
import java.util.Random;
import java.util.logging.Logger;
import net.oauth.jsontoken.JsonToken;
import net.oauth.jsontoken.crypto.AbstractSigner;
import net.oauth.jsontoken.crypto.SignatureAlgorithm;
import net.oauth.jsontoken.crypto.Signer;
import net.oauth.signatures.SignedJsonAssertionToken;
import org.joda.time.Duration;
import org.joda.time.Instant;
import org.joda.time.ReadableDuration;

@Deprecated
public class SignedTokenGenerator {
    private static final Logger LOGGER = Logger.getLogger(SignedTokenGenerator.class.toString());
    private static final Random GENERATOR = new SecureRandom();

    public static JsonToken createJsonTokenForScopes(String scope, String audience) {
        AppIdentityService identityService = AppIdentityServiceFactory.getAppIdentityService();
        AppEngineSigner signer = new AppEngineSigner("", identityService);
        SignedJsonAssertionToken jwt = new SignedJsonAssertionToken((Signer)signer);
        jwt.setAudience(audience);
        jwt.setScope(scope);
        jwt.setNonce(Long.toString(GENERATOR.nextLong()));
        Instant now = new Instant();
        jwt.setIssuedAt(now);
        jwt.setExpiration(now.plus((ReadableDuration)Duration.standardHours((long)1L)));
        LOGGER.fine("JWT: " + jwt.toString());
        return jwt;
    }

    private static class AppEngineSigner
    extends AbstractSigner {
        private final AppIdentityService identityService;

        protected AppEngineSigner(String keyId, AppIdentityService identityService) {
            super(identityService.getServiceAccountName(), keyId);
            this.identityService = identityService;
        }

        public SignatureAlgorithm getSignatureAlgorithm() {
            return SignatureAlgorithm.RS256;
        }

        public byte[] sign(byte[] source) throws SignatureException {
            AppIdentityService.SigningResult key = this.identityService.signForApp(source);
            this.setSigningKeyId(key.getKeyName());
            return key.getSignature();
        }
    }
}

