/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.client.extensions.appengine.auth.oauth2;

import com.google.api.client.auth.oauth2.Credential;
import com.google.api.client.auth.oauth2.CredentialStore;
import com.google.appengine.api.datastore.DatastoreService;
import com.google.appengine.api.datastore.DatastoreServiceFactory;
import com.google.appengine.api.datastore.Entity;
import com.google.appengine.api.datastore.EntityNotFoundException;
import com.google.appengine.api.datastore.Key;
import com.google.appengine.api.datastore.KeyFactory;

public class AppEngineCredentialStore
implements CredentialStore {
    private static final String KIND = AppEngineCredentialStore.class.getName();

    public void store(String userId, Credential credential) {
        DatastoreService datastore = DatastoreServiceFactory.getDatastoreService();
        Entity entity = new Entity(KIND, userId);
        entity.setProperty("accessToken", (Object)credential.getAccessToken());
        entity.setProperty("refreshToken", (Object)credential.getRefreshToken());
        entity.setProperty("expirationTimeMillis", (Object)credential.getExpirationTimeMilliseconds());
        datastore.put(entity);
    }

    public void delete(String userId, Credential credential) {
        DatastoreService datastore = DatastoreServiceFactory.getDatastoreService();
        Key key = KeyFactory.createKey((String)KIND, (String)userId);
        datastore.delete(new Key[]{key});
    }

    public boolean load(String userId, Credential credential) {
        DatastoreService datastore = DatastoreServiceFactory.getDatastoreService();
        Key key = KeyFactory.createKey((String)KIND, (String)userId);
        try {
            Entity entity = datastore.get(key);
            credential.setAccessToken((String)entity.getProperty("accessToken"));
            credential.setRefreshToken((String)entity.getProperty("refreshToken"));
            credential.setExpirationTimeMilliseconds((Long)entity.getProperty("expirationTimeMillis"));
            return true;
        }
        catch (EntityNotFoundException exception) {
            return false;
        }
    }
}

