/*
 * Decompiled with CFR 0.152.
 */
package com.google.mlkit.vision.common.internal;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Matrix;
import android.graphics.Rect;
import android.graphics.YuvImage;
import android.media.Image;
import android.os.Build;
import android.util.Log;
import androidx.annotation.NonNull;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.mlkit.common.MlKitException;
import com.google.mlkit.vision.common.InputImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.nio.Buffer;
import java.nio.ByteBuffer;

@KeepForSdk
public class ImageConvertUtils {
    private static final ImageConvertUtils zza;

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    @NonNull
    @KeepForSdk
    public Bitmap convertJpegToUpRightBitmap(@NonNull Image image, int rotationDegrees) {
        byte[] byArray;
        boolean bl = image.getFormat() == 256;
        Preconditions.checkArgument((boolean)bl, (Object)"Only JPEG is supported now");
        Object object = byArray.getPlanes();
        if (object != null && ((Image.Plane[])object).length == 1) {
            void var2_4;
            object = object[0].getBuffer();
            ((ByteBuffer)object).rewind();
            byArray = new byte[((Buffer)object).remaining()];
            ((ByteBuffer)object).get(byArray);
            object = BitmapFactory.decodeByteArray((byte[])byArray, (int)0, (int)byArray.length);
            return ImageConvertUtils.zza((Bitmap)object, (int)var2_4, object.getWidth(), object.getHeight());
        }
        object = new IllegalArgumentException("Unexpected image format, JPEG should have exactly 1 image plane");
        throw object;
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    @KeepForSdk
    public Bitmap convertToUpRightBitmap(@NonNull InputImage inputImage) throws MlKitException {
        void var1_1;
        switch (inputImage.getFormat()) {
            default: {
                ImageConvertUtils imageConvertUtils = new MlKitException("Unsupported image format", 13);
                throw imageConvertUtils;
            }
            case 842094169: {
                return ImageConvertUtils.yv12ToBitmap((ByteBuffer)Preconditions.checkNotNull((Object)var1_1.getByteBuffer()), var1_1.getWidth(), var1_1.getHeight(), var1_1.getRotationDegrees());
            }
            case 35: {
                return imageConvertUtils.nv21ToBitmap(imageConvertUtils.yuv420ThreePlanesToNV21((Image.Plane[])Preconditions.checkNotNull((Object)var1_1.getPlanes()), var1_1.getWidth(), var1_1.getHeight()), var1_1.getWidth(), var1_1.getHeight(), var1_1.getRotationDegrees());
            }
            case 17: {
                return imageConvertUtils.nv21ToBitmap((ByteBuffer)Preconditions.checkNotNull((Object)var1_1.getByteBuffer()), var1_1.getWidth(), var1_1.getHeight(), var1_1.getRotationDegrees());
            }
            case -1: 
        }
        return ImageConvertUtils.zza((Bitmap)Preconditions.checkNotNull((Object)var1_1.getBitmapInternal()), var1_1.getRotationDegrees(), var1_1.getWidth(), var1_1.getHeight());
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    @KeepForSdk
    public Bitmap getUpRightBitmap(@NonNull InputImage inputImage) throws MlKitException {
        void var1_1;
        Bitmap bitmap = inputImage.getBitmapInternal();
        if (bitmap != null) {
            return ImageConvertUtils.zza(bitmap, var1_1.getRotationDegrees(), var1_1.getWidth(), var1_1.getHeight());
        }
        return this.convertToUpRightBitmap((InputImage)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @KeepForSdk
    @NonNull
    public Bitmap nv21ToBitmap(@NonNull ByteBuffer buffer, int width, int height, int rotationDegrees) throws MlKitException {
        void var4_4;
        void var3_3;
        void var2_2;
        void var1_1;
        Object this_ = ImageConvertUtils.zzb(((ImageConvertUtils)this_).byteBufferToByteArray((ByteBuffer)var1_1), (int)var2_2, (int)var3_3);
        this_ = BitmapFactory.decodeByteArray((byte[])this_, (int)0, (int)((Object)this_).length);
        return ImageConvertUtils.zza((Bitmap)this_, (int)var4_4, this_.getWidth(), this_.getHeight());
    }

    /*
     * WARNING - void declaration
     */
    @KeepForSdk
    @NonNull
    public static Bitmap yv12ToBitmap(@NonNull ByteBuffer buffer, int width, int height, int rotationDegrees) throws MlKitException {
        void var3_3;
        void var2_2;
        void var1_1;
        Object object = ImageConvertUtils.zzb(ImageConvertUtils.yv12ToNv21Buffer(buffer, true).array(), (int)var1_1, (int)var2_2);
        object = BitmapFactory.decodeByteArray((byte[])object, (int)0, (int)((Object)object).length);
        return ImageConvertUtils.zza((Bitmap)object, (int)var3_3, object.getWidth(), object.getHeight());
    }

    @KeepForSdk
    @NonNull
    public static ImageConvertUtils getInstance() {
        return zza;
    }

    @KeepForSdk
    @NonNull
    public static ByteBuffer bufferWithBackingArray(@NonNull ByteBuffer byteBuffer) {
        ByteBuffer byteBuffer2;
        if (byteBuffer.hasArray()) {
            return byteBuffer2;
        }
        byteBuffer2.rewind();
        byte[] byArray = new byte[byteBuffer2.limit()];
        byteBuffer2.get(byArray);
        return ByteBuffer.wrap(byArray);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    @KeepForSdk
    @NonNull
    public ByteBuffer cloneByteBuffer(@NonNull ByteBuffer byteBuffer) {
        void var1_3;
        Preconditions.checkNotNull((Object)byteBuffer);
        int n = var1_3.capacity();
        int n2 = var1_3.position();
        ByteBuffer byteBuffer2 = var1_3.isDirect() ? ByteBuffer.allocateDirect(n) : ByteBuffer.allocate(n);
        byteBuffer2.limit(var1_3.limit());
        byteBuffer2.put((ByteBuffer)var1_3.rewind());
        byteBuffer2.position(n2);
        var1_3.position(n2);
        return byteBuffer2;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    @NonNull
    @KeepForSdk
    public ByteBuffer convertToNv21Buffer(@NonNull InputImage inputImage, boolean requestBackingArray) throws MlKitException {
        switch (inputImage.getFormat()) {
            case 842094169: {
                int n;
                void var1_3;
                return ImageConvertUtils.yv12ToNv21Buffer((ByteBuffer)Preconditions.checkNotNull((Object)var1_3.getByteBuffer()), n != 0);
            }
            case 35: {
                void var1_3;
                return ((ImageConvertUtils)object).yuv420ThreePlanesToNV21((Image.Plane[])Preconditions.checkNotNull((Object)var1_3.getPlanes()), var1_3.getWidth(), var1_3.getHeight());
            }
            case -1: {
                int n;
                void var1_3;
                Object object = (Bitmap)Preconditions.checkNotNull((Object)var1_3.getBitmapInternal());
                if (Build.VERSION.SDK_INT >= 26 && object.getConfig() == Bitmap.Config.HARDWARE) {
                    object = object.copy(Bitmap.Config.ARGB_8888, object.isMutable());
                }
                int n2 = object.getWidth();
                int n3 = object.getHeight();
                int n4 = n2 * n3;
                int[] nArray = new int[n4];
                object.getPixels(nArray, 0, n2, 0, 0, n2, n3);
                int n5 = (int)Math.ceil((double)n3 / 2.0);
                n5 = n4 + (n5 + n5) * (int)Math.ceil((double)n2 / 2.0);
                ByteBuffer byteBuffer = n != 0 ? ByteBuffer.allocate(n5) : ByteBuffer.allocateDirect(n5);
                int n6 = 0;
                n = n4;
                n4 = 0;
                int n7 = 0;
                while (n7 < n3) {
                    int n8 = n;
                    int n9 = n4;
                    for (int i = 0; i < n2; ++n9, ++i) {
                        n = nArray[n9];
                        n4 = n >> 16 & 0xFF;
                        int n10 = n >> 8 & 0xFF;
                        int n11 = (n4 * -38 - n10 * 74 + (n &= 0xFF) * 112 + 128 >> 8) + 128;
                        int n12 = (n4 * 112 - n10 * 94 - n * 18 + 128 >> 8) + 128;
                        int n13 = n6 + 1;
                        byteBuffer.put(n6, (byte)Math.min(255, (n4 * 66 + n10 * 129 + n * 25 + 128 >> 8) + 16));
                        if (n7 % 2 == 0 && n9 % 2 == 0) {
                            n6 = n8 + 1;
                            byteBuffer.put(n8, (byte)Math.min(255, n12));
                            n8 = n6 + 1;
                            byteBuffer.put(n6, (byte)Math.min(255, n11));
                        }
                        n6 = n13;
                    }
                    ++n7;
                    n = n8;
                    n4 = n9;
                }
                return byteBuffer;
            }
            case 17: {
                int n;
                void var1_3;
                if (n == false) return (ByteBuffer)Preconditions.checkNotNull((Object)var1_3.getByteBuffer());
                return ImageConvertUtils.bufferWithBackingArray((ByteBuffer)Preconditions.checkNotNull((Object)var1_3.getByteBuffer()));
            }
            default: {
                Object object = new MlKitException("Unsupported image format", 13);
                throw object;
            }
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    @KeepForSdk
    @NonNull
    public ByteBuffer yuv420ThreePlanesToNV21(@NonNull Image.Plane[] yuv420888planes, int width, int height) {
        void var2_4;
        void var1_3;
        void var3_5;
        int n = width * var3_5;
        int n2 = n / 4;
        byte[] byArray = new byte[n + (n2 + n2)];
        ByteBuffer byteBuffer = var1_3[1].getBuffer();
        ByteBuffer byteBuffer2 = var1_3[2].getBuffer();
        int n3 = byteBuffer2.position();
        int n4 = byteBuffer.limit();
        byteBuffer2.position(n3 + 1);
        byteBuffer.limit(n4 + -1);
        int n5 = n + n;
        n2 = byteBuffer2.remaining() == n5 / 4 + -2 ? (byteBuffer2.compareTo(byteBuffer) == 0 ? 1 : 0) : 0;
        byteBuffer2.position(n3);
        byteBuffer.limit(n4);
        if (n2 != 0) {
            var1_3[0].getBuffer().get(byArray, 0, n);
            ByteBuffer byteBuffer3 = var1_3[1];
            byteBuffer3 = byteBuffer3.getBuffer();
            var1_3[2].getBuffer().get(byArray, n, 1);
            byteBuffer3.get(byArray, n + 1, n5 / 4 + -1);
            return ByteBuffer.wrap(byArray);
        }
        ImageConvertUtils.zzc((Image.Plane)var1_3[0], (int)var2_4, (int)var3_5, byArray, 0, 1);
        ImageConvertUtils.zzc((Image.Plane)var1_3[1], (int)var2_4, (int)var3_5, byArray, n + 1, 2);
        ImageConvertUtils.zzc((Image.Plane)var1_3[2], (int)var2_4, (int)var3_5, byArray, n, 2);
        return ByteBuffer.wrap(byArray);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    @VisibleForTesting
    @KeepForSdk
    @NonNull
    public static ByteBuffer yv12ToNv21Buffer(@NonNull ByteBuffer yv12Buffer, boolean requestBackingArray) {
        int n;
        void var1_1;
        ByteBuffer byteBuffer;
        yv12Buffer.rewind();
        int n2 = byteBuffer.limit();
        int n3 = n2 / 6;
        ByteBuffer byteBuffer2 = var1_1 != false ? ByteBuffer.allocate(n2) : ByteBuffer.allocateDirect(n2);
        for (n = 0; n < n3 * 4; ++n) {
            byteBuffer2.put(n, byteBuffer.get(n));
        }
        n2 = n2 / 6 * 4;
        n = 0;
        while (n < n3 + n3) {
            byteBuffer2.put(n2 + n, byteBuffer.get(n2 + n % 2 * n3 + n / 2));
            ++n;
        }
        return byteBuffer2;
    }

    static {
        ImageConvertUtils imageConvertUtils;
        zza = imageConvertUtils = new ImageConvertUtils();
    }

    private ImageConvertUtils() {
    }

    /*
     * WARNING - void declaration
     */
    @KeepForSdk
    @NonNull
    public byte[] byteBufferToByteArray(@NonNull ByteBuffer byteBuffer) {
        void var1_1;
        if (byteBuffer.hasArray() && var1_1.arrayOffset() == 0) {
            return var1_1.array();
        }
        var1_1.rewind();
        Object object = new byte[var1_1.limit()];
        var1_1.get((byte[])object, 0, ((Object)object).length);
        return object;
    }

    private static Bitmap zza(Bitmap bitmap, int n, int n2, int n3) {
        if (n == 0) {
            return Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)0, (int)n2, (int)n3);
        }
        Matrix matrix = new Matrix();
        matrix.postRotate((float)n);
        return Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)0, (int)n2, (int)n3, (Matrix)matrix, (boolean)true);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static byte[] zzb(@NonNull byte[] object, int n, int n2) throws MlKitException {
        Object[] objectArray = new YuvImage((byte[])object, 17, n, n2, null);
        object = new ByteArrayOutputStream;
        ((ByteArrayOutputStream)object)();
        {
            byte[] byArray;
            catch (IOException iOException) {
                Log.w((String)"ImageConvertUtils", (String)"Error closing ByteArrayOutputStream");
                object = new MlKitException;
                object("Image conversion error from NV21 format", 13);
                throw object;
            }
            try {
                Rect rect = new Rect(0, 0, n, n2);
                objectArray.compressToJpeg(rect, 100, (OutputStream)object);
                byArray = ((ByteArrayOutputStream)object).toByteArray();
            }
            catch (Throwable throwable) {}
            try {
                ((ByteArrayOutputStream)object).close();
            }
            catch (Throwable throwable2) {
                try {
                    Object object2 = new Class[]{Throwable.class};
                    object2 = Throwable.class.getDeclaredMethod("addSuppressed", (Class<?>)object2);
                    objectArray = new Object[]{throwable2};
                    ((Method)object2).invoke((Object)throwable, objectArray);
                    throw throwable;
                }
                catch (Exception exception) {
                    throw throwable;
                }
            }
            {
                throw throwable;
            }
            {
                ((ByteArrayOutputStream)object).close();
                return byArray;
            }
        }
    }

    private static final void zzc(Image.Plane plane, int n, int n2, byte[] byArray, int n3, int n4) {
        ByteBuffer byteBuffer = plane.getBuffer();
        byteBuffer.rewind();
        int n5 = (byteBuffer.limit() + plane.getRowStride() + -1) / plane.getRowStride();
        if (n5 == 0) {
            return;
        }
        int n6 = n / (n2 / n5);
        n = n3;
        n2 = 0;
        for (n3 = 0; n3 < n5; ++n3) {
            int n7 = n2;
            for (int i = 0; i < n6; ++i) {
                byArray[n] = byteBuffer.get(n7);
                n += n4;
                n7 += plane.getPixelStride();
            }
            n2 += plane.getRowStride();
        }
    }
}

