/*
 * Decompiled with CFR 0.152.
 */
package com.google.mlkit.common.sdkinternal;

import android.app.admin.DevicePolicyManager;
import android.content.Context;
import android.content.SharedPreferences;
import android.os.Build;
import android.os.SystemClock;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import androidx.annotation.WorkerThread;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.internal.Preconditions;
import com.google.firebase.components.Component;
import com.google.firebase.components.ComponentFactory;
import com.google.firebase.components.Dependency;
import com.google.mlkit.common.model.RemoteModel;
import com.google.mlkit.common.sdkinternal.MlKitContext;
import com.google.mlkit.common.sdkinternal.ModelInfo;
import com.google.mlkit.common.sdkinternal.zzs;
import java.util.UUID;

@KeepForSdk
public class SharedPrefManager {
    @KeepForSdk
    @VisibleForTesting
    @NonNull
    public static final String PREF_FILE = "com.google.mlkit.internal";
    @KeepForSdk
    @NonNull
    public static final Component<?> COMPONENT = Component.builder(SharedPrefManager.class).add(Dependency.required(MlKitContext.class)).add(Dependency.required(Context.class)).factory((ComponentFactory)zzs.zza).build();
    private final Context zza;

    /*
     * WARNING - void declaration
     */
    @KeepForSdk
    public synchronized long getModelDownloadBeginTimeMs(@NonNull RemoteModel remoteModel) {
        void var1_1;
        SharedPreferences sharedPreferences = this_.zzc();
        Object[] this_ = new Object[]{var1_1.getUniqueModelNameForPersist()};
        return sharedPreferences.getLong(String.format("downloading_begin_time_%s", this_), 0L);
    }

    /*
     * WARNING - void declaration
     */
    @KeepForSdk
    public synchronized long getModelFirstUseTimeMs(@NonNull RemoteModel remoteModel) {
        void var1_1;
        SharedPreferences sharedPreferences = this_.zzc();
        Object[] this_ = new Object[]{var1_1.getUniqueModelNameForPersist()};
        return sharedPreferences.getLong(String.format("model_first_use_time_%s", this_), 0L);
    }

    @KeepForSdk
    @NonNull
    public static SharedPrefManager getInstance(@NonNull MlKitContext mlKitContext) {
        return mlKitContext.get(SharedPrefManager.class);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    @KeepForSdk
    public synchronized Long getDownloadingModelId(@NonNull RemoteModel remoteModel) {
        void var1_1;
        SharedPreferences sharedPreferences = this_.zzc();
        Object[] this_ = new Object[]{var1_1.getUniqueModelNameForPersist()};
        long l = sharedPreferences.getLong(String.format("downloading_model_id_%s", this_), -1L);
        if (l < 0L) {
            return null;
        }
        return l;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    @KeepForSdk
    public synchronized String getDownloadingModelHash(@NonNull RemoteModel remoteModel) {
        void var1_1;
        SharedPreferences sharedPreferences = this_.zzc();
        Object[] this_ = new Object[]{var1_1.getUniqueModelNameForPersist()};
        return sharedPreferences.getString(String.format("downloading_model_hash_%s", this_), null);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    @KeepForSdk
    public synchronized String getIncompatibleModelHash(@NonNull RemoteModel remoteModel) {
        void var1_1;
        SharedPreferences sharedPreferences = this_.zzc();
        Object[] this_ = new Object[]{var1_1.getUniqueModelNameForPersist()};
        return sharedPreferences.getString(String.format("bad_hash_%s", this_), null);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    @KeepForSdk
    public synchronized String getLatestModelHash(@NonNull RemoteModel remoteModel) {
        void var1_1;
        SharedPreferences sharedPreferences = this_.zzc();
        Object[] this_ = new Object[]{var1_1.getUniqueModelNameForPersist()};
        return sharedPreferences.getString(String.format("current_model_hash_%s", this_), null);
    }

    @KeepForSdk
    @NonNull
    public synchronized String getMlSdkInstanceId() {
        String string = this.zzc().getString("ml_sdk_instance_id", null);
        if (string != null) {
            return string;
        }
        string = UUID.randomUUID().toString();
        this.zzc().edit().putString("ml_sdk_instance_id", string).apply();
        return string;
    }

    @Nullable
    @KeepForSdk
    public synchronized String getPreviousAppVersion() {
        return this.zzc().getString("app_version", null);
    }

    public SharedPrefManager(@NonNull Context context) {
        this.zza = context;
    }

    /*
     * WARNING - void declaration
     */
    @KeepForSdk
    public synchronized void clearDownloadingModelInfo(@NonNull RemoteModel remoteModel) {
        void var1_1;
        String string = this_.getDownloadingModelHash((RemoteModel)var1_1);
        SharedPreferences.Editor editor = this_.zzc().edit();
        Object[] this_ = new Object[]{var1_1.getUniqueModelNameForPersist()};
        SharedPreferences.Editor editor2 = editor.remove(String.format("downloading_model_id_%s", this_));
        this_ = new Object[]{var1_1.getUniqueModelNameForPersist()};
        SharedPreferences.Editor editor3 = editor2.remove(String.format("downloading_model_hash_%s", this_));
        this_ = new Object[]{string};
        SharedPreferences.Editor editor4 = editor3.remove(String.format("downloading_model_type_%s", this_));
        this_ = new Object[]{var1_1.getUniqueModelNameForPersist()};
        SharedPreferences.Editor editor5 = editor4.remove(String.format("downloading_begin_time_%s", this_));
        this_ = new Object[]{var1_1.getUniqueModelNameForPersist()};
        editor5.remove(String.format("model_first_use_time_%s", this_)).apply();
    }

    /*
     * WARNING - void declaration
     */
    @KeepForSdk
    public synchronized void clearIncompatibleModelInfo(@NonNull RemoteModel remoteModel) {
        void var1_1;
        SharedPreferences.Editor editor = this_.zzc().edit();
        Object[] this_ = new Object[]{var1_1.getUniqueModelNameForPersist()};
        editor.remove(String.format("bad_hash_%s", this_)).remove("app_version").apply();
    }

    /*
     * WARNING - void declaration
     */
    @WorkerThread
    @KeepForSdk
    public synchronized void clearLatestModelHash(@NonNull RemoteModel remoteModel) {
        void var1_1;
        SharedPreferences.Editor editor = this_.zzc().edit();
        Object[] this_ = new Object[]{var1_1.getUniqueModelNameForPersist()};
        editor.remove(String.format("current_model_hash_%s", this_)).commit();
    }

    /*
     * WARNING - void declaration
     */
    @KeepForSdk
    public synchronized void setDownloadingModelInfo(long id, @NonNull ModelInfo modelInfo) {
        void var1_1;
        String string;
        String string2 = modelInfo.getModelNameForPersist();
        string = ((ModelInfo)((Object)string)).getModelHash();
        SharedPreferences.Editor editor = objectArray.zzc().edit();
        Object[] objectArray = new Object[]{string2};
        SharedPreferences.Editor editor2 = editor.putString(String.format("downloading_model_hash_%s", objectArray), string);
        objectArray = new Object[]{string2};
        SharedPreferences.Editor editor3 = editor2.putLong(String.format("downloading_model_id_%s", objectArray), (long)var1_1);
        objectArray = new Object[]{string2};
        editor3.putLong(String.format("downloading_begin_time_%s", objectArray), SystemClock.elapsedRealtime()).apply();
    }

    /*
     * WARNING - void declaration
     */
    @KeepForSdk
    public synchronized void setIncompatibleModelInfo(@NonNull RemoteModel remoteModel, @NonNull String hash, @NonNull String appVersion) {
        void var3_3;
        void var2_2;
        void var1_1;
        SharedPreferences.Editor editor = this_.zzc().edit();
        Object[] this_ = new Object[]{var1_1.getUniqueModelNameForPersist()};
        editor.putString(String.format("bad_hash_%s", this_), (String)var2_2).putString("app_version", (String)var3_3).apply();
    }

    /*
     * WARNING - void declaration
     */
    @KeepForSdk
    public synchronized void setLatestModelHash(@NonNull RemoteModel remoteModel, @NonNull String hash) {
        void var2_2;
        void var1_1;
        SharedPreferences.Editor editor = this_.zzc().edit();
        Object[] this_ = new Object[]{var1_1.getUniqueModelNameForPersist()};
        editor.putString(String.format("current_model_hash_%s", this_), (String)var2_2).apply();
    }

    /*
     * WARNING - void declaration
     */
    @KeepForSdk
    public synchronized void setModelFirstUseTimeMs(@NonNull RemoteModel remoteModel, long firstUseTimeMs) {
        void var2_2;
        void var1_1;
        SharedPreferences.Editor editor = this_.zzc().edit();
        Object[] this_ = new Object[]{var1_1.getUniqueModelNameForPersist()};
        editor.putLong(String.format("model_first_use_time_%s", this_), (long)var2_2).apply();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final SharedPreferences zzc() {
        DevicePolicyManager devicePolicyManager = (DevicePolicyManager)this.zza.getSystemService("device_policy");
        if (devicePolicyManager == null) return this.zza.getSharedPreferences(PREF_FILE, 0);
        if (Build.VERSION.SDK_INT < 24) return this.zza.getSharedPreferences(PREF_FILE, 0);
        int n = devicePolicyManager.getStorageEncryptionStatus();
        if (n != 3) {
            if (n != 5) return this.zza.getSharedPreferences(PREF_FILE, 0);
        }
        Context context = this.zza.createDeviceProtectedStorageContext();
        context.moveSharedPreferencesFrom(this.zza, PREF_FILE);
        return context.getSharedPreferences(PREF_FILE, 0);
    }

    @Nullable
    public final synchronized String zza(@NonNull String string, long l) {
        SharedPreferences sharedPreferences = objectArray.zzc();
        Object[] objectArray = new Object[]{Preconditions.checkNotNull((Object)string), l};
        return sharedPreferences.getString(String.format("cached_local_model_hash_%1s_%2s", objectArray), null);
    }

    public final synchronized void zzb(@NonNull String string, long l, @NonNull String string2) {
        SharedPreferences.Editor editor = objectArray.zzc().edit();
        Object[] objectArray = new Object[]{Preconditions.checkNotNull((Object)string), l};
        editor.putString(String.format("cached_local_model_hash_%1s_%2s", objectArray), string2).apply();
    }
}

