/*
 * Decompiled with CFR 0.152.
 */
package com.google.mlkit.common.sdkinternal.model;

import androidx.annotation.GuardedBy;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.WorkerThread;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.internal.GmsLogger;
import com.google.android.gms.internal.mlkit_common.zzsh;
import com.google.android.gms.internal.mlkit_common.zzsk;
import com.google.android.gms.internal.mlkit_common.zzss;
import com.google.mlkit.common.MlKitException;
import com.google.mlkit.common.model.RemoteModel;
import com.google.mlkit.common.sdkinternal.MlKitContext;
import com.google.mlkit.common.sdkinternal.SharedPrefManager;
import com.google.mlkit.common.sdkinternal.model.ModelFileHelper;
import com.google.mlkit.common.sdkinternal.model.ModelInfoRetrieverInterop;
import com.google.mlkit.common.sdkinternal.model.ModelValidator;
import com.google.mlkit.common.sdkinternal.model.RemoteModelDownloadManager;
import com.google.mlkit.common.sdkinternal.model.RemoteModelFileManager;
import com.google.mlkit.common.sdkinternal.model.RemoteModelFileMover;
import com.google.mlkit.common.sdkinternal.model.RemoteModelLoaderHelper;
import java.io.File;
import java.nio.MappedByteBuffer;
import java.util.HashMap;
import java.util.Map;

@KeepForSdk
public class RemoteModelLoader {
    private static final GmsLogger zza = new GmsLogger("RemoteModelLoader", "");
    @GuardedBy(value="RemoteModelLoader.class")
    private static final Map zzb = new HashMap();
    private final MlKitContext zzc;
    private final RemoteModel zzd;
    private final RemoteModelDownloadManager zze;
    private final RemoteModelFileManager zzf;
    private final RemoteModelLoaderHelper zzg;
    private final zzsh zzh;
    private boolean zzi;

    @KeepForSdk
    @NonNull
    public RemoteModel getRemoteModel() {
        return this.zzd;
    }

    /*
     * WARNING - void declaration
     */
    @KeepForSdk
    @NonNull
    public static synchronized RemoteModelLoader getInstance(@NonNull MlKitContext mlKitContext, @NonNull RemoteModel remoteModel, @NonNull ModelValidator checker, @NonNull RemoteModelLoaderHelper loaderHelper, @NonNull RemoteModelFileMover modelFileMover) {
        String string = remoteModel.getUniqueModelNameForPersist();
        if (!zzb.containsKey(string)) {
            void var4_4;
            void var3_3;
            void var2_2;
            void var1_1;
            MlKitContext mlKitContext2;
            RemoteModelLoader remoteModelLoader = new RemoteModelLoader(mlKitContext2, (RemoteModel)var1_1, (ModelValidator)var2_2, (RemoteModelLoaderHelper)var3_3, (RemoteModelFileMover)var4_4);
            zzb.put(string, remoteModelLoader);
        }
        return (RemoteModelLoader)zzb.get(string);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    @WorkerThread
    @KeepForSdk
    public synchronized MappedByteBuffer load() throws MlKitException {
        Object object;
        block10: {
            Integer n;
            Object object2;
            Comparable<Long> comparable;
            block13: {
                String string;
                boolean bl;
                block14: {
                    block12: {
                        block11: {
                            zza.d("RemoteModelLoader", "Try to load newly downloaded model file.");
                            bl = ((RemoteModelLoader)((Object)remoteModel)).zzi;
                            comparable = ((RemoteModelLoader)((Object)remoteModel)).zze.getDownloadingId();
                            object2 = ((RemoteModelLoader)((Object)remoteModel)).zze.getDownloadingModelHash();
                            if (comparable != null && object2 != null) break block11;
                            zza.d("RemoteModelLoader", "No new model is downloading.");
                            ((RemoteModelLoader)((Object)remoteModel)).zze.removeOrCancelDownload();
                            object = null;
                            break block10;
                        }
                        n = ((RemoteModelLoader)((Object)remoteModel)).zze.getDownloadingModelStatusCode();
                        if (n != null) break block12;
                        ((RemoteModelLoader)((Object)remoteModel)).zze.removeOrCancelDownload();
                        object = null;
                        break block10;
                    }
                    StringBuilder stringBuilder = new StringBuilder();
                    stringBuilder.append("Download Status code: ");
                    stringBuilder.append(n);
                    string = "Download Status code: ".concat(((Object)n).toString());
                    zza.d("RemoteModelLoader", string);
                    if (n != 8) break block13;
                    comparable = ((RemoteModelLoader)((Object)remoteModel)).zze.zzi((String)object2);
                    if (comparable != null) break block14;
                    object = null;
                    break block10;
                }
                MappedByteBuffer mappedByteBuffer = super.zzb((File)comparable);
                string = String.valueOf(((File)comparable).getParent());
                String string2 = "Moved the downloaded model to private folder successfully: ";
                zza.d("RemoteModelLoader", string2.concat(string));
                ((RemoteModelLoader)((Object)remoteModel)).zze.updateLatestModelHashAndType((String)object2);
                if (bl) {
                    if (((RemoteModelLoader)((Object)remoteModel)).zzf.zzd((File)comparable)) {
                        zza.d("RemoteModelLoader", "All old models are deleted.");
                        RemoteModel remoteModel = remoteModel;
                        object = super.zzb(((RemoteModelLoader)((Object)remoteModel)).zzf.zza((File)comparable));
                        break block10;
                    } else {
                        object = mappedByteBuffer;
                    }
                    break block10;
                } else {
                    object = mappedByteBuffer;
                }
                break block10;
            }
            if (n == 16) {
                object = ((RemoteModelLoader)((Object)remoteModel)).zzd;
                object2 = ((RemoteModelLoader)((Object)remoteModel)).zze;
                ((RemoteModelLoader)((Object)remoteModel)).zzh.zze(zzsk.zzg(), (RemoteModel)object, false, ((RemoteModelDownloadManager)object2).getFailureReason((Long)comparable));
                ((RemoteModelLoader)((Object)remoteModel)).zze.removeOrCancelDownload();
                object = null;
            } else {
                object = null;
            }
        }
        if (object != null) {
            ((RemoteModelLoader)((Object)remoteModel)).zzi = false;
            return object;
        }
        zza.d("RemoteModelLoader", "Loading existing model file.");
        object = ((RemoteModelLoader)((Object)remoteModel)).zzf.zzb();
        if (object == null) {
            zza.d("RemoteModelLoader", "No existing model file");
            return null;
        }
        try {
            return ((RemoteModelLoader)((Object)remoteModel)).zza((String)object);
        }
        catch (Exception exception) {
            ((RemoteModelLoader)((Object)remoteModel)).zzf.zzc(new File((String)object));
            RemoteModel remoteModel = ((RemoteModelLoader)((Object)remoteModel)).zzd;
            SharedPrefManager.getInstance(((RemoteModelLoader)((Object)remoteModel)).zzc).clearLatestModelHash(remoteModel);
            throw new MlKitException("Failed to load an already downloaded model.", 14, exception);
        }
    }

    private RemoteModelLoader(@NonNull MlKitContext mlKitContext, @NonNull RemoteModel remoteModel, @NonNull ModelValidator object, @NonNull RemoteModelLoaderHelper remoteModelLoaderHelper, @NonNull RemoteModelFileMover remoteModelFileMover) {
        this.zzf = new RemoteModelFileManager(mlKitContext, remoteModel, (ModelValidator)object, new ModelFileHelper(mlKitContext), remoteModelFileMover);
        this.zzi = true;
        object = ModelInfoRetrieverInterop.class;
        this.zze = RemoteModelDownloadManager.getInstance(mlKitContext, remoteModel, new ModelFileHelper(mlKitContext), this.zzf, (ModelInfoRetrieverInterop)mlKitContext.get(object));
        this.zzg = remoteModelLoaderHelper;
        this.zzc = mlKitContext;
        this.zzd = remoteModel;
        this.zzh = zzss.zzb("common");
    }

    @WorkerThread
    @NonNull
    private final MappedByteBuffer zza(@NonNull String string) throws MlKitException {
        return this.zzg.loadModelAtPath(string);
    }

    private final MappedByteBuffer zzb(File file) throws MlKitException {
        try {
            MappedByteBuffer mappedByteBuffer = ((RemoteModelLoader)((Object)mappedByteBuffer)).zza(file.getAbsolutePath());
        }
        catch (Exception exception) {
            ((RemoteModelLoader)((Object)mappedByteBuffer)).zzf.zzc(file);
            throw new MlKitException("Failed to load newly downloaded model.", 14, exception);
        }
        return mappedByteBuffer;
    }
}

