/*
 * Decompiled with CFR 0.152.
 */
package com.google.maps.model;

import java.io.Serializable;
import java.time.LocalTime;
import java.util.Arrays;

public class OpeningHours
implements Serializable {
    private static final long serialVersionUID = 1L;
    public Boolean openNow;
    public Period[] periods;
    public SpecialDay[] specialDays;
    public String type;
    public String[] weekdayText;

    public String toString() {
        StringBuilder sb = new StringBuilder("[OpeningHours:");
        if (this.openNow != null && this.openNow.booleanValue()) {
            sb.append(" openNow");
        }
        sb.append(" ").append(Arrays.toString(this.periods));
        if (this.specialDays != null) {
            sb.append(" (\"").append(this.specialDays).append("\")");
        }
        if (this.type != null) {
            sb.append(" (\"").append(this.type).append("\")");
        }
        return sb.toString();
    }

    public static class SpecialDay
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public String date;
        public Boolean exceptionalHours;

        public String toString() {
            StringBuilder sb = new StringBuilder("[Special Day: ");
            if (this.date != null) {
                sb.append(" (\"").append(this.date).append("\")");
            }
            if (this.exceptionalHours != null) {
                sb.append(" (\"").append(this.exceptionalHours).append("\")");
            }
            sb.append("]");
            return sb.toString();
        }
    }

    public static class Period
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public OpenClose open;
        public OpenClose close;

        public String toString() {
            return String.format("%s - %s", this.open, this.close);
        }

        public static class OpenClose
        implements Serializable {
            private static final long serialVersionUID = 1L;
            public DayOfWeek day;
            public LocalTime time;

            public String toString() {
                return String.format("%s %s", new Object[]{this.day, this.time});
            }

            public static enum DayOfWeek {
                SUNDAY("Sunday"),
                MONDAY("Monday"),
                TUESDAY("Tuesday"),
                WEDNESDAY("Wednesday"),
                THURSDAY("Thursday"),
                FRIDAY("Friday"),
                SATURDAY("Saturday"),
                UNKNOWN("Unknown");

                private final String name;

                private DayOfWeek(String name) {
                    this.name = name;
                }

                public String getName() {
                    return this.name;
                }
            }
        }
    }
}

