/*
 * Decompiled with CFR 0.152.
 */
package com.google.maps;

import com.google.gson.FieldNamingPolicy;
import com.google.maps.GeoApiContext;
import com.google.maps.PendingResult;
import com.google.maps.errors.ApiError;
import com.google.maps.errors.ApiException;
import com.google.maps.internal.ApiConfig;
import com.google.maps.internal.ApiResponse;
import com.google.maps.internal.StringJoin;
import com.google.maps.model.LatLng;
import com.google.maps.model.SnappedPoint;
import com.google.maps.model.SnappedSpeedLimitResponse;
import com.google.maps.model.SpeedLimit;

public class RoadsApi {
    static final String API_BASE_URL = "https://roads.googleapis.com";
    static final ApiConfig SNAP_TO_ROADS_API_CONFIG = new ApiConfig("/v1/snapToRoads").hostName("https://roads.googleapis.com").supportsClientId(false).fieldNamingPolicy(FieldNamingPolicy.IDENTITY);
    static final ApiConfig SPEEDS_API_CONFIG = new ApiConfig("/v1/speedLimits").hostName("https://roads.googleapis.com").supportsClientId(false).fieldNamingPolicy(FieldNamingPolicy.IDENTITY);
    static final ApiConfig NEAREST_ROADS_API_CONFIG = new ApiConfig("/v1/nearestRoads").hostName("https://roads.googleapis.com").supportsClientId(false).fieldNamingPolicy(FieldNamingPolicy.IDENTITY);

    private RoadsApi() {
    }

    public static PendingResult<SnappedPoint[]> snapToRoads(GeoApiContext context, LatLng ... path) {
        return context.get(SNAP_TO_ROADS_API_CONFIG, RoadsResponse.class, "path", StringJoin.join('|', path));
    }

    public static PendingResult<SnappedPoint[]> snapToRoads(GeoApiContext context, boolean interpolate, LatLng ... path) {
        return context.get(SNAP_TO_ROADS_API_CONFIG, RoadsResponse.class, "path", StringJoin.join('|', path), "interpolate", String.valueOf(interpolate));
    }

    public static PendingResult<SpeedLimit[]> speedLimits(GeoApiContext context, LatLng ... path) {
        return context.get(SPEEDS_API_CONFIG, SpeedsResponse.class, "path", StringJoin.join('|', path));
    }

    public static PendingResult<SpeedLimit[]> speedLimits(GeoApiContext context, String ... placeIds) {
        String[] placeParams = new String[2 * placeIds.length];
        int i = 0;
        for (String placeId : placeIds) {
            placeParams[i++] = "placeId";
            placeParams[i++] = placeId;
        }
        return context.get(SPEEDS_API_CONFIG, SpeedsResponse.class, placeParams);
    }

    public static PendingResult<SnappedSpeedLimitResponse> snappedSpeedLimits(GeoApiContext context, LatLng ... path) {
        return context.get(SPEEDS_API_CONFIG, CombinedResponse.class, "path", StringJoin.join('|', path));
    }

    public static PendingResult<SnappedPoint[]> nearestRoads(GeoApiContext context, LatLng ... points) {
        return context.get(NEAREST_ROADS_API_CONFIG, RoadsResponse.class, "points", StringJoin.join('|', points));
    }

    private static class CombinedResponse
    implements ApiResponse<SnappedSpeedLimitResponse> {
        private SnappedPoint[] snappedPoints;
        private SpeedLimit[] speedLimits;
        private ApiError error;

        private CombinedResponse() {
        }

        @Override
        public boolean successful() {
            return this.error == null;
        }

        @Override
        public SnappedSpeedLimitResponse getResult() {
            SnappedSpeedLimitResponse response = new SnappedSpeedLimitResponse();
            response.snappedPoints = this.snappedPoints;
            response.speedLimits = this.speedLimits;
            return response;
        }

        @Override
        public ApiException getError() {
            return ApiException.from(this.error.status, this.error.message);
        }
    }

    private static class SpeedsResponse
    implements ApiResponse<SpeedLimit[]> {
        private SpeedLimit[] speedLimits;
        private ApiError error;

        private SpeedsResponse() {
        }

        @Override
        public boolean successful() {
            return this.error == null;
        }

        @Override
        public SpeedLimit[] getResult() {
            return this.speedLimits;
        }

        @Override
        public ApiException getError() {
            return ApiException.from(this.error.status, this.error.message);
        }
    }

    private static class RoadsResponse
    implements ApiResponse<SnappedPoint[]> {
        private SnappedPoint[] snappedPoints;
        private ApiError error;

        private RoadsResponse() {
        }

        @Override
        public boolean successful() {
            return this.error == null;
        }

        @Override
        public SnappedPoint[] getResult() {
            return this.snappedPoints;
        }

        @Override
        public ApiException getError() {
            return ApiException.from(this.error.status, this.error.message);
        }
    }
}

