/*
 * Decompiled with CFR 0.152.
 */
package com.google.maps.model;

import com.google.maps.model.AddressComponent;
import com.google.maps.model.AddressType;
import com.google.maps.model.Geometry;
import com.google.maps.model.OpeningHours;
import com.google.maps.model.Photo;
import com.google.maps.model.PlaceIdScope;
import com.google.maps.model.PlusCode;
import com.google.maps.model.PriceLevel;
import java.io.Serializable;
import java.net.URL;
import java.util.Arrays;
import org.joda.time.Instant;

public class PlaceDetails
implements Serializable {
    private static final long serialVersionUID = 1L;
    public AddressComponent[] addressComponents;
    public String adrAddress;
    public String formattedAddress;
    public String formattedPhoneNumber;
    public Geometry geometry;
    public URL icon;
    public String internationalPhoneNumber;
    public String name;
    public OpeningHours openingHours;
    public Photo[] photos;
    public String placeId;
    public PlaceIdScope scope;
    public PlusCode plusCode;
    public boolean permanentlyClosed;
    public AlternatePlaceIds[] altIds;
    public PriceLevel priceLevel;
    public float rating;
    public Review[] reviews;
    public AddressType[] types;
    public URL url;
    public int utcOffset;
    public String vicinity;
    public URL website;
    public String[] htmlAttributions;

    public String toString() {
        StringBuilder sb = new StringBuilder("[PlaceDetails: ");
        sb.append("\"").append(this.name).append("\"");
        sb.append(" ").append(this.placeId).append(" (").append((Object)this.scope).append(")");
        sb.append(" address=\"").append(this.formattedAddress).append("\"");
        sb.append(" geometry=").append(this.geometry);
        if (this.vicinity != null) {
            sb.append(", vicinity=").append(this.vicinity);
        }
        if (this.types != null && this.types.length > 0) {
            sb.append(", types=").append(Arrays.toString(this.types));
        }
        if (this.altIds != null && this.altIds.length > 0) {
            sb.append(", altIds=").append(Arrays.toString(this.altIds));
        }
        if (this.formattedPhoneNumber != null) {
            sb.append(", phone=").append(this.formattedPhoneNumber);
        }
        if (this.internationalPhoneNumber != null) {
            sb.append(", internationalPhoneNumber=").append(this.internationalPhoneNumber);
        }
        if (this.url != null) {
            sb.append(", url=").append(this.url);
        }
        if (this.website != null) {
            sb.append(", website=").append(this.website);
        }
        if (this.icon != null) {
            sb.append(", icon");
        }
        if (this.openingHours != null) {
            sb.append(", openingHours");
            sb.append(", utcOffset=").append(this.utcOffset);
        }
        if (this.priceLevel != null) {
            sb.append(", priceLevel=").append(this.priceLevel);
        }
        sb.append(", rating=").append(this.rating);
        if (this.permanentlyClosed) {
            sb.append(", permanentlyClosed");
        }
        if (this.photos != null && this.photos.length > 0) {
            sb.append(", ").append(this.photos.length).append(" photos");
        }
        if (this.reviews != null && this.reviews.length > 0) {
            sb.append(", ").append(this.reviews.length).append(" reviews");
        }
        if (this.htmlAttributions != null && this.htmlAttributions.length > 0) {
            sb.append(", ").append(this.htmlAttributions.length).append(" htmlAttributions");
        }
        sb.append("]");
        return sb.toString();
    }

    public static class Review
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public AspectRating[] aspects;
        public String authorName;
        public URL authorUrl;
        public String language;
        public String profilePhotoUrl;
        public int rating;
        public String relativeTimeDescription;
        public String text;
        public Instant time;

        public static class AspectRating
        implements Serializable {
            private static final long serialVersionUID = 1L;
            public RatingType type;
            public int rating;

            public static enum RatingType {
                APPEAL,
                ATMOSPHERE,
                DECOR,
                FACILITIES,
                FOOD,
                OVERALL,
                QUALITY,
                SERVICE,
                UNKNOWN;

            }
        }
    }

    public static class AlternatePlaceIds
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public String placeId;
        public PlaceIdScope scope;

        public String toString() {
            return String.format("%s (%s)", new Object[]{this.placeId, this.scope});
        }
    }
}

