/*
 * Decompiled with CFR 0.152.
 */
package com.google.maps;

import com.google.maps.DirectionsApi;
import com.google.maps.GeoApiContext;
import com.google.maps.PendingResultBase;
import com.google.maps.internal.StringJoin;
import com.google.maps.model.DirectionsResult;
import com.google.maps.model.LatLng;
import com.google.maps.model.TrafficModel;
import com.google.maps.model.TransitMode;
import com.google.maps.model.TransitRoutingPreference;
import com.google.maps.model.TravelMode;
import com.google.maps.model.Unit;
import java.util.Objects;
import org.joda.time.ReadableInstant;

public class DirectionsApiRequest
extends PendingResultBase<DirectionsResult, DirectionsApiRequest, DirectionsApi.Response> {
    protected boolean optimizeWaypoints;
    protected Waypoint[] waypoints;

    public DirectionsApiRequest(GeoApiContext context) {
        super(context, DirectionsApi.API_CONFIG, DirectionsApi.Response.class);
    }

    @Override
    protected void validateRequest() {
        if (!this.params().containsKey("origin")) {
            throw new IllegalArgumentException("Request must contain 'origin'");
        }
        if (!this.params().containsKey("destination")) {
            throw new IllegalArgumentException("Request must contain 'destination'");
        }
        if (this.params().containsKey("arrival_time") && this.params().containsKey("departure_time")) {
            throw new IllegalArgumentException("Transit request must not contain both a departureTime and an arrivalTime");
        }
        if (this.params().containsKey("traffic_model") && !this.params().containsKey("departure_time")) {
            throw new IllegalArgumentException("Specifying a traffic model requires that departure time be provided.");
        }
    }

    public DirectionsApiRequest origin(String origin) {
        return (DirectionsApiRequest)this.param("origin", origin);
    }

    public DirectionsApiRequest destination(String destination) {
        return (DirectionsApiRequest)this.param("destination", destination);
    }

    public DirectionsApiRequest origin(LatLng origin) {
        return this.origin(origin.toString());
    }

    public DirectionsApiRequest destination(LatLng destination) {
        return this.destination(destination.toString());
    }

    public DirectionsApiRequest mode(TravelMode mode) {
        return (DirectionsApiRequest)this.param("mode", mode);
    }

    public DirectionsApiRequest avoid(DirectionsApi.RouteRestriction ... restrictions) {
        return (DirectionsApiRequest)this.param("avoid", StringJoin.join('|', restrictions));
    }

    public DirectionsApiRequest units(Unit units) {
        return (DirectionsApiRequest)this.param("units", units);
    }

    public DirectionsApiRequest region(String region) {
        return (DirectionsApiRequest)this.param("region", region);
    }

    public DirectionsApiRequest arrivalTime(ReadableInstant time) {
        return (DirectionsApiRequest)this.param("arrival_time", Long.toString(time.getMillis() / 1000L));
    }

    public DirectionsApiRequest departureTime(ReadableInstant time) {
        return (DirectionsApiRequest)this.param("departure_time", Long.toString(time.getMillis() / 1000L));
    }

    public DirectionsApiRequest waypoints(Waypoint ... waypoints) {
        if (waypoints == null || waypoints.length == 0) {
            this.waypoints = new Waypoint[0];
            this.param("waypoints", "");
            return this;
        }
        this.waypoints = waypoints;
        String[] waypointStrs = new String[waypoints.length];
        for (int i = 0; i < waypoints.length; ++i) {
            waypointStrs[i] = waypoints[i].toString();
        }
        this.param("waypoints", (this.optimizeWaypoints ? "optimize:true|" : "") + StringJoin.join('|', waypointStrs));
        return this;
    }

    public DirectionsApiRequest waypoints(String ... waypoints) {
        Waypoint[] objWaypoints = new Waypoint[waypoints.length];
        for (int i = 0; i < waypoints.length; ++i) {
            objWaypoints[i] = new Waypoint(waypoints[i]);
        }
        return this.waypoints(objWaypoints);
    }

    public DirectionsApiRequest waypoints(LatLng ... waypoints) {
        Waypoint[] objWaypoints = new Waypoint[waypoints.length];
        for (int i = 0; i < waypoints.length; ++i) {
            objWaypoints[i] = new Waypoint(waypoints[i]);
        }
        return this.waypoints(objWaypoints);
    }

    public DirectionsApiRequest optimizeWaypoints(boolean optimize) {
        this.optimizeWaypoints = optimize;
        if (this.waypoints != null) {
            return this.waypoints(this.waypoints);
        }
        return this;
    }

    public DirectionsApiRequest alternatives(boolean alternateRoutes) {
        if (alternateRoutes) {
            return (DirectionsApiRequest)this.param("alternatives", "true");
        }
        return (DirectionsApiRequest)this.param("alternatives", "false");
    }

    public DirectionsApiRequest transitMode(TransitMode ... transitModes) {
        return (DirectionsApiRequest)this.param("transit_mode", StringJoin.join('|', transitModes));
    }

    public DirectionsApiRequest transitRoutingPreference(TransitRoutingPreference pref) {
        return (DirectionsApiRequest)this.param("transit_routing_preference", pref);
    }

    public DirectionsApiRequest trafficModel(TrafficModel trafficModel) {
        return (DirectionsApiRequest)this.param("traffic_model", trafficModel);
    }

    public static class Waypoint {
        private String location;
        private boolean isStopover;

        public Waypoint(String location) {
            this(location, true);
        }

        public Waypoint(String location, boolean isStopover) {
            Objects.requireNonNull(location, "address may not be null");
            this.location = location;
            this.isStopover = isStopover;
        }

        public Waypoint(LatLng location) {
            this(location, true);
        }

        public Waypoint(LatLng location, boolean isStopover) {
            Objects.requireNonNull(location, "location may not be null");
            this.location = location.toString();
            this.isStopover = isStopover;
        }

        public String toString() {
            if (this.isStopover) {
                return this.location;
            }
            return "via:" + this.location;
        }
    }
}

