/*
 * Decompiled with CFR 0.152.
 */
package com.google.maps.internal;

import com.google.gson.FieldNamingPolicy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonSyntaxException;
import com.google.maps.GeolocationApi;
import com.google.maps.ImageResult;
import com.google.maps.PendingResult;
import com.google.maps.errors.ApiException;
import com.google.maps.internal.ApiResponse;
import com.google.maps.internal.DayOfWeekAdapter;
import com.google.maps.internal.DistanceAdapter;
import com.google.maps.internal.DurationAdapter;
import com.google.maps.internal.ExceptionsAllowedToRetry;
import com.google.maps.internal.FareAdapter;
import com.google.maps.internal.GeolocationResponseAdapter;
import com.google.maps.internal.InstantAdapter;
import com.google.maps.internal.LatLngAdapter;
import com.google.maps.internal.LocalTimeAdapter;
import com.google.maps.internal.PriceLevelAdapter;
import com.google.maps.internal.SafeEnumAdapter;
import com.google.maps.internal.ZonedDateTimeAdapter;
import com.google.maps.metrics.RequestMetrics;
import com.google.maps.model.AddressComponentType;
import com.google.maps.model.AddressType;
import com.google.maps.model.Distance;
import com.google.maps.model.Duration;
import com.google.maps.model.Fare;
import com.google.maps.model.LatLng;
import com.google.maps.model.LocationType;
import com.google.maps.model.OpeningHours;
import com.google.maps.model.PlaceDetails;
import com.google.maps.model.PriceLevel;
import com.google.maps.model.TravelMode;
import com.google.maps.model.VehicleType;
import java.io.IOException;
import java.time.Instant;
import java.time.LocalTime;
import java.time.ZonedDateTime;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OkHttpPendingResult<T, R extends ApiResponse<T>>
implements PendingResult<T>,
Callback {
    private final Request request;
    private final OkHttpClient client;
    private final Class<R> responseClass;
    private final FieldNamingPolicy fieldNamingPolicy;
    private final Integer maxRetries;
    private final RequestMetrics metrics;
    private Call call;
    private PendingResult.Callback<T> callback;
    private long errorTimeOut;
    private int retryCounter = 0;
    private long cumulativeSleepTime = 0L;
    private ExceptionsAllowedToRetry exceptionsAllowedToRetry;
    private static final Logger LOG = LoggerFactory.getLogger((String)OkHttpPendingResult.class.getName());
    private static final List<Integer> RETRY_ERROR_CODES = Arrays.asList(500, 503, 504);

    public OkHttpPendingResult(Request request, OkHttpClient client, Class<R> responseClass, FieldNamingPolicy fieldNamingPolicy, long errorTimeOut, Integer maxRetries, ExceptionsAllowedToRetry exceptionsAllowedToRetry, RequestMetrics metrics) {
        this.request = request;
        this.client = client;
        this.responseClass = responseClass;
        this.fieldNamingPolicy = fieldNamingPolicy;
        this.errorTimeOut = errorTimeOut;
        this.maxRetries = maxRetries;
        this.exceptionsAllowedToRetry = exceptionsAllowedToRetry;
        this.metrics = metrics;
        metrics.startNetwork();
        this.call = client.newCall(request);
    }

    @Override
    public void setCallback(PendingResult.Callback<T> callback) {
        this.callback = callback;
        this.call.enqueue((Callback)this);
    }

    @Override
    public T await() throws ApiException, IOException, InterruptedException {
        if (this.retryCounter > 0) {
            double delaySecs = 0.5 * Math.pow(1.5, this.retryCounter - 1);
            long delayMillis = (long)(delaySecs * (Math.random() + 0.5) * 1000.0);
            LOG.debug(String.format("Sleeping between errors for %dms (retry #%d, already slept %dms)", delayMillis, this.retryCounter, this.cumulativeSleepTime));
            this.cumulativeSleepTime += delayMillis;
            try {
                Thread.sleep(delayMillis);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        final ArrayBlockingQueue waiter = new ArrayBlockingQueue(1);
        final OkHttpPendingResult parent = this;
        this.call.enqueue(new Callback(){

            public void onFailure(Call call, IOException e) {
                OkHttpPendingResult.this.metrics.endNetwork();
                waiter.add(new QueuedResponse(parent, e));
            }

            public void onResponse(Call call, Response response) throws IOException {
                OkHttpPendingResult.this.metrics.endNetwork();
                waiter.add(new QueuedResponse(parent, response));
            }
        });
        QueuedResponse r = (QueuedResponse)waiter.take();
        if (r.response != null) {
            return this.parseResponse(r.request, r.response);
        }
        this.metrics.endRequest(r.e, 0, this.retryCounter);
        throw r.e;
    }

    @Override
    public T awaitIgnoreError() {
        try {
            return this.await();
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public void cancel() {
        this.call.cancel();
    }

    public void onFailure(Call call, IOException ioe) {
        this.metrics.endNetwork();
        if (this.callback != null) {
            this.metrics.endRequest(ioe, 0, this.retryCounter);
            this.callback.onFailure(ioe);
        }
    }

    public void onResponse(Call call, Response response) throws IOException {
        this.metrics.endNetwork();
        if (this.callback != null) {
            try {
                this.callback.onResult(this.parseResponse(this, response));
            }
            catch (Exception e) {
                this.callback.onFailure(e);
            }
        }
    }

    private T parseResponse(OkHttpPendingResult<T, R> request, Response response) throws ApiException, InterruptedException, IOException {
        try {
            T result = this.parseResponseInternal(request, response);
            this.metrics.endRequest(null, response.code(), this.retryCounter);
            return result;
        }
        catch (Exception e) {
            this.metrics.endRequest(e, response.code(), this.retryCounter);
            throw e;
        }
    }

    private T parseResponseInternal(OkHttpPendingResult<T, R> request, Response response) throws ApiException, InterruptedException, IOException {
        ApiResponse resp;
        byte[] bytes;
        if (this.shouldRetry(response)) {
            response.close();
            return super.retry();
        }
        try (ResponseBody body = response.body();){
            bytes = body.bytes();
        }
        String contentType = response.header("Content-Type");
        if (contentType != null && contentType.startsWith("image") && this.responseClass == ImageResult.Response.class && response.code() == 200) {
            ImageResult result = new ImageResult(contentType, bytes);
            return (T)result;
        }
        Gson gson = new GsonBuilder().registerTypeAdapter(ZonedDateTime.class, (Object)new ZonedDateTimeAdapter()).registerTypeAdapter(Distance.class, (Object)new DistanceAdapter()).registerTypeAdapter(Duration.class, (Object)new DurationAdapter()).registerTypeAdapter(Fare.class, (Object)new FareAdapter()).registerTypeAdapter(LatLng.class, (Object)new LatLngAdapter()).registerTypeAdapter(AddressComponentType.class, new SafeEnumAdapter<AddressComponentType>(AddressComponentType.UNKNOWN)).registerTypeAdapter(AddressType.class, new SafeEnumAdapter<AddressType>(AddressType.UNKNOWN)).registerTypeAdapter(TravelMode.class, new SafeEnumAdapter<TravelMode>(TravelMode.UNKNOWN)).registerTypeAdapter(LocationType.class, new SafeEnumAdapter<LocationType>(LocationType.UNKNOWN)).registerTypeAdapter(PlaceDetails.Review.AspectRating.RatingType.class, new SafeEnumAdapter<PlaceDetails.Review.AspectRating.RatingType>(PlaceDetails.Review.AspectRating.RatingType.UNKNOWN)).registerTypeAdapter(VehicleType.class, new SafeEnumAdapter<VehicleType>(VehicleType.OTHER)).registerTypeAdapter(OpeningHours.Period.OpenClose.DayOfWeek.class, (Object)new DayOfWeekAdapter()).registerTypeAdapter(PriceLevel.class, (Object)new PriceLevelAdapter()).registerTypeAdapter(Instant.class, (Object)new InstantAdapter()).registerTypeAdapter(LocalTime.class, (Object)new LocalTimeAdapter()).registerTypeAdapter(GeolocationApi.Response.class, (Object)new GeolocationResponseAdapter()).setFieldNamingPolicy(this.fieldNamingPolicy).create();
        try {
            resp = (ApiResponse)gson.fromJson(new String(bytes, "utf8"), this.responseClass);
        }
        catch (JsonSyntaxException e) {
            if (!response.isSuccessful()) {
                throw new IOException(String.format("Server Error: %d %s", response.code(), response.message()));
            }
            throw e;
        }
        if (resp.successful()) {
            return resp.getResult();
        }
        ApiException e = resp.getError();
        if (this.shouldRetry(e)) {
            return super.retry();
        }
        throw e;
    }

    private T retry() throws ApiException, InterruptedException, IOException {
        ++this.retryCounter;
        LOG.info("Retrying request. Retry #" + this.retryCounter);
        this.metrics.startNetwork();
        this.call = this.client.newCall(this.request);
        return this.await();
    }

    private boolean shouldRetry(Response response) {
        return RETRY_ERROR_CODES.contains(response.code()) && this.cumulativeSleepTime < this.errorTimeOut && (this.maxRetries == null || this.retryCounter < this.maxRetries);
    }

    private boolean shouldRetry(ApiException exception) {
        return this.exceptionsAllowedToRetry.contains(exception.getClass()) && this.cumulativeSleepTime < this.errorTimeOut && (this.maxRetries == null || this.retryCounter < this.maxRetries);
    }

    private class QueuedResponse {
        private final OkHttpPendingResult<T, R> request;
        private final Response response;
        private final IOException e;

        public QueuedResponse(OkHttpPendingResult<T, R> request, Response response) {
            this.request = request;
            this.response = response;
            this.e = null;
        }

        public QueuedResponse(OkHttpPendingResult<T, R> request, IOException e) {
            this.request = request;
            this.response = null;
            this.e = e;
        }
    }
}

