/*
 * Decompiled with CFR 0.152.
 */
package com.google.maps.model;

import java.io.Serializable;
import java.time.LocalTime;
import java.util.Arrays;

public class OpeningHours
implements Serializable {
    private static final long serialVersionUID = 1L;
    public Boolean openNow;
    public Period[] periods;
    public String[] weekdayText;
    public Boolean permanentlyClosed;

    public String toString() {
        StringBuilder sb = new StringBuilder("[OpeningHours:");
        if (this.permanentlyClosed != null && this.permanentlyClosed.booleanValue()) {
            sb.append(" permanentlyClosed");
        }
        if (this.openNow != null && this.openNow.booleanValue()) {
            sb.append(" openNow");
        }
        sb.append(" ").append(Arrays.toString(this.periods));
        return sb.toString();
    }

    public static class Period
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public OpenClose open;
        public OpenClose close;

        public String toString() {
            return String.format("%s - %s", this.open, this.close);
        }

        public static class OpenClose
        implements Serializable {
            private static final long serialVersionUID = 1L;
            public DayOfWeek day;
            public LocalTime time;

            public String toString() {
                return String.format("%s %s", new Object[]{this.day, this.time});
            }

            public static enum DayOfWeek {
                SUNDAY("Sunday"),
                MONDAY("Monday"),
                TUESDAY("Tuesday"),
                WEDNESDAY("Wednesday"),
                THURSDAY("Thursday"),
                FRIDAY("Friday"),
                SATURDAY("Saturday"),
                UNKNOWN("Unknown");

                private final String name;

                private DayOfWeek(String name) {
                    this.name = name;
                }

                public String getName() {
                    return this.name;
                }
            }
        }
    }
}

