/*
 * Decompiled with CFR 0.152.
 */
package com.google.maps.internal;

import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import com.google.maps.GeolocationApi;
import com.google.maps.internal.LatLngAdapter;
import java.io.IOException;

public class GeolocationResponseAdapter
extends TypeAdapter<GeolocationApi.Response> {
    public GeolocationApi.Response read(JsonReader reader) throws IOException {
        if (reader.peek() == JsonToken.NULL) {
            reader.nextNull();
            return null;
        }
        GeolocationApi.Response response = new GeolocationApi.Response();
        LatLngAdapter latLngAdapter = new LatLngAdapter();
        reader.beginObject();
        while (reader.hasNext()) {
            String name = reader.nextName();
            if (name.equals("location")) {
                response.location = latLngAdapter.read(reader);
                continue;
            }
            if (name.equals("accuracy")) {
                response.accuracy = reader.nextDouble();
                continue;
            }
            if (!name.equals("error")) continue;
            reader.beginObject();
            while (reader.hasNext()) {
                String errName = reader.nextName();
                if (errName.equals("code")) {
                    response.code = reader.nextInt();
                    continue;
                }
                if (errName.equals("message")) {
                    response.message = reader.nextString();
                    continue;
                }
                if (!errName.equals("errors")) continue;
                reader.beginArray();
                while (reader.hasNext()) {
                    reader.beginObject();
                    while (reader.hasNext()) {
                        errName = reader.nextName();
                        if (errName.equals("reason")) {
                            response.reason = reader.nextString();
                            continue;
                        }
                        if (errName.equals("domain")) {
                            response.domain = reader.nextString();
                            continue;
                        }
                        if (errName.equals("debugInfo")) {
                            response.debugInfo = reader.nextString();
                            continue;
                        }
                        if (errName.equals("message")) {
                            reader.nextString();
                            continue;
                        }
                        if (errName.equals("location")) {
                            reader.nextString();
                            continue;
                        }
                        if (!errName.equals("locationType")) continue;
                        reader.nextString();
                    }
                    reader.endObject();
                }
                reader.endArray();
            }
            reader.endObject();
        }
        reader.endObject();
        return response;
    }

    public void write(JsonWriter out, GeolocationApi.Response value) throws IOException {
        throw new UnsupportedOperationException("Unimplemented method.");
    }
}

