/*
 * Decompiled with CFR 0.152.
 */
package com.google.maps;

import com.google.gson.FieldNamingPolicy;
import com.google.maps.GeoApiContext;
import com.google.maps.PendingResult;
import com.google.maps.internal.ApiResponse;
import com.google.maps.internal.ExceptionsAllowedToRetry;
import com.google.maps.internal.OkHttpPendingResult;
import com.google.maps.internal.RateLimitExecutorService;
import java.io.IOException;
import java.net.Proxy;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import okhttp3.Authenticator;
import okhttp3.Credentials;
import okhttp3.Dispatcher;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.Route;

public class OkHttpRequestHandler
implements GeoApiContext.RequestHandler {
    private static final MediaType JSON = MediaType.parse((String)"application/json; charset=utf-8");
    private final OkHttpClient client;
    private final ExecutorService executorService;

    OkHttpRequestHandler(OkHttpClient client, ExecutorService executorService) {
        this.client = client;
        this.executorService = executorService;
    }

    @Override
    public <T, R extends ApiResponse<T>> PendingResult<T> handle(String hostName, String url, String userAgent, String experienceIdHeaderValue, Class<R> clazz, FieldNamingPolicy fieldNamingPolicy, long errorTimeout, Integer maxRetries, ExceptionsAllowedToRetry exceptionsAllowedToRetry) {
        Request.Builder builder = new Request.Builder().get().header("User-Agent", userAgent);
        if (experienceIdHeaderValue != null) {
            builder = builder.header("X-Goog-Maps-Experience-ID", experienceIdHeaderValue);
        }
        Request req = builder.url(hostName + url).build();
        return new OkHttpPendingResult(req, this.client, clazz, fieldNamingPolicy, errorTimeout, maxRetries, exceptionsAllowedToRetry);
    }

    @Override
    public <T, R extends ApiResponse<T>> PendingResult<T> handlePost(String hostName, String url, String payload, String userAgent, String experienceIdHeaderValue, Class<R> clazz, FieldNamingPolicy fieldNamingPolicy, long errorTimeout, Integer maxRetries, ExceptionsAllowedToRetry exceptionsAllowedToRetry) {
        RequestBody body = RequestBody.create((MediaType)JSON, (String)payload);
        Request.Builder builder = new Request.Builder().post(body).header("User-Agent", userAgent);
        if (experienceIdHeaderValue != null) {
            builder = builder.header("X-Goog-Maps-Experience-ID", experienceIdHeaderValue);
        }
        Request req = builder.url(hostName + url).build();
        return new OkHttpPendingResult(req, this.client, clazz, fieldNamingPolicy, errorTimeout, maxRetries, exceptionsAllowedToRetry);
    }

    @Override
    public void shutdown() {
        this.executorService.shutdown();
        this.client.connectionPool().evictAll();
    }

    public static class Builder
    implements GeoApiContext.RequestHandler.Builder {
        private final OkHttpClient.Builder builder = new OkHttpClient.Builder();
        private final RateLimitExecutorService rateLimitExecutorService = new RateLimitExecutorService();
        private final Dispatcher dispatcher = new Dispatcher((ExecutorService)this.rateLimitExecutorService);

        public Builder() {
            this.builder.dispatcher(this.dispatcher);
        }

        @Override
        public Builder connectTimeout(long timeout, TimeUnit unit) {
            this.builder.connectTimeout(timeout, unit);
            return this;
        }

        @Override
        public Builder readTimeout(long timeout, TimeUnit unit) {
            this.builder.readTimeout(timeout, unit);
            return this;
        }

        @Override
        public Builder writeTimeout(long timeout, TimeUnit unit) {
            this.builder.writeTimeout(timeout, unit);
            return this;
        }

        @Override
        public Builder queriesPerSecond(int maxQps) {
            this.dispatcher.setMaxRequests(maxQps);
            this.dispatcher.setMaxRequestsPerHost(maxQps);
            this.rateLimitExecutorService.setQueriesPerSecond(maxQps);
            return this;
        }

        @Override
        public Builder proxy(Proxy proxy) {
            this.builder.proxy(proxy);
            return this;
        }

        @Override
        public Builder proxyAuthentication(String proxyUserName, String proxyUserPassword) {
            final String userName = proxyUserName;
            final String password = proxyUserPassword;
            this.builder.proxyAuthenticator(new Authenticator(){

                public Request authenticate(Route route, Response response) throws IOException {
                    String credential = Credentials.basic((String)userName, (String)password);
                    return response.request().newBuilder().header("Proxy-Authorization", credential).build();
                }
            });
            return this;
        }

        public OkHttpClient.Builder okHttpClientBuilder() {
            return this.builder;
        }

        @Override
        public GeoApiContext.RequestHandler build() {
            OkHttpClient client = this.builder.build();
            return new OkHttpRequestHandler(client, this.rateLimitExecutorService);
        }
    }
}

