/*
 * Decompiled with CFR 0.152.
 */
package com.google.maps.internal;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class RateLimitExecutorService
implements ExecutorService,
Runnable {
    private static final Logger LOG = Logger.getLogger(RateLimitExecutorService.class.getName());
    private static final int DEFAULT_QUERIES_PER_SECOND = 10;
    private static final int SECOND = 1000;
    private static final int HALF_SECOND = 500;
    private final ExecutorService delegate = new ThreadPoolExecutor(Runtime.getRuntime().availableProcessors(), Integer.MAX_VALUE, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), RateLimitExecutorService.threadFactory("Rate Limited Dispatcher", true));
    private final BlockingQueue<Runnable> queue = new LinkedBlockingQueue<Runnable>();
    private volatile int queriesPerSecond;
    private volatile int minimumDelay;
    private LinkedList<Long> sentTimes = new LinkedList();
    private long lastSentTime = 0L;

    public RateLimitExecutorService() {
        this.setQueriesPerSecond(10);
        Thread delayThread = new Thread(this);
        delayThread.setDaemon(true);
        delayThread.setName("RateLimitExecutorDelayThread");
        delayThread.start();
    }

    public void setQueriesPerSecond(int maxQps) {
        this.queriesPerSecond = maxQps;
        this.minimumDelay = 500 / this.queriesPerSecond;
    }

    public void setQueriesPerSecond(int maxQps, int minimumInterval) {
        this.queriesPerSecond = maxQps;
        this.minimumDelay = minimumInterval;
        LOG.log(Level.INFO, "Configuring rate limit at QPS: " + maxQps + ", minimum delay " + minimumInterval + "ms between requests");
    }

    @Override
    public void run() {
        try {
            while (!this.delegate.isShutdown()) {
                long now = System.currentTimeMillis();
                long oneSecondAgo = now - 1000L;
                Runnable r = this.queue.take();
                long requiredSeparationDelay = this.lastSentTime + (long)this.minimumDelay - now;
                if (requiredSeparationDelay > 0L) {
                    Thread.sleep(requiredSeparationDelay);
                }
                while (this.sentTimes.size() > 0 && this.sentTimes.peekFirst() < oneSecondAgo) {
                    this.sentTimes.pop();
                }
                long delay = 0L;
                if (this.sentTimes.size() > 0) {
                    delay = this.sentTimes.peekFirst() + 1000L - System.currentTimeMillis();
                }
                if (this.sentTimes.size() < this.queriesPerSecond || delay <= 0L) {
                    this.delegate.execute(r);
                    this.lastSentTime = now;
                    this.sentTimes.add(this.lastSentTime);
                    continue;
                }
                this.queue.add(r);
                Thread.sleep(delay);
            }
        }
        catch (InterruptedException ie) {
            LOG.log(Level.INFO, "Interrupted", ie);
        }
    }

    private static ThreadFactory threadFactory(final String name, final boolean daemon) {
        return new ThreadFactory(){

            @Override
            public Thread newThread(Runnable runnable) {
                Thread result = new Thread(runnable, name);
                result.setDaemon(daemon);
                return result;
            }
        };
    }

    @Override
    public void execute(Runnable runnable) {
        this.queue.add(runnable);
    }

    @Override
    public void shutdown() {
        this.delegate.shutdown();
    }

    @Override
    public List<Runnable> shutdownNow() {
        return this.delegate.shutdownNow();
    }

    @Override
    public boolean isShutdown() {
        return this.delegate.isShutdown();
    }

    @Override
    public boolean isTerminated() {
        return this.delegate.isTerminated();
    }

    @Override
    public boolean awaitTermination(long l, TimeUnit timeUnit) throws InterruptedException {
        return this.delegate.awaitTermination(l, timeUnit);
    }

    @Override
    public <T> Future<T> submit(Callable<T> tCallable) {
        return this.delegate.submit(tCallable);
    }

    @Override
    public <T> Future<T> submit(Runnable runnable, T t) {
        return this.delegate.submit(runnable, t);
    }

    @Override
    public Future<?> submit(Runnable runnable) {
        return this.delegate.submit(runnable);
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> callables) throws InterruptedException {
        return this.delegate.invokeAll(callables);
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> callables, long l, TimeUnit timeUnit) throws InterruptedException {
        return this.delegate.invokeAll(callables, l, timeUnit);
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> callables) throws InterruptedException, ExecutionException {
        return this.delegate.invokeAny(callables);
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> callables, long l, TimeUnit timeUnit) throws InterruptedException, ExecutionException, TimeoutException {
        return this.delegate.invokeAny(callables, l, timeUnit);
    }
}

