/*
 * Decompiled with CFR 0.152.
 */
package com.google.maps.model;

import com.google.maps.internal.StringJoin;

public enum AddressType implements StringJoin.UrlValue
{
    STREET_ADDRESS("street_address"),
    ROUTE("route"),
    INTERSECTION("intersection"),
    POLITICAL("political"),
    COUNTRY("country"),
    ADMINISTRATIVE_AREA_LEVEL_1("administrative_area_level_1"),
    ADMINISTRATIVE_AREA_LEVEL_2("administrative_area_level_2"),
    ADMINISTRATIVE_AREA_LEVEL_3("administrative_area_level_3"),
    ADMINISTRATIVE_AREA_LEVEL_4("administrative_area_level_4"),
    ADMINISTRATIVE_AREA_LEVEL_5("administrative_area_level_5"),
    COLLOQUIAL_AREA("colloquial_area"),
    LOCALITY("locality"),
    SUBLOCALITY("sublocality"),
    SUBLOCALITY_LEVEL_1("sublocality_level_1"),
    SUBLOCALITY_LEVEL_2("sublocality_level_2"),
    SUBLOCALITY_LEVEL_3("sublocality_level_3"),
    SUBLOCALITY_LEVEL_4("sublocality_level_4"),
    SUBLOCALITY_LEVEL_5("sublocality_level_5"),
    NEIGHBORHOOD("neighborhood"),
    PREMISE("premise"),
    SUBPREMISE("subpremise"),
    POSTAL_CODE("postal_code"),
    NATURAL_FEATURE("natural_feature"),
    AIRPORT("airport"),
    UNIVERSITY("university"),
    PARK("park"),
    POINT_OF_INTEREST("point_of_interest"),
    ESTABLISHMENT("establishment"),
    BUS_STATION("bus_station"),
    TRAIN_STATION("train_station"),
    SUBWAY_STATION("subway_station"),
    TRANSIT_STATION("transit_station"),
    CHURCH("church"),
    FINANCE("finance"),
    POST_OFFICE("post_office"),
    PLACE_OF_WORSHIP("place_of_worship"),
    WARD("ward"),
    POSTAL_TOWN("postal_town"),
    UNKNOWN("unknown");

    private final String addressType;

    private AddressType(String addressType) {
        this.addressType = addressType;
    }

    public String toString() {
        return this.addressType;
    }

    public String toCanonicalLiteral() {
        return this.toString();
    }

    @Override
    public String toUrlValue() {
        if (this == UNKNOWN) {
            throw new UnsupportedOperationException("Shouldn't use AddressType.UNKNOWN in a request.");
        }
        return this.addressType;
    }
}

