/*
 * Decompiled with CFR 0.152.
 */
package com.google.maps;

import com.google.maps.GeoApiContext;
import com.google.maps.GeocodingApiRequest;
import com.google.maps.errors.ApiException;
import com.google.maps.internal.ApiResponse;
import com.google.maps.model.GeocodingResult;
import com.google.maps.model.LatLng;

public class GeocodingApi {
    private GeocodingApi() {
    }

    public static GeocodingApiRequest newRequest(GeoApiContext context) {
        return new GeocodingApiRequest(context);
    }

    public static GeocodingApiRequest geocode(GeoApiContext context, String address) {
        GeocodingApiRequest request = new GeocodingApiRequest(context);
        request.address(address);
        return request;
    }

    public static GeocodingApiRequest reverseGeocode(GeoApiContext context, LatLng location) {
        GeocodingApiRequest request = new GeocodingApiRequest(context);
        request.latlng(location);
        return request;
    }

    static class Response
    implements ApiResponse<GeocodingResult[]> {
        public String status;
        public String errorMessage;
        public GeocodingResult[] results;

        Response() {
        }

        @Override
        public boolean successful() {
            return "OK".equals(this.status) || "ZERO_RESULTS".equals(this.status);
        }

        @Override
        public GeocodingResult[] getResult() {
            return this.results;
        }

        @Override
        public ApiException getError() {
            if (this.successful()) {
                return null;
            }
            return ApiException.from(this.status, this.errorMessage);
        }
    }
}

