/*
 * Decompiled with CFR 0.152.
 */
package com.google.maps.routing.v2;

import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.rpc.ServerStreamingCallable;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.maps.routing.v2.ComputeRouteMatrixRequest;
import com.google.maps.routing.v2.ComputeRoutesRequest;
import com.google.maps.routing.v2.ComputeRoutesResponse;
import com.google.maps.routing.v2.RouteMatrixElement;
import com.google.maps.routing.v2.RoutesSettings;
import com.google.maps.routing.v2.stub.RoutesStub;
import com.google.maps.routing.v2.stub.RoutesStubSettings;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

public class RoutesClient
implements BackgroundResource {
    private final RoutesSettings settings;
    private final RoutesStub stub;

    public static final RoutesClient create() throws IOException {
        return RoutesClient.create(RoutesSettings.newBuilder().build());
    }

    public static final RoutesClient create(RoutesSettings settings) throws IOException {
        return new RoutesClient(settings);
    }

    public static final RoutesClient create(RoutesStub stub) {
        return new RoutesClient(stub);
    }

    protected RoutesClient(RoutesSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((RoutesStubSettings)settings.getStubSettings()).createStub();
    }

    protected RoutesClient(RoutesStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final RoutesSettings getSettings() {
        return this.settings;
    }

    public RoutesStub getStub() {
        return this.stub;
    }

    public final ComputeRoutesResponse computeRoutes(ComputeRoutesRequest request) {
        return (ComputeRoutesResponse)this.computeRoutesCallable().call((Object)request);
    }

    public final UnaryCallable<ComputeRoutesRequest, ComputeRoutesResponse> computeRoutesCallable() {
        return this.stub.computeRoutesCallable();
    }

    public final ServerStreamingCallable<ComputeRouteMatrixRequest, RouteMatrixElement> computeRouteMatrixCallable() {
        return this.stub.computeRouteMatrixCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }
}

