/*
 * Decompiled with CFR 0.152.
 */
package com.google.maps.places.v1;

import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.maps.places.v1.GetPhotoMediaRequest;
import com.google.maps.places.v1.GetPlaceRequest;
import com.google.maps.places.v1.PhotoMedia;
import com.google.maps.places.v1.PhotoMediaName;
import com.google.maps.places.v1.Place;
import com.google.maps.places.v1.PlaceName;
import com.google.maps.places.v1.PlacesSettings;
import com.google.maps.places.v1.SearchNearbyRequest;
import com.google.maps.places.v1.SearchNearbyResponse;
import com.google.maps.places.v1.SearchTextRequest;
import com.google.maps.places.v1.SearchTextResponse;
import com.google.maps.places.v1.stub.PlacesStub;
import com.google.maps.places.v1.stub.PlacesStubSettings;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

public class PlacesClient
implements BackgroundResource {
    private final PlacesSettings settings;
    private final PlacesStub stub;

    public static final PlacesClient create() throws IOException {
        return PlacesClient.create(PlacesSettings.newBuilder().build());
    }

    public static final PlacesClient create(PlacesSettings settings) throws IOException {
        return new PlacesClient(settings);
    }

    public static final PlacesClient create(PlacesStub stub) {
        return new PlacesClient(stub);
    }

    protected PlacesClient(PlacesSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((PlacesStubSettings)settings.getStubSettings()).createStub();
    }

    protected PlacesClient(PlacesStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final PlacesSettings getSettings() {
        return this.settings;
    }

    public PlacesStub getStub() {
        return this.stub;
    }

    public final SearchNearbyResponse searchNearby(SearchNearbyRequest request) {
        return (SearchNearbyResponse)this.searchNearbyCallable().call((Object)request);
    }

    public final UnaryCallable<SearchNearbyRequest, SearchNearbyResponse> searchNearbyCallable() {
        return this.stub.searchNearbyCallable();
    }

    public final SearchTextResponse searchText(SearchTextRequest request) {
        return (SearchTextResponse)this.searchTextCallable().call((Object)request);
    }

    public final UnaryCallable<SearchTextRequest, SearchTextResponse> searchTextCallable() {
        return this.stub.searchTextCallable();
    }

    public final PhotoMedia getPhotoMedia(PhotoMediaName name) {
        GetPhotoMediaRequest request = GetPhotoMediaRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getPhotoMedia(request);
    }

    public final PhotoMedia getPhotoMedia(String name) {
        GetPhotoMediaRequest request = GetPhotoMediaRequest.newBuilder().setName(name).build();
        return this.getPhotoMedia(request);
    }

    public final PhotoMedia getPhotoMedia(GetPhotoMediaRequest request) {
        return (PhotoMedia)this.getPhotoMediaCallable().call((Object)request);
    }

    public final UnaryCallable<GetPhotoMediaRequest, PhotoMedia> getPhotoMediaCallable() {
        return this.stub.getPhotoMediaCallable();
    }

    public final Place getPlace(PlaceName name) {
        GetPlaceRequest request = GetPlaceRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getPlace(request);
    }

    public final Place getPlace(String name) {
        GetPlaceRequest request = GetPlaceRequest.newBuilder().setName(name).build();
        return this.getPlace(request);
    }

    public final Place getPlace(GetPlaceRequest request) {
        return (Place)this.getPlaceCallable().call((Object)request);
    }

    public final UnaryCallable<GetPlaceRequest, Place> getPlaceCallable() {
        return this.stub.getPlaceCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }
}

