/*
 * Decompiled with CFR 0.152.
 */
package com.google.maps.mapsplatformdatasets.v1alpha;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.maps.mapsplatformdatasets.v1alpha.CreateDatasetRequest;
import com.google.maps.mapsplatformdatasets.v1alpha.Dataset;
import com.google.maps.mapsplatformdatasets.v1alpha.DatasetName;
import com.google.maps.mapsplatformdatasets.v1alpha.DeleteDatasetRequest;
import com.google.maps.mapsplatformdatasets.v1alpha.DeleteDatasetVersionRequest;
import com.google.maps.mapsplatformdatasets.v1alpha.GetDatasetRequest;
import com.google.maps.mapsplatformdatasets.v1alpha.ListDatasetVersionsRequest;
import com.google.maps.mapsplatformdatasets.v1alpha.ListDatasetVersionsResponse;
import com.google.maps.mapsplatformdatasets.v1alpha.ListDatasetsRequest;
import com.google.maps.mapsplatformdatasets.v1alpha.ListDatasetsResponse;
import com.google.maps.mapsplatformdatasets.v1alpha.MapsPlatformDatasetsV1AlphaSettings;
import com.google.maps.mapsplatformdatasets.v1alpha.ProjectName;
import com.google.maps.mapsplatformdatasets.v1alpha.UpdateDatasetMetadataRequest;
import com.google.maps.mapsplatformdatasets.v1alpha.stub.MapsPlatformDatasetsV1AlphaStub;
import com.google.maps.mapsplatformdatasets.v1alpha.stub.MapsPlatformDatasetsV1AlphaStubSettings;
import com.google.protobuf.Empty;
import com.google.protobuf.FieldMask;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

@BetaApi
public class MapsPlatformDatasetsV1AlphaClient
implements BackgroundResource {
    private final MapsPlatformDatasetsV1AlphaSettings settings;
    private final MapsPlatformDatasetsV1AlphaStub stub;

    public static final MapsPlatformDatasetsV1AlphaClient create() throws IOException {
        return MapsPlatformDatasetsV1AlphaClient.create(MapsPlatformDatasetsV1AlphaSettings.newBuilder().build());
    }

    public static final MapsPlatformDatasetsV1AlphaClient create(MapsPlatformDatasetsV1AlphaSettings settings) throws IOException {
        return new MapsPlatformDatasetsV1AlphaClient(settings);
    }

    public static final MapsPlatformDatasetsV1AlphaClient create(MapsPlatformDatasetsV1AlphaStub stub) {
        return new MapsPlatformDatasetsV1AlphaClient(stub);
    }

    protected MapsPlatformDatasetsV1AlphaClient(MapsPlatformDatasetsV1AlphaSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((MapsPlatformDatasetsV1AlphaStubSettings)settings.getStubSettings()).createStub();
    }

    protected MapsPlatformDatasetsV1AlphaClient(MapsPlatformDatasetsV1AlphaStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final MapsPlatformDatasetsV1AlphaSettings getSettings() {
        return this.settings;
    }

    public MapsPlatformDatasetsV1AlphaStub getStub() {
        return this.stub;
    }

    public final Dataset createDataset(ProjectName parent, Dataset dataset) {
        CreateDatasetRequest request = CreateDatasetRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setDataset(dataset).build();
        return this.createDataset(request);
    }

    public final Dataset createDataset(String parent, Dataset dataset) {
        CreateDatasetRequest request = CreateDatasetRequest.newBuilder().setParent(parent).setDataset(dataset).build();
        return this.createDataset(request);
    }

    public final Dataset createDataset(CreateDatasetRequest request) {
        return (Dataset)this.createDatasetCallable().call((Object)request);
    }

    public final UnaryCallable<CreateDatasetRequest, Dataset> createDatasetCallable() {
        return this.stub.createDatasetCallable();
    }

    public final Dataset updateDatasetMetadata(Dataset dataset, FieldMask updateMask) {
        UpdateDatasetMetadataRequest request = UpdateDatasetMetadataRequest.newBuilder().setDataset(dataset).setUpdateMask(updateMask).build();
        return this.updateDatasetMetadata(request);
    }

    public final Dataset updateDatasetMetadata(UpdateDatasetMetadataRequest request) {
        return (Dataset)this.updateDatasetMetadataCallable().call((Object)request);
    }

    public final UnaryCallable<UpdateDatasetMetadataRequest, Dataset> updateDatasetMetadataCallable() {
        return this.stub.updateDatasetMetadataCallable();
    }

    public final Dataset getDataset(DatasetName name) {
        GetDatasetRequest request = GetDatasetRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getDataset(request);
    }

    public final Dataset getDataset(String name) {
        GetDatasetRequest request = GetDatasetRequest.newBuilder().setName(name).build();
        return this.getDataset(request);
    }

    public final Dataset getDataset(GetDatasetRequest request) {
        return (Dataset)this.getDatasetCallable().call((Object)request);
    }

    public final UnaryCallable<GetDatasetRequest, Dataset> getDatasetCallable() {
        return this.stub.getDatasetCallable();
    }

    public final ListDatasetVersionsPagedResponse listDatasetVersions(DatasetName name) {
        ListDatasetVersionsRequest request = ListDatasetVersionsRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.listDatasetVersions(request);
    }

    public final ListDatasetVersionsPagedResponse listDatasetVersions(String name) {
        ListDatasetVersionsRequest request = ListDatasetVersionsRequest.newBuilder().setName(name).build();
        return this.listDatasetVersions(request);
    }

    public final ListDatasetVersionsPagedResponse listDatasetVersions(ListDatasetVersionsRequest request) {
        return (ListDatasetVersionsPagedResponse)((Object)this.listDatasetVersionsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListDatasetVersionsRequest, ListDatasetVersionsPagedResponse> listDatasetVersionsPagedCallable() {
        return this.stub.listDatasetVersionsPagedCallable();
    }

    public final UnaryCallable<ListDatasetVersionsRequest, ListDatasetVersionsResponse> listDatasetVersionsCallable() {
        return this.stub.listDatasetVersionsCallable();
    }

    public final ListDatasetsPagedResponse listDatasets(ProjectName parent) {
        ListDatasetsRequest request = ListDatasetsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listDatasets(request);
    }

    public final ListDatasetsPagedResponse listDatasets(String parent) {
        ListDatasetsRequest request = ListDatasetsRequest.newBuilder().setParent(parent).build();
        return this.listDatasets(request);
    }

    public final ListDatasetsPagedResponse listDatasets(ListDatasetsRequest request) {
        return (ListDatasetsPagedResponse)((Object)this.listDatasetsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListDatasetsRequest, ListDatasetsPagedResponse> listDatasetsPagedCallable() {
        return this.stub.listDatasetsPagedCallable();
    }

    public final UnaryCallable<ListDatasetsRequest, ListDatasetsResponse> listDatasetsCallable() {
        return this.stub.listDatasetsCallable();
    }

    public final void deleteDataset(DatasetName name) {
        DeleteDatasetRequest request = DeleteDatasetRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        this.deleteDataset(request);
    }

    public final void deleteDataset(String name) {
        DeleteDatasetRequest request = DeleteDatasetRequest.newBuilder().setName(name).build();
        this.deleteDataset(request);
    }

    public final void deleteDataset(DeleteDatasetRequest request) {
        this.deleteDatasetCallable().call((Object)request);
    }

    public final UnaryCallable<DeleteDatasetRequest, Empty> deleteDatasetCallable() {
        return this.stub.deleteDatasetCallable();
    }

    public final void deleteDatasetVersion(DatasetName name) {
        DeleteDatasetVersionRequest request = DeleteDatasetVersionRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        this.deleteDatasetVersion(request);
    }

    public final void deleteDatasetVersion(String name) {
        DeleteDatasetVersionRequest request = DeleteDatasetVersionRequest.newBuilder().setName(name).build();
        this.deleteDatasetVersion(request);
    }

    public final void deleteDatasetVersion(DeleteDatasetVersionRequest request) {
        this.deleteDatasetVersionCallable().call((Object)request);
    }

    public final UnaryCallable<DeleteDatasetVersionRequest, Empty> deleteDatasetVersionCallable() {
        return this.stub.deleteDatasetVersionCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListDatasetsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListDatasetsRequest, ListDatasetsResponse, Dataset, ListDatasetsPage, ListDatasetsFixedSizeCollection> {
        private ListDatasetsFixedSizeCollection(List<ListDatasetsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListDatasetsFixedSizeCollection createEmptyCollection() {
            return new ListDatasetsFixedSizeCollection(null, 0);
        }

        protected ListDatasetsFixedSizeCollection createCollection(List<ListDatasetsPage> pages, int collectionSize) {
            return new ListDatasetsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListDatasetsPage
    extends AbstractPage<ListDatasetsRequest, ListDatasetsResponse, Dataset, ListDatasetsPage> {
        private ListDatasetsPage(PageContext<ListDatasetsRequest, ListDatasetsResponse, Dataset> context, ListDatasetsResponse response) {
            super(context, (Object)response);
        }

        private static ListDatasetsPage createEmptyPage() {
            return new ListDatasetsPage(null, null);
        }

        protected ListDatasetsPage createPage(PageContext<ListDatasetsRequest, ListDatasetsResponse, Dataset> context, ListDatasetsResponse response) {
            return new ListDatasetsPage(context, response);
        }

        public ApiFuture<ListDatasetsPage> createPageAsync(PageContext<ListDatasetsRequest, ListDatasetsResponse, Dataset> context, ApiFuture<ListDatasetsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListDatasetsPagedResponse
    extends AbstractPagedListResponse<ListDatasetsRequest, ListDatasetsResponse, Dataset, ListDatasetsPage, ListDatasetsFixedSizeCollection> {
        public static ApiFuture<ListDatasetsPagedResponse> createAsync(PageContext<ListDatasetsRequest, ListDatasetsResponse, Dataset> context, ApiFuture<ListDatasetsResponse> futureResponse) {
            ApiFuture<ListDatasetsPage> futurePage = ListDatasetsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListDatasetsPagedResponse((ListDatasetsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListDatasetsPagedResponse(ListDatasetsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListDatasetsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListDatasetVersionsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListDatasetVersionsRequest, ListDatasetVersionsResponse, Dataset, ListDatasetVersionsPage, ListDatasetVersionsFixedSizeCollection> {
        private ListDatasetVersionsFixedSizeCollection(List<ListDatasetVersionsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListDatasetVersionsFixedSizeCollection createEmptyCollection() {
            return new ListDatasetVersionsFixedSizeCollection(null, 0);
        }

        protected ListDatasetVersionsFixedSizeCollection createCollection(List<ListDatasetVersionsPage> pages, int collectionSize) {
            return new ListDatasetVersionsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListDatasetVersionsPage
    extends AbstractPage<ListDatasetVersionsRequest, ListDatasetVersionsResponse, Dataset, ListDatasetVersionsPage> {
        private ListDatasetVersionsPage(PageContext<ListDatasetVersionsRequest, ListDatasetVersionsResponse, Dataset> context, ListDatasetVersionsResponse response) {
            super(context, (Object)response);
        }

        private static ListDatasetVersionsPage createEmptyPage() {
            return new ListDatasetVersionsPage(null, null);
        }

        protected ListDatasetVersionsPage createPage(PageContext<ListDatasetVersionsRequest, ListDatasetVersionsResponse, Dataset> context, ListDatasetVersionsResponse response) {
            return new ListDatasetVersionsPage(context, response);
        }

        public ApiFuture<ListDatasetVersionsPage> createPageAsync(PageContext<ListDatasetVersionsRequest, ListDatasetVersionsResponse, Dataset> context, ApiFuture<ListDatasetVersionsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListDatasetVersionsPagedResponse
    extends AbstractPagedListResponse<ListDatasetVersionsRequest, ListDatasetVersionsResponse, Dataset, ListDatasetVersionsPage, ListDatasetVersionsFixedSizeCollection> {
        public static ApiFuture<ListDatasetVersionsPagedResponse> createAsync(PageContext<ListDatasetVersionsRequest, ListDatasetVersionsResponse, Dataset> context, ApiFuture<ListDatasetVersionsResponse> futureResponse) {
            ApiFuture<ListDatasetVersionsPage> futurePage = ListDatasetVersionsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListDatasetVersionsPagedResponse((ListDatasetVersionsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListDatasetVersionsPagedResponse(ListDatasetVersionsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListDatasetVersionsFixedSizeCollection.createEmptyCollection());
        }
    }
}

