/*
 * Decompiled with CFR 0.152.
 */
package com.google.maps.fleetengine.v1.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.ObsoleteApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.maps.fleetengine.v1.CreateVehicleRequest;
import com.google.maps.fleetengine.v1.GetVehicleRequest;
import com.google.maps.fleetengine.v1.ListVehiclesRequest;
import com.google.maps.fleetengine.v1.ListVehiclesResponse;
import com.google.maps.fleetengine.v1.SearchVehiclesRequest;
import com.google.maps.fleetengine.v1.SearchVehiclesResponse;
import com.google.maps.fleetengine.v1.UpdateVehicleAttributesRequest;
import com.google.maps.fleetengine.v1.UpdateVehicleAttributesResponse;
import com.google.maps.fleetengine.v1.UpdateVehicleRequest;
import com.google.maps.fleetengine.v1.Vehicle;
import com.google.maps.fleetengine.v1.VehicleServiceClient;
import com.google.maps.fleetengine.v1.stub.GrpcVehicleServiceStub;
import com.google.maps.fleetengine.v1.stub.VehicleServiceStub;
import java.io.IOException;
import java.time.Duration;
import java.util.Collection;
import java.util.List;
import java.util.Set;

public class VehicleServiceStubSettings
extends StubSettings<VehicleServiceStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").build();
    private final UnaryCallSettings<CreateVehicleRequest, Vehicle> createVehicleSettings;
    private final UnaryCallSettings<GetVehicleRequest, Vehicle> getVehicleSettings;
    private final UnaryCallSettings<UpdateVehicleRequest, Vehicle> updateVehicleSettings;
    private final UnaryCallSettings<UpdateVehicleAttributesRequest, UpdateVehicleAttributesResponse> updateVehicleAttributesSettings;
    private final PagedCallSettings<ListVehiclesRequest, ListVehiclesResponse, VehicleServiceClient.ListVehiclesPagedResponse> listVehiclesSettings;
    private final UnaryCallSettings<SearchVehiclesRequest, SearchVehiclesResponse> searchVehiclesSettings;
    private static final PagedListDescriptor<ListVehiclesRequest, ListVehiclesResponse, Vehicle> LIST_VEHICLES_PAGE_STR_DESC = new PagedListDescriptor<ListVehiclesRequest, ListVehiclesResponse, Vehicle>(){

        public String emptyToken() {
            return "";
        }

        public ListVehiclesRequest injectToken(ListVehiclesRequest payload, String token) {
            return ListVehiclesRequest.newBuilder((ListVehiclesRequest)payload).setPageToken(token).build();
        }

        public ListVehiclesRequest injectPageSize(ListVehiclesRequest payload, int pageSize) {
            return ListVehiclesRequest.newBuilder((ListVehiclesRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListVehiclesRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListVehiclesResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Vehicle> extractResources(ListVehiclesResponse payload) {
            return payload.getVehiclesList();
        }
    };
    private static final PagedListResponseFactory<ListVehiclesRequest, ListVehiclesResponse, VehicleServiceClient.ListVehiclesPagedResponse> LIST_VEHICLES_PAGE_STR_FACT = new PagedListResponseFactory<ListVehiclesRequest, ListVehiclesResponse, VehicleServiceClient.ListVehiclesPagedResponse>(){

        public ApiFuture<VehicleServiceClient.ListVehiclesPagedResponse> getFuturePagedResponse(UnaryCallable<ListVehiclesRequest, ListVehiclesResponse> callable, ListVehiclesRequest request, ApiCallContext context, ApiFuture<ListVehiclesResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_VEHICLES_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return VehicleServiceClient.ListVehiclesPagedResponse.createAsync((PageContext<ListVehiclesRequest, ListVehiclesResponse, Vehicle>)pageContext, futureResponse);
        }
    };

    public UnaryCallSettings<CreateVehicleRequest, Vehicle> createVehicleSettings() {
        return this.createVehicleSettings;
    }

    public UnaryCallSettings<GetVehicleRequest, Vehicle> getVehicleSettings() {
        return this.getVehicleSettings;
    }

    public UnaryCallSettings<UpdateVehicleRequest, Vehicle> updateVehicleSettings() {
        return this.updateVehicleSettings;
    }

    public UnaryCallSettings<UpdateVehicleAttributesRequest, UpdateVehicleAttributesResponse> updateVehicleAttributesSettings() {
        return this.updateVehicleAttributesSettings;
    }

    public PagedCallSettings<ListVehiclesRequest, ListVehiclesResponse, VehicleServiceClient.ListVehiclesPagedResponse> listVehiclesSettings() {
        return this.listVehiclesSettings;
    }

    public UnaryCallSettings<SearchVehiclesRequest, SearchVehiclesResponse> searchVehiclesSettings() {
        return this.searchVehiclesSettings;
    }

    public VehicleServiceStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(GrpcTransportChannel.getGrpcTransportName())) {
            return GrpcVehicleServiceStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public String getServiceName() {
        return "fleetengine";
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    @ObsoleteApi(value="Use getEndpoint() instead")
    public static String getDefaultEndpoint() {
        return "fleetengine.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "fleetengine.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return InstantiatingGrpcChannelProvider.newBuilder().setMaxInboundMessageSize(Integer.valueOf(Integer.MAX_VALUE));
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return VehicleServiceStubSettings.defaultGrpcTransportProviderBuilder().build();
    }

    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(VehicleServiceStubSettings.class)).setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion());
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected VehicleServiceStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.createVehicleSettings = settingsBuilder.createVehicleSettings().build();
        this.getVehicleSettings = settingsBuilder.getVehicleSettings().build();
        this.updateVehicleSettings = settingsBuilder.updateVehicleSettings().build();
        this.updateVehicleAttributesSettings = settingsBuilder.updateVehicleAttributesSettings().build();
        this.listVehiclesSettings = settingsBuilder.listVehiclesSettings().build();
        this.searchVehiclesSettings = settingsBuilder.searchVehiclesSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<VehicleServiceStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final UnaryCallSettings.Builder<CreateVehicleRequest, Vehicle> createVehicleSettings;
        private final UnaryCallSettings.Builder<GetVehicleRequest, Vehicle> getVehicleSettings;
        private final UnaryCallSettings.Builder<UpdateVehicleRequest, Vehicle> updateVehicleSettings;
        private final UnaryCallSettings.Builder<UpdateVehicleAttributesRequest, UpdateVehicleAttributesResponse> updateVehicleAttributesSettings;
        private final PagedCallSettings.Builder<ListVehiclesRequest, ListVehiclesResponse, VehicleServiceClient.ListVehiclesPagedResponse> listVehiclesSettings;
        private final UnaryCallSettings.Builder<SearchVehiclesRequest, SearchVehiclesResponse> searchVehiclesSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.createVehicleSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getVehicleSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateVehicleSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateVehicleAttributesSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listVehiclesSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_VEHICLES_PAGE_STR_FACT);
            this.searchVehiclesSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.createVehicleSettings, this.getVehicleSettings, this.updateVehicleSettings, this.updateVehicleAttributesSettings, this.listVehiclesSettings, this.searchVehiclesSettings);
            Builder.initDefaults(this);
        }

        protected Builder(VehicleServiceStubSettings settings) {
            super((StubSettings)settings);
            this.createVehicleSettings = settings.createVehicleSettings.toBuilder();
            this.getVehicleSettings = settings.getVehicleSettings.toBuilder();
            this.updateVehicleSettings = settings.updateVehicleSettings.toBuilder();
            this.updateVehicleAttributesSettings = settings.updateVehicleAttributesSettings.toBuilder();
            this.listVehiclesSettings = settings.listVehiclesSettings.toBuilder();
            this.searchVehiclesSettings = settings.searchVehiclesSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.createVehicleSettings, this.getVehicleSettings, this.updateVehicleSettings, this.updateVehicleAttributesSettings, this.listVehiclesSettings, this.searchVehiclesSettings);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(VehicleServiceStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)VehicleServiceStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)VehicleServiceStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(VehicleServiceStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.createVehicleSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.getVehicleSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.updateVehicleSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.updateVehicleAttributesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.listVehiclesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.searchVehiclesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public UnaryCallSettings.Builder<CreateVehicleRequest, Vehicle> createVehicleSettings() {
            return this.createVehicleSettings;
        }

        public UnaryCallSettings.Builder<GetVehicleRequest, Vehicle> getVehicleSettings() {
            return this.getVehicleSettings;
        }

        public UnaryCallSettings.Builder<UpdateVehicleRequest, Vehicle> updateVehicleSettings() {
            return this.updateVehicleSettings;
        }

        public UnaryCallSettings.Builder<UpdateVehicleAttributesRequest, UpdateVehicleAttributesResponse> updateVehicleAttributesSettings() {
            return this.updateVehicleAttributesSettings;
        }

        public PagedCallSettings.Builder<ListVehiclesRequest, ListVehiclesResponse, VehicleServiceClient.ListVehiclesPagedResponse> listVehiclesSettings() {
            return this.listVehiclesSettings;
        }

        public UnaryCallSettings.Builder<SearchVehiclesRequest, SearchVehiclesResponse> searchVehiclesSettings() {
            return this.searchVehiclesSettings;
        }

        public VehicleServiceStubSettings build() throws IOException {
            return new VehicleServiceStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"retry_policy_0_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.UNAVAILABLE})));
            definitions.put((Object)"no_retry_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(1000L)).setRetryDelayMultiplier(1.3).setMaxRetryDelayDuration(Duration.ofMillis(10000L)).setInitialRpcTimeoutDuration(Duration.ofMillis(15000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ofMillis(15000L)).setTotalTimeoutDuration(Duration.ofMillis(15000L)).build();
            definitions.put((Object)"retry_policy_0_params", (Object)settings);
            settings = RetrySettings.newBuilder().setRpcTimeoutMultiplier(1.0).build();
            definitions.put((Object)"no_retry_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

