/*
 * Decompiled with CFR 0.152.
 */
package com.google.maps.fleetengine.v1;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.maps.fleetengine.v1.CreateTripRequest;
import com.google.maps.fleetengine.v1.DeleteTripRequest;
import com.google.maps.fleetengine.v1.GetTripRequest;
import com.google.maps.fleetengine.v1.ReportBillableTripRequest;
import com.google.maps.fleetengine.v1.SearchTripsRequest;
import com.google.maps.fleetengine.v1.SearchTripsResponse;
import com.google.maps.fleetengine.v1.Trip;
import com.google.maps.fleetengine.v1.TripName;
import com.google.maps.fleetengine.v1.TripServiceSettings;
import com.google.maps.fleetengine.v1.UpdateTripRequest;
import com.google.maps.fleetengine.v1.stub.TripServiceStub;
import com.google.maps.fleetengine.v1.stub.TripServiceStubSettings;
import com.google.protobuf.Empty;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class TripServiceClient
implements BackgroundResource {
    private final TripServiceSettings settings;
    private final TripServiceStub stub;

    public static final TripServiceClient create() throws IOException {
        return TripServiceClient.create(TripServiceSettings.newBuilder().build());
    }

    public static final TripServiceClient create(TripServiceSettings settings) throws IOException {
        return new TripServiceClient(settings);
    }

    public static final TripServiceClient create(TripServiceStub stub) {
        return new TripServiceClient(stub);
    }

    protected TripServiceClient(TripServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((TripServiceStubSettings)settings.getStubSettings()).createStub();
    }

    protected TripServiceClient(TripServiceStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final TripServiceSettings getSettings() {
        return this.settings;
    }

    public TripServiceStub getStub() {
        return this.stub;
    }

    public final Trip createTrip(CreateTripRequest request) {
        return (Trip)this.createTripCallable().call((Object)request);
    }

    public final UnaryCallable<CreateTripRequest, Trip> createTripCallable() {
        return this.stub.createTripCallable();
    }

    public final Trip getTrip(GetTripRequest request) {
        return (Trip)this.getTripCallable().call((Object)request);
    }

    public final UnaryCallable<GetTripRequest, Trip> getTripCallable() {
        return this.stub.getTripCallable();
    }

    public final void deleteTrip(TripName name) {
        DeleteTripRequest request = DeleteTripRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        this.deleteTrip(request);
    }

    public final void deleteTrip(String name) {
        DeleteTripRequest request = DeleteTripRequest.newBuilder().setName(name).build();
        this.deleteTrip(request);
    }

    public final void deleteTrip(DeleteTripRequest request) {
        this.deleteTripCallable().call((Object)request);
    }

    public final UnaryCallable<DeleteTripRequest, Empty> deleteTripCallable() {
        return this.stub.deleteTripCallable();
    }

    public final void reportBillableTrip(ReportBillableTripRequest request) {
        this.reportBillableTripCallable().call((Object)request);
    }

    public final UnaryCallable<ReportBillableTripRequest, Empty> reportBillableTripCallable() {
        return this.stub.reportBillableTripCallable();
    }

    public final SearchTripsPagedResponse searchTrips(SearchTripsRequest request) {
        return (SearchTripsPagedResponse)((Object)this.searchTripsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<SearchTripsRequest, SearchTripsPagedResponse> searchTripsPagedCallable() {
        return this.stub.searchTripsPagedCallable();
    }

    public final UnaryCallable<SearchTripsRequest, SearchTripsResponse> searchTripsCallable() {
        return this.stub.searchTripsCallable();
    }

    public final Trip updateTrip(UpdateTripRequest request) {
        return (Trip)this.updateTripCallable().call((Object)request);
    }

    public final UnaryCallable<UpdateTripRequest, Trip> updateTripCallable() {
        return this.stub.updateTripCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class SearchTripsFixedSizeCollection
    extends AbstractFixedSizeCollection<SearchTripsRequest, SearchTripsResponse, Trip, SearchTripsPage, SearchTripsFixedSizeCollection> {
        private SearchTripsFixedSizeCollection(List<SearchTripsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static SearchTripsFixedSizeCollection createEmptyCollection() {
            return new SearchTripsFixedSizeCollection(null, 0);
        }

        protected SearchTripsFixedSizeCollection createCollection(List<SearchTripsPage> pages, int collectionSize) {
            return new SearchTripsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class SearchTripsPage
    extends AbstractPage<SearchTripsRequest, SearchTripsResponse, Trip, SearchTripsPage> {
        private SearchTripsPage(PageContext<SearchTripsRequest, SearchTripsResponse, Trip> context, SearchTripsResponse response) {
            super(context, (Object)response);
        }

        private static SearchTripsPage createEmptyPage() {
            return new SearchTripsPage(null, null);
        }

        protected SearchTripsPage createPage(PageContext<SearchTripsRequest, SearchTripsResponse, Trip> context, SearchTripsResponse response) {
            return new SearchTripsPage(context, response);
        }

        public ApiFuture<SearchTripsPage> createPageAsync(PageContext<SearchTripsRequest, SearchTripsResponse, Trip> context, ApiFuture<SearchTripsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class SearchTripsPagedResponse
    extends AbstractPagedListResponse<SearchTripsRequest, SearchTripsResponse, Trip, SearchTripsPage, SearchTripsFixedSizeCollection> {
        public static ApiFuture<SearchTripsPagedResponse> createAsync(PageContext<SearchTripsRequest, SearchTripsResponse, Trip> context, ApiFuture<SearchTripsResponse> futureResponse) {
            ApiFuture<SearchTripsPage> futurePage = SearchTripsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new SearchTripsPagedResponse((SearchTripsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private SearchTripsPagedResponse(SearchTripsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)SearchTripsFixedSizeCollection.createEmptyCollection());
        }
    }
}

