/*
 * Decompiled with CFR 0.152.
 */
package com.google.maps.fleetengine.delivery.v1;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.maps.fleetengine.delivery.v1.BatchCreateTasksRequest;
import com.google.maps.fleetengine.delivery.v1.BatchCreateTasksResponse;
import com.google.maps.fleetengine.delivery.v1.CreateDeliveryVehicleRequest;
import com.google.maps.fleetengine.delivery.v1.CreateTaskRequest;
import com.google.maps.fleetengine.delivery.v1.DeleteDeliveryVehicleRequest;
import com.google.maps.fleetengine.delivery.v1.DeleteTaskRequest;
import com.google.maps.fleetengine.delivery.v1.DeliveryServiceSettings;
import com.google.maps.fleetengine.delivery.v1.DeliveryVehicle;
import com.google.maps.fleetengine.delivery.v1.DeliveryVehicleName;
import com.google.maps.fleetengine.delivery.v1.GetDeliveryVehicleRequest;
import com.google.maps.fleetengine.delivery.v1.GetTaskRequest;
import com.google.maps.fleetengine.delivery.v1.GetTaskTrackingInfoRequest;
import com.google.maps.fleetengine.delivery.v1.ListDeliveryVehiclesRequest;
import com.google.maps.fleetengine.delivery.v1.ListDeliveryVehiclesResponse;
import com.google.maps.fleetengine.delivery.v1.ListTasksRequest;
import com.google.maps.fleetengine.delivery.v1.ListTasksResponse;
import com.google.maps.fleetengine.delivery.v1.ProviderName;
import com.google.maps.fleetengine.delivery.v1.Task;
import com.google.maps.fleetengine.delivery.v1.TaskName;
import com.google.maps.fleetengine.delivery.v1.TaskTrackingInfo;
import com.google.maps.fleetengine.delivery.v1.TaskTrackingInfoName;
import com.google.maps.fleetengine.delivery.v1.UpdateDeliveryVehicleRequest;
import com.google.maps.fleetengine.delivery.v1.UpdateTaskRequest;
import com.google.maps.fleetengine.delivery.v1.stub.DeliveryServiceStub;
import com.google.maps.fleetengine.delivery.v1.stub.DeliveryServiceStubSettings;
import com.google.protobuf.Empty;
import com.google.protobuf.FieldMask;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class DeliveryServiceClient
implements BackgroundResource {
    private final DeliveryServiceSettings settings;
    private final DeliveryServiceStub stub;

    public static final DeliveryServiceClient create() throws IOException {
        return DeliveryServiceClient.create(DeliveryServiceSettings.newBuilder().build());
    }

    public static final DeliveryServiceClient create(DeliveryServiceSettings settings) throws IOException {
        return new DeliveryServiceClient(settings);
    }

    public static final DeliveryServiceClient create(DeliveryServiceStub stub) {
        return new DeliveryServiceClient(stub);
    }

    protected DeliveryServiceClient(DeliveryServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((DeliveryServiceStubSettings)settings.getStubSettings()).createStub();
    }

    protected DeliveryServiceClient(DeliveryServiceStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final DeliveryServiceSettings getSettings() {
        return this.settings;
    }

    public DeliveryServiceStub getStub() {
        return this.stub;
    }

    public final DeliveryVehicle createDeliveryVehicle(String parent, DeliveryVehicle deliveryVehicle, String deliveryVehicleId) {
        CreateDeliveryVehicleRequest request = CreateDeliveryVehicleRequest.newBuilder().setParent(parent).setDeliveryVehicle(deliveryVehicle).setDeliveryVehicleId(deliveryVehicleId).build();
        return this.createDeliveryVehicle(request);
    }

    public final DeliveryVehicle createDeliveryVehicle(CreateDeliveryVehicleRequest request) {
        return (DeliveryVehicle)this.createDeliveryVehicleCallable().call((Object)request);
    }

    public final UnaryCallable<CreateDeliveryVehicleRequest, DeliveryVehicle> createDeliveryVehicleCallable() {
        return this.stub.createDeliveryVehicleCallable();
    }

    public final DeliveryVehicle getDeliveryVehicle(DeliveryVehicleName name) {
        GetDeliveryVehicleRequest request = GetDeliveryVehicleRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getDeliveryVehicle(request);
    }

    public final DeliveryVehicle getDeliveryVehicle(String name) {
        GetDeliveryVehicleRequest request = GetDeliveryVehicleRequest.newBuilder().setName(name).build();
        return this.getDeliveryVehicle(request);
    }

    public final DeliveryVehicle getDeliveryVehicle(GetDeliveryVehicleRequest request) {
        return (DeliveryVehicle)this.getDeliveryVehicleCallable().call((Object)request);
    }

    public final UnaryCallable<GetDeliveryVehicleRequest, DeliveryVehicle> getDeliveryVehicleCallable() {
        return this.stub.getDeliveryVehicleCallable();
    }

    public final void deleteDeliveryVehicle(DeliveryVehicleName name) {
        DeleteDeliveryVehicleRequest request = DeleteDeliveryVehicleRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        this.deleteDeliveryVehicle(request);
    }

    public final void deleteDeliveryVehicle(String name) {
        DeleteDeliveryVehicleRequest request = DeleteDeliveryVehicleRequest.newBuilder().setName(name).build();
        this.deleteDeliveryVehicle(request);
    }

    public final void deleteDeliveryVehicle(DeleteDeliveryVehicleRequest request) {
        this.deleteDeliveryVehicleCallable().call((Object)request);
    }

    public final UnaryCallable<DeleteDeliveryVehicleRequest, Empty> deleteDeliveryVehicleCallable() {
        return this.stub.deleteDeliveryVehicleCallable();
    }

    public final DeliveryVehicle updateDeliveryVehicle(DeliveryVehicle deliveryVehicle, FieldMask updateMask) {
        UpdateDeliveryVehicleRequest request = UpdateDeliveryVehicleRequest.newBuilder().setDeliveryVehicle(deliveryVehicle).setUpdateMask(updateMask).build();
        return this.updateDeliveryVehicle(request);
    }

    public final DeliveryVehicle updateDeliveryVehicle(UpdateDeliveryVehicleRequest request) {
        return (DeliveryVehicle)this.updateDeliveryVehicleCallable().call((Object)request);
    }

    public final UnaryCallable<UpdateDeliveryVehicleRequest, DeliveryVehicle> updateDeliveryVehicleCallable() {
        return this.stub.updateDeliveryVehicleCallable();
    }

    public final BatchCreateTasksResponse batchCreateTasks(BatchCreateTasksRequest request) {
        return (BatchCreateTasksResponse)this.batchCreateTasksCallable().call((Object)request);
    }

    public final UnaryCallable<BatchCreateTasksRequest, BatchCreateTasksResponse> batchCreateTasksCallable() {
        return this.stub.batchCreateTasksCallable();
    }

    public final Task createTask(String parent, Task task, String taskId) {
        CreateTaskRequest request = CreateTaskRequest.newBuilder().setParent(parent).setTask(task).setTaskId(taskId).build();
        return this.createTask(request);
    }

    public final Task createTask(CreateTaskRequest request) {
        return (Task)this.createTaskCallable().call((Object)request);
    }

    public final UnaryCallable<CreateTaskRequest, Task> createTaskCallable() {
        return this.stub.createTaskCallable();
    }

    public final Task getTask(TaskName name) {
        GetTaskRequest request = GetTaskRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getTask(request);
    }

    public final Task getTask(String name) {
        GetTaskRequest request = GetTaskRequest.newBuilder().setName(name).build();
        return this.getTask(request);
    }

    public final Task getTask(GetTaskRequest request) {
        return (Task)this.getTaskCallable().call((Object)request);
    }

    public final UnaryCallable<GetTaskRequest, Task> getTaskCallable() {
        return this.stub.getTaskCallable();
    }

    public final void deleteTask(TaskName name) {
        DeleteTaskRequest request = DeleteTaskRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        this.deleteTask(request);
    }

    public final void deleteTask(String name) {
        DeleteTaskRequest request = DeleteTaskRequest.newBuilder().setName(name).build();
        this.deleteTask(request);
    }

    public final void deleteTask(DeleteTaskRequest request) {
        this.deleteTaskCallable().call((Object)request);
    }

    public final UnaryCallable<DeleteTaskRequest, Empty> deleteTaskCallable() {
        return this.stub.deleteTaskCallable();
    }

    public final Task updateTask(Task task, FieldMask updateMask) {
        UpdateTaskRequest request = UpdateTaskRequest.newBuilder().setTask(task).setUpdateMask(updateMask).build();
        return this.updateTask(request);
    }

    public final Task updateTask(UpdateTaskRequest request) {
        return (Task)this.updateTaskCallable().call((Object)request);
    }

    public final UnaryCallable<UpdateTaskRequest, Task> updateTaskCallable() {
        return this.stub.updateTaskCallable();
    }

    public final ListTasksPagedResponse listTasks(ProviderName parent) {
        ListTasksRequest request = ListTasksRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listTasks(request);
    }

    public final ListTasksPagedResponse listTasks(String parent) {
        ListTasksRequest request = ListTasksRequest.newBuilder().setParent(parent).build();
        return this.listTasks(request);
    }

    public final ListTasksPagedResponse listTasks(ListTasksRequest request) {
        return (ListTasksPagedResponse)((Object)this.listTasksPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListTasksRequest, ListTasksPagedResponse> listTasksPagedCallable() {
        return this.stub.listTasksPagedCallable();
    }

    public final UnaryCallable<ListTasksRequest, ListTasksResponse> listTasksCallable() {
        return this.stub.listTasksCallable();
    }

    public final TaskTrackingInfo getTaskTrackingInfo(TaskTrackingInfoName name) {
        GetTaskTrackingInfoRequest request = GetTaskTrackingInfoRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getTaskTrackingInfo(request);
    }

    public final TaskTrackingInfo getTaskTrackingInfo(String name) {
        GetTaskTrackingInfoRequest request = GetTaskTrackingInfoRequest.newBuilder().setName(name).build();
        return this.getTaskTrackingInfo(request);
    }

    public final TaskTrackingInfo getTaskTrackingInfo(GetTaskTrackingInfoRequest request) {
        return (TaskTrackingInfo)this.getTaskTrackingInfoCallable().call((Object)request);
    }

    public final UnaryCallable<GetTaskTrackingInfoRequest, TaskTrackingInfo> getTaskTrackingInfoCallable() {
        return this.stub.getTaskTrackingInfoCallable();
    }

    public final ListDeliveryVehiclesPagedResponse listDeliveryVehicles(ProviderName parent) {
        ListDeliveryVehiclesRequest request = ListDeliveryVehiclesRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listDeliveryVehicles(request);
    }

    public final ListDeliveryVehiclesPagedResponse listDeliveryVehicles(String parent) {
        ListDeliveryVehiclesRequest request = ListDeliveryVehiclesRequest.newBuilder().setParent(parent).build();
        return this.listDeliveryVehicles(request);
    }

    public final ListDeliveryVehiclesPagedResponse listDeliveryVehicles(ListDeliveryVehiclesRequest request) {
        return (ListDeliveryVehiclesPagedResponse)((Object)this.listDeliveryVehiclesPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListDeliveryVehiclesRequest, ListDeliveryVehiclesPagedResponse> listDeliveryVehiclesPagedCallable() {
        return this.stub.listDeliveryVehiclesPagedCallable();
    }

    public final UnaryCallable<ListDeliveryVehiclesRequest, ListDeliveryVehiclesResponse> listDeliveryVehiclesCallable() {
        return this.stub.listDeliveryVehiclesCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListDeliveryVehiclesFixedSizeCollection
    extends AbstractFixedSizeCollection<ListDeliveryVehiclesRequest, ListDeliveryVehiclesResponse, DeliveryVehicle, ListDeliveryVehiclesPage, ListDeliveryVehiclesFixedSizeCollection> {
        private ListDeliveryVehiclesFixedSizeCollection(List<ListDeliveryVehiclesPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListDeliveryVehiclesFixedSizeCollection createEmptyCollection() {
            return new ListDeliveryVehiclesFixedSizeCollection(null, 0);
        }

        protected ListDeliveryVehiclesFixedSizeCollection createCollection(List<ListDeliveryVehiclesPage> pages, int collectionSize) {
            return new ListDeliveryVehiclesFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListDeliveryVehiclesPage
    extends AbstractPage<ListDeliveryVehiclesRequest, ListDeliveryVehiclesResponse, DeliveryVehicle, ListDeliveryVehiclesPage> {
        private ListDeliveryVehiclesPage(PageContext<ListDeliveryVehiclesRequest, ListDeliveryVehiclesResponse, DeliveryVehicle> context, ListDeliveryVehiclesResponse response) {
            super(context, (Object)response);
        }

        private static ListDeliveryVehiclesPage createEmptyPage() {
            return new ListDeliveryVehiclesPage(null, null);
        }

        protected ListDeliveryVehiclesPage createPage(PageContext<ListDeliveryVehiclesRequest, ListDeliveryVehiclesResponse, DeliveryVehicle> context, ListDeliveryVehiclesResponse response) {
            return new ListDeliveryVehiclesPage(context, response);
        }

        public ApiFuture<ListDeliveryVehiclesPage> createPageAsync(PageContext<ListDeliveryVehiclesRequest, ListDeliveryVehiclesResponse, DeliveryVehicle> context, ApiFuture<ListDeliveryVehiclesResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListDeliveryVehiclesPagedResponse
    extends AbstractPagedListResponse<ListDeliveryVehiclesRequest, ListDeliveryVehiclesResponse, DeliveryVehicle, ListDeliveryVehiclesPage, ListDeliveryVehiclesFixedSizeCollection> {
        public static ApiFuture<ListDeliveryVehiclesPagedResponse> createAsync(PageContext<ListDeliveryVehiclesRequest, ListDeliveryVehiclesResponse, DeliveryVehicle> context, ApiFuture<ListDeliveryVehiclesResponse> futureResponse) {
            ApiFuture<ListDeliveryVehiclesPage> futurePage = ListDeliveryVehiclesPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListDeliveryVehiclesPagedResponse((ListDeliveryVehiclesPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListDeliveryVehiclesPagedResponse(ListDeliveryVehiclesPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListDeliveryVehiclesFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListTasksFixedSizeCollection
    extends AbstractFixedSizeCollection<ListTasksRequest, ListTasksResponse, Task, ListTasksPage, ListTasksFixedSizeCollection> {
        private ListTasksFixedSizeCollection(List<ListTasksPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListTasksFixedSizeCollection createEmptyCollection() {
            return new ListTasksFixedSizeCollection(null, 0);
        }

        protected ListTasksFixedSizeCollection createCollection(List<ListTasksPage> pages, int collectionSize) {
            return new ListTasksFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListTasksPage
    extends AbstractPage<ListTasksRequest, ListTasksResponse, Task, ListTasksPage> {
        private ListTasksPage(PageContext<ListTasksRequest, ListTasksResponse, Task> context, ListTasksResponse response) {
            super(context, (Object)response);
        }

        private static ListTasksPage createEmptyPage() {
            return new ListTasksPage(null, null);
        }

        protected ListTasksPage createPage(PageContext<ListTasksRequest, ListTasksResponse, Task> context, ListTasksResponse response) {
            return new ListTasksPage(context, response);
        }

        public ApiFuture<ListTasksPage> createPageAsync(PageContext<ListTasksRequest, ListTasksResponse, Task> context, ApiFuture<ListTasksResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListTasksPagedResponse
    extends AbstractPagedListResponse<ListTasksRequest, ListTasksResponse, Task, ListTasksPage, ListTasksFixedSizeCollection> {
        public static ApiFuture<ListTasksPagedResponse> createAsync(PageContext<ListTasksRequest, ListTasksResponse, Task> context, ApiFuture<ListTasksResponse> futureResponse) {
            ApiFuture<ListTasksPage> futurePage = ListTasksPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListTasksPagedResponse((ListTasksPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListTasksPagedResponse(ListTasksPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListTasksFixedSizeCollection.createEmptyCollection());
        }
    }
}

