/*
 * Decompiled with CFR 0.152.
 */
package com.google.maps.areainsights.v1;

import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.maps.areainsights.v1.AreaInsightsSettings;
import com.google.maps.areainsights.v1.ComputeInsightsRequest;
import com.google.maps.areainsights.v1.ComputeInsightsResponse;
import com.google.maps.areainsights.v1.stub.AreaInsightsStub;
import com.google.maps.areainsights.v1.stub.AreaInsightsStubSettings;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

public class AreaInsightsClient
implements BackgroundResource {
    private final AreaInsightsSettings settings;
    private final AreaInsightsStub stub;

    public static final AreaInsightsClient create() throws IOException {
        return AreaInsightsClient.create(AreaInsightsSettings.newBuilder().build());
    }

    public static final AreaInsightsClient create(AreaInsightsSettings settings) throws IOException {
        return new AreaInsightsClient(settings);
    }

    public static final AreaInsightsClient create(AreaInsightsStub stub) {
        return new AreaInsightsClient(stub);
    }

    protected AreaInsightsClient(AreaInsightsSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((AreaInsightsStubSettings)settings.getStubSettings()).createStub();
    }

    protected AreaInsightsClient(AreaInsightsStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final AreaInsightsSettings getSettings() {
        return this.settings;
    }

    public AreaInsightsStub getStub() {
        return this.stub;
    }

    public final ComputeInsightsResponse computeInsights(ComputeInsightsRequest request) {
        return (ComputeInsightsResponse)this.computeInsightsCallable().call((Object)request);
    }

    public final UnaryCallable<ComputeInsightsRequest, ComputeInsightsResponse> computeInsightsCallable() {
        return this.stub.computeInsightsCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }
}

