/*
 * Decompiled with CFR 0.152.
 */
package com.google.maps.solar.v1;

import com.google.maps.solar.v1.DataLayerView;
import com.google.maps.solar.v1.Experiment;
import com.google.maps.solar.v1.GetDataLayersRequestOrBuilder;
import com.google.maps.solar.v1.ImageryQuality;
import com.google.maps.solar.v1.SolarServiceProto;
import com.google.protobuf.AbstractMessage;
import com.google.protobuf.AbstractParser;
import com.google.protobuf.ByteString;
import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import com.google.protobuf.Descriptors;
import com.google.protobuf.ExtensionRegistryLite;
import com.google.protobuf.GeneratedMessageV3;
import com.google.protobuf.Internal;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import com.google.protobuf.MessageLite;
import com.google.protobuf.Parser;
import com.google.protobuf.SingleFieldBuilderV3;
import com.google.protobuf.UninitializedMessageException;
import com.google.protobuf.UnknownFieldSet;
import com.google.type.LatLng;
import com.google.type.LatLngOrBuilder;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class GetDataLayersRequest
extends GeneratedMessageV3
implements GetDataLayersRequestOrBuilder {
    private static final long serialVersionUID = 0L;
    private int bitField0_;
    public static final int LOCATION_FIELD_NUMBER = 1;
    private LatLng location_;
    public static final int RADIUS_METERS_FIELD_NUMBER = 2;
    private float radiusMeters_ = 0.0f;
    public static final int VIEW_FIELD_NUMBER = 3;
    private int view_ = 0;
    public static final int REQUIRED_QUALITY_FIELD_NUMBER = 5;
    private int requiredQuality_ = 0;
    public static final int PIXEL_SIZE_METERS_FIELD_NUMBER = 6;
    private float pixelSizeMeters_ = 0.0f;
    public static final int EXACT_QUALITY_REQUIRED_FIELD_NUMBER = 7;
    private boolean exactQualityRequired_ = false;
    public static final int EXPERIMENTS_FIELD_NUMBER = 8;
    private List<Integer> experiments_;
    private static final Internal.ListAdapter.Converter<Integer, Experiment> experiments_converter_ = new Internal.ListAdapter.Converter<Integer, Experiment>(){

        public Experiment convert(Integer from) {
            Experiment result = Experiment.forNumber(from);
            return result == null ? Experiment.UNRECOGNIZED : result;
        }
    };
    private int experimentsMemoizedSerializedSize;
    private byte memoizedIsInitialized = (byte)-1;
    private static final GetDataLayersRequest DEFAULT_INSTANCE = new GetDataLayersRequest();
    private static final Parser<GetDataLayersRequest> PARSER = new AbstractParser<GetDataLayersRequest>(){

        public GetDataLayersRequest parsePartialFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            Builder builder = GetDataLayersRequest.newBuilder();
            try {
                builder.mergeFrom(input, extensionRegistry);
            }
            catch (InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage((MessageLite)builder.buildPartial());
            }
            catch (UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException().setUnfinishedMessage((MessageLite)builder.buildPartial());
            }
            catch (IOException e) {
                throw new InvalidProtocolBufferException(e).setUnfinishedMessage((MessageLite)builder.buildPartial());
            }
            return builder.buildPartial();
        }
    };

    private GetDataLayersRequest(GeneratedMessageV3.Builder<?> builder) {
        super(builder);
    }

    private GetDataLayersRequest() {
        this.view_ = 0;
        this.requiredQuality_ = 0;
        this.experiments_ = Collections.emptyList();
    }

    protected Object newInstance(GeneratedMessageV3.UnusedPrivateParameter unused) {
        return new GetDataLayersRequest();
    }

    public static final Descriptors.Descriptor getDescriptor() {
        return SolarServiceProto.internal_static_google_maps_solar_v1_GetDataLayersRequest_descriptor;
    }

    protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
        return SolarServiceProto.internal_static_google_maps_solar_v1_GetDataLayersRequest_fieldAccessorTable.ensureFieldAccessorsInitialized(GetDataLayersRequest.class, Builder.class);
    }

    @Override
    public boolean hasLocation() {
        return (this.bitField0_ & 1) != 0;
    }

    @Override
    public LatLng getLocation() {
        return this.location_ == null ? LatLng.getDefaultInstance() : this.location_;
    }

    @Override
    public LatLngOrBuilder getLocationOrBuilder() {
        return this.location_ == null ? LatLng.getDefaultInstance() : this.location_;
    }

    @Override
    public float getRadiusMeters() {
        return this.radiusMeters_;
    }

    @Override
    public int getViewValue() {
        return this.view_;
    }

    @Override
    public DataLayerView getView() {
        DataLayerView result = DataLayerView.forNumber(this.view_);
        return result == null ? DataLayerView.UNRECOGNIZED : result;
    }

    @Override
    public int getRequiredQualityValue() {
        return this.requiredQuality_;
    }

    @Override
    public ImageryQuality getRequiredQuality() {
        ImageryQuality result = ImageryQuality.forNumber(this.requiredQuality_);
        return result == null ? ImageryQuality.UNRECOGNIZED : result;
    }

    @Override
    public float getPixelSizeMeters() {
        return this.pixelSizeMeters_;
    }

    @Override
    public boolean getExactQualityRequired() {
        return this.exactQualityRequired_;
    }

    @Override
    public List<Experiment> getExperimentsList() {
        return new Internal.ListAdapter(this.experiments_, experiments_converter_);
    }

    @Override
    public int getExperimentsCount() {
        return this.experiments_.size();
    }

    @Override
    public Experiment getExperiments(int index) {
        return (Experiment)((Object)experiments_converter_.convert((Object)this.experiments_.get(index)));
    }

    @Override
    public List<Integer> getExperimentsValueList() {
        return this.experiments_;
    }

    @Override
    public int getExperimentsValue(int index) {
        return this.experiments_.get(index);
    }

    public final boolean isInitialized() {
        byte isInitialized = this.memoizedIsInitialized;
        if (isInitialized == 1) {
            return true;
        }
        if (isInitialized == 0) {
            return false;
        }
        this.memoizedIsInitialized = 1;
        return true;
    }

    public void writeTo(CodedOutputStream output) throws IOException {
        this.getSerializedSize();
        if ((this.bitField0_ & 1) != 0) {
            output.writeMessage(1, (MessageLite)this.getLocation());
        }
        if (Float.floatToRawIntBits(this.radiusMeters_) != 0) {
            output.writeFloat(2, this.radiusMeters_);
        }
        if (this.view_ != DataLayerView.DATA_LAYER_VIEW_UNSPECIFIED.getNumber()) {
            output.writeEnum(3, this.view_);
        }
        if (this.requiredQuality_ != ImageryQuality.IMAGERY_QUALITY_UNSPECIFIED.getNumber()) {
            output.writeEnum(5, this.requiredQuality_);
        }
        if (Float.floatToRawIntBits(this.pixelSizeMeters_) != 0) {
            output.writeFloat(6, this.pixelSizeMeters_);
        }
        if (this.exactQualityRequired_) {
            output.writeBool(7, this.exactQualityRequired_);
        }
        if (this.getExperimentsList().size() > 0) {
            output.writeUInt32NoTag(66);
            output.writeUInt32NoTag(this.experimentsMemoizedSerializedSize);
        }
        for (int i = 0; i < this.experiments_.size(); ++i) {
            output.writeEnumNoTag(this.experiments_.get(i).intValue());
        }
        this.getUnknownFields().writeTo(output);
    }

    public int getSerializedSize() {
        int size = this.memoizedSize;
        if (size != -1) {
            return size;
        }
        size = 0;
        if ((this.bitField0_ & 1) != 0) {
            size += CodedOutputStream.computeMessageSize((int)1, (MessageLite)this.getLocation());
        }
        if (Float.floatToRawIntBits(this.radiusMeters_) != 0) {
            size += CodedOutputStream.computeFloatSize((int)2, (float)this.radiusMeters_);
        }
        if (this.view_ != DataLayerView.DATA_LAYER_VIEW_UNSPECIFIED.getNumber()) {
            size += CodedOutputStream.computeEnumSize((int)3, (int)this.view_);
        }
        if (this.requiredQuality_ != ImageryQuality.IMAGERY_QUALITY_UNSPECIFIED.getNumber()) {
            size += CodedOutputStream.computeEnumSize((int)5, (int)this.requiredQuality_);
        }
        if (Float.floatToRawIntBits(this.pixelSizeMeters_) != 0) {
            size += CodedOutputStream.computeFloatSize((int)6, (float)this.pixelSizeMeters_);
        }
        if (this.exactQualityRequired_) {
            size += CodedOutputStream.computeBoolSize((int)7, (boolean)this.exactQualityRequired_);
        }
        int dataSize = 0;
        for (int i = 0; i < this.experiments_.size(); ++i) {
            dataSize += CodedOutputStream.computeEnumSizeNoTag((int)this.experiments_.get(i));
        }
        size += dataSize;
        if (!this.getExperimentsList().isEmpty()) {
            ++size;
            size += CodedOutputStream.computeUInt32SizeNoTag((int)dataSize);
        }
        this.experimentsMemoizedSerializedSize = dataSize;
        this.memoizedSize = size += this.getUnknownFields().getSerializedSize();
        return size;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof GetDataLayersRequest)) {
            return super.equals(obj);
        }
        GetDataLayersRequest other = (GetDataLayersRequest)obj;
        if (this.hasLocation() != other.hasLocation()) {
            return false;
        }
        if (this.hasLocation() && !this.getLocation().equals((Object)other.getLocation())) {
            return false;
        }
        if (Float.floatToIntBits(this.getRadiusMeters()) != Float.floatToIntBits(other.getRadiusMeters())) {
            return false;
        }
        if (this.view_ != other.view_) {
            return false;
        }
        if (this.requiredQuality_ != other.requiredQuality_) {
            return false;
        }
        if (Float.floatToIntBits(this.getPixelSizeMeters()) != Float.floatToIntBits(other.getPixelSizeMeters())) {
            return false;
        }
        if (this.getExactQualityRequired() != other.getExactQualityRequired()) {
            return false;
        }
        if (!this.experiments_.equals(other.experiments_)) {
            return false;
        }
        return this.getUnknownFields().equals((Object)other.getUnknownFields());
    }

    public int hashCode() {
        if (this.memoizedHashCode != 0) {
            return this.memoizedHashCode;
        }
        int hash = 41;
        hash = 19 * hash + GetDataLayersRequest.getDescriptor().hashCode();
        if (this.hasLocation()) {
            hash = 37 * hash + 1;
            hash = 53 * hash + this.getLocation().hashCode();
        }
        hash = 37 * hash + 2;
        hash = 53 * hash + Float.floatToIntBits(this.getRadiusMeters());
        hash = 37 * hash + 3;
        hash = 53 * hash + this.view_;
        hash = 37 * hash + 5;
        hash = 53 * hash + this.requiredQuality_;
        hash = 37 * hash + 6;
        hash = 53 * hash + Float.floatToIntBits(this.getPixelSizeMeters());
        hash = 37 * hash + 7;
        hash = 53 * hash + Internal.hashBoolean((boolean)this.getExactQualityRequired());
        if (this.getExperimentsCount() > 0) {
            hash = 37 * hash + 8;
            hash = 53 * hash + this.experiments_.hashCode();
        }
        this.memoizedHashCode = hash = 29 * hash + this.getUnknownFields().hashCode();
        return hash;
    }

    public static GetDataLayersRequest parseFrom(ByteBuffer data) throws InvalidProtocolBufferException {
        return (GetDataLayersRequest)PARSER.parseFrom(data);
    }

    public static GetDataLayersRequest parseFrom(ByteBuffer data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (GetDataLayersRequest)PARSER.parseFrom(data, extensionRegistry);
    }

    public static GetDataLayersRequest parseFrom(ByteString data) throws InvalidProtocolBufferException {
        return (GetDataLayersRequest)PARSER.parseFrom(data);
    }

    public static GetDataLayersRequest parseFrom(ByteString data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (GetDataLayersRequest)PARSER.parseFrom(data, extensionRegistry);
    }

    public static GetDataLayersRequest parseFrom(byte[] data) throws InvalidProtocolBufferException {
        return (GetDataLayersRequest)PARSER.parseFrom(data);
    }

    public static GetDataLayersRequest parseFrom(byte[] data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (GetDataLayersRequest)PARSER.parseFrom(data, extensionRegistry);
    }

    public static GetDataLayersRequest parseFrom(InputStream input) throws IOException {
        return (GetDataLayersRequest)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input);
    }

    public static GetDataLayersRequest parseFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (GetDataLayersRequest)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public static GetDataLayersRequest parseDelimitedFrom(InputStream input) throws IOException {
        return (GetDataLayersRequest)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input);
    }

    public static GetDataLayersRequest parseDelimitedFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (GetDataLayersRequest)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public static GetDataLayersRequest parseFrom(CodedInputStream input) throws IOException {
        return (GetDataLayersRequest)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input);
    }

    public static GetDataLayersRequest parseFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (GetDataLayersRequest)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public Builder newBuilderForType() {
        return GetDataLayersRequest.newBuilder();
    }

    public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(GetDataLayersRequest prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    protected Builder newBuilderForType(GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
    }

    public static GetDataLayersRequest getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public static Parser<GetDataLayersRequest> parser() {
        return PARSER;
    }

    public Parser<GetDataLayersRequest> getParserForType() {
        return PARSER;
    }

    public GetDataLayersRequest getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
    }

    public static final class Builder
    extends GeneratedMessageV3.Builder<Builder>
    implements GetDataLayersRequestOrBuilder {
        private int bitField0_;
        private LatLng location_;
        private SingleFieldBuilderV3<LatLng, LatLng.Builder, LatLngOrBuilder> locationBuilder_;
        private float radiusMeters_;
        private int view_ = 0;
        private int requiredQuality_ = 0;
        private float pixelSizeMeters_;
        private boolean exactQualityRequired_;
        private List<Integer> experiments_ = Collections.emptyList();

        public static final Descriptors.Descriptor getDescriptor() {
            return SolarServiceProto.internal_static_google_maps_solar_v1_GetDataLayersRequest_descriptor;
        }

        protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
            return SolarServiceProto.internal_static_google_maps_solar_v1_GetDataLayersRequest_fieldAccessorTable.ensureFieldAccessorsInitialized(GetDataLayersRequest.class, Builder.class);
        }

        private Builder() {
            this.maybeForceBuilderInitialization();
        }

        private Builder(GeneratedMessageV3.BuilderParent parent) {
            super(parent);
            this.maybeForceBuilderInitialization();
        }

        private void maybeForceBuilderInitialization() {
            if (alwaysUseFieldBuilders) {
                this.getLocationFieldBuilder();
            }
        }

        public Builder clear() {
            super.clear();
            this.bitField0_ = 0;
            this.location_ = null;
            if (this.locationBuilder_ != null) {
                this.locationBuilder_.dispose();
                this.locationBuilder_ = null;
            }
            this.radiusMeters_ = 0.0f;
            this.view_ = 0;
            this.requiredQuality_ = 0;
            this.pixelSizeMeters_ = 0.0f;
            this.exactQualityRequired_ = false;
            this.experiments_ = Collections.emptyList();
            this.bitField0_ &= 0xFFFFFFBF;
            return this;
        }

        public Descriptors.Descriptor getDescriptorForType() {
            return SolarServiceProto.internal_static_google_maps_solar_v1_GetDataLayersRequest_descriptor;
        }

        public GetDataLayersRequest getDefaultInstanceForType() {
            return GetDataLayersRequest.getDefaultInstance();
        }

        public GetDataLayersRequest build() {
            GetDataLayersRequest result = this.buildPartial();
            if (!result.isInitialized()) {
                throw Builder.newUninitializedMessageException((Message)result);
            }
            return result;
        }

        public GetDataLayersRequest buildPartial() {
            GetDataLayersRequest result = new GetDataLayersRequest(this);
            this.buildPartialRepeatedFields(result);
            if (this.bitField0_ != 0) {
                this.buildPartial0(result);
            }
            this.onBuilt();
            return result;
        }

        private void buildPartialRepeatedFields(GetDataLayersRequest result) {
            if ((this.bitField0_ & 0x40) != 0) {
                this.experiments_ = Collections.unmodifiableList(this.experiments_);
                this.bitField0_ &= 0xFFFFFFBF;
            }
            result.experiments_ = this.experiments_;
        }

        private void buildPartial0(GetDataLayersRequest result) {
            int from_bitField0_ = this.bitField0_;
            int to_bitField0_ = 0;
            if ((from_bitField0_ & 1) != 0) {
                result.location_ = this.locationBuilder_ == null ? this.location_ : (LatLng)this.locationBuilder_.build();
                to_bitField0_ |= 1;
            }
            if ((from_bitField0_ & 2) != 0) {
                result.radiusMeters_ = this.radiusMeters_;
            }
            if ((from_bitField0_ & 4) != 0) {
                result.view_ = this.view_;
            }
            if ((from_bitField0_ & 8) != 0) {
                result.requiredQuality_ = this.requiredQuality_;
            }
            if ((from_bitField0_ & 0x10) != 0) {
                result.pixelSizeMeters_ = this.pixelSizeMeters_;
            }
            if ((from_bitField0_ & 0x20) != 0) {
                result.exactQualityRequired_ = this.exactQualityRequired_;
            }
            GetDataLayersRequest getDataLayersRequest = result;
            getDataLayersRequest.bitField0_ = getDataLayersRequest.bitField0_ | to_bitField0_;
        }

        public Builder clone() {
            return (Builder)super.clone();
        }

        public Builder setField(Descriptors.FieldDescriptor field, Object value) {
            return (Builder)super.setField(field, value);
        }

        public Builder clearField(Descriptors.FieldDescriptor field) {
            return (Builder)super.clearField(field);
        }

        public Builder clearOneof(Descriptors.OneofDescriptor oneof) {
            return (Builder)super.clearOneof(oneof);
        }

        public Builder setRepeatedField(Descriptors.FieldDescriptor field, int index, Object value) {
            return (Builder)super.setRepeatedField(field, index, value);
        }

        public Builder addRepeatedField(Descriptors.FieldDescriptor field, Object value) {
            return (Builder)super.addRepeatedField(field, value);
        }

        public Builder mergeFrom(Message other) {
            if (other instanceof GetDataLayersRequest) {
                return this.mergeFrom((GetDataLayersRequest)other);
            }
            super.mergeFrom(other);
            return this;
        }

        public Builder mergeFrom(GetDataLayersRequest other) {
            if (other == GetDataLayersRequest.getDefaultInstance()) {
                return this;
            }
            if (other.hasLocation()) {
                this.mergeLocation(other.getLocation());
            }
            if (other.getRadiusMeters() != 0.0f) {
                this.setRadiusMeters(other.getRadiusMeters());
            }
            if (other.view_ != 0) {
                this.setViewValue(other.getViewValue());
            }
            if (other.requiredQuality_ != 0) {
                this.setRequiredQualityValue(other.getRequiredQualityValue());
            }
            if (other.getPixelSizeMeters() != 0.0f) {
                this.setPixelSizeMeters(other.getPixelSizeMeters());
            }
            if (other.getExactQualityRequired()) {
                this.setExactQualityRequired(other.getExactQualityRequired());
            }
            if (!other.experiments_.isEmpty()) {
                if (this.experiments_.isEmpty()) {
                    this.experiments_ = other.experiments_;
                    this.bitField0_ &= 0xFFFFFFBF;
                } else {
                    this.ensureExperimentsIsMutable();
                    this.experiments_.addAll(other.experiments_);
                }
                this.onChanged();
            }
            this.mergeUnknownFields(other.getUnknownFields());
            this.onChanged();
            return this;
        }

        public final boolean isInitialized() {
            return true;
        }

        public Builder mergeFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            if (extensionRegistry == null) {
                throw new NullPointerException();
            }
            try {
                boolean done = false;
                block16: while (!done) {
                    int tag = input.readTag();
                    switch (tag) {
                        case 0: {
                            done = true;
                            continue block16;
                        }
                        case 10: {
                            input.readMessage((MessageLite.Builder)this.getLocationFieldBuilder().getBuilder(), extensionRegistry);
                            this.bitField0_ |= 1;
                            continue block16;
                        }
                        case 21: {
                            this.radiusMeters_ = input.readFloat();
                            this.bitField0_ |= 2;
                            continue block16;
                        }
                        case 24: {
                            this.view_ = input.readEnum();
                            this.bitField0_ |= 4;
                            continue block16;
                        }
                        case 40: {
                            this.requiredQuality_ = input.readEnum();
                            this.bitField0_ |= 8;
                            continue block16;
                        }
                        case 53: {
                            this.pixelSizeMeters_ = input.readFloat();
                            this.bitField0_ |= 0x10;
                            continue block16;
                        }
                        case 56: {
                            this.exactQualityRequired_ = input.readBool();
                            this.bitField0_ |= 0x20;
                            continue block16;
                        }
                        case 64: {
                            int tmpRaw = input.readEnum();
                            this.ensureExperimentsIsMutable();
                            this.experiments_.add(tmpRaw);
                            continue block16;
                        }
                        case 66: {
                            int length = input.readRawVarint32();
                            int oldLimit = input.pushLimit(length);
                            while (input.getBytesUntilLimit() > 0) {
                                int tmpRaw = input.readEnum();
                                this.ensureExperimentsIsMutable();
                                this.experiments_.add(tmpRaw);
                            }
                            input.popLimit(oldLimit);
                            continue block16;
                        }
                    }
                    if (super.parseUnknownField(input, extensionRegistry, tag)) continue;
                    done = true;
                }
            }
            catch (InvalidProtocolBufferException e) {
                throw e.unwrapIOException();
            }
            finally {
                this.onChanged();
            }
            return this;
        }

        @Override
        public boolean hasLocation() {
            return (this.bitField0_ & 1) != 0;
        }

        @Override
        public LatLng getLocation() {
            if (this.locationBuilder_ == null) {
                return this.location_ == null ? LatLng.getDefaultInstance() : this.location_;
            }
            return (LatLng)this.locationBuilder_.getMessage();
        }

        public Builder setLocation(LatLng value) {
            if (this.locationBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.location_ = value;
            } else {
                this.locationBuilder_.setMessage((AbstractMessage)value);
            }
            this.bitField0_ |= 1;
            this.onChanged();
            return this;
        }

        public Builder setLocation(LatLng.Builder builderForValue) {
            if (this.locationBuilder_ == null) {
                this.location_ = builderForValue.build();
            } else {
                this.locationBuilder_.setMessage((AbstractMessage)builderForValue.build());
            }
            this.bitField0_ |= 1;
            this.onChanged();
            return this;
        }

        public Builder mergeLocation(LatLng value) {
            if (this.locationBuilder_ == null) {
                if ((this.bitField0_ & 1) != 0 && this.location_ != null && this.location_ != LatLng.getDefaultInstance()) {
                    this.getLocationBuilder().mergeFrom(value);
                } else {
                    this.location_ = value;
                }
            } else {
                this.locationBuilder_.mergeFrom((AbstractMessage)value);
            }
            if (this.location_ != null) {
                this.bitField0_ |= 1;
                this.onChanged();
            }
            return this;
        }

        public Builder clearLocation() {
            this.bitField0_ &= 0xFFFFFFFE;
            this.location_ = null;
            if (this.locationBuilder_ != null) {
                this.locationBuilder_.dispose();
                this.locationBuilder_ = null;
            }
            this.onChanged();
            return this;
        }

        public LatLng.Builder getLocationBuilder() {
            this.bitField0_ |= 1;
            this.onChanged();
            return (LatLng.Builder)this.getLocationFieldBuilder().getBuilder();
        }

        @Override
        public LatLngOrBuilder getLocationOrBuilder() {
            if (this.locationBuilder_ != null) {
                return (LatLngOrBuilder)this.locationBuilder_.getMessageOrBuilder();
            }
            return this.location_ == null ? LatLng.getDefaultInstance() : this.location_;
        }

        private SingleFieldBuilderV3<LatLng, LatLng.Builder, LatLngOrBuilder> getLocationFieldBuilder() {
            if (this.locationBuilder_ == null) {
                this.locationBuilder_ = new SingleFieldBuilderV3((AbstractMessage)this.getLocation(), (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.location_ = null;
            }
            return this.locationBuilder_;
        }

        @Override
        public float getRadiusMeters() {
            return this.radiusMeters_;
        }

        public Builder setRadiusMeters(float value) {
            this.radiusMeters_ = value;
            this.bitField0_ |= 2;
            this.onChanged();
            return this;
        }

        public Builder clearRadiusMeters() {
            this.bitField0_ &= 0xFFFFFFFD;
            this.radiusMeters_ = 0.0f;
            this.onChanged();
            return this;
        }

        @Override
        public int getViewValue() {
            return this.view_;
        }

        public Builder setViewValue(int value) {
            this.view_ = value;
            this.bitField0_ |= 4;
            this.onChanged();
            return this;
        }

        @Override
        public DataLayerView getView() {
            DataLayerView result = DataLayerView.forNumber(this.view_);
            return result == null ? DataLayerView.UNRECOGNIZED : result;
        }

        public Builder setView(DataLayerView value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.bitField0_ |= 4;
            this.view_ = value.getNumber();
            this.onChanged();
            return this;
        }

        public Builder clearView() {
            this.bitField0_ &= 0xFFFFFFFB;
            this.view_ = 0;
            this.onChanged();
            return this;
        }

        @Override
        public int getRequiredQualityValue() {
            return this.requiredQuality_;
        }

        public Builder setRequiredQualityValue(int value) {
            this.requiredQuality_ = value;
            this.bitField0_ |= 8;
            this.onChanged();
            return this;
        }

        @Override
        public ImageryQuality getRequiredQuality() {
            ImageryQuality result = ImageryQuality.forNumber(this.requiredQuality_);
            return result == null ? ImageryQuality.UNRECOGNIZED : result;
        }

        public Builder setRequiredQuality(ImageryQuality value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.bitField0_ |= 8;
            this.requiredQuality_ = value.getNumber();
            this.onChanged();
            return this;
        }

        public Builder clearRequiredQuality() {
            this.bitField0_ &= 0xFFFFFFF7;
            this.requiredQuality_ = 0;
            this.onChanged();
            return this;
        }

        @Override
        public float getPixelSizeMeters() {
            return this.pixelSizeMeters_;
        }

        public Builder setPixelSizeMeters(float value) {
            this.pixelSizeMeters_ = value;
            this.bitField0_ |= 0x10;
            this.onChanged();
            return this;
        }

        public Builder clearPixelSizeMeters() {
            this.bitField0_ &= 0xFFFFFFEF;
            this.pixelSizeMeters_ = 0.0f;
            this.onChanged();
            return this;
        }

        @Override
        public boolean getExactQualityRequired() {
            return this.exactQualityRequired_;
        }

        public Builder setExactQualityRequired(boolean value) {
            this.exactQualityRequired_ = value;
            this.bitField0_ |= 0x20;
            this.onChanged();
            return this;
        }

        public Builder clearExactQualityRequired() {
            this.bitField0_ &= 0xFFFFFFDF;
            this.exactQualityRequired_ = false;
            this.onChanged();
            return this;
        }

        private void ensureExperimentsIsMutable() {
            if ((this.bitField0_ & 0x40) == 0) {
                this.experiments_ = new ArrayList<Integer>(this.experiments_);
                this.bitField0_ |= 0x40;
            }
        }

        @Override
        public List<Experiment> getExperimentsList() {
            return new Internal.ListAdapter(this.experiments_, experiments_converter_);
        }

        @Override
        public int getExperimentsCount() {
            return this.experiments_.size();
        }

        @Override
        public Experiment getExperiments(int index) {
            return (Experiment)((Object)experiments_converter_.convert((Object)this.experiments_.get(index)));
        }

        public Builder setExperiments(int index, Experiment value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.ensureExperimentsIsMutable();
            this.experiments_.set(index, value.getNumber());
            this.onChanged();
            return this;
        }

        public Builder addExperiments(Experiment value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.ensureExperimentsIsMutable();
            this.experiments_.add(value.getNumber());
            this.onChanged();
            return this;
        }

        public Builder addAllExperiments(Iterable<? extends Experiment> values) {
            this.ensureExperimentsIsMutable();
            for (Experiment experiment : values) {
                this.experiments_.add(experiment.getNumber());
            }
            this.onChanged();
            return this;
        }

        public Builder clearExperiments() {
            this.experiments_ = Collections.emptyList();
            this.bitField0_ &= 0xFFFFFFBF;
            this.onChanged();
            return this;
        }

        @Override
        public List<Integer> getExperimentsValueList() {
            return Collections.unmodifiableList(this.experiments_);
        }

        @Override
        public int getExperimentsValue(int index) {
            return this.experiments_.get(index);
        }

        public Builder setExperimentsValue(int index, int value) {
            this.ensureExperimentsIsMutable();
            this.experiments_.set(index, value);
            this.onChanged();
            return this;
        }

        public Builder addExperimentsValue(int value) {
            this.ensureExperimentsIsMutable();
            this.experiments_.add(value);
            this.onChanged();
            return this;
        }

        public Builder addAllExperimentsValue(Iterable<Integer> values) {
            this.ensureExperimentsIsMutable();
            for (int value : values) {
                this.experiments_.add(value);
            }
            this.onChanged();
            return this;
        }

        public final Builder setUnknownFields(UnknownFieldSet unknownFields) {
            return (Builder)super.setUnknownFields(unknownFields);
        }

        public final Builder mergeUnknownFields(UnknownFieldSet unknownFields) {
            return (Builder)super.mergeUnknownFields(unknownFields);
        }
    }
}

