/*
 * Decompiled with CFR 0.152.
 */
package com.google.maps.routing.v2;

import com.google.maps.routing.v2.ComputeRoutesRequestOrBuilder;
import com.google.maps.routing.v2.PolylineEncoding;
import com.google.maps.routing.v2.PolylineQuality;
import com.google.maps.routing.v2.RouteModifiers;
import com.google.maps.routing.v2.RouteModifiersOrBuilder;
import com.google.maps.routing.v2.RouteTravelMode;
import com.google.maps.routing.v2.RoutesServiceProto;
import com.google.maps.routing.v2.RoutingPreference;
import com.google.maps.routing.v2.TrafficModel;
import com.google.maps.routing.v2.TransitPreferences;
import com.google.maps.routing.v2.TransitPreferencesOrBuilder;
import com.google.maps.routing.v2.Units;
import com.google.maps.routing.v2.Waypoint;
import com.google.maps.routing.v2.WaypointOrBuilder;
import com.google.protobuf.AbstractMessage;
import com.google.protobuf.AbstractMessageLite;
import com.google.protobuf.AbstractParser;
import com.google.protobuf.ByteString;
import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import com.google.protobuf.Descriptors;
import com.google.protobuf.ExtensionRegistryLite;
import com.google.protobuf.GeneratedMessageV3;
import com.google.protobuf.Internal;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import com.google.protobuf.MessageLite;
import com.google.protobuf.Parser;
import com.google.protobuf.ProtocolMessageEnum;
import com.google.protobuf.RepeatedFieldBuilderV3;
import com.google.protobuf.SingleFieldBuilderV3;
import com.google.protobuf.Timestamp;
import com.google.protobuf.TimestampOrBuilder;
import com.google.protobuf.UninitializedMessageException;
import com.google.protobuf.UnknownFieldSet;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class ComputeRoutesRequest
extends GeneratedMessageV3
implements ComputeRoutesRequestOrBuilder {
    private static final long serialVersionUID = 0L;
    private int bitField0_;
    public static final int ORIGIN_FIELD_NUMBER = 1;
    private Waypoint origin_;
    public static final int DESTINATION_FIELD_NUMBER = 2;
    private Waypoint destination_;
    public static final int INTERMEDIATES_FIELD_NUMBER = 3;
    private List<Waypoint> intermediates_;
    public static final int TRAVEL_MODE_FIELD_NUMBER = 4;
    private int travelMode_ = 0;
    public static final int ROUTING_PREFERENCE_FIELD_NUMBER = 5;
    private int routingPreference_ = 0;
    public static final int POLYLINE_QUALITY_FIELD_NUMBER = 6;
    private int polylineQuality_ = 0;
    public static final int POLYLINE_ENCODING_FIELD_NUMBER = 12;
    private int polylineEncoding_ = 0;
    public static final int DEPARTURE_TIME_FIELD_NUMBER = 7;
    private Timestamp departureTime_;
    public static final int ARRIVAL_TIME_FIELD_NUMBER = 19;
    private Timestamp arrivalTime_;
    public static final int COMPUTE_ALTERNATIVE_ROUTES_FIELD_NUMBER = 8;
    private boolean computeAlternativeRoutes_ = false;
    public static final int ROUTE_MODIFIERS_FIELD_NUMBER = 9;
    private RouteModifiers routeModifiers_;
    public static final int LANGUAGE_CODE_FIELD_NUMBER = 10;
    private volatile Object languageCode_ = "";
    public static final int REGION_CODE_FIELD_NUMBER = 16;
    private volatile Object regionCode_ = "";
    public static final int UNITS_FIELD_NUMBER = 11;
    private int units_ = 0;
    public static final int OPTIMIZE_WAYPOINT_ORDER_FIELD_NUMBER = 13;
    private boolean optimizeWaypointOrder_ = false;
    public static final int REQUESTED_REFERENCE_ROUTES_FIELD_NUMBER = 14;
    private List<Integer> requestedReferenceRoutes_;
    private static final Internal.ListAdapter.Converter<Integer, ReferenceRoute> requestedReferenceRoutes_converter_ = new Internal.ListAdapter.Converter<Integer, ReferenceRoute>(){

        public ReferenceRoute convert(Integer from) {
            ReferenceRoute result = ReferenceRoute.forNumber(from);
            return result == null ? ReferenceRoute.UNRECOGNIZED : result;
        }
    };
    private int requestedReferenceRoutesMemoizedSerializedSize;
    public static final int EXTRA_COMPUTATIONS_FIELD_NUMBER = 15;
    private List<Integer> extraComputations_;
    private static final Internal.ListAdapter.Converter<Integer, ExtraComputation> extraComputations_converter_ = new Internal.ListAdapter.Converter<Integer, ExtraComputation>(){

        public ExtraComputation convert(Integer from) {
            ExtraComputation result = ExtraComputation.forNumber(from);
            return result == null ? ExtraComputation.UNRECOGNIZED : result;
        }
    };
    private int extraComputationsMemoizedSerializedSize;
    public static final int TRAFFIC_MODEL_FIELD_NUMBER = 18;
    private int trafficModel_ = 0;
    public static final int TRANSIT_PREFERENCES_FIELD_NUMBER = 20;
    private TransitPreferences transitPreferences_;
    private byte memoizedIsInitialized = (byte)-1;
    private static final ComputeRoutesRequest DEFAULT_INSTANCE = new ComputeRoutesRequest();
    private static final Parser<ComputeRoutesRequest> PARSER = new AbstractParser<ComputeRoutesRequest>(){

        public ComputeRoutesRequest parsePartialFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            Builder builder = ComputeRoutesRequest.newBuilder();
            try {
                builder.mergeFrom(input, extensionRegistry);
            }
            catch (InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage((MessageLite)builder.buildPartial());
            }
            catch (UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException().setUnfinishedMessage((MessageLite)builder.buildPartial());
            }
            catch (IOException e) {
                throw new InvalidProtocolBufferException(e).setUnfinishedMessage((MessageLite)builder.buildPartial());
            }
            return builder.buildPartial();
        }
    };

    private ComputeRoutesRequest(GeneratedMessageV3.Builder<?> builder) {
        super(builder);
    }

    private ComputeRoutesRequest() {
        this.intermediates_ = Collections.emptyList();
        this.travelMode_ = 0;
        this.routingPreference_ = 0;
        this.polylineQuality_ = 0;
        this.polylineEncoding_ = 0;
        this.languageCode_ = "";
        this.regionCode_ = "";
        this.units_ = 0;
        this.requestedReferenceRoutes_ = Collections.emptyList();
        this.extraComputations_ = Collections.emptyList();
        this.trafficModel_ = 0;
    }

    protected Object newInstance(GeneratedMessageV3.UnusedPrivateParameter unused) {
        return new ComputeRoutesRequest();
    }

    public static final Descriptors.Descriptor getDescriptor() {
        return RoutesServiceProto.internal_static_google_maps_routing_v2_ComputeRoutesRequest_descriptor;
    }

    protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
        return RoutesServiceProto.internal_static_google_maps_routing_v2_ComputeRoutesRequest_fieldAccessorTable.ensureFieldAccessorsInitialized(ComputeRoutesRequest.class, Builder.class);
    }

    @Override
    public boolean hasOrigin() {
        return (this.bitField0_ & 1) != 0;
    }

    @Override
    public Waypoint getOrigin() {
        return this.origin_ == null ? Waypoint.getDefaultInstance() : this.origin_;
    }

    @Override
    public WaypointOrBuilder getOriginOrBuilder() {
        return this.origin_ == null ? Waypoint.getDefaultInstance() : this.origin_;
    }

    @Override
    public boolean hasDestination() {
        return (this.bitField0_ & 2) != 0;
    }

    @Override
    public Waypoint getDestination() {
        return this.destination_ == null ? Waypoint.getDefaultInstance() : this.destination_;
    }

    @Override
    public WaypointOrBuilder getDestinationOrBuilder() {
        return this.destination_ == null ? Waypoint.getDefaultInstance() : this.destination_;
    }

    @Override
    public List<Waypoint> getIntermediatesList() {
        return this.intermediates_;
    }

    @Override
    public List<? extends WaypointOrBuilder> getIntermediatesOrBuilderList() {
        return this.intermediates_;
    }

    @Override
    public int getIntermediatesCount() {
        return this.intermediates_.size();
    }

    @Override
    public Waypoint getIntermediates(int index) {
        return this.intermediates_.get(index);
    }

    @Override
    public WaypointOrBuilder getIntermediatesOrBuilder(int index) {
        return this.intermediates_.get(index);
    }

    @Override
    public int getTravelModeValue() {
        return this.travelMode_;
    }

    @Override
    public RouteTravelMode getTravelMode() {
        RouteTravelMode result = RouteTravelMode.forNumber(this.travelMode_);
        return result == null ? RouteTravelMode.UNRECOGNIZED : result;
    }

    @Override
    public int getRoutingPreferenceValue() {
        return this.routingPreference_;
    }

    @Override
    public RoutingPreference getRoutingPreference() {
        RoutingPreference result = RoutingPreference.forNumber(this.routingPreference_);
        return result == null ? RoutingPreference.UNRECOGNIZED : result;
    }

    @Override
    public int getPolylineQualityValue() {
        return this.polylineQuality_;
    }

    @Override
    public PolylineQuality getPolylineQuality() {
        PolylineQuality result = PolylineQuality.forNumber(this.polylineQuality_);
        return result == null ? PolylineQuality.UNRECOGNIZED : result;
    }

    @Override
    public int getPolylineEncodingValue() {
        return this.polylineEncoding_;
    }

    @Override
    public PolylineEncoding getPolylineEncoding() {
        PolylineEncoding result = PolylineEncoding.forNumber(this.polylineEncoding_);
        return result == null ? PolylineEncoding.UNRECOGNIZED : result;
    }

    @Override
    public boolean hasDepartureTime() {
        return (this.bitField0_ & 4) != 0;
    }

    @Override
    public Timestamp getDepartureTime() {
        return this.departureTime_ == null ? Timestamp.getDefaultInstance() : this.departureTime_;
    }

    @Override
    public TimestampOrBuilder getDepartureTimeOrBuilder() {
        return this.departureTime_ == null ? Timestamp.getDefaultInstance() : this.departureTime_;
    }

    @Override
    public boolean hasArrivalTime() {
        return (this.bitField0_ & 8) != 0;
    }

    @Override
    public Timestamp getArrivalTime() {
        return this.arrivalTime_ == null ? Timestamp.getDefaultInstance() : this.arrivalTime_;
    }

    @Override
    public TimestampOrBuilder getArrivalTimeOrBuilder() {
        return this.arrivalTime_ == null ? Timestamp.getDefaultInstance() : this.arrivalTime_;
    }

    @Override
    public boolean getComputeAlternativeRoutes() {
        return this.computeAlternativeRoutes_;
    }

    @Override
    public boolean hasRouteModifiers() {
        return (this.bitField0_ & 0x10) != 0;
    }

    @Override
    public RouteModifiers getRouteModifiers() {
        return this.routeModifiers_ == null ? RouteModifiers.getDefaultInstance() : this.routeModifiers_;
    }

    @Override
    public RouteModifiersOrBuilder getRouteModifiersOrBuilder() {
        return this.routeModifiers_ == null ? RouteModifiers.getDefaultInstance() : this.routeModifiers_;
    }

    @Override
    public String getLanguageCode() {
        Object ref = this.languageCode_;
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s = bs.toStringUtf8();
        this.languageCode_ = s;
        return s;
    }

    @Override
    public ByteString getLanguageCodeBytes() {
        Object ref = this.languageCode_;
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)((String)ref));
            this.languageCode_ = b;
            return b;
        }
        return (ByteString)ref;
    }

    @Override
    public String getRegionCode() {
        Object ref = this.regionCode_;
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s = bs.toStringUtf8();
        this.regionCode_ = s;
        return s;
    }

    @Override
    public ByteString getRegionCodeBytes() {
        Object ref = this.regionCode_;
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)((String)ref));
            this.regionCode_ = b;
            return b;
        }
        return (ByteString)ref;
    }

    @Override
    public int getUnitsValue() {
        return this.units_;
    }

    @Override
    public Units getUnits() {
        Units result = Units.forNumber(this.units_);
        return result == null ? Units.UNRECOGNIZED : result;
    }

    @Override
    public boolean getOptimizeWaypointOrder() {
        return this.optimizeWaypointOrder_;
    }

    @Override
    public List<ReferenceRoute> getRequestedReferenceRoutesList() {
        return new Internal.ListAdapter(this.requestedReferenceRoutes_, requestedReferenceRoutes_converter_);
    }

    @Override
    public int getRequestedReferenceRoutesCount() {
        return this.requestedReferenceRoutes_.size();
    }

    @Override
    public ReferenceRoute getRequestedReferenceRoutes(int index) {
        return (ReferenceRoute)((Object)requestedReferenceRoutes_converter_.convert((Object)this.requestedReferenceRoutes_.get(index)));
    }

    @Override
    public List<Integer> getRequestedReferenceRoutesValueList() {
        return this.requestedReferenceRoutes_;
    }

    @Override
    public int getRequestedReferenceRoutesValue(int index) {
        return this.requestedReferenceRoutes_.get(index);
    }

    @Override
    public List<ExtraComputation> getExtraComputationsList() {
        return new Internal.ListAdapter(this.extraComputations_, extraComputations_converter_);
    }

    @Override
    public int getExtraComputationsCount() {
        return this.extraComputations_.size();
    }

    @Override
    public ExtraComputation getExtraComputations(int index) {
        return (ExtraComputation)((Object)extraComputations_converter_.convert((Object)this.extraComputations_.get(index)));
    }

    @Override
    public List<Integer> getExtraComputationsValueList() {
        return this.extraComputations_;
    }

    @Override
    public int getExtraComputationsValue(int index) {
        return this.extraComputations_.get(index);
    }

    @Override
    public int getTrafficModelValue() {
        return this.trafficModel_;
    }

    @Override
    public TrafficModel getTrafficModel() {
        TrafficModel result = TrafficModel.forNumber(this.trafficModel_);
        return result == null ? TrafficModel.UNRECOGNIZED : result;
    }

    @Override
    public boolean hasTransitPreferences() {
        return (this.bitField0_ & 0x20) != 0;
    }

    @Override
    public TransitPreferences getTransitPreferences() {
        return this.transitPreferences_ == null ? TransitPreferences.getDefaultInstance() : this.transitPreferences_;
    }

    @Override
    public TransitPreferencesOrBuilder getTransitPreferencesOrBuilder() {
        return this.transitPreferences_ == null ? TransitPreferences.getDefaultInstance() : this.transitPreferences_;
    }

    public final boolean isInitialized() {
        byte isInitialized = this.memoizedIsInitialized;
        if (isInitialized == 1) {
            return true;
        }
        if (isInitialized == 0) {
            return false;
        }
        this.memoizedIsInitialized = 1;
        return true;
    }

    public void writeTo(CodedOutputStream output) throws IOException {
        int i;
        this.getSerializedSize();
        if ((this.bitField0_ & 1) != 0) {
            output.writeMessage(1, (MessageLite)this.getOrigin());
        }
        if ((this.bitField0_ & 2) != 0) {
            output.writeMessage(2, (MessageLite)this.getDestination());
        }
        for (i = 0; i < this.intermediates_.size(); ++i) {
            output.writeMessage(3, (MessageLite)this.intermediates_.get(i));
        }
        if (this.travelMode_ != RouteTravelMode.TRAVEL_MODE_UNSPECIFIED.getNumber()) {
            output.writeEnum(4, this.travelMode_);
        }
        if (this.routingPreference_ != RoutingPreference.ROUTING_PREFERENCE_UNSPECIFIED.getNumber()) {
            output.writeEnum(5, this.routingPreference_);
        }
        if (this.polylineQuality_ != PolylineQuality.POLYLINE_QUALITY_UNSPECIFIED.getNumber()) {
            output.writeEnum(6, this.polylineQuality_);
        }
        if ((this.bitField0_ & 4) != 0) {
            output.writeMessage(7, (MessageLite)this.getDepartureTime());
        }
        if (this.computeAlternativeRoutes_) {
            output.writeBool(8, this.computeAlternativeRoutes_);
        }
        if ((this.bitField0_ & 0x10) != 0) {
            output.writeMessage(9, (MessageLite)this.getRouteModifiers());
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.languageCode_)) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)10, (Object)this.languageCode_);
        }
        if (this.units_ != Units.UNITS_UNSPECIFIED.getNumber()) {
            output.writeEnum(11, this.units_);
        }
        if (this.polylineEncoding_ != PolylineEncoding.POLYLINE_ENCODING_UNSPECIFIED.getNumber()) {
            output.writeEnum(12, this.polylineEncoding_);
        }
        if (this.optimizeWaypointOrder_) {
            output.writeBool(13, this.optimizeWaypointOrder_);
        }
        if (this.getRequestedReferenceRoutesList().size() > 0) {
            output.writeUInt32NoTag(114);
            output.writeUInt32NoTag(this.requestedReferenceRoutesMemoizedSerializedSize);
        }
        for (i = 0; i < this.requestedReferenceRoutes_.size(); ++i) {
            output.writeEnumNoTag(this.requestedReferenceRoutes_.get(i).intValue());
        }
        if (this.getExtraComputationsList().size() > 0) {
            output.writeUInt32NoTag(122);
            output.writeUInt32NoTag(this.extraComputationsMemoizedSerializedSize);
        }
        for (i = 0; i < this.extraComputations_.size(); ++i) {
            output.writeEnumNoTag(this.extraComputations_.get(i).intValue());
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.regionCode_)) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)16, (Object)this.regionCode_);
        }
        if (this.trafficModel_ != TrafficModel.TRAFFIC_MODEL_UNSPECIFIED.getNumber()) {
            output.writeEnum(18, this.trafficModel_);
        }
        if ((this.bitField0_ & 8) != 0) {
            output.writeMessage(19, (MessageLite)this.getArrivalTime());
        }
        if ((this.bitField0_ & 0x20) != 0) {
            output.writeMessage(20, (MessageLite)this.getTransitPreferences());
        }
        this.getUnknownFields().writeTo(output);
    }

    public int getSerializedSize() {
        int i;
        int size = this.memoizedSize;
        if (size != -1) {
            return size;
        }
        size = 0;
        if ((this.bitField0_ & 1) != 0) {
            size += CodedOutputStream.computeMessageSize((int)1, (MessageLite)this.getOrigin());
        }
        if ((this.bitField0_ & 2) != 0) {
            size += CodedOutputStream.computeMessageSize((int)2, (MessageLite)this.getDestination());
        }
        for (int i2 = 0; i2 < this.intermediates_.size(); ++i2) {
            size += CodedOutputStream.computeMessageSize((int)3, (MessageLite)((MessageLite)this.intermediates_.get(i2)));
        }
        if (this.travelMode_ != RouteTravelMode.TRAVEL_MODE_UNSPECIFIED.getNumber()) {
            size += CodedOutputStream.computeEnumSize((int)4, (int)this.travelMode_);
        }
        if (this.routingPreference_ != RoutingPreference.ROUTING_PREFERENCE_UNSPECIFIED.getNumber()) {
            size += CodedOutputStream.computeEnumSize((int)5, (int)this.routingPreference_);
        }
        if (this.polylineQuality_ != PolylineQuality.POLYLINE_QUALITY_UNSPECIFIED.getNumber()) {
            size += CodedOutputStream.computeEnumSize((int)6, (int)this.polylineQuality_);
        }
        if ((this.bitField0_ & 4) != 0) {
            size += CodedOutputStream.computeMessageSize((int)7, (MessageLite)this.getDepartureTime());
        }
        if (this.computeAlternativeRoutes_) {
            size += CodedOutputStream.computeBoolSize((int)8, (boolean)this.computeAlternativeRoutes_);
        }
        if ((this.bitField0_ & 0x10) != 0) {
            size += CodedOutputStream.computeMessageSize((int)9, (MessageLite)this.getRouteModifiers());
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.languageCode_)) {
            size += GeneratedMessageV3.computeStringSize((int)10, (Object)this.languageCode_);
        }
        if (this.units_ != Units.UNITS_UNSPECIFIED.getNumber()) {
            size += CodedOutputStream.computeEnumSize((int)11, (int)this.units_);
        }
        if (this.polylineEncoding_ != PolylineEncoding.POLYLINE_ENCODING_UNSPECIFIED.getNumber()) {
            size += CodedOutputStream.computeEnumSize((int)12, (int)this.polylineEncoding_);
        }
        if (this.optimizeWaypointOrder_) {
            size += CodedOutputStream.computeBoolSize((int)13, (boolean)this.optimizeWaypointOrder_);
        }
        int dataSize = 0;
        for (i = 0; i < this.requestedReferenceRoutes_.size(); ++i) {
            dataSize += CodedOutputStream.computeEnumSizeNoTag((int)this.requestedReferenceRoutes_.get(i));
        }
        size += dataSize;
        if (!this.getRequestedReferenceRoutesList().isEmpty()) {
            ++size;
            size += CodedOutputStream.computeUInt32SizeNoTag((int)dataSize);
        }
        this.requestedReferenceRoutesMemoizedSerializedSize = dataSize;
        dataSize = 0;
        for (i = 0; i < this.extraComputations_.size(); ++i) {
            dataSize += CodedOutputStream.computeEnumSizeNoTag((int)this.extraComputations_.get(i));
        }
        size += dataSize;
        if (!this.getExtraComputationsList().isEmpty()) {
            ++size;
            size += CodedOutputStream.computeUInt32SizeNoTag((int)dataSize);
        }
        this.extraComputationsMemoizedSerializedSize = dataSize;
        if (!GeneratedMessageV3.isStringEmpty((Object)this.regionCode_)) {
            size += GeneratedMessageV3.computeStringSize((int)16, (Object)this.regionCode_);
        }
        if (this.trafficModel_ != TrafficModel.TRAFFIC_MODEL_UNSPECIFIED.getNumber()) {
            size += CodedOutputStream.computeEnumSize((int)18, (int)this.trafficModel_);
        }
        if ((this.bitField0_ & 8) != 0) {
            size += CodedOutputStream.computeMessageSize((int)19, (MessageLite)this.getArrivalTime());
        }
        if ((this.bitField0_ & 0x20) != 0) {
            size += CodedOutputStream.computeMessageSize((int)20, (MessageLite)this.getTransitPreferences());
        }
        this.memoizedSize = size += this.getUnknownFields().getSerializedSize();
        return size;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ComputeRoutesRequest)) {
            return super.equals(obj);
        }
        ComputeRoutesRequest other = (ComputeRoutesRequest)obj;
        if (this.hasOrigin() != other.hasOrigin()) {
            return false;
        }
        if (this.hasOrigin() && !this.getOrigin().equals(other.getOrigin())) {
            return false;
        }
        if (this.hasDestination() != other.hasDestination()) {
            return false;
        }
        if (this.hasDestination() && !this.getDestination().equals(other.getDestination())) {
            return false;
        }
        if (!this.getIntermediatesList().equals(other.getIntermediatesList())) {
            return false;
        }
        if (this.travelMode_ != other.travelMode_) {
            return false;
        }
        if (this.routingPreference_ != other.routingPreference_) {
            return false;
        }
        if (this.polylineQuality_ != other.polylineQuality_) {
            return false;
        }
        if (this.polylineEncoding_ != other.polylineEncoding_) {
            return false;
        }
        if (this.hasDepartureTime() != other.hasDepartureTime()) {
            return false;
        }
        if (this.hasDepartureTime() && !this.getDepartureTime().equals((Object)other.getDepartureTime())) {
            return false;
        }
        if (this.hasArrivalTime() != other.hasArrivalTime()) {
            return false;
        }
        if (this.hasArrivalTime() && !this.getArrivalTime().equals((Object)other.getArrivalTime())) {
            return false;
        }
        if (this.getComputeAlternativeRoutes() != other.getComputeAlternativeRoutes()) {
            return false;
        }
        if (this.hasRouteModifiers() != other.hasRouteModifiers()) {
            return false;
        }
        if (this.hasRouteModifiers() && !this.getRouteModifiers().equals(other.getRouteModifiers())) {
            return false;
        }
        if (!this.getLanguageCode().equals(other.getLanguageCode())) {
            return false;
        }
        if (!this.getRegionCode().equals(other.getRegionCode())) {
            return false;
        }
        if (this.units_ != other.units_) {
            return false;
        }
        if (this.getOptimizeWaypointOrder() != other.getOptimizeWaypointOrder()) {
            return false;
        }
        if (!this.requestedReferenceRoutes_.equals(other.requestedReferenceRoutes_)) {
            return false;
        }
        if (!this.extraComputations_.equals(other.extraComputations_)) {
            return false;
        }
        if (this.trafficModel_ != other.trafficModel_) {
            return false;
        }
        if (this.hasTransitPreferences() != other.hasTransitPreferences()) {
            return false;
        }
        if (this.hasTransitPreferences() && !this.getTransitPreferences().equals(other.getTransitPreferences())) {
            return false;
        }
        return this.getUnknownFields().equals((Object)other.getUnknownFields());
    }

    public int hashCode() {
        if (this.memoizedHashCode != 0) {
            return this.memoizedHashCode;
        }
        int hash = 41;
        hash = 19 * hash + ComputeRoutesRequest.getDescriptor().hashCode();
        if (this.hasOrigin()) {
            hash = 37 * hash + 1;
            hash = 53 * hash + this.getOrigin().hashCode();
        }
        if (this.hasDestination()) {
            hash = 37 * hash + 2;
            hash = 53 * hash + this.getDestination().hashCode();
        }
        if (this.getIntermediatesCount() > 0) {
            hash = 37 * hash + 3;
            hash = 53 * hash + this.getIntermediatesList().hashCode();
        }
        hash = 37 * hash + 4;
        hash = 53 * hash + this.travelMode_;
        hash = 37 * hash + 5;
        hash = 53 * hash + this.routingPreference_;
        hash = 37 * hash + 6;
        hash = 53 * hash + this.polylineQuality_;
        hash = 37 * hash + 12;
        hash = 53 * hash + this.polylineEncoding_;
        if (this.hasDepartureTime()) {
            hash = 37 * hash + 7;
            hash = 53 * hash + this.getDepartureTime().hashCode();
        }
        if (this.hasArrivalTime()) {
            hash = 37 * hash + 19;
            hash = 53 * hash + this.getArrivalTime().hashCode();
        }
        hash = 37 * hash + 8;
        hash = 53 * hash + Internal.hashBoolean((boolean)this.getComputeAlternativeRoutes());
        if (this.hasRouteModifiers()) {
            hash = 37 * hash + 9;
            hash = 53 * hash + this.getRouteModifiers().hashCode();
        }
        hash = 37 * hash + 10;
        hash = 53 * hash + this.getLanguageCode().hashCode();
        hash = 37 * hash + 16;
        hash = 53 * hash + this.getRegionCode().hashCode();
        hash = 37 * hash + 11;
        hash = 53 * hash + this.units_;
        hash = 37 * hash + 13;
        hash = 53 * hash + Internal.hashBoolean((boolean)this.getOptimizeWaypointOrder());
        if (this.getRequestedReferenceRoutesCount() > 0) {
            hash = 37 * hash + 14;
            hash = 53 * hash + this.requestedReferenceRoutes_.hashCode();
        }
        if (this.getExtraComputationsCount() > 0) {
            hash = 37 * hash + 15;
            hash = 53 * hash + this.extraComputations_.hashCode();
        }
        hash = 37 * hash + 18;
        hash = 53 * hash + this.trafficModel_;
        if (this.hasTransitPreferences()) {
            hash = 37 * hash + 20;
            hash = 53 * hash + this.getTransitPreferences().hashCode();
        }
        this.memoizedHashCode = hash = 29 * hash + this.getUnknownFields().hashCode();
        return hash;
    }

    public static ComputeRoutesRequest parseFrom(ByteBuffer data) throws InvalidProtocolBufferException {
        return (ComputeRoutesRequest)PARSER.parseFrom(data);
    }

    public static ComputeRoutesRequest parseFrom(ByteBuffer data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (ComputeRoutesRequest)PARSER.parseFrom(data, extensionRegistry);
    }

    public static ComputeRoutesRequest parseFrom(ByteString data) throws InvalidProtocolBufferException {
        return (ComputeRoutesRequest)PARSER.parseFrom(data);
    }

    public static ComputeRoutesRequest parseFrom(ByteString data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (ComputeRoutesRequest)PARSER.parseFrom(data, extensionRegistry);
    }

    public static ComputeRoutesRequest parseFrom(byte[] data) throws InvalidProtocolBufferException {
        return (ComputeRoutesRequest)PARSER.parseFrom(data);
    }

    public static ComputeRoutesRequest parseFrom(byte[] data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (ComputeRoutesRequest)PARSER.parseFrom(data, extensionRegistry);
    }

    public static ComputeRoutesRequest parseFrom(InputStream input) throws IOException {
        return (ComputeRoutesRequest)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input);
    }

    public static ComputeRoutesRequest parseFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (ComputeRoutesRequest)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public static ComputeRoutesRequest parseDelimitedFrom(InputStream input) throws IOException {
        return (ComputeRoutesRequest)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input);
    }

    public static ComputeRoutesRequest parseDelimitedFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (ComputeRoutesRequest)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public static ComputeRoutesRequest parseFrom(CodedInputStream input) throws IOException {
        return (ComputeRoutesRequest)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input);
    }

    public static ComputeRoutesRequest parseFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (ComputeRoutesRequest)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public Builder newBuilderForType() {
        return ComputeRoutesRequest.newBuilder();
    }

    public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(ComputeRoutesRequest prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    protected Builder newBuilderForType(GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
    }

    public static ComputeRoutesRequest getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public static Parser<ComputeRoutesRequest> parser() {
        return PARSER;
    }

    public Parser<ComputeRoutesRequest> getParserForType() {
        return PARSER;
    }

    public ComputeRoutesRequest getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
    }

    public static final class Builder
    extends GeneratedMessageV3.Builder<Builder>
    implements ComputeRoutesRequestOrBuilder {
        private int bitField0_;
        private Waypoint origin_;
        private SingleFieldBuilderV3<Waypoint, Waypoint.Builder, WaypointOrBuilder> originBuilder_;
        private Waypoint destination_;
        private SingleFieldBuilderV3<Waypoint, Waypoint.Builder, WaypointOrBuilder> destinationBuilder_;
        private List<Waypoint> intermediates_ = Collections.emptyList();
        private RepeatedFieldBuilderV3<Waypoint, Waypoint.Builder, WaypointOrBuilder> intermediatesBuilder_;
        private int travelMode_ = 0;
        private int routingPreference_ = 0;
        private int polylineQuality_ = 0;
        private int polylineEncoding_ = 0;
        private Timestamp departureTime_;
        private SingleFieldBuilderV3<Timestamp, Timestamp.Builder, TimestampOrBuilder> departureTimeBuilder_;
        private Timestamp arrivalTime_;
        private SingleFieldBuilderV3<Timestamp, Timestamp.Builder, TimestampOrBuilder> arrivalTimeBuilder_;
        private boolean computeAlternativeRoutes_;
        private RouteModifiers routeModifiers_;
        private SingleFieldBuilderV3<RouteModifiers, RouteModifiers.Builder, RouteModifiersOrBuilder> routeModifiersBuilder_;
        private Object languageCode_ = "";
        private Object regionCode_ = "";
        private int units_ = 0;
        private boolean optimizeWaypointOrder_;
        private List<Integer> requestedReferenceRoutes_ = Collections.emptyList();
        private List<Integer> extraComputations_ = Collections.emptyList();
        private int trafficModel_ = 0;
        private TransitPreferences transitPreferences_;
        private SingleFieldBuilderV3<TransitPreferences, TransitPreferences.Builder, TransitPreferencesOrBuilder> transitPreferencesBuilder_;

        public static final Descriptors.Descriptor getDescriptor() {
            return RoutesServiceProto.internal_static_google_maps_routing_v2_ComputeRoutesRequest_descriptor;
        }

        protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
            return RoutesServiceProto.internal_static_google_maps_routing_v2_ComputeRoutesRequest_fieldAccessorTable.ensureFieldAccessorsInitialized(ComputeRoutesRequest.class, Builder.class);
        }

        private Builder() {
            this.maybeForceBuilderInitialization();
        }

        private Builder(GeneratedMessageV3.BuilderParent parent) {
            super(parent);
            this.maybeForceBuilderInitialization();
        }

        private void maybeForceBuilderInitialization() {
            if (alwaysUseFieldBuilders) {
                this.getOriginFieldBuilder();
                this.getDestinationFieldBuilder();
                this.getIntermediatesFieldBuilder();
                this.getDepartureTimeFieldBuilder();
                this.getArrivalTimeFieldBuilder();
                this.getRouteModifiersFieldBuilder();
                this.getTransitPreferencesFieldBuilder();
            }
        }

        public Builder clear() {
            super.clear();
            this.bitField0_ = 0;
            this.origin_ = null;
            if (this.originBuilder_ != null) {
                this.originBuilder_.dispose();
                this.originBuilder_ = null;
            }
            this.destination_ = null;
            if (this.destinationBuilder_ != null) {
                this.destinationBuilder_.dispose();
                this.destinationBuilder_ = null;
            }
            if (this.intermediatesBuilder_ == null) {
                this.intermediates_ = Collections.emptyList();
            } else {
                this.intermediates_ = null;
                this.intermediatesBuilder_.clear();
            }
            this.bitField0_ &= 0xFFFFFFFB;
            this.travelMode_ = 0;
            this.routingPreference_ = 0;
            this.polylineQuality_ = 0;
            this.polylineEncoding_ = 0;
            this.departureTime_ = null;
            if (this.departureTimeBuilder_ != null) {
                this.departureTimeBuilder_.dispose();
                this.departureTimeBuilder_ = null;
            }
            this.arrivalTime_ = null;
            if (this.arrivalTimeBuilder_ != null) {
                this.arrivalTimeBuilder_.dispose();
                this.arrivalTimeBuilder_ = null;
            }
            this.computeAlternativeRoutes_ = false;
            this.routeModifiers_ = null;
            if (this.routeModifiersBuilder_ != null) {
                this.routeModifiersBuilder_.dispose();
                this.routeModifiersBuilder_ = null;
            }
            this.languageCode_ = "";
            this.regionCode_ = "";
            this.units_ = 0;
            this.optimizeWaypointOrder_ = false;
            this.requestedReferenceRoutes_ = Collections.emptyList();
            this.bitField0_ &= 0xFFFF7FFF;
            this.extraComputations_ = Collections.emptyList();
            this.bitField0_ &= 0xFFFEFFFF;
            this.trafficModel_ = 0;
            this.transitPreferences_ = null;
            if (this.transitPreferencesBuilder_ != null) {
                this.transitPreferencesBuilder_.dispose();
                this.transitPreferencesBuilder_ = null;
            }
            return this;
        }

        public Descriptors.Descriptor getDescriptorForType() {
            return RoutesServiceProto.internal_static_google_maps_routing_v2_ComputeRoutesRequest_descriptor;
        }

        public ComputeRoutesRequest getDefaultInstanceForType() {
            return ComputeRoutesRequest.getDefaultInstance();
        }

        public ComputeRoutesRequest build() {
            ComputeRoutesRequest result = this.buildPartial();
            if (!result.isInitialized()) {
                throw Builder.newUninitializedMessageException((Message)result);
            }
            return result;
        }

        public ComputeRoutesRequest buildPartial() {
            ComputeRoutesRequest result = new ComputeRoutesRequest(this);
            this.buildPartialRepeatedFields(result);
            if (this.bitField0_ != 0) {
                this.buildPartial0(result);
            }
            this.onBuilt();
            return result;
        }

        private void buildPartialRepeatedFields(ComputeRoutesRequest result) {
            if (this.intermediatesBuilder_ == null) {
                if ((this.bitField0_ & 4) != 0) {
                    this.intermediates_ = Collections.unmodifiableList(this.intermediates_);
                    this.bitField0_ &= 0xFFFFFFFB;
                }
                result.intermediates_ = this.intermediates_;
            } else {
                result.intermediates_ = this.intermediatesBuilder_.build();
            }
            if ((this.bitField0_ & 0x8000) != 0) {
                this.requestedReferenceRoutes_ = Collections.unmodifiableList(this.requestedReferenceRoutes_);
                this.bitField0_ &= 0xFFFF7FFF;
            }
            result.requestedReferenceRoutes_ = this.requestedReferenceRoutes_;
            if ((this.bitField0_ & 0x10000) != 0) {
                this.extraComputations_ = Collections.unmodifiableList(this.extraComputations_);
                this.bitField0_ &= 0xFFFEFFFF;
            }
            result.extraComputations_ = this.extraComputations_;
        }

        private void buildPartial0(ComputeRoutesRequest result) {
            int from_bitField0_ = this.bitField0_;
            int to_bitField0_ = 0;
            if ((from_bitField0_ & 1) != 0) {
                result.origin_ = this.originBuilder_ == null ? this.origin_ : (Waypoint)this.originBuilder_.build();
                to_bitField0_ |= 1;
            }
            if ((from_bitField0_ & 2) != 0) {
                result.destination_ = this.destinationBuilder_ == null ? this.destination_ : (Waypoint)this.destinationBuilder_.build();
                to_bitField0_ |= 2;
            }
            if ((from_bitField0_ & 8) != 0) {
                result.travelMode_ = this.travelMode_;
            }
            if ((from_bitField0_ & 0x10) != 0) {
                result.routingPreference_ = this.routingPreference_;
            }
            if ((from_bitField0_ & 0x20) != 0) {
                result.polylineQuality_ = this.polylineQuality_;
            }
            if ((from_bitField0_ & 0x40) != 0) {
                result.polylineEncoding_ = this.polylineEncoding_;
            }
            if ((from_bitField0_ & 0x80) != 0) {
                result.departureTime_ = this.departureTimeBuilder_ == null ? this.departureTime_ : (Timestamp)this.departureTimeBuilder_.build();
                to_bitField0_ |= 4;
            }
            if ((from_bitField0_ & 0x100) != 0) {
                result.arrivalTime_ = this.arrivalTimeBuilder_ == null ? this.arrivalTime_ : (Timestamp)this.arrivalTimeBuilder_.build();
                to_bitField0_ |= 8;
            }
            if ((from_bitField0_ & 0x200) != 0) {
                result.computeAlternativeRoutes_ = this.computeAlternativeRoutes_;
            }
            if ((from_bitField0_ & 0x400) != 0) {
                result.routeModifiers_ = this.routeModifiersBuilder_ == null ? this.routeModifiers_ : (RouteModifiers)this.routeModifiersBuilder_.build();
                to_bitField0_ |= 0x10;
            }
            if ((from_bitField0_ & 0x800) != 0) {
                result.languageCode_ = this.languageCode_;
            }
            if ((from_bitField0_ & 0x1000) != 0) {
                result.regionCode_ = this.regionCode_;
            }
            if ((from_bitField0_ & 0x2000) != 0) {
                result.units_ = this.units_;
            }
            if ((from_bitField0_ & 0x4000) != 0) {
                result.optimizeWaypointOrder_ = this.optimizeWaypointOrder_;
            }
            if ((from_bitField0_ & 0x20000) != 0) {
                result.trafficModel_ = this.trafficModel_;
            }
            if ((from_bitField0_ & 0x40000) != 0) {
                result.transitPreferences_ = this.transitPreferencesBuilder_ == null ? this.transitPreferences_ : (TransitPreferences)this.transitPreferencesBuilder_.build();
                to_bitField0_ |= 0x20;
            }
            ComputeRoutesRequest computeRoutesRequest = result;
            computeRoutesRequest.bitField0_ = computeRoutesRequest.bitField0_ | to_bitField0_;
        }

        public Builder clone() {
            return (Builder)super.clone();
        }

        public Builder setField(Descriptors.FieldDescriptor field, Object value) {
            return (Builder)super.setField(field, value);
        }

        public Builder clearField(Descriptors.FieldDescriptor field) {
            return (Builder)super.clearField(field);
        }

        public Builder clearOneof(Descriptors.OneofDescriptor oneof) {
            return (Builder)super.clearOneof(oneof);
        }

        public Builder setRepeatedField(Descriptors.FieldDescriptor field, int index, Object value) {
            return (Builder)super.setRepeatedField(field, index, value);
        }

        public Builder addRepeatedField(Descriptors.FieldDescriptor field, Object value) {
            return (Builder)super.addRepeatedField(field, value);
        }

        public Builder mergeFrom(Message other) {
            if (other instanceof ComputeRoutesRequest) {
                return this.mergeFrom((ComputeRoutesRequest)other);
            }
            super.mergeFrom(other);
            return this;
        }

        public Builder mergeFrom(ComputeRoutesRequest other) {
            if (other == ComputeRoutesRequest.getDefaultInstance()) {
                return this;
            }
            if (other.hasOrigin()) {
                this.mergeOrigin(other.getOrigin());
            }
            if (other.hasDestination()) {
                this.mergeDestination(other.getDestination());
            }
            if (this.intermediatesBuilder_ == null) {
                if (!other.intermediates_.isEmpty()) {
                    if (this.intermediates_.isEmpty()) {
                        this.intermediates_ = other.intermediates_;
                        this.bitField0_ &= 0xFFFFFFFB;
                    } else {
                        this.ensureIntermediatesIsMutable();
                        this.intermediates_.addAll(other.intermediates_);
                    }
                    this.onChanged();
                }
            } else if (!other.intermediates_.isEmpty()) {
                if (this.intermediatesBuilder_.isEmpty()) {
                    this.intermediatesBuilder_.dispose();
                    this.intermediatesBuilder_ = null;
                    this.intermediates_ = other.intermediates_;
                    this.bitField0_ &= 0xFFFFFFFB;
                    this.intermediatesBuilder_ = alwaysUseFieldBuilders ? this.getIntermediatesFieldBuilder() : null;
                } else {
                    this.intermediatesBuilder_.addAllMessages((Iterable)other.intermediates_);
                }
            }
            if (other.travelMode_ != 0) {
                this.setTravelModeValue(other.getTravelModeValue());
            }
            if (other.routingPreference_ != 0) {
                this.setRoutingPreferenceValue(other.getRoutingPreferenceValue());
            }
            if (other.polylineQuality_ != 0) {
                this.setPolylineQualityValue(other.getPolylineQualityValue());
            }
            if (other.polylineEncoding_ != 0) {
                this.setPolylineEncodingValue(other.getPolylineEncodingValue());
            }
            if (other.hasDepartureTime()) {
                this.mergeDepartureTime(other.getDepartureTime());
            }
            if (other.hasArrivalTime()) {
                this.mergeArrivalTime(other.getArrivalTime());
            }
            if (other.getComputeAlternativeRoutes()) {
                this.setComputeAlternativeRoutes(other.getComputeAlternativeRoutes());
            }
            if (other.hasRouteModifiers()) {
                this.mergeRouteModifiers(other.getRouteModifiers());
            }
            if (!other.getLanguageCode().isEmpty()) {
                this.languageCode_ = other.languageCode_;
                this.bitField0_ |= 0x800;
                this.onChanged();
            }
            if (!other.getRegionCode().isEmpty()) {
                this.regionCode_ = other.regionCode_;
                this.bitField0_ |= 0x1000;
                this.onChanged();
            }
            if (other.units_ != 0) {
                this.setUnitsValue(other.getUnitsValue());
            }
            if (other.getOptimizeWaypointOrder()) {
                this.setOptimizeWaypointOrder(other.getOptimizeWaypointOrder());
            }
            if (!other.requestedReferenceRoutes_.isEmpty()) {
                if (this.requestedReferenceRoutes_.isEmpty()) {
                    this.requestedReferenceRoutes_ = other.requestedReferenceRoutes_;
                    this.bitField0_ &= 0xFFFF7FFF;
                } else {
                    this.ensureRequestedReferenceRoutesIsMutable();
                    this.requestedReferenceRoutes_.addAll(other.requestedReferenceRoutes_);
                }
                this.onChanged();
            }
            if (!other.extraComputations_.isEmpty()) {
                if (this.extraComputations_.isEmpty()) {
                    this.extraComputations_ = other.extraComputations_;
                    this.bitField0_ &= 0xFFFEFFFF;
                } else {
                    this.ensureExtraComputationsIsMutable();
                    this.extraComputations_.addAll(other.extraComputations_);
                }
                this.onChanged();
            }
            if (other.trafficModel_ != 0) {
                this.setTrafficModelValue(other.getTrafficModelValue());
            }
            if (other.hasTransitPreferences()) {
                this.mergeTransitPreferences(other.getTransitPreferences());
            }
            this.mergeUnknownFields(other.getUnknownFields());
            this.onChanged();
            return this;
        }

        public final boolean isInitialized() {
            return true;
        }

        public Builder mergeFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            if (extensionRegistry == null) {
                throw new NullPointerException();
            }
            try {
                boolean done = false;
                block29: while (!done) {
                    int tag = input.readTag();
                    switch (tag) {
                        case 0: {
                            done = true;
                            continue block29;
                        }
                        case 10: {
                            input.readMessage((MessageLite.Builder)this.getOriginFieldBuilder().getBuilder(), extensionRegistry);
                            this.bitField0_ |= 1;
                            continue block29;
                        }
                        case 18: {
                            input.readMessage((MessageLite.Builder)this.getDestinationFieldBuilder().getBuilder(), extensionRegistry);
                            this.bitField0_ |= 2;
                            continue block29;
                        }
                        case 26: {
                            Waypoint m = (Waypoint)input.readMessage(Waypoint.parser(), extensionRegistry);
                            if (this.intermediatesBuilder_ == null) {
                                this.ensureIntermediatesIsMutable();
                                this.intermediates_.add(m);
                                continue block29;
                            }
                            this.intermediatesBuilder_.addMessage((AbstractMessage)m);
                            continue block29;
                        }
                        case 32: {
                            this.travelMode_ = input.readEnum();
                            this.bitField0_ |= 8;
                            continue block29;
                        }
                        case 40: {
                            this.routingPreference_ = input.readEnum();
                            this.bitField0_ |= 0x10;
                            continue block29;
                        }
                        case 48: {
                            this.polylineQuality_ = input.readEnum();
                            this.bitField0_ |= 0x20;
                            continue block29;
                        }
                        case 58: {
                            input.readMessage((MessageLite.Builder)this.getDepartureTimeFieldBuilder().getBuilder(), extensionRegistry);
                            this.bitField0_ |= 0x80;
                            continue block29;
                        }
                        case 64: {
                            this.computeAlternativeRoutes_ = input.readBool();
                            this.bitField0_ |= 0x200;
                            continue block29;
                        }
                        case 74: {
                            input.readMessage((MessageLite.Builder)this.getRouteModifiersFieldBuilder().getBuilder(), extensionRegistry);
                            this.bitField0_ |= 0x400;
                            continue block29;
                        }
                        case 82: {
                            this.languageCode_ = input.readStringRequireUtf8();
                            this.bitField0_ |= 0x800;
                            continue block29;
                        }
                        case 88: {
                            this.units_ = input.readEnum();
                            this.bitField0_ |= 0x2000;
                            continue block29;
                        }
                        case 96: {
                            this.polylineEncoding_ = input.readEnum();
                            this.bitField0_ |= 0x40;
                            continue block29;
                        }
                        case 104: {
                            this.optimizeWaypointOrder_ = input.readBool();
                            this.bitField0_ |= 0x4000;
                            continue block29;
                        }
                        case 112: {
                            int tmpRaw = input.readEnum();
                            this.ensureRequestedReferenceRoutesIsMutable();
                            this.requestedReferenceRoutes_.add(tmpRaw);
                            continue block29;
                        }
                        case 114: {
                            int tmpRaw;
                            int length = input.readRawVarint32();
                            int oldLimit = input.pushLimit(length);
                            while (input.getBytesUntilLimit() > 0) {
                                tmpRaw = input.readEnum();
                                this.ensureRequestedReferenceRoutesIsMutable();
                                this.requestedReferenceRoutes_.add(tmpRaw);
                            }
                            input.popLimit(oldLimit);
                            continue block29;
                        }
                        case 120: {
                            int tmpRaw = input.readEnum();
                            this.ensureExtraComputationsIsMutable();
                            this.extraComputations_.add(tmpRaw);
                            continue block29;
                        }
                        case 122: {
                            int tmpRaw;
                            int length = input.readRawVarint32();
                            int oldLimit = input.pushLimit(length);
                            while (input.getBytesUntilLimit() > 0) {
                                tmpRaw = input.readEnum();
                                this.ensureExtraComputationsIsMutable();
                                this.extraComputations_.add(tmpRaw);
                            }
                            input.popLimit(oldLimit);
                            continue block29;
                        }
                        case 130: {
                            this.regionCode_ = input.readStringRequireUtf8();
                            this.bitField0_ |= 0x1000;
                            continue block29;
                        }
                        case 144: {
                            this.trafficModel_ = input.readEnum();
                            this.bitField0_ |= 0x20000;
                            continue block29;
                        }
                        case 154: {
                            input.readMessage((MessageLite.Builder)this.getArrivalTimeFieldBuilder().getBuilder(), extensionRegistry);
                            this.bitField0_ |= 0x100;
                            continue block29;
                        }
                        case 162: {
                            input.readMessage((MessageLite.Builder)this.getTransitPreferencesFieldBuilder().getBuilder(), extensionRegistry);
                            this.bitField0_ |= 0x40000;
                            continue block29;
                        }
                    }
                    if (super.parseUnknownField(input, extensionRegistry, tag)) continue;
                    done = true;
                }
            }
            catch (InvalidProtocolBufferException e) {
                throw e.unwrapIOException();
            }
            finally {
                this.onChanged();
            }
            return this;
        }

        @Override
        public boolean hasOrigin() {
            return (this.bitField0_ & 1) != 0;
        }

        @Override
        public Waypoint getOrigin() {
            if (this.originBuilder_ == null) {
                return this.origin_ == null ? Waypoint.getDefaultInstance() : this.origin_;
            }
            return (Waypoint)this.originBuilder_.getMessage();
        }

        public Builder setOrigin(Waypoint value) {
            if (this.originBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.origin_ = value;
            } else {
                this.originBuilder_.setMessage((AbstractMessage)value);
            }
            this.bitField0_ |= 1;
            this.onChanged();
            return this;
        }

        public Builder setOrigin(Waypoint.Builder builderForValue) {
            if (this.originBuilder_ == null) {
                this.origin_ = builderForValue.build();
            } else {
                this.originBuilder_.setMessage((AbstractMessage)builderForValue.build());
            }
            this.bitField0_ |= 1;
            this.onChanged();
            return this;
        }

        public Builder mergeOrigin(Waypoint value) {
            if (this.originBuilder_ == null) {
                if ((this.bitField0_ & 1) != 0 && this.origin_ != null && this.origin_ != Waypoint.getDefaultInstance()) {
                    this.getOriginBuilder().mergeFrom(value);
                } else {
                    this.origin_ = value;
                }
            } else {
                this.originBuilder_.mergeFrom((AbstractMessage)value);
            }
            if (this.origin_ != null) {
                this.bitField0_ |= 1;
                this.onChanged();
            }
            return this;
        }

        public Builder clearOrigin() {
            this.bitField0_ &= 0xFFFFFFFE;
            this.origin_ = null;
            if (this.originBuilder_ != null) {
                this.originBuilder_.dispose();
                this.originBuilder_ = null;
            }
            this.onChanged();
            return this;
        }

        public Waypoint.Builder getOriginBuilder() {
            this.bitField0_ |= 1;
            this.onChanged();
            return (Waypoint.Builder)this.getOriginFieldBuilder().getBuilder();
        }

        @Override
        public WaypointOrBuilder getOriginOrBuilder() {
            if (this.originBuilder_ != null) {
                return (WaypointOrBuilder)this.originBuilder_.getMessageOrBuilder();
            }
            return this.origin_ == null ? Waypoint.getDefaultInstance() : this.origin_;
        }

        private SingleFieldBuilderV3<Waypoint, Waypoint.Builder, WaypointOrBuilder> getOriginFieldBuilder() {
            if (this.originBuilder_ == null) {
                this.originBuilder_ = new SingleFieldBuilderV3((AbstractMessage)this.getOrigin(), (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.origin_ = null;
            }
            return this.originBuilder_;
        }

        @Override
        public boolean hasDestination() {
            return (this.bitField0_ & 2) != 0;
        }

        @Override
        public Waypoint getDestination() {
            if (this.destinationBuilder_ == null) {
                return this.destination_ == null ? Waypoint.getDefaultInstance() : this.destination_;
            }
            return (Waypoint)this.destinationBuilder_.getMessage();
        }

        public Builder setDestination(Waypoint value) {
            if (this.destinationBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.destination_ = value;
            } else {
                this.destinationBuilder_.setMessage((AbstractMessage)value);
            }
            this.bitField0_ |= 2;
            this.onChanged();
            return this;
        }

        public Builder setDestination(Waypoint.Builder builderForValue) {
            if (this.destinationBuilder_ == null) {
                this.destination_ = builderForValue.build();
            } else {
                this.destinationBuilder_.setMessage((AbstractMessage)builderForValue.build());
            }
            this.bitField0_ |= 2;
            this.onChanged();
            return this;
        }

        public Builder mergeDestination(Waypoint value) {
            if (this.destinationBuilder_ == null) {
                if ((this.bitField0_ & 2) != 0 && this.destination_ != null && this.destination_ != Waypoint.getDefaultInstance()) {
                    this.getDestinationBuilder().mergeFrom(value);
                } else {
                    this.destination_ = value;
                }
            } else {
                this.destinationBuilder_.mergeFrom((AbstractMessage)value);
            }
            if (this.destination_ != null) {
                this.bitField0_ |= 2;
                this.onChanged();
            }
            return this;
        }

        public Builder clearDestination() {
            this.bitField0_ &= 0xFFFFFFFD;
            this.destination_ = null;
            if (this.destinationBuilder_ != null) {
                this.destinationBuilder_.dispose();
                this.destinationBuilder_ = null;
            }
            this.onChanged();
            return this;
        }

        public Waypoint.Builder getDestinationBuilder() {
            this.bitField0_ |= 2;
            this.onChanged();
            return (Waypoint.Builder)this.getDestinationFieldBuilder().getBuilder();
        }

        @Override
        public WaypointOrBuilder getDestinationOrBuilder() {
            if (this.destinationBuilder_ != null) {
                return (WaypointOrBuilder)this.destinationBuilder_.getMessageOrBuilder();
            }
            return this.destination_ == null ? Waypoint.getDefaultInstance() : this.destination_;
        }

        private SingleFieldBuilderV3<Waypoint, Waypoint.Builder, WaypointOrBuilder> getDestinationFieldBuilder() {
            if (this.destinationBuilder_ == null) {
                this.destinationBuilder_ = new SingleFieldBuilderV3((AbstractMessage)this.getDestination(), (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.destination_ = null;
            }
            return this.destinationBuilder_;
        }

        private void ensureIntermediatesIsMutable() {
            if ((this.bitField0_ & 4) == 0) {
                this.intermediates_ = new ArrayList<Waypoint>(this.intermediates_);
                this.bitField0_ |= 4;
            }
        }

        @Override
        public List<Waypoint> getIntermediatesList() {
            if (this.intermediatesBuilder_ == null) {
                return Collections.unmodifiableList(this.intermediates_);
            }
            return this.intermediatesBuilder_.getMessageList();
        }

        @Override
        public int getIntermediatesCount() {
            if (this.intermediatesBuilder_ == null) {
                return this.intermediates_.size();
            }
            return this.intermediatesBuilder_.getCount();
        }

        @Override
        public Waypoint getIntermediates(int index) {
            if (this.intermediatesBuilder_ == null) {
                return this.intermediates_.get(index);
            }
            return (Waypoint)this.intermediatesBuilder_.getMessage(index);
        }

        public Builder setIntermediates(int index, Waypoint value) {
            if (this.intermediatesBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureIntermediatesIsMutable();
                this.intermediates_.set(index, value);
                this.onChanged();
            } else {
                this.intermediatesBuilder_.setMessage(index, (AbstractMessage)value);
            }
            return this;
        }

        public Builder setIntermediates(int index, Waypoint.Builder builderForValue) {
            if (this.intermediatesBuilder_ == null) {
                this.ensureIntermediatesIsMutable();
                this.intermediates_.set(index, builderForValue.build());
                this.onChanged();
            } else {
                this.intermediatesBuilder_.setMessage(index, (AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addIntermediates(Waypoint value) {
            if (this.intermediatesBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureIntermediatesIsMutable();
                this.intermediates_.add(value);
                this.onChanged();
            } else {
                this.intermediatesBuilder_.addMessage((AbstractMessage)value);
            }
            return this;
        }

        public Builder addIntermediates(int index, Waypoint value) {
            if (this.intermediatesBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureIntermediatesIsMutable();
                this.intermediates_.add(index, value);
                this.onChanged();
            } else {
                this.intermediatesBuilder_.addMessage(index, (AbstractMessage)value);
            }
            return this;
        }

        public Builder addIntermediates(Waypoint.Builder builderForValue) {
            if (this.intermediatesBuilder_ == null) {
                this.ensureIntermediatesIsMutable();
                this.intermediates_.add(builderForValue.build());
                this.onChanged();
            } else {
                this.intermediatesBuilder_.addMessage((AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addIntermediates(int index, Waypoint.Builder builderForValue) {
            if (this.intermediatesBuilder_ == null) {
                this.ensureIntermediatesIsMutable();
                this.intermediates_.add(index, builderForValue.build());
                this.onChanged();
            } else {
                this.intermediatesBuilder_.addMessage(index, (AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addAllIntermediates(Iterable<? extends Waypoint> values) {
            if (this.intermediatesBuilder_ == null) {
                this.ensureIntermediatesIsMutable();
                AbstractMessageLite.Builder.addAll(values, this.intermediates_);
                this.onChanged();
            } else {
                this.intermediatesBuilder_.addAllMessages(values);
            }
            return this;
        }

        public Builder clearIntermediates() {
            if (this.intermediatesBuilder_ == null) {
                this.intermediates_ = Collections.emptyList();
                this.bitField0_ &= 0xFFFFFFFB;
                this.onChanged();
            } else {
                this.intermediatesBuilder_.clear();
            }
            return this;
        }

        public Builder removeIntermediates(int index) {
            if (this.intermediatesBuilder_ == null) {
                this.ensureIntermediatesIsMutable();
                this.intermediates_.remove(index);
                this.onChanged();
            } else {
                this.intermediatesBuilder_.remove(index);
            }
            return this;
        }

        public Waypoint.Builder getIntermediatesBuilder(int index) {
            return (Waypoint.Builder)this.getIntermediatesFieldBuilder().getBuilder(index);
        }

        @Override
        public WaypointOrBuilder getIntermediatesOrBuilder(int index) {
            if (this.intermediatesBuilder_ == null) {
                return this.intermediates_.get(index);
            }
            return (WaypointOrBuilder)this.intermediatesBuilder_.getMessageOrBuilder(index);
        }

        @Override
        public List<? extends WaypointOrBuilder> getIntermediatesOrBuilderList() {
            if (this.intermediatesBuilder_ != null) {
                return this.intermediatesBuilder_.getMessageOrBuilderList();
            }
            return Collections.unmodifiableList(this.intermediates_);
        }

        public Waypoint.Builder addIntermediatesBuilder() {
            return (Waypoint.Builder)this.getIntermediatesFieldBuilder().addBuilder((AbstractMessage)Waypoint.getDefaultInstance());
        }

        public Waypoint.Builder addIntermediatesBuilder(int index) {
            return (Waypoint.Builder)this.getIntermediatesFieldBuilder().addBuilder(index, (AbstractMessage)Waypoint.getDefaultInstance());
        }

        public List<Waypoint.Builder> getIntermediatesBuilderList() {
            return this.getIntermediatesFieldBuilder().getBuilderList();
        }

        private RepeatedFieldBuilderV3<Waypoint, Waypoint.Builder, WaypointOrBuilder> getIntermediatesFieldBuilder() {
            if (this.intermediatesBuilder_ == null) {
                this.intermediatesBuilder_ = new RepeatedFieldBuilderV3(this.intermediates_, (this.bitField0_ & 4) != 0, (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.intermediates_ = null;
            }
            return this.intermediatesBuilder_;
        }

        @Override
        public int getTravelModeValue() {
            return this.travelMode_;
        }

        public Builder setTravelModeValue(int value) {
            this.travelMode_ = value;
            this.bitField0_ |= 8;
            this.onChanged();
            return this;
        }

        @Override
        public RouteTravelMode getTravelMode() {
            RouteTravelMode result = RouteTravelMode.forNumber(this.travelMode_);
            return result == null ? RouteTravelMode.UNRECOGNIZED : result;
        }

        public Builder setTravelMode(RouteTravelMode value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.bitField0_ |= 8;
            this.travelMode_ = value.getNumber();
            this.onChanged();
            return this;
        }

        public Builder clearTravelMode() {
            this.bitField0_ &= 0xFFFFFFF7;
            this.travelMode_ = 0;
            this.onChanged();
            return this;
        }

        @Override
        public int getRoutingPreferenceValue() {
            return this.routingPreference_;
        }

        public Builder setRoutingPreferenceValue(int value) {
            this.routingPreference_ = value;
            this.bitField0_ |= 0x10;
            this.onChanged();
            return this;
        }

        @Override
        public RoutingPreference getRoutingPreference() {
            RoutingPreference result = RoutingPreference.forNumber(this.routingPreference_);
            return result == null ? RoutingPreference.UNRECOGNIZED : result;
        }

        public Builder setRoutingPreference(RoutingPreference value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.bitField0_ |= 0x10;
            this.routingPreference_ = value.getNumber();
            this.onChanged();
            return this;
        }

        public Builder clearRoutingPreference() {
            this.bitField0_ &= 0xFFFFFFEF;
            this.routingPreference_ = 0;
            this.onChanged();
            return this;
        }

        @Override
        public int getPolylineQualityValue() {
            return this.polylineQuality_;
        }

        public Builder setPolylineQualityValue(int value) {
            this.polylineQuality_ = value;
            this.bitField0_ |= 0x20;
            this.onChanged();
            return this;
        }

        @Override
        public PolylineQuality getPolylineQuality() {
            PolylineQuality result = PolylineQuality.forNumber(this.polylineQuality_);
            return result == null ? PolylineQuality.UNRECOGNIZED : result;
        }

        public Builder setPolylineQuality(PolylineQuality value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.bitField0_ |= 0x20;
            this.polylineQuality_ = value.getNumber();
            this.onChanged();
            return this;
        }

        public Builder clearPolylineQuality() {
            this.bitField0_ &= 0xFFFFFFDF;
            this.polylineQuality_ = 0;
            this.onChanged();
            return this;
        }

        @Override
        public int getPolylineEncodingValue() {
            return this.polylineEncoding_;
        }

        public Builder setPolylineEncodingValue(int value) {
            this.polylineEncoding_ = value;
            this.bitField0_ |= 0x40;
            this.onChanged();
            return this;
        }

        @Override
        public PolylineEncoding getPolylineEncoding() {
            PolylineEncoding result = PolylineEncoding.forNumber(this.polylineEncoding_);
            return result == null ? PolylineEncoding.UNRECOGNIZED : result;
        }

        public Builder setPolylineEncoding(PolylineEncoding value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.bitField0_ |= 0x40;
            this.polylineEncoding_ = value.getNumber();
            this.onChanged();
            return this;
        }

        public Builder clearPolylineEncoding() {
            this.bitField0_ &= 0xFFFFFFBF;
            this.polylineEncoding_ = 0;
            this.onChanged();
            return this;
        }

        @Override
        public boolean hasDepartureTime() {
            return (this.bitField0_ & 0x80) != 0;
        }

        @Override
        public Timestamp getDepartureTime() {
            if (this.departureTimeBuilder_ == null) {
                return this.departureTime_ == null ? Timestamp.getDefaultInstance() : this.departureTime_;
            }
            return (Timestamp)this.departureTimeBuilder_.getMessage();
        }

        public Builder setDepartureTime(Timestamp value) {
            if (this.departureTimeBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.departureTime_ = value;
            } else {
                this.departureTimeBuilder_.setMessage((AbstractMessage)value);
            }
            this.bitField0_ |= 0x80;
            this.onChanged();
            return this;
        }

        public Builder setDepartureTime(Timestamp.Builder builderForValue) {
            if (this.departureTimeBuilder_ == null) {
                this.departureTime_ = builderForValue.build();
            } else {
                this.departureTimeBuilder_.setMessage((AbstractMessage)builderForValue.build());
            }
            this.bitField0_ |= 0x80;
            this.onChanged();
            return this;
        }

        public Builder mergeDepartureTime(Timestamp value) {
            if (this.departureTimeBuilder_ == null) {
                if ((this.bitField0_ & 0x80) != 0 && this.departureTime_ != null && this.departureTime_ != Timestamp.getDefaultInstance()) {
                    this.getDepartureTimeBuilder().mergeFrom(value);
                } else {
                    this.departureTime_ = value;
                }
            } else {
                this.departureTimeBuilder_.mergeFrom((AbstractMessage)value);
            }
            if (this.departureTime_ != null) {
                this.bitField0_ |= 0x80;
                this.onChanged();
            }
            return this;
        }

        public Builder clearDepartureTime() {
            this.bitField0_ &= 0xFFFFFF7F;
            this.departureTime_ = null;
            if (this.departureTimeBuilder_ != null) {
                this.departureTimeBuilder_.dispose();
                this.departureTimeBuilder_ = null;
            }
            this.onChanged();
            return this;
        }

        public Timestamp.Builder getDepartureTimeBuilder() {
            this.bitField0_ |= 0x80;
            this.onChanged();
            return (Timestamp.Builder)this.getDepartureTimeFieldBuilder().getBuilder();
        }

        @Override
        public TimestampOrBuilder getDepartureTimeOrBuilder() {
            if (this.departureTimeBuilder_ != null) {
                return (TimestampOrBuilder)this.departureTimeBuilder_.getMessageOrBuilder();
            }
            return this.departureTime_ == null ? Timestamp.getDefaultInstance() : this.departureTime_;
        }

        private SingleFieldBuilderV3<Timestamp, Timestamp.Builder, TimestampOrBuilder> getDepartureTimeFieldBuilder() {
            if (this.departureTimeBuilder_ == null) {
                this.departureTimeBuilder_ = new SingleFieldBuilderV3((AbstractMessage)this.getDepartureTime(), (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.departureTime_ = null;
            }
            return this.departureTimeBuilder_;
        }

        @Override
        public boolean hasArrivalTime() {
            return (this.bitField0_ & 0x100) != 0;
        }

        @Override
        public Timestamp getArrivalTime() {
            if (this.arrivalTimeBuilder_ == null) {
                return this.arrivalTime_ == null ? Timestamp.getDefaultInstance() : this.arrivalTime_;
            }
            return (Timestamp)this.arrivalTimeBuilder_.getMessage();
        }

        public Builder setArrivalTime(Timestamp value) {
            if (this.arrivalTimeBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.arrivalTime_ = value;
            } else {
                this.arrivalTimeBuilder_.setMessage((AbstractMessage)value);
            }
            this.bitField0_ |= 0x100;
            this.onChanged();
            return this;
        }

        public Builder setArrivalTime(Timestamp.Builder builderForValue) {
            if (this.arrivalTimeBuilder_ == null) {
                this.arrivalTime_ = builderForValue.build();
            } else {
                this.arrivalTimeBuilder_.setMessage((AbstractMessage)builderForValue.build());
            }
            this.bitField0_ |= 0x100;
            this.onChanged();
            return this;
        }

        public Builder mergeArrivalTime(Timestamp value) {
            if (this.arrivalTimeBuilder_ == null) {
                if ((this.bitField0_ & 0x100) != 0 && this.arrivalTime_ != null && this.arrivalTime_ != Timestamp.getDefaultInstance()) {
                    this.getArrivalTimeBuilder().mergeFrom(value);
                } else {
                    this.arrivalTime_ = value;
                }
            } else {
                this.arrivalTimeBuilder_.mergeFrom((AbstractMessage)value);
            }
            if (this.arrivalTime_ != null) {
                this.bitField0_ |= 0x100;
                this.onChanged();
            }
            return this;
        }

        public Builder clearArrivalTime() {
            this.bitField0_ &= 0xFFFFFEFF;
            this.arrivalTime_ = null;
            if (this.arrivalTimeBuilder_ != null) {
                this.arrivalTimeBuilder_.dispose();
                this.arrivalTimeBuilder_ = null;
            }
            this.onChanged();
            return this;
        }

        public Timestamp.Builder getArrivalTimeBuilder() {
            this.bitField0_ |= 0x100;
            this.onChanged();
            return (Timestamp.Builder)this.getArrivalTimeFieldBuilder().getBuilder();
        }

        @Override
        public TimestampOrBuilder getArrivalTimeOrBuilder() {
            if (this.arrivalTimeBuilder_ != null) {
                return (TimestampOrBuilder)this.arrivalTimeBuilder_.getMessageOrBuilder();
            }
            return this.arrivalTime_ == null ? Timestamp.getDefaultInstance() : this.arrivalTime_;
        }

        private SingleFieldBuilderV3<Timestamp, Timestamp.Builder, TimestampOrBuilder> getArrivalTimeFieldBuilder() {
            if (this.arrivalTimeBuilder_ == null) {
                this.arrivalTimeBuilder_ = new SingleFieldBuilderV3((AbstractMessage)this.getArrivalTime(), (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.arrivalTime_ = null;
            }
            return this.arrivalTimeBuilder_;
        }

        @Override
        public boolean getComputeAlternativeRoutes() {
            return this.computeAlternativeRoutes_;
        }

        public Builder setComputeAlternativeRoutes(boolean value) {
            this.computeAlternativeRoutes_ = value;
            this.bitField0_ |= 0x200;
            this.onChanged();
            return this;
        }

        public Builder clearComputeAlternativeRoutes() {
            this.bitField0_ &= 0xFFFFFDFF;
            this.computeAlternativeRoutes_ = false;
            this.onChanged();
            return this;
        }

        @Override
        public boolean hasRouteModifiers() {
            return (this.bitField0_ & 0x400) != 0;
        }

        @Override
        public RouteModifiers getRouteModifiers() {
            if (this.routeModifiersBuilder_ == null) {
                return this.routeModifiers_ == null ? RouteModifiers.getDefaultInstance() : this.routeModifiers_;
            }
            return (RouteModifiers)this.routeModifiersBuilder_.getMessage();
        }

        public Builder setRouteModifiers(RouteModifiers value) {
            if (this.routeModifiersBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.routeModifiers_ = value;
            } else {
                this.routeModifiersBuilder_.setMessage((AbstractMessage)value);
            }
            this.bitField0_ |= 0x400;
            this.onChanged();
            return this;
        }

        public Builder setRouteModifiers(RouteModifiers.Builder builderForValue) {
            if (this.routeModifiersBuilder_ == null) {
                this.routeModifiers_ = builderForValue.build();
            } else {
                this.routeModifiersBuilder_.setMessage((AbstractMessage)builderForValue.build());
            }
            this.bitField0_ |= 0x400;
            this.onChanged();
            return this;
        }

        public Builder mergeRouteModifiers(RouteModifiers value) {
            if (this.routeModifiersBuilder_ == null) {
                if ((this.bitField0_ & 0x400) != 0 && this.routeModifiers_ != null && this.routeModifiers_ != RouteModifiers.getDefaultInstance()) {
                    this.getRouteModifiersBuilder().mergeFrom(value);
                } else {
                    this.routeModifiers_ = value;
                }
            } else {
                this.routeModifiersBuilder_.mergeFrom((AbstractMessage)value);
            }
            if (this.routeModifiers_ != null) {
                this.bitField0_ |= 0x400;
                this.onChanged();
            }
            return this;
        }

        public Builder clearRouteModifiers() {
            this.bitField0_ &= 0xFFFFFBFF;
            this.routeModifiers_ = null;
            if (this.routeModifiersBuilder_ != null) {
                this.routeModifiersBuilder_.dispose();
                this.routeModifiersBuilder_ = null;
            }
            this.onChanged();
            return this;
        }

        public RouteModifiers.Builder getRouteModifiersBuilder() {
            this.bitField0_ |= 0x400;
            this.onChanged();
            return (RouteModifiers.Builder)this.getRouteModifiersFieldBuilder().getBuilder();
        }

        @Override
        public RouteModifiersOrBuilder getRouteModifiersOrBuilder() {
            if (this.routeModifiersBuilder_ != null) {
                return (RouteModifiersOrBuilder)this.routeModifiersBuilder_.getMessageOrBuilder();
            }
            return this.routeModifiers_ == null ? RouteModifiers.getDefaultInstance() : this.routeModifiers_;
        }

        private SingleFieldBuilderV3<RouteModifiers, RouteModifiers.Builder, RouteModifiersOrBuilder> getRouteModifiersFieldBuilder() {
            if (this.routeModifiersBuilder_ == null) {
                this.routeModifiersBuilder_ = new SingleFieldBuilderV3((AbstractMessage)this.getRouteModifiers(), (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.routeModifiers_ = null;
            }
            return this.routeModifiersBuilder_;
        }

        @Override
        public String getLanguageCode() {
            Object ref = this.languageCode_;
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                this.languageCode_ = s;
                return s;
            }
            return (String)ref;
        }

        @Override
        public ByteString getLanguageCodeBytes() {
            Object ref = this.languageCode_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.languageCode_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public Builder setLanguageCode(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.languageCode_ = value;
            this.bitField0_ |= 0x800;
            this.onChanged();
            return this;
        }

        public Builder clearLanguageCode() {
            this.languageCode_ = ComputeRoutesRequest.getDefaultInstance().getLanguageCode();
            this.bitField0_ &= 0xFFFFF7FF;
            this.onChanged();
            return this;
        }

        public Builder setLanguageCodeBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            ComputeRoutesRequest.checkByteStringIsUtf8((ByteString)value);
            this.languageCode_ = value;
            this.bitField0_ |= 0x800;
            this.onChanged();
            return this;
        }

        @Override
        public String getRegionCode() {
            Object ref = this.regionCode_;
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                this.regionCode_ = s;
                return s;
            }
            return (String)ref;
        }

        @Override
        public ByteString getRegionCodeBytes() {
            Object ref = this.regionCode_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.regionCode_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public Builder setRegionCode(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.regionCode_ = value;
            this.bitField0_ |= 0x1000;
            this.onChanged();
            return this;
        }

        public Builder clearRegionCode() {
            this.regionCode_ = ComputeRoutesRequest.getDefaultInstance().getRegionCode();
            this.bitField0_ &= 0xFFFFEFFF;
            this.onChanged();
            return this;
        }

        public Builder setRegionCodeBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            ComputeRoutesRequest.checkByteStringIsUtf8((ByteString)value);
            this.regionCode_ = value;
            this.bitField0_ |= 0x1000;
            this.onChanged();
            return this;
        }

        @Override
        public int getUnitsValue() {
            return this.units_;
        }

        public Builder setUnitsValue(int value) {
            this.units_ = value;
            this.bitField0_ |= 0x2000;
            this.onChanged();
            return this;
        }

        @Override
        public Units getUnits() {
            Units result = Units.forNumber(this.units_);
            return result == null ? Units.UNRECOGNIZED : result;
        }

        public Builder setUnits(Units value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.bitField0_ |= 0x2000;
            this.units_ = value.getNumber();
            this.onChanged();
            return this;
        }

        public Builder clearUnits() {
            this.bitField0_ &= 0xFFFFDFFF;
            this.units_ = 0;
            this.onChanged();
            return this;
        }

        @Override
        public boolean getOptimizeWaypointOrder() {
            return this.optimizeWaypointOrder_;
        }

        public Builder setOptimizeWaypointOrder(boolean value) {
            this.optimizeWaypointOrder_ = value;
            this.bitField0_ |= 0x4000;
            this.onChanged();
            return this;
        }

        public Builder clearOptimizeWaypointOrder() {
            this.bitField0_ &= 0xFFFFBFFF;
            this.optimizeWaypointOrder_ = false;
            this.onChanged();
            return this;
        }

        private void ensureRequestedReferenceRoutesIsMutable() {
            if ((this.bitField0_ & 0x8000) == 0) {
                this.requestedReferenceRoutes_ = new ArrayList<Integer>(this.requestedReferenceRoutes_);
                this.bitField0_ |= 0x8000;
            }
        }

        @Override
        public List<ReferenceRoute> getRequestedReferenceRoutesList() {
            return new Internal.ListAdapter(this.requestedReferenceRoutes_, requestedReferenceRoutes_converter_);
        }

        @Override
        public int getRequestedReferenceRoutesCount() {
            return this.requestedReferenceRoutes_.size();
        }

        @Override
        public ReferenceRoute getRequestedReferenceRoutes(int index) {
            return (ReferenceRoute)((Object)requestedReferenceRoutes_converter_.convert((Object)this.requestedReferenceRoutes_.get(index)));
        }

        public Builder setRequestedReferenceRoutes(int index, ReferenceRoute value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.ensureRequestedReferenceRoutesIsMutable();
            this.requestedReferenceRoutes_.set(index, value.getNumber());
            this.onChanged();
            return this;
        }

        public Builder addRequestedReferenceRoutes(ReferenceRoute value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.ensureRequestedReferenceRoutesIsMutable();
            this.requestedReferenceRoutes_.add(value.getNumber());
            this.onChanged();
            return this;
        }

        public Builder addAllRequestedReferenceRoutes(Iterable<? extends ReferenceRoute> values) {
            this.ensureRequestedReferenceRoutesIsMutable();
            for (ReferenceRoute referenceRoute : values) {
                this.requestedReferenceRoutes_.add(referenceRoute.getNumber());
            }
            this.onChanged();
            return this;
        }

        public Builder clearRequestedReferenceRoutes() {
            this.requestedReferenceRoutes_ = Collections.emptyList();
            this.bitField0_ &= 0xFFFF7FFF;
            this.onChanged();
            return this;
        }

        @Override
        public List<Integer> getRequestedReferenceRoutesValueList() {
            return Collections.unmodifiableList(this.requestedReferenceRoutes_);
        }

        @Override
        public int getRequestedReferenceRoutesValue(int index) {
            return this.requestedReferenceRoutes_.get(index);
        }

        public Builder setRequestedReferenceRoutesValue(int index, int value) {
            this.ensureRequestedReferenceRoutesIsMutable();
            this.requestedReferenceRoutes_.set(index, value);
            this.onChanged();
            return this;
        }

        public Builder addRequestedReferenceRoutesValue(int value) {
            this.ensureRequestedReferenceRoutesIsMutable();
            this.requestedReferenceRoutes_.add(value);
            this.onChanged();
            return this;
        }

        public Builder addAllRequestedReferenceRoutesValue(Iterable<Integer> values) {
            this.ensureRequestedReferenceRoutesIsMutable();
            for (int value : values) {
                this.requestedReferenceRoutes_.add(value);
            }
            this.onChanged();
            return this;
        }

        private void ensureExtraComputationsIsMutable() {
            if ((this.bitField0_ & 0x10000) == 0) {
                this.extraComputations_ = new ArrayList<Integer>(this.extraComputations_);
                this.bitField0_ |= 0x10000;
            }
        }

        @Override
        public List<ExtraComputation> getExtraComputationsList() {
            return new Internal.ListAdapter(this.extraComputations_, extraComputations_converter_);
        }

        @Override
        public int getExtraComputationsCount() {
            return this.extraComputations_.size();
        }

        @Override
        public ExtraComputation getExtraComputations(int index) {
            return (ExtraComputation)((Object)extraComputations_converter_.convert((Object)this.extraComputations_.get(index)));
        }

        public Builder setExtraComputations(int index, ExtraComputation value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.ensureExtraComputationsIsMutable();
            this.extraComputations_.set(index, value.getNumber());
            this.onChanged();
            return this;
        }

        public Builder addExtraComputations(ExtraComputation value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.ensureExtraComputationsIsMutable();
            this.extraComputations_.add(value.getNumber());
            this.onChanged();
            return this;
        }

        public Builder addAllExtraComputations(Iterable<? extends ExtraComputation> values) {
            this.ensureExtraComputationsIsMutable();
            for (ExtraComputation extraComputation : values) {
                this.extraComputations_.add(extraComputation.getNumber());
            }
            this.onChanged();
            return this;
        }

        public Builder clearExtraComputations() {
            this.extraComputations_ = Collections.emptyList();
            this.bitField0_ &= 0xFFFEFFFF;
            this.onChanged();
            return this;
        }

        @Override
        public List<Integer> getExtraComputationsValueList() {
            return Collections.unmodifiableList(this.extraComputations_);
        }

        @Override
        public int getExtraComputationsValue(int index) {
            return this.extraComputations_.get(index);
        }

        public Builder setExtraComputationsValue(int index, int value) {
            this.ensureExtraComputationsIsMutable();
            this.extraComputations_.set(index, value);
            this.onChanged();
            return this;
        }

        public Builder addExtraComputationsValue(int value) {
            this.ensureExtraComputationsIsMutable();
            this.extraComputations_.add(value);
            this.onChanged();
            return this;
        }

        public Builder addAllExtraComputationsValue(Iterable<Integer> values) {
            this.ensureExtraComputationsIsMutable();
            for (int value : values) {
                this.extraComputations_.add(value);
            }
            this.onChanged();
            return this;
        }

        @Override
        public int getTrafficModelValue() {
            return this.trafficModel_;
        }

        public Builder setTrafficModelValue(int value) {
            this.trafficModel_ = value;
            this.bitField0_ |= 0x20000;
            this.onChanged();
            return this;
        }

        @Override
        public TrafficModel getTrafficModel() {
            TrafficModel result = TrafficModel.forNumber(this.trafficModel_);
            return result == null ? TrafficModel.UNRECOGNIZED : result;
        }

        public Builder setTrafficModel(TrafficModel value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.bitField0_ |= 0x20000;
            this.trafficModel_ = value.getNumber();
            this.onChanged();
            return this;
        }

        public Builder clearTrafficModel() {
            this.bitField0_ &= 0xFFFDFFFF;
            this.trafficModel_ = 0;
            this.onChanged();
            return this;
        }

        @Override
        public boolean hasTransitPreferences() {
            return (this.bitField0_ & 0x40000) != 0;
        }

        @Override
        public TransitPreferences getTransitPreferences() {
            if (this.transitPreferencesBuilder_ == null) {
                return this.transitPreferences_ == null ? TransitPreferences.getDefaultInstance() : this.transitPreferences_;
            }
            return (TransitPreferences)this.transitPreferencesBuilder_.getMessage();
        }

        public Builder setTransitPreferences(TransitPreferences value) {
            if (this.transitPreferencesBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.transitPreferences_ = value;
            } else {
                this.transitPreferencesBuilder_.setMessage((AbstractMessage)value);
            }
            this.bitField0_ |= 0x40000;
            this.onChanged();
            return this;
        }

        public Builder setTransitPreferences(TransitPreferences.Builder builderForValue) {
            if (this.transitPreferencesBuilder_ == null) {
                this.transitPreferences_ = builderForValue.build();
            } else {
                this.transitPreferencesBuilder_.setMessage((AbstractMessage)builderForValue.build());
            }
            this.bitField0_ |= 0x40000;
            this.onChanged();
            return this;
        }

        public Builder mergeTransitPreferences(TransitPreferences value) {
            if (this.transitPreferencesBuilder_ == null) {
                if ((this.bitField0_ & 0x40000) != 0 && this.transitPreferences_ != null && this.transitPreferences_ != TransitPreferences.getDefaultInstance()) {
                    this.getTransitPreferencesBuilder().mergeFrom(value);
                } else {
                    this.transitPreferences_ = value;
                }
            } else {
                this.transitPreferencesBuilder_.mergeFrom((AbstractMessage)value);
            }
            if (this.transitPreferences_ != null) {
                this.bitField0_ |= 0x40000;
                this.onChanged();
            }
            return this;
        }

        public Builder clearTransitPreferences() {
            this.bitField0_ &= 0xFFFBFFFF;
            this.transitPreferences_ = null;
            if (this.transitPreferencesBuilder_ != null) {
                this.transitPreferencesBuilder_.dispose();
                this.transitPreferencesBuilder_ = null;
            }
            this.onChanged();
            return this;
        }

        public TransitPreferences.Builder getTransitPreferencesBuilder() {
            this.bitField0_ |= 0x40000;
            this.onChanged();
            return (TransitPreferences.Builder)this.getTransitPreferencesFieldBuilder().getBuilder();
        }

        @Override
        public TransitPreferencesOrBuilder getTransitPreferencesOrBuilder() {
            if (this.transitPreferencesBuilder_ != null) {
                return (TransitPreferencesOrBuilder)this.transitPreferencesBuilder_.getMessageOrBuilder();
            }
            return this.transitPreferences_ == null ? TransitPreferences.getDefaultInstance() : this.transitPreferences_;
        }

        private SingleFieldBuilderV3<TransitPreferences, TransitPreferences.Builder, TransitPreferencesOrBuilder> getTransitPreferencesFieldBuilder() {
            if (this.transitPreferencesBuilder_ == null) {
                this.transitPreferencesBuilder_ = new SingleFieldBuilderV3((AbstractMessage)this.getTransitPreferences(), (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.transitPreferences_ = null;
            }
            return this.transitPreferencesBuilder_;
        }

        public final Builder setUnknownFields(UnknownFieldSet unknownFields) {
            return (Builder)super.setUnknownFields(unknownFields);
        }

        public final Builder mergeUnknownFields(UnknownFieldSet unknownFields) {
            return (Builder)super.mergeUnknownFields(unknownFields);
        }
    }

    public static enum ExtraComputation implements ProtocolMessageEnum
    {
        EXTRA_COMPUTATION_UNSPECIFIED(0),
        TOLLS(1),
        FUEL_CONSUMPTION(2),
        TRAFFIC_ON_POLYLINE(3),
        HTML_FORMATTED_NAVIGATION_INSTRUCTIONS(4),
        UNRECOGNIZED(-1);

        public static final int EXTRA_COMPUTATION_UNSPECIFIED_VALUE = 0;
        public static final int TOLLS_VALUE = 1;
        public static final int FUEL_CONSUMPTION_VALUE = 2;
        public static final int TRAFFIC_ON_POLYLINE_VALUE = 3;
        public static final int HTML_FORMATTED_NAVIGATION_INSTRUCTIONS_VALUE = 4;
        private static final Internal.EnumLiteMap<ExtraComputation> internalValueMap;
        private static final ExtraComputation[] VALUES;
        private final int value;

        public final int getNumber() {
            if (this == UNRECOGNIZED) {
                throw new IllegalArgumentException("Can't get the number of an unknown enum value.");
            }
            return this.value;
        }

        @Deprecated
        public static ExtraComputation valueOf(int value) {
            return ExtraComputation.forNumber(value);
        }

        public static ExtraComputation forNumber(int value) {
            switch (value) {
                case 0: {
                    return EXTRA_COMPUTATION_UNSPECIFIED;
                }
                case 1: {
                    return TOLLS;
                }
                case 2: {
                    return FUEL_CONSUMPTION;
                }
                case 3: {
                    return TRAFFIC_ON_POLYLINE;
                }
                case 4: {
                    return HTML_FORMATTED_NAVIGATION_INSTRUCTIONS;
                }
            }
            return null;
        }

        public static Internal.EnumLiteMap<ExtraComputation> internalGetValueMap() {
            return internalValueMap;
        }

        public final Descriptors.EnumValueDescriptor getValueDescriptor() {
            if (this == UNRECOGNIZED) {
                throw new IllegalStateException("Can't get the descriptor of an unrecognized enum value.");
            }
            return (Descriptors.EnumValueDescriptor)ExtraComputation.getDescriptor().getValues().get(this.ordinal());
        }

        public final Descriptors.EnumDescriptor getDescriptorForType() {
            return ExtraComputation.getDescriptor();
        }

        public static final Descriptors.EnumDescriptor getDescriptor() {
            return (Descriptors.EnumDescriptor)ComputeRoutesRequest.getDescriptor().getEnumTypes().get(1);
        }

        public static ExtraComputation valueOf(Descriptors.EnumValueDescriptor desc) {
            if (desc.getType() != ExtraComputation.getDescriptor()) {
                throw new IllegalArgumentException("EnumValueDescriptor is not for this type.");
            }
            if (desc.getIndex() == -1) {
                return UNRECOGNIZED;
            }
            return VALUES[desc.getIndex()];
        }

        private ExtraComputation(int value) {
            this.value = value;
        }

        static {
            internalValueMap = new Internal.EnumLiteMap<ExtraComputation>(){

                public ExtraComputation findValueByNumber(int number) {
                    return ExtraComputation.forNumber(number);
                }
            };
            VALUES = ExtraComputation.values();
        }
    }

    public static enum ReferenceRoute implements ProtocolMessageEnum
    {
        REFERENCE_ROUTE_UNSPECIFIED(0),
        FUEL_EFFICIENT(1),
        UNRECOGNIZED(-1);

        public static final int REFERENCE_ROUTE_UNSPECIFIED_VALUE = 0;
        public static final int FUEL_EFFICIENT_VALUE = 1;
        private static final Internal.EnumLiteMap<ReferenceRoute> internalValueMap;
        private static final ReferenceRoute[] VALUES;
        private final int value;

        public final int getNumber() {
            if (this == UNRECOGNIZED) {
                throw new IllegalArgumentException("Can't get the number of an unknown enum value.");
            }
            return this.value;
        }

        @Deprecated
        public static ReferenceRoute valueOf(int value) {
            return ReferenceRoute.forNumber(value);
        }

        public static ReferenceRoute forNumber(int value) {
            switch (value) {
                case 0: {
                    return REFERENCE_ROUTE_UNSPECIFIED;
                }
                case 1: {
                    return FUEL_EFFICIENT;
                }
            }
            return null;
        }

        public static Internal.EnumLiteMap<ReferenceRoute> internalGetValueMap() {
            return internalValueMap;
        }

        public final Descriptors.EnumValueDescriptor getValueDescriptor() {
            if (this == UNRECOGNIZED) {
                throw new IllegalStateException("Can't get the descriptor of an unrecognized enum value.");
            }
            return (Descriptors.EnumValueDescriptor)ReferenceRoute.getDescriptor().getValues().get(this.ordinal());
        }

        public final Descriptors.EnumDescriptor getDescriptorForType() {
            return ReferenceRoute.getDescriptor();
        }

        public static final Descriptors.EnumDescriptor getDescriptor() {
            return (Descriptors.EnumDescriptor)ComputeRoutesRequest.getDescriptor().getEnumTypes().get(0);
        }

        public static ReferenceRoute valueOf(Descriptors.EnumValueDescriptor desc) {
            if (desc.getType() != ReferenceRoute.getDescriptor()) {
                throw new IllegalArgumentException("EnumValueDescriptor is not for this type.");
            }
            if (desc.getIndex() == -1) {
                return UNRECOGNIZED;
            }
            return VALUES[desc.getIndex()];
        }

        private ReferenceRoute(int value) {
            this.value = value;
        }

        static {
            internalValueMap = new Internal.EnumLiteMap<ReferenceRoute>(){

                public ReferenceRoute findValueByNumber(int number) {
                    return ReferenceRoute.forNumber(number);
                }
            };
            VALUES = ReferenceRoute.values();
        }
    }
}

