/*
 * Decompiled with CFR 0.152.
 */
package com.google.maps.routing.v2;

import com.google.maps.routing.v2.ComputeRouteMatrixRequestOrBuilder;
import com.google.maps.routing.v2.RouteMatrixDestination;
import com.google.maps.routing.v2.RouteMatrixDestinationOrBuilder;
import com.google.maps.routing.v2.RouteMatrixOrigin;
import com.google.maps.routing.v2.RouteMatrixOriginOrBuilder;
import com.google.maps.routing.v2.RouteTravelMode;
import com.google.maps.routing.v2.RoutesServiceProto;
import com.google.maps.routing.v2.RoutingPreference;
import com.google.maps.routing.v2.TrafficModel;
import com.google.maps.routing.v2.TransitPreferences;
import com.google.maps.routing.v2.TransitPreferencesOrBuilder;
import com.google.protobuf.AbstractMessage;
import com.google.protobuf.AbstractMessageLite;
import com.google.protobuf.AbstractParser;
import com.google.protobuf.ByteString;
import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import com.google.protobuf.Descriptors;
import com.google.protobuf.ExtensionRegistryLite;
import com.google.protobuf.GeneratedMessageV3;
import com.google.protobuf.Internal;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import com.google.protobuf.MessageLite;
import com.google.protobuf.Parser;
import com.google.protobuf.ProtocolMessageEnum;
import com.google.protobuf.RepeatedFieldBuilderV3;
import com.google.protobuf.SingleFieldBuilderV3;
import com.google.protobuf.Timestamp;
import com.google.protobuf.TimestampOrBuilder;
import com.google.protobuf.UninitializedMessageException;
import com.google.protobuf.UnknownFieldSet;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class ComputeRouteMatrixRequest
extends GeneratedMessageV3
implements ComputeRouteMatrixRequestOrBuilder {
    private static final long serialVersionUID = 0L;
    private int bitField0_;
    public static final int ORIGINS_FIELD_NUMBER = 1;
    private List<RouteMatrixOrigin> origins_;
    public static final int DESTINATIONS_FIELD_NUMBER = 2;
    private List<RouteMatrixDestination> destinations_;
    public static final int TRAVEL_MODE_FIELD_NUMBER = 3;
    private int travelMode_ = 0;
    public static final int ROUTING_PREFERENCE_FIELD_NUMBER = 4;
    private int routingPreference_ = 0;
    public static final int DEPARTURE_TIME_FIELD_NUMBER = 5;
    private Timestamp departureTime_;
    public static final int ARRIVAL_TIME_FIELD_NUMBER = 11;
    private Timestamp arrivalTime_;
    public static final int LANGUAGE_CODE_FIELD_NUMBER = 6;
    private volatile Object languageCode_ = "";
    public static final int REGION_CODE_FIELD_NUMBER = 9;
    private volatile Object regionCode_ = "";
    public static final int EXTRA_COMPUTATIONS_FIELD_NUMBER = 8;
    private List<Integer> extraComputations_;
    private static final Internal.ListAdapter.Converter<Integer, ExtraComputation> extraComputations_converter_ = new Internal.ListAdapter.Converter<Integer, ExtraComputation>(){

        public ExtraComputation convert(Integer from) {
            ExtraComputation result = ExtraComputation.forNumber(from);
            return result == null ? ExtraComputation.UNRECOGNIZED : result;
        }
    };
    private int extraComputationsMemoizedSerializedSize;
    public static final int TRAFFIC_MODEL_FIELD_NUMBER = 10;
    private int trafficModel_ = 0;
    public static final int TRANSIT_PREFERENCES_FIELD_NUMBER = 12;
    private TransitPreferences transitPreferences_;
    private byte memoizedIsInitialized = (byte)-1;
    private static final ComputeRouteMatrixRequest DEFAULT_INSTANCE = new ComputeRouteMatrixRequest();
    private static final Parser<ComputeRouteMatrixRequest> PARSER = new AbstractParser<ComputeRouteMatrixRequest>(){

        public ComputeRouteMatrixRequest parsePartialFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            Builder builder = ComputeRouteMatrixRequest.newBuilder();
            try {
                builder.mergeFrom(input, extensionRegistry);
            }
            catch (InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage((MessageLite)builder.buildPartial());
            }
            catch (UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException().setUnfinishedMessage((MessageLite)builder.buildPartial());
            }
            catch (IOException e) {
                throw new InvalidProtocolBufferException(e).setUnfinishedMessage((MessageLite)builder.buildPartial());
            }
            return builder.buildPartial();
        }
    };

    private ComputeRouteMatrixRequest(GeneratedMessageV3.Builder<?> builder) {
        super(builder);
    }

    private ComputeRouteMatrixRequest() {
        this.origins_ = Collections.emptyList();
        this.destinations_ = Collections.emptyList();
        this.travelMode_ = 0;
        this.routingPreference_ = 0;
        this.languageCode_ = "";
        this.regionCode_ = "";
        this.extraComputations_ = Collections.emptyList();
        this.trafficModel_ = 0;
    }

    protected Object newInstance(GeneratedMessageV3.UnusedPrivateParameter unused) {
        return new ComputeRouteMatrixRequest();
    }

    public static final Descriptors.Descriptor getDescriptor() {
        return RoutesServiceProto.internal_static_google_maps_routing_v2_ComputeRouteMatrixRequest_descriptor;
    }

    protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
        return RoutesServiceProto.internal_static_google_maps_routing_v2_ComputeRouteMatrixRequest_fieldAccessorTable.ensureFieldAccessorsInitialized(ComputeRouteMatrixRequest.class, Builder.class);
    }

    @Override
    public List<RouteMatrixOrigin> getOriginsList() {
        return this.origins_;
    }

    @Override
    public List<? extends RouteMatrixOriginOrBuilder> getOriginsOrBuilderList() {
        return this.origins_;
    }

    @Override
    public int getOriginsCount() {
        return this.origins_.size();
    }

    @Override
    public RouteMatrixOrigin getOrigins(int index) {
        return this.origins_.get(index);
    }

    @Override
    public RouteMatrixOriginOrBuilder getOriginsOrBuilder(int index) {
        return this.origins_.get(index);
    }

    @Override
    public List<RouteMatrixDestination> getDestinationsList() {
        return this.destinations_;
    }

    @Override
    public List<? extends RouteMatrixDestinationOrBuilder> getDestinationsOrBuilderList() {
        return this.destinations_;
    }

    @Override
    public int getDestinationsCount() {
        return this.destinations_.size();
    }

    @Override
    public RouteMatrixDestination getDestinations(int index) {
        return this.destinations_.get(index);
    }

    @Override
    public RouteMatrixDestinationOrBuilder getDestinationsOrBuilder(int index) {
        return this.destinations_.get(index);
    }

    @Override
    public int getTravelModeValue() {
        return this.travelMode_;
    }

    @Override
    public RouteTravelMode getTravelMode() {
        RouteTravelMode result = RouteTravelMode.forNumber(this.travelMode_);
        return result == null ? RouteTravelMode.UNRECOGNIZED : result;
    }

    @Override
    public int getRoutingPreferenceValue() {
        return this.routingPreference_;
    }

    @Override
    public RoutingPreference getRoutingPreference() {
        RoutingPreference result = RoutingPreference.forNumber(this.routingPreference_);
        return result == null ? RoutingPreference.UNRECOGNIZED : result;
    }

    @Override
    public boolean hasDepartureTime() {
        return (this.bitField0_ & 1) != 0;
    }

    @Override
    public Timestamp getDepartureTime() {
        return this.departureTime_ == null ? Timestamp.getDefaultInstance() : this.departureTime_;
    }

    @Override
    public TimestampOrBuilder getDepartureTimeOrBuilder() {
        return this.departureTime_ == null ? Timestamp.getDefaultInstance() : this.departureTime_;
    }

    @Override
    public boolean hasArrivalTime() {
        return (this.bitField0_ & 2) != 0;
    }

    @Override
    public Timestamp getArrivalTime() {
        return this.arrivalTime_ == null ? Timestamp.getDefaultInstance() : this.arrivalTime_;
    }

    @Override
    public TimestampOrBuilder getArrivalTimeOrBuilder() {
        return this.arrivalTime_ == null ? Timestamp.getDefaultInstance() : this.arrivalTime_;
    }

    @Override
    public String getLanguageCode() {
        Object ref = this.languageCode_;
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s = bs.toStringUtf8();
        this.languageCode_ = s;
        return s;
    }

    @Override
    public ByteString getLanguageCodeBytes() {
        Object ref = this.languageCode_;
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)((String)ref));
            this.languageCode_ = b;
            return b;
        }
        return (ByteString)ref;
    }

    @Override
    public String getRegionCode() {
        Object ref = this.regionCode_;
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s = bs.toStringUtf8();
        this.regionCode_ = s;
        return s;
    }

    @Override
    public ByteString getRegionCodeBytes() {
        Object ref = this.regionCode_;
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)((String)ref));
            this.regionCode_ = b;
            return b;
        }
        return (ByteString)ref;
    }

    @Override
    public List<ExtraComputation> getExtraComputationsList() {
        return new Internal.ListAdapter(this.extraComputations_, extraComputations_converter_);
    }

    @Override
    public int getExtraComputationsCount() {
        return this.extraComputations_.size();
    }

    @Override
    public ExtraComputation getExtraComputations(int index) {
        return (ExtraComputation)((Object)extraComputations_converter_.convert((Object)this.extraComputations_.get(index)));
    }

    @Override
    public List<Integer> getExtraComputationsValueList() {
        return this.extraComputations_;
    }

    @Override
    public int getExtraComputationsValue(int index) {
        return this.extraComputations_.get(index);
    }

    @Override
    public int getTrafficModelValue() {
        return this.trafficModel_;
    }

    @Override
    public TrafficModel getTrafficModel() {
        TrafficModel result = TrafficModel.forNumber(this.trafficModel_);
        return result == null ? TrafficModel.UNRECOGNIZED : result;
    }

    @Override
    public boolean hasTransitPreferences() {
        return (this.bitField0_ & 4) != 0;
    }

    @Override
    public TransitPreferences getTransitPreferences() {
        return this.transitPreferences_ == null ? TransitPreferences.getDefaultInstance() : this.transitPreferences_;
    }

    @Override
    public TransitPreferencesOrBuilder getTransitPreferencesOrBuilder() {
        return this.transitPreferences_ == null ? TransitPreferences.getDefaultInstance() : this.transitPreferences_;
    }

    public final boolean isInitialized() {
        byte isInitialized = this.memoizedIsInitialized;
        if (isInitialized == 1) {
            return true;
        }
        if (isInitialized == 0) {
            return false;
        }
        this.memoizedIsInitialized = 1;
        return true;
    }

    public void writeTo(CodedOutputStream output) throws IOException {
        int i;
        this.getSerializedSize();
        for (i = 0; i < this.origins_.size(); ++i) {
            output.writeMessage(1, (MessageLite)this.origins_.get(i));
        }
        for (i = 0; i < this.destinations_.size(); ++i) {
            output.writeMessage(2, (MessageLite)this.destinations_.get(i));
        }
        if (this.travelMode_ != RouteTravelMode.TRAVEL_MODE_UNSPECIFIED.getNumber()) {
            output.writeEnum(3, this.travelMode_);
        }
        if (this.routingPreference_ != RoutingPreference.ROUTING_PREFERENCE_UNSPECIFIED.getNumber()) {
            output.writeEnum(4, this.routingPreference_);
        }
        if ((this.bitField0_ & 1) != 0) {
            output.writeMessage(5, (MessageLite)this.getDepartureTime());
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.languageCode_)) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)6, (Object)this.languageCode_);
        }
        if (this.getExtraComputationsList().size() > 0) {
            output.writeUInt32NoTag(66);
            output.writeUInt32NoTag(this.extraComputationsMemoizedSerializedSize);
        }
        for (i = 0; i < this.extraComputations_.size(); ++i) {
            output.writeEnumNoTag(this.extraComputations_.get(i).intValue());
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.regionCode_)) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)9, (Object)this.regionCode_);
        }
        if (this.trafficModel_ != TrafficModel.TRAFFIC_MODEL_UNSPECIFIED.getNumber()) {
            output.writeEnum(10, this.trafficModel_);
        }
        if ((this.bitField0_ & 2) != 0) {
            output.writeMessage(11, (MessageLite)this.getArrivalTime());
        }
        if ((this.bitField0_ & 4) != 0) {
            output.writeMessage(12, (MessageLite)this.getTransitPreferences());
        }
        this.getUnknownFields().writeTo(output);
    }

    public int getSerializedSize() {
        int i;
        int size = this.memoizedSize;
        if (size != -1) {
            return size;
        }
        size = 0;
        for (i = 0; i < this.origins_.size(); ++i) {
            size += CodedOutputStream.computeMessageSize((int)1, (MessageLite)((MessageLite)this.origins_.get(i)));
        }
        for (i = 0; i < this.destinations_.size(); ++i) {
            size += CodedOutputStream.computeMessageSize((int)2, (MessageLite)((MessageLite)this.destinations_.get(i)));
        }
        if (this.travelMode_ != RouteTravelMode.TRAVEL_MODE_UNSPECIFIED.getNumber()) {
            size += CodedOutputStream.computeEnumSize((int)3, (int)this.travelMode_);
        }
        if (this.routingPreference_ != RoutingPreference.ROUTING_PREFERENCE_UNSPECIFIED.getNumber()) {
            size += CodedOutputStream.computeEnumSize((int)4, (int)this.routingPreference_);
        }
        if ((this.bitField0_ & 1) != 0) {
            size += CodedOutputStream.computeMessageSize((int)5, (MessageLite)this.getDepartureTime());
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.languageCode_)) {
            size += GeneratedMessageV3.computeStringSize((int)6, (Object)this.languageCode_);
        }
        int dataSize = 0;
        for (int i2 = 0; i2 < this.extraComputations_.size(); ++i2) {
            dataSize += CodedOutputStream.computeEnumSizeNoTag((int)this.extraComputations_.get(i2));
        }
        size += dataSize;
        if (!this.getExtraComputationsList().isEmpty()) {
            ++size;
            size += CodedOutputStream.computeUInt32SizeNoTag((int)dataSize);
        }
        this.extraComputationsMemoizedSerializedSize = dataSize;
        if (!GeneratedMessageV3.isStringEmpty((Object)this.regionCode_)) {
            size += GeneratedMessageV3.computeStringSize((int)9, (Object)this.regionCode_);
        }
        if (this.trafficModel_ != TrafficModel.TRAFFIC_MODEL_UNSPECIFIED.getNumber()) {
            size += CodedOutputStream.computeEnumSize((int)10, (int)this.trafficModel_);
        }
        if ((this.bitField0_ & 2) != 0) {
            size += CodedOutputStream.computeMessageSize((int)11, (MessageLite)this.getArrivalTime());
        }
        if ((this.bitField0_ & 4) != 0) {
            size += CodedOutputStream.computeMessageSize((int)12, (MessageLite)this.getTransitPreferences());
        }
        this.memoizedSize = size += this.getUnknownFields().getSerializedSize();
        return size;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ComputeRouteMatrixRequest)) {
            return super.equals(obj);
        }
        ComputeRouteMatrixRequest other = (ComputeRouteMatrixRequest)obj;
        if (!this.getOriginsList().equals(other.getOriginsList())) {
            return false;
        }
        if (!this.getDestinationsList().equals(other.getDestinationsList())) {
            return false;
        }
        if (this.travelMode_ != other.travelMode_) {
            return false;
        }
        if (this.routingPreference_ != other.routingPreference_) {
            return false;
        }
        if (this.hasDepartureTime() != other.hasDepartureTime()) {
            return false;
        }
        if (this.hasDepartureTime() && !this.getDepartureTime().equals((Object)other.getDepartureTime())) {
            return false;
        }
        if (this.hasArrivalTime() != other.hasArrivalTime()) {
            return false;
        }
        if (this.hasArrivalTime() && !this.getArrivalTime().equals((Object)other.getArrivalTime())) {
            return false;
        }
        if (!this.getLanguageCode().equals(other.getLanguageCode())) {
            return false;
        }
        if (!this.getRegionCode().equals(other.getRegionCode())) {
            return false;
        }
        if (!this.extraComputations_.equals(other.extraComputations_)) {
            return false;
        }
        if (this.trafficModel_ != other.trafficModel_) {
            return false;
        }
        if (this.hasTransitPreferences() != other.hasTransitPreferences()) {
            return false;
        }
        if (this.hasTransitPreferences() && !this.getTransitPreferences().equals(other.getTransitPreferences())) {
            return false;
        }
        return this.getUnknownFields().equals((Object)other.getUnknownFields());
    }

    public int hashCode() {
        if (this.memoizedHashCode != 0) {
            return this.memoizedHashCode;
        }
        int hash = 41;
        hash = 19 * hash + ComputeRouteMatrixRequest.getDescriptor().hashCode();
        if (this.getOriginsCount() > 0) {
            hash = 37 * hash + 1;
            hash = 53 * hash + this.getOriginsList().hashCode();
        }
        if (this.getDestinationsCount() > 0) {
            hash = 37 * hash + 2;
            hash = 53 * hash + this.getDestinationsList().hashCode();
        }
        hash = 37 * hash + 3;
        hash = 53 * hash + this.travelMode_;
        hash = 37 * hash + 4;
        hash = 53 * hash + this.routingPreference_;
        if (this.hasDepartureTime()) {
            hash = 37 * hash + 5;
            hash = 53 * hash + this.getDepartureTime().hashCode();
        }
        if (this.hasArrivalTime()) {
            hash = 37 * hash + 11;
            hash = 53 * hash + this.getArrivalTime().hashCode();
        }
        hash = 37 * hash + 6;
        hash = 53 * hash + this.getLanguageCode().hashCode();
        hash = 37 * hash + 9;
        hash = 53 * hash + this.getRegionCode().hashCode();
        if (this.getExtraComputationsCount() > 0) {
            hash = 37 * hash + 8;
            hash = 53 * hash + this.extraComputations_.hashCode();
        }
        hash = 37 * hash + 10;
        hash = 53 * hash + this.trafficModel_;
        if (this.hasTransitPreferences()) {
            hash = 37 * hash + 12;
            hash = 53 * hash + this.getTransitPreferences().hashCode();
        }
        this.memoizedHashCode = hash = 29 * hash + this.getUnknownFields().hashCode();
        return hash;
    }

    public static ComputeRouteMatrixRequest parseFrom(ByteBuffer data) throws InvalidProtocolBufferException {
        return (ComputeRouteMatrixRequest)PARSER.parseFrom(data);
    }

    public static ComputeRouteMatrixRequest parseFrom(ByteBuffer data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (ComputeRouteMatrixRequest)PARSER.parseFrom(data, extensionRegistry);
    }

    public static ComputeRouteMatrixRequest parseFrom(ByteString data) throws InvalidProtocolBufferException {
        return (ComputeRouteMatrixRequest)PARSER.parseFrom(data);
    }

    public static ComputeRouteMatrixRequest parseFrom(ByteString data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (ComputeRouteMatrixRequest)PARSER.parseFrom(data, extensionRegistry);
    }

    public static ComputeRouteMatrixRequest parseFrom(byte[] data) throws InvalidProtocolBufferException {
        return (ComputeRouteMatrixRequest)PARSER.parseFrom(data);
    }

    public static ComputeRouteMatrixRequest parseFrom(byte[] data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (ComputeRouteMatrixRequest)PARSER.parseFrom(data, extensionRegistry);
    }

    public static ComputeRouteMatrixRequest parseFrom(InputStream input) throws IOException {
        return (ComputeRouteMatrixRequest)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input);
    }

    public static ComputeRouteMatrixRequest parseFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (ComputeRouteMatrixRequest)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public static ComputeRouteMatrixRequest parseDelimitedFrom(InputStream input) throws IOException {
        return (ComputeRouteMatrixRequest)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input);
    }

    public static ComputeRouteMatrixRequest parseDelimitedFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (ComputeRouteMatrixRequest)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public static ComputeRouteMatrixRequest parseFrom(CodedInputStream input) throws IOException {
        return (ComputeRouteMatrixRequest)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input);
    }

    public static ComputeRouteMatrixRequest parseFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (ComputeRouteMatrixRequest)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public Builder newBuilderForType() {
        return ComputeRouteMatrixRequest.newBuilder();
    }

    public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(ComputeRouteMatrixRequest prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    protected Builder newBuilderForType(GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
    }

    public static ComputeRouteMatrixRequest getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public static Parser<ComputeRouteMatrixRequest> parser() {
        return PARSER;
    }

    public Parser<ComputeRouteMatrixRequest> getParserForType() {
        return PARSER;
    }

    public ComputeRouteMatrixRequest getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
    }

    public static final class Builder
    extends GeneratedMessageV3.Builder<Builder>
    implements ComputeRouteMatrixRequestOrBuilder {
        private int bitField0_;
        private List<RouteMatrixOrigin> origins_ = Collections.emptyList();
        private RepeatedFieldBuilderV3<RouteMatrixOrigin, RouteMatrixOrigin.Builder, RouteMatrixOriginOrBuilder> originsBuilder_;
        private List<RouteMatrixDestination> destinations_ = Collections.emptyList();
        private RepeatedFieldBuilderV3<RouteMatrixDestination, RouteMatrixDestination.Builder, RouteMatrixDestinationOrBuilder> destinationsBuilder_;
        private int travelMode_ = 0;
        private int routingPreference_ = 0;
        private Timestamp departureTime_;
        private SingleFieldBuilderV3<Timestamp, Timestamp.Builder, TimestampOrBuilder> departureTimeBuilder_;
        private Timestamp arrivalTime_;
        private SingleFieldBuilderV3<Timestamp, Timestamp.Builder, TimestampOrBuilder> arrivalTimeBuilder_;
        private Object languageCode_ = "";
        private Object regionCode_ = "";
        private List<Integer> extraComputations_ = Collections.emptyList();
        private int trafficModel_ = 0;
        private TransitPreferences transitPreferences_;
        private SingleFieldBuilderV3<TransitPreferences, TransitPreferences.Builder, TransitPreferencesOrBuilder> transitPreferencesBuilder_;

        public static final Descriptors.Descriptor getDescriptor() {
            return RoutesServiceProto.internal_static_google_maps_routing_v2_ComputeRouteMatrixRequest_descriptor;
        }

        protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
            return RoutesServiceProto.internal_static_google_maps_routing_v2_ComputeRouteMatrixRequest_fieldAccessorTable.ensureFieldAccessorsInitialized(ComputeRouteMatrixRequest.class, Builder.class);
        }

        private Builder() {
            this.maybeForceBuilderInitialization();
        }

        private Builder(GeneratedMessageV3.BuilderParent parent) {
            super(parent);
            this.maybeForceBuilderInitialization();
        }

        private void maybeForceBuilderInitialization() {
            if (alwaysUseFieldBuilders) {
                this.getOriginsFieldBuilder();
                this.getDestinationsFieldBuilder();
                this.getDepartureTimeFieldBuilder();
                this.getArrivalTimeFieldBuilder();
                this.getTransitPreferencesFieldBuilder();
            }
        }

        public Builder clear() {
            super.clear();
            this.bitField0_ = 0;
            if (this.originsBuilder_ == null) {
                this.origins_ = Collections.emptyList();
            } else {
                this.origins_ = null;
                this.originsBuilder_.clear();
            }
            this.bitField0_ &= 0xFFFFFFFE;
            if (this.destinationsBuilder_ == null) {
                this.destinations_ = Collections.emptyList();
            } else {
                this.destinations_ = null;
                this.destinationsBuilder_.clear();
            }
            this.bitField0_ &= 0xFFFFFFFD;
            this.travelMode_ = 0;
            this.routingPreference_ = 0;
            this.departureTime_ = null;
            if (this.departureTimeBuilder_ != null) {
                this.departureTimeBuilder_.dispose();
                this.departureTimeBuilder_ = null;
            }
            this.arrivalTime_ = null;
            if (this.arrivalTimeBuilder_ != null) {
                this.arrivalTimeBuilder_.dispose();
                this.arrivalTimeBuilder_ = null;
            }
            this.languageCode_ = "";
            this.regionCode_ = "";
            this.extraComputations_ = Collections.emptyList();
            this.bitField0_ &= 0xFFFFFEFF;
            this.trafficModel_ = 0;
            this.transitPreferences_ = null;
            if (this.transitPreferencesBuilder_ != null) {
                this.transitPreferencesBuilder_.dispose();
                this.transitPreferencesBuilder_ = null;
            }
            return this;
        }

        public Descriptors.Descriptor getDescriptorForType() {
            return RoutesServiceProto.internal_static_google_maps_routing_v2_ComputeRouteMatrixRequest_descriptor;
        }

        public ComputeRouteMatrixRequest getDefaultInstanceForType() {
            return ComputeRouteMatrixRequest.getDefaultInstance();
        }

        public ComputeRouteMatrixRequest build() {
            ComputeRouteMatrixRequest result = this.buildPartial();
            if (!result.isInitialized()) {
                throw Builder.newUninitializedMessageException((Message)result);
            }
            return result;
        }

        public ComputeRouteMatrixRequest buildPartial() {
            ComputeRouteMatrixRequest result = new ComputeRouteMatrixRequest(this);
            this.buildPartialRepeatedFields(result);
            if (this.bitField0_ != 0) {
                this.buildPartial0(result);
            }
            this.onBuilt();
            return result;
        }

        private void buildPartialRepeatedFields(ComputeRouteMatrixRequest result) {
            if (this.originsBuilder_ == null) {
                if ((this.bitField0_ & 1) != 0) {
                    this.origins_ = Collections.unmodifiableList(this.origins_);
                    this.bitField0_ &= 0xFFFFFFFE;
                }
                result.origins_ = this.origins_;
            } else {
                result.origins_ = this.originsBuilder_.build();
            }
            if (this.destinationsBuilder_ == null) {
                if ((this.bitField0_ & 2) != 0) {
                    this.destinations_ = Collections.unmodifiableList(this.destinations_);
                    this.bitField0_ &= 0xFFFFFFFD;
                }
                result.destinations_ = this.destinations_;
            } else {
                result.destinations_ = this.destinationsBuilder_.build();
            }
            if ((this.bitField0_ & 0x100) != 0) {
                this.extraComputations_ = Collections.unmodifiableList(this.extraComputations_);
                this.bitField0_ &= 0xFFFFFEFF;
            }
            result.extraComputations_ = this.extraComputations_;
        }

        private void buildPartial0(ComputeRouteMatrixRequest result) {
            int from_bitField0_ = this.bitField0_;
            if ((from_bitField0_ & 4) != 0) {
                result.travelMode_ = this.travelMode_;
            }
            if ((from_bitField0_ & 8) != 0) {
                result.routingPreference_ = this.routingPreference_;
            }
            int to_bitField0_ = 0;
            if ((from_bitField0_ & 0x10) != 0) {
                result.departureTime_ = this.departureTimeBuilder_ == null ? this.departureTime_ : (Timestamp)this.departureTimeBuilder_.build();
                to_bitField0_ |= 1;
            }
            if ((from_bitField0_ & 0x20) != 0) {
                result.arrivalTime_ = this.arrivalTimeBuilder_ == null ? this.arrivalTime_ : (Timestamp)this.arrivalTimeBuilder_.build();
                to_bitField0_ |= 2;
            }
            if ((from_bitField0_ & 0x40) != 0) {
                result.languageCode_ = this.languageCode_;
            }
            if ((from_bitField0_ & 0x80) != 0) {
                result.regionCode_ = this.regionCode_;
            }
            if ((from_bitField0_ & 0x200) != 0) {
                result.trafficModel_ = this.trafficModel_;
            }
            if ((from_bitField0_ & 0x400) != 0) {
                result.transitPreferences_ = this.transitPreferencesBuilder_ == null ? this.transitPreferences_ : (TransitPreferences)this.transitPreferencesBuilder_.build();
                to_bitField0_ |= 4;
            }
            ComputeRouteMatrixRequest computeRouteMatrixRequest = result;
            computeRouteMatrixRequest.bitField0_ = computeRouteMatrixRequest.bitField0_ | to_bitField0_;
        }

        public Builder clone() {
            return (Builder)super.clone();
        }

        public Builder setField(Descriptors.FieldDescriptor field, Object value) {
            return (Builder)super.setField(field, value);
        }

        public Builder clearField(Descriptors.FieldDescriptor field) {
            return (Builder)super.clearField(field);
        }

        public Builder clearOneof(Descriptors.OneofDescriptor oneof) {
            return (Builder)super.clearOneof(oneof);
        }

        public Builder setRepeatedField(Descriptors.FieldDescriptor field, int index, Object value) {
            return (Builder)super.setRepeatedField(field, index, value);
        }

        public Builder addRepeatedField(Descriptors.FieldDescriptor field, Object value) {
            return (Builder)super.addRepeatedField(field, value);
        }

        public Builder mergeFrom(Message other) {
            if (other instanceof ComputeRouteMatrixRequest) {
                return this.mergeFrom((ComputeRouteMatrixRequest)other);
            }
            super.mergeFrom(other);
            return this;
        }

        public Builder mergeFrom(ComputeRouteMatrixRequest other) {
            if (other == ComputeRouteMatrixRequest.getDefaultInstance()) {
                return this;
            }
            if (this.originsBuilder_ == null) {
                if (!other.origins_.isEmpty()) {
                    if (this.origins_.isEmpty()) {
                        this.origins_ = other.origins_;
                        this.bitField0_ &= 0xFFFFFFFE;
                    } else {
                        this.ensureOriginsIsMutable();
                        this.origins_.addAll(other.origins_);
                    }
                    this.onChanged();
                }
            } else if (!other.origins_.isEmpty()) {
                if (this.originsBuilder_.isEmpty()) {
                    this.originsBuilder_.dispose();
                    this.originsBuilder_ = null;
                    this.origins_ = other.origins_;
                    this.bitField0_ &= 0xFFFFFFFE;
                    this.originsBuilder_ = alwaysUseFieldBuilders ? this.getOriginsFieldBuilder() : null;
                } else {
                    this.originsBuilder_.addAllMessages((Iterable)other.origins_);
                }
            }
            if (this.destinationsBuilder_ == null) {
                if (!other.destinations_.isEmpty()) {
                    if (this.destinations_.isEmpty()) {
                        this.destinations_ = other.destinations_;
                        this.bitField0_ &= 0xFFFFFFFD;
                    } else {
                        this.ensureDestinationsIsMutable();
                        this.destinations_.addAll(other.destinations_);
                    }
                    this.onChanged();
                }
            } else if (!other.destinations_.isEmpty()) {
                if (this.destinationsBuilder_.isEmpty()) {
                    this.destinationsBuilder_.dispose();
                    this.destinationsBuilder_ = null;
                    this.destinations_ = other.destinations_;
                    this.bitField0_ &= 0xFFFFFFFD;
                    this.destinationsBuilder_ = alwaysUseFieldBuilders ? this.getDestinationsFieldBuilder() : null;
                } else {
                    this.destinationsBuilder_.addAllMessages((Iterable)other.destinations_);
                }
            }
            if (other.travelMode_ != 0) {
                this.setTravelModeValue(other.getTravelModeValue());
            }
            if (other.routingPreference_ != 0) {
                this.setRoutingPreferenceValue(other.getRoutingPreferenceValue());
            }
            if (other.hasDepartureTime()) {
                this.mergeDepartureTime(other.getDepartureTime());
            }
            if (other.hasArrivalTime()) {
                this.mergeArrivalTime(other.getArrivalTime());
            }
            if (!other.getLanguageCode().isEmpty()) {
                this.languageCode_ = other.languageCode_;
                this.bitField0_ |= 0x40;
                this.onChanged();
            }
            if (!other.getRegionCode().isEmpty()) {
                this.regionCode_ = other.regionCode_;
                this.bitField0_ |= 0x80;
                this.onChanged();
            }
            if (!other.extraComputations_.isEmpty()) {
                if (this.extraComputations_.isEmpty()) {
                    this.extraComputations_ = other.extraComputations_;
                    this.bitField0_ &= 0xFFFFFEFF;
                } else {
                    this.ensureExtraComputationsIsMutable();
                    this.extraComputations_.addAll(other.extraComputations_);
                }
                this.onChanged();
            }
            if (other.trafficModel_ != 0) {
                this.setTrafficModelValue(other.getTrafficModelValue());
            }
            if (other.hasTransitPreferences()) {
                this.mergeTransitPreferences(other.getTransitPreferences());
            }
            this.mergeUnknownFields(other.getUnknownFields());
            this.onChanged();
            return this;
        }

        public final boolean isInitialized() {
            return true;
        }

        public Builder mergeFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            if (extensionRegistry == null) {
                throw new NullPointerException();
            }
            try {
                boolean done = false;
                block20: while (!done) {
                    int tag = input.readTag();
                    switch (tag) {
                        case 0: {
                            done = true;
                            continue block20;
                        }
                        case 10: {
                            RouteMatrixOrigin m = (RouteMatrixOrigin)input.readMessage(RouteMatrixOrigin.parser(), extensionRegistry);
                            if (this.originsBuilder_ == null) {
                                this.ensureOriginsIsMutable();
                                this.origins_.add(m);
                                continue block20;
                            }
                            this.originsBuilder_.addMessage((AbstractMessage)m);
                            continue block20;
                        }
                        case 18: {
                            RouteMatrixDestination m = (RouteMatrixDestination)input.readMessage(RouteMatrixDestination.parser(), extensionRegistry);
                            if (this.destinationsBuilder_ == null) {
                                this.ensureDestinationsIsMutable();
                                this.destinations_.add(m);
                                continue block20;
                            }
                            this.destinationsBuilder_.addMessage((AbstractMessage)m);
                            continue block20;
                        }
                        case 24: {
                            this.travelMode_ = input.readEnum();
                            this.bitField0_ |= 4;
                            continue block20;
                        }
                        case 32: {
                            this.routingPreference_ = input.readEnum();
                            this.bitField0_ |= 8;
                            continue block20;
                        }
                        case 42: {
                            input.readMessage((MessageLite.Builder)this.getDepartureTimeFieldBuilder().getBuilder(), extensionRegistry);
                            this.bitField0_ |= 0x10;
                            continue block20;
                        }
                        case 50: {
                            this.languageCode_ = input.readStringRequireUtf8();
                            this.bitField0_ |= 0x40;
                            continue block20;
                        }
                        case 64: {
                            int tmpRaw = input.readEnum();
                            this.ensureExtraComputationsIsMutable();
                            this.extraComputations_.add(tmpRaw);
                            continue block20;
                        }
                        case 66: {
                            int length = input.readRawVarint32();
                            int oldLimit = input.pushLimit(length);
                            while (input.getBytesUntilLimit() > 0) {
                                int tmpRaw = input.readEnum();
                                this.ensureExtraComputationsIsMutable();
                                this.extraComputations_.add(tmpRaw);
                            }
                            input.popLimit(oldLimit);
                            continue block20;
                        }
                        case 74: {
                            this.regionCode_ = input.readStringRequireUtf8();
                            this.bitField0_ |= 0x80;
                            continue block20;
                        }
                        case 80: {
                            this.trafficModel_ = input.readEnum();
                            this.bitField0_ |= 0x200;
                            continue block20;
                        }
                        case 90: {
                            input.readMessage((MessageLite.Builder)this.getArrivalTimeFieldBuilder().getBuilder(), extensionRegistry);
                            this.bitField0_ |= 0x20;
                            continue block20;
                        }
                        case 98: {
                            input.readMessage((MessageLite.Builder)this.getTransitPreferencesFieldBuilder().getBuilder(), extensionRegistry);
                            this.bitField0_ |= 0x400;
                            continue block20;
                        }
                    }
                    if (super.parseUnknownField(input, extensionRegistry, tag)) continue;
                    done = true;
                }
            }
            catch (InvalidProtocolBufferException e) {
                throw e.unwrapIOException();
            }
            finally {
                this.onChanged();
            }
            return this;
        }

        private void ensureOriginsIsMutable() {
            if ((this.bitField0_ & 1) == 0) {
                this.origins_ = new ArrayList<RouteMatrixOrigin>(this.origins_);
                this.bitField0_ |= 1;
            }
        }

        @Override
        public List<RouteMatrixOrigin> getOriginsList() {
            if (this.originsBuilder_ == null) {
                return Collections.unmodifiableList(this.origins_);
            }
            return this.originsBuilder_.getMessageList();
        }

        @Override
        public int getOriginsCount() {
            if (this.originsBuilder_ == null) {
                return this.origins_.size();
            }
            return this.originsBuilder_.getCount();
        }

        @Override
        public RouteMatrixOrigin getOrigins(int index) {
            if (this.originsBuilder_ == null) {
                return this.origins_.get(index);
            }
            return (RouteMatrixOrigin)this.originsBuilder_.getMessage(index);
        }

        public Builder setOrigins(int index, RouteMatrixOrigin value) {
            if (this.originsBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureOriginsIsMutable();
                this.origins_.set(index, value);
                this.onChanged();
            } else {
                this.originsBuilder_.setMessage(index, (AbstractMessage)value);
            }
            return this;
        }

        public Builder setOrigins(int index, RouteMatrixOrigin.Builder builderForValue) {
            if (this.originsBuilder_ == null) {
                this.ensureOriginsIsMutable();
                this.origins_.set(index, builderForValue.build());
                this.onChanged();
            } else {
                this.originsBuilder_.setMessage(index, (AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addOrigins(RouteMatrixOrigin value) {
            if (this.originsBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureOriginsIsMutable();
                this.origins_.add(value);
                this.onChanged();
            } else {
                this.originsBuilder_.addMessage((AbstractMessage)value);
            }
            return this;
        }

        public Builder addOrigins(int index, RouteMatrixOrigin value) {
            if (this.originsBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureOriginsIsMutable();
                this.origins_.add(index, value);
                this.onChanged();
            } else {
                this.originsBuilder_.addMessage(index, (AbstractMessage)value);
            }
            return this;
        }

        public Builder addOrigins(RouteMatrixOrigin.Builder builderForValue) {
            if (this.originsBuilder_ == null) {
                this.ensureOriginsIsMutable();
                this.origins_.add(builderForValue.build());
                this.onChanged();
            } else {
                this.originsBuilder_.addMessage((AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addOrigins(int index, RouteMatrixOrigin.Builder builderForValue) {
            if (this.originsBuilder_ == null) {
                this.ensureOriginsIsMutable();
                this.origins_.add(index, builderForValue.build());
                this.onChanged();
            } else {
                this.originsBuilder_.addMessage(index, (AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addAllOrigins(Iterable<? extends RouteMatrixOrigin> values) {
            if (this.originsBuilder_ == null) {
                this.ensureOriginsIsMutable();
                AbstractMessageLite.Builder.addAll(values, this.origins_);
                this.onChanged();
            } else {
                this.originsBuilder_.addAllMessages(values);
            }
            return this;
        }

        public Builder clearOrigins() {
            if (this.originsBuilder_ == null) {
                this.origins_ = Collections.emptyList();
                this.bitField0_ &= 0xFFFFFFFE;
                this.onChanged();
            } else {
                this.originsBuilder_.clear();
            }
            return this;
        }

        public Builder removeOrigins(int index) {
            if (this.originsBuilder_ == null) {
                this.ensureOriginsIsMutable();
                this.origins_.remove(index);
                this.onChanged();
            } else {
                this.originsBuilder_.remove(index);
            }
            return this;
        }

        public RouteMatrixOrigin.Builder getOriginsBuilder(int index) {
            return (RouteMatrixOrigin.Builder)this.getOriginsFieldBuilder().getBuilder(index);
        }

        @Override
        public RouteMatrixOriginOrBuilder getOriginsOrBuilder(int index) {
            if (this.originsBuilder_ == null) {
                return this.origins_.get(index);
            }
            return (RouteMatrixOriginOrBuilder)this.originsBuilder_.getMessageOrBuilder(index);
        }

        @Override
        public List<? extends RouteMatrixOriginOrBuilder> getOriginsOrBuilderList() {
            if (this.originsBuilder_ != null) {
                return this.originsBuilder_.getMessageOrBuilderList();
            }
            return Collections.unmodifiableList(this.origins_);
        }

        public RouteMatrixOrigin.Builder addOriginsBuilder() {
            return (RouteMatrixOrigin.Builder)this.getOriginsFieldBuilder().addBuilder((AbstractMessage)RouteMatrixOrigin.getDefaultInstance());
        }

        public RouteMatrixOrigin.Builder addOriginsBuilder(int index) {
            return (RouteMatrixOrigin.Builder)this.getOriginsFieldBuilder().addBuilder(index, (AbstractMessage)RouteMatrixOrigin.getDefaultInstance());
        }

        public List<RouteMatrixOrigin.Builder> getOriginsBuilderList() {
            return this.getOriginsFieldBuilder().getBuilderList();
        }

        private RepeatedFieldBuilderV3<RouteMatrixOrigin, RouteMatrixOrigin.Builder, RouteMatrixOriginOrBuilder> getOriginsFieldBuilder() {
            if (this.originsBuilder_ == null) {
                this.originsBuilder_ = new RepeatedFieldBuilderV3(this.origins_, (this.bitField0_ & 1) != 0, (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.origins_ = null;
            }
            return this.originsBuilder_;
        }

        private void ensureDestinationsIsMutable() {
            if ((this.bitField0_ & 2) == 0) {
                this.destinations_ = new ArrayList<RouteMatrixDestination>(this.destinations_);
                this.bitField0_ |= 2;
            }
        }

        @Override
        public List<RouteMatrixDestination> getDestinationsList() {
            if (this.destinationsBuilder_ == null) {
                return Collections.unmodifiableList(this.destinations_);
            }
            return this.destinationsBuilder_.getMessageList();
        }

        @Override
        public int getDestinationsCount() {
            if (this.destinationsBuilder_ == null) {
                return this.destinations_.size();
            }
            return this.destinationsBuilder_.getCount();
        }

        @Override
        public RouteMatrixDestination getDestinations(int index) {
            if (this.destinationsBuilder_ == null) {
                return this.destinations_.get(index);
            }
            return (RouteMatrixDestination)this.destinationsBuilder_.getMessage(index);
        }

        public Builder setDestinations(int index, RouteMatrixDestination value) {
            if (this.destinationsBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureDestinationsIsMutable();
                this.destinations_.set(index, value);
                this.onChanged();
            } else {
                this.destinationsBuilder_.setMessage(index, (AbstractMessage)value);
            }
            return this;
        }

        public Builder setDestinations(int index, RouteMatrixDestination.Builder builderForValue) {
            if (this.destinationsBuilder_ == null) {
                this.ensureDestinationsIsMutable();
                this.destinations_.set(index, builderForValue.build());
                this.onChanged();
            } else {
                this.destinationsBuilder_.setMessage(index, (AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addDestinations(RouteMatrixDestination value) {
            if (this.destinationsBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureDestinationsIsMutable();
                this.destinations_.add(value);
                this.onChanged();
            } else {
                this.destinationsBuilder_.addMessage((AbstractMessage)value);
            }
            return this;
        }

        public Builder addDestinations(int index, RouteMatrixDestination value) {
            if (this.destinationsBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureDestinationsIsMutable();
                this.destinations_.add(index, value);
                this.onChanged();
            } else {
                this.destinationsBuilder_.addMessage(index, (AbstractMessage)value);
            }
            return this;
        }

        public Builder addDestinations(RouteMatrixDestination.Builder builderForValue) {
            if (this.destinationsBuilder_ == null) {
                this.ensureDestinationsIsMutable();
                this.destinations_.add(builderForValue.build());
                this.onChanged();
            } else {
                this.destinationsBuilder_.addMessage((AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addDestinations(int index, RouteMatrixDestination.Builder builderForValue) {
            if (this.destinationsBuilder_ == null) {
                this.ensureDestinationsIsMutable();
                this.destinations_.add(index, builderForValue.build());
                this.onChanged();
            } else {
                this.destinationsBuilder_.addMessage(index, (AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addAllDestinations(Iterable<? extends RouteMatrixDestination> values) {
            if (this.destinationsBuilder_ == null) {
                this.ensureDestinationsIsMutable();
                AbstractMessageLite.Builder.addAll(values, this.destinations_);
                this.onChanged();
            } else {
                this.destinationsBuilder_.addAllMessages(values);
            }
            return this;
        }

        public Builder clearDestinations() {
            if (this.destinationsBuilder_ == null) {
                this.destinations_ = Collections.emptyList();
                this.bitField0_ &= 0xFFFFFFFD;
                this.onChanged();
            } else {
                this.destinationsBuilder_.clear();
            }
            return this;
        }

        public Builder removeDestinations(int index) {
            if (this.destinationsBuilder_ == null) {
                this.ensureDestinationsIsMutable();
                this.destinations_.remove(index);
                this.onChanged();
            } else {
                this.destinationsBuilder_.remove(index);
            }
            return this;
        }

        public RouteMatrixDestination.Builder getDestinationsBuilder(int index) {
            return (RouteMatrixDestination.Builder)this.getDestinationsFieldBuilder().getBuilder(index);
        }

        @Override
        public RouteMatrixDestinationOrBuilder getDestinationsOrBuilder(int index) {
            if (this.destinationsBuilder_ == null) {
                return this.destinations_.get(index);
            }
            return (RouteMatrixDestinationOrBuilder)this.destinationsBuilder_.getMessageOrBuilder(index);
        }

        @Override
        public List<? extends RouteMatrixDestinationOrBuilder> getDestinationsOrBuilderList() {
            if (this.destinationsBuilder_ != null) {
                return this.destinationsBuilder_.getMessageOrBuilderList();
            }
            return Collections.unmodifiableList(this.destinations_);
        }

        public RouteMatrixDestination.Builder addDestinationsBuilder() {
            return (RouteMatrixDestination.Builder)this.getDestinationsFieldBuilder().addBuilder((AbstractMessage)RouteMatrixDestination.getDefaultInstance());
        }

        public RouteMatrixDestination.Builder addDestinationsBuilder(int index) {
            return (RouteMatrixDestination.Builder)this.getDestinationsFieldBuilder().addBuilder(index, (AbstractMessage)RouteMatrixDestination.getDefaultInstance());
        }

        public List<RouteMatrixDestination.Builder> getDestinationsBuilderList() {
            return this.getDestinationsFieldBuilder().getBuilderList();
        }

        private RepeatedFieldBuilderV3<RouteMatrixDestination, RouteMatrixDestination.Builder, RouteMatrixDestinationOrBuilder> getDestinationsFieldBuilder() {
            if (this.destinationsBuilder_ == null) {
                this.destinationsBuilder_ = new RepeatedFieldBuilderV3(this.destinations_, (this.bitField0_ & 2) != 0, (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.destinations_ = null;
            }
            return this.destinationsBuilder_;
        }

        @Override
        public int getTravelModeValue() {
            return this.travelMode_;
        }

        public Builder setTravelModeValue(int value) {
            this.travelMode_ = value;
            this.bitField0_ |= 4;
            this.onChanged();
            return this;
        }

        @Override
        public RouteTravelMode getTravelMode() {
            RouteTravelMode result = RouteTravelMode.forNumber(this.travelMode_);
            return result == null ? RouteTravelMode.UNRECOGNIZED : result;
        }

        public Builder setTravelMode(RouteTravelMode value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.bitField0_ |= 4;
            this.travelMode_ = value.getNumber();
            this.onChanged();
            return this;
        }

        public Builder clearTravelMode() {
            this.bitField0_ &= 0xFFFFFFFB;
            this.travelMode_ = 0;
            this.onChanged();
            return this;
        }

        @Override
        public int getRoutingPreferenceValue() {
            return this.routingPreference_;
        }

        public Builder setRoutingPreferenceValue(int value) {
            this.routingPreference_ = value;
            this.bitField0_ |= 8;
            this.onChanged();
            return this;
        }

        @Override
        public RoutingPreference getRoutingPreference() {
            RoutingPreference result = RoutingPreference.forNumber(this.routingPreference_);
            return result == null ? RoutingPreference.UNRECOGNIZED : result;
        }

        public Builder setRoutingPreference(RoutingPreference value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.bitField0_ |= 8;
            this.routingPreference_ = value.getNumber();
            this.onChanged();
            return this;
        }

        public Builder clearRoutingPreference() {
            this.bitField0_ &= 0xFFFFFFF7;
            this.routingPreference_ = 0;
            this.onChanged();
            return this;
        }

        @Override
        public boolean hasDepartureTime() {
            return (this.bitField0_ & 0x10) != 0;
        }

        @Override
        public Timestamp getDepartureTime() {
            if (this.departureTimeBuilder_ == null) {
                return this.departureTime_ == null ? Timestamp.getDefaultInstance() : this.departureTime_;
            }
            return (Timestamp)this.departureTimeBuilder_.getMessage();
        }

        public Builder setDepartureTime(Timestamp value) {
            if (this.departureTimeBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.departureTime_ = value;
            } else {
                this.departureTimeBuilder_.setMessage((AbstractMessage)value);
            }
            this.bitField0_ |= 0x10;
            this.onChanged();
            return this;
        }

        public Builder setDepartureTime(Timestamp.Builder builderForValue) {
            if (this.departureTimeBuilder_ == null) {
                this.departureTime_ = builderForValue.build();
            } else {
                this.departureTimeBuilder_.setMessage((AbstractMessage)builderForValue.build());
            }
            this.bitField0_ |= 0x10;
            this.onChanged();
            return this;
        }

        public Builder mergeDepartureTime(Timestamp value) {
            if (this.departureTimeBuilder_ == null) {
                if ((this.bitField0_ & 0x10) != 0 && this.departureTime_ != null && this.departureTime_ != Timestamp.getDefaultInstance()) {
                    this.getDepartureTimeBuilder().mergeFrom(value);
                } else {
                    this.departureTime_ = value;
                }
            } else {
                this.departureTimeBuilder_.mergeFrom((AbstractMessage)value);
            }
            if (this.departureTime_ != null) {
                this.bitField0_ |= 0x10;
                this.onChanged();
            }
            return this;
        }

        public Builder clearDepartureTime() {
            this.bitField0_ &= 0xFFFFFFEF;
            this.departureTime_ = null;
            if (this.departureTimeBuilder_ != null) {
                this.departureTimeBuilder_.dispose();
                this.departureTimeBuilder_ = null;
            }
            this.onChanged();
            return this;
        }

        public Timestamp.Builder getDepartureTimeBuilder() {
            this.bitField0_ |= 0x10;
            this.onChanged();
            return (Timestamp.Builder)this.getDepartureTimeFieldBuilder().getBuilder();
        }

        @Override
        public TimestampOrBuilder getDepartureTimeOrBuilder() {
            if (this.departureTimeBuilder_ != null) {
                return (TimestampOrBuilder)this.departureTimeBuilder_.getMessageOrBuilder();
            }
            return this.departureTime_ == null ? Timestamp.getDefaultInstance() : this.departureTime_;
        }

        private SingleFieldBuilderV3<Timestamp, Timestamp.Builder, TimestampOrBuilder> getDepartureTimeFieldBuilder() {
            if (this.departureTimeBuilder_ == null) {
                this.departureTimeBuilder_ = new SingleFieldBuilderV3((AbstractMessage)this.getDepartureTime(), (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.departureTime_ = null;
            }
            return this.departureTimeBuilder_;
        }

        @Override
        public boolean hasArrivalTime() {
            return (this.bitField0_ & 0x20) != 0;
        }

        @Override
        public Timestamp getArrivalTime() {
            if (this.arrivalTimeBuilder_ == null) {
                return this.arrivalTime_ == null ? Timestamp.getDefaultInstance() : this.arrivalTime_;
            }
            return (Timestamp)this.arrivalTimeBuilder_.getMessage();
        }

        public Builder setArrivalTime(Timestamp value) {
            if (this.arrivalTimeBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.arrivalTime_ = value;
            } else {
                this.arrivalTimeBuilder_.setMessage((AbstractMessage)value);
            }
            this.bitField0_ |= 0x20;
            this.onChanged();
            return this;
        }

        public Builder setArrivalTime(Timestamp.Builder builderForValue) {
            if (this.arrivalTimeBuilder_ == null) {
                this.arrivalTime_ = builderForValue.build();
            } else {
                this.arrivalTimeBuilder_.setMessage((AbstractMessage)builderForValue.build());
            }
            this.bitField0_ |= 0x20;
            this.onChanged();
            return this;
        }

        public Builder mergeArrivalTime(Timestamp value) {
            if (this.arrivalTimeBuilder_ == null) {
                if ((this.bitField0_ & 0x20) != 0 && this.arrivalTime_ != null && this.arrivalTime_ != Timestamp.getDefaultInstance()) {
                    this.getArrivalTimeBuilder().mergeFrom(value);
                } else {
                    this.arrivalTime_ = value;
                }
            } else {
                this.arrivalTimeBuilder_.mergeFrom((AbstractMessage)value);
            }
            if (this.arrivalTime_ != null) {
                this.bitField0_ |= 0x20;
                this.onChanged();
            }
            return this;
        }

        public Builder clearArrivalTime() {
            this.bitField0_ &= 0xFFFFFFDF;
            this.arrivalTime_ = null;
            if (this.arrivalTimeBuilder_ != null) {
                this.arrivalTimeBuilder_.dispose();
                this.arrivalTimeBuilder_ = null;
            }
            this.onChanged();
            return this;
        }

        public Timestamp.Builder getArrivalTimeBuilder() {
            this.bitField0_ |= 0x20;
            this.onChanged();
            return (Timestamp.Builder)this.getArrivalTimeFieldBuilder().getBuilder();
        }

        @Override
        public TimestampOrBuilder getArrivalTimeOrBuilder() {
            if (this.arrivalTimeBuilder_ != null) {
                return (TimestampOrBuilder)this.arrivalTimeBuilder_.getMessageOrBuilder();
            }
            return this.arrivalTime_ == null ? Timestamp.getDefaultInstance() : this.arrivalTime_;
        }

        private SingleFieldBuilderV3<Timestamp, Timestamp.Builder, TimestampOrBuilder> getArrivalTimeFieldBuilder() {
            if (this.arrivalTimeBuilder_ == null) {
                this.arrivalTimeBuilder_ = new SingleFieldBuilderV3((AbstractMessage)this.getArrivalTime(), (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.arrivalTime_ = null;
            }
            return this.arrivalTimeBuilder_;
        }

        @Override
        public String getLanguageCode() {
            Object ref = this.languageCode_;
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                this.languageCode_ = s;
                return s;
            }
            return (String)ref;
        }

        @Override
        public ByteString getLanguageCodeBytes() {
            Object ref = this.languageCode_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.languageCode_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public Builder setLanguageCode(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.languageCode_ = value;
            this.bitField0_ |= 0x40;
            this.onChanged();
            return this;
        }

        public Builder clearLanguageCode() {
            this.languageCode_ = ComputeRouteMatrixRequest.getDefaultInstance().getLanguageCode();
            this.bitField0_ &= 0xFFFFFFBF;
            this.onChanged();
            return this;
        }

        public Builder setLanguageCodeBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            ComputeRouteMatrixRequest.checkByteStringIsUtf8((ByteString)value);
            this.languageCode_ = value;
            this.bitField0_ |= 0x40;
            this.onChanged();
            return this;
        }

        @Override
        public String getRegionCode() {
            Object ref = this.regionCode_;
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                this.regionCode_ = s;
                return s;
            }
            return (String)ref;
        }

        @Override
        public ByteString getRegionCodeBytes() {
            Object ref = this.regionCode_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.regionCode_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public Builder setRegionCode(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.regionCode_ = value;
            this.bitField0_ |= 0x80;
            this.onChanged();
            return this;
        }

        public Builder clearRegionCode() {
            this.regionCode_ = ComputeRouteMatrixRequest.getDefaultInstance().getRegionCode();
            this.bitField0_ &= 0xFFFFFF7F;
            this.onChanged();
            return this;
        }

        public Builder setRegionCodeBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            ComputeRouteMatrixRequest.checkByteStringIsUtf8((ByteString)value);
            this.regionCode_ = value;
            this.bitField0_ |= 0x80;
            this.onChanged();
            return this;
        }

        private void ensureExtraComputationsIsMutable() {
            if ((this.bitField0_ & 0x100) == 0) {
                this.extraComputations_ = new ArrayList<Integer>(this.extraComputations_);
                this.bitField0_ |= 0x100;
            }
        }

        @Override
        public List<ExtraComputation> getExtraComputationsList() {
            return new Internal.ListAdapter(this.extraComputations_, extraComputations_converter_);
        }

        @Override
        public int getExtraComputationsCount() {
            return this.extraComputations_.size();
        }

        @Override
        public ExtraComputation getExtraComputations(int index) {
            return (ExtraComputation)((Object)extraComputations_converter_.convert((Object)this.extraComputations_.get(index)));
        }

        public Builder setExtraComputations(int index, ExtraComputation value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.ensureExtraComputationsIsMutable();
            this.extraComputations_.set(index, value.getNumber());
            this.onChanged();
            return this;
        }

        public Builder addExtraComputations(ExtraComputation value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.ensureExtraComputationsIsMutable();
            this.extraComputations_.add(value.getNumber());
            this.onChanged();
            return this;
        }

        public Builder addAllExtraComputations(Iterable<? extends ExtraComputation> values) {
            this.ensureExtraComputationsIsMutable();
            for (ExtraComputation extraComputation : values) {
                this.extraComputations_.add(extraComputation.getNumber());
            }
            this.onChanged();
            return this;
        }

        public Builder clearExtraComputations() {
            this.extraComputations_ = Collections.emptyList();
            this.bitField0_ &= 0xFFFFFEFF;
            this.onChanged();
            return this;
        }

        @Override
        public List<Integer> getExtraComputationsValueList() {
            return Collections.unmodifiableList(this.extraComputations_);
        }

        @Override
        public int getExtraComputationsValue(int index) {
            return this.extraComputations_.get(index);
        }

        public Builder setExtraComputationsValue(int index, int value) {
            this.ensureExtraComputationsIsMutable();
            this.extraComputations_.set(index, value);
            this.onChanged();
            return this;
        }

        public Builder addExtraComputationsValue(int value) {
            this.ensureExtraComputationsIsMutable();
            this.extraComputations_.add(value);
            this.onChanged();
            return this;
        }

        public Builder addAllExtraComputationsValue(Iterable<Integer> values) {
            this.ensureExtraComputationsIsMutable();
            for (int value : values) {
                this.extraComputations_.add(value);
            }
            this.onChanged();
            return this;
        }

        @Override
        public int getTrafficModelValue() {
            return this.trafficModel_;
        }

        public Builder setTrafficModelValue(int value) {
            this.trafficModel_ = value;
            this.bitField0_ |= 0x200;
            this.onChanged();
            return this;
        }

        @Override
        public TrafficModel getTrafficModel() {
            TrafficModel result = TrafficModel.forNumber(this.trafficModel_);
            return result == null ? TrafficModel.UNRECOGNIZED : result;
        }

        public Builder setTrafficModel(TrafficModel value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.bitField0_ |= 0x200;
            this.trafficModel_ = value.getNumber();
            this.onChanged();
            return this;
        }

        public Builder clearTrafficModel() {
            this.bitField0_ &= 0xFFFFFDFF;
            this.trafficModel_ = 0;
            this.onChanged();
            return this;
        }

        @Override
        public boolean hasTransitPreferences() {
            return (this.bitField0_ & 0x400) != 0;
        }

        @Override
        public TransitPreferences getTransitPreferences() {
            if (this.transitPreferencesBuilder_ == null) {
                return this.transitPreferences_ == null ? TransitPreferences.getDefaultInstance() : this.transitPreferences_;
            }
            return (TransitPreferences)this.transitPreferencesBuilder_.getMessage();
        }

        public Builder setTransitPreferences(TransitPreferences value) {
            if (this.transitPreferencesBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.transitPreferences_ = value;
            } else {
                this.transitPreferencesBuilder_.setMessage((AbstractMessage)value);
            }
            this.bitField0_ |= 0x400;
            this.onChanged();
            return this;
        }

        public Builder setTransitPreferences(TransitPreferences.Builder builderForValue) {
            if (this.transitPreferencesBuilder_ == null) {
                this.transitPreferences_ = builderForValue.build();
            } else {
                this.transitPreferencesBuilder_.setMessage((AbstractMessage)builderForValue.build());
            }
            this.bitField0_ |= 0x400;
            this.onChanged();
            return this;
        }

        public Builder mergeTransitPreferences(TransitPreferences value) {
            if (this.transitPreferencesBuilder_ == null) {
                if ((this.bitField0_ & 0x400) != 0 && this.transitPreferences_ != null && this.transitPreferences_ != TransitPreferences.getDefaultInstance()) {
                    this.getTransitPreferencesBuilder().mergeFrom(value);
                } else {
                    this.transitPreferences_ = value;
                }
            } else {
                this.transitPreferencesBuilder_.mergeFrom((AbstractMessage)value);
            }
            if (this.transitPreferences_ != null) {
                this.bitField0_ |= 0x400;
                this.onChanged();
            }
            return this;
        }

        public Builder clearTransitPreferences() {
            this.bitField0_ &= 0xFFFFFBFF;
            this.transitPreferences_ = null;
            if (this.transitPreferencesBuilder_ != null) {
                this.transitPreferencesBuilder_.dispose();
                this.transitPreferencesBuilder_ = null;
            }
            this.onChanged();
            return this;
        }

        public TransitPreferences.Builder getTransitPreferencesBuilder() {
            this.bitField0_ |= 0x400;
            this.onChanged();
            return (TransitPreferences.Builder)this.getTransitPreferencesFieldBuilder().getBuilder();
        }

        @Override
        public TransitPreferencesOrBuilder getTransitPreferencesOrBuilder() {
            if (this.transitPreferencesBuilder_ != null) {
                return (TransitPreferencesOrBuilder)this.transitPreferencesBuilder_.getMessageOrBuilder();
            }
            return this.transitPreferences_ == null ? TransitPreferences.getDefaultInstance() : this.transitPreferences_;
        }

        private SingleFieldBuilderV3<TransitPreferences, TransitPreferences.Builder, TransitPreferencesOrBuilder> getTransitPreferencesFieldBuilder() {
            if (this.transitPreferencesBuilder_ == null) {
                this.transitPreferencesBuilder_ = new SingleFieldBuilderV3((AbstractMessage)this.getTransitPreferences(), (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.transitPreferences_ = null;
            }
            return this.transitPreferencesBuilder_;
        }

        public final Builder setUnknownFields(UnknownFieldSet unknownFields) {
            return (Builder)super.setUnknownFields(unknownFields);
        }

        public final Builder mergeUnknownFields(UnknownFieldSet unknownFields) {
            return (Builder)super.mergeUnknownFields(unknownFields);
        }
    }

    public static enum ExtraComputation implements ProtocolMessageEnum
    {
        EXTRA_COMPUTATION_UNSPECIFIED(0),
        TOLLS(1),
        UNRECOGNIZED(-1);

        public static final int EXTRA_COMPUTATION_UNSPECIFIED_VALUE = 0;
        public static final int TOLLS_VALUE = 1;
        private static final Internal.EnumLiteMap<ExtraComputation> internalValueMap;
        private static final ExtraComputation[] VALUES;
        private final int value;

        public final int getNumber() {
            if (this == UNRECOGNIZED) {
                throw new IllegalArgumentException("Can't get the number of an unknown enum value.");
            }
            return this.value;
        }

        @Deprecated
        public static ExtraComputation valueOf(int value) {
            return ExtraComputation.forNumber(value);
        }

        public static ExtraComputation forNumber(int value) {
            switch (value) {
                case 0: {
                    return EXTRA_COMPUTATION_UNSPECIFIED;
                }
                case 1: {
                    return TOLLS;
                }
            }
            return null;
        }

        public static Internal.EnumLiteMap<ExtraComputation> internalGetValueMap() {
            return internalValueMap;
        }

        public final Descriptors.EnumValueDescriptor getValueDescriptor() {
            if (this == UNRECOGNIZED) {
                throw new IllegalStateException("Can't get the descriptor of an unrecognized enum value.");
            }
            return (Descriptors.EnumValueDescriptor)ExtraComputation.getDescriptor().getValues().get(this.ordinal());
        }

        public final Descriptors.EnumDescriptor getDescriptorForType() {
            return ExtraComputation.getDescriptor();
        }

        public static final Descriptors.EnumDescriptor getDescriptor() {
            return (Descriptors.EnumDescriptor)ComputeRouteMatrixRequest.getDescriptor().getEnumTypes().get(0);
        }

        public static ExtraComputation valueOf(Descriptors.EnumValueDescriptor desc) {
            if (desc.getType() != ExtraComputation.getDescriptor()) {
                throw new IllegalArgumentException("EnumValueDescriptor is not for this type.");
            }
            if (desc.getIndex() == -1) {
                return UNRECOGNIZED;
            }
            return VALUES[desc.getIndex()];
        }

        private ExtraComputation(int value) {
            this.value = value;
        }

        static {
            internalValueMap = new Internal.EnumLiteMap<ExtraComputation>(){

                public ExtraComputation findValueByNumber(int number) {
                    return ExtraComputation.forNumber(number);
                }
            };
            VALUES = ExtraComputation.values();
        }
    }
}

