/*
 * Decompiled with CFR 0.152.
 */
package com.google.maps.routing.v2;

import com.google.geo.type.Viewport;
import com.google.geo.type.ViewportOrBuilder;
import com.google.maps.routing.v2.Polyline;
import com.google.maps.routing.v2.PolylineOrBuilder;
import com.google.maps.routing.v2.RouteLabel;
import com.google.maps.routing.v2.RouteLeg;
import com.google.maps.routing.v2.RouteLegOrBuilder;
import com.google.maps.routing.v2.RouteOrBuilder;
import com.google.maps.routing.v2.RouteProto;
import com.google.maps.routing.v2.RouteTravelAdvisory;
import com.google.maps.routing.v2.RouteTravelAdvisoryOrBuilder;
import com.google.protobuf.AbstractMessage;
import com.google.protobuf.AbstractMessageLite;
import com.google.protobuf.AbstractParser;
import com.google.protobuf.ByteString;
import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import com.google.protobuf.Descriptors;
import com.google.protobuf.Duration;
import com.google.protobuf.DurationOrBuilder;
import com.google.protobuf.ExtensionRegistryLite;
import com.google.protobuf.GeneratedMessageV3;
import com.google.protobuf.Internal;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.LazyStringArrayList;
import com.google.protobuf.LazyStringList;
import com.google.protobuf.Message;
import com.google.protobuf.MessageLite;
import com.google.protobuf.MessageOrBuilder;
import com.google.protobuf.Parser;
import com.google.protobuf.ProtocolStringList;
import com.google.protobuf.RepeatedFieldBuilderV3;
import com.google.protobuf.SingleFieldBuilderV3;
import com.google.protobuf.UninitializedMessageException;
import com.google.protobuf.UnknownFieldSet;
import com.google.type.LocalizedText;
import com.google.type.LocalizedTextOrBuilder;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public final class Route
extends GeneratedMessageV3
implements RouteOrBuilder {
    private static final long serialVersionUID = 0L;
    public static final int ROUTE_LABELS_FIELD_NUMBER = 13;
    private List<Integer> routeLabels_;
    private static final Internal.ListAdapter.Converter<Integer, RouteLabel> routeLabels_converter_ = new Internal.ListAdapter.Converter<Integer, RouteLabel>(){

        public RouteLabel convert(Integer from) {
            RouteLabel result = RouteLabel.forNumber(from);
            return result == null ? RouteLabel.UNRECOGNIZED : result;
        }
    };
    private int routeLabelsMemoizedSerializedSize;
    public static final int LEGS_FIELD_NUMBER = 1;
    private List<RouteLeg> legs_;
    public static final int DISTANCE_METERS_FIELD_NUMBER = 2;
    private int distanceMeters_ = 0;
    public static final int DURATION_FIELD_NUMBER = 3;
    private Duration duration_;
    public static final int STATIC_DURATION_FIELD_NUMBER = 4;
    private Duration staticDuration_;
    public static final int POLYLINE_FIELD_NUMBER = 5;
    private Polyline polyline_;
    public static final int DESCRIPTION_FIELD_NUMBER = 6;
    private volatile Object description_ = "";
    public static final int WARNINGS_FIELD_NUMBER = 7;
    private LazyStringArrayList warnings_ = LazyStringArrayList.emptyList();
    public static final int VIEWPORT_FIELD_NUMBER = 8;
    private Viewport viewport_;
    public static final int TRAVEL_ADVISORY_FIELD_NUMBER = 9;
    private RouteTravelAdvisory travelAdvisory_;
    public static final int OPTIMIZED_INTERMEDIATE_WAYPOINT_INDEX_FIELD_NUMBER = 10;
    private Internal.IntList optimizedIntermediateWaypointIndex_;
    private int optimizedIntermediateWaypointIndexMemoizedSerializedSize = -1;
    public static final int LOCALIZED_VALUES_FIELD_NUMBER = 11;
    private RouteLocalizedValues localizedValues_;
    public static final int ROUTE_TOKEN_FIELD_NUMBER = 12;
    private volatile Object routeToken_ = "";
    private byte memoizedIsInitialized = (byte)-1;
    private static final Route DEFAULT_INSTANCE = new Route();
    private static final Parser<Route> PARSER = new AbstractParser<Route>(){

        public Route parsePartialFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            Builder builder = Route.newBuilder();
            try {
                builder.mergeFrom(input, extensionRegistry);
            }
            catch (InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage((MessageLite)builder.buildPartial());
            }
            catch (UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException().setUnfinishedMessage((MessageLite)builder.buildPartial());
            }
            catch (IOException e) {
                throw new InvalidProtocolBufferException(e).setUnfinishedMessage((MessageLite)builder.buildPartial());
            }
            return builder.buildPartial();
        }
    };

    private Route(GeneratedMessageV3.Builder<?> builder) {
        super(builder);
    }

    private Route() {
        this.routeLabels_ = Collections.emptyList();
        this.legs_ = Collections.emptyList();
        this.description_ = "";
        this.warnings_ = LazyStringArrayList.emptyList();
        this.optimizedIntermediateWaypointIndex_ = Route.emptyIntList();
        this.routeToken_ = "";
    }

    protected Object newInstance(GeneratedMessageV3.UnusedPrivateParameter unused) {
        return new Route();
    }

    public static final Descriptors.Descriptor getDescriptor() {
        return RouteProto.internal_static_google_maps_routing_v2_Route_descriptor;
    }

    protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
        return RouteProto.internal_static_google_maps_routing_v2_Route_fieldAccessorTable.ensureFieldAccessorsInitialized(Route.class, Builder.class);
    }

    @Override
    public List<RouteLabel> getRouteLabelsList() {
        return new Internal.ListAdapter(this.routeLabels_, routeLabels_converter_);
    }

    @Override
    public int getRouteLabelsCount() {
        return this.routeLabels_.size();
    }

    @Override
    public RouteLabel getRouteLabels(int index) {
        return (RouteLabel)((Object)routeLabels_converter_.convert((Object)this.routeLabels_.get(index)));
    }

    @Override
    public List<Integer> getRouteLabelsValueList() {
        return this.routeLabels_;
    }

    @Override
    public int getRouteLabelsValue(int index) {
        return this.routeLabels_.get(index);
    }

    @Override
    public List<RouteLeg> getLegsList() {
        return this.legs_;
    }

    @Override
    public List<? extends RouteLegOrBuilder> getLegsOrBuilderList() {
        return this.legs_;
    }

    @Override
    public int getLegsCount() {
        return this.legs_.size();
    }

    @Override
    public RouteLeg getLegs(int index) {
        return this.legs_.get(index);
    }

    @Override
    public RouteLegOrBuilder getLegsOrBuilder(int index) {
        return this.legs_.get(index);
    }

    @Override
    public int getDistanceMeters() {
        return this.distanceMeters_;
    }

    @Override
    public boolean hasDuration() {
        return this.duration_ != null;
    }

    @Override
    public Duration getDuration() {
        return this.duration_ == null ? Duration.getDefaultInstance() : this.duration_;
    }

    @Override
    public DurationOrBuilder getDurationOrBuilder() {
        return this.duration_ == null ? Duration.getDefaultInstance() : this.duration_;
    }

    @Override
    public boolean hasStaticDuration() {
        return this.staticDuration_ != null;
    }

    @Override
    public Duration getStaticDuration() {
        return this.staticDuration_ == null ? Duration.getDefaultInstance() : this.staticDuration_;
    }

    @Override
    public DurationOrBuilder getStaticDurationOrBuilder() {
        return this.staticDuration_ == null ? Duration.getDefaultInstance() : this.staticDuration_;
    }

    @Override
    public boolean hasPolyline() {
        return this.polyline_ != null;
    }

    @Override
    public Polyline getPolyline() {
        return this.polyline_ == null ? Polyline.getDefaultInstance() : this.polyline_;
    }

    @Override
    public PolylineOrBuilder getPolylineOrBuilder() {
        return this.polyline_ == null ? Polyline.getDefaultInstance() : this.polyline_;
    }

    @Override
    public String getDescription() {
        Object ref = this.description_;
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s = bs.toStringUtf8();
        this.description_ = s;
        return s;
    }

    @Override
    public ByteString getDescriptionBytes() {
        Object ref = this.description_;
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)((String)ref));
            this.description_ = b;
            return b;
        }
        return (ByteString)ref;
    }

    public ProtocolStringList getWarningsList() {
        return this.warnings_;
    }

    @Override
    public int getWarningsCount() {
        return this.warnings_.size();
    }

    @Override
    public String getWarnings(int index) {
        return this.warnings_.get(index);
    }

    @Override
    public ByteString getWarningsBytes(int index) {
        return this.warnings_.getByteString(index);
    }

    @Override
    public boolean hasViewport() {
        return this.viewport_ != null;
    }

    @Override
    public Viewport getViewport() {
        return this.viewport_ == null ? Viewport.getDefaultInstance() : this.viewport_;
    }

    @Override
    public ViewportOrBuilder getViewportOrBuilder() {
        return this.viewport_ == null ? Viewport.getDefaultInstance() : this.viewport_;
    }

    @Override
    public boolean hasTravelAdvisory() {
        return this.travelAdvisory_ != null;
    }

    @Override
    public RouteTravelAdvisory getTravelAdvisory() {
        return this.travelAdvisory_ == null ? RouteTravelAdvisory.getDefaultInstance() : this.travelAdvisory_;
    }

    @Override
    public RouteTravelAdvisoryOrBuilder getTravelAdvisoryOrBuilder() {
        return this.travelAdvisory_ == null ? RouteTravelAdvisory.getDefaultInstance() : this.travelAdvisory_;
    }

    @Override
    public List<Integer> getOptimizedIntermediateWaypointIndexList() {
        return this.optimizedIntermediateWaypointIndex_;
    }

    @Override
    public int getOptimizedIntermediateWaypointIndexCount() {
        return this.optimizedIntermediateWaypointIndex_.size();
    }

    @Override
    public int getOptimizedIntermediateWaypointIndex(int index) {
        return this.optimizedIntermediateWaypointIndex_.getInt(index);
    }

    @Override
    public boolean hasLocalizedValues() {
        return this.localizedValues_ != null;
    }

    @Override
    public RouteLocalizedValues getLocalizedValues() {
        return this.localizedValues_ == null ? RouteLocalizedValues.getDefaultInstance() : this.localizedValues_;
    }

    @Override
    public RouteLocalizedValuesOrBuilder getLocalizedValuesOrBuilder() {
        return this.localizedValues_ == null ? RouteLocalizedValues.getDefaultInstance() : this.localizedValues_;
    }

    @Override
    public String getRouteToken() {
        Object ref = this.routeToken_;
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s = bs.toStringUtf8();
        this.routeToken_ = s;
        return s;
    }

    @Override
    public ByteString getRouteTokenBytes() {
        Object ref = this.routeToken_;
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)((String)ref));
            this.routeToken_ = b;
            return b;
        }
        return (ByteString)ref;
    }

    public final boolean isInitialized() {
        byte isInitialized = this.memoizedIsInitialized;
        if (isInitialized == 1) {
            return true;
        }
        if (isInitialized == 0) {
            return false;
        }
        this.memoizedIsInitialized = 1;
        return true;
    }

    public void writeTo(CodedOutputStream output) throws IOException {
        int i;
        this.getSerializedSize();
        for (i = 0; i < this.legs_.size(); ++i) {
            output.writeMessage(1, (MessageLite)this.legs_.get(i));
        }
        if (this.distanceMeters_ != 0) {
            output.writeInt32(2, this.distanceMeters_);
        }
        if (this.duration_ != null) {
            output.writeMessage(3, (MessageLite)this.getDuration());
        }
        if (this.staticDuration_ != null) {
            output.writeMessage(4, (MessageLite)this.getStaticDuration());
        }
        if (this.polyline_ != null) {
            output.writeMessage(5, (MessageLite)this.getPolyline());
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.description_)) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)6, (Object)this.description_);
        }
        for (i = 0; i < this.warnings_.size(); ++i) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)7, (Object)this.warnings_.getRaw(i));
        }
        if (this.viewport_ != null) {
            output.writeMessage(8, (MessageLite)this.getViewport());
        }
        if (this.travelAdvisory_ != null) {
            output.writeMessage(9, (MessageLite)this.getTravelAdvisory());
        }
        if (this.getOptimizedIntermediateWaypointIndexList().size() > 0) {
            output.writeUInt32NoTag(82);
            output.writeUInt32NoTag(this.optimizedIntermediateWaypointIndexMemoizedSerializedSize);
        }
        for (i = 0; i < this.optimizedIntermediateWaypointIndex_.size(); ++i) {
            output.writeInt32NoTag(this.optimizedIntermediateWaypointIndex_.getInt(i));
        }
        if (this.localizedValues_ != null) {
            output.writeMessage(11, (MessageLite)this.getLocalizedValues());
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.routeToken_)) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)12, (Object)this.routeToken_);
        }
        if (this.getRouteLabelsList().size() > 0) {
            output.writeUInt32NoTag(106);
            output.writeUInt32NoTag(this.routeLabelsMemoizedSerializedSize);
        }
        for (i = 0; i < this.routeLabels_.size(); ++i) {
            output.writeEnumNoTag(this.routeLabels_.get(i).intValue());
        }
        this.getUnknownFields().writeTo(output);
    }

    public int getSerializedSize() {
        int i;
        int size = this.memoizedSize;
        if (size != -1) {
            return size;
        }
        size = 0;
        for (int i2 = 0; i2 < this.legs_.size(); ++i2) {
            size += CodedOutputStream.computeMessageSize((int)1, (MessageLite)((MessageLite)this.legs_.get(i2)));
        }
        if (this.distanceMeters_ != 0) {
            size += CodedOutputStream.computeInt32Size((int)2, (int)this.distanceMeters_);
        }
        if (this.duration_ != null) {
            size += CodedOutputStream.computeMessageSize((int)3, (MessageLite)this.getDuration());
        }
        if (this.staticDuration_ != null) {
            size += CodedOutputStream.computeMessageSize((int)4, (MessageLite)this.getStaticDuration());
        }
        if (this.polyline_ != null) {
            size += CodedOutputStream.computeMessageSize((int)5, (MessageLite)this.getPolyline());
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.description_)) {
            size += GeneratedMessageV3.computeStringSize((int)6, (Object)this.description_);
        }
        int dataSize = 0;
        for (i = 0; i < this.warnings_.size(); ++i) {
            dataSize += Route.computeStringSizeNoTag((Object)this.warnings_.getRaw(i));
        }
        size += dataSize;
        size += 1 * this.getWarningsList().size();
        if (this.viewport_ != null) {
            size += CodedOutputStream.computeMessageSize((int)8, (MessageLite)this.getViewport());
        }
        if (this.travelAdvisory_ != null) {
            size += CodedOutputStream.computeMessageSize((int)9, (MessageLite)this.getTravelAdvisory());
        }
        dataSize = 0;
        for (i = 0; i < this.optimizedIntermediateWaypointIndex_.size(); ++i) {
            dataSize += CodedOutputStream.computeInt32SizeNoTag((int)this.optimizedIntermediateWaypointIndex_.getInt(i));
        }
        size += dataSize;
        if (!this.getOptimizedIntermediateWaypointIndexList().isEmpty()) {
            ++size;
            size += CodedOutputStream.computeInt32SizeNoTag((int)dataSize);
        }
        this.optimizedIntermediateWaypointIndexMemoizedSerializedSize = dataSize;
        if (this.localizedValues_ != null) {
            size += CodedOutputStream.computeMessageSize((int)11, (MessageLite)this.getLocalizedValues());
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.routeToken_)) {
            size += GeneratedMessageV3.computeStringSize((int)12, (Object)this.routeToken_);
        }
        dataSize = 0;
        for (i = 0; i < this.routeLabels_.size(); ++i) {
            dataSize += CodedOutputStream.computeEnumSizeNoTag((int)this.routeLabels_.get(i));
        }
        size += dataSize;
        if (!this.getRouteLabelsList().isEmpty()) {
            ++size;
            size += CodedOutputStream.computeUInt32SizeNoTag((int)dataSize);
        }
        this.routeLabelsMemoizedSerializedSize = dataSize;
        this.memoizedSize = size += this.getUnknownFields().getSerializedSize();
        return size;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Route)) {
            return super.equals(obj);
        }
        Route other = (Route)obj;
        if (!this.routeLabels_.equals(other.routeLabels_)) {
            return false;
        }
        if (!this.getLegsList().equals(other.getLegsList())) {
            return false;
        }
        if (this.getDistanceMeters() != other.getDistanceMeters()) {
            return false;
        }
        if (this.hasDuration() != other.hasDuration()) {
            return false;
        }
        if (this.hasDuration() && !this.getDuration().equals((Object)other.getDuration())) {
            return false;
        }
        if (this.hasStaticDuration() != other.hasStaticDuration()) {
            return false;
        }
        if (this.hasStaticDuration() && !this.getStaticDuration().equals((Object)other.getStaticDuration())) {
            return false;
        }
        if (this.hasPolyline() != other.hasPolyline()) {
            return false;
        }
        if (this.hasPolyline() && !this.getPolyline().equals(other.getPolyline())) {
            return false;
        }
        if (!this.getDescription().equals(other.getDescription())) {
            return false;
        }
        if (!this.getWarningsList().equals(other.getWarningsList())) {
            return false;
        }
        if (this.hasViewport() != other.hasViewport()) {
            return false;
        }
        if (this.hasViewport() && !this.getViewport().equals((Object)other.getViewport())) {
            return false;
        }
        if (this.hasTravelAdvisory() != other.hasTravelAdvisory()) {
            return false;
        }
        if (this.hasTravelAdvisory() && !this.getTravelAdvisory().equals(other.getTravelAdvisory())) {
            return false;
        }
        if (!this.getOptimizedIntermediateWaypointIndexList().equals(other.getOptimizedIntermediateWaypointIndexList())) {
            return false;
        }
        if (this.hasLocalizedValues() != other.hasLocalizedValues()) {
            return false;
        }
        if (this.hasLocalizedValues() && !this.getLocalizedValues().equals(other.getLocalizedValues())) {
            return false;
        }
        if (!this.getRouteToken().equals(other.getRouteToken())) {
            return false;
        }
        return this.getUnknownFields().equals((Object)other.getUnknownFields());
    }

    public int hashCode() {
        if (this.memoizedHashCode != 0) {
            return this.memoizedHashCode;
        }
        int hash = 41;
        hash = 19 * hash + Route.getDescriptor().hashCode();
        if (this.getRouteLabelsCount() > 0) {
            hash = 37 * hash + 13;
            hash = 53 * hash + this.routeLabels_.hashCode();
        }
        if (this.getLegsCount() > 0) {
            hash = 37 * hash + 1;
            hash = 53 * hash + this.getLegsList().hashCode();
        }
        hash = 37 * hash + 2;
        hash = 53 * hash + this.getDistanceMeters();
        if (this.hasDuration()) {
            hash = 37 * hash + 3;
            hash = 53 * hash + this.getDuration().hashCode();
        }
        if (this.hasStaticDuration()) {
            hash = 37 * hash + 4;
            hash = 53 * hash + this.getStaticDuration().hashCode();
        }
        if (this.hasPolyline()) {
            hash = 37 * hash + 5;
            hash = 53 * hash + this.getPolyline().hashCode();
        }
        hash = 37 * hash + 6;
        hash = 53 * hash + this.getDescription().hashCode();
        if (this.getWarningsCount() > 0) {
            hash = 37 * hash + 7;
            hash = 53 * hash + this.getWarningsList().hashCode();
        }
        if (this.hasViewport()) {
            hash = 37 * hash + 8;
            hash = 53 * hash + this.getViewport().hashCode();
        }
        if (this.hasTravelAdvisory()) {
            hash = 37 * hash + 9;
            hash = 53 * hash + this.getTravelAdvisory().hashCode();
        }
        if (this.getOptimizedIntermediateWaypointIndexCount() > 0) {
            hash = 37 * hash + 10;
            hash = 53 * hash + this.getOptimizedIntermediateWaypointIndexList().hashCode();
        }
        if (this.hasLocalizedValues()) {
            hash = 37 * hash + 11;
            hash = 53 * hash + this.getLocalizedValues().hashCode();
        }
        hash = 37 * hash + 12;
        hash = 53 * hash + this.getRouteToken().hashCode();
        this.memoizedHashCode = hash = 29 * hash + this.getUnknownFields().hashCode();
        return hash;
    }

    public static Route parseFrom(ByteBuffer data) throws InvalidProtocolBufferException {
        return (Route)PARSER.parseFrom(data);
    }

    public static Route parseFrom(ByteBuffer data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (Route)PARSER.parseFrom(data, extensionRegistry);
    }

    public static Route parseFrom(ByteString data) throws InvalidProtocolBufferException {
        return (Route)PARSER.parseFrom(data);
    }

    public static Route parseFrom(ByteString data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (Route)PARSER.parseFrom(data, extensionRegistry);
    }

    public static Route parseFrom(byte[] data) throws InvalidProtocolBufferException {
        return (Route)PARSER.parseFrom(data);
    }

    public static Route parseFrom(byte[] data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (Route)PARSER.parseFrom(data, extensionRegistry);
    }

    public static Route parseFrom(InputStream input) throws IOException {
        return (Route)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input);
    }

    public static Route parseFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (Route)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public static Route parseDelimitedFrom(InputStream input) throws IOException {
        return (Route)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input);
    }

    public static Route parseDelimitedFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (Route)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public static Route parseFrom(CodedInputStream input) throws IOException {
        return (Route)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input);
    }

    public static Route parseFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (Route)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public Builder newBuilderForType() {
        return Route.newBuilder();
    }

    public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(Route prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    protected Builder newBuilderForType(GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
    }

    public static Route getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public static Parser<Route> parser() {
        return PARSER;
    }

    public Parser<Route> getParserForType() {
        return PARSER;
    }

    public Route getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
    }

    static /* synthetic */ Internal.IntList access$2800() {
        return Route.emptyIntList();
    }

    public static final class Builder
    extends GeneratedMessageV3.Builder<Builder>
    implements RouteOrBuilder {
        private int bitField0_;
        private List<Integer> routeLabels_ = Collections.emptyList();
        private List<RouteLeg> legs_ = Collections.emptyList();
        private RepeatedFieldBuilderV3<RouteLeg, RouteLeg.Builder, RouteLegOrBuilder> legsBuilder_;
        private int distanceMeters_;
        private Duration duration_;
        private SingleFieldBuilderV3<Duration, Duration.Builder, DurationOrBuilder> durationBuilder_;
        private Duration staticDuration_;
        private SingleFieldBuilderV3<Duration, Duration.Builder, DurationOrBuilder> staticDurationBuilder_;
        private Polyline polyline_;
        private SingleFieldBuilderV3<Polyline, Polyline.Builder, PolylineOrBuilder> polylineBuilder_;
        private Object description_ = "";
        private LazyStringArrayList warnings_ = LazyStringArrayList.emptyList();
        private Viewport viewport_;
        private SingleFieldBuilderV3<Viewport, Viewport.Builder, ViewportOrBuilder> viewportBuilder_;
        private RouteTravelAdvisory travelAdvisory_;
        private SingleFieldBuilderV3<RouteTravelAdvisory, RouteTravelAdvisory.Builder, RouteTravelAdvisoryOrBuilder> travelAdvisoryBuilder_;
        private Internal.IntList optimizedIntermediateWaypointIndex_ = Route.access$2800();
        private RouteLocalizedValues localizedValues_;
        private SingleFieldBuilderV3<RouteLocalizedValues, RouteLocalizedValues.Builder, RouteLocalizedValuesOrBuilder> localizedValuesBuilder_;
        private Object routeToken_ = "";

        public static final Descriptors.Descriptor getDescriptor() {
            return RouteProto.internal_static_google_maps_routing_v2_Route_descriptor;
        }

        protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
            return RouteProto.internal_static_google_maps_routing_v2_Route_fieldAccessorTable.ensureFieldAccessorsInitialized(Route.class, Builder.class);
        }

        private Builder() {
        }

        private Builder(GeneratedMessageV3.BuilderParent parent) {
            super(parent);
        }

        public Builder clear() {
            super.clear();
            this.bitField0_ = 0;
            this.routeLabels_ = Collections.emptyList();
            this.bitField0_ &= 0xFFFFFFFE;
            if (this.legsBuilder_ == null) {
                this.legs_ = Collections.emptyList();
            } else {
                this.legs_ = null;
                this.legsBuilder_.clear();
            }
            this.bitField0_ &= 0xFFFFFFFD;
            this.distanceMeters_ = 0;
            this.duration_ = null;
            if (this.durationBuilder_ != null) {
                this.durationBuilder_.dispose();
                this.durationBuilder_ = null;
            }
            this.staticDuration_ = null;
            if (this.staticDurationBuilder_ != null) {
                this.staticDurationBuilder_.dispose();
                this.staticDurationBuilder_ = null;
            }
            this.polyline_ = null;
            if (this.polylineBuilder_ != null) {
                this.polylineBuilder_.dispose();
                this.polylineBuilder_ = null;
            }
            this.description_ = "";
            this.warnings_ = LazyStringArrayList.emptyList();
            this.viewport_ = null;
            if (this.viewportBuilder_ != null) {
                this.viewportBuilder_.dispose();
                this.viewportBuilder_ = null;
            }
            this.travelAdvisory_ = null;
            if (this.travelAdvisoryBuilder_ != null) {
                this.travelAdvisoryBuilder_.dispose();
                this.travelAdvisoryBuilder_ = null;
            }
            this.optimizedIntermediateWaypointIndex_ = Route.emptyIntList();
            this.localizedValues_ = null;
            if (this.localizedValuesBuilder_ != null) {
                this.localizedValuesBuilder_.dispose();
                this.localizedValuesBuilder_ = null;
            }
            this.routeToken_ = "";
            return this;
        }

        public Descriptors.Descriptor getDescriptorForType() {
            return RouteProto.internal_static_google_maps_routing_v2_Route_descriptor;
        }

        public Route getDefaultInstanceForType() {
            return Route.getDefaultInstance();
        }

        public Route build() {
            Route result = this.buildPartial();
            if (!result.isInitialized()) {
                throw Builder.newUninitializedMessageException((Message)result);
            }
            return result;
        }

        public Route buildPartial() {
            Route result = new Route(this);
            this.buildPartialRepeatedFields(result);
            if (this.bitField0_ != 0) {
                this.buildPartial0(result);
            }
            this.onBuilt();
            return result;
        }

        private void buildPartialRepeatedFields(Route result) {
            if ((this.bitField0_ & 1) != 0) {
                this.routeLabels_ = Collections.unmodifiableList(this.routeLabels_);
                this.bitField0_ &= 0xFFFFFFFE;
            }
            result.routeLabels_ = this.routeLabels_;
            if (this.legsBuilder_ == null) {
                if ((this.bitField0_ & 2) != 0) {
                    this.legs_ = Collections.unmodifiableList(this.legs_);
                    this.bitField0_ &= 0xFFFFFFFD;
                }
                result.legs_ = this.legs_;
            } else {
                result.legs_ = this.legsBuilder_.build();
            }
            if ((this.bitField0_ & 0x400) != 0) {
                this.optimizedIntermediateWaypointIndex_.makeImmutable();
                this.bitField0_ &= 0xFFFFFBFF;
            }
            result.optimizedIntermediateWaypointIndex_ = this.optimizedIntermediateWaypointIndex_;
        }

        private void buildPartial0(Route result) {
            int from_bitField0_ = this.bitField0_;
            if ((from_bitField0_ & 4) != 0) {
                result.distanceMeters_ = this.distanceMeters_;
            }
            if ((from_bitField0_ & 8) != 0) {
                result.duration_ = this.durationBuilder_ == null ? this.duration_ : (Duration)this.durationBuilder_.build();
            }
            if ((from_bitField0_ & 0x10) != 0) {
                result.staticDuration_ = this.staticDurationBuilder_ == null ? this.staticDuration_ : (Duration)this.staticDurationBuilder_.build();
            }
            if ((from_bitField0_ & 0x20) != 0) {
                result.polyline_ = this.polylineBuilder_ == null ? this.polyline_ : (Polyline)this.polylineBuilder_.build();
            }
            if ((from_bitField0_ & 0x40) != 0) {
                result.description_ = this.description_;
            }
            if ((from_bitField0_ & 0x80) != 0) {
                this.warnings_.makeImmutable();
                result.warnings_ = this.warnings_;
            }
            if ((from_bitField0_ & 0x100) != 0) {
                result.viewport_ = this.viewportBuilder_ == null ? this.viewport_ : (Viewport)this.viewportBuilder_.build();
            }
            if ((from_bitField0_ & 0x200) != 0) {
                result.travelAdvisory_ = this.travelAdvisoryBuilder_ == null ? this.travelAdvisory_ : (RouteTravelAdvisory)this.travelAdvisoryBuilder_.build();
            }
            if ((from_bitField0_ & 0x800) != 0) {
                result.localizedValues_ = this.localizedValuesBuilder_ == null ? this.localizedValues_ : (RouteLocalizedValues)this.localizedValuesBuilder_.build();
            }
            if ((from_bitField0_ & 0x1000) != 0) {
                result.routeToken_ = this.routeToken_;
            }
        }

        public Builder clone() {
            return (Builder)super.clone();
        }

        public Builder setField(Descriptors.FieldDescriptor field, Object value) {
            return (Builder)super.setField(field, value);
        }

        public Builder clearField(Descriptors.FieldDescriptor field) {
            return (Builder)super.clearField(field);
        }

        public Builder clearOneof(Descriptors.OneofDescriptor oneof) {
            return (Builder)super.clearOneof(oneof);
        }

        public Builder setRepeatedField(Descriptors.FieldDescriptor field, int index, Object value) {
            return (Builder)super.setRepeatedField(field, index, value);
        }

        public Builder addRepeatedField(Descriptors.FieldDescriptor field, Object value) {
            return (Builder)super.addRepeatedField(field, value);
        }

        public Builder mergeFrom(Message other) {
            if (other instanceof Route) {
                return this.mergeFrom((Route)other);
            }
            super.mergeFrom(other);
            return this;
        }

        public Builder mergeFrom(Route other) {
            if (other == Route.getDefaultInstance()) {
                return this;
            }
            if (!other.routeLabels_.isEmpty()) {
                if (this.routeLabels_.isEmpty()) {
                    this.routeLabels_ = other.routeLabels_;
                    this.bitField0_ &= 0xFFFFFFFE;
                } else {
                    this.ensureRouteLabelsIsMutable();
                    this.routeLabels_.addAll(other.routeLabels_);
                }
                this.onChanged();
            }
            if (this.legsBuilder_ == null) {
                if (!other.legs_.isEmpty()) {
                    if (this.legs_.isEmpty()) {
                        this.legs_ = other.legs_;
                        this.bitField0_ &= 0xFFFFFFFD;
                    } else {
                        this.ensureLegsIsMutable();
                        this.legs_.addAll(other.legs_);
                    }
                    this.onChanged();
                }
            } else if (!other.legs_.isEmpty()) {
                if (this.legsBuilder_.isEmpty()) {
                    this.legsBuilder_.dispose();
                    this.legsBuilder_ = null;
                    this.legs_ = other.legs_;
                    this.bitField0_ &= 0xFFFFFFFD;
                    this.legsBuilder_ = alwaysUseFieldBuilders ? this.getLegsFieldBuilder() : null;
                } else {
                    this.legsBuilder_.addAllMessages((Iterable)other.legs_);
                }
            }
            if (other.getDistanceMeters() != 0) {
                this.setDistanceMeters(other.getDistanceMeters());
            }
            if (other.hasDuration()) {
                this.mergeDuration(other.getDuration());
            }
            if (other.hasStaticDuration()) {
                this.mergeStaticDuration(other.getStaticDuration());
            }
            if (other.hasPolyline()) {
                this.mergePolyline(other.getPolyline());
            }
            if (!other.getDescription().isEmpty()) {
                this.description_ = other.description_;
                this.bitField0_ |= 0x40;
                this.onChanged();
            }
            if (!other.warnings_.isEmpty()) {
                if (this.warnings_.isEmpty()) {
                    this.warnings_ = other.warnings_;
                    this.bitField0_ |= 0x80;
                } else {
                    this.ensureWarningsIsMutable();
                    this.warnings_.addAll((Collection)other.warnings_);
                }
                this.onChanged();
            }
            if (other.hasViewport()) {
                this.mergeViewport(other.getViewport());
            }
            if (other.hasTravelAdvisory()) {
                this.mergeTravelAdvisory(other.getTravelAdvisory());
            }
            if (!other.optimizedIntermediateWaypointIndex_.isEmpty()) {
                if (this.optimizedIntermediateWaypointIndex_.isEmpty()) {
                    this.optimizedIntermediateWaypointIndex_ = other.optimizedIntermediateWaypointIndex_;
                    this.bitField0_ &= 0xFFFFFBFF;
                } else {
                    this.ensureOptimizedIntermediateWaypointIndexIsMutable();
                    this.optimizedIntermediateWaypointIndex_.addAll((Collection)other.optimizedIntermediateWaypointIndex_);
                }
                this.onChanged();
            }
            if (other.hasLocalizedValues()) {
                this.mergeLocalizedValues(other.getLocalizedValues());
            }
            if (!other.getRouteToken().isEmpty()) {
                this.routeToken_ = other.routeToken_;
                this.bitField0_ |= 0x1000;
                this.onChanged();
            }
            this.mergeUnknownFields(other.getUnknownFields());
            this.onChanged();
            return this;
        }

        public final boolean isInitialized() {
            return true;
        }

        public Builder mergeFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            if (extensionRegistry == null) {
                throw new NullPointerException();
            }
            try {
                boolean done = false;
                block23: while (!done) {
                    int tag = input.readTag();
                    switch (tag) {
                        case 0: {
                            done = true;
                            continue block23;
                        }
                        case 10: {
                            RouteLeg m = (RouteLeg)input.readMessage(RouteLeg.parser(), extensionRegistry);
                            if (this.legsBuilder_ == null) {
                                this.ensureLegsIsMutable();
                                this.legs_.add(m);
                                continue block23;
                            }
                            this.legsBuilder_.addMessage((AbstractMessage)m);
                            continue block23;
                        }
                        case 16: {
                            this.distanceMeters_ = input.readInt32();
                            this.bitField0_ |= 4;
                            continue block23;
                        }
                        case 26: {
                            input.readMessage((MessageLite.Builder)this.getDurationFieldBuilder().getBuilder(), extensionRegistry);
                            this.bitField0_ |= 8;
                            continue block23;
                        }
                        case 34: {
                            input.readMessage((MessageLite.Builder)this.getStaticDurationFieldBuilder().getBuilder(), extensionRegistry);
                            this.bitField0_ |= 0x10;
                            continue block23;
                        }
                        case 42: {
                            input.readMessage((MessageLite.Builder)this.getPolylineFieldBuilder().getBuilder(), extensionRegistry);
                            this.bitField0_ |= 0x20;
                            continue block23;
                        }
                        case 50: {
                            this.description_ = input.readStringRequireUtf8();
                            this.bitField0_ |= 0x40;
                            continue block23;
                        }
                        case 58: {
                            String s = input.readStringRequireUtf8();
                            this.ensureWarningsIsMutable();
                            this.warnings_.add((Object)s);
                            continue block23;
                        }
                        case 66: {
                            input.readMessage((MessageLite.Builder)this.getViewportFieldBuilder().getBuilder(), extensionRegistry);
                            this.bitField0_ |= 0x100;
                            continue block23;
                        }
                        case 74: {
                            input.readMessage((MessageLite.Builder)this.getTravelAdvisoryFieldBuilder().getBuilder(), extensionRegistry);
                            this.bitField0_ |= 0x200;
                            continue block23;
                        }
                        case 80: {
                            int v = input.readInt32();
                            this.ensureOptimizedIntermediateWaypointIndexIsMutable();
                            this.optimizedIntermediateWaypointIndex_.addInt(v);
                            continue block23;
                        }
                        case 82: {
                            int length = input.readRawVarint32();
                            int limit = input.pushLimit(length);
                            this.ensureOptimizedIntermediateWaypointIndexIsMutable();
                            while (input.getBytesUntilLimit() > 0) {
                                this.optimizedIntermediateWaypointIndex_.addInt(input.readInt32());
                            }
                            input.popLimit(limit);
                            continue block23;
                        }
                        case 90: {
                            input.readMessage((MessageLite.Builder)this.getLocalizedValuesFieldBuilder().getBuilder(), extensionRegistry);
                            this.bitField0_ |= 0x800;
                            continue block23;
                        }
                        case 98: {
                            this.routeToken_ = input.readStringRequireUtf8();
                            this.bitField0_ |= 0x1000;
                            continue block23;
                        }
                        case 104: {
                            int tmpRaw = input.readEnum();
                            this.ensureRouteLabelsIsMutable();
                            this.routeLabels_.add(tmpRaw);
                            continue block23;
                        }
                        case 106: {
                            int length = input.readRawVarint32();
                            int oldLimit = input.pushLimit(length);
                            while (input.getBytesUntilLimit() > 0) {
                                int tmpRaw = input.readEnum();
                                this.ensureRouteLabelsIsMutable();
                                this.routeLabels_.add(tmpRaw);
                            }
                            input.popLimit(oldLimit);
                            continue block23;
                        }
                    }
                    if (super.parseUnknownField(input, extensionRegistry, tag)) continue;
                    done = true;
                }
            }
            catch (InvalidProtocolBufferException e) {
                throw e.unwrapIOException();
            }
            finally {
                this.onChanged();
            }
            return this;
        }

        private void ensureRouteLabelsIsMutable() {
            if ((this.bitField0_ & 1) == 0) {
                this.routeLabels_ = new ArrayList<Integer>(this.routeLabels_);
                this.bitField0_ |= 1;
            }
        }

        @Override
        public List<RouteLabel> getRouteLabelsList() {
            return new Internal.ListAdapter(this.routeLabels_, routeLabels_converter_);
        }

        @Override
        public int getRouteLabelsCount() {
            return this.routeLabels_.size();
        }

        @Override
        public RouteLabel getRouteLabels(int index) {
            return (RouteLabel)((Object)routeLabels_converter_.convert((Object)this.routeLabels_.get(index)));
        }

        public Builder setRouteLabels(int index, RouteLabel value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.ensureRouteLabelsIsMutable();
            this.routeLabels_.set(index, value.getNumber());
            this.onChanged();
            return this;
        }

        public Builder addRouteLabels(RouteLabel value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.ensureRouteLabelsIsMutable();
            this.routeLabels_.add(value.getNumber());
            this.onChanged();
            return this;
        }

        public Builder addAllRouteLabels(Iterable<? extends RouteLabel> values) {
            this.ensureRouteLabelsIsMutable();
            for (RouteLabel routeLabel : values) {
                this.routeLabels_.add(routeLabel.getNumber());
            }
            this.onChanged();
            return this;
        }

        public Builder clearRouteLabels() {
            this.routeLabels_ = Collections.emptyList();
            this.bitField0_ &= 0xFFFFFFFE;
            this.onChanged();
            return this;
        }

        @Override
        public List<Integer> getRouteLabelsValueList() {
            return Collections.unmodifiableList(this.routeLabels_);
        }

        @Override
        public int getRouteLabelsValue(int index) {
            return this.routeLabels_.get(index);
        }

        public Builder setRouteLabelsValue(int index, int value) {
            this.ensureRouteLabelsIsMutable();
            this.routeLabels_.set(index, value);
            this.onChanged();
            return this;
        }

        public Builder addRouteLabelsValue(int value) {
            this.ensureRouteLabelsIsMutable();
            this.routeLabels_.add(value);
            this.onChanged();
            return this;
        }

        public Builder addAllRouteLabelsValue(Iterable<Integer> values) {
            this.ensureRouteLabelsIsMutable();
            for (int value : values) {
                this.routeLabels_.add(value);
            }
            this.onChanged();
            return this;
        }

        private void ensureLegsIsMutable() {
            if ((this.bitField0_ & 2) == 0) {
                this.legs_ = new ArrayList<RouteLeg>(this.legs_);
                this.bitField0_ |= 2;
            }
        }

        @Override
        public List<RouteLeg> getLegsList() {
            if (this.legsBuilder_ == null) {
                return Collections.unmodifiableList(this.legs_);
            }
            return this.legsBuilder_.getMessageList();
        }

        @Override
        public int getLegsCount() {
            if (this.legsBuilder_ == null) {
                return this.legs_.size();
            }
            return this.legsBuilder_.getCount();
        }

        @Override
        public RouteLeg getLegs(int index) {
            if (this.legsBuilder_ == null) {
                return this.legs_.get(index);
            }
            return (RouteLeg)this.legsBuilder_.getMessage(index);
        }

        public Builder setLegs(int index, RouteLeg value) {
            if (this.legsBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureLegsIsMutable();
                this.legs_.set(index, value);
                this.onChanged();
            } else {
                this.legsBuilder_.setMessage(index, (AbstractMessage)value);
            }
            return this;
        }

        public Builder setLegs(int index, RouteLeg.Builder builderForValue) {
            if (this.legsBuilder_ == null) {
                this.ensureLegsIsMutable();
                this.legs_.set(index, builderForValue.build());
                this.onChanged();
            } else {
                this.legsBuilder_.setMessage(index, (AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addLegs(RouteLeg value) {
            if (this.legsBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureLegsIsMutable();
                this.legs_.add(value);
                this.onChanged();
            } else {
                this.legsBuilder_.addMessage((AbstractMessage)value);
            }
            return this;
        }

        public Builder addLegs(int index, RouteLeg value) {
            if (this.legsBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureLegsIsMutable();
                this.legs_.add(index, value);
                this.onChanged();
            } else {
                this.legsBuilder_.addMessage(index, (AbstractMessage)value);
            }
            return this;
        }

        public Builder addLegs(RouteLeg.Builder builderForValue) {
            if (this.legsBuilder_ == null) {
                this.ensureLegsIsMutable();
                this.legs_.add(builderForValue.build());
                this.onChanged();
            } else {
                this.legsBuilder_.addMessage((AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addLegs(int index, RouteLeg.Builder builderForValue) {
            if (this.legsBuilder_ == null) {
                this.ensureLegsIsMutable();
                this.legs_.add(index, builderForValue.build());
                this.onChanged();
            } else {
                this.legsBuilder_.addMessage(index, (AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addAllLegs(Iterable<? extends RouteLeg> values) {
            if (this.legsBuilder_ == null) {
                this.ensureLegsIsMutable();
                AbstractMessageLite.Builder.addAll(values, this.legs_);
                this.onChanged();
            } else {
                this.legsBuilder_.addAllMessages(values);
            }
            return this;
        }

        public Builder clearLegs() {
            if (this.legsBuilder_ == null) {
                this.legs_ = Collections.emptyList();
                this.bitField0_ &= 0xFFFFFFFD;
                this.onChanged();
            } else {
                this.legsBuilder_.clear();
            }
            return this;
        }

        public Builder removeLegs(int index) {
            if (this.legsBuilder_ == null) {
                this.ensureLegsIsMutable();
                this.legs_.remove(index);
                this.onChanged();
            } else {
                this.legsBuilder_.remove(index);
            }
            return this;
        }

        public RouteLeg.Builder getLegsBuilder(int index) {
            return (RouteLeg.Builder)this.getLegsFieldBuilder().getBuilder(index);
        }

        @Override
        public RouteLegOrBuilder getLegsOrBuilder(int index) {
            if (this.legsBuilder_ == null) {
                return this.legs_.get(index);
            }
            return (RouteLegOrBuilder)this.legsBuilder_.getMessageOrBuilder(index);
        }

        @Override
        public List<? extends RouteLegOrBuilder> getLegsOrBuilderList() {
            if (this.legsBuilder_ != null) {
                return this.legsBuilder_.getMessageOrBuilderList();
            }
            return Collections.unmodifiableList(this.legs_);
        }

        public RouteLeg.Builder addLegsBuilder() {
            return (RouteLeg.Builder)this.getLegsFieldBuilder().addBuilder((AbstractMessage)RouteLeg.getDefaultInstance());
        }

        public RouteLeg.Builder addLegsBuilder(int index) {
            return (RouteLeg.Builder)this.getLegsFieldBuilder().addBuilder(index, (AbstractMessage)RouteLeg.getDefaultInstance());
        }

        public List<RouteLeg.Builder> getLegsBuilderList() {
            return this.getLegsFieldBuilder().getBuilderList();
        }

        private RepeatedFieldBuilderV3<RouteLeg, RouteLeg.Builder, RouteLegOrBuilder> getLegsFieldBuilder() {
            if (this.legsBuilder_ == null) {
                this.legsBuilder_ = new RepeatedFieldBuilderV3(this.legs_, (this.bitField0_ & 2) != 0, (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.legs_ = null;
            }
            return this.legsBuilder_;
        }

        @Override
        public int getDistanceMeters() {
            return this.distanceMeters_;
        }

        public Builder setDistanceMeters(int value) {
            this.distanceMeters_ = value;
            this.bitField0_ |= 4;
            this.onChanged();
            return this;
        }

        public Builder clearDistanceMeters() {
            this.bitField0_ &= 0xFFFFFFFB;
            this.distanceMeters_ = 0;
            this.onChanged();
            return this;
        }

        @Override
        public boolean hasDuration() {
            return (this.bitField0_ & 8) != 0;
        }

        @Override
        public Duration getDuration() {
            if (this.durationBuilder_ == null) {
                return this.duration_ == null ? Duration.getDefaultInstance() : this.duration_;
            }
            return (Duration)this.durationBuilder_.getMessage();
        }

        public Builder setDuration(Duration value) {
            if (this.durationBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.duration_ = value;
            } else {
                this.durationBuilder_.setMessage((AbstractMessage)value);
            }
            this.bitField0_ |= 8;
            this.onChanged();
            return this;
        }

        public Builder setDuration(Duration.Builder builderForValue) {
            if (this.durationBuilder_ == null) {
                this.duration_ = builderForValue.build();
            } else {
                this.durationBuilder_.setMessage((AbstractMessage)builderForValue.build());
            }
            this.bitField0_ |= 8;
            this.onChanged();
            return this;
        }

        public Builder mergeDuration(Duration value) {
            if (this.durationBuilder_ == null) {
                if ((this.bitField0_ & 8) != 0 && this.duration_ != null && this.duration_ != Duration.getDefaultInstance()) {
                    this.getDurationBuilder().mergeFrom(value);
                } else {
                    this.duration_ = value;
                }
            } else {
                this.durationBuilder_.mergeFrom((AbstractMessage)value);
            }
            this.bitField0_ |= 8;
            this.onChanged();
            return this;
        }

        public Builder clearDuration() {
            this.bitField0_ &= 0xFFFFFFF7;
            this.duration_ = null;
            if (this.durationBuilder_ != null) {
                this.durationBuilder_.dispose();
                this.durationBuilder_ = null;
            }
            this.onChanged();
            return this;
        }

        public Duration.Builder getDurationBuilder() {
            this.bitField0_ |= 8;
            this.onChanged();
            return (Duration.Builder)this.getDurationFieldBuilder().getBuilder();
        }

        @Override
        public DurationOrBuilder getDurationOrBuilder() {
            if (this.durationBuilder_ != null) {
                return (DurationOrBuilder)this.durationBuilder_.getMessageOrBuilder();
            }
            return this.duration_ == null ? Duration.getDefaultInstance() : this.duration_;
        }

        private SingleFieldBuilderV3<Duration, Duration.Builder, DurationOrBuilder> getDurationFieldBuilder() {
            if (this.durationBuilder_ == null) {
                this.durationBuilder_ = new SingleFieldBuilderV3((AbstractMessage)this.getDuration(), (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.duration_ = null;
            }
            return this.durationBuilder_;
        }

        @Override
        public boolean hasStaticDuration() {
            return (this.bitField0_ & 0x10) != 0;
        }

        @Override
        public Duration getStaticDuration() {
            if (this.staticDurationBuilder_ == null) {
                return this.staticDuration_ == null ? Duration.getDefaultInstance() : this.staticDuration_;
            }
            return (Duration)this.staticDurationBuilder_.getMessage();
        }

        public Builder setStaticDuration(Duration value) {
            if (this.staticDurationBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.staticDuration_ = value;
            } else {
                this.staticDurationBuilder_.setMessage((AbstractMessage)value);
            }
            this.bitField0_ |= 0x10;
            this.onChanged();
            return this;
        }

        public Builder setStaticDuration(Duration.Builder builderForValue) {
            if (this.staticDurationBuilder_ == null) {
                this.staticDuration_ = builderForValue.build();
            } else {
                this.staticDurationBuilder_.setMessage((AbstractMessage)builderForValue.build());
            }
            this.bitField0_ |= 0x10;
            this.onChanged();
            return this;
        }

        public Builder mergeStaticDuration(Duration value) {
            if (this.staticDurationBuilder_ == null) {
                if ((this.bitField0_ & 0x10) != 0 && this.staticDuration_ != null && this.staticDuration_ != Duration.getDefaultInstance()) {
                    this.getStaticDurationBuilder().mergeFrom(value);
                } else {
                    this.staticDuration_ = value;
                }
            } else {
                this.staticDurationBuilder_.mergeFrom((AbstractMessage)value);
            }
            this.bitField0_ |= 0x10;
            this.onChanged();
            return this;
        }

        public Builder clearStaticDuration() {
            this.bitField0_ &= 0xFFFFFFEF;
            this.staticDuration_ = null;
            if (this.staticDurationBuilder_ != null) {
                this.staticDurationBuilder_.dispose();
                this.staticDurationBuilder_ = null;
            }
            this.onChanged();
            return this;
        }

        public Duration.Builder getStaticDurationBuilder() {
            this.bitField0_ |= 0x10;
            this.onChanged();
            return (Duration.Builder)this.getStaticDurationFieldBuilder().getBuilder();
        }

        @Override
        public DurationOrBuilder getStaticDurationOrBuilder() {
            if (this.staticDurationBuilder_ != null) {
                return (DurationOrBuilder)this.staticDurationBuilder_.getMessageOrBuilder();
            }
            return this.staticDuration_ == null ? Duration.getDefaultInstance() : this.staticDuration_;
        }

        private SingleFieldBuilderV3<Duration, Duration.Builder, DurationOrBuilder> getStaticDurationFieldBuilder() {
            if (this.staticDurationBuilder_ == null) {
                this.staticDurationBuilder_ = new SingleFieldBuilderV3((AbstractMessage)this.getStaticDuration(), (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.staticDuration_ = null;
            }
            return this.staticDurationBuilder_;
        }

        @Override
        public boolean hasPolyline() {
            return (this.bitField0_ & 0x20) != 0;
        }

        @Override
        public Polyline getPolyline() {
            if (this.polylineBuilder_ == null) {
                return this.polyline_ == null ? Polyline.getDefaultInstance() : this.polyline_;
            }
            return (Polyline)this.polylineBuilder_.getMessage();
        }

        public Builder setPolyline(Polyline value) {
            if (this.polylineBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.polyline_ = value;
            } else {
                this.polylineBuilder_.setMessage((AbstractMessage)value);
            }
            this.bitField0_ |= 0x20;
            this.onChanged();
            return this;
        }

        public Builder setPolyline(Polyline.Builder builderForValue) {
            if (this.polylineBuilder_ == null) {
                this.polyline_ = builderForValue.build();
            } else {
                this.polylineBuilder_.setMessage((AbstractMessage)builderForValue.build());
            }
            this.bitField0_ |= 0x20;
            this.onChanged();
            return this;
        }

        public Builder mergePolyline(Polyline value) {
            if (this.polylineBuilder_ == null) {
                if ((this.bitField0_ & 0x20) != 0 && this.polyline_ != null && this.polyline_ != Polyline.getDefaultInstance()) {
                    this.getPolylineBuilder().mergeFrom(value);
                } else {
                    this.polyline_ = value;
                }
            } else {
                this.polylineBuilder_.mergeFrom((AbstractMessage)value);
            }
            this.bitField0_ |= 0x20;
            this.onChanged();
            return this;
        }

        public Builder clearPolyline() {
            this.bitField0_ &= 0xFFFFFFDF;
            this.polyline_ = null;
            if (this.polylineBuilder_ != null) {
                this.polylineBuilder_.dispose();
                this.polylineBuilder_ = null;
            }
            this.onChanged();
            return this;
        }

        public Polyline.Builder getPolylineBuilder() {
            this.bitField0_ |= 0x20;
            this.onChanged();
            return (Polyline.Builder)this.getPolylineFieldBuilder().getBuilder();
        }

        @Override
        public PolylineOrBuilder getPolylineOrBuilder() {
            if (this.polylineBuilder_ != null) {
                return (PolylineOrBuilder)this.polylineBuilder_.getMessageOrBuilder();
            }
            return this.polyline_ == null ? Polyline.getDefaultInstance() : this.polyline_;
        }

        private SingleFieldBuilderV3<Polyline, Polyline.Builder, PolylineOrBuilder> getPolylineFieldBuilder() {
            if (this.polylineBuilder_ == null) {
                this.polylineBuilder_ = new SingleFieldBuilderV3((AbstractMessage)this.getPolyline(), (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.polyline_ = null;
            }
            return this.polylineBuilder_;
        }

        @Override
        public String getDescription() {
            Object ref = this.description_;
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                this.description_ = s;
                return s;
            }
            return (String)ref;
        }

        @Override
        public ByteString getDescriptionBytes() {
            Object ref = this.description_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.description_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public Builder setDescription(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.description_ = value;
            this.bitField0_ |= 0x40;
            this.onChanged();
            return this;
        }

        public Builder clearDescription() {
            this.description_ = Route.getDefaultInstance().getDescription();
            this.bitField0_ &= 0xFFFFFFBF;
            this.onChanged();
            return this;
        }

        public Builder setDescriptionBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            Route.checkByteStringIsUtf8((ByteString)value);
            this.description_ = value;
            this.bitField0_ |= 0x40;
            this.onChanged();
            return this;
        }

        private void ensureWarningsIsMutable() {
            if (!this.warnings_.isModifiable()) {
                this.warnings_ = new LazyStringArrayList((LazyStringList)this.warnings_);
            }
            this.bitField0_ |= 0x80;
        }

        public ProtocolStringList getWarningsList() {
            this.warnings_.makeImmutable();
            return this.warnings_;
        }

        @Override
        public int getWarningsCount() {
            return this.warnings_.size();
        }

        @Override
        public String getWarnings(int index) {
            return this.warnings_.get(index);
        }

        @Override
        public ByteString getWarningsBytes(int index) {
            return this.warnings_.getByteString(index);
        }

        public Builder setWarnings(int index, String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.ensureWarningsIsMutable();
            this.warnings_.set(index, value);
            this.bitField0_ |= 0x80;
            this.onChanged();
            return this;
        }

        public Builder addWarnings(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.ensureWarningsIsMutable();
            this.warnings_.add((Object)value);
            this.bitField0_ |= 0x80;
            this.onChanged();
            return this;
        }

        public Builder addAllWarnings(Iterable<String> values) {
            this.ensureWarningsIsMutable();
            AbstractMessageLite.Builder.addAll(values, (List)this.warnings_);
            this.bitField0_ |= 0x80;
            this.onChanged();
            return this;
        }

        public Builder clearWarnings() {
            this.warnings_ = LazyStringArrayList.emptyList();
            this.bitField0_ &= 0xFFFFFF7F;
            this.onChanged();
            return this;
        }

        public Builder addWarningsBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            Route.checkByteStringIsUtf8((ByteString)value);
            this.ensureWarningsIsMutable();
            this.warnings_.add(value);
            this.bitField0_ |= 0x80;
            this.onChanged();
            return this;
        }

        @Override
        public boolean hasViewport() {
            return (this.bitField0_ & 0x100) != 0;
        }

        @Override
        public Viewport getViewport() {
            if (this.viewportBuilder_ == null) {
                return this.viewport_ == null ? Viewport.getDefaultInstance() : this.viewport_;
            }
            return (Viewport)this.viewportBuilder_.getMessage();
        }

        public Builder setViewport(Viewport value) {
            if (this.viewportBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.viewport_ = value;
            } else {
                this.viewportBuilder_.setMessage((AbstractMessage)value);
            }
            this.bitField0_ |= 0x100;
            this.onChanged();
            return this;
        }

        public Builder setViewport(Viewport.Builder builderForValue) {
            if (this.viewportBuilder_ == null) {
                this.viewport_ = builderForValue.build();
            } else {
                this.viewportBuilder_.setMessage((AbstractMessage)builderForValue.build());
            }
            this.bitField0_ |= 0x100;
            this.onChanged();
            return this;
        }

        public Builder mergeViewport(Viewport value) {
            if (this.viewportBuilder_ == null) {
                if ((this.bitField0_ & 0x100) != 0 && this.viewport_ != null && this.viewport_ != Viewport.getDefaultInstance()) {
                    this.getViewportBuilder().mergeFrom(value);
                } else {
                    this.viewport_ = value;
                }
            } else {
                this.viewportBuilder_.mergeFrom((AbstractMessage)value);
            }
            this.bitField0_ |= 0x100;
            this.onChanged();
            return this;
        }

        public Builder clearViewport() {
            this.bitField0_ &= 0xFFFFFEFF;
            this.viewport_ = null;
            if (this.viewportBuilder_ != null) {
                this.viewportBuilder_.dispose();
                this.viewportBuilder_ = null;
            }
            this.onChanged();
            return this;
        }

        public Viewport.Builder getViewportBuilder() {
            this.bitField0_ |= 0x100;
            this.onChanged();
            return (Viewport.Builder)this.getViewportFieldBuilder().getBuilder();
        }

        @Override
        public ViewportOrBuilder getViewportOrBuilder() {
            if (this.viewportBuilder_ != null) {
                return (ViewportOrBuilder)this.viewportBuilder_.getMessageOrBuilder();
            }
            return this.viewport_ == null ? Viewport.getDefaultInstance() : this.viewport_;
        }

        private SingleFieldBuilderV3<Viewport, Viewport.Builder, ViewportOrBuilder> getViewportFieldBuilder() {
            if (this.viewportBuilder_ == null) {
                this.viewportBuilder_ = new SingleFieldBuilderV3((AbstractMessage)this.getViewport(), (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.viewport_ = null;
            }
            return this.viewportBuilder_;
        }

        @Override
        public boolean hasTravelAdvisory() {
            return (this.bitField0_ & 0x200) != 0;
        }

        @Override
        public RouteTravelAdvisory getTravelAdvisory() {
            if (this.travelAdvisoryBuilder_ == null) {
                return this.travelAdvisory_ == null ? RouteTravelAdvisory.getDefaultInstance() : this.travelAdvisory_;
            }
            return (RouteTravelAdvisory)this.travelAdvisoryBuilder_.getMessage();
        }

        public Builder setTravelAdvisory(RouteTravelAdvisory value) {
            if (this.travelAdvisoryBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.travelAdvisory_ = value;
            } else {
                this.travelAdvisoryBuilder_.setMessage((AbstractMessage)value);
            }
            this.bitField0_ |= 0x200;
            this.onChanged();
            return this;
        }

        public Builder setTravelAdvisory(RouteTravelAdvisory.Builder builderForValue) {
            if (this.travelAdvisoryBuilder_ == null) {
                this.travelAdvisory_ = builderForValue.build();
            } else {
                this.travelAdvisoryBuilder_.setMessage((AbstractMessage)builderForValue.build());
            }
            this.bitField0_ |= 0x200;
            this.onChanged();
            return this;
        }

        public Builder mergeTravelAdvisory(RouteTravelAdvisory value) {
            if (this.travelAdvisoryBuilder_ == null) {
                if ((this.bitField0_ & 0x200) != 0 && this.travelAdvisory_ != null && this.travelAdvisory_ != RouteTravelAdvisory.getDefaultInstance()) {
                    this.getTravelAdvisoryBuilder().mergeFrom(value);
                } else {
                    this.travelAdvisory_ = value;
                }
            } else {
                this.travelAdvisoryBuilder_.mergeFrom((AbstractMessage)value);
            }
            this.bitField0_ |= 0x200;
            this.onChanged();
            return this;
        }

        public Builder clearTravelAdvisory() {
            this.bitField0_ &= 0xFFFFFDFF;
            this.travelAdvisory_ = null;
            if (this.travelAdvisoryBuilder_ != null) {
                this.travelAdvisoryBuilder_.dispose();
                this.travelAdvisoryBuilder_ = null;
            }
            this.onChanged();
            return this;
        }

        public RouteTravelAdvisory.Builder getTravelAdvisoryBuilder() {
            this.bitField0_ |= 0x200;
            this.onChanged();
            return (RouteTravelAdvisory.Builder)this.getTravelAdvisoryFieldBuilder().getBuilder();
        }

        @Override
        public RouteTravelAdvisoryOrBuilder getTravelAdvisoryOrBuilder() {
            if (this.travelAdvisoryBuilder_ != null) {
                return (RouteTravelAdvisoryOrBuilder)this.travelAdvisoryBuilder_.getMessageOrBuilder();
            }
            return this.travelAdvisory_ == null ? RouteTravelAdvisory.getDefaultInstance() : this.travelAdvisory_;
        }

        private SingleFieldBuilderV3<RouteTravelAdvisory, RouteTravelAdvisory.Builder, RouteTravelAdvisoryOrBuilder> getTravelAdvisoryFieldBuilder() {
            if (this.travelAdvisoryBuilder_ == null) {
                this.travelAdvisoryBuilder_ = new SingleFieldBuilderV3((AbstractMessage)this.getTravelAdvisory(), (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.travelAdvisory_ = null;
            }
            return this.travelAdvisoryBuilder_;
        }

        private void ensureOptimizedIntermediateWaypointIndexIsMutable() {
            if ((this.bitField0_ & 0x400) == 0) {
                this.optimizedIntermediateWaypointIndex_ = Route.mutableCopy((Internal.IntList)this.optimizedIntermediateWaypointIndex_);
                this.bitField0_ |= 0x400;
            }
        }

        @Override
        public List<Integer> getOptimizedIntermediateWaypointIndexList() {
            return (this.bitField0_ & 0x400) != 0 ? Collections.unmodifiableList(this.optimizedIntermediateWaypointIndex_) : this.optimizedIntermediateWaypointIndex_;
        }

        @Override
        public int getOptimizedIntermediateWaypointIndexCount() {
            return this.optimizedIntermediateWaypointIndex_.size();
        }

        @Override
        public int getOptimizedIntermediateWaypointIndex(int index) {
            return this.optimizedIntermediateWaypointIndex_.getInt(index);
        }

        public Builder setOptimizedIntermediateWaypointIndex(int index, int value) {
            this.ensureOptimizedIntermediateWaypointIndexIsMutable();
            this.optimizedIntermediateWaypointIndex_.setInt(index, value);
            this.onChanged();
            return this;
        }

        public Builder addOptimizedIntermediateWaypointIndex(int value) {
            this.ensureOptimizedIntermediateWaypointIndexIsMutable();
            this.optimizedIntermediateWaypointIndex_.addInt(value);
            this.onChanged();
            return this;
        }

        public Builder addAllOptimizedIntermediateWaypointIndex(Iterable<? extends Integer> values) {
            this.ensureOptimizedIntermediateWaypointIndexIsMutable();
            AbstractMessageLite.Builder.addAll(values, (List)this.optimizedIntermediateWaypointIndex_);
            this.onChanged();
            return this;
        }

        public Builder clearOptimizedIntermediateWaypointIndex() {
            this.optimizedIntermediateWaypointIndex_ = Route.emptyIntList();
            this.bitField0_ &= 0xFFFFFBFF;
            this.onChanged();
            return this;
        }

        @Override
        public boolean hasLocalizedValues() {
            return (this.bitField0_ & 0x800) != 0;
        }

        @Override
        public RouteLocalizedValues getLocalizedValues() {
            if (this.localizedValuesBuilder_ == null) {
                return this.localizedValues_ == null ? RouteLocalizedValues.getDefaultInstance() : this.localizedValues_;
            }
            return (RouteLocalizedValues)this.localizedValuesBuilder_.getMessage();
        }

        public Builder setLocalizedValues(RouteLocalizedValues value) {
            if (this.localizedValuesBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.localizedValues_ = value;
            } else {
                this.localizedValuesBuilder_.setMessage((AbstractMessage)value);
            }
            this.bitField0_ |= 0x800;
            this.onChanged();
            return this;
        }

        public Builder setLocalizedValues(RouteLocalizedValues.Builder builderForValue) {
            if (this.localizedValuesBuilder_ == null) {
                this.localizedValues_ = builderForValue.build();
            } else {
                this.localizedValuesBuilder_.setMessage((AbstractMessage)builderForValue.build());
            }
            this.bitField0_ |= 0x800;
            this.onChanged();
            return this;
        }

        public Builder mergeLocalizedValues(RouteLocalizedValues value) {
            if (this.localizedValuesBuilder_ == null) {
                if ((this.bitField0_ & 0x800) != 0 && this.localizedValues_ != null && this.localizedValues_ != RouteLocalizedValues.getDefaultInstance()) {
                    this.getLocalizedValuesBuilder().mergeFrom(value);
                } else {
                    this.localizedValues_ = value;
                }
            } else {
                this.localizedValuesBuilder_.mergeFrom((AbstractMessage)value);
            }
            this.bitField0_ |= 0x800;
            this.onChanged();
            return this;
        }

        public Builder clearLocalizedValues() {
            this.bitField0_ &= 0xFFFFF7FF;
            this.localizedValues_ = null;
            if (this.localizedValuesBuilder_ != null) {
                this.localizedValuesBuilder_.dispose();
                this.localizedValuesBuilder_ = null;
            }
            this.onChanged();
            return this;
        }

        public RouteLocalizedValues.Builder getLocalizedValuesBuilder() {
            this.bitField0_ |= 0x800;
            this.onChanged();
            return (RouteLocalizedValues.Builder)this.getLocalizedValuesFieldBuilder().getBuilder();
        }

        @Override
        public RouteLocalizedValuesOrBuilder getLocalizedValuesOrBuilder() {
            if (this.localizedValuesBuilder_ != null) {
                return (RouteLocalizedValuesOrBuilder)this.localizedValuesBuilder_.getMessageOrBuilder();
            }
            return this.localizedValues_ == null ? RouteLocalizedValues.getDefaultInstance() : this.localizedValues_;
        }

        private SingleFieldBuilderV3<RouteLocalizedValues, RouteLocalizedValues.Builder, RouteLocalizedValuesOrBuilder> getLocalizedValuesFieldBuilder() {
            if (this.localizedValuesBuilder_ == null) {
                this.localizedValuesBuilder_ = new SingleFieldBuilderV3((AbstractMessage)this.getLocalizedValues(), (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.localizedValues_ = null;
            }
            return this.localizedValuesBuilder_;
        }

        @Override
        public String getRouteToken() {
            Object ref = this.routeToken_;
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                this.routeToken_ = s;
                return s;
            }
            return (String)ref;
        }

        @Override
        public ByteString getRouteTokenBytes() {
            Object ref = this.routeToken_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.routeToken_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public Builder setRouteToken(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.routeToken_ = value;
            this.bitField0_ |= 0x1000;
            this.onChanged();
            return this;
        }

        public Builder clearRouteToken() {
            this.routeToken_ = Route.getDefaultInstance().getRouteToken();
            this.bitField0_ &= 0xFFFFEFFF;
            this.onChanged();
            return this;
        }

        public Builder setRouteTokenBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            Route.checkByteStringIsUtf8((ByteString)value);
            this.routeToken_ = value;
            this.bitField0_ |= 0x1000;
            this.onChanged();
            return this;
        }

        public final Builder setUnknownFields(UnknownFieldSet unknownFields) {
            return (Builder)super.setUnknownFields(unknownFields);
        }

        public final Builder mergeUnknownFields(UnknownFieldSet unknownFields) {
            return (Builder)super.mergeUnknownFields(unknownFields);
        }
    }

    public static final class RouteLocalizedValues
    extends GeneratedMessageV3
    implements RouteLocalizedValuesOrBuilder {
        private static final long serialVersionUID = 0L;
        public static final int DISTANCE_FIELD_NUMBER = 1;
        private LocalizedText distance_;
        public static final int DURATION_FIELD_NUMBER = 2;
        private LocalizedText duration_;
        public static final int STATIC_DURATION_FIELD_NUMBER = 3;
        private LocalizedText staticDuration_;
        public static final int TRANSIT_FARE_FIELD_NUMBER = 4;
        private LocalizedText transitFare_;
        private byte memoizedIsInitialized = (byte)-1;
        private static final RouteLocalizedValues DEFAULT_INSTANCE = new RouteLocalizedValues();
        private static final Parser<RouteLocalizedValues> PARSER = new AbstractParser<RouteLocalizedValues>(){

            public RouteLocalizedValues parsePartialFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
                Builder builder = RouteLocalizedValues.newBuilder();
                try {
                    builder.mergeFrom(input, extensionRegistry);
                }
                catch (InvalidProtocolBufferException e) {
                    throw e.setUnfinishedMessage((MessageLite)builder.buildPartial());
                }
                catch (UninitializedMessageException e) {
                    throw e.asInvalidProtocolBufferException().setUnfinishedMessage((MessageLite)builder.buildPartial());
                }
                catch (IOException e) {
                    throw new InvalidProtocolBufferException(e).setUnfinishedMessage((MessageLite)builder.buildPartial());
                }
                return builder.buildPartial();
            }
        };

        private RouteLocalizedValues(GeneratedMessageV3.Builder<?> builder) {
            super(builder);
        }

        private RouteLocalizedValues() {
        }

        protected Object newInstance(GeneratedMessageV3.UnusedPrivateParameter unused) {
            return new RouteLocalizedValues();
        }

        public static final Descriptors.Descriptor getDescriptor() {
            return RouteProto.internal_static_google_maps_routing_v2_Route_RouteLocalizedValues_descriptor;
        }

        protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
            return RouteProto.internal_static_google_maps_routing_v2_Route_RouteLocalizedValues_fieldAccessorTable.ensureFieldAccessorsInitialized(RouteLocalizedValues.class, Builder.class);
        }

        @Override
        public boolean hasDistance() {
            return this.distance_ != null;
        }

        @Override
        public LocalizedText getDistance() {
            return this.distance_ == null ? LocalizedText.getDefaultInstance() : this.distance_;
        }

        @Override
        public LocalizedTextOrBuilder getDistanceOrBuilder() {
            return this.distance_ == null ? LocalizedText.getDefaultInstance() : this.distance_;
        }

        @Override
        public boolean hasDuration() {
            return this.duration_ != null;
        }

        @Override
        public LocalizedText getDuration() {
            return this.duration_ == null ? LocalizedText.getDefaultInstance() : this.duration_;
        }

        @Override
        public LocalizedTextOrBuilder getDurationOrBuilder() {
            return this.duration_ == null ? LocalizedText.getDefaultInstance() : this.duration_;
        }

        @Override
        public boolean hasStaticDuration() {
            return this.staticDuration_ != null;
        }

        @Override
        public LocalizedText getStaticDuration() {
            return this.staticDuration_ == null ? LocalizedText.getDefaultInstance() : this.staticDuration_;
        }

        @Override
        public LocalizedTextOrBuilder getStaticDurationOrBuilder() {
            return this.staticDuration_ == null ? LocalizedText.getDefaultInstance() : this.staticDuration_;
        }

        @Override
        public boolean hasTransitFare() {
            return this.transitFare_ != null;
        }

        @Override
        public LocalizedText getTransitFare() {
            return this.transitFare_ == null ? LocalizedText.getDefaultInstance() : this.transitFare_;
        }

        @Override
        public LocalizedTextOrBuilder getTransitFareOrBuilder() {
            return this.transitFare_ == null ? LocalizedText.getDefaultInstance() : this.transitFare_;
        }

        public final boolean isInitialized() {
            byte isInitialized = this.memoizedIsInitialized;
            if (isInitialized == 1) {
                return true;
            }
            if (isInitialized == 0) {
                return false;
            }
            this.memoizedIsInitialized = 1;
            return true;
        }

        public void writeTo(CodedOutputStream output) throws IOException {
            if (this.distance_ != null) {
                output.writeMessage(1, (MessageLite)this.getDistance());
            }
            if (this.duration_ != null) {
                output.writeMessage(2, (MessageLite)this.getDuration());
            }
            if (this.staticDuration_ != null) {
                output.writeMessage(3, (MessageLite)this.getStaticDuration());
            }
            if (this.transitFare_ != null) {
                output.writeMessage(4, (MessageLite)this.getTransitFare());
            }
            this.getUnknownFields().writeTo(output);
        }

        public int getSerializedSize() {
            int size = this.memoizedSize;
            if (size != -1) {
                return size;
            }
            size = 0;
            if (this.distance_ != null) {
                size += CodedOutputStream.computeMessageSize((int)1, (MessageLite)this.getDistance());
            }
            if (this.duration_ != null) {
                size += CodedOutputStream.computeMessageSize((int)2, (MessageLite)this.getDuration());
            }
            if (this.staticDuration_ != null) {
                size += CodedOutputStream.computeMessageSize((int)3, (MessageLite)this.getStaticDuration());
            }
            if (this.transitFare_ != null) {
                size += CodedOutputStream.computeMessageSize((int)4, (MessageLite)this.getTransitFare());
            }
            this.memoizedSize = size += this.getUnknownFields().getSerializedSize();
            return size;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof RouteLocalizedValues)) {
                return super.equals(obj);
            }
            RouteLocalizedValues other = (RouteLocalizedValues)obj;
            if (this.hasDistance() != other.hasDistance()) {
                return false;
            }
            if (this.hasDistance() && !this.getDistance().equals((Object)other.getDistance())) {
                return false;
            }
            if (this.hasDuration() != other.hasDuration()) {
                return false;
            }
            if (this.hasDuration() && !this.getDuration().equals((Object)other.getDuration())) {
                return false;
            }
            if (this.hasStaticDuration() != other.hasStaticDuration()) {
                return false;
            }
            if (this.hasStaticDuration() && !this.getStaticDuration().equals((Object)other.getStaticDuration())) {
                return false;
            }
            if (this.hasTransitFare() != other.hasTransitFare()) {
                return false;
            }
            if (this.hasTransitFare() && !this.getTransitFare().equals((Object)other.getTransitFare())) {
                return false;
            }
            return this.getUnknownFields().equals((Object)other.getUnknownFields());
        }

        public int hashCode() {
            if (this.memoizedHashCode != 0) {
                return this.memoizedHashCode;
            }
            int hash = 41;
            hash = 19 * hash + RouteLocalizedValues.getDescriptor().hashCode();
            if (this.hasDistance()) {
                hash = 37 * hash + 1;
                hash = 53 * hash + this.getDistance().hashCode();
            }
            if (this.hasDuration()) {
                hash = 37 * hash + 2;
                hash = 53 * hash + this.getDuration().hashCode();
            }
            if (this.hasStaticDuration()) {
                hash = 37 * hash + 3;
                hash = 53 * hash + this.getStaticDuration().hashCode();
            }
            if (this.hasTransitFare()) {
                hash = 37 * hash + 4;
                hash = 53 * hash + this.getTransitFare().hashCode();
            }
            this.memoizedHashCode = hash = 29 * hash + this.getUnknownFields().hashCode();
            return hash;
        }

        public static RouteLocalizedValues parseFrom(ByteBuffer data) throws InvalidProtocolBufferException {
            return (RouteLocalizedValues)PARSER.parseFrom(data);
        }

        public static RouteLocalizedValues parseFrom(ByteBuffer data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            return (RouteLocalizedValues)PARSER.parseFrom(data, extensionRegistry);
        }

        public static RouteLocalizedValues parseFrom(ByteString data) throws InvalidProtocolBufferException {
            return (RouteLocalizedValues)PARSER.parseFrom(data);
        }

        public static RouteLocalizedValues parseFrom(ByteString data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            return (RouteLocalizedValues)PARSER.parseFrom(data, extensionRegistry);
        }

        public static RouteLocalizedValues parseFrom(byte[] data) throws InvalidProtocolBufferException {
            return (RouteLocalizedValues)PARSER.parseFrom(data);
        }

        public static RouteLocalizedValues parseFrom(byte[] data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            return (RouteLocalizedValues)PARSER.parseFrom(data, extensionRegistry);
        }

        public static RouteLocalizedValues parseFrom(InputStream input) throws IOException {
            return (RouteLocalizedValues)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input);
        }

        public static RouteLocalizedValues parseFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            return (RouteLocalizedValues)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
        }

        public static RouteLocalizedValues parseDelimitedFrom(InputStream input) throws IOException {
            return (RouteLocalizedValues)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input);
        }

        public static RouteLocalizedValues parseDelimitedFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            return (RouteLocalizedValues)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
        }

        public static RouteLocalizedValues parseFrom(CodedInputStream input) throws IOException {
            return (RouteLocalizedValues)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input);
        }

        public static RouteLocalizedValues parseFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            return (RouteLocalizedValues)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input, (ExtensionRegistryLite)extensionRegistry);
        }

        public Builder newBuilderForType() {
            return RouteLocalizedValues.newBuilder();
        }

        public static Builder newBuilder() {
            return DEFAULT_INSTANCE.toBuilder();
        }

        public static Builder newBuilder(RouteLocalizedValues prototype) {
            return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
        }

        public Builder toBuilder() {
            return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
        }

        protected Builder newBuilderForType(GeneratedMessageV3.BuilderParent parent) {
            Builder builder = new Builder(parent);
            return builder;
        }

        public static RouteLocalizedValues getDefaultInstance() {
            return DEFAULT_INSTANCE;
        }

        public static Parser<RouteLocalizedValues> parser() {
            return PARSER;
        }

        public Parser<RouteLocalizedValues> getParserForType() {
            return PARSER;
        }

        public RouteLocalizedValues getDefaultInstanceForType() {
            return DEFAULT_INSTANCE;
        }

        public static final class Builder
        extends GeneratedMessageV3.Builder<Builder>
        implements RouteLocalizedValuesOrBuilder {
            private int bitField0_;
            private LocalizedText distance_;
            private SingleFieldBuilderV3<LocalizedText, LocalizedText.Builder, LocalizedTextOrBuilder> distanceBuilder_;
            private LocalizedText duration_;
            private SingleFieldBuilderV3<LocalizedText, LocalizedText.Builder, LocalizedTextOrBuilder> durationBuilder_;
            private LocalizedText staticDuration_;
            private SingleFieldBuilderV3<LocalizedText, LocalizedText.Builder, LocalizedTextOrBuilder> staticDurationBuilder_;
            private LocalizedText transitFare_;
            private SingleFieldBuilderV3<LocalizedText, LocalizedText.Builder, LocalizedTextOrBuilder> transitFareBuilder_;

            public static final Descriptors.Descriptor getDescriptor() {
                return RouteProto.internal_static_google_maps_routing_v2_Route_RouteLocalizedValues_descriptor;
            }

            protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
                return RouteProto.internal_static_google_maps_routing_v2_Route_RouteLocalizedValues_fieldAccessorTable.ensureFieldAccessorsInitialized(RouteLocalizedValues.class, Builder.class);
            }

            private Builder() {
            }

            private Builder(GeneratedMessageV3.BuilderParent parent) {
                super(parent);
            }

            public Builder clear() {
                super.clear();
                this.bitField0_ = 0;
                this.distance_ = null;
                if (this.distanceBuilder_ != null) {
                    this.distanceBuilder_.dispose();
                    this.distanceBuilder_ = null;
                }
                this.duration_ = null;
                if (this.durationBuilder_ != null) {
                    this.durationBuilder_.dispose();
                    this.durationBuilder_ = null;
                }
                this.staticDuration_ = null;
                if (this.staticDurationBuilder_ != null) {
                    this.staticDurationBuilder_.dispose();
                    this.staticDurationBuilder_ = null;
                }
                this.transitFare_ = null;
                if (this.transitFareBuilder_ != null) {
                    this.transitFareBuilder_.dispose();
                    this.transitFareBuilder_ = null;
                }
                return this;
            }

            public Descriptors.Descriptor getDescriptorForType() {
                return RouteProto.internal_static_google_maps_routing_v2_Route_RouteLocalizedValues_descriptor;
            }

            public RouteLocalizedValues getDefaultInstanceForType() {
                return RouteLocalizedValues.getDefaultInstance();
            }

            public RouteLocalizedValues build() {
                RouteLocalizedValues result = this.buildPartial();
                if (!result.isInitialized()) {
                    throw Builder.newUninitializedMessageException((Message)result);
                }
                return result;
            }

            public RouteLocalizedValues buildPartial() {
                RouteLocalizedValues result = new RouteLocalizedValues(this);
                if (this.bitField0_ != 0) {
                    this.buildPartial0(result);
                }
                this.onBuilt();
                return result;
            }

            private void buildPartial0(RouteLocalizedValues result) {
                int from_bitField0_ = this.bitField0_;
                if ((from_bitField0_ & 1) != 0) {
                    result.distance_ = this.distanceBuilder_ == null ? this.distance_ : (LocalizedText)this.distanceBuilder_.build();
                }
                if ((from_bitField0_ & 2) != 0) {
                    result.duration_ = this.durationBuilder_ == null ? this.duration_ : (LocalizedText)this.durationBuilder_.build();
                }
                if ((from_bitField0_ & 4) != 0) {
                    result.staticDuration_ = this.staticDurationBuilder_ == null ? this.staticDuration_ : (LocalizedText)this.staticDurationBuilder_.build();
                }
                if ((from_bitField0_ & 8) != 0) {
                    result.transitFare_ = this.transitFareBuilder_ == null ? this.transitFare_ : (LocalizedText)this.transitFareBuilder_.build();
                }
            }

            public Builder clone() {
                return (Builder)super.clone();
            }

            public Builder setField(Descriptors.FieldDescriptor field, Object value) {
                return (Builder)super.setField(field, value);
            }

            public Builder clearField(Descriptors.FieldDescriptor field) {
                return (Builder)super.clearField(field);
            }

            public Builder clearOneof(Descriptors.OneofDescriptor oneof) {
                return (Builder)super.clearOneof(oneof);
            }

            public Builder setRepeatedField(Descriptors.FieldDescriptor field, int index, Object value) {
                return (Builder)super.setRepeatedField(field, index, value);
            }

            public Builder addRepeatedField(Descriptors.FieldDescriptor field, Object value) {
                return (Builder)super.addRepeatedField(field, value);
            }

            public Builder mergeFrom(Message other) {
                if (other instanceof RouteLocalizedValues) {
                    return this.mergeFrom((RouteLocalizedValues)other);
                }
                super.mergeFrom(other);
                return this;
            }

            public Builder mergeFrom(RouteLocalizedValues other) {
                if (other == RouteLocalizedValues.getDefaultInstance()) {
                    return this;
                }
                if (other.hasDistance()) {
                    this.mergeDistance(other.getDistance());
                }
                if (other.hasDuration()) {
                    this.mergeDuration(other.getDuration());
                }
                if (other.hasStaticDuration()) {
                    this.mergeStaticDuration(other.getStaticDuration());
                }
                if (other.hasTransitFare()) {
                    this.mergeTransitFare(other.getTransitFare());
                }
                this.mergeUnknownFields(other.getUnknownFields());
                this.onChanged();
                return this;
            }

            public final boolean isInitialized() {
                return true;
            }

            public Builder mergeFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
                if (extensionRegistry == null) {
                    throw new NullPointerException();
                }
                try {
                    boolean done = false;
                    block12: while (!done) {
                        int tag = input.readTag();
                        switch (tag) {
                            case 0: {
                                done = true;
                                continue block12;
                            }
                            case 10: {
                                input.readMessage((MessageLite.Builder)this.getDistanceFieldBuilder().getBuilder(), extensionRegistry);
                                this.bitField0_ |= 1;
                                continue block12;
                            }
                            case 18: {
                                input.readMessage((MessageLite.Builder)this.getDurationFieldBuilder().getBuilder(), extensionRegistry);
                                this.bitField0_ |= 2;
                                continue block12;
                            }
                            case 26: {
                                input.readMessage((MessageLite.Builder)this.getStaticDurationFieldBuilder().getBuilder(), extensionRegistry);
                                this.bitField0_ |= 4;
                                continue block12;
                            }
                            case 34: {
                                input.readMessage((MessageLite.Builder)this.getTransitFareFieldBuilder().getBuilder(), extensionRegistry);
                                this.bitField0_ |= 8;
                                continue block12;
                            }
                        }
                        if (super.parseUnknownField(input, extensionRegistry, tag)) continue;
                        done = true;
                    }
                }
                catch (InvalidProtocolBufferException e) {
                    throw e.unwrapIOException();
                }
                finally {
                    this.onChanged();
                }
                return this;
            }

            @Override
            public boolean hasDistance() {
                return (this.bitField0_ & 1) != 0;
            }

            @Override
            public LocalizedText getDistance() {
                if (this.distanceBuilder_ == null) {
                    return this.distance_ == null ? LocalizedText.getDefaultInstance() : this.distance_;
                }
                return (LocalizedText)this.distanceBuilder_.getMessage();
            }

            public Builder setDistance(LocalizedText value) {
                if (this.distanceBuilder_ == null) {
                    if (value == null) {
                        throw new NullPointerException();
                    }
                    this.distance_ = value;
                } else {
                    this.distanceBuilder_.setMessage((AbstractMessage)value);
                }
                this.bitField0_ |= 1;
                this.onChanged();
                return this;
            }

            public Builder setDistance(LocalizedText.Builder builderForValue) {
                if (this.distanceBuilder_ == null) {
                    this.distance_ = builderForValue.build();
                } else {
                    this.distanceBuilder_.setMessage((AbstractMessage)builderForValue.build());
                }
                this.bitField0_ |= 1;
                this.onChanged();
                return this;
            }

            public Builder mergeDistance(LocalizedText value) {
                if (this.distanceBuilder_ == null) {
                    if ((this.bitField0_ & 1) != 0 && this.distance_ != null && this.distance_ != LocalizedText.getDefaultInstance()) {
                        this.getDistanceBuilder().mergeFrom(value);
                    } else {
                        this.distance_ = value;
                    }
                } else {
                    this.distanceBuilder_.mergeFrom((AbstractMessage)value);
                }
                this.bitField0_ |= 1;
                this.onChanged();
                return this;
            }

            public Builder clearDistance() {
                this.bitField0_ &= 0xFFFFFFFE;
                this.distance_ = null;
                if (this.distanceBuilder_ != null) {
                    this.distanceBuilder_.dispose();
                    this.distanceBuilder_ = null;
                }
                this.onChanged();
                return this;
            }

            public LocalizedText.Builder getDistanceBuilder() {
                this.bitField0_ |= 1;
                this.onChanged();
                return (LocalizedText.Builder)this.getDistanceFieldBuilder().getBuilder();
            }

            @Override
            public LocalizedTextOrBuilder getDistanceOrBuilder() {
                if (this.distanceBuilder_ != null) {
                    return (LocalizedTextOrBuilder)this.distanceBuilder_.getMessageOrBuilder();
                }
                return this.distance_ == null ? LocalizedText.getDefaultInstance() : this.distance_;
            }

            private SingleFieldBuilderV3<LocalizedText, LocalizedText.Builder, LocalizedTextOrBuilder> getDistanceFieldBuilder() {
                if (this.distanceBuilder_ == null) {
                    this.distanceBuilder_ = new SingleFieldBuilderV3((AbstractMessage)this.getDistance(), (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                    this.distance_ = null;
                }
                return this.distanceBuilder_;
            }

            @Override
            public boolean hasDuration() {
                return (this.bitField0_ & 2) != 0;
            }

            @Override
            public LocalizedText getDuration() {
                if (this.durationBuilder_ == null) {
                    return this.duration_ == null ? LocalizedText.getDefaultInstance() : this.duration_;
                }
                return (LocalizedText)this.durationBuilder_.getMessage();
            }

            public Builder setDuration(LocalizedText value) {
                if (this.durationBuilder_ == null) {
                    if (value == null) {
                        throw new NullPointerException();
                    }
                    this.duration_ = value;
                } else {
                    this.durationBuilder_.setMessage((AbstractMessage)value);
                }
                this.bitField0_ |= 2;
                this.onChanged();
                return this;
            }

            public Builder setDuration(LocalizedText.Builder builderForValue) {
                if (this.durationBuilder_ == null) {
                    this.duration_ = builderForValue.build();
                } else {
                    this.durationBuilder_.setMessage((AbstractMessage)builderForValue.build());
                }
                this.bitField0_ |= 2;
                this.onChanged();
                return this;
            }

            public Builder mergeDuration(LocalizedText value) {
                if (this.durationBuilder_ == null) {
                    if ((this.bitField0_ & 2) != 0 && this.duration_ != null && this.duration_ != LocalizedText.getDefaultInstance()) {
                        this.getDurationBuilder().mergeFrom(value);
                    } else {
                        this.duration_ = value;
                    }
                } else {
                    this.durationBuilder_.mergeFrom((AbstractMessage)value);
                }
                this.bitField0_ |= 2;
                this.onChanged();
                return this;
            }

            public Builder clearDuration() {
                this.bitField0_ &= 0xFFFFFFFD;
                this.duration_ = null;
                if (this.durationBuilder_ != null) {
                    this.durationBuilder_.dispose();
                    this.durationBuilder_ = null;
                }
                this.onChanged();
                return this;
            }

            public LocalizedText.Builder getDurationBuilder() {
                this.bitField0_ |= 2;
                this.onChanged();
                return (LocalizedText.Builder)this.getDurationFieldBuilder().getBuilder();
            }

            @Override
            public LocalizedTextOrBuilder getDurationOrBuilder() {
                if (this.durationBuilder_ != null) {
                    return (LocalizedTextOrBuilder)this.durationBuilder_.getMessageOrBuilder();
                }
                return this.duration_ == null ? LocalizedText.getDefaultInstance() : this.duration_;
            }

            private SingleFieldBuilderV3<LocalizedText, LocalizedText.Builder, LocalizedTextOrBuilder> getDurationFieldBuilder() {
                if (this.durationBuilder_ == null) {
                    this.durationBuilder_ = new SingleFieldBuilderV3((AbstractMessage)this.getDuration(), (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                    this.duration_ = null;
                }
                return this.durationBuilder_;
            }

            @Override
            public boolean hasStaticDuration() {
                return (this.bitField0_ & 4) != 0;
            }

            @Override
            public LocalizedText getStaticDuration() {
                if (this.staticDurationBuilder_ == null) {
                    return this.staticDuration_ == null ? LocalizedText.getDefaultInstance() : this.staticDuration_;
                }
                return (LocalizedText)this.staticDurationBuilder_.getMessage();
            }

            public Builder setStaticDuration(LocalizedText value) {
                if (this.staticDurationBuilder_ == null) {
                    if (value == null) {
                        throw new NullPointerException();
                    }
                    this.staticDuration_ = value;
                } else {
                    this.staticDurationBuilder_.setMessage((AbstractMessage)value);
                }
                this.bitField0_ |= 4;
                this.onChanged();
                return this;
            }

            public Builder setStaticDuration(LocalizedText.Builder builderForValue) {
                if (this.staticDurationBuilder_ == null) {
                    this.staticDuration_ = builderForValue.build();
                } else {
                    this.staticDurationBuilder_.setMessage((AbstractMessage)builderForValue.build());
                }
                this.bitField0_ |= 4;
                this.onChanged();
                return this;
            }

            public Builder mergeStaticDuration(LocalizedText value) {
                if (this.staticDurationBuilder_ == null) {
                    if ((this.bitField0_ & 4) != 0 && this.staticDuration_ != null && this.staticDuration_ != LocalizedText.getDefaultInstance()) {
                        this.getStaticDurationBuilder().mergeFrom(value);
                    } else {
                        this.staticDuration_ = value;
                    }
                } else {
                    this.staticDurationBuilder_.mergeFrom((AbstractMessage)value);
                }
                this.bitField0_ |= 4;
                this.onChanged();
                return this;
            }

            public Builder clearStaticDuration() {
                this.bitField0_ &= 0xFFFFFFFB;
                this.staticDuration_ = null;
                if (this.staticDurationBuilder_ != null) {
                    this.staticDurationBuilder_.dispose();
                    this.staticDurationBuilder_ = null;
                }
                this.onChanged();
                return this;
            }

            public LocalizedText.Builder getStaticDurationBuilder() {
                this.bitField0_ |= 4;
                this.onChanged();
                return (LocalizedText.Builder)this.getStaticDurationFieldBuilder().getBuilder();
            }

            @Override
            public LocalizedTextOrBuilder getStaticDurationOrBuilder() {
                if (this.staticDurationBuilder_ != null) {
                    return (LocalizedTextOrBuilder)this.staticDurationBuilder_.getMessageOrBuilder();
                }
                return this.staticDuration_ == null ? LocalizedText.getDefaultInstance() : this.staticDuration_;
            }

            private SingleFieldBuilderV3<LocalizedText, LocalizedText.Builder, LocalizedTextOrBuilder> getStaticDurationFieldBuilder() {
                if (this.staticDurationBuilder_ == null) {
                    this.staticDurationBuilder_ = new SingleFieldBuilderV3((AbstractMessage)this.getStaticDuration(), (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                    this.staticDuration_ = null;
                }
                return this.staticDurationBuilder_;
            }

            @Override
            public boolean hasTransitFare() {
                return (this.bitField0_ & 8) != 0;
            }

            @Override
            public LocalizedText getTransitFare() {
                if (this.transitFareBuilder_ == null) {
                    return this.transitFare_ == null ? LocalizedText.getDefaultInstance() : this.transitFare_;
                }
                return (LocalizedText)this.transitFareBuilder_.getMessage();
            }

            public Builder setTransitFare(LocalizedText value) {
                if (this.transitFareBuilder_ == null) {
                    if (value == null) {
                        throw new NullPointerException();
                    }
                    this.transitFare_ = value;
                } else {
                    this.transitFareBuilder_.setMessage((AbstractMessage)value);
                }
                this.bitField0_ |= 8;
                this.onChanged();
                return this;
            }

            public Builder setTransitFare(LocalizedText.Builder builderForValue) {
                if (this.transitFareBuilder_ == null) {
                    this.transitFare_ = builderForValue.build();
                } else {
                    this.transitFareBuilder_.setMessage((AbstractMessage)builderForValue.build());
                }
                this.bitField0_ |= 8;
                this.onChanged();
                return this;
            }

            public Builder mergeTransitFare(LocalizedText value) {
                if (this.transitFareBuilder_ == null) {
                    if ((this.bitField0_ & 8) != 0 && this.transitFare_ != null && this.transitFare_ != LocalizedText.getDefaultInstance()) {
                        this.getTransitFareBuilder().mergeFrom(value);
                    } else {
                        this.transitFare_ = value;
                    }
                } else {
                    this.transitFareBuilder_.mergeFrom((AbstractMessage)value);
                }
                this.bitField0_ |= 8;
                this.onChanged();
                return this;
            }

            public Builder clearTransitFare() {
                this.bitField0_ &= 0xFFFFFFF7;
                this.transitFare_ = null;
                if (this.transitFareBuilder_ != null) {
                    this.transitFareBuilder_.dispose();
                    this.transitFareBuilder_ = null;
                }
                this.onChanged();
                return this;
            }

            public LocalizedText.Builder getTransitFareBuilder() {
                this.bitField0_ |= 8;
                this.onChanged();
                return (LocalizedText.Builder)this.getTransitFareFieldBuilder().getBuilder();
            }

            @Override
            public LocalizedTextOrBuilder getTransitFareOrBuilder() {
                if (this.transitFareBuilder_ != null) {
                    return (LocalizedTextOrBuilder)this.transitFareBuilder_.getMessageOrBuilder();
                }
                return this.transitFare_ == null ? LocalizedText.getDefaultInstance() : this.transitFare_;
            }

            private SingleFieldBuilderV3<LocalizedText, LocalizedText.Builder, LocalizedTextOrBuilder> getTransitFareFieldBuilder() {
                if (this.transitFareBuilder_ == null) {
                    this.transitFareBuilder_ = new SingleFieldBuilderV3((AbstractMessage)this.getTransitFare(), (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                    this.transitFare_ = null;
                }
                return this.transitFareBuilder_;
            }

            public final Builder setUnknownFields(UnknownFieldSet unknownFields) {
                return (Builder)super.setUnknownFields(unknownFields);
            }

            public final Builder mergeUnknownFields(UnknownFieldSet unknownFields) {
                return (Builder)super.mergeUnknownFields(unknownFields);
            }
        }
    }

    public static interface RouteLocalizedValuesOrBuilder
    extends MessageOrBuilder {
        public boolean hasDistance();

        public LocalizedText getDistance();

        public LocalizedTextOrBuilder getDistanceOrBuilder();

        public boolean hasDuration();

        public LocalizedText getDuration();

        public LocalizedTextOrBuilder getDurationOrBuilder();

        public boolean hasStaticDuration();

        public LocalizedText getStaticDuration();

        public LocalizedTextOrBuilder getStaticDurationOrBuilder();

        public boolean hasTransitFare();

        public LocalizedText getTransitFare();

        public LocalizedTextOrBuilder getTransitFareOrBuilder();
    }
}

