/*
 * Decompiled with CFR 0.152.
 */
package com.google.maps.routeoptimization.v1;

import com.google.maps.routeoptimization.v1.BreakRule;
import com.google.maps.routeoptimization.v1.BreakRuleOrBuilder;
import com.google.maps.routeoptimization.v1.DistanceLimit;
import com.google.maps.routeoptimization.v1.DistanceLimitOrBuilder;
import com.google.maps.routeoptimization.v1.RouteOptimizationServiceProto;
import com.google.maps.routeoptimization.v1.TimeWindow;
import com.google.maps.routeoptimization.v1.TimeWindowOrBuilder;
import com.google.maps.routeoptimization.v1.VehicleOrBuilder;
import com.google.maps.routeoptimization.v1.Waypoint;
import com.google.maps.routeoptimization.v1.WaypointOrBuilder;
import com.google.protobuf.AbstractMessage;
import com.google.protobuf.AbstractMessageLite;
import com.google.protobuf.AbstractParser;
import com.google.protobuf.ByteString;
import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import com.google.protobuf.Descriptors;
import com.google.protobuf.Duration;
import com.google.protobuf.DurationOrBuilder;
import com.google.protobuf.ExtensionRegistryLite;
import com.google.protobuf.GeneratedMessageV3;
import com.google.protobuf.Internal;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.LazyStringArrayList;
import com.google.protobuf.LazyStringList;
import com.google.protobuf.MapEntry;
import com.google.protobuf.MapField;
import com.google.protobuf.MapFieldBuilder;
import com.google.protobuf.MapFieldReflectionAccessor;
import com.google.protobuf.Message;
import com.google.protobuf.MessageLite;
import com.google.protobuf.MessageOrBuilder;
import com.google.protobuf.Parser;
import com.google.protobuf.ProtocolMessageEnum;
import com.google.protobuf.ProtocolStringList;
import com.google.protobuf.RepeatedFieldBuilderV3;
import com.google.protobuf.SingleFieldBuilderV3;
import com.google.protobuf.UninitializedMessageException;
import com.google.protobuf.UnknownFieldSet;
import com.google.protobuf.WireFormat;
import com.google.type.LatLng;
import com.google.type.LatLngOrBuilder;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public final class Vehicle
extends GeneratedMessageV3
implements VehicleOrBuilder {
    private static final long serialVersionUID = 0L;
    private int bitField0_;
    public static final int DISPLAY_NAME_FIELD_NUMBER = 32;
    private volatile Object displayName_ = "";
    public static final int TRAVEL_MODE_FIELD_NUMBER = 1;
    private int travelMode_ = 0;
    public static final int START_LOCATION_FIELD_NUMBER = 3;
    private LatLng startLocation_;
    public static final int START_WAYPOINT_FIELD_NUMBER = 4;
    private Waypoint startWaypoint_;
    public static final int END_LOCATION_FIELD_NUMBER = 5;
    private LatLng endLocation_;
    public static final int END_WAYPOINT_FIELD_NUMBER = 6;
    private Waypoint endWaypoint_;
    public static final int START_TAGS_FIELD_NUMBER = 7;
    private LazyStringArrayList startTags_ = LazyStringArrayList.emptyList();
    public static final int END_TAGS_FIELD_NUMBER = 8;
    private LazyStringArrayList endTags_ = LazyStringArrayList.emptyList();
    public static final int START_TIME_WINDOWS_FIELD_NUMBER = 9;
    private List<TimeWindow> startTimeWindows_;
    public static final int END_TIME_WINDOWS_FIELD_NUMBER = 10;
    private List<TimeWindow> endTimeWindows_;
    public static final int TRAVEL_DURATION_MULTIPLE_FIELD_NUMBER = 11;
    private double travelDurationMultiple_ = 0.0;
    public static final int UNLOADING_POLICY_FIELD_NUMBER = 12;
    private int unloadingPolicy_ = 0;
    public static final int LOAD_LIMITS_FIELD_NUMBER = 30;
    private MapField<String, LoadLimit> loadLimits_;
    public static final int COST_PER_HOUR_FIELD_NUMBER = 16;
    private double costPerHour_ = 0.0;
    public static final int COST_PER_TRAVELED_HOUR_FIELD_NUMBER = 17;
    private double costPerTraveledHour_ = 0.0;
    public static final int COST_PER_KILOMETER_FIELD_NUMBER = 18;
    private double costPerKilometer_ = 0.0;
    public static final int FIXED_COST_FIELD_NUMBER = 19;
    private double fixedCost_ = 0.0;
    public static final int USED_IF_ROUTE_IS_EMPTY_FIELD_NUMBER = 20;
    private boolean usedIfRouteIsEmpty_ = false;
    public static final int ROUTE_DURATION_LIMIT_FIELD_NUMBER = 21;
    private DurationLimit routeDurationLimit_;
    public static final int TRAVEL_DURATION_LIMIT_FIELD_NUMBER = 22;
    private DurationLimit travelDurationLimit_;
    public static final int ROUTE_DISTANCE_LIMIT_FIELD_NUMBER = 23;
    private DistanceLimit routeDistanceLimit_;
    public static final int EXTRA_VISIT_DURATION_FOR_VISIT_TYPE_FIELD_NUMBER = 24;
    private MapField<String, Duration> extraVisitDurationForVisitType_;
    public static final int BREAK_RULE_FIELD_NUMBER = 25;
    private BreakRule breakRule_;
    public static final int LABEL_FIELD_NUMBER = 27;
    private volatile Object label_ = "";
    public static final int IGNORE_FIELD_NUMBER = 28;
    private boolean ignore_ = false;
    private byte memoizedIsInitialized = (byte)-1;
    private static final Vehicle DEFAULT_INSTANCE = new Vehicle();
    private static final Parser<Vehicle> PARSER = new AbstractParser<Vehicle>(){

        public Vehicle parsePartialFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            Builder builder = Vehicle.newBuilder();
            try {
                builder.mergeFrom(input, extensionRegistry);
            }
            catch (InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage((MessageLite)builder.buildPartial());
            }
            catch (UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException().setUnfinishedMessage((MessageLite)builder.buildPartial());
            }
            catch (IOException e) {
                throw new InvalidProtocolBufferException(e).setUnfinishedMessage((MessageLite)builder.buildPartial());
            }
            return builder.buildPartial();
        }
    };

    private Vehicle(GeneratedMessageV3.Builder<?> builder) {
        super(builder);
    }

    private Vehicle() {
        this.displayName_ = "";
        this.travelMode_ = 0;
        this.startTags_ = LazyStringArrayList.emptyList();
        this.endTags_ = LazyStringArrayList.emptyList();
        this.startTimeWindows_ = Collections.emptyList();
        this.endTimeWindows_ = Collections.emptyList();
        this.unloadingPolicy_ = 0;
        this.label_ = "";
    }

    protected Object newInstance(GeneratedMessageV3.UnusedPrivateParameter unused) {
        return new Vehicle();
    }

    public static final Descriptors.Descriptor getDescriptor() {
        return RouteOptimizationServiceProto.internal_static_google_maps_routeoptimization_v1_Vehicle_descriptor;
    }

    protected MapFieldReflectionAccessor internalGetMapFieldReflection(int number) {
        switch (number) {
            case 30: {
                return this.internalGetLoadLimits();
            }
            case 24: {
                return this.internalGetExtraVisitDurationForVisitType();
            }
        }
        throw new RuntimeException("Invalid map field number: " + number);
    }

    protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
        return RouteOptimizationServiceProto.internal_static_google_maps_routeoptimization_v1_Vehicle_fieldAccessorTable.ensureFieldAccessorsInitialized(Vehicle.class, Builder.class);
    }

    @Override
    public String getDisplayName() {
        Object ref = this.displayName_;
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s = bs.toStringUtf8();
        this.displayName_ = s;
        return s;
    }

    @Override
    public ByteString getDisplayNameBytes() {
        Object ref = this.displayName_;
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)((String)ref));
            this.displayName_ = b;
            return b;
        }
        return (ByteString)ref;
    }

    @Override
    public int getTravelModeValue() {
        return this.travelMode_;
    }

    @Override
    public TravelMode getTravelMode() {
        TravelMode result = TravelMode.forNumber(this.travelMode_);
        return result == null ? TravelMode.UNRECOGNIZED : result;
    }

    @Override
    public boolean hasStartLocation() {
        return (this.bitField0_ & 1) != 0;
    }

    @Override
    public LatLng getStartLocation() {
        return this.startLocation_ == null ? LatLng.getDefaultInstance() : this.startLocation_;
    }

    @Override
    public LatLngOrBuilder getStartLocationOrBuilder() {
        return this.startLocation_ == null ? LatLng.getDefaultInstance() : this.startLocation_;
    }

    @Override
    public boolean hasStartWaypoint() {
        return (this.bitField0_ & 2) != 0;
    }

    @Override
    public Waypoint getStartWaypoint() {
        return this.startWaypoint_ == null ? Waypoint.getDefaultInstance() : this.startWaypoint_;
    }

    @Override
    public WaypointOrBuilder getStartWaypointOrBuilder() {
        return this.startWaypoint_ == null ? Waypoint.getDefaultInstance() : this.startWaypoint_;
    }

    @Override
    public boolean hasEndLocation() {
        return (this.bitField0_ & 4) != 0;
    }

    @Override
    public LatLng getEndLocation() {
        return this.endLocation_ == null ? LatLng.getDefaultInstance() : this.endLocation_;
    }

    @Override
    public LatLngOrBuilder getEndLocationOrBuilder() {
        return this.endLocation_ == null ? LatLng.getDefaultInstance() : this.endLocation_;
    }

    @Override
    public boolean hasEndWaypoint() {
        return (this.bitField0_ & 8) != 0;
    }

    @Override
    public Waypoint getEndWaypoint() {
        return this.endWaypoint_ == null ? Waypoint.getDefaultInstance() : this.endWaypoint_;
    }

    @Override
    public WaypointOrBuilder getEndWaypointOrBuilder() {
        return this.endWaypoint_ == null ? Waypoint.getDefaultInstance() : this.endWaypoint_;
    }

    public ProtocolStringList getStartTagsList() {
        return this.startTags_;
    }

    @Override
    public int getStartTagsCount() {
        return this.startTags_.size();
    }

    @Override
    public String getStartTags(int index) {
        return this.startTags_.get(index);
    }

    @Override
    public ByteString getStartTagsBytes(int index) {
        return this.startTags_.getByteString(index);
    }

    public ProtocolStringList getEndTagsList() {
        return this.endTags_;
    }

    @Override
    public int getEndTagsCount() {
        return this.endTags_.size();
    }

    @Override
    public String getEndTags(int index) {
        return this.endTags_.get(index);
    }

    @Override
    public ByteString getEndTagsBytes(int index) {
        return this.endTags_.getByteString(index);
    }

    @Override
    public List<TimeWindow> getStartTimeWindowsList() {
        return this.startTimeWindows_;
    }

    @Override
    public List<? extends TimeWindowOrBuilder> getStartTimeWindowsOrBuilderList() {
        return this.startTimeWindows_;
    }

    @Override
    public int getStartTimeWindowsCount() {
        return this.startTimeWindows_.size();
    }

    @Override
    public TimeWindow getStartTimeWindows(int index) {
        return this.startTimeWindows_.get(index);
    }

    @Override
    public TimeWindowOrBuilder getStartTimeWindowsOrBuilder(int index) {
        return this.startTimeWindows_.get(index);
    }

    @Override
    public List<TimeWindow> getEndTimeWindowsList() {
        return this.endTimeWindows_;
    }

    @Override
    public List<? extends TimeWindowOrBuilder> getEndTimeWindowsOrBuilderList() {
        return this.endTimeWindows_;
    }

    @Override
    public int getEndTimeWindowsCount() {
        return this.endTimeWindows_.size();
    }

    @Override
    public TimeWindow getEndTimeWindows(int index) {
        return this.endTimeWindows_.get(index);
    }

    @Override
    public TimeWindowOrBuilder getEndTimeWindowsOrBuilder(int index) {
        return this.endTimeWindows_.get(index);
    }

    @Override
    public boolean hasTravelDurationMultiple() {
        return (this.bitField0_ & 0x10) != 0;
    }

    @Override
    public double getTravelDurationMultiple() {
        return this.travelDurationMultiple_;
    }

    @Override
    public int getUnloadingPolicyValue() {
        return this.unloadingPolicy_;
    }

    @Override
    public UnloadingPolicy getUnloadingPolicy() {
        UnloadingPolicy result = UnloadingPolicy.forNumber(this.unloadingPolicy_);
        return result == null ? UnloadingPolicy.UNRECOGNIZED : result;
    }

    private MapField<String, LoadLimit> internalGetLoadLimits() {
        if (this.loadLimits_ == null) {
            return MapField.emptyMapField(LoadLimitsDefaultEntryHolder.defaultEntry);
        }
        return this.loadLimits_;
    }

    @Override
    public int getLoadLimitsCount() {
        return this.internalGetLoadLimits().getMap().size();
    }

    @Override
    public boolean containsLoadLimits(String key) {
        if (key == null) {
            throw new NullPointerException("map key");
        }
        return this.internalGetLoadLimits().getMap().containsKey(key);
    }

    @Override
    @Deprecated
    public Map<String, LoadLimit> getLoadLimits() {
        return this.getLoadLimitsMap();
    }

    @Override
    public Map<String, LoadLimit> getLoadLimitsMap() {
        return this.internalGetLoadLimits().getMap();
    }

    @Override
    public LoadLimit getLoadLimitsOrDefault(String key, LoadLimit defaultValue) {
        if (key == null) {
            throw new NullPointerException("map key");
        }
        Map map = this.internalGetLoadLimits().getMap();
        return map.containsKey(key) ? (LoadLimit)map.get(key) : defaultValue;
    }

    @Override
    public LoadLimit getLoadLimitsOrThrow(String key) {
        if (key == null) {
            throw new NullPointerException("map key");
        }
        Map map = this.internalGetLoadLimits().getMap();
        if (!map.containsKey(key)) {
            throw new IllegalArgumentException();
        }
        return (LoadLimit)map.get(key);
    }

    @Override
    public double getCostPerHour() {
        return this.costPerHour_;
    }

    @Override
    public double getCostPerTraveledHour() {
        return this.costPerTraveledHour_;
    }

    @Override
    public double getCostPerKilometer() {
        return this.costPerKilometer_;
    }

    @Override
    public double getFixedCost() {
        return this.fixedCost_;
    }

    @Override
    public boolean getUsedIfRouteIsEmpty() {
        return this.usedIfRouteIsEmpty_;
    }

    @Override
    public boolean hasRouteDurationLimit() {
        return (this.bitField0_ & 0x20) != 0;
    }

    @Override
    public DurationLimit getRouteDurationLimit() {
        return this.routeDurationLimit_ == null ? DurationLimit.getDefaultInstance() : this.routeDurationLimit_;
    }

    @Override
    public DurationLimitOrBuilder getRouteDurationLimitOrBuilder() {
        return this.routeDurationLimit_ == null ? DurationLimit.getDefaultInstance() : this.routeDurationLimit_;
    }

    @Override
    public boolean hasTravelDurationLimit() {
        return (this.bitField0_ & 0x40) != 0;
    }

    @Override
    public DurationLimit getTravelDurationLimit() {
        return this.travelDurationLimit_ == null ? DurationLimit.getDefaultInstance() : this.travelDurationLimit_;
    }

    @Override
    public DurationLimitOrBuilder getTravelDurationLimitOrBuilder() {
        return this.travelDurationLimit_ == null ? DurationLimit.getDefaultInstance() : this.travelDurationLimit_;
    }

    @Override
    public boolean hasRouteDistanceLimit() {
        return (this.bitField0_ & 0x80) != 0;
    }

    @Override
    public DistanceLimit getRouteDistanceLimit() {
        return this.routeDistanceLimit_ == null ? DistanceLimit.getDefaultInstance() : this.routeDistanceLimit_;
    }

    @Override
    public DistanceLimitOrBuilder getRouteDistanceLimitOrBuilder() {
        return this.routeDistanceLimit_ == null ? DistanceLimit.getDefaultInstance() : this.routeDistanceLimit_;
    }

    private MapField<String, Duration> internalGetExtraVisitDurationForVisitType() {
        if (this.extraVisitDurationForVisitType_ == null) {
            return MapField.emptyMapField(ExtraVisitDurationForVisitTypeDefaultEntryHolder.defaultEntry);
        }
        return this.extraVisitDurationForVisitType_;
    }

    @Override
    public int getExtraVisitDurationForVisitTypeCount() {
        return this.internalGetExtraVisitDurationForVisitType().getMap().size();
    }

    @Override
    public boolean containsExtraVisitDurationForVisitType(String key) {
        if (key == null) {
            throw new NullPointerException("map key");
        }
        return this.internalGetExtraVisitDurationForVisitType().getMap().containsKey(key);
    }

    @Override
    @Deprecated
    public Map<String, Duration> getExtraVisitDurationForVisitType() {
        return this.getExtraVisitDurationForVisitTypeMap();
    }

    @Override
    public Map<String, Duration> getExtraVisitDurationForVisitTypeMap() {
        return this.internalGetExtraVisitDurationForVisitType().getMap();
    }

    @Override
    public Duration getExtraVisitDurationForVisitTypeOrDefault(String key, Duration defaultValue) {
        if (key == null) {
            throw new NullPointerException("map key");
        }
        Map map = this.internalGetExtraVisitDurationForVisitType().getMap();
        return map.containsKey(key) ? (Duration)map.get(key) : defaultValue;
    }

    @Override
    public Duration getExtraVisitDurationForVisitTypeOrThrow(String key) {
        if (key == null) {
            throw new NullPointerException("map key");
        }
        Map map = this.internalGetExtraVisitDurationForVisitType().getMap();
        if (!map.containsKey(key)) {
            throw new IllegalArgumentException();
        }
        return (Duration)map.get(key);
    }

    @Override
    public boolean hasBreakRule() {
        return (this.bitField0_ & 0x100) != 0;
    }

    @Override
    public BreakRule getBreakRule() {
        return this.breakRule_ == null ? BreakRule.getDefaultInstance() : this.breakRule_;
    }

    @Override
    public BreakRuleOrBuilder getBreakRuleOrBuilder() {
        return this.breakRule_ == null ? BreakRule.getDefaultInstance() : this.breakRule_;
    }

    @Override
    public String getLabel() {
        Object ref = this.label_;
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s = bs.toStringUtf8();
        this.label_ = s;
        return s;
    }

    @Override
    public ByteString getLabelBytes() {
        Object ref = this.label_;
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)((String)ref));
            this.label_ = b;
            return b;
        }
        return (ByteString)ref;
    }

    @Override
    public boolean getIgnore() {
        return this.ignore_;
    }

    public final boolean isInitialized() {
        byte isInitialized = this.memoizedIsInitialized;
        if (isInitialized == 1) {
            return true;
        }
        if (isInitialized == 0) {
            return false;
        }
        this.memoizedIsInitialized = 1;
        return true;
    }

    public void writeTo(CodedOutputStream output) throws IOException {
        int i;
        if (this.travelMode_ != TravelMode.TRAVEL_MODE_UNSPECIFIED.getNumber()) {
            output.writeEnum(1, this.travelMode_);
        }
        if ((this.bitField0_ & 1) != 0) {
            output.writeMessage(3, (MessageLite)this.getStartLocation());
        }
        if ((this.bitField0_ & 2) != 0) {
            output.writeMessage(4, (MessageLite)this.getStartWaypoint());
        }
        if ((this.bitField0_ & 4) != 0) {
            output.writeMessage(5, (MessageLite)this.getEndLocation());
        }
        if ((this.bitField0_ & 8) != 0) {
            output.writeMessage(6, (MessageLite)this.getEndWaypoint());
        }
        for (i = 0; i < this.startTags_.size(); ++i) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)7, (Object)this.startTags_.getRaw(i));
        }
        for (i = 0; i < this.endTags_.size(); ++i) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)8, (Object)this.endTags_.getRaw(i));
        }
        for (i = 0; i < this.startTimeWindows_.size(); ++i) {
            output.writeMessage(9, (MessageLite)this.startTimeWindows_.get(i));
        }
        for (i = 0; i < this.endTimeWindows_.size(); ++i) {
            output.writeMessage(10, (MessageLite)this.endTimeWindows_.get(i));
        }
        if ((this.bitField0_ & 0x10) != 0) {
            output.writeDouble(11, this.travelDurationMultiple_);
        }
        if (this.unloadingPolicy_ != UnloadingPolicy.UNLOADING_POLICY_UNSPECIFIED.getNumber()) {
            output.writeEnum(12, this.unloadingPolicy_);
        }
        if (Double.doubleToRawLongBits(this.costPerHour_) != 0L) {
            output.writeDouble(16, this.costPerHour_);
        }
        if (Double.doubleToRawLongBits(this.costPerTraveledHour_) != 0L) {
            output.writeDouble(17, this.costPerTraveledHour_);
        }
        if (Double.doubleToRawLongBits(this.costPerKilometer_) != 0L) {
            output.writeDouble(18, this.costPerKilometer_);
        }
        if (Double.doubleToRawLongBits(this.fixedCost_) != 0L) {
            output.writeDouble(19, this.fixedCost_);
        }
        if (this.usedIfRouteIsEmpty_) {
            output.writeBool(20, this.usedIfRouteIsEmpty_);
        }
        if ((this.bitField0_ & 0x20) != 0) {
            output.writeMessage(21, (MessageLite)this.getRouteDurationLimit());
        }
        if ((this.bitField0_ & 0x40) != 0) {
            output.writeMessage(22, (MessageLite)this.getTravelDurationLimit());
        }
        if ((this.bitField0_ & 0x80) != 0) {
            output.writeMessage(23, (MessageLite)this.getRouteDistanceLimit());
        }
        GeneratedMessageV3.serializeStringMapTo((CodedOutputStream)output, this.internalGetExtraVisitDurationForVisitType(), ExtraVisitDurationForVisitTypeDefaultEntryHolder.defaultEntry, (int)24);
        if ((this.bitField0_ & 0x100) != 0) {
            output.writeMessage(25, (MessageLite)this.getBreakRule());
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.label_)) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)27, (Object)this.label_);
        }
        if (this.ignore_) {
            output.writeBool(28, this.ignore_);
        }
        GeneratedMessageV3.serializeStringMapTo((CodedOutputStream)output, this.internalGetLoadLimits(), LoadLimitsDefaultEntryHolder.defaultEntry, (int)30);
        if (!GeneratedMessageV3.isStringEmpty((Object)this.displayName_)) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)32, (Object)this.displayName_);
        }
        this.getUnknownFields().writeTo(output);
    }

    public int getSerializedSize() {
        int i;
        int i2;
        int size = this.memoizedSize;
        if (size != -1) {
            return size;
        }
        size = 0;
        if (this.travelMode_ != TravelMode.TRAVEL_MODE_UNSPECIFIED.getNumber()) {
            size += CodedOutputStream.computeEnumSize((int)1, (int)this.travelMode_);
        }
        if ((this.bitField0_ & 1) != 0) {
            size += CodedOutputStream.computeMessageSize((int)3, (MessageLite)this.getStartLocation());
        }
        if ((this.bitField0_ & 2) != 0) {
            size += CodedOutputStream.computeMessageSize((int)4, (MessageLite)this.getStartWaypoint());
        }
        if ((this.bitField0_ & 4) != 0) {
            size += CodedOutputStream.computeMessageSize((int)5, (MessageLite)this.getEndLocation());
        }
        if ((this.bitField0_ & 8) != 0) {
            size += CodedOutputStream.computeMessageSize((int)6, (MessageLite)this.getEndWaypoint());
        }
        int dataSize = 0;
        for (i2 = 0; i2 < this.startTags_.size(); ++i2) {
            dataSize += Vehicle.computeStringSizeNoTag((Object)this.startTags_.getRaw(i2));
        }
        size += dataSize;
        size += 1 * this.getStartTagsList().size();
        dataSize = 0;
        for (i2 = 0; i2 < this.endTags_.size(); ++i2) {
            dataSize += Vehicle.computeStringSizeNoTag((Object)this.endTags_.getRaw(i2));
        }
        size += dataSize;
        size += 1 * this.getEndTagsList().size();
        for (i = 0; i < this.startTimeWindows_.size(); ++i) {
            size += CodedOutputStream.computeMessageSize((int)9, (MessageLite)((MessageLite)this.startTimeWindows_.get(i)));
        }
        for (i = 0; i < this.endTimeWindows_.size(); ++i) {
            size += CodedOutputStream.computeMessageSize((int)10, (MessageLite)((MessageLite)this.endTimeWindows_.get(i)));
        }
        if ((this.bitField0_ & 0x10) != 0) {
            size += CodedOutputStream.computeDoubleSize((int)11, (double)this.travelDurationMultiple_);
        }
        if (this.unloadingPolicy_ != UnloadingPolicy.UNLOADING_POLICY_UNSPECIFIED.getNumber()) {
            size += CodedOutputStream.computeEnumSize((int)12, (int)this.unloadingPolicy_);
        }
        if (Double.doubleToRawLongBits(this.costPerHour_) != 0L) {
            size += CodedOutputStream.computeDoubleSize((int)16, (double)this.costPerHour_);
        }
        if (Double.doubleToRawLongBits(this.costPerTraveledHour_) != 0L) {
            size += CodedOutputStream.computeDoubleSize((int)17, (double)this.costPerTraveledHour_);
        }
        if (Double.doubleToRawLongBits(this.costPerKilometer_) != 0L) {
            size += CodedOutputStream.computeDoubleSize((int)18, (double)this.costPerKilometer_);
        }
        if (Double.doubleToRawLongBits(this.fixedCost_) != 0L) {
            size += CodedOutputStream.computeDoubleSize((int)19, (double)this.fixedCost_);
        }
        if (this.usedIfRouteIsEmpty_) {
            size += CodedOutputStream.computeBoolSize((int)20, (boolean)this.usedIfRouteIsEmpty_);
        }
        if ((this.bitField0_ & 0x20) != 0) {
            size += CodedOutputStream.computeMessageSize((int)21, (MessageLite)this.getRouteDurationLimit());
        }
        if ((this.bitField0_ & 0x40) != 0) {
            size += CodedOutputStream.computeMessageSize((int)22, (MessageLite)this.getTravelDurationLimit());
        }
        if ((this.bitField0_ & 0x80) != 0) {
            size += CodedOutputStream.computeMessageSize((int)23, (MessageLite)this.getRouteDistanceLimit());
        }
        for (Map.Entry entry : this.internalGetExtraVisitDurationForVisitType().getMap().entrySet()) {
            MapEntry extraVisitDurationForVisitType__ = ExtraVisitDurationForVisitTypeDefaultEntryHolder.defaultEntry.newBuilderForType().setKey(entry.getKey()).setValue(entry.getValue()).build();
            size += CodedOutputStream.computeMessageSize((int)24, (MessageLite)extraVisitDurationForVisitType__);
        }
        if ((this.bitField0_ & 0x100) != 0) {
            size += CodedOutputStream.computeMessageSize((int)25, (MessageLite)this.getBreakRule());
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.label_)) {
            size += GeneratedMessageV3.computeStringSize((int)27, (Object)this.label_);
        }
        if (this.ignore_) {
            size += CodedOutputStream.computeBoolSize((int)28, (boolean)this.ignore_);
        }
        for (Map.Entry entry : this.internalGetLoadLimits().getMap().entrySet()) {
            MapEntry loadLimits__ = LoadLimitsDefaultEntryHolder.defaultEntry.newBuilderForType().setKey(entry.getKey()).setValue(entry.getValue()).build();
            size += CodedOutputStream.computeMessageSize((int)30, (MessageLite)loadLimits__);
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.displayName_)) {
            size += GeneratedMessageV3.computeStringSize((int)32, (Object)this.displayName_);
        }
        this.memoizedSize = size += this.getUnknownFields().getSerializedSize();
        return size;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Vehicle)) {
            return super.equals(obj);
        }
        Vehicle other = (Vehicle)obj;
        if (!this.getDisplayName().equals(other.getDisplayName())) {
            return false;
        }
        if (this.travelMode_ != other.travelMode_) {
            return false;
        }
        if (this.hasStartLocation() != other.hasStartLocation()) {
            return false;
        }
        if (this.hasStartLocation() && !this.getStartLocation().equals((Object)other.getStartLocation())) {
            return false;
        }
        if (this.hasStartWaypoint() != other.hasStartWaypoint()) {
            return false;
        }
        if (this.hasStartWaypoint() && !this.getStartWaypoint().equals(other.getStartWaypoint())) {
            return false;
        }
        if (this.hasEndLocation() != other.hasEndLocation()) {
            return false;
        }
        if (this.hasEndLocation() && !this.getEndLocation().equals((Object)other.getEndLocation())) {
            return false;
        }
        if (this.hasEndWaypoint() != other.hasEndWaypoint()) {
            return false;
        }
        if (this.hasEndWaypoint() && !this.getEndWaypoint().equals(other.getEndWaypoint())) {
            return false;
        }
        if (!this.getStartTagsList().equals(other.getStartTagsList())) {
            return false;
        }
        if (!this.getEndTagsList().equals(other.getEndTagsList())) {
            return false;
        }
        if (!this.getStartTimeWindowsList().equals(other.getStartTimeWindowsList())) {
            return false;
        }
        if (!this.getEndTimeWindowsList().equals(other.getEndTimeWindowsList())) {
            return false;
        }
        if (this.hasTravelDurationMultiple() != other.hasTravelDurationMultiple()) {
            return false;
        }
        if (this.hasTravelDurationMultiple() && Double.doubleToLongBits(this.getTravelDurationMultiple()) != Double.doubleToLongBits(other.getTravelDurationMultiple())) {
            return false;
        }
        if (this.unloadingPolicy_ != other.unloadingPolicy_) {
            return false;
        }
        if (!this.internalGetLoadLimits().equals(other.internalGetLoadLimits())) {
            return false;
        }
        if (Double.doubleToLongBits(this.getCostPerHour()) != Double.doubleToLongBits(other.getCostPerHour())) {
            return false;
        }
        if (Double.doubleToLongBits(this.getCostPerTraveledHour()) != Double.doubleToLongBits(other.getCostPerTraveledHour())) {
            return false;
        }
        if (Double.doubleToLongBits(this.getCostPerKilometer()) != Double.doubleToLongBits(other.getCostPerKilometer())) {
            return false;
        }
        if (Double.doubleToLongBits(this.getFixedCost()) != Double.doubleToLongBits(other.getFixedCost())) {
            return false;
        }
        if (this.getUsedIfRouteIsEmpty() != other.getUsedIfRouteIsEmpty()) {
            return false;
        }
        if (this.hasRouteDurationLimit() != other.hasRouteDurationLimit()) {
            return false;
        }
        if (this.hasRouteDurationLimit() && !this.getRouteDurationLimit().equals(other.getRouteDurationLimit())) {
            return false;
        }
        if (this.hasTravelDurationLimit() != other.hasTravelDurationLimit()) {
            return false;
        }
        if (this.hasTravelDurationLimit() && !this.getTravelDurationLimit().equals(other.getTravelDurationLimit())) {
            return false;
        }
        if (this.hasRouteDistanceLimit() != other.hasRouteDistanceLimit()) {
            return false;
        }
        if (this.hasRouteDistanceLimit() && !this.getRouteDistanceLimit().equals(other.getRouteDistanceLimit())) {
            return false;
        }
        if (!this.internalGetExtraVisitDurationForVisitType().equals(other.internalGetExtraVisitDurationForVisitType())) {
            return false;
        }
        if (this.hasBreakRule() != other.hasBreakRule()) {
            return false;
        }
        if (this.hasBreakRule() && !this.getBreakRule().equals(other.getBreakRule())) {
            return false;
        }
        if (!this.getLabel().equals(other.getLabel())) {
            return false;
        }
        if (this.getIgnore() != other.getIgnore()) {
            return false;
        }
        return this.getUnknownFields().equals((Object)other.getUnknownFields());
    }

    public int hashCode() {
        if (this.memoizedHashCode != 0) {
            return this.memoizedHashCode;
        }
        int hash = 41;
        hash = 19 * hash + Vehicle.getDescriptor().hashCode();
        hash = 37 * hash + 32;
        hash = 53 * hash + this.getDisplayName().hashCode();
        hash = 37 * hash + 1;
        hash = 53 * hash + this.travelMode_;
        if (this.hasStartLocation()) {
            hash = 37 * hash + 3;
            hash = 53 * hash + this.getStartLocation().hashCode();
        }
        if (this.hasStartWaypoint()) {
            hash = 37 * hash + 4;
            hash = 53 * hash + this.getStartWaypoint().hashCode();
        }
        if (this.hasEndLocation()) {
            hash = 37 * hash + 5;
            hash = 53 * hash + this.getEndLocation().hashCode();
        }
        if (this.hasEndWaypoint()) {
            hash = 37 * hash + 6;
            hash = 53 * hash + this.getEndWaypoint().hashCode();
        }
        if (this.getStartTagsCount() > 0) {
            hash = 37 * hash + 7;
            hash = 53 * hash + this.getStartTagsList().hashCode();
        }
        if (this.getEndTagsCount() > 0) {
            hash = 37 * hash + 8;
            hash = 53 * hash + this.getEndTagsList().hashCode();
        }
        if (this.getStartTimeWindowsCount() > 0) {
            hash = 37 * hash + 9;
            hash = 53 * hash + this.getStartTimeWindowsList().hashCode();
        }
        if (this.getEndTimeWindowsCount() > 0) {
            hash = 37 * hash + 10;
            hash = 53 * hash + this.getEndTimeWindowsList().hashCode();
        }
        if (this.hasTravelDurationMultiple()) {
            hash = 37 * hash + 11;
            hash = 53 * hash + Internal.hashLong((long)Double.doubleToLongBits(this.getTravelDurationMultiple()));
        }
        hash = 37 * hash + 12;
        hash = 53 * hash + this.unloadingPolicy_;
        if (!this.internalGetLoadLimits().getMap().isEmpty()) {
            hash = 37 * hash + 30;
            hash = 53 * hash + this.internalGetLoadLimits().hashCode();
        }
        hash = 37 * hash + 16;
        hash = 53 * hash + Internal.hashLong((long)Double.doubleToLongBits(this.getCostPerHour()));
        hash = 37 * hash + 17;
        hash = 53 * hash + Internal.hashLong((long)Double.doubleToLongBits(this.getCostPerTraveledHour()));
        hash = 37 * hash + 18;
        hash = 53 * hash + Internal.hashLong((long)Double.doubleToLongBits(this.getCostPerKilometer()));
        hash = 37 * hash + 19;
        hash = 53 * hash + Internal.hashLong((long)Double.doubleToLongBits(this.getFixedCost()));
        hash = 37 * hash + 20;
        hash = 53 * hash + Internal.hashBoolean((boolean)this.getUsedIfRouteIsEmpty());
        if (this.hasRouteDurationLimit()) {
            hash = 37 * hash + 21;
            hash = 53 * hash + this.getRouteDurationLimit().hashCode();
        }
        if (this.hasTravelDurationLimit()) {
            hash = 37 * hash + 22;
            hash = 53 * hash + this.getTravelDurationLimit().hashCode();
        }
        if (this.hasRouteDistanceLimit()) {
            hash = 37 * hash + 23;
            hash = 53 * hash + this.getRouteDistanceLimit().hashCode();
        }
        if (!this.internalGetExtraVisitDurationForVisitType().getMap().isEmpty()) {
            hash = 37 * hash + 24;
            hash = 53 * hash + this.internalGetExtraVisitDurationForVisitType().hashCode();
        }
        if (this.hasBreakRule()) {
            hash = 37 * hash + 25;
            hash = 53 * hash + this.getBreakRule().hashCode();
        }
        hash = 37 * hash + 27;
        hash = 53 * hash + this.getLabel().hashCode();
        hash = 37 * hash + 28;
        hash = 53 * hash + Internal.hashBoolean((boolean)this.getIgnore());
        this.memoizedHashCode = hash = 29 * hash + this.getUnknownFields().hashCode();
        return hash;
    }

    public static Vehicle parseFrom(ByteBuffer data) throws InvalidProtocolBufferException {
        return (Vehicle)PARSER.parseFrom(data);
    }

    public static Vehicle parseFrom(ByteBuffer data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (Vehicle)PARSER.parseFrom(data, extensionRegistry);
    }

    public static Vehicle parseFrom(ByteString data) throws InvalidProtocolBufferException {
        return (Vehicle)PARSER.parseFrom(data);
    }

    public static Vehicle parseFrom(ByteString data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (Vehicle)PARSER.parseFrom(data, extensionRegistry);
    }

    public static Vehicle parseFrom(byte[] data) throws InvalidProtocolBufferException {
        return (Vehicle)PARSER.parseFrom(data);
    }

    public static Vehicle parseFrom(byte[] data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (Vehicle)PARSER.parseFrom(data, extensionRegistry);
    }

    public static Vehicle parseFrom(InputStream input) throws IOException {
        return (Vehicle)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input);
    }

    public static Vehicle parseFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (Vehicle)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public static Vehicle parseDelimitedFrom(InputStream input) throws IOException {
        return (Vehicle)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input);
    }

    public static Vehicle parseDelimitedFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (Vehicle)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public static Vehicle parseFrom(CodedInputStream input) throws IOException {
        return (Vehicle)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input);
    }

    public static Vehicle parseFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (Vehicle)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public Builder newBuilderForType() {
        return Vehicle.newBuilder();
    }

    public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(Vehicle prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    protected Builder newBuilderForType(GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
    }

    public static Vehicle getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public static Parser<Vehicle> parser() {
        return PARSER;
    }

    public Parser<Vehicle> getParserForType() {
        return PARSER;
    }

    public Vehicle getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
    }

    public static final class Builder
    extends GeneratedMessageV3.Builder<Builder>
    implements VehicleOrBuilder {
        private int bitField0_;
        private Object displayName_ = "";
        private int travelMode_ = 0;
        private LatLng startLocation_;
        private SingleFieldBuilderV3<LatLng, LatLng.Builder, LatLngOrBuilder> startLocationBuilder_;
        private Waypoint startWaypoint_;
        private SingleFieldBuilderV3<Waypoint, Waypoint.Builder, WaypointOrBuilder> startWaypointBuilder_;
        private LatLng endLocation_;
        private SingleFieldBuilderV3<LatLng, LatLng.Builder, LatLngOrBuilder> endLocationBuilder_;
        private Waypoint endWaypoint_;
        private SingleFieldBuilderV3<Waypoint, Waypoint.Builder, WaypointOrBuilder> endWaypointBuilder_;
        private LazyStringArrayList startTags_ = LazyStringArrayList.emptyList();
        private LazyStringArrayList endTags_ = LazyStringArrayList.emptyList();
        private List<TimeWindow> startTimeWindows_ = Collections.emptyList();
        private RepeatedFieldBuilderV3<TimeWindow, TimeWindow.Builder, TimeWindowOrBuilder> startTimeWindowsBuilder_;
        private List<TimeWindow> endTimeWindows_ = Collections.emptyList();
        private RepeatedFieldBuilderV3<TimeWindow, TimeWindow.Builder, TimeWindowOrBuilder> endTimeWindowsBuilder_;
        private double travelDurationMultiple_;
        private int unloadingPolicy_ = 0;
        private static final LoadLimitsConverter loadLimitsConverter = new LoadLimitsConverter();
        private MapFieldBuilder<String, LoadLimitOrBuilder, LoadLimit, LoadLimit.Builder> loadLimits_;
        private double costPerHour_;
        private double costPerTraveledHour_;
        private double costPerKilometer_;
        private double fixedCost_;
        private boolean usedIfRouteIsEmpty_;
        private DurationLimit routeDurationLimit_;
        private SingleFieldBuilderV3<DurationLimit, DurationLimit.Builder, DurationLimitOrBuilder> routeDurationLimitBuilder_;
        private DurationLimit travelDurationLimit_;
        private SingleFieldBuilderV3<DurationLimit, DurationLimit.Builder, DurationLimitOrBuilder> travelDurationLimitBuilder_;
        private DistanceLimit routeDistanceLimit_;
        private SingleFieldBuilderV3<DistanceLimit, DistanceLimit.Builder, DistanceLimitOrBuilder> routeDistanceLimitBuilder_;
        private static final ExtraVisitDurationForVisitTypeConverter extraVisitDurationForVisitTypeConverter = new ExtraVisitDurationForVisitTypeConverter();
        private MapFieldBuilder<String, DurationOrBuilder, Duration, Duration.Builder> extraVisitDurationForVisitType_;
        private BreakRule breakRule_;
        private SingleFieldBuilderV3<BreakRule, BreakRule.Builder, BreakRuleOrBuilder> breakRuleBuilder_;
        private Object label_ = "";
        private boolean ignore_;

        public static final Descriptors.Descriptor getDescriptor() {
            return RouteOptimizationServiceProto.internal_static_google_maps_routeoptimization_v1_Vehicle_descriptor;
        }

        protected MapFieldReflectionAccessor internalGetMapFieldReflection(int number) {
            switch (number) {
                case 30: {
                    return this.internalGetLoadLimits();
                }
                case 24: {
                    return this.internalGetExtraVisitDurationForVisitType();
                }
            }
            throw new RuntimeException("Invalid map field number: " + number);
        }

        protected MapFieldReflectionAccessor internalGetMutableMapFieldReflection(int number) {
            switch (number) {
                case 30: {
                    return this.internalGetMutableLoadLimits();
                }
                case 24: {
                    return this.internalGetMutableExtraVisitDurationForVisitType();
                }
            }
            throw new RuntimeException("Invalid map field number: " + number);
        }

        protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
            return RouteOptimizationServiceProto.internal_static_google_maps_routeoptimization_v1_Vehicle_fieldAccessorTable.ensureFieldAccessorsInitialized(Vehicle.class, Builder.class);
        }

        private Builder() {
            this.maybeForceBuilderInitialization();
        }

        private Builder(GeneratedMessageV3.BuilderParent parent) {
            super(parent);
            this.maybeForceBuilderInitialization();
        }

        private void maybeForceBuilderInitialization() {
            if (alwaysUseFieldBuilders) {
                this.getStartLocationFieldBuilder();
                this.getStartWaypointFieldBuilder();
                this.getEndLocationFieldBuilder();
                this.getEndWaypointFieldBuilder();
                this.getStartTimeWindowsFieldBuilder();
                this.getEndTimeWindowsFieldBuilder();
                this.getRouteDurationLimitFieldBuilder();
                this.getTravelDurationLimitFieldBuilder();
                this.getRouteDistanceLimitFieldBuilder();
                this.getBreakRuleFieldBuilder();
            }
        }

        public Builder clear() {
            super.clear();
            this.bitField0_ = 0;
            this.displayName_ = "";
            this.travelMode_ = 0;
            this.startLocation_ = null;
            if (this.startLocationBuilder_ != null) {
                this.startLocationBuilder_.dispose();
                this.startLocationBuilder_ = null;
            }
            this.startWaypoint_ = null;
            if (this.startWaypointBuilder_ != null) {
                this.startWaypointBuilder_.dispose();
                this.startWaypointBuilder_ = null;
            }
            this.endLocation_ = null;
            if (this.endLocationBuilder_ != null) {
                this.endLocationBuilder_.dispose();
                this.endLocationBuilder_ = null;
            }
            this.endWaypoint_ = null;
            if (this.endWaypointBuilder_ != null) {
                this.endWaypointBuilder_.dispose();
                this.endWaypointBuilder_ = null;
            }
            this.startTags_ = LazyStringArrayList.emptyList();
            this.endTags_ = LazyStringArrayList.emptyList();
            if (this.startTimeWindowsBuilder_ == null) {
                this.startTimeWindows_ = Collections.emptyList();
            } else {
                this.startTimeWindows_ = null;
                this.startTimeWindowsBuilder_.clear();
            }
            this.bitField0_ &= 0xFFFFFEFF;
            if (this.endTimeWindowsBuilder_ == null) {
                this.endTimeWindows_ = Collections.emptyList();
            } else {
                this.endTimeWindows_ = null;
                this.endTimeWindowsBuilder_.clear();
            }
            this.bitField0_ &= 0xFFFFFDFF;
            this.travelDurationMultiple_ = 0.0;
            this.unloadingPolicy_ = 0;
            this.internalGetMutableLoadLimits().clear();
            this.costPerHour_ = 0.0;
            this.costPerTraveledHour_ = 0.0;
            this.costPerKilometer_ = 0.0;
            this.fixedCost_ = 0.0;
            this.usedIfRouteIsEmpty_ = false;
            this.routeDurationLimit_ = null;
            if (this.routeDurationLimitBuilder_ != null) {
                this.routeDurationLimitBuilder_.dispose();
                this.routeDurationLimitBuilder_ = null;
            }
            this.travelDurationLimit_ = null;
            if (this.travelDurationLimitBuilder_ != null) {
                this.travelDurationLimitBuilder_.dispose();
                this.travelDurationLimitBuilder_ = null;
            }
            this.routeDistanceLimit_ = null;
            if (this.routeDistanceLimitBuilder_ != null) {
                this.routeDistanceLimitBuilder_.dispose();
                this.routeDistanceLimitBuilder_ = null;
            }
            this.internalGetMutableExtraVisitDurationForVisitType().clear();
            this.breakRule_ = null;
            if (this.breakRuleBuilder_ != null) {
                this.breakRuleBuilder_.dispose();
                this.breakRuleBuilder_ = null;
            }
            this.label_ = "";
            this.ignore_ = false;
            return this;
        }

        public Descriptors.Descriptor getDescriptorForType() {
            return RouteOptimizationServiceProto.internal_static_google_maps_routeoptimization_v1_Vehicle_descriptor;
        }

        public Vehicle getDefaultInstanceForType() {
            return Vehicle.getDefaultInstance();
        }

        public Vehicle build() {
            Vehicle result = this.buildPartial();
            if (!result.isInitialized()) {
                throw Builder.newUninitializedMessageException((Message)result);
            }
            return result;
        }

        public Vehicle buildPartial() {
            Vehicle result = new Vehicle(this);
            this.buildPartialRepeatedFields(result);
            if (this.bitField0_ != 0) {
                this.buildPartial0(result);
            }
            this.onBuilt();
            return result;
        }

        private void buildPartialRepeatedFields(Vehicle result) {
            if (this.startTimeWindowsBuilder_ == null) {
                if ((this.bitField0_ & 0x100) != 0) {
                    this.startTimeWindows_ = Collections.unmodifiableList(this.startTimeWindows_);
                    this.bitField0_ &= 0xFFFFFEFF;
                }
                result.startTimeWindows_ = this.startTimeWindows_;
            } else {
                result.startTimeWindows_ = this.startTimeWindowsBuilder_.build();
            }
            if (this.endTimeWindowsBuilder_ == null) {
                if ((this.bitField0_ & 0x200) != 0) {
                    this.endTimeWindows_ = Collections.unmodifiableList(this.endTimeWindows_);
                    this.bitField0_ &= 0xFFFFFDFF;
                }
                result.endTimeWindows_ = this.endTimeWindows_;
            } else {
                result.endTimeWindows_ = this.endTimeWindowsBuilder_.build();
            }
        }

        private void buildPartial0(Vehicle result) {
            int from_bitField0_ = this.bitField0_;
            if ((from_bitField0_ & 1) != 0) {
                result.displayName_ = this.displayName_;
            }
            if ((from_bitField0_ & 2) != 0) {
                result.travelMode_ = this.travelMode_;
            }
            int to_bitField0_ = 0;
            if ((from_bitField0_ & 4) != 0) {
                result.startLocation_ = this.startLocationBuilder_ == null ? this.startLocation_ : (LatLng)this.startLocationBuilder_.build();
                to_bitField0_ |= 1;
            }
            if ((from_bitField0_ & 8) != 0) {
                result.startWaypoint_ = this.startWaypointBuilder_ == null ? this.startWaypoint_ : (Waypoint)this.startWaypointBuilder_.build();
                to_bitField0_ |= 2;
            }
            if ((from_bitField0_ & 0x10) != 0) {
                result.endLocation_ = this.endLocationBuilder_ == null ? this.endLocation_ : (LatLng)this.endLocationBuilder_.build();
                to_bitField0_ |= 4;
            }
            if ((from_bitField0_ & 0x20) != 0) {
                result.endWaypoint_ = this.endWaypointBuilder_ == null ? this.endWaypoint_ : (Waypoint)this.endWaypointBuilder_.build();
                to_bitField0_ |= 8;
            }
            if ((from_bitField0_ & 0x40) != 0) {
                this.startTags_.makeImmutable();
                result.startTags_ = this.startTags_;
            }
            if ((from_bitField0_ & 0x80) != 0) {
                this.endTags_.makeImmutable();
                result.endTags_ = this.endTags_;
            }
            if ((from_bitField0_ & 0x400) != 0) {
                result.travelDurationMultiple_ = this.travelDurationMultiple_;
                to_bitField0_ |= 0x10;
            }
            if ((from_bitField0_ & 0x800) != 0) {
                result.unloadingPolicy_ = this.unloadingPolicy_;
            }
            if ((from_bitField0_ & 0x1000) != 0) {
                result.loadLimits_ = this.internalGetLoadLimits().build(LoadLimitsDefaultEntryHolder.defaultEntry);
            }
            if ((from_bitField0_ & 0x2000) != 0) {
                result.costPerHour_ = this.costPerHour_;
            }
            if ((from_bitField0_ & 0x4000) != 0) {
                result.costPerTraveledHour_ = this.costPerTraveledHour_;
            }
            if ((from_bitField0_ & 0x8000) != 0) {
                result.costPerKilometer_ = this.costPerKilometer_;
            }
            if ((from_bitField0_ & 0x10000) != 0) {
                result.fixedCost_ = this.fixedCost_;
            }
            if ((from_bitField0_ & 0x20000) != 0) {
                result.usedIfRouteIsEmpty_ = this.usedIfRouteIsEmpty_;
            }
            if ((from_bitField0_ & 0x40000) != 0) {
                result.routeDurationLimit_ = this.routeDurationLimitBuilder_ == null ? this.routeDurationLimit_ : (DurationLimit)this.routeDurationLimitBuilder_.build();
                to_bitField0_ |= 0x20;
            }
            if ((from_bitField0_ & 0x80000) != 0) {
                result.travelDurationLimit_ = this.travelDurationLimitBuilder_ == null ? this.travelDurationLimit_ : (DurationLimit)this.travelDurationLimitBuilder_.build();
                to_bitField0_ |= 0x40;
            }
            if ((from_bitField0_ & 0x100000) != 0) {
                result.routeDistanceLimit_ = this.routeDistanceLimitBuilder_ == null ? this.routeDistanceLimit_ : (DistanceLimit)this.routeDistanceLimitBuilder_.build();
                to_bitField0_ |= 0x80;
            }
            if ((from_bitField0_ & 0x200000) != 0) {
                result.extraVisitDurationForVisitType_ = this.internalGetExtraVisitDurationForVisitType().build(ExtraVisitDurationForVisitTypeDefaultEntryHolder.defaultEntry);
            }
            if ((from_bitField0_ & 0x400000) != 0) {
                result.breakRule_ = this.breakRuleBuilder_ == null ? this.breakRule_ : (BreakRule)this.breakRuleBuilder_.build();
                to_bitField0_ |= 0x100;
            }
            if ((from_bitField0_ & 0x800000) != 0) {
                result.label_ = this.label_;
            }
            if ((from_bitField0_ & 0x1000000) != 0) {
                result.ignore_ = this.ignore_;
            }
            Vehicle vehicle = result;
            vehicle.bitField0_ = vehicle.bitField0_ | to_bitField0_;
        }

        public Builder clone() {
            return (Builder)super.clone();
        }

        public Builder setField(Descriptors.FieldDescriptor field, Object value) {
            return (Builder)super.setField(field, value);
        }

        public Builder clearField(Descriptors.FieldDescriptor field) {
            return (Builder)super.clearField(field);
        }

        public Builder clearOneof(Descriptors.OneofDescriptor oneof) {
            return (Builder)super.clearOneof(oneof);
        }

        public Builder setRepeatedField(Descriptors.FieldDescriptor field, int index, Object value) {
            return (Builder)super.setRepeatedField(field, index, value);
        }

        public Builder addRepeatedField(Descriptors.FieldDescriptor field, Object value) {
            return (Builder)super.addRepeatedField(field, value);
        }

        public Builder mergeFrom(Message other) {
            if (other instanceof Vehicle) {
                return this.mergeFrom((Vehicle)other);
            }
            super.mergeFrom(other);
            return this;
        }

        public Builder mergeFrom(Vehicle other) {
            if (other == Vehicle.getDefaultInstance()) {
                return this;
            }
            if (!other.getDisplayName().isEmpty()) {
                this.displayName_ = other.displayName_;
                this.bitField0_ |= 1;
                this.onChanged();
            }
            if (other.travelMode_ != 0) {
                this.setTravelModeValue(other.getTravelModeValue());
            }
            if (other.hasStartLocation()) {
                this.mergeStartLocation(other.getStartLocation());
            }
            if (other.hasStartWaypoint()) {
                this.mergeStartWaypoint(other.getStartWaypoint());
            }
            if (other.hasEndLocation()) {
                this.mergeEndLocation(other.getEndLocation());
            }
            if (other.hasEndWaypoint()) {
                this.mergeEndWaypoint(other.getEndWaypoint());
            }
            if (!other.startTags_.isEmpty()) {
                if (this.startTags_.isEmpty()) {
                    this.startTags_ = other.startTags_;
                    this.bitField0_ |= 0x40;
                } else {
                    this.ensureStartTagsIsMutable();
                    this.startTags_.addAll((Collection)other.startTags_);
                }
                this.onChanged();
            }
            if (!other.endTags_.isEmpty()) {
                if (this.endTags_.isEmpty()) {
                    this.endTags_ = other.endTags_;
                    this.bitField0_ |= 0x80;
                } else {
                    this.ensureEndTagsIsMutable();
                    this.endTags_.addAll((Collection)other.endTags_);
                }
                this.onChanged();
            }
            if (this.startTimeWindowsBuilder_ == null) {
                if (!other.startTimeWindows_.isEmpty()) {
                    if (this.startTimeWindows_.isEmpty()) {
                        this.startTimeWindows_ = other.startTimeWindows_;
                        this.bitField0_ &= 0xFFFFFEFF;
                    } else {
                        this.ensureStartTimeWindowsIsMutable();
                        this.startTimeWindows_.addAll(other.startTimeWindows_);
                    }
                    this.onChanged();
                }
            } else if (!other.startTimeWindows_.isEmpty()) {
                if (this.startTimeWindowsBuilder_.isEmpty()) {
                    this.startTimeWindowsBuilder_.dispose();
                    this.startTimeWindowsBuilder_ = null;
                    this.startTimeWindows_ = other.startTimeWindows_;
                    this.bitField0_ &= 0xFFFFFEFF;
                    this.startTimeWindowsBuilder_ = alwaysUseFieldBuilders ? this.getStartTimeWindowsFieldBuilder() : null;
                } else {
                    this.startTimeWindowsBuilder_.addAllMessages((Iterable)other.startTimeWindows_);
                }
            }
            if (this.endTimeWindowsBuilder_ == null) {
                if (!other.endTimeWindows_.isEmpty()) {
                    if (this.endTimeWindows_.isEmpty()) {
                        this.endTimeWindows_ = other.endTimeWindows_;
                        this.bitField0_ &= 0xFFFFFDFF;
                    } else {
                        this.ensureEndTimeWindowsIsMutable();
                        this.endTimeWindows_.addAll(other.endTimeWindows_);
                    }
                    this.onChanged();
                }
            } else if (!other.endTimeWindows_.isEmpty()) {
                if (this.endTimeWindowsBuilder_.isEmpty()) {
                    this.endTimeWindowsBuilder_.dispose();
                    this.endTimeWindowsBuilder_ = null;
                    this.endTimeWindows_ = other.endTimeWindows_;
                    this.bitField0_ &= 0xFFFFFDFF;
                    this.endTimeWindowsBuilder_ = alwaysUseFieldBuilders ? this.getEndTimeWindowsFieldBuilder() : null;
                } else {
                    this.endTimeWindowsBuilder_.addAllMessages((Iterable)other.endTimeWindows_);
                }
            }
            if (other.hasTravelDurationMultiple()) {
                this.setTravelDurationMultiple(other.getTravelDurationMultiple());
            }
            if (other.unloadingPolicy_ != 0) {
                this.setUnloadingPolicyValue(other.getUnloadingPolicyValue());
            }
            this.internalGetMutableLoadLimits().mergeFrom(other.internalGetLoadLimits());
            this.bitField0_ |= 0x1000;
            if (other.getCostPerHour() != 0.0) {
                this.setCostPerHour(other.getCostPerHour());
            }
            if (other.getCostPerTraveledHour() != 0.0) {
                this.setCostPerTraveledHour(other.getCostPerTraveledHour());
            }
            if (other.getCostPerKilometer() != 0.0) {
                this.setCostPerKilometer(other.getCostPerKilometer());
            }
            if (other.getFixedCost() != 0.0) {
                this.setFixedCost(other.getFixedCost());
            }
            if (other.getUsedIfRouteIsEmpty()) {
                this.setUsedIfRouteIsEmpty(other.getUsedIfRouteIsEmpty());
            }
            if (other.hasRouteDurationLimit()) {
                this.mergeRouteDurationLimit(other.getRouteDurationLimit());
            }
            if (other.hasTravelDurationLimit()) {
                this.mergeTravelDurationLimit(other.getTravelDurationLimit());
            }
            if (other.hasRouteDistanceLimit()) {
                this.mergeRouteDistanceLimit(other.getRouteDistanceLimit());
            }
            this.internalGetMutableExtraVisitDurationForVisitType().mergeFrom(other.internalGetExtraVisitDurationForVisitType());
            this.bitField0_ |= 0x200000;
            if (other.hasBreakRule()) {
                this.mergeBreakRule(other.getBreakRule());
            }
            if (!other.getLabel().isEmpty()) {
                this.label_ = other.label_;
                this.bitField0_ |= 0x800000;
                this.onChanged();
            }
            if (other.getIgnore()) {
                this.setIgnore(other.getIgnore());
            }
            this.mergeUnknownFields(other.getUnknownFields());
            this.onChanged();
            return this;
        }

        public final boolean isInitialized() {
            return true;
        }

        public Builder mergeFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            if (extensionRegistry == null) {
                throw new NullPointerException();
            }
            try {
                boolean done = false;
                block33: while (!done) {
                    int tag = input.readTag();
                    switch (tag) {
                        case 0: {
                            done = true;
                            continue block33;
                        }
                        case 8: {
                            this.travelMode_ = input.readEnum();
                            this.bitField0_ |= 2;
                            continue block33;
                        }
                        case 26: {
                            input.readMessage((MessageLite.Builder)this.getStartLocationFieldBuilder().getBuilder(), extensionRegistry);
                            this.bitField0_ |= 4;
                            continue block33;
                        }
                        case 34: {
                            input.readMessage((MessageLite.Builder)this.getStartWaypointFieldBuilder().getBuilder(), extensionRegistry);
                            this.bitField0_ |= 8;
                            continue block33;
                        }
                        case 42: {
                            input.readMessage((MessageLite.Builder)this.getEndLocationFieldBuilder().getBuilder(), extensionRegistry);
                            this.bitField0_ |= 0x10;
                            continue block33;
                        }
                        case 50: {
                            input.readMessage((MessageLite.Builder)this.getEndWaypointFieldBuilder().getBuilder(), extensionRegistry);
                            this.bitField0_ |= 0x20;
                            continue block33;
                        }
                        case 58: {
                            String s = input.readStringRequireUtf8();
                            this.ensureStartTagsIsMutable();
                            this.startTags_.add((Object)s);
                            continue block33;
                        }
                        case 66: {
                            String s = input.readStringRequireUtf8();
                            this.ensureEndTagsIsMutable();
                            this.endTags_.add((Object)s);
                            continue block33;
                        }
                        case 74: {
                            TimeWindow m = (TimeWindow)input.readMessage(TimeWindow.parser(), extensionRegistry);
                            if (this.startTimeWindowsBuilder_ == null) {
                                this.ensureStartTimeWindowsIsMutable();
                                this.startTimeWindows_.add(m);
                                continue block33;
                            }
                            this.startTimeWindowsBuilder_.addMessage((AbstractMessage)m);
                            continue block33;
                        }
                        case 82: {
                            TimeWindow m = (TimeWindow)input.readMessage(TimeWindow.parser(), extensionRegistry);
                            if (this.endTimeWindowsBuilder_ == null) {
                                this.ensureEndTimeWindowsIsMutable();
                                this.endTimeWindows_.add(m);
                                continue block33;
                            }
                            this.endTimeWindowsBuilder_.addMessage((AbstractMessage)m);
                            continue block33;
                        }
                        case 89: {
                            this.travelDurationMultiple_ = input.readDouble();
                            this.bitField0_ |= 0x400;
                            continue block33;
                        }
                        case 96: {
                            this.unloadingPolicy_ = input.readEnum();
                            this.bitField0_ |= 0x800;
                            continue block33;
                        }
                        case 129: {
                            this.costPerHour_ = input.readDouble();
                            this.bitField0_ |= 0x2000;
                            continue block33;
                        }
                        case 137: {
                            this.costPerTraveledHour_ = input.readDouble();
                            this.bitField0_ |= 0x4000;
                            continue block33;
                        }
                        case 145: {
                            this.costPerKilometer_ = input.readDouble();
                            this.bitField0_ |= 0x8000;
                            continue block33;
                        }
                        case 153: {
                            this.fixedCost_ = input.readDouble();
                            this.bitField0_ |= 0x10000;
                            continue block33;
                        }
                        case 160: {
                            this.usedIfRouteIsEmpty_ = input.readBool();
                            this.bitField0_ |= 0x20000;
                            continue block33;
                        }
                        case 170: {
                            input.readMessage((MessageLite.Builder)this.getRouteDurationLimitFieldBuilder().getBuilder(), extensionRegistry);
                            this.bitField0_ |= 0x40000;
                            continue block33;
                        }
                        case 178: {
                            input.readMessage((MessageLite.Builder)this.getTravelDurationLimitFieldBuilder().getBuilder(), extensionRegistry);
                            this.bitField0_ |= 0x80000;
                            continue block33;
                        }
                        case 186: {
                            input.readMessage((MessageLite.Builder)this.getRouteDistanceLimitFieldBuilder().getBuilder(), extensionRegistry);
                            this.bitField0_ |= 0x100000;
                            continue block33;
                        }
                        case 194: {
                            MapEntry extraVisitDurationForVisitType__ = (MapEntry)input.readMessage(ExtraVisitDurationForVisitTypeDefaultEntryHolder.defaultEntry.getParserForType(), extensionRegistry);
                            this.internalGetMutableExtraVisitDurationForVisitType().ensureBuilderMap().put(extraVisitDurationForVisitType__.getKey(), extraVisitDurationForVisitType__.getValue());
                            this.bitField0_ |= 0x200000;
                            continue block33;
                        }
                        case 202: {
                            input.readMessage((MessageLite.Builder)this.getBreakRuleFieldBuilder().getBuilder(), extensionRegistry);
                            this.bitField0_ |= 0x400000;
                            continue block33;
                        }
                        case 218: {
                            this.label_ = input.readStringRequireUtf8();
                            this.bitField0_ |= 0x800000;
                            continue block33;
                        }
                        case 224: {
                            this.ignore_ = input.readBool();
                            this.bitField0_ |= 0x1000000;
                            continue block33;
                        }
                        case 242: {
                            MapEntry loadLimits__ = (MapEntry)input.readMessage(LoadLimitsDefaultEntryHolder.defaultEntry.getParserForType(), extensionRegistry);
                            this.internalGetMutableLoadLimits().ensureBuilderMap().put(loadLimits__.getKey(), loadLimits__.getValue());
                            this.bitField0_ |= 0x1000;
                            continue block33;
                        }
                        case 258: {
                            this.displayName_ = input.readStringRequireUtf8();
                            this.bitField0_ |= 1;
                            continue block33;
                        }
                    }
                    if (super.parseUnknownField(input, extensionRegistry, tag)) continue;
                    done = true;
                }
            }
            catch (InvalidProtocolBufferException e) {
                throw e.unwrapIOException();
            }
            finally {
                this.onChanged();
            }
            return this;
        }

        @Override
        public String getDisplayName() {
            Object ref = this.displayName_;
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                this.displayName_ = s;
                return s;
            }
            return (String)ref;
        }

        @Override
        public ByteString getDisplayNameBytes() {
            Object ref = this.displayName_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.displayName_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public Builder setDisplayName(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.displayName_ = value;
            this.bitField0_ |= 1;
            this.onChanged();
            return this;
        }

        public Builder clearDisplayName() {
            this.displayName_ = Vehicle.getDefaultInstance().getDisplayName();
            this.bitField0_ &= 0xFFFFFFFE;
            this.onChanged();
            return this;
        }

        public Builder setDisplayNameBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            Vehicle.checkByteStringIsUtf8((ByteString)value);
            this.displayName_ = value;
            this.bitField0_ |= 1;
            this.onChanged();
            return this;
        }

        @Override
        public int getTravelModeValue() {
            return this.travelMode_;
        }

        public Builder setTravelModeValue(int value) {
            this.travelMode_ = value;
            this.bitField0_ |= 2;
            this.onChanged();
            return this;
        }

        @Override
        public TravelMode getTravelMode() {
            TravelMode result = TravelMode.forNumber(this.travelMode_);
            return result == null ? TravelMode.UNRECOGNIZED : result;
        }

        public Builder setTravelMode(TravelMode value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.bitField0_ |= 2;
            this.travelMode_ = value.getNumber();
            this.onChanged();
            return this;
        }

        public Builder clearTravelMode() {
            this.bitField0_ &= 0xFFFFFFFD;
            this.travelMode_ = 0;
            this.onChanged();
            return this;
        }

        @Override
        public boolean hasStartLocation() {
            return (this.bitField0_ & 4) != 0;
        }

        @Override
        public LatLng getStartLocation() {
            if (this.startLocationBuilder_ == null) {
                return this.startLocation_ == null ? LatLng.getDefaultInstance() : this.startLocation_;
            }
            return (LatLng)this.startLocationBuilder_.getMessage();
        }

        public Builder setStartLocation(LatLng value) {
            if (this.startLocationBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.startLocation_ = value;
            } else {
                this.startLocationBuilder_.setMessage((AbstractMessage)value);
            }
            this.bitField0_ |= 4;
            this.onChanged();
            return this;
        }

        public Builder setStartLocation(LatLng.Builder builderForValue) {
            if (this.startLocationBuilder_ == null) {
                this.startLocation_ = builderForValue.build();
            } else {
                this.startLocationBuilder_.setMessage((AbstractMessage)builderForValue.build());
            }
            this.bitField0_ |= 4;
            this.onChanged();
            return this;
        }

        public Builder mergeStartLocation(LatLng value) {
            if (this.startLocationBuilder_ == null) {
                if ((this.bitField0_ & 4) != 0 && this.startLocation_ != null && this.startLocation_ != LatLng.getDefaultInstance()) {
                    this.getStartLocationBuilder().mergeFrom(value);
                } else {
                    this.startLocation_ = value;
                }
            } else {
                this.startLocationBuilder_.mergeFrom((AbstractMessage)value);
            }
            if (this.startLocation_ != null) {
                this.bitField0_ |= 4;
                this.onChanged();
            }
            return this;
        }

        public Builder clearStartLocation() {
            this.bitField0_ &= 0xFFFFFFFB;
            this.startLocation_ = null;
            if (this.startLocationBuilder_ != null) {
                this.startLocationBuilder_.dispose();
                this.startLocationBuilder_ = null;
            }
            this.onChanged();
            return this;
        }

        public LatLng.Builder getStartLocationBuilder() {
            this.bitField0_ |= 4;
            this.onChanged();
            return (LatLng.Builder)this.getStartLocationFieldBuilder().getBuilder();
        }

        @Override
        public LatLngOrBuilder getStartLocationOrBuilder() {
            if (this.startLocationBuilder_ != null) {
                return (LatLngOrBuilder)this.startLocationBuilder_.getMessageOrBuilder();
            }
            return this.startLocation_ == null ? LatLng.getDefaultInstance() : this.startLocation_;
        }

        private SingleFieldBuilderV3<LatLng, LatLng.Builder, LatLngOrBuilder> getStartLocationFieldBuilder() {
            if (this.startLocationBuilder_ == null) {
                this.startLocationBuilder_ = new SingleFieldBuilderV3((AbstractMessage)this.getStartLocation(), (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.startLocation_ = null;
            }
            return this.startLocationBuilder_;
        }

        @Override
        public boolean hasStartWaypoint() {
            return (this.bitField0_ & 8) != 0;
        }

        @Override
        public Waypoint getStartWaypoint() {
            if (this.startWaypointBuilder_ == null) {
                return this.startWaypoint_ == null ? Waypoint.getDefaultInstance() : this.startWaypoint_;
            }
            return (Waypoint)this.startWaypointBuilder_.getMessage();
        }

        public Builder setStartWaypoint(Waypoint value) {
            if (this.startWaypointBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.startWaypoint_ = value;
            } else {
                this.startWaypointBuilder_.setMessage((AbstractMessage)value);
            }
            this.bitField0_ |= 8;
            this.onChanged();
            return this;
        }

        public Builder setStartWaypoint(Waypoint.Builder builderForValue) {
            if (this.startWaypointBuilder_ == null) {
                this.startWaypoint_ = builderForValue.build();
            } else {
                this.startWaypointBuilder_.setMessage((AbstractMessage)builderForValue.build());
            }
            this.bitField0_ |= 8;
            this.onChanged();
            return this;
        }

        public Builder mergeStartWaypoint(Waypoint value) {
            if (this.startWaypointBuilder_ == null) {
                if ((this.bitField0_ & 8) != 0 && this.startWaypoint_ != null && this.startWaypoint_ != Waypoint.getDefaultInstance()) {
                    this.getStartWaypointBuilder().mergeFrom(value);
                } else {
                    this.startWaypoint_ = value;
                }
            } else {
                this.startWaypointBuilder_.mergeFrom((AbstractMessage)value);
            }
            if (this.startWaypoint_ != null) {
                this.bitField0_ |= 8;
                this.onChanged();
            }
            return this;
        }

        public Builder clearStartWaypoint() {
            this.bitField0_ &= 0xFFFFFFF7;
            this.startWaypoint_ = null;
            if (this.startWaypointBuilder_ != null) {
                this.startWaypointBuilder_.dispose();
                this.startWaypointBuilder_ = null;
            }
            this.onChanged();
            return this;
        }

        public Waypoint.Builder getStartWaypointBuilder() {
            this.bitField0_ |= 8;
            this.onChanged();
            return (Waypoint.Builder)this.getStartWaypointFieldBuilder().getBuilder();
        }

        @Override
        public WaypointOrBuilder getStartWaypointOrBuilder() {
            if (this.startWaypointBuilder_ != null) {
                return (WaypointOrBuilder)this.startWaypointBuilder_.getMessageOrBuilder();
            }
            return this.startWaypoint_ == null ? Waypoint.getDefaultInstance() : this.startWaypoint_;
        }

        private SingleFieldBuilderV3<Waypoint, Waypoint.Builder, WaypointOrBuilder> getStartWaypointFieldBuilder() {
            if (this.startWaypointBuilder_ == null) {
                this.startWaypointBuilder_ = new SingleFieldBuilderV3((AbstractMessage)this.getStartWaypoint(), (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.startWaypoint_ = null;
            }
            return this.startWaypointBuilder_;
        }

        @Override
        public boolean hasEndLocation() {
            return (this.bitField0_ & 0x10) != 0;
        }

        @Override
        public LatLng getEndLocation() {
            if (this.endLocationBuilder_ == null) {
                return this.endLocation_ == null ? LatLng.getDefaultInstance() : this.endLocation_;
            }
            return (LatLng)this.endLocationBuilder_.getMessage();
        }

        public Builder setEndLocation(LatLng value) {
            if (this.endLocationBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.endLocation_ = value;
            } else {
                this.endLocationBuilder_.setMessage((AbstractMessage)value);
            }
            this.bitField0_ |= 0x10;
            this.onChanged();
            return this;
        }

        public Builder setEndLocation(LatLng.Builder builderForValue) {
            if (this.endLocationBuilder_ == null) {
                this.endLocation_ = builderForValue.build();
            } else {
                this.endLocationBuilder_.setMessage((AbstractMessage)builderForValue.build());
            }
            this.bitField0_ |= 0x10;
            this.onChanged();
            return this;
        }

        public Builder mergeEndLocation(LatLng value) {
            if (this.endLocationBuilder_ == null) {
                if ((this.bitField0_ & 0x10) != 0 && this.endLocation_ != null && this.endLocation_ != LatLng.getDefaultInstance()) {
                    this.getEndLocationBuilder().mergeFrom(value);
                } else {
                    this.endLocation_ = value;
                }
            } else {
                this.endLocationBuilder_.mergeFrom((AbstractMessage)value);
            }
            if (this.endLocation_ != null) {
                this.bitField0_ |= 0x10;
                this.onChanged();
            }
            return this;
        }

        public Builder clearEndLocation() {
            this.bitField0_ &= 0xFFFFFFEF;
            this.endLocation_ = null;
            if (this.endLocationBuilder_ != null) {
                this.endLocationBuilder_.dispose();
                this.endLocationBuilder_ = null;
            }
            this.onChanged();
            return this;
        }

        public LatLng.Builder getEndLocationBuilder() {
            this.bitField0_ |= 0x10;
            this.onChanged();
            return (LatLng.Builder)this.getEndLocationFieldBuilder().getBuilder();
        }

        @Override
        public LatLngOrBuilder getEndLocationOrBuilder() {
            if (this.endLocationBuilder_ != null) {
                return (LatLngOrBuilder)this.endLocationBuilder_.getMessageOrBuilder();
            }
            return this.endLocation_ == null ? LatLng.getDefaultInstance() : this.endLocation_;
        }

        private SingleFieldBuilderV3<LatLng, LatLng.Builder, LatLngOrBuilder> getEndLocationFieldBuilder() {
            if (this.endLocationBuilder_ == null) {
                this.endLocationBuilder_ = new SingleFieldBuilderV3((AbstractMessage)this.getEndLocation(), (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.endLocation_ = null;
            }
            return this.endLocationBuilder_;
        }

        @Override
        public boolean hasEndWaypoint() {
            return (this.bitField0_ & 0x20) != 0;
        }

        @Override
        public Waypoint getEndWaypoint() {
            if (this.endWaypointBuilder_ == null) {
                return this.endWaypoint_ == null ? Waypoint.getDefaultInstance() : this.endWaypoint_;
            }
            return (Waypoint)this.endWaypointBuilder_.getMessage();
        }

        public Builder setEndWaypoint(Waypoint value) {
            if (this.endWaypointBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.endWaypoint_ = value;
            } else {
                this.endWaypointBuilder_.setMessage((AbstractMessage)value);
            }
            this.bitField0_ |= 0x20;
            this.onChanged();
            return this;
        }

        public Builder setEndWaypoint(Waypoint.Builder builderForValue) {
            if (this.endWaypointBuilder_ == null) {
                this.endWaypoint_ = builderForValue.build();
            } else {
                this.endWaypointBuilder_.setMessage((AbstractMessage)builderForValue.build());
            }
            this.bitField0_ |= 0x20;
            this.onChanged();
            return this;
        }

        public Builder mergeEndWaypoint(Waypoint value) {
            if (this.endWaypointBuilder_ == null) {
                if ((this.bitField0_ & 0x20) != 0 && this.endWaypoint_ != null && this.endWaypoint_ != Waypoint.getDefaultInstance()) {
                    this.getEndWaypointBuilder().mergeFrom(value);
                } else {
                    this.endWaypoint_ = value;
                }
            } else {
                this.endWaypointBuilder_.mergeFrom((AbstractMessage)value);
            }
            if (this.endWaypoint_ != null) {
                this.bitField0_ |= 0x20;
                this.onChanged();
            }
            return this;
        }

        public Builder clearEndWaypoint() {
            this.bitField0_ &= 0xFFFFFFDF;
            this.endWaypoint_ = null;
            if (this.endWaypointBuilder_ != null) {
                this.endWaypointBuilder_.dispose();
                this.endWaypointBuilder_ = null;
            }
            this.onChanged();
            return this;
        }

        public Waypoint.Builder getEndWaypointBuilder() {
            this.bitField0_ |= 0x20;
            this.onChanged();
            return (Waypoint.Builder)this.getEndWaypointFieldBuilder().getBuilder();
        }

        @Override
        public WaypointOrBuilder getEndWaypointOrBuilder() {
            if (this.endWaypointBuilder_ != null) {
                return (WaypointOrBuilder)this.endWaypointBuilder_.getMessageOrBuilder();
            }
            return this.endWaypoint_ == null ? Waypoint.getDefaultInstance() : this.endWaypoint_;
        }

        private SingleFieldBuilderV3<Waypoint, Waypoint.Builder, WaypointOrBuilder> getEndWaypointFieldBuilder() {
            if (this.endWaypointBuilder_ == null) {
                this.endWaypointBuilder_ = new SingleFieldBuilderV3((AbstractMessage)this.getEndWaypoint(), (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.endWaypoint_ = null;
            }
            return this.endWaypointBuilder_;
        }

        private void ensureStartTagsIsMutable() {
            if (!this.startTags_.isModifiable()) {
                this.startTags_ = new LazyStringArrayList((LazyStringList)this.startTags_);
            }
            this.bitField0_ |= 0x40;
        }

        public ProtocolStringList getStartTagsList() {
            this.startTags_.makeImmutable();
            return this.startTags_;
        }

        @Override
        public int getStartTagsCount() {
            return this.startTags_.size();
        }

        @Override
        public String getStartTags(int index) {
            return this.startTags_.get(index);
        }

        @Override
        public ByteString getStartTagsBytes(int index) {
            return this.startTags_.getByteString(index);
        }

        public Builder setStartTags(int index, String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.ensureStartTagsIsMutable();
            this.startTags_.set(index, value);
            this.bitField0_ |= 0x40;
            this.onChanged();
            return this;
        }

        public Builder addStartTags(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.ensureStartTagsIsMutable();
            this.startTags_.add((Object)value);
            this.bitField0_ |= 0x40;
            this.onChanged();
            return this;
        }

        public Builder addAllStartTags(Iterable<String> values) {
            this.ensureStartTagsIsMutable();
            AbstractMessageLite.Builder.addAll(values, (List)this.startTags_);
            this.bitField0_ |= 0x40;
            this.onChanged();
            return this;
        }

        public Builder clearStartTags() {
            this.startTags_ = LazyStringArrayList.emptyList();
            this.bitField0_ &= 0xFFFFFFBF;
            this.onChanged();
            return this;
        }

        public Builder addStartTagsBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            Vehicle.checkByteStringIsUtf8((ByteString)value);
            this.ensureStartTagsIsMutable();
            this.startTags_.add(value);
            this.bitField0_ |= 0x40;
            this.onChanged();
            return this;
        }

        private void ensureEndTagsIsMutable() {
            if (!this.endTags_.isModifiable()) {
                this.endTags_ = new LazyStringArrayList((LazyStringList)this.endTags_);
            }
            this.bitField0_ |= 0x80;
        }

        public ProtocolStringList getEndTagsList() {
            this.endTags_.makeImmutable();
            return this.endTags_;
        }

        @Override
        public int getEndTagsCount() {
            return this.endTags_.size();
        }

        @Override
        public String getEndTags(int index) {
            return this.endTags_.get(index);
        }

        @Override
        public ByteString getEndTagsBytes(int index) {
            return this.endTags_.getByteString(index);
        }

        public Builder setEndTags(int index, String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.ensureEndTagsIsMutable();
            this.endTags_.set(index, value);
            this.bitField0_ |= 0x80;
            this.onChanged();
            return this;
        }

        public Builder addEndTags(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.ensureEndTagsIsMutable();
            this.endTags_.add((Object)value);
            this.bitField0_ |= 0x80;
            this.onChanged();
            return this;
        }

        public Builder addAllEndTags(Iterable<String> values) {
            this.ensureEndTagsIsMutable();
            AbstractMessageLite.Builder.addAll(values, (List)this.endTags_);
            this.bitField0_ |= 0x80;
            this.onChanged();
            return this;
        }

        public Builder clearEndTags() {
            this.endTags_ = LazyStringArrayList.emptyList();
            this.bitField0_ &= 0xFFFFFF7F;
            this.onChanged();
            return this;
        }

        public Builder addEndTagsBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            Vehicle.checkByteStringIsUtf8((ByteString)value);
            this.ensureEndTagsIsMutable();
            this.endTags_.add(value);
            this.bitField0_ |= 0x80;
            this.onChanged();
            return this;
        }

        private void ensureStartTimeWindowsIsMutable() {
            if ((this.bitField0_ & 0x100) == 0) {
                this.startTimeWindows_ = new ArrayList<TimeWindow>(this.startTimeWindows_);
                this.bitField0_ |= 0x100;
            }
        }

        @Override
        public List<TimeWindow> getStartTimeWindowsList() {
            if (this.startTimeWindowsBuilder_ == null) {
                return Collections.unmodifiableList(this.startTimeWindows_);
            }
            return this.startTimeWindowsBuilder_.getMessageList();
        }

        @Override
        public int getStartTimeWindowsCount() {
            if (this.startTimeWindowsBuilder_ == null) {
                return this.startTimeWindows_.size();
            }
            return this.startTimeWindowsBuilder_.getCount();
        }

        @Override
        public TimeWindow getStartTimeWindows(int index) {
            if (this.startTimeWindowsBuilder_ == null) {
                return this.startTimeWindows_.get(index);
            }
            return (TimeWindow)this.startTimeWindowsBuilder_.getMessage(index);
        }

        public Builder setStartTimeWindows(int index, TimeWindow value) {
            if (this.startTimeWindowsBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureStartTimeWindowsIsMutable();
                this.startTimeWindows_.set(index, value);
                this.onChanged();
            } else {
                this.startTimeWindowsBuilder_.setMessage(index, (AbstractMessage)value);
            }
            return this;
        }

        public Builder setStartTimeWindows(int index, TimeWindow.Builder builderForValue) {
            if (this.startTimeWindowsBuilder_ == null) {
                this.ensureStartTimeWindowsIsMutable();
                this.startTimeWindows_.set(index, builderForValue.build());
                this.onChanged();
            } else {
                this.startTimeWindowsBuilder_.setMessage(index, (AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addStartTimeWindows(TimeWindow value) {
            if (this.startTimeWindowsBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureStartTimeWindowsIsMutable();
                this.startTimeWindows_.add(value);
                this.onChanged();
            } else {
                this.startTimeWindowsBuilder_.addMessage((AbstractMessage)value);
            }
            return this;
        }

        public Builder addStartTimeWindows(int index, TimeWindow value) {
            if (this.startTimeWindowsBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureStartTimeWindowsIsMutable();
                this.startTimeWindows_.add(index, value);
                this.onChanged();
            } else {
                this.startTimeWindowsBuilder_.addMessage(index, (AbstractMessage)value);
            }
            return this;
        }

        public Builder addStartTimeWindows(TimeWindow.Builder builderForValue) {
            if (this.startTimeWindowsBuilder_ == null) {
                this.ensureStartTimeWindowsIsMutable();
                this.startTimeWindows_.add(builderForValue.build());
                this.onChanged();
            } else {
                this.startTimeWindowsBuilder_.addMessage((AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addStartTimeWindows(int index, TimeWindow.Builder builderForValue) {
            if (this.startTimeWindowsBuilder_ == null) {
                this.ensureStartTimeWindowsIsMutable();
                this.startTimeWindows_.add(index, builderForValue.build());
                this.onChanged();
            } else {
                this.startTimeWindowsBuilder_.addMessage(index, (AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addAllStartTimeWindows(Iterable<? extends TimeWindow> values) {
            if (this.startTimeWindowsBuilder_ == null) {
                this.ensureStartTimeWindowsIsMutable();
                AbstractMessageLite.Builder.addAll(values, this.startTimeWindows_);
                this.onChanged();
            } else {
                this.startTimeWindowsBuilder_.addAllMessages(values);
            }
            return this;
        }

        public Builder clearStartTimeWindows() {
            if (this.startTimeWindowsBuilder_ == null) {
                this.startTimeWindows_ = Collections.emptyList();
                this.bitField0_ &= 0xFFFFFEFF;
                this.onChanged();
            } else {
                this.startTimeWindowsBuilder_.clear();
            }
            return this;
        }

        public Builder removeStartTimeWindows(int index) {
            if (this.startTimeWindowsBuilder_ == null) {
                this.ensureStartTimeWindowsIsMutable();
                this.startTimeWindows_.remove(index);
                this.onChanged();
            } else {
                this.startTimeWindowsBuilder_.remove(index);
            }
            return this;
        }

        public TimeWindow.Builder getStartTimeWindowsBuilder(int index) {
            return (TimeWindow.Builder)this.getStartTimeWindowsFieldBuilder().getBuilder(index);
        }

        @Override
        public TimeWindowOrBuilder getStartTimeWindowsOrBuilder(int index) {
            if (this.startTimeWindowsBuilder_ == null) {
                return this.startTimeWindows_.get(index);
            }
            return (TimeWindowOrBuilder)this.startTimeWindowsBuilder_.getMessageOrBuilder(index);
        }

        @Override
        public List<? extends TimeWindowOrBuilder> getStartTimeWindowsOrBuilderList() {
            if (this.startTimeWindowsBuilder_ != null) {
                return this.startTimeWindowsBuilder_.getMessageOrBuilderList();
            }
            return Collections.unmodifiableList(this.startTimeWindows_);
        }

        public TimeWindow.Builder addStartTimeWindowsBuilder() {
            return (TimeWindow.Builder)this.getStartTimeWindowsFieldBuilder().addBuilder((AbstractMessage)TimeWindow.getDefaultInstance());
        }

        public TimeWindow.Builder addStartTimeWindowsBuilder(int index) {
            return (TimeWindow.Builder)this.getStartTimeWindowsFieldBuilder().addBuilder(index, (AbstractMessage)TimeWindow.getDefaultInstance());
        }

        public List<TimeWindow.Builder> getStartTimeWindowsBuilderList() {
            return this.getStartTimeWindowsFieldBuilder().getBuilderList();
        }

        private RepeatedFieldBuilderV3<TimeWindow, TimeWindow.Builder, TimeWindowOrBuilder> getStartTimeWindowsFieldBuilder() {
            if (this.startTimeWindowsBuilder_ == null) {
                this.startTimeWindowsBuilder_ = new RepeatedFieldBuilderV3(this.startTimeWindows_, (this.bitField0_ & 0x100) != 0, (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.startTimeWindows_ = null;
            }
            return this.startTimeWindowsBuilder_;
        }

        private void ensureEndTimeWindowsIsMutable() {
            if ((this.bitField0_ & 0x200) == 0) {
                this.endTimeWindows_ = new ArrayList<TimeWindow>(this.endTimeWindows_);
                this.bitField0_ |= 0x200;
            }
        }

        @Override
        public List<TimeWindow> getEndTimeWindowsList() {
            if (this.endTimeWindowsBuilder_ == null) {
                return Collections.unmodifiableList(this.endTimeWindows_);
            }
            return this.endTimeWindowsBuilder_.getMessageList();
        }

        @Override
        public int getEndTimeWindowsCount() {
            if (this.endTimeWindowsBuilder_ == null) {
                return this.endTimeWindows_.size();
            }
            return this.endTimeWindowsBuilder_.getCount();
        }

        @Override
        public TimeWindow getEndTimeWindows(int index) {
            if (this.endTimeWindowsBuilder_ == null) {
                return this.endTimeWindows_.get(index);
            }
            return (TimeWindow)this.endTimeWindowsBuilder_.getMessage(index);
        }

        public Builder setEndTimeWindows(int index, TimeWindow value) {
            if (this.endTimeWindowsBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureEndTimeWindowsIsMutable();
                this.endTimeWindows_.set(index, value);
                this.onChanged();
            } else {
                this.endTimeWindowsBuilder_.setMessage(index, (AbstractMessage)value);
            }
            return this;
        }

        public Builder setEndTimeWindows(int index, TimeWindow.Builder builderForValue) {
            if (this.endTimeWindowsBuilder_ == null) {
                this.ensureEndTimeWindowsIsMutable();
                this.endTimeWindows_.set(index, builderForValue.build());
                this.onChanged();
            } else {
                this.endTimeWindowsBuilder_.setMessage(index, (AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addEndTimeWindows(TimeWindow value) {
            if (this.endTimeWindowsBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureEndTimeWindowsIsMutable();
                this.endTimeWindows_.add(value);
                this.onChanged();
            } else {
                this.endTimeWindowsBuilder_.addMessage((AbstractMessage)value);
            }
            return this;
        }

        public Builder addEndTimeWindows(int index, TimeWindow value) {
            if (this.endTimeWindowsBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureEndTimeWindowsIsMutable();
                this.endTimeWindows_.add(index, value);
                this.onChanged();
            } else {
                this.endTimeWindowsBuilder_.addMessage(index, (AbstractMessage)value);
            }
            return this;
        }

        public Builder addEndTimeWindows(TimeWindow.Builder builderForValue) {
            if (this.endTimeWindowsBuilder_ == null) {
                this.ensureEndTimeWindowsIsMutable();
                this.endTimeWindows_.add(builderForValue.build());
                this.onChanged();
            } else {
                this.endTimeWindowsBuilder_.addMessage((AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addEndTimeWindows(int index, TimeWindow.Builder builderForValue) {
            if (this.endTimeWindowsBuilder_ == null) {
                this.ensureEndTimeWindowsIsMutable();
                this.endTimeWindows_.add(index, builderForValue.build());
                this.onChanged();
            } else {
                this.endTimeWindowsBuilder_.addMessage(index, (AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addAllEndTimeWindows(Iterable<? extends TimeWindow> values) {
            if (this.endTimeWindowsBuilder_ == null) {
                this.ensureEndTimeWindowsIsMutable();
                AbstractMessageLite.Builder.addAll(values, this.endTimeWindows_);
                this.onChanged();
            } else {
                this.endTimeWindowsBuilder_.addAllMessages(values);
            }
            return this;
        }

        public Builder clearEndTimeWindows() {
            if (this.endTimeWindowsBuilder_ == null) {
                this.endTimeWindows_ = Collections.emptyList();
                this.bitField0_ &= 0xFFFFFDFF;
                this.onChanged();
            } else {
                this.endTimeWindowsBuilder_.clear();
            }
            return this;
        }

        public Builder removeEndTimeWindows(int index) {
            if (this.endTimeWindowsBuilder_ == null) {
                this.ensureEndTimeWindowsIsMutable();
                this.endTimeWindows_.remove(index);
                this.onChanged();
            } else {
                this.endTimeWindowsBuilder_.remove(index);
            }
            return this;
        }

        public TimeWindow.Builder getEndTimeWindowsBuilder(int index) {
            return (TimeWindow.Builder)this.getEndTimeWindowsFieldBuilder().getBuilder(index);
        }

        @Override
        public TimeWindowOrBuilder getEndTimeWindowsOrBuilder(int index) {
            if (this.endTimeWindowsBuilder_ == null) {
                return this.endTimeWindows_.get(index);
            }
            return (TimeWindowOrBuilder)this.endTimeWindowsBuilder_.getMessageOrBuilder(index);
        }

        @Override
        public List<? extends TimeWindowOrBuilder> getEndTimeWindowsOrBuilderList() {
            if (this.endTimeWindowsBuilder_ != null) {
                return this.endTimeWindowsBuilder_.getMessageOrBuilderList();
            }
            return Collections.unmodifiableList(this.endTimeWindows_);
        }

        public TimeWindow.Builder addEndTimeWindowsBuilder() {
            return (TimeWindow.Builder)this.getEndTimeWindowsFieldBuilder().addBuilder((AbstractMessage)TimeWindow.getDefaultInstance());
        }

        public TimeWindow.Builder addEndTimeWindowsBuilder(int index) {
            return (TimeWindow.Builder)this.getEndTimeWindowsFieldBuilder().addBuilder(index, (AbstractMessage)TimeWindow.getDefaultInstance());
        }

        public List<TimeWindow.Builder> getEndTimeWindowsBuilderList() {
            return this.getEndTimeWindowsFieldBuilder().getBuilderList();
        }

        private RepeatedFieldBuilderV3<TimeWindow, TimeWindow.Builder, TimeWindowOrBuilder> getEndTimeWindowsFieldBuilder() {
            if (this.endTimeWindowsBuilder_ == null) {
                this.endTimeWindowsBuilder_ = new RepeatedFieldBuilderV3(this.endTimeWindows_, (this.bitField0_ & 0x200) != 0, (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.endTimeWindows_ = null;
            }
            return this.endTimeWindowsBuilder_;
        }

        @Override
        public boolean hasTravelDurationMultiple() {
            return (this.bitField0_ & 0x400) != 0;
        }

        @Override
        public double getTravelDurationMultiple() {
            return this.travelDurationMultiple_;
        }

        public Builder setTravelDurationMultiple(double value) {
            this.travelDurationMultiple_ = value;
            this.bitField0_ |= 0x400;
            this.onChanged();
            return this;
        }

        public Builder clearTravelDurationMultiple() {
            this.bitField0_ &= 0xFFFFFBFF;
            this.travelDurationMultiple_ = 0.0;
            this.onChanged();
            return this;
        }

        @Override
        public int getUnloadingPolicyValue() {
            return this.unloadingPolicy_;
        }

        public Builder setUnloadingPolicyValue(int value) {
            this.unloadingPolicy_ = value;
            this.bitField0_ |= 0x800;
            this.onChanged();
            return this;
        }

        @Override
        public UnloadingPolicy getUnloadingPolicy() {
            UnloadingPolicy result = UnloadingPolicy.forNumber(this.unloadingPolicy_);
            return result == null ? UnloadingPolicy.UNRECOGNIZED : result;
        }

        public Builder setUnloadingPolicy(UnloadingPolicy value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.bitField0_ |= 0x800;
            this.unloadingPolicy_ = value.getNumber();
            this.onChanged();
            return this;
        }

        public Builder clearUnloadingPolicy() {
            this.bitField0_ &= 0xFFFFF7FF;
            this.unloadingPolicy_ = 0;
            this.onChanged();
            return this;
        }

        private MapFieldBuilder<String, LoadLimitOrBuilder, LoadLimit, LoadLimit.Builder> internalGetLoadLimits() {
            if (this.loadLimits_ == null) {
                return new MapFieldBuilder((MapFieldBuilder.Converter)loadLimitsConverter);
            }
            return this.loadLimits_;
        }

        private MapFieldBuilder<String, LoadLimitOrBuilder, LoadLimit, LoadLimit.Builder> internalGetMutableLoadLimits() {
            if (this.loadLimits_ == null) {
                this.loadLimits_ = new MapFieldBuilder((MapFieldBuilder.Converter)loadLimitsConverter);
            }
            this.bitField0_ |= 0x1000;
            this.onChanged();
            return this.loadLimits_;
        }

        @Override
        public int getLoadLimitsCount() {
            return this.internalGetLoadLimits().ensureBuilderMap().size();
        }

        @Override
        public boolean containsLoadLimits(String key) {
            if (key == null) {
                throw new NullPointerException("map key");
            }
            return this.internalGetLoadLimits().ensureBuilderMap().containsKey(key);
        }

        @Override
        @Deprecated
        public Map<String, LoadLimit> getLoadLimits() {
            return this.getLoadLimitsMap();
        }

        @Override
        public Map<String, LoadLimit> getLoadLimitsMap() {
            return this.internalGetLoadLimits().getImmutableMap();
        }

        @Override
        public LoadLimit getLoadLimitsOrDefault(String key, LoadLimit defaultValue) {
            if (key == null) {
                throw new NullPointerException("map key");
            }
            Map map = this.internalGetMutableLoadLimits().ensureBuilderMap();
            return map.containsKey(key) ? loadLimitsConverter.build((LoadLimitOrBuilder)map.get(key)) : defaultValue;
        }

        @Override
        public LoadLimit getLoadLimitsOrThrow(String key) {
            if (key == null) {
                throw new NullPointerException("map key");
            }
            Map map = this.internalGetMutableLoadLimits().ensureBuilderMap();
            if (!map.containsKey(key)) {
                throw new IllegalArgumentException();
            }
            return loadLimitsConverter.build((LoadLimitOrBuilder)map.get(key));
        }

        public Builder clearLoadLimits() {
            this.bitField0_ &= 0xFFFFEFFF;
            this.internalGetMutableLoadLimits().clear();
            return this;
        }

        public Builder removeLoadLimits(String key) {
            if (key == null) {
                throw new NullPointerException("map key");
            }
            this.internalGetMutableLoadLimits().ensureBuilderMap().remove(key);
            return this;
        }

        @Deprecated
        public Map<String, LoadLimit> getMutableLoadLimits() {
            this.bitField0_ |= 0x1000;
            return this.internalGetMutableLoadLimits().ensureMessageMap();
        }

        public Builder putLoadLimits(String key, LoadLimit value) {
            if (key == null) {
                throw new NullPointerException("map key");
            }
            if (value == null) {
                throw new NullPointerException("map value");
            }
            this.internalGetMutableLoadLimits().ensureBuilderMap().put(key, value);
            this.bitField0_ |= 0x1000;
            return this;
        }

        public Builder putAllLoadLimits(Map<String, LoadLimit> values) {
            for (Map.Entry<String, LoadLimit> e : values.entrySet()) {
                if (e.getKey() != null && e.getValue() != null) continue;
                throw new NullPointerException();
            }
            this.internalGetMutableLoadLimits().ensureBuilderMap().putAll(values);
            this.bitField0_ |= 0x1000;
            return this;
        }

        public LoadLimit.Builder putLoadLimitsBuilderIfAbsent(String key) {
            Map builderMap = this.internalGetMutableLoadLimits().ensureBuilderMap();
            LoadLimitOrBuilder entry = (LoadLimitOrBuilder)builderMap.get(key);
            if (entry == null) {
                entry = LoadLimit.newBuilder();
                builderMap.put(key, entry);
            }
            if (entry instanceof LoadLimit) {
                entry = ((LoadLimit)entry).toBuilder();
                builderMap.put(key, entry);
            }
            return (LoadLimit.Builder)entry;
        }

        @Override
        public double getCostPerHour() {
            return this.costPerHour_;
        }

        public Builder setCostPerHour(double value) {
            this.costPerHour_ = value;
            this.bitField0_ |= 0x2000;
            this.onChanged();
            return this;
        }

        public Builder clearCostPerHour() {
            this.bitField0_ &= 0xFFFFDFFF;
            this.costPerHour_ = 0.0;
            this.onChanged();
            return this;
        }

        @Override
        public double getCostPerTraveledHour() {
            return this.costPerTraveledHour_;
        }

        public Builder setCostPerTraveledHour(double value) {
            this.costPerTraveledHour_ = value;
            this.bitField0_ |= 0x4000;
            this.onChanged();
            return this;
        }

        public Builder clearCostPerTraveledHour() {
            this.bitField0_ &= 0xFFFFBFFF;
            this.costPerTraveledHour_ = 0.0;
            this.onChanged();
            return this;
        }

        @Override
        public double getCostPerKilometer() {
            return this.costPerKilometer_;
        }

        public Builder setCostPerKilometer(double value) {
            this.costPerKilometer_ = value;
            this.bitField0_ |= 0x8000;
            this.onChanged();
            return this;
        }

        public Builder clearCostPerKilometer() {
            this.bitField0_ &= 0xFFFF7FFF;
            this.costPerKilometer_ = 0.0;
            this.onChanged();
            return this;
        }

        @Override
        public double getFixedCost() {
            return this.fixedCost_;
        }

        public Builder setFixedCost(double value) {
            this.fixedCost_ = value;
            this.bitField0_ |= 0x10000;
            this.onChanged();
            return this;
        }

        public Builder clearFixedCost() {
            this.bitField0_ &= 0xFFFEFFFF;
            this.fixedCost_ = 0.0;
            this.onChanged();
            return this;
        }

        @Override
        public boolean getUsedIfRouteIsEmpty() {
            return this.usedIfRouteIsEmpty_;
        }

        public Builder setUsedIfRouteIsEmpty(boolean value) {
            this.usedIfRouteIsEmpty_ = value;
            this.bitField0_ |= 0x20000;
            this.onChanged();
            return this;
        }

        public Builder clearUsedIfRouteIsEmpty() {
            this.bitField0_ &= 0xFFFDFFFF;
            this.usedIfRouteIsEmpty_ = false;
            this.onChanged();
            return this;
        }

        @Override
        public boolean hasRouteDurationLimit() {
            return (this.bitField0_ & 0x40000) != 0;
        }

        @Override
        public DurationLimit getRouteDurationLimit() {
            if (this.routeDurationLimitBuilder_ == null) {
                return this.routeDurationLimit_ == null ? DurationLimit.getDefaultInstance() : this.routeDurationLimit_;
            }
            return (DurationLimit)this.routeDurationLimitBuilder_.getMessage();
        }

        public Builder setRouteDurationLimit(DurationLimit value) {
            if (this.routeDurationLimitBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.routeDurationLimit_ = value;
            } else {
                this.routeDurationLimitBuilder_.setMessage((AbstractMessage)value);
            }
            this.bitField0_ |= 0x40000;
            this.onChanged();
            return this;
        }

        public Builder setRouteDurationLimit(DurationLimit.Builder builderForValue) {
            if (this.routeDurationLimitBuilder_ == null) {
                this.routeDurationLimit_ = builderForValue.build();
            } else {
                this.routeDurationLimitBuilder_.setMessage((AbstractMessage)builderForValue.build());
            }
            this.bitField0_ |= 0x40000;
            this.onChanged();
            return this;
        }

        public Builder mergeRouteDurationLimit(DurationLimit value) {
            if (this.routeDurationLimitBuilder_ == null) {
                if ((this.bitField0_ & 0x40000) != 0 && this.routeDurationLimit_ != null && this.routeDurationLimit_ != DurationLimit.getDefaultInstance()) {
                    this.getRouteDurationLimitBuilder().mergeFrom(value);
                } else {
                    this.routeDurationLimit_ = value;
                }
            } else {
                this.routeDurationLimitBuilder_.mergeFrom((AbstractMessage)value);
            }
            if (this.routeDurationLimit_ != null) {
                this.bitField0_ |= 0x40000;
                this.onChanged();
            }
            return this;
        }

        public Builder clearRouteDurationLimit() {
            this.bitField0_ &= 0xFFFBFFFF;
            this.routeDurationLimit_ = null;
            if (this.routeDurationLimitBuilder_ != null) {
                this.routeDurationLimitBuilder_.dispose();
                this.routeDurationLimitBuilder_ = null;
            }
            this.onChanged();
            return this;
        }

        public DurationLimit.Builder getRouteDurationLimitBuilder() {
            this.bitField0_ |= 0x40000;
            this.onChanged();
            return (DurationLimit.Builder)this.getRouteDurationLimitFieldBuilder().getBuilder();
        }

        @Override
        public DurationLimitOrBuilder getRouteDurationLimitOrBuilder() {
            if (this.routeDurationLimitBuilder_ != null) {
                return (DurationLimitOrBuilder)this.routeDurationLimitBuilder_.getMessageOrBuilder();
            }
            return this.routeDurationLimit_ == null ? DurationLimit.getDefaultInstance() : this.routeDurationLimit_;
        }

        private SingleFieldBuilderV3<DurationLimit, DurationLimit.Builder, DurationLimitOrBuilder> getRouteDurationLimitFieldBuilder() {
            if (this.routeDurationLimitBuilder_ == null) {
                this.routeDurationLimitBuilder_ = new SingleFieldBuilderV3((AbstractMessage)this.getRouteDurationLimit(), (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.routeDurationLimit_ = null;
            }
            return this.routeDurationLimitBuilder_;
        }

        @Override
        public boolean hasTravelDurationLimit() {
            return (this.bitField0_ & 0x80000) != 0;
        }

        @Override
        public DurationLimit getTravelDurationLimit() {
            if (this.travelDurationLimitBuilder_ == null) {
                return this.travelDurationLimit_ == null ? DurationLimit.getDefaultInstance() : this.travelDurationLimit_;
            }
            return (DurationLimit)this.travelDurationLimitBuilder_.getMessage();
        }

        public Builder setTravelDurationLimit(DurationLimit value) {
            if (this.travelDurationLimitBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.travelDurationLimit_ = value;
            } else {
                this.travelDurationLimitBuilder_.setMessage((AbstractMessage)value);
            }
            this.bitField0_ |= 0x80000;
            this.onChanged();
            return this;
        }

        public Builder setTravelDurationLimit(DurationLimit.Builder builderForValue) {
            if (this.travelDurationLimitBuilder_ == null) {
                this.travelDurationLimit_ = builderForValue.build();
            } else {
                this.travelDurationLimitBuilder_.setMessage((AbstractMessage)builderForValue.build());
            }
            this.bitField0_ |= 0x80000;
            this.onChanged();
            return this;
        }

        public Builder mergeTravelDurationLimit(DurationLimit value) {
            if (this.travelDurationLimitBuilder_ == null) {
                if ((this.bitField0_ & 0x80000) != 0 && this.travelDurationLimit_ != null && this.travelDurationLimit_ != DurationLimit.getDefaultInstance()) {
                    this.getTravelDurationLimitBuilder().mergeFrom(value);
                } else {
                    this.travelDurationLimit_ = value;
                }
            } else {
                this.travelDurationLimitBuilder_.mergeFrom((AbstractMessage)value);
            }
            if (this.travelDurationLimit_ != null) {
                this.bitField0_ |= 0x80000;
                this.onChanged();
            }
            return this;
        }

        public Builder clearTravelDurationLimit() {
            this.bitField0_ &= 0xFFF7FFFF;
            this.travelDurationLimit_ = null;
            if (this.travelDurationLimitBuilder_ != null) {
                this.travelDurationLimitBuilder_.dispose();
                this.travelDurationLimitBuilder_ = null;
            }
            this.onChanged();
            return this;
        }

        public DurationLimit.Builder getTravelDurationLimitBuilder() {
            this.bitField0_ |= 0x80000;
            this.onChanged();
            return (DurationLimit.Builder)this.getTravelDurationLimitFieldBuilder().getBuilder();
        }

        @Override
        public DurationLimitOrBuilder getTravelDurationLimitOrBuilder() {
            if (this.travelDurationLimitBuilder_ != null) {
                return (DurationLimitOrBuilder)this.travelDurationLimitBuilder_.getMessageOrBuilder();
            }
            return this.travelDurationLimit_ == null ? DurationLimit.getDefaultInstance() : this.travelDurationLimit_;
        }

        private SingleFieldBuilderV3<DurationLimit, DurationLimit.Builder, DurationLimitOrBuilder> getTravelDurationLimitFieldBuilder() {
            if (this.travelDurationLimitBuilder_ == null) {
                this.travelDurationLimitBuilder_ = new SingleFieldBuilderV3((AbstractMessage)this.getTravelDurationLimit(), (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.travelDurationLimit_ = null;
            }
            return this.travelDurationLimitBuilder_;
        }

        @Override
        public boolean hasRouteDistanceLimit() {
            return (this.bitField0_ & 0x100000) != 0;
        }

        @Override
        public DistanceLimit getRouteDistanceLimit() {
            if (this.routeDistanceLimitBuilder_ == null) {
                return this.routeDistanceLimit_ == null ? DistanceLimit.getDefaultInstance() : this.routeDistanceLimit_;
            }
            return (DistanceLimit)this.routeDistanceLimitBuilder_.getMessage();
        }

        public Builder setRouteDistanceLimit(DistanceLimit value) {
            if (this.routeDistanceLimitBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.routeDistanceLimit_ = value;
            } else {
                this.routeDistanceLimitBuilder_.setMessage((AbstractMessage)value);
            }
            this.bitField0_ |= 0x100000;
            this.onChanged();
            return this;
        }

        public Builder setRouteDistanceLimit(DistanceLimit.Builder builderForValue) {
            if (this.routeDistanceLimitBuilder_ == null) {
                this.routeDistanceLimit_ = builderForValue.build();
            } else {
                this.routeDistanceLimitBuilder_.setMessage((AbstractMessage)builderForValue.build());
            }
            this.bitField0_ |= 0x100000;
            this.onChanged();
            return this;
        }

        public Builder mergeRouteDistanceLimit(DistanceLimit value) {
            if (this.routeDistanceLimitBuilder_ == null) {
                if ((this.bitField0_ & 0x100000) != 0 && this.routeDistanceLimit_ != null && this.routeDistanceLimit_ != DistanceLimit.getDefaultInstance()) {
                    this.getRouteDistanceLimitBuilder().mergeFrom(value);
                } else {
                    this.routeDistanceLimit_ = value;
                }
            } else {
                this.routeDistanceLimitBuilder_.mergeFrom((AbstractMessage)value);
            }
            if (this.routeDistanceLimit_ != null) {
                this.bitField0_ |= 0x100000;
                this.onChanged();
            }
            return this;
        }

        public Builder clearRouteDistanceLimit() {
            this.bitField0_ &= 0xFFEFFFFF;
            this.routeDistanceLimit_ = null;
            if (this.routeDistanceLimitBuilder_ != null) {
                this.routeDistanceLimitBuilder_.dispose();
                this.routeDistanceLimitBuilder_ = null;
            }
            this.onChanged();
            return this;
        }

        public DistanceLimit.Builder getRouteDistanceLimitBuilder() {
            this.bitField0_ |= 0x100000;
            this.onChanged();
            return (DistanceLimit.Builder)this.getRouteDistanceLimitFieldBuilder().getBuilder();
        }

        @Override
        public DistanceLimitOrBuilder getRouteDistanceLimitOrBuilder() {
            if (this.routeDistanceLimitBuilder_ != null) {
                return (DistanceLimitOrBuilder)this.routeDistanceLimitBuilder_.getMessageOrBuilder();
            }
            return this.routeDistanceLimit_ == null ? DistanceLimit.getDefaultInstance() : this.routeDistanceLimit_;
        }

        private SingleFieldBuilderV3<DistanceLimit, DistanceLimit.Builder, DistanceLimitOrBuilder> getRouteDistanceLimitFieldBuilder() {
            if (this.routeDistanceLimitBuilder_ == null) {
                this.routeDistanceLimitBuilder_ = new SingleFieldBuilderV3((AbstractMessage)this.getRouteDistanceLimit(), (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.routeDistanceLimit_ = null;
            }
            return this.routeDistanceLimitBuilder_;
        }

        private MapFieldBuilder<String, DurationOrBuilder, Duration, Duration.Builder> internalGetExtraVisitDurationForVisitType() {
            if (this.extraVisitDurationForVisitType_ == null) {
                return new MapFieldBuilder((MapFieldBuilder.Converter)extraVisitDurationForVisitTypeConverter);
            }
            return this.extraVisitDurationForVisitType_;
        }

        private MapFieldBuilder<String, DurationOrBuilder, Duration, Duration.Builder> internalGetMutableExtraVisitDurationForVisitType() {
            if (this.extraVisitDurationForVisitType_ == null) {
                this.extraVisitDurationForVisitType_ = new MapFieldBuilder((MapFieldBuilder.Converter)extraVisitDurationForVisitTypeConverter);
            }
            this.bitField0_ |= 0x200000;
            this.onChanged();
            return this.extraVisitDurationForVisitType_;
        }

        @Override
        public int getExtraVisitDurationForVisitTypeCount() {
            return this.internalGetExtraVisitDurationForVisitType().ensureBuilderMap().size();
        }

        @Override
        public boolean containsExtraVisitDurationForVisitType(String key) {
            if (key == null) {
                throw new NullPointerException("map key");
            }
            return this.internalGetExtraVisitDurationForVisitType().ensureBuilderMap().containsKey(key);
        }

        @Override
        @Deprecated
        public Map<String, Duration> getExtraVisitDurationForVisitType() {
            return this.getExtraVisitDurationForVisitTypeMap();
        }

        @Override
        public Map<String, Duration> getExtraVisitDurationForVisitTypeMap() {
            return this.internalGetExtraVisitDurationForVisitType().getImmutableMap();
        }

        @Override
        public Duration getExtraVisitDurationForVisitTypeOrDefault(String key, Duration defaultValue) {
            if (key == null) {
                throw new NullPointerException("map key");
            }
            Map map = this.internalGetMutableExtraVisitDurationForVisitType().ensureBuilderMap();
            return map.containsKey(key) ? extraVisitDurationForVisitTypeConverter.build((DurationOrBuilder)map.get(key)) : defaultValue;
        }

        @Override
        public Duration getExtraVisitDurationForVisitTypeOrThrow(String key) {
            if (key == null) {
                throw new NullPointerException("map key");
            }
            Map map = this.internalGetMutableExtraVisitDurationForVisitType().ensureBuilderMap();
            if (!map.containsKey(key)) {
                throw new IllegalArgumentException();
            }
            return extraVisitDurationForVisitTypeConverter.build((DurationOrBuilder)map.get(key));
        }

        public Builder clearExtraVisitDurationForVisitType() {
            this.bitField0_ &= 0xFFDFFFFF;
            this.internalGetMutableExtraVisitDurationForVisitType().clear();
            return this;
        }

        public Builder removeExtraVisitDurationForVisitType(String key) {
            if (key == null) {
                throw new NullPointerException("map key");
            }
            this.internalGetMutableExtraVisitDurationForVisitType().ensureBuilderMap().remove(key);
            return this;
        }

        @Deprecated
        public Map<String, Duration> getMutableExtraVisitDurationForVisitType() {
            this.bitField0_ |= 0x200000;
            return this.internalGetMutableExtraVisitDurationForVisitType().ensureMessageMap();
        }

        public Builder putExtraVisitDurationForVisitType(String key, Duration value) {
            if (key == null) {
                throw new NullPointerException("map key");
            }
            if (value == null) {
                throw new NullPointerException("map value");
            }
            this.internalGetMutableExtraVisitDurationForVisitType().ensureBuilderMap().put(key, value);
            this.bitField0_ |= 0x200000;
            return this;
        }

        public Builder putAllExtraVisitDurationForVisitType(Map<String, Duration> values) {
            for (Map.Entry<String, Duration> e : values.entrySet()) {
                if (e.getKey() != null && e.getValue() != null) continue;
                throw new NullPointerException();
            }
            this.internalGetMutableExtraVisitDurationForVisitType().ensureBuilderMap().putAll(values);
            this.bitField0_ |= 0x200000;
            return this;
        }

        public Duration.Builder putExtraVisitDurationForVisitTypeBuilderIfAbsent(String key) {
            Map builderMap = this.internalGetMutableExtraVisitDurationForVisitType().ensureBuilderMap();
            DurationOrBuilder entry = (DurationOrBuilder)builderMap.get(key);
            if (entry == null) {
                entry = Duration.newBuilder();
                builderMap.put(key, entry);
            }
            if (entry instanceof Duration) {
                entry = ((Duration)entry).toBuilder();
                builderMap.put(key, entry);
            }
            return (Duration.Builder)entry;
        }

        @Override
        public boolean hasBreakRule() {
            return (this.bitField0_ & 0x400000) != 0;
        }

        @Override
        public BreakRule getBreakRule() {
            if (this.breakRuleBuilder_ == null) {
                return this.breakRule_ == null ? BreakRule.getDefaultInstance() : this.breakRule_;
            }
            return (BreakRule)this.breakRuleBuilder_.getMessage();
        }

        public Builder setBreakRule(BreakRule value) {
            if (this.breakRuleBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.breakRule_ = value;
            } else {
                this.breakRuleBuilder_.setMessage((AbstractMessage)value);
            }
            this.bitField0_ |= 0x400000;
            this.onChanged();
            return this;
        }

        public Builder setBreakRule(BreakRule.Builder builderForValue) {
            if (this.breakRuleBuilder_ == null) {
                this.breakRule_ = builderForValue.build();
            } else {
                this.breakRuleBuilder_.setMessage((AbstractMessage)builderForValue.build());
            }
            this.bitField0_ |= 0x400000;
            this.onChanged();
            return this;
        }

        public Builder mergeBreakRule(BreakRule value) {
            if (this.breakRuleBuilder_ == null) {
                if ((this.bitField0_ & 0x400000) != 0 && this.breakRule_ != null && this.breakRule_ != BreakRule.getDefaultInstance()) {
                    this.getBreakRuleBuilder().mergeFrom(value);
                } else {
                    this.breakRule_ = value;
                }
            } else {
                this.breakRuleBuilder_.mergeFrom((AbstractMessage)value);
            }
            if (this.breakRule_ != null) {
                this.bitField0_ |= 0x400000;
                this.onChanged();
            }
            return this;
        }

        public Builder clearBreakRule() {
            this.bitField0_ &= 0xFFBFFFFF;
            this.breakRule_ = null;
            if (this.breakRuleBuilder_ != null) {
                this.breakRuleBuilder_.dispose();
                this.breakRuleBuilder_ = null;
            }
            this.onChanged();
            return this;
        }

        public BreakRule.Builder getBreakRuleBuilder() {
            this.bitField0_ |= 0x400000;
            this.onChanged();
            return (BreakRule.Builder)this.getBreakRuleFieldBuilder().getBuilder();
        }

        @Override
        public BreakRuleOrBuilder getBreakRuleOrBuilder() {
            if (this.breakRuleBuilder_ != null) {
                return (BreakRuleOrBuilder)this.breakRuleBuilder_.getMessageOrBuilder();
            }
            return this.breakRule_ == null ? BreakRule.getDefaultInstance() : this.breakRule_;
        }

        private SingleFieldBuilderV3<BreakRule, BreakRule.Builder, BreakRuleOrBuilder> getBreakRuleFieldBuilder() {
            if (this.breakRuleBuilder_ == null) {
                this.breakRuleBuilder_ = new SingleFieldBuilderV3((AbstractMessage)this.getBreakRule(), (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.breakRule_ = null;
            }
            return this.breakRuleBuilder_;
        }

        @Override
        public String getLabel() {
            Object ref = this.label_;
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                this.label_ = s;
                return s;
            }
            return (String)ref;
        }

        @Override
        public ByteString getLabelBytes() {
            Object ref = this.label_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.label_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public Builder setLabel(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.label_ = value;
            this.bitField0_ |= 0x800000;
            this.onChanged();
            return this;
        }

        public Builder clearLabel() {
            this.label_ = Vehicle.getDefaultInstance().getLabel();
            this.bitField0_ &= 0xFF7FFFFF;
            this.onChanged();
            return this;
        }

        public Builder setLabelBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            Vehicle.checkByteStringIsUtf8((ByteString)value);
            this.label_ = value;
            this.bitField0_ |= 0x800000;
            this.onChanged();
            return this;
        }

        @Override
        public boolean getIgnore() {
            return this.ignore_;
        }

        public Builder setIgnore(boolean value) {
            this.ignore_ = value;
            this.bitField0_ |= 0x1000000;
            this.onChanged();
            return this;
        }

        public Builder clearIgnore() {
            this.bitField0_ &= 0xFEFFFFFF;
            this.ignore_ = false;
            this.onChanged();
            return this;
        }

        public final Builder setUnknownFields(UnknownFieldSet unknownFields) {
            return (Builder)super.setUnknownFields(unknownFields);
        }

        public final Builder mergeUnknownFields(UnknownFieldSet unknownFields) {
            return (Builder)super.mergeUnknownFields(unknownFields);
        }

        private static final class ExtraVisitDurationForVisitTypeConverter
        implements MapFieldBuilder.Converter<String, DurationOrBuilder, Duration> {
            private ExtraVisitDurationForVisitTypeConverter() {
            }

            public Duration build(DurationOrBuilder val) {
                if (val instanceof Duration) {
                    return (Duration)val;
                }
                return ((Duration.Builder)val).build();
            }

            public MapEntry<String, Duration> defaultEntry() {
                return ExtraVisitDurationForVisitTypeDefaultEntryHolder.defaultEntry;
            }
        }

        private static final class LoadLimitsConverter
        implements MapFieldBuilder.Converter<String, LoadLimitOrBuilder, LoadLimit> {
            private LoadLimitsConverter() {
            }

            public LoadLimit build(LoadLimitOrBuilder val) {
                if (val instanceof LoadLimit) {
                    return (LoadLimit)val;
                }
                return ((LoadLimit.Builder)val).build();
            }

            public MapEntry<String, LoadLimit> defaultEntry() {
                return LoadLimitsDefaultEntryHolder.defaultEntry;
            }
        }
    }

    private static final class ExtraVisitDurationForVisitTypeDefaultEntryHolder {
        static final MapEntry<String, Duration> defaultEntry = MapEntry.newDefaultInstance((Descriptors.Descriptor)RouteOptimizationServiceProto.internal_static_google_maps_routeoptimization_v1_Vehicle_ExtraVisitDurationForVisitTypeEntry_descriptor, (WireFormat.FieldType)WireFormat.FieldType.STRING, (Object)"", (WireFormat.FieldType)WireFormat.FieldType.MESSAGE, (Object)Duration.getDefaultInstance());

        private ExtraVisitDurationForVisitTypeDefaultEntryHolder() {
        }
    }

    private static final class LoadLimitsDefaultEntryHolder {
        static final MapEntry<String, LoadLimit> defaultEntry = MapEntry.newDefaultInstance((Descriptors.Descriptor)RouteOptimizationServiceProto.internal_static_google_maps_routeoptimization_v1_Vehicle_LoadLimitsEntry_descriptor, (WireFormat.FieldType)WireFormat.FieldType.STRING, (Object)"", (WireFormat.FieldType)WireFormat.FieldType.MESSAGE, (Object)LoadLimit.getDefaultInstance());

        private LoadLimitsDefaultEntryHolder() {
        }
    }

    public static final class DurationLimit
    extends GeneratedMessageV3
    implements DurationLimitOrBuilder {
        private static final long serialVersionUID = 0L;
        private int bitField0_;
        public static final int MAX_DURATION_FIELD_NUMBER = 1;
        private Duration maxDuration_;
        public static final int SOFT_MAX_DURATION_FIELD_NUMBER = 2;
        private Duration softMaxDuration_;
        public static final int COST_PER_HOUR_AFTER_SOFT_MAX_FIELD_NUMBER = 3;
        private double costPerHourAfterSoftMax_ = 0.0;
        public static final int QUADRATIC_SOFT_MAX_DURATION_FIELD_NUMBER = 4;
        private Duration quadraticSoftMaxDuration_;
        public static final int COST_PER_SQUARE_HOUR_AFTER_QUADRATIC_SOFT_MAX_FIELD_NUMBER = 5;
        private double costPerSquareHourAfterQuadraticSoftMax_ = 0.0;
        private byte memoizedIsInitialized = (byte)-1;
        private static final DurationLimit DEFAULT_INSTANCE = new DurationLimit();
        private static final Parser<DurationLimit> PARSER = new AbstractParser<DurationLimit>(){

            public DurationLimit parsePartialFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
                Builder builder = DurationLimit.newBuilder();
                try {
                    builder.mergeFrom(input, extensionRegistry);
                }
                catch (InvalidProtocolBufferException e) {
                    throw e.setUnfinishedMessage((MessageLite)builder.buildPartial());
                }
                catch (UninitializedMessageException e) {
                    throw e.asInvalidProtocolBufferException().setUnfinishedMessage((MessageLite)builder.buildPartial());
                }
                catch (IOException e) {
                    throw new InvalidProtocolBufferException(e).setUnfinishedMessage((MessageLite)builder.buildPartial());
                }
                return builder.buildPartial();
            }
        };

        private DurationLimit(GeneratedMessageV3.Builder<?> builder) {
            super(builder);
        }

        private DurationLimit() {
        }

        protected Object newInstance(GeneratedMessageV3.UnusedPrivateParameter unused) {
            return new DurationLimit();
        }

        public static final Descriptors.Descriptor getDescriptor() {
            return RouteOptimizationServiceProto.internal_static_google_maps_routeoptimization_v1_Vehicle_DurationLimit_descriptor;
        }

        protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
            return RouteOptimizationServiceProto.internal_static_google_maps_routeoptimization_v1_Vehicle_DurationLimit_fieldAccessorTable.ensureFieldAccessorsInitialized(DurationLimit.class, Builder.class);
        }

        @Override
        public boolean hasMaxDuration() {
            return (this.bitField0_ & 1) != 0;
        }

        @Override
        public Duration getMaxDuration() {
            return this.maxDuration_ == null ? Duration.getDefaultInstance() : this.maxDuration_;
        }

        @Override
        public DurationOrBuilder getMaxDurationOrBuilder() {
            return this.maxDuration_ == null ? Duration.getDefaultInstance() : this.maxDuration_;
        }

        @Override
        public boolean hasSoftMaxDuration() {
            return (this.bitField0_ & 2) != 0;
        }

        @Override
        public Duration getSoftMaxDuration() {
            return this.softMaxDuration_ == null ? Duration.getDefaultInstance() : this.softMaxDuration_;
        }

        @Override
        public DurationOrBuilder getSoftMaxDurationOrBuilder() {
            return this.softMaxDuration_ == null ? Duration.getDefaultInstance() : this.softMaxDuration_;
        }

        @Override
        public boolean hasCostPerHourAfterSoftMax() {
            return (this.bitField0_ & 4) != 0;
        }

        @Override
        public double getCostPerHourAfterSoftMax() {
            return this.costPerHourAfterSoftMax_;
        }

        @Override
        public boolean hasQuadraticSoftMaxDuration() {
            return (this.bitField0_ & 8) != 0;
        }

        @Override
        public Duration getQuadraticSoftMaxDuration() {
            return this.quadraticSoftMaxDuration_ == null ? Duration.getDefaultInstance() : this.quadraticSoftMaxDuration_;
        }

        @Override
        public DurationOrBuilder getQuadraticSoftMaxDurationOrBuilder() {
            return this.quadraticSoftMaxDuration_ == null ? Duration.getDefaultInstance() : this.quadraticSoftMaxDuration_;
        }

        @Override
        public boolean hasCostPerSquareHourAfterQuadraticSoftMax() {
            return (this.bitField0_ & 0x10) != 0;
        }

        @Override
        public double getCostPerSquareHourAfterQuadraticSoftMax() {
            return this.costPerSquareHourAfterQuadraticSoftMax_;
        }

        public final boolean isInitialized() {
            byte isInitialized = this.memoizedIsInitialized;
            if (isInitialized == 1) {
                return true;
            }
            if (isInitialized == 0) {
                return false;
            }
            this.memoizedIsInitialized = 1;
            return true;
        }

        public void writeTo(CodedOutputStream output) throws IOException {
            if ((this.bitField0_ & 1) != 0) {
                output.writeMessage(1, (MessageLite)this.getMaxDuration());
            }
            if ((this.bitField0_ & 2) != 0) {
                output.writeMessage(2, (MessageLite)this.getSoftMaxDuration());
            }
            if ((this.bitField0_ & 4) != 0) {
                output.writeDouble(3, this.costPerHourAfterSoftMax_);
            }
            if ((this.bitField0_ & 8) != 0) {
                output.writeMessage(4, (MessageLite)this.getQuadraticSoftMaxDuration());
            }
            if ((this.bitField0_ & 0x10) != 0) {
                output.writeDouble(5, this.costPerSquareHourAfterQuadraticSoftMax_);
            }
            this.getUnknownFields().writeTo(output);
        }

        public int getSerializedSize() {
            int size = this.memoizedSize;
            if (size != -1) {
                return size;
            }
            size = 0;
            if ((this.bitField0_ & 1) != 0) {
                size += CodedOutputStream.computeMessageSize((int)1, (MessageLite)this.getMaxDuration());
            }
            if ((this.bitField0_ & 2) != 0) {
                size += CodedOutputStream.computeMessageSize((int)2, (MessageLite)this.getSoftMaxDuration());
            }
            if ((this.bitField0_ & 4) != 0) {
                size += CodedOutputStream.computeDoubleSize((int)3, (double)this.costPerHourAfterSoftMax_);
            }
            if ((this.bitField0_ & 8) != 0) {
                size += CodedOutputStream.computeMessageSize((int)4, (MessageLite)this.getQuadraticSoftMaxDuration());
            }
            if ((this.bitField0_ & 0x10) != 0) {
                size += CodedOutputStream.computeDoubleSize((int)5, (double)this.costPerSquareHourAfterQuadraticSoftMax_);
            }
            this.memoizedSize = size += this.getUnknownFields().getSerializedSize();
            return size;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof DurationLimit)) {
                return super.equals(obj);
            }
            DurationLimit other = (DurationLimit)obj;
            if (this.hasMaxDuration() != other.hasMaxDuration()) {
                return false;
            }
            if (this.hasMaxDuration() && !this.getMaxDuration().equals((Object)other.getMaxDuration())) {
                return false;
            }
            if (this.hasSoftMaxDuration() != other.hasSoftMaxDuration()) {
                return false;
            }
            if (this.hasSoftMaxDuration() && !this.getSoftMaxDuration().equals((Object)other.getSoftMaxDuration())) {
                return false;
            }
            if (this.hasCostPerHourAfterSoftMax() != other.hasCostPerHourAfterSoftMax()) {
                return false;
            }
            if (this.hasCostPerHourAfterSoftMax() && Double.doubleToLongBits(this.getCostPerHourAfterSoftMax()) != Double.doubleToLongBits(other.getCostPerHourAfterSoftMax())) {
                return false;
            }
            if (this.hasQuadraticSoftMaxDuration() != other.hasQuadraticSoftMaxDuration()) {
                return false;
            }
            if (this.hasQuadraticSoftMaxDuration() && !this.getQuadraticSoftMaxDuration().equals((Object)other.getQuadraticSoftMaxDuration())) {
                return false;
            }
            if (this.hasCostPerSquareHourAfterQuadraticSoftMax() != other.hasCostPerSquareHourAfterQuadraticSoftMax()) {
                return false;
            }
            if (this.hasCostPerSquareHourAfterQuadraticSoftMax() && Double.doubleToLongBits(this.getCostPerSquareHourAfterQuadraticSoftMax()) != Double.doubleToLongBits(other.getCostPerSquareHourAfterQuadraticSoftMax())) {
                return false;
            }
            return this.getUnknownFields().equals((Object)other.getUnknownFields());
        }

        public int hashCode() {
            if (this.memoizedHashCode != 0) {
                return this.memoizedHashCode;
            }
            int hash = 41;
            hash = 19 * hash + DurationLimit.getDescriptor().hashCode();
            if (this.hasMaxDuration()) {
                hash = 37 * hash + 1;
                hash = 53 * hash + this.getMaxDuration().hashCode();
            }
            if (this.hasSoftMaxDuration()) {
                hash = 37 * hash + 2;
                hash = 53 * hash + this.getSoftMaxDuration().hashCode();
            }
            if (this.hasCostPerHourAfterSoftMax()) {
                hash = 37 * hash + 3;
                hash = 53 * hash + Internal.hashLong((long)Double.doubleToLongBits(this.getCostPerHourAfterSoftMax()));
            }
            if (this.hasQuadraticSoftMaxDuration()) {
                hash = 37 * hash + 4;
                hash = 53 * hash + this.getQuadraticSoftMaxDuration().hashCode();
            }
            if (this.hasCostPerSquareHourAfterQuadraticSoftMax()) {
                hash = 37 * hash + 5;
                hash = 53 * hash + Internal.hashLong((long)Double.doubleToLongBits(this.getCostPerSquareHourAfterQuadraticSoftMax()));
            }
            this.memoizedHashCode = hash = 29 * hash + this.getUnknownFields().hashCode();
            return hash;
        }

        public static DurationLimit parseFrom(ByteBuffer data) throws InvalidProtocolBufferException {
            return (DurationLimit)PARSER.parseFrom(data);
        }

        public static DurationLimit parseFrom(ByteBuffer data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            return (DurationLimit)PARSER.parseFrom(data, extensionRegistry);
        }

        public static DurationLimit parseFrom(ByteString data) throws InvalidProtocolBufferException {
            return (DurationLimit)PARSER.parseFrom(data);
        }

        public static DurationLimit parseFrom(ByteString data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            return (DurationLimit)PARSER.parseFrom(data, extensionRegistry);
        }

        public static DurationLimit parseFrom(byte[] data) throws InvalidProtocolBufferException {
            return (DurationLimit)PARSER.parseFrom(data);
        }

        public static DurationLimit parseFrom(byte[] data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            return (DurationLimit)PARSER.parseFrom(data, extensionRegistry);
        }

        public static DurationLimit parseFrom(InputStream input) throws IOException {
            return (DurationLimit)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input);
        }

        public static DurationLimit parseFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            return (DurationLimit)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
        }

        public static DurationLimit parseDelimitedFrom(InputStream input) throws IOException {
            return (DurationLimit)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input);
        }

        public static DurationLimit parseDelimitedFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            return (DurationLimit)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
        }

        public static DurationLimit parseFrom(CodedInputStream input) throws IOException {
            return (DurationLimit)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input);
        }

        public static DurationLimit parseFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            return (DurationLimit)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input, (ExtensionRegistryLite)extensionRegistry);
        }

        public Builder newBuilderForType() {
            return DurationLimit.newBuilder();
        }

        public static Builder newBuilder() {
            return DEFAULT_INSTANCE.toBuilder();
        }

        public static Builder newBuilder(DurationLimit prototype) {
            return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
        }

        public Builder toBuilder() {
            return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
        }

        protected Builder newBuilderForType(GeneratedMessageV3.BuilderParent parent) {
            Builder builder = new Builder(parent);
            return builder;
        }

        public static DurationLimit getDefaultInstance() {
            return DEFAULT_INSTANCE;
        }

        public static Parser<DurationLimit> parser() {
            return PARSER;
        }

        public Parser<DurationLimit> getParserForType() {
            return PARSER;
        }

        public DurationLimit getDefaultInstanceForType() {
            return DEFAULT_INSTANCE;
        }

        public static final class Builder
        extends GeneratedMessageV3.Builder<Builder>
        implements DurationLimitOrBuilder {
            private int bitField0_;
            private Duration maxDuration_;
            private SingleFieldBuilderV3<Duration, Duration.Builder, DurationOrBuilder> maxDurationBuilder_;
            private Duration softMaxDuration_;
            private SingleFieldBuilderV3<Duration, Duration.Builder, DurationOrBuilder> softMaxDurationBuilder_;
            private double costPerHourAfterSoftMax_;
            private Duration quadraticSoftMaxDuration_;
            private SingleFieldBuilderV3<Duration, Duration.Builder, DurationOrBuilder> quadraticSoftMaxDurationBuilder_;
            private double costPerSquareHourAfterQuadraticSoftMax_;

            public static final Descriptors.Descriptor getDescriptor() {
                return RouteOptimizationServiceProto.internal_static_google_maps_routeoptimization_v1_Vehicle_DurationLimit_descriptor;
            }

            protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
                return RouteOptimizationServiceProto.internal_static_google_maps_routeoptimization_v1_Vehicle_DurationLimit_fieldAccessorTable.ensureFieldAccessorsInitialized(DurationLimit.class, Builder.class);
            }

            private Builder() {
                this.maybeForceBuilderInitialization();
            }

            private Builder(GeneratedMessageV3.BuilderParent parent) {
                super(parent);
                this.maybeForceBuilderInitialization();
            }

            private void maybeForceBuilderInitialization() {
                if (alwaysUseFieldBuilders) {
                    this.getMaxDurationFieldBuilder();
                    this.getSoftMaxDurationFieldBuilder();
                    this.getQuadraticSoftMaxDurationFieldBuilder();
                }
            }

            public Builder clear() {
                super.clear();
                this.bitField0_ = 0;
                this.maxDuration_ = null;
                if (this.maxDurationBuilder_ != null) {
                    this.maxDurationBuilder_.dispose();
                    this.maxDurationBuilder_ = null;
                }
                this.softMaxDuration_ = null;
                if (this.softMaxDurationBuilder_ != null) {
                    this.softMaxDurationBuilder_.dispose();
                    this.softMaxDurationBuilder_ = null;
                }
                this.costPerHourAfterSoftMax_ = 0.0;
                this.quadraticSoftMaxDuration_ = null;
                if (this.quadraticSoftMaxDurationBuilder_ != null) {
                    this.quadraticSoftMaxDurationBuilder_.dispose();
                    this.quadraticSoftMaxDurationBuilder_ = null;
                }
                this.costPerSquareHourAfterQuadraticSoftMax_ = 0.0;
                return this;
            }

            public Descriptors.Descriptor getDescriptorForType() {
                return RouteOptimizationServiceProto.internal_static_google_maps_routeoptimization_v1_Vehicle_DurationLimit_descriptor;
            }

            public DurationLimit getDefaultInstanceForType() {
                return DurationLimit.getDefaultInstance();
            }

            public DurationLimit build() {
                DurationLimit result = this.buildPartial();
                if (!result.isInitialized()) {
                    throw Builder.newUninitializedMessageException((Message)result);
                }
                return result;
            }

            public DurationLimit buildPartial() {
                DurationLimit result = new DurationLimit(this);
                if (this.bitField0_ != 0) {
                    this.buildPartial0(result);
                }
                this.onBuilt();
                return result;
            }

            private void buildPartial0(DurationLimit result) {
                int from_bitField0_ = this.bitField0_;
                int to_bitField0_ = 0;
                if ((from_bitField0_ & 1) != 0) {
                    result.maxDuration_ = this.maxDurationBuilder_ == null ? this.maxDuration_ : (Duration)this.maxDurationBuilder_.build();
                    to_bitField0_ |= 1;
                }
                if ((from_bitField0_ & 2) != 0) {
                    result.softMaxDuration_ = this.softMaxDurationBuilder_ == null ? this.softMaxDuration_ : (Duration)this.softMaxDurationBuilder_.build();
                    to_bitField0_ |= 2;
                }
                if ((from_bitField0_ & 4) != 0) {
                    result.costPerHourAfterSoftMax_ = this.costPerHourAfterSoftMax_;
                    to_bitField0_ |= 4;
                }
                if ((from_bitField0_ & 8) != 0) {
                    result.quadraticSoftMaxDuration_ = this.quadraticSoftMaxDurationBuilder_ == null ? this.quadraticSoftMaxDuration_ : (Duration)this.quadraticSoftMaxDurationBuilder_.build();
                    to_bitField0_ |= 8;
                }
                if ((from_bitField0_ & 0x10) != 0) {
                    result.costPerSquareHourAfterQuadraticSoftMax_ = this.costPerSquareHourAfterQuadraticSoftMax_;
                    to_bitField0_ |= 0x10;
                }
                DurationLimit durationLimit = result;
                durationLimit.bitField0_ = durationLimit.bitField0_ | to_bitField0_;
            }

            public Builder clone() {
                return (Builder)super.clone();
            }

            public Builder setField(Descriptors.FieldDescriptor field, Object value) {
                return (Builder)super.setField(field, value);
            }

            public Builder clearField(Descriptors.FieldDescriptor field) {
                return (Builder)super.clearField(field);
            }

            public Builder clearOneof(Descriptors.OneofDescriptor oneof) {
                return (Builder)super.clearOneof(oneof);
            }

            public Builder setRepeatedField(Descriptors.FieldDescriptor field, int index, Object value) {
                return (Builder)super.setRepeatedField(field, index, value);
            }

            public Builder addRepeatedField(Descriptors.FieldDescriptor field, Object value) {
                return (Builder)super.addRepeatedField(field, value);
            }

            public Builder mergeFrom(Message other) {
                if (other instanceof DurationLimit) {
                    return this.mergeFrom((DurationLimit)other);
                }
                super.mergeFrom(other);
                return this;
            }

            public Builder mergeFrom(DurationLimit other) {
                if (other == DurationLimit.getDefaultInstance()) {
                    return this;
                }
                if (other.hasMaxDuration()) {
                    this.mergeMaxDuration(other.getMaxDuration());
                }
                if (other.hasSoftMaxDuration()) {
                    this.mergeSoftMaxDuration(other.getSoftMaxDuration());
                }
                if (other.hasCostPerHourAfterSoftMax()) {
                    this.setCostPerHourAfterSoftMax(other.getCostPerHourAfterSoftMax());
                }
                if (other.hasQuadraticSoftMaxDuration()) {
                    this.mergeQuadraticSoftMaxDuration(other.getQuadraticSoftMaxDuration());
                }
                if (other.hasCostPerSquareHourAfterQuadraticSoftMax()) {
                    this.setCostPerSquareHourAfterQuadraticSoftMax(other.getCostPerSquareHourAfterQuadraticSoftMax());
                }
                this.mergeUnknownFields(other.getUnknownFields());
                this.onChanged();
                return this;
            }

            public final boolean isInitialized() {
                return true;
            }

            public Builder mergeFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
                if (extensionRegistry == null) {
                    throw new NullPointerException();
                }
                try {
                    boolean done = false;
                    block13: while (!done) {
                        int tag = input.readTag();
                        switch (tag) {
                            case 0: {
                                done = true;
                                continue block13;
                            }
                            case 10: {
                                input.readMessage((MessageLite.Builder)this.getMaxDurationFieldBuilder().getBuilder(), extensionRegistry);
                                this.bitField0_ |= 1;
                                continue block13;
                            }
                            case 18: {
                                input.readMessage((MessageLite.Builder)this.getSoftMaxDurationFieldBuilder().getBuilder(), extensionRegistry);
                                this.bitField0_ |= 2;
                                continue block13;
                            }
                            case 25: {
                                this.costPerHourAfterSoftMax_ = input.readDouble();
                                this.bitField0_ |= 4;
                                continue block13;
                            }
                            case 34: {
                                input.readMessage((MessageLite.Builder)this.getQuadraticSoftMaxDurationFieldBuilder().getBuilder(), extensionRegistry);
                                this.bitField0_ |= 8;
                                continue block13;
                            }
                            case 41: {
                                this.costPerSquareHourAfterQuadraticSoftMax_ = input.readDouble();
                                this.bitField0_ |= 0x10;
                                continue block13;
                            }
                        }
                        if (super.parseUnknownField(input, extensionRegistry, tag)) continue;
                        done = true;
                    }
                }
                catch (InvalidProtocolBufferException e) {
                    throw e.unwrapIOException();
                }
                finally {
                    this.onChanged();
                }
                return this;
            }

            @Override
            public boolean hasMaxDuration() {
                return (this.bitField0_ & 1) != 0;
            }

            @Override
            public Duration getMaxDuration() {
                if (this.maxDurationBuilder_ == null) {
                    return this.maxDuration_ == null ? Duration.getDefaultInstance() : this.maxDuration_;
                }
                return (Duration)this.maxDurationBuilder_.getMessage();
            }

            public Builder setMaxDuration(Duration value) {
                if (this.maxDurationBuilder_ == null) {
                    if (value == null) {
                        throw new NullPointerException();
                    }
                    this.maxDuration_ = value;
                } else {
                    this.maxDurationBuilder_.setMessage((AbstractMessage)value);
                }
                this.bitField0_ |= 1;
                this.onChanged();
                return this;
            }

            public Builder setMaxDuration(Duration.Builder builderForValue) {
                if (this.maxDurationBuilder_ == null) {
                    this.maxDuration_ = builderForValue.build();
                } else {
                    this.maxDurationBuilder_.setMessage((AbstractMessage)builderForValue.build());
                }
                this.bitField0_ |= 1;
                this.onChanged();
                return this;
            }

            public Builder mergeMaxDuration(Duration value) {
                if (this.maxDurationBuilder_ == null) {
                    if ((this.bitField0_ & 1) != 0 && this.maxDuration_ != null && this.maxDuration_ != Duration.getDefaultInstance()) {
                        this.getMaxDurationBuilder().mergeFrom(value);
                    } else {
                        this.maxDuration_ = value;
                    }
                } else {
                    this.maxDurationBuilder_.mergeFrom((AbstractMessage)value);
                }
                if (this.maxDuration_ != null) {
                    this.bitField0_ |= 1;
                    this.onChanged();
                }
                return this;
            }

            public Builder clearMaxDuration() {
                this.bitField0_ &= 0xFFFFFFFE;
                this.maxDuration_ = null;
                if (this.maxDurationBuilder_ != null) {
                    this.maxDurationBuilder_.dispose();
                    this.maxDurationBuilder_ = null;
                }
                this.onChanged();
                return this;
            }

            public Duration.Builder getMaxDurationBuilder() {
                this.bitField0_ |= 1;
                this.onChanged();
                return (Duration.Builder)this.getMaxDurationFieldBuilder().getBuilder();
            }

            @Override
            public DurationOrBuilder getMaxDurationOrBuilder() {
                if (this.maxDurationBuilder_ != null) {
                    return (DurationOrBuilder)this.maxDurationBuilder_.getMessageOrBuilder();
                }
                return this.maxDuration_ == null ? Duration.getDefaultInstance() : this.maxDuration_;
            }

            private SingleFieldBuilderV3<Duration, Duration.Builder, DurationOrBuilder> getMaxDurationFieldBuilder() {
                if (this.maxDurationBuilder_ == null) {
                    this.maxDurationBuilder_ = new SingleFieldBuilderV3((AbstractMessage)this.getMaxDuration(), (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                    this.maxDuration_ = null;
                }
                return this.maxDurationBuilder_;
            }

            @Override
            public boolean hasSoftMaxDuration() {
                return (this.bitField0_ & 2) != 0;
            }

            @Override
            public Duration getSoftMaxDuration() {
                if (this.softMaxDurationBuilder_ == null) {
                    return this.softMaxDuration_ == null ? Duration.getDefaultInstance() : this.softMaxDuration_;
                }
                return (Duration)this.softMaxDurationBuilder_.getMessage();
            }

            public Builder setSoftMaxDuration(Duration value) {
                if (this.softMaxDurationBuilder_ == null) {
                    if (value == null) {
                        throw new NullPointerException();
                    }
                    this.softMaxDuration_ = value;
                } else {
                    this.softMaxDurationBuilder_.setMessage((AbstractMessage)value);
                }
                this.bitField0_ |= 2;
                this.onChanged();
                return this;
            }

            public Builder setSoftMaxDuration(Duration.Builder builderForValue) {
                if (this.softMaxDurationBuilder_ == null) {
                    this.softMaxDuration_ = builderForValue.build();
                } else {
                    this.softMaxDurationBuilder_.setMessage((AbstractMessage)builderForValue.build());
                }
                this.bitField0_ |= 2;
                this.onChanged();
                return this;
            }

            public Builder mergeSoftMaxDuration(Duration value) {
                if (this.softMaxDurationBuilder_ == null) {
                    if ((this.bitField0_ & 2) != 0 && this.softMaxDuration_ != null && this.softMaxDuration_ != Duration.getDefaultInstance()) {
                        this.getSoftMaxDurationBuilder().mergeFrom(value);
                    } else {
                        this.softMaxDuration_ = value;
                    }
                } else {
                    this.softMaxDurationBuilder_.mergeFrom((AbstractMessage)value);
                }
                if (this.softMaxDuration_ != null) {
                    this.bitField0_ |= 2;
                    this.onChanged();
                }
                return this;
            }

            public Builder clearSoftMaxDuration() {
                this.bitField0_ &= 0xFFFFFFFD;
                this.softMaxDuration_ = null;
                if (this.softMaxDurationBuilder_ != null) {
                    this.softMaxDurationBuilder_.dispose();
                    this.softMaxDurationBuilder_ = null;
                }
                this.onChanged();
                return this;
            }

            public Duration.Builder getSoftMaxDurationBuilder() {
                this.bitField0_ |= 2;
                this.onChanged();
                return (Duration.Builder)this.getSoftMaxDurationFieldBuilder().getBuilder();
            }

            @Override
            public DurationOrBuilder getSoftMaxDurationOrBuilder() {
                if (this.softMaxDurationBuilder_ != null) {
                    return (DurationOrBuilder)this.softMaxDurationBuilder_.getMessageOrBuilder();
                }
                return this.softMaxDuration_ == null ? Duration.getDefaultInstance() : this.softMaxDuration_;
            }

            private SingleFieldBuilderV3<Duration, Duration.Builder, DurationOrBuilder> getSoftMaxDurationFieldBuilder() {
                if (this.softMaxDurationBuilder_ == null) {
                    this.softMaxDurationBuilder_ = new SingleFieldBuilderV3((AbstractMessage)this.getSoftMaxDuration(), (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                    this.softMaxDuration_ = null;
                }
                return this.softMaxDurationBuilder_;
            }

            @Override
            public boolean hasCostPerHourAfterSoftMax() {
                return (this.bitField0_ & 4) != 0;
            }

            @Override
            public double getCostPerHourAfterSoftMax() {
                return this.costPerHourAfterSoftMax_;
            }

            public Builder setCostPerHourAfterSoftMax(double value) {
                this.costPerHourAfterSoftMax_ = value;
                this.bitField0_ |= 4;
                this.onChanged();
                return this;
            }

            public Builder clearCostPerHourAfterSoftMax() {
                this.bitField0_ &= 0xFFFFFFFB;
                this.costPerHourAfterSoftMax_ = 0.0;
                this.onChanged();
                return this;
            }

            @Override
            public boolean hasQuadraticSoftMaxDuration() {
                return (this.bitField0_ & 8) != 0;
            }

            @Override
            public Duration getQuadraticSoftMaxDuration() {
                if (this.quadraticSoftMaxDurationBuilder_ == null) {
                    return this.quadraticSoftMaxDuration_ == null ? Duration.getDefaultInstance() : this.quadraticSoftMaxDuration_;
                }
                return (Duration)this.quadraticSoftMaxDurationBuilder_.getMessage();
            }

            public Builder setQuadraticSoftMaxDuration(Duration value) {
                if (this.quadraticSoftMaxDurationBuilder_ == null) {
                    if (value == null) {
                        throw new NullPointerException();
                    }
                    this.quadraticSoftMaxDuration_ = value;
                } else {
                    this.quadraticSoftMaxDurationBuilder_.setMessage((AbstractMessage)value);
                }
                this.bitField0_ |= 8;
                this.onChanged();
                return this;
            }

            public Builder setQuadraticSoftMaxDuration(Duration.Builder builderForValue) {
                if (this.quadraticSoftMaxDurationBuilder_ == null) {
                    this.quadraticSoftMaxDuration_ = builderForValue.build();
                } else {
                    this.quadraticSoftMaxDurationBuilder_.setMessage((AbstractMessage)builderForValue.build());
                }
                this.bitField0_ |= 8;
                this.onChanged();
                return this;
            }

            public Builder mergeQuadraticSoftMaxDuration(Duration value) {
                if (this.quadraticSoftMaxDurationBuilder_ == null) {
                    if ((this.bitField0_ & 8) != 0 && this.quadraticSoftMaxDuration_ != null && this.quadraticSoftMaxDuration_ != Duration.getDefaultInstance()) {
                        this.getQuadraticSoftMaxDurationBuilder().mergeFrom(value);
                    } else {
                        this.quadraticSoftMaxDuration_ = value;
                    }
                } else {
                    this.quadraticSoftMaxDurationBuilder_.mergeFrom((AbstractMessage)value);
                }
                if (this.quadraticSoftMaxDuration_ != null) {
                    this.bitField0_ |= 8;
                    this.onChanged();
                }
                return this;
            }

            public Builder clearQuadraticSoftMaxDuration() {
                this.bitField0_ &= 0xFFFFFFF7;
                this.quadraticSoftMaxDuration_ = null;
                if (this.quadraticSoftMaxDurationBuilder_ != null) {
                    this.quadraticSoftMaxDurationBuilder_.dispose();
                    this.quadraticSoftMaxDurationBuilder_ = null;
                }
                this.onChanged();
                return this;
            }

            public Duration.Builder getQuadraticSoftMaxDurationBuilder() {
                this.bitField0_ |= 8;
                this.onChanged();
                return (Duration.Builder)this.getQuadraticSoftMaxDurationFieldBuilder().getBuilder();
            }

            @Override
            public DurationOrBuilder getQuadraticSoftMaxDurationOrBuilder() {
                if (this.quadraticSoftMaxDurationBuilder_ != null) {
                    return (DurationOrBuilder)this.quadraticSoftMaxDurationBuilder_.getMessageOrBuilder();
                }
                return this.quadraticSoftMaxDuration_ == null ? Duration.getDefaultInstance() : this.quadraticSoftMaxDuration_;
            }

            private SingleFieldBuilderV3<Duration, Duration.Builder, DurationOrBuilder> getQuadraticSoftMaxDurationFieldBuilder() {
                if (this.quadraticSoftMaxDurationBuilder_ == null) {
                    this.quadraticSoftMaxDurationBuilder_ = new SingleFieldBuilderV3((AbstractMessage)this.getQuadraticSoftMaxDuration(), (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                    this.quadraticSoftMaxDuration_ = null;
                }
                return this.quadraticSoftMaxDurationBuilder_;
            }

            @Override
            public boolean hasCostPerSquareHourAfterQuadraticSoftMax() {
                return (this.bitField0_ & 0x10) != 0;
            }

            @Override
            public double getCostPerSquareHourAfterQuadraticSoftMax() {
                return this.costPerSquareHourAfterQuadraticSoftMax_;
            }

            public Builder setCostPerSquareHourAfterQuadraticSoftMax(double value) {
                this.costPerSquareHourAfterQuadraticSoftMax_ = value;
                this.bitField0_ |= 0x10;
                this.onChanged();
                return this;
            }

            public Builder clearCostPerSquareHourAfterQuadraticSoftMax() {
                this.bitField0_ &= 0xFFFFFFEF;
                this.costPerSquareHourAfterQuadraticSoftMax_ = 0.0;
                this.onChanged();
                return this;
            }

            public final Builder setUnknownFields(UnknownFieldSet unknownFields) {
                return (Builder)super.setUnknownFields(unknownFields);
            }

            public final Builder mergeUnknownFields(UnknownFieldSet unknownFields) {
                return (Builder)super.mergeUnknownFields(unknownFields);
            }
        }
    }

    public static interface DurationLimitOrBuilder
    extends MessageOrBuilder {
        public boolean hasMaxDuration();

        public Duration getMaxDuration();

        public DurationOrBuilder getMaxDurationOrBuilder();

        public boolean hasSoftMaxDuration();

        public Duration getSoftMaxDuration();

        public DurationOrBuilder getSoftMaxDurationOrBuilder();

        public boolean hasCostPerHourAfterSoftMax();

        public double getCostPerHourAfterSoftMax();

        public boolean hasQuadraticSoftMaxDuration();

        public Duration getQuadraticSoftMaxDuration();

        public DurationOrBuilder getQuadraticSoftMaxDurationOrBuilder();

        public boolean hasCostPerSquareHourAfterQuadraticSoftMax();

        public double getCostPerSquareHourAfterQuadraticSoftMax();
    }

    public static final class LoadLimit
    extends GeneratedMessageV3
    implements LoadLimitOrBuilder {
        private static final long serialVersionUID = 0L;
        private int bitField0_;
        public static final int MAX_LOAD_FIELD_NUMBER = 1;
        private long maxLoad_ = 0L;
        public static final int SOFT_MAX_LOAD_FIELD_NUMBER = 2;
        private long softMaxLoad_ = 0L;
        public static final int COST_PER_UNIT_ABOVE_SOFT_MAX_FIELD_NUMBER = 3;
        private double costPerUnitAboveSoftMax_ = 0.0;
        public static final int START_LOAD_INTERVAL_FIELD_NUMBER = 4;
        private Interval startLoadInterval_;
        public static final int END_LOAD_INTERVAL_FIELD_NUMBER = 5;
        private Interval endLoadInterval_;
        private byte memoizedIsInitialized = (byte)-1;
        private static final LoadLimit DEFAULT_INSTANCE = new LoadLimit();
        private static final Parser<LoadLimit> PARSER = new AbstractParser<LoadLimit>(){

            public LoadLimit parsePartialFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
                Builder builder = LoadLimit.newBuilder();
                try {
                    builder.mergeFrom(input, extensionRegistry);
                }
                catch (InvalidProtocolBufferException e) {
                    throw e.setUnfinishedMessage((MessageLite)builder.buildPartial());
                }
                catch (UninitializedMessageException e) {
                    throw e.asInvalidProtocolBufferException().setUnfinishedMessage((MessageLite)builder.buildPartial());
                }
                catch (IOException e) {
                    throw new InvalidProtocolBufferException(e).setUnfinishedMessage((MessageLite)builder.buildPartial());
                }
                return builder.buildPartial();
            }
        };

        private LoadLimit(GeneratedMessageV3.Builder<?> builder) {
            super(builder);
        }

        private LoadLimit() {
        }

        protected Object newInstance(GeneratedMessageV3.UnusedPrivateParameter unused) {
            return new LoadLimit();
        }

        public static final Descriptors.Descriptor getDescriptor() {
            return RouteOptimizationServiceProto.internal_static_google_maps_routeoptimization_v1_Vehicle_LoadLimit_descriptor;
        }

        protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
            return RouteOptimizationServiceProto.internal_static_google_maps_routeoptimization_v1_Vehicle_LoadLimit_fieldAccessorTable.ensureFieldAccessorsInitialized(LoadLimit.class, Builder.class);
        }

        @Override
        public boolean hasMaxLoad() {
            return (this.bitField0_ & 1) != 0;
        }

        @Override
        public long getMaxLoad() {
            return this.maxLoad_;
        }

        @Override
        public long getSoftMaxLoad() {
            return this.softMaxLoad_;
        }

        @Override
        public double getCostPerUnitAboveSoftMax() {
            return this.costPerUnitAboveSoftMax_;
        }

        @Override
        public boolean hasStartLoadInterval() {
            return (this.bitField0_ & 2) != 0;
        }

        @Override
        public Interval getStartLoadInterval() {
            return this.startLoadInterval_ == null ? Interval.getDefaultInstance() : this.startLoadInterval_;
        }

        @Override
        public IntervalOrBuilder getStartLoadIntervalOrBuilder() {
            return this.startLoadInterval_ == null ? Interval.getDefaultInstance() : this.startLoadInterval_;
        }

        @Override
        public boolean hasEndLoadInterval() {
            return (this.bitField0_ & 4) != 0;
        }

        @Override
        public Interval getEndLoadInterval() {
            return this.endLoadInterval_ == null ? Interval.getDefaultInstance() : this.endLoadInterval_;
        }

        @Override
        public IntervalOrBuilder getEndLoadIntervalOrBuilder() {
            return this.endLoadInterval_ == null ? Interval.getDefaultInstance() : this.endLoadInterval_;
        }

        public final boolean isInitialized() {
            byte isInitialized = this.memoizedIsInitialized;
            if (isInitialized == 1) {
                return true;
            }
            if (isInitialized == 0) {
                return false;
            }
            this.memoizedIsInitialized = 1;
            return true;
        }

        public void writeTo(CodedOutputStream output) throws IOException {
            if ((this.bitField0_ & 1) != 0) {
                output.writeInt64(1, this.maxLoad_);
            }
            if (this.softMaxLoad_ != 0L) {
                output.writeInt64(2, this.softMaxLoad_);
            }
            if (Double.doubleToRawLongBits(this.costPerUnitAboveSoftMax_) != 0L) {
                output.writeDouble(3, this.costPerUnitAboveSoftMax_);
            }
            if ((this.bitField0_ & 2) != 0) {
                output.writeMessage(4, (MessageLite)this.getStartLoadInterval());
            }
            if ((this.bitField0_ & 4) != 0) {
                output.writeMessage(5, (MessageLite)this.getEndLoadInterval());
            }
            this.getUnknownFields().writeTo(output);
        }

        public int getSerializedSize() {
            int size = this.memoizedSize;
            if (size != -1) {
                return size;
            }
            size = 0;
            if ((this.bitField0_ & 1) != 0) {
                size += CodedOutputStream.computeInt64Size((int)1, (long)this.maxLoad_);
            }
            if (this.softMaxLoad_ != 0L) {
                size += CodedOutputStream.computeInt64Size((int)2, (long)this.softMaxLoad_);
            }
            if (Double.doubleToRawLongBits(this.costPerUnitAboveSoftMax_) != 0L) {
                size += CodedOutputStream.computeDoubleSize((int)3, (double)this.costPerUnitAboveSoftMax_);
            }
            if ((this.bitField0_ & 2) != 0) {
                size += CodedOutputStream.computeMessageSize((int)4, (MessageLite)this.getStartLoadInterval());
            }
            if ((this.bitField0_ & 4) != 0) {
                size += CodedOutputStream.computeMessageSize((int)5, (MessageLite)this.getEndLoadInterval());
            }
            this.memoizedSize = size += this.getUnknownFields().getSerializedSize();
            return size;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof LoadLimit)) {
                return super.equals(obj);
            }
            LoadLimit other = (LoadLimit)obj;
            if (this.hasMaxLoad() != other.hasMaxLoad()) {
                return false;
            }
            if (this.hasMaxLoad() && this.getMaxLoad() != other.getMaxLoad()) {
                return false;
            }
            if (this.getSoftMaxLoad() != other.getSoftMaxLoad()) {
                return false;
            }
            if (Double.doubleToLongBits(this.getCostPerUnitAboveSoftMax()) != Double.doubleToLongBits(other.getCostPerUnitAboveSoftMax())) {
                return false;
            }
            if (this.hasStartLoadInterval() != other.hasStartLoadInterval()) {
                return false;
            }
            if (this.hasStartLoadInterval() && !this.getStartLoadInterval().equals(other.getStartLoadInterval())) {
                return false;
            }
            if (this.hasEndLoadInterval() != other.hasEndLoadInterval()) {
                return false;
            }
            if (this.hasEndLoadInterval() && !this.getEndLoadInterval().equals(other.getEndLoadInterval())) {
                return false;
            }
            return this.getUnknownFields().equals((Object)other.getUnknownFields());
        }

        public int hashCode() {
            if (this.memoizedHashCode != 0) {
                return this.memoizedHashCode;
            }
            int hash = 41;
            hash = 19 * hash + LoadLimit.getDescriptor().hashCode();
            if (this.hasMaxLoad()) {
                hash = 37 * hash + 1;
                hash = 53 * hash + Internal.hashLong((long)this.getMaxLoad());
            }
            hash = 37 * hash + 2;
            hash = 53 * hash + Internal.hashLong((long)this.getSoftMaxLoad());
            hash = 37 * hash + 3;
            hash = 53 * hash + Internal.hashLong((long)Double.doubleToLongBits(this.getCostPerUnitAboveSoftMax()));
            if (this.hasStartLoadInterval()) {
                hash = 37 * hash + 4;
                hash = 53 * hash + this.getStartLoadInterval().hashCode();
            }
            if (this.hasEndLoadInterval()) {
                hash = 37 * hash + 5;
                hash = 53 * hash + this.getEndLoadInterval().hashCode();
            }
            this.memoizedHashCode = hash = 29 * hash + this.getUnknownFields().hashCode();
            return hash;
        }

        public static LoadLimit parseFrom(ByteBuffer data) throws InvalidProtocolBufferException {
            return (LoadLimit)PARSER.parseFrom(data);
        }

        public static LoadLimit parseFrom(ByteBuffer data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            return (LoadLimit)PARSER.parseFrom(data, extensionRegistry);
        }

        public static LoadLimit parseFrom(ByteString data) throws InvalidProtocolBufferException {
            return (LoadLimit)PARSER.parseFrom(data);
        }

        public static LoadLimit parseFrom(ByteString data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            return (LoadLimit)PARSER.parseFrom(data, extensionRegistry);
        }

        public static LoadLimit parseFrom(byte[] data) throws InvalidProtocolBufferException {
            return (LoadLimit)PARSER.parseFrom(data);
        }

        public static LoadLimit parseFrom(byte[] data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            return (LoadLimit)PARSER.parseFrom(data, extensionRegistry);
        }

        public static LoadLimit parseFrom(InputStream input) throws IOException {
            return (LoadLimit)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input);
        }

        public static LoadLimit parseFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            return (LoadLimit)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
        }

        public static LoadLimit parseDelimitedFrom(InputStream input) throws IOException {
            return (LoadLimit)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input);
        }

        public static LoadLimit parseDelimitedFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            return (LoadLimit)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
        }

        public static LoadLimit parseFrom(CodedInputStream input) throws IOException {
            return (LoadLimit)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input);
        }

        public static LoadLimit parseFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            return (LoadLimit)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input, (ExtensionRegistryLite)extensionRegistry);
        }

        public Builder newBuilderForType() {
            return LoadLimit.newBuilder();
        }

        public static Builder newBuilder() {
            return DEFAULT_INSTANCE.toBuilder();
        }

        public static Builder newBuilder(LoadLimit prototype) {
            return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
        }

        public Builder toBuilder() {
            return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
        }

        protected Builder newBuilderForType(GeneratedMessageV3.BuilderParent parent) {
            Builder builder = new Builder(parent);
            return builder;
        }

        public static LoadLimit getDefaultInstance() {
            return DEFAULT_INSTANCE;
        }

        public static Parser<LoadLimit> parser() {
            return PARSER;
        }

        public Parser<LoadLimit> getParserForType() {
            return PARSER;
        }

        public LoadLimit getDefaultInstanceForType() {
            return DEFAULT_INSTANCE;
        }

        public static final class Builder
        extends GeneratedMessageV3.Builder<Builder>
        implements LoadLimitOrBuilder {
            private int bitField0_;
            private long maxLoad_;
            private long softMaxLoad_;
            private double costPerUnitAboveSoftMax_;
            private Interval startLoadInterval_;
            private SingleFieldBuilderV3<Interval, Interval.Builder, IntervalOrBuilder> startLoadIntervalBuilder_;
            private Interval endLoadInterval_;
            private SingleFieldBuilderV3<Interval, Interval.Builder, IntervalOrBuilder> endLoadIntervalBuilder_;

            public static final Descriptors.Descriptor getDescriptor() {
                return RouteOptimizationServiceProto.internal_static_google_maps_routeoptimization_v1_Vehicle_LoadLimit_descriptor;
            }

            protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
                return RouteOptimizationServiceProto.internal_static_google_maps_routeoptimization_v1_Vehicle_LoadLimit_fieldAccessorTable.ensureFieldAccessorsInitialized(LoadLimit.class, Builder.class);
            }

            private Builder() {
                this.maybeForceBuilderInitialization();
            }

            private Builder(GeneratedMessageV3.BuilderParent parent) {
                super(parent);
                this.maybeForceBuilderInitialization();
            }

            private void maybeForceBuilderInitialization() {
                if (alwaysUseFieldBuilders) {
                    this.getStartLoadIntervalFieldBuilder();
                    this.getEndLoadIntervalFieldBuilder();
                }
            }

            public Builder clear() {
                super.clear();
                this.bitField0_ = 0;
                this.maxLoad_ = 0L;
                this.softMaxLoad_ = 0L;
                this.costPerUnitAboveSoftMax_ = 0.0;
                this.startLoadInterval_ = null;
                if (this.startLoadIntervalBuilder_ != null) {
                    this.startLoadIntervalBuilder_.dispose();
                    this.startLoadIntervalBuilder_ = null;
                }
                this.endLoadInterval_ = null;
                if (this.endLoadIntervalBuilder_ != null) {
                    this.endLoadIntervalBuilder_.dispose();
                    this.endLoadIntervalBuilder_ = null;
                }
                return this;
            }

            public Descriptors.Descriptor getDescriptorForType() {
                return RouteOptimizationServiceProto.internal_static_google_maps_routeoptimization_v1_Vehicle_LoadLimit_descriptor;
            }

            public LoadLimit getDefaultInstanceForType() {
                return LoadLimit.getDefaultInstance();
            }

            public LoadLimit build() {
                LoadLimit result = this.buildPartial();
                if (!result.isInitialized()) {
                    throw Builder.newUninitializedMessageException((Message)result);
                }
                return result;
            }

            public LoadLimit buildPartial() {
                LoadLimit result = new LoadLimit(this);
                if (this.bitField0_ != 0) {
                    this.buildPartial0(result);
                }
                this.onBuilt();
                return result;
            }

            private void buildPartial0(LoadLimit result) {
                int from_bitField0_ = this.bitField0_;
                int to_bitField0_ = 0;
                if ((from_bitField0_ & 1) != 0) {
                    result.maxLoad_ = this.maxLoad_;
                    to_bitField0_ |= 1;
                }
                if ((from_bitField0_ & 2) != 0) {
                    result.softMaxLoad_ = this.softMaxLoad_;
                }
                if ((from_bitField0_ & 4) != 0) {
                    result.costPerUnitAboveSoftMax_ = this.costPerUnitAboveSoftMax_;
                }
                if ((from_bitField0_ & 8) != 0) {
                    result.startLoadInterval_ = this.startLoadIntervalBuilder_ == null ? this.startLoadInterval_ : (Interval)this.startLoadIntervalBuilder_.build();
                    to_bitField0_ |= 2;
                }
                if ((from_bitField0_ & 0x10) != 0) {
                    result.endLoadInterval_ = this.endLoadIntervalBuilder_ == null ? this.endLoadInterval_ : (Interval)this.endLoadIntervalBuilder_.build();
                    to_bitField0_ |= 4;
                }
                LoadLimit loadLimit = result;
                loadLimit.bitField0_ = loadLimit.bitField0_ | to_bitField0_;
            }

            public Builder clone() {
                return (Builder)super.clone();
            }

            public Builder setField(Descriptors.FieldDescriptor field, Object value) {
                return (Builder)super.setField(field, value);
            }

            public Builder clearField(Descriptors.FieldDescriptor field) {
                return (Builder)super.clearField(field);
            }

            public Builder clearOneof(Descriptors.OneofDescriptor oneof) {
                return (Builder)super.clearOneof(oneof);
            }

            public Builder setRepeatedField(Descriptors.FieldDescriptor field, int index, Object value) {
                return (Builder)super.setRepeatedField(field, index, value);
            }

            public Builder addRepeatedField(Descriptors.FieldDescriptor field, Object value) {
                return (Builder)super.addRepeatedField(field, value);
            }

            public Builder mergeFrom(Message other) {
                if (other instanceof LoadLimit) {
                    return this.mergeFrom((LoadLimit)other);
                }
                super.mergeFrom(other);
                return this;
            }

            public Builder mergeFrom(LoadLimit other) {
                if (other == LoadLimit.getDefaultInstance()) {
                    return this;
                }
                if (other.hasMaxLoad()) {
                    this.setMaxLoad(other.getMaxLoad());
                }
                if (other.getSoftMaxLoad() != 0L) {
                    this.setSoftMaxLoad(other.getSoftMaxLoad());
                }
                if (other.getCostPerUnitAboveSoftMax() != 0.0) {
                    this.setCostPerUnitAboveSoftMax(other.getCostPerUnitAboveSoftMax());
                }
                if (other.hasStartLoadInterval()) {
                    this.mergeStartLoadInterval(other.getStartLoadInterval());
                }
                if (other.hasEndLoadInterval()) {
                    this.mergeEndLoadInterval(other.getEndLoadInterval());
                }
                this.mergeUnknownFields(other.getUnknownFields());
                this.onChanged();
                return this;
            }

            public final boolean isInitialized() {
                return true;
            }

            public Builder mergeFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
                if (extensionRegistry == null) {
                    throw new NullPointerException();
                }
                try {
                    boolean done = false;
                    block13: while (!done) {
                        int tag = input.readTag();
                        switch (tag) {
                            case 0: {
                                done = true;
                                continue block13;
                            }
                            case 8: {
                                this.maxLoad_ = input.readInt64();
                                this.bitField0_ |= 1;
                                continue block13;
                            }
                            case 16: {
                                this.softMaxLoad_ = input.readInt64();
                                this.bitField0_ |= 2;
                                continue block13;
                            }
                            case 25: {
                                this.costPerUnitAboveSoftMax_ = input.readDouble();
                                this.bitField0_ |= 4;
                                continue block13;
                            }
                            case 34: {
                                input.readMessage((MessageLite.Builder)this.getStartLoadIntervalFieldBuilder().getBuilder(), extensionRegistry);
                                this.bitField0_ |= 8;
                                continue block13;
                            }
                            case 42: {
                                input.readMessage((MessageLite.Builder)this.getEndLoadIntervalFieldBuilder().getBuilder(), extensionRegistry);
                                this.bitField0_ |= 0x10;
                                continue block13;
                            }
                        }
                        if (super.parseUnknownField(input, extensionRegistry, tag)) continue;
                        done = true;
                    }
                }
                catch (InvalidProtocolBufferException e) {
                    throw e.unwrapIOException();
                }
                finally {
                    this.onChanged();
                }
                return this;
            }

            @Override
            public boolean hasMaxLoad() {
                return (this.bitField0_ & 1) != 0;
            }

            @Override
            public long getMaxLoad() {
                return this.maxLoad_;
            }

            public Builder setMaxLoad(long value) {
                this.maxLoad_ = value;
                this.bitField0_ |= 1;
                this.onChanged();
                return this;
            }

            public Builder clearMaxLoad() {
                this.bitField0_ &= 0xFFFFFFFE;
                this.maxLoad_ = 0L;
                this.onChanged();
                return this;
            }

            @Override
            public long getSoftMaxLoad() {
                return this.softMaxLoad_;
            }

            public Builder setSoftMaxLoad(long value) {
                this.softMaxLoad_ = value;
                this.bitField0_ |= 2;
                this.onChanged();
                return this;
            }

            public Builder clearSoftMaxLoad() {
                this.bitField0_ &= 0xFFFFFFFD;
                this.softMaxLoad_ = 0L;
                this.onChanged();
                return this;
            }

            @Override
            public double getCostPerUnitAboveSoftMax() {
                return this.costPerUnitAboveSoftMax_;
            }

            public Builder setCostPerUnitAboveSoftMax(double value) {
                this.costPerUnitAboveSoftMax_ = value;
                this.bitField0_ |= 4;
                this.onChanged();
                return this;
            }

            public Builder clearCostPerUnitAboveSoftMax() {
                this.bitField0_ &= 0xFFFFFFFB;
                this.costPerUnitAboveSoftMax_ = 0.0;
                this.onChanged();
                return this;
            }

            @Override
            public boolean hasStartLoadInterval() {
                return (this.bitField0_ & 8) != 0;
            }

            @Override
            public Interval getStartLoadInterval() {
                if (this.startLoadIntervalBuilder_ == null) {
                    return this.startLoadInterval_ == null ? Interval.getDefaultInstance() : this.startLoadInterval_;
                }
                return (Interval)this.startLoadIntervalBuilder_.getMessage();
            }

            public Builder setStartLoadInterval(Interval value) {
                if (this.startLoadIntervalBuilder_ == null) {
                    if (value == null) {
                        throw new NullPointerException();
                    }
                    this.startLoadInterval_ = value;
                } else {
                    this.startLoadIntervalBuilder_.setMessage((AbstractMessage)value);
                }
                this.bitField0_ |= 8;
                this.onChanged();
                return this;
            }

            public Builder setStartLoadInterval(Interval.Builder builderForValue) {
                if (this.startLoadIntervalBuilder_ == null) {
                    this.startLoadInterval_ = builderForValue.build();
                } else {
                    this.startLoadIntervalBuilder_.setMessage((AbstractMessage)builderForValue.build());
                }
                this.bitField0_ |= 8;
                this.onChanged();
                return this;
            }

            public Builder mergeStartLoadInterval(Interval value) {
                if (this.startLoadIntervalBuilder_ == null) {
                    if ((this.bitField0_ & 8) != 0 && this.startLoadInterval_ != null && this.startLoadInterval_ != Interval.getDefaultInstance()) {
                        this.getStartLoadIntervalBuilder().mergeFrom(value);
                    } else {
                        this.startLoadInterval_ = value;
                    }
                } else {
                    this.startLoadIntervalBuilder_.mergeFrom((AbstractMessage)value);
                }
                if (this.startLoadInterval_ != null) {
                    this.bitField0_ |= 8;
                    this.onChanged();
                }
                return this;
            }

            public Builder clearStartLoadInterval() {
                this.bitField0_ &= 0xFFFFFFF7;
                this.startLoadInterval_ = null;
                if (this.startLoadIntervalBuilder_ != null) {
                    this.startLoadIntervalBuilder_.dispose();
                    this.startLoadIntervalBuilder_ = null;
                }
                this.onChanged();
                return this;
            }

            public Interval.Builder getStartLoadIntervalBuilder() {
                this.bitField0_ |= 8;
                this.onChanged();
                return (Interval.Builder)this.getStartLoadIntervalFieldBuilder().getBuilder();
            }

            @Override
            public IntervalOrBuilder getStartLoadIntervalOrBuilder() {
                if (this.startLoadIntervalBuilder_ != null) {
                    return (IntervalOrBuilder)this.startLoadIntervalBuilder_.getMessageOrBuilder();
                }
                return this.startLoadInterval_ == null ? Interval.getDefaultInstance() : this.startLoadInterval_;
            }

            private SingleFieldBuilderV3<Interval, Interval.Builder, IntervalOrBuilder> getStartLoadIntervalFieldBuilder() {
                if (this.startLoadIntervalBuilder_ == null) {
                    this.startLoadIntervalBuilder_ = new SingleFieldBuilderV3((AbstractMessage)this.getStartLoadInterval(), (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                    this.startLoadInterval_ = null;
                }
                return this.startLoadIntervalBuilder_;
            }

            @Override
            public boolean hasEndLoadInterval() {
                return (this.bitField0_ & 0x10) != 0;
            }

            @Override
            public Interval getEndLoadInterval() {
                if (this.endLoadIntervalBuilder_ == null) {
                    return this.endLoadInterval_ == null ? Interval.getDefaultInstance() : this.endLoadInterval_;
                }
                return (Interval)this.endLoadIntervalBuilder_.getMessage();
            }

            public Builder setEndLoadInterval(Interval value) {
                if (this.endLoadIntervalBuilder_ == null) {
                    if (value == null) {
                        throw new NullPointerException();
                    }
                    this.endLoadInterval_ = value;
                } else {
                    this.endLoadIntervalBuilder_.setMessage((AbstractMessage)value);
                }
                this.bitField0_ |= 0x10;
                this.onChanged();
                return this;
            }

            public Builder setEndLoadInterval(Interval.Builder builderForValue) {
                if (this.endLoadIntervalBuilder_ == null) {
                    this.endLoadInterval_ = builderForValue.build();
                } else {
                    this.endLoadIntervalBuilder_.setMessage((AbstractMessage)builderForValue.build());
                }
                this.bitField0_ |= 0x10;
                this.onChanged();
                return this;
            }

            public Builder mergeEndLoadInterval(Interval value) {
                if (this.endLoadIntervalBuilder_ == null) {
                    if ((this.bitField0_ & 0x10) != 0 && this.endLoadInterval_ != null && this.endLoadInterval_ != Interval.getDefaultInstance()) {
                        this.getEndLoadIntervalBuilder().mergeFrom(value);
                    } else {
                        this.endLoadInterval_ = value;
                    }
                } else {
                    this.endLoadIntervalBuilder_.mergeFrom((AbstractMessage)value);
                }
                if (this.endLoadInterval_ != null) {
                    this.bitField0_ |= 0x10;
                    this.onChanged();
                }
                return this;
            }

            public Builder clearEndLoadInterval() {
                this.bitField0_ &= 0xFFFFFFEF;
                this.endLoadInterval_ = null;
                if (this.endLoadIntervalBuilder_ != null) {
                    this.endLoadIntervalBuilder_.dispose();
                    this.endLoadIntervalBuilder_ = null;
                }
                this.onChanged();
                return this;
            }

            public Interval.Builder getEndLoadIntervalBuilder() {
                this.bitField0_ |= 0x10;
                this.onChanged();
                return (Interval.Builder)this.getEndLoadIntervalFieldBuilder().getBuilder();
            }

            @Override
            public IntervalOrBuilder getEndLoadIntervalOrBuilder() {
                if (this.endLoadIntervalBuilder_ != null) {
                    return (IntervalOrBuilder)this.endLoadIntervalBuilder_.getMessageOrBuilder();
                }
                return this.endLoadInterval_ == null ? Interval.getDefaultInstance() : this.endLoadInterval_;
            }

            private SingleFieldBuilderV3<Interval, Interval.Builder, IntervalOrBuilder> getEndLoadIntervalFieldBuilder() {
                if (this.endLoadIntervalBuilder_ == null) {
                    this.endLoadIntervalBuilder_ = new SingleFieldBuilderV3((AbstractMessage)this.getEndLoadInterval(), (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                    this.endLoadInterval_ = null;
                }
                return this.endLoadIntervalBuilder_;
            }

            public final Builder setUnknownFields(UnknownFieldSet unknownFields) {
                return (Builder)super.setUnknownFields(unknownFields);
            }

            public final Builder mergeUnknownFields(UnknownFieldSet unknownFields) {
                return (Builder)super.mergeUnknownFields(unknownFields);
            }
        }

        public static final class Interval
        extends GeneratedMessageV3
        implements IntervalOrBuilder {
            private static final long serialVersionUID = 0L;
            private int bitField0_;
            public static final int MIN_FIELD_NUMBER = 1;
            private long min_ = 0L;
            public static final int MAX_FIELD_NUMBER = 2;
            private long max_ = 0L;
            private byte memoizedIsInitialized = (byte)-1;
            private static final Interval DEFAULT_INSTANCE = new Interval();
            private static final Parser<Interval> PARSER = new AbstractParser<Interval>(){

                public Interval parsePartialFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
                    Builder builder = Interval.newBuilder();
                    try {
                        builder.mergeFrom(input, extensionRegistry);
                    }
                    catch (InvalidProtocolBufferException e) {
                        throw e.setUnfinishedMessage((MessageLite)builder.buildPartial());
                    }
                    catch (UninitializedMessageException e) {
                        throw e.asInvalidProtocolBufferException().setUnfinishedMessage((MessageLite)builder.buildPartial());
                    }
                    catch (IOException e) {
                        throw new InvalidProtocolBufferException(e).setUnfinishedMessage((MessageLite)builder.buildPartial());
                    }
                    return builder.buildPartial();
                }
            };

            private Interval(GeneratedMessageV3.Builder<?> builder) {
                super(builder);
            }

            private Interval() {
            }

            protected Object newInstance(GeneratedMessageV3.UnusedPrivateParameter unused) {
                return new Interval();
            }

            public static final Descriptors.Descriptor getDescriptor() {
                return RouteOptimizationServiceProto.internal_static_google_maps_routeoptimization_v1_Vehicle_LoadLimit_Interval_descriptor;
            }

            protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
                return RouteOptimizationServiceProto.internal_static_google_maps_routeoptimization_v1_Vehicle_LoadLimit_Interval_fieldAccessorTable.ensureFieldAccessorsInitialized(Interval.class, Builder.class);
            }

            @Override
            public long getMin() {
                return this.min_;
            }

            @Override
            public boolean hasMax() {
                return (this.bitField0_ & 1) != 0;
            }

            @Override
            public long getMax() {
                return this.max_;
            }

            public final boolean isInitialized() {
                byte isInitialized = this.memoizedIsInitialized;
                if (isInitialized == 1) {
                    return true;
                }
                if (isInitialized == 0) {
                    return false;
                }
                this.memoizedIsInitialized = 1;
                return true;
            }

            public void writeTo(CodedOutputStream output) throws IOException {
                if (this.min_ != 0L) {
                    output.writeInt64(1, this.min_);
                }
                if ((this.bitField0_ & 1) != 0) {
                    output.writeInt64(2, this.max_);
                }
                this.getUnknownFields().writeTo(output);
            }

            public int getSerializedSize() {
                int size = this.memoizedSize;
                if (size != -1) {
                    return size;
                }
                size = 0;
                if (this.min_ != 0L) {
                    size += CodedOutputStream.computeInt64Size((int)1, (long)this.min_);
                }
                if ((this.bitField0_ & 1) != 0) {
                    size += CodedOutputStream.computeInt64Size((int)2, (long)this.max_);
                }
                this.memoizedSize = size += this.getUnknownFields().getSerializedSize();
                return size;
            }

            public boolean equals(Object obj) {
                if (obj == this) {
                    return true;
                }
                if (!(obj instanceof Interval)) {
                    return super.equals(obj);
                }
                Interval other = (Interval)obj;
                if (this.getMin() != other.getMin()) {
                    return false;
                }
                if (this.hasMax() != other.hasMax()) {
                    return false;
                }
                if (this.hasMax() && this.getMax() != other.getMax()) {
                    return false;
                }
                return this.getUnknownFields().equals((Object)other.getUnknownFields());
            }

            public int hashCode() {
                if (this.memoizedHashCode != 0) {
                    return this.memoizedHashCode;
                }
                int hash = 41;
                hash = 19 * hash + Interval.getDescriptor().hashCode();
                hash = 37 * hash + 1;
                hash = 53 * hash + Internal.hashLong((long)this.getMin());
                if (this.hasMax()) {
                    hash = 37 * hash + 2;
                    hash = 53 * hash + Internal.hashLong((long)this.getMax());
                }
                this.memoizedHashCode = hash = 29 * hash + this.getUnknownFields().hashCode();
                return hash;
            }

            public static Interval parseFrom(ByteBuffer data) throws InvalidProtocolBufferException {
                return (Interval)PARSER.parseFrom(data);
            }

            public static Interval parseFrom(ByteBuffer data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
                return (Interval)PARSER.parseFrom(data, extensionRegistry);
            }

            public static Interval parseFrom(ByteString data) throws InvalidProtocolBufferException {
                return (Interval)PARSER.parseFrom(data);
            }

            public static Interval parseFrom(ByteString data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
                return (Interval)PARSER.parseFrom(data, extensionRegistry);
            }

            public static Interval parseFrom(byte[] data) throws InvalidProtocolBufferException {
                return (Interval)PARSER.parseFrom(data);
            }

            public static Interval parseFrom(byte[] data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
                return (Interval)PARSER.parseFrom(data, extensionRegistry);
            }

            public static Interval parseFrom(InputStream input) throws IOException {
                return (Interval)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input);
            }

            public static Interval parseFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
                return (Interval)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
            }

            public static Interval parseDelimitedFrom(InputStream input) throws IOException {
                return (Interval)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input);
            }

            public static Interval parseDelimitedFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
                return (Interval)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
            }

            public static Interval parseFrom(CodedInputStream input) throws IOException {
                return (Interval)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input);
            }

            public static Interval parseFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
                return (Interval)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input, (ExtensionRegistryLite)extensionRegistry);
            }

            public Builder newBuilderForType() {
                return Interval.newBuilder();
            }

            public static Builder newBuilder() {
                return DEFAULT_INSTANCE.toBuilder();
            }

            public static Builder newBuilder(Interval prototype) {
                return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
            }

            public Builder toBuilder() {
                return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
            }

            protected Builder newBuilderForType(GeneratedMessageV3.BuilderParent parent) {
                Builder builder = new Builder(parent);
                return builder;
            }

            public static Interval getDefaultInstance() {
                return DEFAULT_INSTANCE;
            }

            public static Parser<Interval> parser() {
                return PARSER;
            }

            public Parser<Interval> getParserForType() {
                return PARSER;
            }

            public Interval getDefaultInstanceForType() {
                return DEFAULT_INSTANCE;
            }

            public static final class Builder
            extends GeneratedMessageV3.Builder<Builder>
            implements IntervalOrBuilder {
                private int bitField0_;
                private long min_;
                private long max_;

                public static final Descriptors.Descriptor getDescriptor() {
                    return RouteOptimizationServiceProto.internal_static_google_maps_routeoptimization_v1_Vehicle_LoadLimit_Interval_descriptor;
                }

                protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
                    return RouteOptimizationServiceProto.internal_static_google_maps_routeoptimization_v1_Vehicle_LoadLimit_Interval_fieldAccessorTable.ensureFieldAccessorsInitialized(Interval.class, Builder.class);
                }

                private Builder() {
                }

                private Builder(GeneratedMessageV3.BuilderParent parent) {
                    super(parent);
                }

                public Builder clear() {
                    super.clear();
                    this.bitField0_ = 0;
                    this.min_ = 0L;
                    this.max_ = 0L;
                    return this;
                }

                public Descriptors.Descriptor getDescriptorForType() {
                    return RouteOptimizationServiceProto.internal_static_google_maps_routeoptimization_v1_Vehicle_LoadLimit_Interval_descriptor;
                }

                public Interval getDefaultInstanceForType() {
                    return Interval.getDefaultInstance();
                }

                public Interval build() {
                    Interval result = this.buildPartial();
                    if (!result.isInitialized()) {
                        throw Builder.newUninitializedMessageException((Message)result);
                    }
                    return result;
                }

                public Interval buildPartial() {
                    Interval result = new Interval(this);
                    if (this.bitField0_ != 0) {
                        this.buildPartial0(result);
                    }
                    this.onBuilt();
                    return result;
                }

                private void buildPartial0(Interval result) {
                    int from_bitField0_ = this.bitField0_;
                    if ((from_bitField0_ & 1) != 0) {
                        result.min_ = this.min_;
                    }
                    int to_bitField0_ = 0;
                    if ((from_bitField0_ & 2) != 0) {
                        result.max_ = this.max_;
                        to_bitField0_ |= 1;
                    }
                    Interval interval = result;
                    interval.bitField0_ = interval.bitField0_ | to_bitField0_;
                }

                public Builder clone() {
                    return (Builder)super.clone();
                }

                public Builder setField(Descriptors.FieldDescriptor field, Object value) {
                    return (Builder)super.setField(field, value);
                }

                public Builder clearField(Descriptors.FieldDescriptor field) {
                    return (Builder)super.clearField(field);
                }

                public Builder clearOneof(Descriptors.OneofDescriptor oneof) {
                    return (Builder)super.clearOneof(oneof);
                }

                public Builder setRepeatedField(Descriptors.FieldDescriptor field, int index, Object value) {
                    return (Builder)super.setRepeatedField(field, index, value);
                }

                public Builder addRepeatedField(Descriptors.FieldDescriptor field, Object value) {
                    return (Builder)super.addRepeatedField(field, value);
                }

                public Builder mergeFrom(Message other) {
                    if (other instanceof Interval) {
                        return this.mergeFrom((Interval)other);
                    }
                    super.mergeFrom(other);
                    return this;
                }

                public Builder mergeFrom(Interval other) {
                    if (other == Interval.getDefaultInstance()) {
                        return this;
                    }
                    if (other.getMin() != 0L) {
                        this.setMin(other.getMin());
                    }
                    if (other.hasMax()) {
                        this.setMax(other.getMax());
                    }
                    this.mergeUnknownFields(other.getUnknownFields());
                    this.onChanged();
                    return this;
                }

                public final boolean isInitialized() {
                    return true;
                }

                public Builder mergeFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
                    if (extensionRegistry == null) {
                        throw new NullPointerException();
                    }
                    try {
                        boolean done = false;
                        block10: while (!done) {
                            int tag = input.readTag();
                            switch (tag) {
                                case 0: {
                                    done = true;
                                    continue block10;
                                }
                                case 8: {
                                    this.min_ = input.readInt64();
                                    this.bitField0_ |= 1;
                                    continue block10;
                                }
                                case 16: {
                                    this.max_ = input.readInt64();
                                    this.bitField0_ |= 2;
                                    continue block10;
                                }
                            }
                            if (super.parseUnknownField(input, extensionRegistry, tag)) continue;
                            done = true;
                        }
                    }
                    catch (InvalidProtocolBufferException e) {
                        throw e.unwrapIOException();
                    }
                    finally {
                        this.onChanged();
                    }
                    return this;
                }

                @Override
                public long getMin() {
                    return this.min_;
                }

                public Builder setMin(long value) {
                    this.min_ = value;
                    this.bitField0_ |= 1;
                    this.onChanged();
                    return this;
                }

                public Builder clearMin() {
                    this.bitField0_ &= 0xFFFFFFFE;
                    this.min_ = 0L;
                    this.onChanged();
                    return this;
                }

                @Override
                public boolean hasMax() {
                    return (this.bitField0_ & 2) != 0;
                }

                @Override
                public long getMax() {
                    return this.max_;
                }

                public Builder setMax(long value) {
                    this.max_ = value;
                    this.bitField0_ |= 2;
                    this.onChanged();
                    return this;
                }

                public Builder clearMax() {
                    this.bitField0_ &= 0xFFFFFFFD;
                    this.max_ = 0L;
                    this.onChanged();
                    return this;
                }

                public final Builder setUnknownFields(UnknownFieldSet unknownFields) {
                    return (Builder)super.setUnknownFields(unknownFields);
                }

                public final Builder mergeUnknownFields(UnknownFieldSet unknownFields) {
                    return (Builder)super.mergeUnknownFields(unknownFields);
                }
            }
        }

        public static interface IntervalOrBuilder
        extends MessageOrBuilder {
            public long getMin();

            public boolean hasMax();

            public long getMax();
        }
    }

    public static interface LoadLimitOrBuilder
    extends MessageOrBuilder {
        public boolean hasMaxLoad();

        public long getMaxLoad();

        public long getSoftMaxLoad();

        public double getCostPerUnitAboveSoftMax();

        public boolean hasStartLoadInterval();

        public LoadLimit.Interval getStartLoadInterval();

        public LoadLimit.IntervalOrBuilder getStartLoadIntervalOrBuilder();

        public boolean hasEndLoadInterval();

        public LoadLimit.Interval getEndLoadInterval();

        public LoadLimit.IntervalOrBuilder getEndLoadIntervalOrBuilder();
    }

    public static enum UnloadingPolicy implements ProtocolMessageEnum
    {
        UNLOADING_POLICY_UNSPECIFIED(0),
        LAST_IN_FIRST_OUT(1),
        FIRST_IN_FIRST_OUT(2),
        UNRECOGNIZED(-1);

        public static final int UNLOADING_POLICY_UNSPECIFIED_VALUE = 0;
        public static final int LAST_IN_FIRST_OUT_VALUE = 1;
        public static final int FIRST_IN_FIRST_OUT_VALUE = 2;
        private static final Internal.EnumLiteMap<UnloadingPolicy> internalValueMap;
        private static final UnloadingPolicy[] VALUES;
        private final int value;

        public final int getNumber() {
            if (this == UNRECOGNIZED) {
                throw new IllegalArgumentException("Can't get the number of an unknown enum value.");
            }
            return this.value;
        }

        @Deprecated
        public static UnloadingPolicy valueOf(int value) {
            return UnloadingPolicy.forNumber(value);
        }

        public static UnloadingPolicy forNumber(int value) {
            switch (value) {
                case 0: {
                    return UNLOADING_POLICY_UNSPECIFIED;
                }
                case 1: {
                    return LAST_IN_FIRST_OUT;
                }
                case 2: {
                    return FIRST_IN_FIRST_OUT;
                }
            }
            return null;
        }

        public static Internal.EnumLiteMap<UnloadingPolicy> internalGetValueMap() {
            return internalValueMap;
        }

        public final Descriptors.EnumValueDescriptor getValueDescriptor() {
            if (this == UNRECOGNIZED) {
                throw new IllegalStateException("Can't get the descriptor of an unrecognized enum value.");
            }
            return (Descriptors.EnumValueDescriptor)UnloadingPolicy.getDescriptor().getValues().get(this.ordinal());
        }

        public final Descriptors.EnumDescriptor getDescriptorForType() {
            return UnloadingPolicy.getDescriptor();
        }

        public static final Descriptors.EnumDescriptor getDescriptor() {
            return (Descriptors.EnumDescriptor)Vehicle.getDescriptor().getEnumTypes().get(1);
        }

        public static UnloadingPolicy valueOf(Descriptors.EnumValueDescriptor desc) {
            if (desc.getType() != UnloadingPolicy.getDescriptor()) {
                throw new IllegalArgumentException("EnumValueDescriptor is not for this type.");
            }
            if (desc.getIndex() == -1) {
                return UNRECOGNIZED;
            }
            return VALUES[desc.getIndex()];
        }

        private UnloadingPolicy(int value) {
            this.value = value;
        }

        static {
            internalValueMap = new Internal.EnumLiteMap<UnloadingPolicy>(){

                public UnloadingPolicy findValueByNumber(int number) {
                    return UnloadingPolicy.forNumber(number);
                }
            };
            VALUES = UnloadingPolicy.values();
        }
    }

    public static enum TravelMode implements ProtocolMessageEnum
    {
        TRAVEL_MODE_UNSPECIFIED(0),
        DRIVING(1),
        WALKING(2),
        UNRECOGNIZED(-1);

        public static final int TRAVEL_MODE_UNSPECIFIED_VALUE = 0;
        public static final int DRIVING_VALUE = 1;
        public static final int WALKING_VALUE = 2;
        private static final Internal.EnumLiteMap<TravelMode> internalValueMap;
        private static final TravelMode[] VALUES;
        private final int value;

        public final int getNumber() {
            if (this == UNRECOGNIZED) {
                throw new IllegalArgumentException("Can't get the number of an unknown enum value.");
            }
            return this.value;
        }

        @Deprecated
        public static TravelMode valueOf(int value) {
            return TravelMode.forNumber(value);
        }

        public static TravelMode forNumber(int value) {
            switch (value) {
                case 0: {
                    return TRAVEL_MODE_UNSPECIFIED;
                }
                case 1: {
                    return DRIVING;
                }
                case 2: {
                    return WALKING;
                }
            }
            return null;
        }

        public static Internal.EnumLiteMap<TravelMode> internalGetValueMap() {
            return internalValueMap;
        }

        public final Descriptors.EnumValueDescriptor getValueDescriptor() {
            if (this == UNRECOGNIZED) {
                throw new IllegalStateException("Can't get the descriptor of an unrecognized enum value.");
            }
            return (Descriptors.EnumValueDescriptor)TravelMode.getDescriptor().getValues().get(this.ordinal());
        }

        public final Descriptors.EnumDescriptor getDescriptorForType() {
            return TravelMode.getDescriptor();
        }

        public static final Descriptors.EnumDescriptor getDescriptor() {
            return (Descriptors.EnumDescriptor)Vehicle.getDescriptor().getEnumTypes().get(0);
        }

        public static TravelMode valueOf(Descriptors.EnumValueDescriptor desc) {
            if (desc.getType() != TravelMode.getDescriptor()) {
                throw new IllegalArgumentException("EnumValueDescriptor is not for this type.");
            }
            if (desc.getIndex() == -1) {
                return UNRECOGNIZED;
            }
            return VALUES[desc.getIndex()];
        }

        private TravelMode(int value) {
            this.value = value;
        }

        static {
            internalValueMap = new Internal.EnumLiteMap<TravelMode>(){

                public TravelMode findValueByNumber(int number) {
                    return TravelMode.forNumber(number);
                }
            };
            VALUES = TravelMode.values();
        }
    }
}

