/*
 * Decompiled with CFR 0.152.
 */
package com.google.maps.places.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class PhotoMediaName
implements ResourceName {
    private static final PathTemplate PLACE_ID_PHOTO_REFERENCE = PathTemplate.createWithoutUrlEncoding((String)"places/{place_id}/photos/{photo_reference}/media");
    private volatile Map<String, String> fieldValuesMap;
    private final String placeId;
    private final String photoReference;

    @Deprecated
    protected PhotoMediaName() {
        this.placeId = null;
        this.photoReference = null;
    }

    private PhotoMediaName(Builder builder) {
        this.placeId = (String)Preconditions.checkNotNull((Object)builder.getPlaceId());
        this.photoReference = (String)Preconditions.checkNotNull((Object)builder.getPhotoReference());
    }

    public String getPlaceId() {
        return this.placeId;
    }

    public String getPhotoReference() {
        return this.photoReference;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static PhotoMediaName of(String placeId, String photoReference) {
        return PhotoMediaName.newBuilder().setPlaceId(placeId).setPhotoReference(photoReference).build();
    }

    public static String format(String placeId, String photoReference) {
        return PhotoMediaName.newBuilder().setPlaceId(placeId).setPhotoReference(photoReference).build().toString();
    }

    public static PhotoMediaName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PLACE_ID_PHOTO_REFERENCE.validatedMatch(formattedString, "PhotoMediaName.parse: formattedString not in valid format");
        return PhotoMediaName.of((String)matchMap.get("place_id"), (String)matchMap.get("photo_reference"));
    }

    public static List<PhotoMediaName> parseList(List<String> formattedStrings) {
        ArrayList<PhotoMediaName> list = new ArrayList<PhotoMediaName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(PhotoMediaName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<PhotoMediaName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (PhotoMediaName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PLACE_ID_PHOTO_REFERENCE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            PhotoMediaName photoMediaName = this;
            synchronized (photoMediaName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.placeId != null) {
                        fieldMapBuilder.put((Object)"place_id", (Object)this.placeId);
                    }
                    if (this.photoReference != null) {
                        fieldMapBuilder.put((Object)"photo_reference", (Object)this.photoReference);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PLACE_ID_PHOTO_REFERENCE.instantiate(new String[]{"place_id", this.placeId, "photo_reference", this.photoReference});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            PhotoMediaName that = (PhotoMediaName)o;
            return Objects.equals(this.placeId, that.placeId) && Objects.equals(this.photoReference, that.photoReference);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.placeId);
        h *= 1000003;
        return h ^= Objects.hashCode(this.photoReference);
    }

    public static class Builder {
        private String placeId;
        private String photoReference;

        protected Builder() {
        }

        public String getPlaceId() {
            return this.placeId;
        }

        public String getPhotoReference() {
            return this.photoReference;
        }

        public Builder setPlaceId(String placeId) {
            this.placeId = placeId;
            return this;
        }

        public Builder setPhotoReference(String photoReference) {
            this.photoReference = photoReference;
            return this;
        }

        private Builder(PhotoMediaName photoMediaName) {
            this.placeId = photoMediaName.placeId;
            this.photoReference = photoMediaName.photoReference;
        }

        public PhotoMediaName build() {
            return new PhotoMediaName(this);
        }
    }
}

