/*
 * Decompiled with CFR 0.152.
 */
package com.google.maps.fleetengine.delivery.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class TaskName
implements ResourceName {
    private static final PathTemplate PROVIDER_TASK = PathTemplate.createWithoutUrlEncoding((String)"providers/{provider}/tasks/{task}");
    private volatile Map<String, String> fieldValuesMap;
    private final String provider;
    private final String task;

    @Deprecated
    protected TaskName() {
        this.provider = null;
        this.task = null;
    }

    private TaskName(Builder builder) {
        this.provider = (String)Preconditions.checkNotNull((Object)builder.getProvider());
        this.task = (String)Preconditions.checkNotNull((Object)builder.getTask());
    }

    public String getProvider() {
        return this.provider;
    }

    public String getTask() {
        return this.task;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static TaskName of(String provider, String task) {
        return TaskName.newBuilder().setProvider(provider).setTask(task).build();
    }

    public static String format(String provider, String task) {
        return TaskName.newBuilder().setProvider(provider).setTask(task).build().toString();
    }

    public static TaskName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROVIDER_TASK.validatedMatch(formattedString, "TaskName.parse: formattedString not in valid format");
        return TaskName.of((String)matchMap.get("provider"), (String)matchMap.get("task"));
    }

    public static List<TaskName> parseList(List<String> formattedStrings) {
        ArrayList<TaskName> list = new ArrayList<TaskName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(TaskName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<TaskName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (TaskName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROVIDER_TASK.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            TaskName taskName = this;
            synchronized (taskName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.provider != null) {
                        fieldMapBuilder.put((Object)"provider", (Object)this.provider);
                    }
                    if (this.task != null) {
                        fieldMapBuilder.put((Object)"task", (Object)this.task);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROVIDER_TASK.instantiate(new String[]{"provider", this.provider, "task", this.task});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            TaskName that = (TaskName)o;
            return Objects.equals(this.provider, that.provider) && Objects.equals(this.task, that.task);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.provider);
        h *= 1000003;
        return h ^= Objects.hashCode(this.task);
    }

    public static class Builder {
        private String provider;
        private String task;

        protected Builder() {
        }

        public String getProvider() {
            return this.provider;
        }

        public String getTask() {
            return this.task;
        }

        public Builder setProvider(String provider) {
            this.provider = provider;
            return this;
        }

        public Builder setTask(String task) {
            this.task = task;
            return this;
        }

        private Builder(TaskName taskName) {
            this.provider = taskName.provider;
            this.task = taskName.task;
        }

        public TaskName build() {
            return new TaskName(this);
        }
    }
}

