/*
 * Decompiled with CFR 0.152.
 */
package com.google.maps.fleetengine.delivery.v1;

import com.google.maps.fleetengine.delivery.v1.DeliveryVehicleLocation;
import com.google.maps.fleetengine.delivery.v1.DeliveryVehicleLocationOrBuilder;
import com.google.maps.fleetengine.delivery.v1.LocationInfo;
import com.google.maps.fleetengine.delivery.v1.LocationInfoOrBuilder;
import com.google.maps.fleetengine.delivery.v1.Task;
import com.google.maps.fleetengine.delivery.v1.TaskAttribute;
import com.google.maps.fleetengine.delivery.v1.TaskAttributeOrBuilder;
import com.google.maps.fleetengine.delivery.v1.TaskTrackingInfoOrBuilder;
import com.google.maps.fleetengine.delivery.v1.TaskTrackingInfoProto;
import com.google.maps.fleetengine.delivery.v1.TimeWindow;
import com.google.maps.fleetengine.delivery.v1.TimeWindowOrBuilder;
import com.google.protobuf.AbstractMessage;
import com.google.protobuf.AbstractMessageLite;
import com.google.protobuf.AbstractParser;
import com.google.protobuf.ByteString;
import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import com.google.protobuf.Descriptors;
import com.google.protobuf.ExtensionRegistryLite;
import com.google.protobuf.GeneratedMessageV3;
import com.google.protobuf.Int32Value;
import com.google.protobuf.Int32ValueOrBuilder;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import com.google.protobuf.MessageLite;
import com.google.protobuf.Parser;
import com.google.protobuf.RepeatedFieldBuilderV3;
import com.google.protobuf.SingleFieldBuilderV3;
import com.google.protobuf.Timestamp;
import com.google.protobuf.TimestampOrBuilder;
import com.google.protobuf.UninitializedMessageException;
import com.google.protobuf.UnknownFieldSet;
import com.google.type.LatLng;
import com.google.type.LatLngOrBuilder;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class TaskTrackingInfo
extends GeneratedMessageV3
implements TaskTrackingInfoOrBuilder {
    private static final long serialVersionUID = 0L;
    private int bitField0_;
    public static final int NAME_FIELD_NUMBER = 1;
    private volatile Object name_ = "";
    public static final int TRACKING_ID_FIELD_NUMBER = 2;
    private volatile Object trackingId_ = "";
    public static final int VEHICLE_LOCATION_FIELD_NUMBER = 3;
    private DeliveryVehicleLocation vehicleLocation_;
    public static final int ROUTE_POLYLINE_POINTS_FIELD_NUMBER = 4;
    private List<LatLng> routePolylinePoints_;
    public static final int REMAINING_STOP_COUNT_FIELD_NUMBER = 5;
    private Int32Value remainingStopCount_;
    public static final int REMAINING_DRIVING_DISTANCE_METERS_FIELD_NUMBER = 6;
    private Int32Value remainingDrivingDistanceMeters_;
    public static final int ESTIMATED_ARRIVAL_TIME_FIELD_NUMBER = 7;
    private Timestamp estimatedArrivalTime_;
    public static final int ESTIMATED_TASK_COMPLETION_TIME_FIELD_NUMBER = 8;
    private Timestamp estimatedTaskCompletionTime_;
    public static final int STATE_FIELD_NUMBER = 11;
    private int state_ = 0;
    public static final int TASK_OUTCOME_FIELD_NUMBER = 9;
    private int taskOutcome_ = 0;
    public static final int TASK_OUTCOME_TIME_FIELD_NUMBER = 12;
    private Timestamp taskOutcomeTime_;
    public static final int PLANNED_LOCATION_FIELD_NUMBER = 10;
    private LocationInfo plannedLocation_;
    public static final int TARGET_TIME_WINDOW_FIELD_NUMBER = 13;
    private TimeWindow targetTimeWindow_;
    public static final int ATTRIBUTES_FIELD_NUMBER = 14;
    private List<TaskAttribute> attributes_;
    private byte memoizedIsInitialized = (byte)-1;
    private static final TaskTrackingInfo DEFAULT_INSTANCE = new TaskTrackingInfo();
    private static final Parser<TaskTrackingInfo> PARSER = new AbstractParser<TaskTrackingInfo>(){

        public TaskTrackingInfo parsePartialFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            Builder builder = TaskTrackingInfo.newBuilder();
            try {
                builder.mergeFrom(input, extensionRegistry);
            }
            catch (InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage((MessageLite)builder.buildPartial());
            }
            catch (UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException().setUnfinishedMessage((MessageLite)builder.buildPartial());
            }
            catch (IOException e) {
                throw new InvalidProtocolBufferException(e).setUnfinishedMessage((MessageLite)builder.buildPartial());
            }
            return builder.buildPartial();
        }
    };

    private TaskTrackingInfo(GeneratedMessageV3.Builder<?> builder) {
        super(builder);
    }

    private TaskTrackingInfo() {
        this.name_ = "";
        this.trackingId_ = "";
        this.routePolylinePoints_ = Collections.emptyList();
        this.state_ = 0;
        this.taskOutcome_ = 0;
        this.attributes_ = Collections.emptyList();
    }

    protected Object newInstance(GeneratedMessageV3.UnusedPrivateParameter unused) {
        return new TaskTrackingInfo();
    }

    public static final Descriptors.Descriptor getDescriptor() {
        return TaskTrackingInfoProto.internal_static_maps_fleetengine_delivery_v1_TaskTrackingInfo_descriptor;
    }

    protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
        return TaskTrackingInfoProto.internal_static_maps_fleetengine_delivery_v1_TaskTrackingInfo_fieldAccessorTable.ensureFieldAccessorsInitialized(TaskTrackingInfo.class, Builder.class);
    }

    @Override
    public String getName() {
        Object ref = this.name_;
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s = bs.toStringUtf8();
        this.name_ = s;
        return s;
    }

    @Override
    public ByteString getNameBytes() {
        Object ref = this.name_;
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)((String)ref));
            this.name_ = b;
            return b;
        }
        return (ByteString)ref;
    }

    @Override
    public String getTrackingId() {
        Object ref = this.trackingId_;
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s = bs.toStringUtf8();
        this.trackingId_ = s;
        return s;
    }

    @Override
    public ByteString getTrackingIdBytes() {
        Object ref = this.trackingId_;
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)((String)ref));
            this.trackingId_ = b;
            return b;
        }
        return (ByteString)ref;
    }

    @Override
    public boolean hasVehicleLocation() {
        return (this.bitField0_ & 1) != 0;
    }

    @Override
    public DeliveryVehicleLocation getVehicleLocation() {
        return this.vehicleLocation_ == null ? DeliveryVehicleLocation.getDefaultInstance() : this.vehicleLocation_;
    }

    @Override
    public DeliveryVehicleLocationOrBuilder getVehicleLocationOrBuilder() {
        return this.vehicleLocation_ == null ? DeliveryVehicleLocation.getDefaultInstance() : this.vehicleLocation_;
    }

    @Override
    public List<LatLng> getRoutePolylinePointsList() {
        return this.routePolylinePoints_;
    }

    @Override
    public List<? extends LatLngOrBuilder> getRoutePolylinePointsOrBuilderList() {
        return this.routePolylinePoints_;
    }

    @Override
    public int getRoutePolylinePointsCount() {
        return this.routePolylinePoints_.size();
    }

    @Override
    public LatLng getRoutePolylinePoints(int index) {
        return this.routePolylinePoints_.get(index);
    }

    @Override
    public LatLngOrBuilder getRoutePolylinePointsOrBuilder(int index) {
        return (LatLngOrBuilder)this.routePolylinePoints_.get(index);
    }

    @Override
    public boolean hasRemainingStopCount() {
        return (this.bitField0_ & 2) != 0;
    }

    @Override
    public Int32Value getRemainingStopCount() {
        return this.remainingStopCount_ == null ? Int32Value.getDefaultInstance() : this.remainingStopCount_;
    }

    @Override
    public Int32ValueOrBuilder getRemainingStopCountOrBuilder() {
        return this.remainingStopCount_ == null ? Int32Value.getDefaultInstance() : this.remainingStopCount_;
    }

    @Override
    public boolean hasRemainingDrivingDistanceMeters() {
        return (this.bitField0_ & 4) != 0;
    }

    @Override
    public Int32Value getRemainingDrivingDistanceMeters() {
        return this.remainingDrivingDistanceMeters_ == null ? Int32Value.getDefaultInstance() : this.remainingDrivingDistanceMeters_;
    }

    @Override
    public Int32ValueOrBuilder getRemainingDrivingDistanceMetersOrBuilder() {
        return this.remainingDrivingDistanceMeters_ == null ? Int32Value.getDefaultInstance() : this.remainingDrivingDistanceMeters_;
    }

    @Override
    public boolean hasEstimatedArrivalTime() {
        return (this.bitField0_ & 8) != 0;
    }

    @Override
    public Timestamp getEstimatedArrivalTime() {
        return this.estimatedArrivalTime_ == null ? Timestamp.getDefaultInstance() : this.estimatedArrivalTime_;
    }

    @Override
    public TimestampOrBuilder getEstimatedArrivalTimeOrBuilder() {
        return this.estimatedArrivalTime_ == null ? Timestamp.getDefaultInstance() : this.estimatedArrivalTime_;
    }

    @Override
    public boolean hasEstimatedTaskCompletionTime() {
        return (this.bitField0_ & 0x10) != 0;
    }

    @Override
    public Timestamp getEstimatedTaskCompletionTime() {
        return this.estimatedTaskCompletionTime_ == null ? Timestamp.getDefaultInstance() : this.estimatedTaskCompletionTime_;
    }

    @Override
    public TimestampOrBuilder getEstimatedTaskCompletionTimeOrBuilder() {
        return this.estimatedTaskCompletionTime_ == null ? Timestamp.getDefaultInstance() : this.estimatedTaskCompletionTime_;
    }

    @Override
    public int getStateValue() {
        return this.state_;
    }

    @Override
    public Task.State getState() {
        Task.State result = Task.State.forNumber(this.state_);
        return result == null ? Task.State.UNRECOGNIZED : result;
    }

    @Override
    public int getTaskOutcomeValue() {
        return this.taskOutcome_;
    }

    @Override
    public Task.TaskOutcome getTaskOutcome() {
        Task.TaskOutcome result = Task.TaskOutcome.forNumber(this.taskOutcome_);
        return result == null ? Task.TaskOutcome.UNRECOGNIZED : result;
    }

    @Override
    public boolean hasTaskOutcomeTime() {
        return (this.bitField0_ & 0x20) != 0;
    }

    @Override
    public Timestamp getTaskOutcomeTime() {
        return this.taskOutcomeTime_ == null ? Timestamp.getDefaultInstance() : this.taskOutcomeTime_;
    }

    @Override
    public TimestampOrBuilder getTaskOutcomeTimeOrBuilder() {
        return this.taskOutcomeTime_ == null ? Timestamp.getDefaultInstance() : this.taskOutcomeTime_;
    }

    @Override
    public boolean hasPlannedLocation() {
        return (this.bitField0_ & 0x40) != 0;
    }

    @Override
    public LocationInfo getPlannedLocation() {
        return this.plannedLocation_ == null ? LocationInfo.getDefaultInstance() : this.plannedLocation_;
    }

    @Override
    public LocationInfoOrBuilder getPlannedLocationOrBuilder() {
        return this.plannedLocation_ == null ? LocationInfo.getDefaultInstance() : this.plannedLocation_;
    }

    @Override
    public boolean hasTargetTimeWindow() {
        return (this.bitField0_ & 0x80) != 0;
    }

    @Override
    public TimeWindow getTargetTimeWindow() {
        return this.targetTimeWindow_ == null ? TimeWindow.getDefaultInstance() : this.targetTimeWindow_;
    }

    @Override
    public TimeWindowOrBuilder getTargetTimeWindowOrBuilder() {
        return this.targetTimeWindow_ == null ? TimeWindow.getDefaultInstance() : this.targetTimeWindow_;
    }

    @Override
    public List<TaskAttribute> getAttributesList() {
        return this.attributes_;
    }

    @Override
    public List<? extends TaskAttributeOrBuilder> getAttributesOrBuilderList() {
        return this.attributes_;
    }

    @Override
    public int getAttributesCount() {
        return this.attributes_.size();
    }

    @Override
    public TaskAttribute getAttributes(int index) {
        return this.attributes_.get(index);
    }

    @Override
    public TaskAttributeOrBuilder getAttributesOrBuilder(int index) {
        return this.attributes_.get(index);
    }

    public final boolean isInitialized() {
        byte isInitialized = this.memoizedIsInitialized;
        if (isInitialized == 1) {
            return true;
        }
        if (isInitialized == 0) {
            return false;
        }
        this.memoizedIsInitialized = 1;
        return true;
    }

    public void writeTo(CodedOutputStream output) throws IOException {
        int i;
        if (!GeneratedMessageV3.isStringEmpty((Object)this.name_)) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)1, (Object)this.name_);
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.trackingId_)) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)2, (Object)this.trackingId_);
        }
        if ((this.bitField0_ & 1) != 0) {
            output.writeMessage(3, (MessageLite)this.getVehicleLocation());
        }
        for (i = 0; i < this.routePolylinePoints_.size(); ++i) {
            output.writeMessage(4, (MessageLite)this.routePolylinePoints_.get(i));
        }
        if ((this.bitField0_ & 2) != 0) {
            output.writeMessage(5, (MessageLite)this.getRemainingStopCount());
        }
        if ((this.bitField0_ & 4) != 0) {
            output.writeMessage(6, (MessageLite)this.getRemainingDrivingDistanceMeters());
        }
        if ((this.bitField0_ & 8) != 0) {
            output.writeMessage(7, (MessageLite)this.getEstimatedArrivalTime());
        }
        if ((this.bitField0_ & 0x10) != 0) {
            output.writeMessage(8, (MessageLite)this.getEstimatedTaskCompletionTime());
        }
        if (this.taskOutcome_ != Task.TaskOutcome.TASK_OUTCOME_UNSPECIFIED.getNumber()) {
            output.writeEnum(9, this.taskOutcome_);
        }
        if ((this.bitField0_ & 0x40) != 0) {
            output.writeMessage(10, (MessageLite)this.getPlannedLocation());
        }
        if (this.state_ != Task.State.STATE_UNSPECIFIED.getNumber()) {
            output.writeEnum(11, this.state_);
        }
        if ((this.bitField0_ & 0x20) != 0) {
            output.writeMessage(12, (MessageLite)this.getTaskOutcomeTime());
        }
        if ((this.bitField0_ & 0x80) != 0) {
            output.writeMessage(13, (MessageLite)this.getTargetTimeWindow());
        }
        for (i = 0; i < this.attributes_.size(); ++i) {
            output.writeMessage(14, (MessageLite)this.attributes_.get(i));
        }
        this.getUnknownFields().writeTo(output);
    }

    public int getSerializedSize() {
        int i;
        int size = this.memoizedSize;
        if (size != -1) {
            return size;
        }
        size = 0;
        if (!GeneratedMessageV3.isStringEmpty((Object)this.name_)) {
            size += GeneratedMessageV3.computeStringSize((int)1, (Object)this.name_);
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.trackingId_)) {
            size += GeneratedMessageV3.computeStringSize((int)2, (Object)this.trackingId_);
        }
        if ((this.bitField0_ & 1) != 0) {
            size += CodedOutputStream.computeMessageSize((int)3, (MessageLite)this.getVehicleLocation());
        }
        for (i = 0; i < this.routePolylinePoints_.size(); ++i) {
            size += CodedOutputStream.computeMessageSize((int)4, (MessageLite)((MessageLite)this.routePolylinePoints_.get(i)));
        }
        if ((this.bitField0_ & 2) != 0) {
            size += CodedOutputStream.computeMessageSize((int)5, (MessageLite)this.getRemainingStopCount());
        }
        if ((this.bitField0_ & 4) != 0) {
            size += CodedOutputStream.computeMessageSize((int)6, (MessageLite)this.getRemainingDrivingDistanceMeters());
        }
        if ((this.bitField0_ & 8) != 0) {
            size += CodedOutputStream.computeMessageSize((int)7, (MessageLite)this.getEstimatedArrivalTime());
        }
        if ((this.bitField0_ & 0x10) != 0) {
            size += CodedOutputStream.computeMessageSize((int)8, (MessageLite)this.getEstimatedTaskCompletionTime());
        }
        if (this.taskOutcome_ != Task.TaskOutcome.TASK_OUTCOME_UNSPECIFIED.getNumber()) {
            size += CodedOutputStream.computeEnumSize((int)9, (int)this.taskOutcome_);
        }
        if ((this.bitField0_ & 0x40) != 0) {
            size += CodedOutputStream.computeMessageSize((int)10, (MessageLite)this.getPlannedLocation());
        }
        if (this.state_ != Task.State.STATE_UNSPECIFIED.getNumber()) {
            size += CodedOutputStream.computeEnumSize((int)11, (int)this.state_);
        }
        if ((this.bitField0_ & 0x20) != 0) {
            size += CodedOutputStream.computeMessageSize((int)12, (MessageLite)this.getTaskOutcomeTime());
        }
        if ((this.bitField0_ & 0x80) != 0) {
            size += CodedOutputStream.computeMessageSize((int)13, (MessageLite)this.getTargetTimeWindow());
        }
        for (i = 0; i < this.attributes_.size(); ++i) {
            size += CodedOutputStream.computeMessageSize((int)14, (MessageLite)((MessageLite)this.attributes_.get(i)));
        }
        this.memoizedSize = size += this.getUnknownFields().getSerializedSize();
        return size;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof TaskTrackingInfo)) {
            return super.equals(obj);
        }
        TaskTrackingInfo other = (TaskTrackingInfo)obj;
        if (!this.getName().equals(other.getName())) {
            return false;
        }
        if (!this.getTrackingId().equals(other.getTrackingId())) {
            return false;
        }
        if (this.hasVehicleLocation() != other.hasVehicleLocation()) {
            return false;
        }
        if (this.hasVehicleLocation() && !this.getVehicleLocation().equals(other.getVehicleLocation())) {
            return false;
        }
        if (!this.getRoutePolylinePointsList().equals(other.getRoutePolylinePointsList())) {
            return false;
        }
        if (this.hasRemainingStopCount() != other.hasRemainingStopCount()) {
            return false;
        }
        if (this.hasRemainingStopCount() && !this.getRemainingStopCount().equals((Object)other.getRemainingStopCount())) {
            return false;
        }
        if (this.hasRemainingDrivingDistanceMeters() != other.hasRemainingDrivingDistanceMeters()) {
            return false;
        }
        if (this.hasRemainingDrivingDistanceMeters() && !this.getRemainingDrivingDistanceMeters().equals((Object)other.getRemainingDrivingDistanceMeters())) {
            return false;
        }
        if (this.hasEstimatedArrivalTime() != other.hasEstimatedArrivalTime()) {
            return false;
        }
        if (this.hasEstimatedArrivalTime() && !this.getEstimatedArrivalTime().equals((Object)other.getEstimatedArrivalTime())) {
            return false;
        }
        if (this.hasEstimatedTaskCompletionTime() != other.hasEstimatedTaskCompletionTime()) {
            return false;
        }
        if (this.hasEstimatedTaskCompletionTime() && !this.getEstimatedTaskCompletionTime().equals((Object)other.getEstimatedTaskCompletionTime())) {
            return false;
        }
        if (this.state_ != other.state_) {
            return false;
        }
        if (this.taskOutcome_ != other.taskOutcome_) {
            return false;
        }
        if (this.hasTaskOutcomeTime() != other.hasTaskOutcomeTime()) {
            return false;
        }
        if (this.hasTaskOutcomeTime() && !this.getTaskOutcomeTime().equals((Object)other.getTaskOutcomeTime())) {
            return false;
        }
        if (this.hasPlannedLocation() != other.hasPlannedLocation()) {
            return false;
        }
        if (this.hasPlannedLocation() && !this.getPlannedLocation().equals(other.getPlannedLocation())) {
            return false;
        }
        if (this.hasTargetTimeWindow() != other.hasTargetTimeWindow()) {
            return false;
        }
        if (this.hasTargetTimeWindow() && !this.getTargetTimeWindow().equals(other.getTargetTimeWindow())) {
            return false;
        }
        if (!this.getAttributesList().equals(other.getAttributesList())) {
            return false;
        }
        return this.getUnknownFields().equals((Object)other.getUnknownFields());
    }

    public int hashCode() {
        if (this.memoizedHashCode != 0) {
            return this.memoizedHashCode;
        }
        int hash = 41;
        hash = 19 * hash + TaskTrackingInfo.getDescriptor().hashCode();
        hash = 37 * hash + 1;
        hash = 53 * hash + this.getName().hashCode();
        hash = 37 * hash + 2;
        hash = 53 * hash + this.getTrackingId().hashCode();
        if (this.hasVehicleLocation()) {
            hash = 37 * hash + 3;
            hash = 53 * hash + this.getVehicleLocation().hashCode();
        }
        if (this.getRoutePolylinePointsCount() > 0) {
            hash = 37 * hash + 4;
            hash = 53 * hash + this.getRoutePolylinePointsList().hashCode();
        }
        if (this.hasRemainingStopCount()) {
            hash = 37 * hash + 5;
            hash = 53 * hash + this.getRemainingStopCount().hashCode();
        }
        if (this.hasRemainingDrivingDistanceMeters()) {
            hash = 37 * hash + 6;
            hash = 53 * hash + this.getRemainingDrivingDistanceMeters().hashCode();
        }
        if (this.hasEstimatedArrivalTime()) {
            hash = 37 * hash + 7;
            hash = 53 * hash + this.getEstimatedArrivalTime().hashCode();
        }
        if (this.hasEstimatedTaskCompletionTime()) {
            hash = 37 * hash + 8;
            hash = 53 * hash + this.getEstimatedTaskCompletionTime().hashCode();
        }
        hash = 37 * hash + 11;
        hash = 53 * hash + this.state_;
        hash = 37 * hash + 9;
        hash = 53 * hash + this.taskOutcome_;
        if (this.hasTaskOutcomeTime()) {
            hash = 37 * hash + 12;
            hash = 53 * hash + this.getTaskOutcomeTime().hashCode();
        }
        if (this.hasPlannedLocation()) {
            hash = 37 * hash + 10;
            hash = 53 * hash + this.getPlannedLocation().hashCode();
        }
        if (this.hasTargetTimeWindow()) {
            hash = 37 * hash + 13;
            hash = 53 * hash + this.getTargetTimeWindow().hashCode();
        }
        if (this.getAttributesCount() > 0) {
            hash = 37 * hash + 14;
            hash = 53 * hash + this.getAttributesList().hashCode();
        }
        this.memoizedHashCode = hash = 29 * hash + this.getUnknownFields().hashCode();
        return hash;
    }

    public static TaskTrackingInfo parseFrom(ByteBuffer data) throws InvalidProtocolBufferException {
        return (TaskTrackingInfo)PARSER.parseFrom(data);
    }

    public static TaskTrackingInfo parseFrom(ByteBuffer data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (TaskTrackingInfo)PARSER.parseFrom(data, extensionRegistry);
    }

    public static TaskTrackingInfo parseFrom(ByteString data) throws InvalidProtocolBufferException {
        return (TaskTrackingInfo)PARSER.parseFrom(data);
    }

    public static TaskTrackingInfo parseFrom(ByteString data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (TaskTrackingInfo)PARSER.parseFrom(data, extensionRegistry);
    }

    public static TaskTrackingInfo parseFrom(byte[] data) throws InvalidProtocolBufferException {
        return (TaskTrackingInfo)PARSER.parseFrom(data);
    }

    public static TaskTrackingInfo parseFrom(byte[] data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (TaskTrackingInfo)PARSER.parseFrom(data, extensionRegistry);
    }

    public static TaskTrackingInfo parseFrom(InputStream input) throws IOException {
        return (TaskTrackingInfo)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input);
    }

    public static TaskTrackingInfo parseFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (TaskTrackingInfo)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public static TaskTrackingInfo parseDelimitedFrom(InputStream input) throws IOException {
        return (TaskTrackingInfo)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input);
    }

    public static TaskTrackingInfo parseDelimitedFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (TaskTrackingInfo)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public static TaskTrackingInfo parseFrom(CodedInputStream input) throws IOException {
        return (TaskTrackingInfo)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input);
    }

    public static TaskTrackingInfo parseFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (TaskTrackingInfo)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public Builder newBuilderForType() {
        return TaskTrackingInfo.newBuilder();
    }

    public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(TaskTrackingInfo prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    protected Builder newBuilderForType(GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
    }

    public static TaskTrackingInfo getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public static Parser<TaskTrackingInfo> parser() {
        return PARSER;
    }

    public Parser<TaskTrackingInfo> getParserForType() {
        return PARSER;
    }

    public TaskTrackingInfo getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
    }

    public static final class Builder
    extends GeneratedMessageV3.Builder<Builder>
    implements TaskTrackingInfoOrBuilder {
        private int bitField0_;
        private Object name_ = "";
        private Object trackingId_ = "";
        private DeliveryVehicleLocation vehicleLocation_;
        private SingleFieldBuilderV3<DeliveryVehicleLocation, DeliveryVehicleLocation.Builder, DeliveryVehicleLocationOrBuilder> vehicleLocationBuilder_;
        private List<LatLng> routePolylinePoints_ = Collections.emptyList();
        private RepeatedFieldBuilderV3<LatLng, LatLng.Builder, LatLngOrBuilder> routePolylinePointsBuilder_;
        private Int32Value remainingStopCount_;
        private SingleFieldBuilderV3<Int32Value, Int32Value.Builder, Int32ValueOrBuilder> remainingStopCountBuilder_;
        private Int32Value remainingDrivingDistanceMeters_;
        private SingleFieldBuilderV3<Int32Value, Int32Value.Builder, Int32ValueOrBuilder> remainingDrivingDistanceMetersBuilder_;
        private Timestamp estimatedArrivalTime_;
        private SingleFieldBuilderV3<Timestamp, Timestamp.Builder, TimestampOrBuilder> estimatedArrivalTimeBuilder_;
        private Timestamp estimatedTaskCompletionTime_;
        private SingleFieldBuilderV3<Timestamp, Timestamp.Builder, TimestampOrBuilder> estimatedTaskCompletionTimeBuilder_;
        private int state_ = 0;
        private int taskOutcome_ = 0;
        private Timestamp taskOutcomeTime_;
        private SingleFieldBuilderV3<Timestamp, Timestamp.Builder, TimestampOrBuilder> taskOutcomeTimeBuilder_;
        private LocationInfo plannedLocation_;
        private SingleFieldBuilderV3<LocationInfo, LocationInfo.Builder, LocationInfoOrBuilder> plannedLocationBuilder_;
        private TimeWindow targetTimeWindow_;
        private SingleFieldBuilderV3<TimeWindow, TimeWindow.Builder, TimeWindowOrBuilder> targetTimeWindowBuilder_;
        private List<TaskAttribute> attributes_ = Collections.emptyList();
        private RepeatedFieldBuilderV3<TaskAttribute, TaskAttribute.Builder, TaskAttributeOrBuilder> attributesBuilder_;

        public static final Descriptors.Descriptor getDescriptor() {
            return TaskTrackingInfoProto.internal_static_maps_fleetengine_delivery_v1_TaskTrackingInfo_descriptor;
        }

        protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
            return TaskTrackingInfoProto.internal_static_maps_fleetengine_delivery_v1_TaskTrackingInfo_fieldAccessorTable.ensureFieldAccessorsInitialized(TaskTrackingInfo.class, Builder.class);
        }

        private Builder() {
            this.maybeForceBuilderInitialization();
        }

        private Builder(GeneratedMessageV3.BuilderParent parent) {
            super(parent);
            this.maybeForceBuilderInitialization();
        }

        private void maybeForceBuilderInitialization() {
            if (alwaysUseFieldBuilders) {
                this.getVehicleLocationFieldBuilder();
                this.getRoutePolylinePointsFieldBuilder();
                this.getRemainingStopCountFieldBuilder();
                this.getRemainingDrivingDistanceMetersFieldBuilder();
                this.getEstimatedArrivalTimeFieldBuilder();
                this.getEstimatedTaskCompletionTimeFieldBuilder();
                this.getTaskOutcomeTimeFieldBuilder();
                this.getPlannedLocationFieldBuilder();
                this.getTargetTimeWindowFieldBuilder();
                this.getAttributesFieldBuilder();
            }
        }

        public Builder clear() {
            super.clear();
            this.bitField0_ = 0;
            this.name_ = "";
            this.trackingId_ = "";
            this.vehicleLocation_ = null;
            if (this.vehicleLocationBuilder_ != null) {
                this.vehicleLocationBuilder_.dispose();
                this.vehicleLocationBuilder_ = null;
            }
            if (this.routePolylinePointsBuilder_ == null) {
                this.routePolylinePoints_ = Collections.emptyList();
            } else {
                this.routePolylinePoints_ = null;
                this.routePolylinePointsBuilder_.clear();
            }
            this.bitField0_ &= 0xFFFFFFF7;
            this.remainingStopCount_ = null;
            if (this.remainingStopCountBuilder_ != null) {
                this.remainingStopCountBuilder_.dispose();
                this.remainingStopCountBuilder_ = null;
            }
            this.remainingDrivingDistanceMeters_ = null;
            if (this.remainingDrivingDistanceMetersBuilder_ != null) {
                this.remainingDrivingDistanceMetersBuilder_.dispose();
                this.remainingDrivingDistanceMetersBuilder_ = null;
            }
            this.estimatedArrivalTime_ = null;
            if (this.estimatedArrivalTimeBuilder_ != null) {
                this.estimatedArrivalTimeBuilder_.dispose();
                this.estimatedArrivalTimeBuilder_ = null;
            }
            this.estimatedTaskCompletionTime_ = null;
            if (this.estimatedTaskCompletionTimeBuilder_ != null) {
                this.estimatedTaskCompletionTimeBuilder_.dispose();
                this.estimatedTaskCompletionTimeBuilder_ = null;
            }
            this.state_ = 0;
            this.taskOutcome_ = 0;
            this.taskOutcomeTime_ = null;
            if (this.taskOutcomeTimeBuilder_ != null) {
                this.taskOutcomeTimeBuilder_.dispose();
                this.taskOutcomeTimeBuilder_ = null;
            }
            this.plannedLocation_ = null;
            if (this.plannedLocationBuilder_ != null) {
                this.plannedLocationBuilder_.dispose();
                this.plannedLocationBuilder_ = null;
            }
            this.targetTimeWindow_ = null;
            if (this.targetTimeWindowBuilder_ != null) {
                this.targetTimeWindowBuilder_.dispose();
                this.targetTimeWindowBuilder_ = null;
            }
            if (this.attributesBuilder_ == null) {
                this.attributes_ = Collections.emptyList();
            } else {
                this.attributes_ = null;
                this.attributesBuilder_.clear();
            }
            this.bitField0_ &= 0xFFFFDFFF;
            return this;
        }

        public Descriptors.Descriptor getDescriptorForType() {
            return TaskTrackingInfoProto.internal_static_maps_fleetengine_delivery_v1_TaskTrackingInfo_descriptor;
        }

        public TaskTrackingInfo getDefaultInstanceForType() {
            return TaskTrackingInfo.getDefaultInstance();
        }

        public TaskTrackingInfo build() {
            TaskTrackingInfo result = this.buildPartial();
            if (!result.isInitialized()) {
                throw Builder.newUninitializedMessageException((Message)result);
            }
            return result;
        }

        public TaskTrackingInfo buildPartial() {
            TaskTrackingInfo result = new TaskTrackingInfo(this);
            this.buildPartialRepeatedFields(result);
            if (this.bitField0_ != 0) {
                this.buildPartial0(result);
            }
            this.onBuilt();
            return result;
        }

        private void buildPartialRepeatedFields(TaskTrackingInfo result) {
            if (this.routePolylinePointsBuilder_ == null) {
                if ((this.bitField0_ & 8) != 0) {
                    this.routePolylinePoints_ = Collections.unmodifiableList(this.routePolylinePoints_);
                    this.bitField0_ &= 0xFFFFFFF7;
                }
                result.routePolylinePoints_ = this.routePolylinePoints_;
            } else {
                result.routePolylinePoints_ = this.routePolylinePointsBuilder_.build();
            }
            if (this.attributesBuilder_ == null) {
                if ((this.bitField0_ & 0x2000) != 0) {
                    this.attributes_ = Collections.unmodifiableList(this.attributes_);
                    this.bitField0_ &= 0xFFFFDFFF;
                }
                result.attributes_ = this.attributes_;
            } else {
                result.attributes_ = this.attributesBuilder_.build();
            }
        }

        private void buildPartial0(TaskTrackingInfo result) {
            int from_bitField0_ = this.bitField0_;
            if ((from_bitField0_ & 1) != 0) {
                result.name_ = this.name_;
            }
            if ((from_bitField0_ & 2) != 0) {
                result.trackingId_ = this.trackingId_;
            }
            int to_bitField0_ = 0;
            if ((from_bitField0_ & 4) != 0) {
                result.vehicleLocation_ = this.vehicleLocationBuilder_ == null ? this.vehicleLocation_ : (DeliveryVehicleLocation)this.vehicleLocationBuilder_.build();
                to_bitField0_ |= 1;
            }
            if ((from_bitField0_ & 0x10) != 0) {
                result.remainingStopCount_ = this.remainingStopCountBuilder_ == null ? this.remainingStopCount_ : (Int32Value)this.remainingStopCountBuilder_.build();
                to_bitField0_ |= 2;
            }
            if ((from_bitField0_ & 0x20) != 0) {
                result.remainingDrivingDistanceMeters_ = this.remainingDrivingDistanceMetersBuilder_ == null ? this.remainingDrivingDistanceMeters_ : (Int32Value)this.remainingDrivingDistanceMetersBuilder_.build();
                to_bitField0_ |= 4;
            }
            if ((from_bitField0_ & 0x40) != 0) {
                result.estimatedArrivalTime_ = this.estimatedArrivalTimeBuilder_ == null ? this.estimatedArrivalTime_ : (Timestamp)this.estimatedArrivalTimeBuilder_.build();
                to_bitField0_ |= 8;
            }
            if ((from_bitField0_ & 0x80) != 0) {
                result.estimatedTaskCompletionTime_ = this.estimatedTaskCompletionTimeBuilder_ == null ? this.estimatedTaskCompletionTime_ : (Timestamp)this.estimatedTaskCompletionTimeBuilder_.build();
                to_bitField0_ |= 0x10;
            }
            if ((from_bitField0_ & 0x100) != 0) {
                result.state_ = this.state_;
            }
            if ((from_bitField0_ & 0x200) != 0) {
                result.taskOutcome_ = this.taskOutcome_;
            }
            if ((from_bitField0_ & 0x400) != 0) {
                result.taskOutcomeTime_ = this.taskOutcomeTimeBuilder_ == null ? this.taskOutcomeTime_ : (Timestamp)this.taskOutcomeTimeBuilder_.build();
                to_bitField0_ |= 0x20;
            }
            if ((from_bitField0_ & 0x800) != 0) {
                result.plannedLocation_ = this.plannedLocationBuilder_ == null ? this.plannedLocation_ : (LocationInfo)this.plannedLocationBuilder_.build();
                to_bitField0_ |= 0x40;
            }
            if ((from_bitField0_ & 0x1000) != 0) {
                result.targetTimeWindow_ = this.targetTimeWindowBuilder_ == null ? this.targetTimeWindow_ : (TimeWindow)this.targetTimeWindowBuilder_.build();
                to_bitField0_ |= 0x80;
            }
            TaskTrackingInfo taskTrackingInfo = result;
            taskTrackingInfo.bitField0_ = taskTrackingInfo.bitField0_ | to_bitField0_;
        }

        public Builder clone() {
            return (Builder)super.clone();
        }

        public Builder setField(Descriptors.FieldDescriptor field, Object value) {
            return (Builder)super.setField(field, value);
        }

        public Builder clearField(Descriptors.FieldDescriptor field) {
            return (Builder)super.clearField(field);
        }

        public Builder clearOneof(Descriptors.OneofDescriptor oneof) {
            return (Builder)super.clearOneof(oneof);
        }

        public Builder setRepeatedField(Descriptors.FieldDescriptor field, int index, Object value) {
            return (Builder)super.setRepeatedField(field, index, value);
        }

        public Builder addRepeatedField(Descriptors.FieldDescriptor field, Object value) {
            return (Builder)super.addRepeatedField(field, value);
        }

        public Builder mergeFrom(Message other) {
            if (other instanceof TaskTrackingInfo) {
                return this.mergeFrom((TaskTrackingInfo)other);
            }
            super.mergeFrom(other);
            return this;
        }

        public Builder mergeFrom(TaskTrackingInfo other) {
            if (other == TaskTrackingInfo.getDefaultInstance()) {
                return this;
            }
            if (!other.getName().isEmpty()) {
                this.name_ = other.name_;
                this.bitField0_ |= 1;
                this.onChanged();
            }
            if (!other.getTrackingId().isEmpty()) {
                this.trackingId_ = other.trackingId_;
                this.bitField0_ |= 2;
                this.onChanged();
            }
            if (other.hasVehicleLocation()) {
                this.mergeVehicleLocation(other.getVehicleLocation());
            }
            if (this.routePolylinePointsBuilder_ == null) {
                if (!other.routePolylinePoints_.isEmpty()) {
                    if (this.routePolylinePoints_.isEmpty()) {
                        this.routePolylinePoints_ = other.routePolylinePoints_;
                        this.bitField0_ &= 0xFFFFFFF7;
                    } else {
                        this.ensureRoutePolylinePointsIsMutable();
                        this.routePolylinePoints_.addAll(other.routePolylinePoints_);
                    }
                    this.onChanged();
                }
            } else if (!other.routePolylinePoints_.isEmpty()) {
                if (this.routePolylinePointsBuilder_.isEmpty()) {
                    this.routePolylinePointsBuilder_.dispose();
                    this.routePolylinePointsBuilder_ = null;
                    this.routePolylinePoints_ = other.routePolylinePoints_;
                    this.bitField0_ &= 0xFFFFFFF7;
                    this.routePolylinePointsBuilder_ = alwaysUseFieldBuilders ? this.getRoutePolylinePointsFieldBuilder() : null;
                } else {
                    this.routePolylinePointsBuilder_.addAllMessages((Iterable)other.routePolylinePoints_);
                }
            }
            if (other.hasRemainingStopCount()) {
                this.mergeRemainingStopCount(other.getRemainingStopCount());
            }
            if (other.hasRemainingDrivingDistanceMeters()) {
                this.mergeRemainingDrivingDistanceMeters(other.getRemainingDrivingDistanceMeters());
            }
            if (other.hasEstimatedArrivalTime()) {
                this.mergeEstimatedArrivalTime(other.getEstimatedArrivalTime());
            }
            if (other.hasEstimatedTaskCompletionTime()) {
                this.mergeEstimatedTaskCompletionTime(other.getEstimatedTaskCompletionTime());
            }
            if (other.state_ != 0) {
                this.setStateValue(other.getStateValue());
            }
            if (other.taskOutcome_ != 0) {
                this.setTaskOutcomeValue(other.getTaskOutcomeValue());
            }
            if (other.hasTaskOutcomeTime()) {
                this.mergeTaskOutcomeTime(other.getTaskOutcomeTime());
            }
            if (other.hasPlannedLocation()) {
                this.mergePlannedLocation(other.getPlannedLocation());
            }
            if (other.hasTargetTimeWindow()) {
                this.mergeTargetTimeWindow(other.getTargetTimeWindow());
            }
            if (this.attributesBuilder_ == null) {
                if (!other.attributes_.isEmpty()) {
                    if (this.attributes_.isEmpty()) {
                        this.attributes_ = other.attributes_;
                        this.bitField0_ &= 0xFFFFDFFF;
                    } else {
                        this.ensureAttributesIsMutable();
                        this.attributes_.addAll(other.attributes_);
                    }
                    this.onChanged();
                }
            } else if (!other.attributes_.isEmpty()) {
                if (this.attributesBuilder_.isEmpty()) {
                    this.attributesBuilder_.dispose();
                    this.attributesBuilder_ = null;
                    this.attributes_ = other.attributes_;
                    this.bitField0_ &= 0xFFFFDFFF;
                    this.attributesBuilder_ = alwaysUseFieldBuilders ? this.getAttributesFieldBuilder() : null;
                } else {
                    this.attributesBuilder_.addAllMessages((Iterable)other.attributes_);
                }
            }
            this.mergeUnknownFields(other.getUnknownFields());
            this.onChanged();
            return this;
        }

        public final boolean isInitialized() {
            return true;
        }

        public Builder mergeFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            if (extensionRegistry == null) {
                throw new NullPointerException();
            }
            try {
                boolean done = false;
                block22: while (!done) {
                    int tag = input.readTag();
                    switch (tag) {
                        case 0: {
                            done = true;
                            continue block22;
                        }
                        case 10: {
                            this.name_ = input.readStringRequireUtf8();
                            this.bitField0_ |= 1;
                            continue block22;
                        }
                        case 18: {
                            this.trackingId_ = input.readStringRequireUtf8();
                            this.bitField0_ |= 2;
                            continue block22;
                        }
                        case 26: {
                            input.readMessage((MessageLite.Builder)this.getVehicleLocationFieldBuilder().getBuilder(), extensionRegistry);
                            this.bitField0_ |= 4;
                            continue block22;
                        }
                        case 34: {
                            Object m = (LatLng)input.readMessage(LatLng.parser(), extensionRegistry);
                            if (this.routePolylinePointsBuilder_ == null) {
                                this.ensureRoutePolylinePointsIsMutable();
                                this.routePolylinePoints_.add((LatLng)m);
                                continue block22;
                            }
                            this.routePolylinePointsBuilder_.addMessage((AbstractMessage)m);
                            continue block22;
                        }
                        case 42: {
                            input.readMessage((MessageLite.Builder)this.getRemainingStopCountFieldBuilder().getBuilder(), extensionRegistry);
                            this.bitField0_ |= 0x10;
                            continue block22;
                        }
                        case 50: {
                            input.readMessage((MessageLite.Builder)this.getRemainingDrivingDistanceMetersFieldBuilder().getBuilder(), extensionRegistry);
                            this.bitField0_ |= 0x20;
                            continue block22;
                        }
                        case 58: {
                            input.readMessage((MessageLite.Builder)this.getEstimatedArrivalTimeFieldBuilder().getBuilder(), extensionRegistry);
                            this.bitField0_ |= 0x40;
                            continue block22;
                        }
                        case 66: {
                            input.readMessage((MessageLite.Builder)this.getEstimatedTaskCompletionTimeFieldBuilder().getBuilder(), extensionRegistry);
                            this.bitField0_ |= 0x80;
                            continue block22;
                        }
                        case 72: {
                            this.taskOutcome_ = input.readEnum();
                            this.bitField0_ |= 0x200;
                            continue block22;
                        }
                        case 82: {
                            input.readMessage((MessageLite.Builder)this.getPlannedLocationFieldBuilder().getBuilder(), extensionRegistry);
                            this.bitField0_ |= 0x800;
                            continue block22;
                        }
                        case 88: {
                            this.state_ = input.readEnum();
                            this.bitField0_ |= 0x100;
                            continue block22;
                        }
                        case 98: {
                            input.readMessage((MessageLite.Builder)this.getTaskOutcomeTimeFieldBuilder().getBuilder(), extensionRegistry);
                            this.bitField0_ |= 0x400;
                            continue block22;
                        }
                        case 106: {
                            input.readMessage((MessageLite.Builder)this.getTargetTimeWindowFieldBuilder().getBuilder(), extensionRegistry);
                            this.bitField0_ |= 0x1000;
                            continue block22;
                        }
                        case 114: {
                            Object m = (TaskAttribute)input.readMessage(TaskAttribute.parser(), extensionRegistry);
                            if (this.attributesBuilder_ == null) {
                                this.ensureAttributesIsMutable();
                                this.attributes_.add((TaskAttribute)m);
                                continue block22;
                            }
                            this.attributesBuilder_.addMessage((AbstractMessage)m);
                            continue block22;
                        }
                    }
                    if (super.parseUnknownField(input, extensionRegistry, tag)) continue;
                    done = true;
                }
            }
            catch (InvalidProtocolBufferException e) {
                throw e.unwrapIOException();
            }
            finally {
                this.onChanged();
            }
            return this;
        }

        @Override
        public String getName() {
            Object ref = this.name_;
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                this.name_ = s;
                return s;
            }
            return (String)ref;
        }

        @Override
        public ByteString getNameBytes() {
            Object ref = this.name_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.name_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public Builder setName(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.name_ = value;
            this.bitField0_ |= 1;
            this.onChanged();
            return this;
        }

        public Builder clearName() {
            this.name_ = TaskTrackingInfo.getDefaultInstance().getName();
            this.bitField0_ &= 0xFFFFFFFE;
            this.onChanged();
            return this;
        }

        public Builder setNameBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            TaskTrackingInfo.checkByteStringIsUtf8((ByteString)value);
            this.name_ = value;
            this.bitField0_ |= 1;
            this.onChanged();
            return this;
        }

        @Override
        public String getTrackingId() {
            Object ref = this.trackingId_;
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                this.trackingId_ = s;
                return s;
            }
            return (String)ref;
        }

        @Override
        public ByteString getTrackingIdBytes() {
            Object ref = this.trackingId_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.trackingId_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public Builder setTrackingId(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.trackingId_ = value;
            this.bitField0_ |= 2;
            this.onChanged();
            return this;
        }

        public Builder clearTrackingId() {
            this.trackingId_ = TaskTrackingInfo.getDefaultInstance().getTrackingId();
            this.bitField0_ &= 0xFFFFFFFD;
            this.onChanged();
            return this;
        }

        public Builder setTrackingIdBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            TaskTrackingInfo.checkByteStringIsUtf8((ByteString)value);
            this.trackingId_ = value;
            this.bitField0_ |= 2;
            this.onChanged();
            return this;
        }

        @Override
        public boolean hasVehicleLocation() {
            return (this.bitField0_ & 4) != 0;
        }

        @Override
        public DeliveryVehicleLocation getVehicleLocation() {
            if (this.vehicleLocationBuilder_ == null) {
                return this.vehicleLocation_ == null ? DeliveryVehicleLocation.getDefaultInstance() : this.vehicleLocation_;
            }
            return (DeliveryVehicleLocation)this.vehicleLocationBuilder_.getMessage();
        }

        public Builder setVehicleLocation(DeliveryVehicleLocation value) {
            if (this.vehicleLocationBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.vehicleLocation_ = value;
            } else {
                this.vehicleLocationBuilder_.setMessage((AbstractMessage)value);
            }
            this.bitField0_ |= 4;
            this.onChanged();
            return this;
        }

        public Builder setVehicleLocation(DeliveryVehicleLocation.Builder builderForValue) {
            if (this.vehicleLocationBuilder_ == null) {
                this.vehicleLocation_ = builderForValue.build();
            } else {
                this.vehicleLocationBuilder_.setMessage((AbstractMessage)builderForValue.build());
            }
            this.bitField0_ |= 4;
            this.onChanged();
            return this;
        }

        public Builder mergeVehicleLocation(DeliveryVehicleLocation value) {
            if (this.vehicleLocationBuilder_ == null) {
                if ((this.bitField0_ & 4) != 0 && this.vehicleLocation_ != null && this.vehicleLocation_ != DeliveryVehicleLocation.getDefaultInstance()) {
                    this.getVehicleLocationBuilder().mergeFrom(value);
                } else {
                    this.vehicleLocation_ = value;
                }
            } else {
                this.vehicleLocationBuilder_.mergeFrom((AbstractMessage)value);
            }
            if (this.vehicleLocation_ != null) {
                this.bitField0_ |= 4;
                this.onChanged();
            }
            return this;
        }

        public Builder clearVehicleLocation() {
            this.bitField0_ &= 0xFFFFFFFB;
            this.vehicleLocation_ = null;
            if (this.vehicleLocationBuilder_ != null) {
                this.vehicleLocationBuilder_.dispose();
                this.vehicleLocationBuilder_ = null;
            }
            this.onChanged();
            return this;
        }

        public DeliveryVehicleLocation.Builder getVehicleLocationBuilder() {
            this.bitField0_ |= 4;
            this.onChanged();
            return (DeliveryVehicleLocation.Builder)this.getVehicleLocationFieldBuilder().getBuilder();
        }

        @Override
        public DeliveryVehicleLocationOrBuilder getVehicleLocationOrBuilder() {
            if (this.vehicleLocationBuilder_ != null) {
                return (DeliveryVehicleLocationOrBuilder)this.vehicleLocationBuilder_.getMessageOrBuilder();
            }
            return this.vehicleLocation_ == null ? DeliveryVehicleLocation.getDefaultInstance() : this.vehicleLocation_;
        }

        private SingleFieldBuilderV3<DeliveryVehicleLocation, DeliveryVehicleLocation.Builder, DeliveryVehicleLocationOrBuilder> getVehicleLocationFieldBuilder() {
            if (this.vehicleLocationBuilder_ == null) {
                this.vehicleLocationBuilder_ = new SingleFieldBuilderV3((AbstractMessage)this.getVehicleLocation(), (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.vehicleLocation_ = null;
            }
            return this.vehicleLocationBuilder_;
        }

        private void ensureRoutePolylinePointsIsMutable() {
            if ((this.bitField0_ & 8) == 0) {
                this.routePolylinePoints_ = new ArrayList<LatLng>(this.routePolylinePoints_);
                this.bitField0_ |= 8;
            }
        }

        @Override
        public List<LatLng> getRoutePolylinePointsList() {
            if (this.routePolylinePointsBuilder_ == null) {
                return Collections.unmodifiableList(this.routePolylinePoints_);
            }
            return this.routePolylinePointsBuilder_.getMessageList();
        }

        @Override
        public int getRoutePolylinePointsCount() {
            if (this.routePolylinePointsBuilder_ == null) {
                return this.routePolylinePoints_.size();
            }
            return this.routePolylinePointsBuilder_.getCount();
        }

        @Override
        public LatLng getRoutePolylinePoints(int index) {
            if (this.routePolylinePointsBuilder_ == null) {
                return this.routePolylinePoints_.get(index);
            }
            return (LatLng)this.routePolylinePointsBuilder_.getMessage(index);
        }

        public Builder setRoutePolylinePoints(int index, LatLng value) {
            if (this.routePolylinePointsBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureRoutePolylinePointsIsMutable();
                this.routePolylinePoints_.set(index, value);
                this.onChanged();
            } else {
                this.routePolylinePointsBuilder_.setMessage(index, (AbstractMessage)value);
            }
            return this;
        }

        public Builder setRoutePolylinePoints(int index, LatLng.Builder builderForValue) {
            if (this.routePolylinePointsBuilder_ == null) {
                this.ensureRoutePolylinePointsIsMutable();
                this.routePolylinePoints_.set(index, builderForValue.build());
                this.onChanged();
            } else {
                this.routePolylinePointsBuilder_.setMessage(index, (AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addRoutePolylinePoints(LatLng value) {
            if (this.routePolylinePointsBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureRoutePolylinePointsIsMutable();
                this.routePolylinePoints_.add(value);
                this.onChanged();
            } else {
                this.routePolylinePointsBuilder_.addMessage((AbstractMessage)value);
            }
            return this;
        }

        public Builder addRoutePolylinePoints(int index, LatLng value) {
            if (this.routePolylinePointsBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureRoutePolylinePointsIsMutable();
                this.routePolylinePoints_.add(index, value);
                this.onChanged();
            } else {
                this.routePolylinePointsBuilder_.addMessage(index, (AbstractMessage)value);
            }
            return this;
        }

        public Builder addRoutePolylinePoints(LatLng.Builder builderForValue) {
            if (this.routePolylinePointsBuilder_ == null) {
                this.ensureRoutePolylinePointsIsMutable();
                this.routePolylinePoints_.add(builderForValue.build());
                this.onChanged();
            } else {
                this.routePolylinePointsBuilder_.addMessage((AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addRoutePolylinePoints(int index, LatLng.Builder builderForValue) {
            if (this.routePolylinePointsBuilder_ == null) {
                this.ensureRoutePolylinePointsIsMutable();
                this.routePolylinePoints_.add(index, builderForValue.build());
                this.onChanged();
            } else {
                this.routePolylinePointsBuilder_.addMessage(index, (AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addAllRoutePolylinePoints(Iterable<? extends LatLng> values) {
            if (this.routePolylinePointsBuilder_ == null) {
                this.ensureRoutePolylinePointsIsMutable();
                AbstractMessageLite.Builder.addAll(values, this.routePolylinePoints_);
                this.onChanged();
            } else {
                this.routePolylinePointsBuilder_.addAllMessages(values);
            }
            return this;
        }

        public Builder clearRoutePolylinePoints() {
            if (this.routePolylinePointsBuilder_ == null) {
                this.routePolylinePoints_ = Collections.emptyList();
                this.bitField0_ &= 0xFFFFFFF7;
                this.onChanged();
            } else {
                this.routePolylinePointsBuilder_.clear();
            }
            return this;
        }

        public Builder removeRoutePolylinePoints(int index) {
            if (this.routePolylinePointsBuilder_ == null) {
                this.ensureRoutePolylinePointsIsMutable();
                this.routePolylinePoints_.remove(index);
                this.onChanged();
            } else {
                this.routePolylinePointsBuilder_.remove(index);
            }
            return this;
        }

        public LatLng.Builder getRoutePolylinePointsBuilder(int index) {
            return (LatLng.Builder)this.getRoutePolylinePointsFieldBuilder().getBuilder(index);
        }

        @Override
        public LatLngOrBuilder getRoutePolylinePointsOrBuilder(int index) {
            if (this.routePolylinePointsBuilder_ == null) {
                return (LatLngOrBuilder)this.routePolylinePoints_.get(index);
            }
            return (LatLngOrBuilder)this.routePolylinePointsBuilder_.getMessageOrBuilder(index);
        }

        @Override
        public List<? extends LatLngOrBuilder> getRoutePolylinePointsOrBuilderList() {
            if (this.routePolylinePointsBuilder_ != null) {
                return this.routePolylinePointsBuilder_.getMessageOrBuilderList();
            }
            return Collections.unmodifiableList(this.routePolylinePoints_);
        }

        public LatLng.Builder addRoutePolylinePointsBuilder() {
            return (LatLng.Builder)this.getRoutePolylinePointsFieldBuilder().addBuilder((AbstractMessage)LatLng.getDefaultInstance());
        }

        public LatLng.Builder addRoutePolylinePointsBuilder(int index) {
            return (LatLng.Builder)this.getRoutePolylinePointsFieldBuilder().addBuilder(index, (AbstractMessage)LatLng.getDefaultInstance());
        }

        public List<LatLng.Builder> getRoutePolylinePointsBuilderList() {
            return this.getRoutePolylinePointsFieldBuilder().getBuilderList();
        }

        private RepeatedFieldBuilderV3<LatLng, LatLng.Builder, LatLngOrBuilder> getRoutePolylinePointsFieldBuilder() {
            if (this.routePolylinePointsBuilder_ == null) {
                this.routePolylinePointsBuilder_ = new RepeatedFieldBuilderV3(this.routePolylinePoints_, (this.bitField0_ & 8) != 0, (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.routePolylinePoints_ = null;
            }
            return this.routePolylinePointsBuilder_;
        }

        @Override
        public boolean hasRemainingStopCount() {
            return (this.bitField0_ & 0x10) != 0;
        }

        @Override
        public Int32Value getRemainingStopCount() {
            if (this.remainingStopCountBuilder_ == null) {
                return this.remainingStopCount_ == null ? Int32Value.getDefaultInstance() : this.remainingStopCount_;
            }
            return (Int32Value)this.remainingStopCountBuilder_.getMessage();
        }

        public Builder setRemainingStopCount(Int32Value value) {
            if (this.remainingStopCountBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.remainingStopCount_ = value;
            } else {
                this.remainingStopCountBuilder_.setMessage((AbstractMessage)value);
            }
            this.bitField0_ |= 0x10;
            this.onChanged();
            return this;
        }

        public Builder setRemainingStopCount(Int32Value.Builder builderForValue) {
            if (this.remainingStopCountBuilder_ == null) {
                this.remainingStopCount_ = builderForValue.build();
            } else {
                this.remainingStopCountBuilder_.setMessage((AbstractMessage)builderForValue.build());
            }
            this.bitField0_ |= 0x10;
            this.onChanged();
            return this;
        }

        public Builder mergeRemainingStopCount(Int32Value value) {
            if (this.remainingStopCountBuilder_ == null) {
                if ((this.bitField0_ & 0x10) != 0 && this.remainingStopCount_ != null && this.remainingStopCount_ != Int32Value.getDefaultInstance()) {
                    this.getRemainingStopCountBuilder().mergeFrom(value);
                } else {
                    this.remainingStopCount_ = value;
                }
            } else {
                this.remainingStopCountBuilder_.mergeFrom((AbstractMessage)value);
            }
            if (this.remainingStopCount_ != null) {
                this.bitField0_ |= 0x10;
                this.onChanged();
            }
            return this;
        }

        public Builder clearRemainingStopCount() {
            this.bitField0_ &= 0xFFFFFFEF;
            this.remainingStopCount_ = null;
            if (this.remainingStopCountBuilder_ != null) {
                this.remainingStopCountBuilder_.dispose();
                this.remainingStopCountBuilder_ = null;
            }
            this.onChanged();
            return this;
        }

        public Int32Value.Builder getRemainingStopCountBuilder() {
            this.bitField0_ |= 0x10;
            this.onChanged();
            return (Int32Value.Builder)this.getRemainingStopCountFieldBuilder().getBuilder();
        }

        @Override
        public Int32ValueOrBuilder getRemainingStopCountOrBuilder() {
            if (this.remainingStopCountBuilder_ != null) {
                return (Int32ValueOrBuilder)this.remainingStopCountBuilder_.getMessageOrBuilder();
            }
            return this.remainingStopCount_ == null ? Int32Value.getDefaultInstance() : this.remainingStopCount_;
        }

        private SingleFieldBuilderV3<Int32Value, Int32Value.Builder, Int32ValueOrBuilder> getRemainingStopCountFieldBuilder() {
            if (this.remainingStopCountBuilder_ == null) {
                this.remainingStopCountBuilder_ = new SingleFieldBuilderV3((AbstractMessage)this.getRemainingStopCount(), (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.remainingStopCount_ = null;
            }
            return this.remainingStopCountBuilder_;
        }

        @Override
        public boolean hasRemainingDrivingDistanceMeters() {
            return (this.bitField0_ & 0x20) != 0;
        }

        @Override
        public Int32Value getRemainingDrivingDistanceMeters() {
            if (this.remainingDrivingDistanceMetersBuilder_ == null) {
                return this.remainingDrivingDistanceMeters_ == null ? Int32Value.getDefaultInstance() : this.remainingDrivingDistanceMeters_;
            }
            return (Int32Value)this.remainingDrivingDistanceMetersBuilder_.getMessage();
        }

        public Builder setRemainingDrivingDistanceMeters(Int32Value value) {
            if (this.remainingDrivingDistanceMetersBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.remainingDrivingDistanceMeters_ = value;
            } else {
                this.remainingDrivingDistanceMetersBuilder_.setMessage((AbstractMessage)value);
            }
            this.bitField0_ |= 0x20;
            this.onChanged();
            return this;
        }

        public Builder setRemainingDrivingDistanceMeters(Int32Value.Builder builderForValue) {
            if (this.remainingDrivingDistanceMetersBuilder_ == null) {
                this.remainingDrivingDistanceMeters_ = builderForValue.build();
            } else {
                this.remainingDrivingDistanceMetersBuilder_.setMessage((AbstractMessage)builderForValue.build());
            }
            this.bitField0_ |= 0x20;
            this.onChanged();
            return this;
        }

        public Builder mergeRemainingDrivingDistanceMeters(Int32Value value) {
            if (this.remainingDrivingDistanceMetersBuilder_ == null) {
                if ((this.bitField0_ & 0x20) != 0 && this.remainingDrivingDistanceMeters_ != null && this.remainingDrivingDistanceMeters_ != Int32Value.getDefaultInstance()) {
                    this.getRemainingDrivingDistanceMetersBuilder().mergeFrom(value);
                } else {
                    this.remainingDrivingDistanceMeters_ = value;
                }
            } else {
                this.remainingDrivingDistanceMetersBuilder_.mergeFrom((AbstractMessage)value);
            }
            if (this.remainingDrivingDistanceMeters_ != null) {
                this.bitField0_ |= 0x20;
                this.onChanged();
            }
            return this;
        }

        public Builder clearRemainingDrivingDistanceMeters() {
            this.bitField0_ &= 0xFFFFFFDF;
            this.remainingDrivingDistanceMeters_ = null;
            if (this.remainingDrivingDistanceMetersBuilder_ != null) {
                this.remainingDrivingDistanceMetersBuilder_.dispose();
                this.remainingDrivingDistanceMetersBuilder_ = null;
            }
            this.onChanged();
            return this;
        }

        public Int32Value.Builder getRemainingDrivingDistanceMetersBuilder() {
            this.bitField0_ |= 0x20;
            this.onChanged();
            return (Int32Value.Builder)this.getRemainingDrivingDistanceMetersFieldBuilder().getBuilder();
        }

        @Override
        public Int32ValueOrBuilder getRemainingDrivingDistanceMetersOrBuilder() {
            if (this.remainingDrivingDistanceMetersBuilder_ != null) {
                return (Int32ValueOrBuilder)this.remainingDrivingDistanceMetersBuilder_.getMessageOrBuilder();
            }
            return this.remainingDrivingDistanceMeters_ == null ? Int32Value.getDefaultInstance() : this.remainingDrivingDistanceMeters_;
        }

        private SingleFieldBuilderV3<Int32Value, Int32Value.Builder, Int32ValueOrBuilder> getRemainingDrivingDistanceMetersFieldBuilder() {
            if (this.remainingDrivingDistanceMetersBuilder_ == null) {
                this.remainingDrivingDistanceMetersBuilder_ = new SingleFieldBuilderV3((AbstractMessage)this.getRemainingDrivingDistanceMeters(), (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.remainingDrivingDistanceMeters_ = null;
            }
            return this.remainingDrivingDistanceMetersBuilder_;
        }

        @Override
        public boolean hasEstimatedArrivalTime() {
            return (this.bitField0_ & 0x40) != 0;
        }

        @Override
        public Timestamp getEstimatedArrivalTime() {
            if (this.estimatedArrivalTimeBuilder_ == null) {
                return this.estimatedArrivalTime_ == null ? Timestamp.getDefaultInstance() : this.estimatedArrivalTime_;
            }
            return (Timestamp)this.estimatedArrivalTimeBuilder_.getMessage();
        }

        public Builder setEstimatedArrivalTime(Timestamp value) {
            if (this.estimatedArrivalTimeBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.estimatedArrivalTime_ = value;
            } else {
                this.estimatedArrivalTimeBuilder_.setMessage((AbstractMessage)value);
            }
            this.bitField0_ |= 0x40;
            this.onChanged();
            return this;
        }

        public Builder setEstimatedArrivalTime(Timestamp.Builder builderForValue) {
            if (this.estimatedArrivalTimeBuilder_ == null) {
                this.estimatedArrivalTime_ = builderForValue.build();
            } else {
                this.estimatedArrivalTimeBuilder_.setMessage((AbstractMessage)builderForValue.build());
            }
            this.bitField0_ |= 0x40;
            this.onChanged();
            return this;
        }

        public Builder mergeEstimatedArrivalTime(Timestamp value) {
            if (this.estimatedArrivalTimeBuilder_ == null) {
                if ((this.bitField0_ & 0x40) != 0 && this.estimatedArrivalTime_ != null && this.estimatedArrivalTime_ != Timestamp.getDefaultInstance()) {
                    this.getEstimatedArrivalTimeBuilder().mergeFrom(value);
                } else {
                    this.estimatedArrivalTime_ = value;
                }
            } else {
                this.estimatedArrivalTimeBuilder_.mergeFrom((AbstractMessage)value);
            }
            if (this.estimatedArrivalTime_ != null) {
                this.bitField0_ |= 0x40;
                this.onChanged();
            }
            return this;
        }

        public Builder clearEstimatedArrivalTime() {
            this.bitField0_ &= 0xFFFFFFBF;
            this.estimatedArrivalTime_ = null;
            if (this.estimatedArrivalTimeBuilder_ != null) {
                this.estimatedArrivalTimeBuilder_.dispose();
                this.estimatedArrivalTimeBuilder_ = null;
            }
            this.onChanged();
            return this;
        }

        public Timestamp.Builder getEstimatedArrivalTimeBuilder() {
            this.bitField0_ |= 0x40;
            this.onChanged();
            return (Timestamp.Builder)this.getEstimatedArrivalTimeFieldBuilder().getBuilder();
        }

        @Override
        public TimestampOrBuilder getEstimatedArrivalTimeOrBuilder() {
            if (this.estimatedArrivalTimeBuilder_ != null) {
                return (TimestampOrBuilder)this.estimatedArrivalTimeBuilder_.getMessageOrBuilder();
            }
            return this.estimatedArrivalTime_ == null ? Timestamp.getDefaultInstance() : this.estimatedArrivalTime_;
        }

        private SingleFieldBuilderV3<Timestamp, Timestamp.Builder, TimestampOrBuilder> getEstimatedArrivalTimeFieldBuilder() {
            if (this.estimatedArrivalTimeBuilder_ == null) {
                this.estimatedArrivalTimeBuilder_ = new SingleFieldBuilderV3((AbstractMessage)this.getEstimatedArrivalTime(), (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.estimatedArrivalTime_ = null;
            }
            return this.estimatedArrivalTimeBuilder_;
        }

        @Override
        public boolean hasEstimatedTaskCompletionTime() {
            return (this.bitField0_ & 0x80) != 0;
        }

        @Override
        public Timestamp getEstimatedTaskCompletionTime() {
            if (this.estimatedTaskCompletionTimeBuilder_ == null) {
                return this.estimatedTaskCompletionTime_ == null ? Timestamp.getDefaultInstance() : this.estimatedTaskCompletionTime_;
            }
            return (Timestamp)this.estimatedTaskCompletionTimeBuilder_.getMessage();
        }

        public Builder setEstimatedTaskCompletionTime(Timestamp value) {
            if (this.estimatedTaskCompletionTimeBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.estimatedTaskCompletionTime_ = value;
            } else {
                this.estimatedTaskCompletionTimeBuilder_.setMessage((AbstractMessage)value);
            }
            this.bitField0_ |= 0x80;
            this.onChanged();
            return this;
        }

        public Builder setEstimatedTaskCompletionTime(Timestamp.Builder builderForValue) {
            if (this.estimatedTaskCompletionTimeBuilder_ == null) {
                this.estimatedTaskCompletionTime_ = builderForValue.build();
            } else {
                this.estimatedTaskCompletionTimeBuilder_.setMessage((AbstractMessage)builderForValue.build());
            }
            this.bitField0_ |= 0x80;
            this.onChanged();
            return this;
        }

        public Builder mergeEstimatedTaskCompletionTime(Timestamp value) {
            if (this.estimatedTaskCompletionTimeBuilder_ == null) {
                if ((this.bitField0_ & 0x80) != 0 && this.estimatedTaskCompletionTime_ != null && this.estimatedTaskCompletionTime_ != Timestamp.getDefaultInstance()) {
                    this.getEstimatedTaskCompletionTimeBuilder().mergeFrom(value);
                } else {
                    this.estimatedTaskCompletionTime_ = value;
                }
            } else {
                this.estimatedTaskCompletionTimeBuilder_.mergeFrom((AbstractMessage)value);
            }
            if (this.estimatedTaskCompletionTime_ != null) {
                this.bitField0_ |= 0x80;
                this.onChanged();
            }
            return this;
        }

        public Builder clearEstimatedTaskCompletionTime() {
            this.bitField0_ &= 0xFFFFFF7F;
            this.estimatedTaskCompletionTime_ = null;
            if (this.estimatedTaskCompletionTimeBuilder_ != null) {
                this.estimatedTaskCompletionTimeBuilder_.dispose();
                this.estimatedTaskCompletionTimeBuilder_ = null;
            }
            this.onChanged();
            return this;
        }

        public Timestamp.Builder getEstimatedTaskCompletionTimeBuilder() {
            this.bitField0_ |= 0x80;
            this.onChanged();
            return (Timestamp.Builder)this.getEstimatedTaskCompletionTimeFieldBuilder().getBuilder();
        }

        @Override
        public TimestampOrBuilder getEstimatedTaskCompletionTimeOrBuilder() {
            if (this.estimatedTaskCompletionTimeBuilder_ != null) {
                return (TimestampOrBuilder)this.estimatedTaskCompletionTimeBuilder_.getMessageOrBuilder();
            }
            return this.estimatedTaskCompletionTime_ == null ? Timestamp.getDefaultInstance() : this.estimatedTaskCompletionTime_;
        }

        private SingleFieldBuilderV3<Timestamp, Timestamp.Builder, TimestampOrBuilder> getEstimatedTaskCompletionTimeFieldBuilder() {
            if (this.estimatedTaskCompletionTimeBuilder_ == null) {
                this.estimatedTaskCompletionTimeBuilder_ = new SingleFieldBuilderV3((AbstractMessage)this.getEstimatedTaskCompletionTime(), (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.estimatedTaskCompletionTime_ = null;
            }
            return this.estimatedTaskCompletionTimeBuilder_;
        }

        @Override
        public int getStateValue() {
            return this.state_;
        }

        public Builder setStateValue(int value) {
            this.state_ = value;
            this.bitField0_ |= 0x100;
            this.onChanged();
            return this;
        }

        @Override
        public Task.State getState() {
            Task.State result = Task.State.forNumber(this.state_);
            return result == null ? Task.State.UNRECOGNIZED : result;
        }

        public Builder setState(Task.State value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.bitField0_ |= 0x100;
            this.state_ = value.getNumber();
            this.onChanged();
            return this;
        }

        public Builder clearState() {
            this.bitField0_ &= 0xFFFFFEFF;
            this.state_ = 0;
            this.onChanged();
            return this;
        }

        @Override
        public int getTaskOutcomeValue() {
            return this.taskOutcome_;
        }

        public Builder setTaskOutcomeValue(int value) {
            this.taskOutcome_ = value;
            this.bitField0_ |= 0x200;
            this.onChanged();
            return this;
        }

        @Override
        public Task.TaskOutcome getTaskOutcome() {
            Task.TaskOutcome result = Task.TaskOutcome.forNumber(this.taskOutcome_);
            return result == null ? Task.TaskOutcome.UNRECOGNIZED : result;
        }

        public Builder setTaskOutcome(Task.TaskOutcome value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.bitField0_ |= 0x200;
            this.taskOutcome_ = value.getNumber();
            this.onChanged();
            return this;
        }

        public Builder clearTaskOutcome() {
            this.bitField0_ &= 0xFFFFFDFF;
            this.taskOutcome_ = 0;
            this.onChanged();
            return this;
        }

        @Override
        public boolean hasTaskOutcomeTime() {
            return (this.bitField0_ & 0x400) != 0;
        }

        @Override
        public Timestamp getTaskOutcomeTime() {
            if (this.taskOutcomeTimeBuilder_ == null) {
                return this.taskOutcomeTime_ == null ? Timestamp.getDefaultInstance() : this.taskOutcomeTime_;
            }
            return (Timestamp)this.taskOutcomeTimeBuilder_.getMessage();
        }

        public Builder setTaskOutcomeTime(Timestamp value) {
            if (this.taskOutcomeTimeBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.taskOutcomeTime_ = value;
            } else {
                this.taskOutcomeTimeBuilder_.setMessage((AbstractMessage)value);
            }
            this.bitField0_ |= 0x400;
            this.onChanged();
            return this;
        }

        public Builder setTaskOutcomeTime(Timestamp.Builder builderForValue) {
            if (this.taskOutcomeTimeBuilder_ == null) {
                this.taskOutcomeTime_ = builderForValue.build();
            } else {
                this.taskOutcomeTimeBuilder_.setMessage((AbstractMessage)builderForValue.build());
            }
            this.bitField0_ |= 0x400;
            this.onChanged();
            return this;
        }

        public Builder mergeTaskOutcomeTime(Timestamp value) {
            if (this.taskOutcomeTimeBuilder_ == null) {
                if ((this.bitField0_ & 0x400) != 0 && this.taskOutcomeTime_ != null && this.taskOutcomeTime_ != Timestamp.getDefaultInstance()) {
                    this.getTaskOutcomeTimeBuilder().mergeFrom(value);
                } else {
                    this.taskOutcomeTime_ = value;
                }
            } else {
                this.taskOutcomeTimeBuilder_.mergeFrom((AbstractMessage)value);
            }
            if (this.taskOutcomeTime_ != null) {
                this.bitField0_ |= 0x400;
                this.onChanged();
            }
            return this;
        }

        public Builder clearTaskOutcomeTime() {
            this.bitField0_ &= 0xFFFFFBFF;
            this.taskOutcomeTime_ = null;
            if (this.taskOutcomeTimeBuilder_ != null) {
                this.taskOutcomeTimeBuilder_.dispose();
                this.taskOutcomeTimeBuilder_ = null;
            }
            this.onChanged();
            return this;
        }

        public Timestamp.Builder getTaskOutcomeTimeBuilder() {
            this.bitField0_ |= 0x400;
            this.onChanged();
            return (Timestamp.Builder)this.getTaskOutcomeTimeFieldBuilder().getBuilder();
        }

        @Override
        public TimestampOrBuilder getTaskOutcomeTimeOrBuilder() {
            if (this.taskOutcomeTimeBuilder_ != null) {
                return (TimestampOrBuilder)this.taskOutcomeTimeBuilder_.getMessageOrBuilder();
            }
            return this.taskOutcomeTime_ == null ? Timestamp.getDefaultInstance() : this.taskOutcomeTime_;
        }

        private SingleFieldBuilderV3<Timestamp, Timestamp.Builder, TimestampOrBuilder> getTaskOutcomeTimeFieldBuilder() {
            if (this.taskOutcomeTimeBuilder_ == null) {
                this.taskOutcomeTimeBuilder_ = new SingleFieldBuilderV3((AbstractMessage)this.getTaskOutcomeTime(), (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.taskOutcomeTime_ = null;
            }
            return this.taskOutcomeTimeBuilder_;
        }

        @Override
        public boolean hasPlannedLocation() {
            return (this.bitField0_ & 0x800) != 0;
        }

        @Override
        public LocationInfo getPlannedLocation() {
            if (this.plannedLocationBuilder_ == null) {
                return this.plannedLocation_ == null ? LocationInfo.getDefaultInstance() : this.plannedLocation_;
            }
            return (LocationInfo)this.plannedLocationBuilder_.getMessage();
        }

        public Builder setPlannedLocation(LocationInfo value) {
            if (this.plannedLocationBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.plannedLocation_ = value;
            } else {
                this.plannedLocationBuilder_.setMessage((AbstractMessage)value);
            }
            this.bitField0_ |= 0x800;
            this.onChanged();
            return this;
        }

        public Builder setPlannedLocation(LocationInfo.Builder builderForValue) {
            if (this.plannedLocationBuilder_ == null) {
                this.plannedLocation_ = builderForValue.build();
            } else {
                this.plannedLocationBuilder_.setMessage((AbstractMessage)builderForValue.build());
            }
            this.bitField0_ |= 0x800;
            this.onChanged();
            return this;
        }

        public Builder mergePlannedLocation(LocationInfo value) {
            if (this.plannedLocationBuilder_ == null) {
                if ((this.bitField0_ & 0x800) != 0 && this.plannedLocation_ != null && this.plannedLocation_ != LocationInfo.getDefaultInstance()) {
                    this.getPlannedLocationBuilder().mergeFrom(value);
                } else {
                    this.plannedLocation_ = value;
                }
            } else {
                this.plannedLocationBuilder_.mergeFrom((AbstractMessage)value);
            }
            if (this.plannedLocation_ != null) {
                this.bitField0_ |= 0x800;
                this.onChanged();
            }
            return this;
        }

        public Builder clearPlannedLocation() {
            this.bitField0_ &= 0xFFFFF7FF;
            this.plannedLocation_ = null;
            if (this.plannedLocationBuilder_ != null) {
                this.plannedLocationBuilder_.dispose();
                this.plannedLocationBuilder_ = null;
            }
            this.onChanged();
            return this;
        }

        public LocationInfo.Builder getPlannedLocationBuilder() {
            this.bitField0_ |= 0x800;
            this.onChanged();
            return (LocationInfo.Builder)this.getPlannedLocationFieldBuilder().getBuilder();
        }

        @Override
        public LocationInfoOrBuilder getPlannedLocationOrBuilder() {
            if (this.plannedLocationBuilder_ != null) {
                return (LocationInfoOrBuilder)this.plannedLocationBuilder_.getMessageOrBuilder();
            }
            return this.plannedLocation_ == null ? LocationInfo.getDefaultInstance() : this.plannedLocation_;
        }

        private SingleFieldBuilderV3<LocationInfo, LocationInfo.Builder, LocationInfoOrBuilder> getPlannedLocationFieldBuilder() {
            if (this.plannedLocationBuilder_ == null) {
                this.plannedLocationBuilder_ = new SingleFieldBuilderV3((AbstractMessage)this.getPlannedLocation(), (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.plannedLocation_ = null;
            }
            return this.plannedLocationBuilder_;
        }

        @Override
        public boolean hasTargetTimeWindow() {
            return (this.bitField0_ & 0x1000) != 0;
        }

        @Override
        public TimeWindow getTargetTimeWindow() {
            if (this.targetTimeWindowBuilder_ == null) {
                return this.targetTimeWindow_ == null ? TimeWindow.getDefaultInstance() : this.targetTimeWindow_;
            }
            return (TimeWindow)this.targetTimeWindowBuilder_.getMessage();
        }

        public Builder setTargetTimeWindow(TimeWindow value) {
            if (this.targetTimeWindowBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.targetTimeWindow_ = value;
            } else {
                this.targetTimeWindowBuilder_.setMessage((AbstractMessage)value);
            }
            this.bitField0_ |= 0x1000;
            this.onChanged();
            return this;
        }

        public Builder setTargetTimeWindow(TimeWindow.Builder builderForValue) {
            if (this.targetTimeWindowBuilder_ == null) {
                this.targetTimeWindow_ = builderForValue.build();
            } else {
                this.targetTimeWindowBuilder_.setMessage((AbstractMessage)builderForValue.build());
            }
            this.bitField0_ |= 0x1000;
            this.onChanged();
            return this;
        }

        public Builder mergeTargetTimeWindow(TimeWindow value) {
            if (this.targetTimeWindowBuilder_ == null) {
                if ((this.bitField0_ & 0x1000) != 0 && this.targetTimeWindow_ != null && this.targetTimeWindow_ != TimeWindow.getDefaultInstance()) {
                    this.getTargetTimeWindowBuilder().mergeFrom(value);
                } else {
                    this.targetTimeWindow_ = value;
                }
            } else {
                this.targetTimeWindowBuilder_.mergeFrom((AbstractMessage)value);
            }
            if (this.targetTimeWindow_ != null) {
                this.bitField0_ |= 0x1000;
                this.onChanged();
            }
            return this;
        }

        public Builder clearTargetTimeWindow() {
            this.bitField0_ &= 0xFFFFEFFF;
            this.targetTimeWindow_ = null;
            if (this.targetTimeWindowBuilder_ != null) {
                this.targetTimeWindowBuilder_.dispose();
                this.targetTimeWindowBuilder_ = null;
            }
            this.onChanged();
            return this;
        }

        public TimeWindow.Builder getTargetTimeWindowBuilder() {
            this.bitField0_ |= 0x1000;
            this.onChanged();
            return (TimeWindow.Builder)this.getTargetTimeWindowFieldBuilder().getBuilder();
        }

        @Override
        public TimeWindowOrBuilder getTargetTimeWindowOrBuilder() {
            if (this.targetTimeWindowBuilder_ != null) {
                return (TimeWindowOrBuilder)this.targetTimeWindowBuilder_.getMessageOrBuilder();
            }
            return this.targetTimeWindow_ == null ? TimeWindow.getDefaultInstance() : this.targetTimeWindow_;
        }

        private SingleFieldBuilderV3<TimeWindow, TimeWindow.Builder, TimeWindowOrBuilder> getTargetTimeWindowFieldBuilder() {
            if (this.targetTimeWindowBuilder_ == null) {
                this.targetTimeWindowBuilder_ = new SingleFieldBuilderV3((AbstractMessage)this.getTargetTimeWindow(), (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.targetTimeWindow_ = null;
            }
            return this.targetTimeWindowBuilder_;
        }

        private void ensureAttributesIsMutable() {
            if ((this.bitField0_ & 0x2000) == 0) {
                this.attributes_ = new ArrayList<TaskAttribute>(this.attributes_);
                this.bitField0_ |= 0x2000;
            }
        }

        @Override
        public List<TaskAttribute> getAttributesList() {
            if (this.attributesBuilder_ == null) {
                return Collections.unmodifiableList(this.attributes_);
            }
            return this.attributesBuilder_.getMessageList();
        }

        @Override
        public int getAttributesCount() {
            if (this.attributesBuilder_ == null) {
                return this.attributes_.size();
            }
            return this.attributesBuilder_.getCount();
        }

        @Override
        public TaskAttribute getAttributes(int index) {
            if (this.attributesBuilder_ == null) {
                return this.attributes_.get(index);
            }
            return (TaskAttribute)this.attributesBuilder_.getMessage(index);
        }

        public Builder setAttributes(int index, TaskAttribute value) {
            if (this.attributesBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureAttributesIsMutable();
                this.attributes_.set(index, value);
                this.onChanged();
            } else {
                this.attributesBuilder_.setMessage(index, (AbstractMessage)value);
            }
            return this;
        }

        public Builder setAttributes(int index, TaskAttribute.Builder builderForValue) {
            if (this.attributesBuilder_ == null) {
                this.ensureAttributesIsMutable();
                this.attributes_.set(index, builderForValue.build());
                this.onChanged();
            } else {
                this.attributesBuilder_.setMessage(index, (AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addAttributes(TaskAttribute value) {
            if (this.attributesBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureAttributesIsMutable();
                this.attributes_.add(value);
                this.onChanged();
            } else {
                this.attributesBuilder_.addMessage((AbstractMessage)value);
            }
            return this;
        }

        public Builder addAttributes(int index, TaskAttribute value) {
            if (this.attributesBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureAttributesIsMutable();
                this.attributes_.add(index, value);
                this.onChanged();
            } else {
                this.attributesBuilder_.addMessage(index, (AbstractMessage)value);
            }
            return this;
        }

        public Builder addAttributes(TaskAttribute.Builder builderForValue) {
            if (this.attributesBuilder_ == null) {
                this.ensureAttributesIsMutable();
                this.attributes_.add(builderForValue.build());
                this.onChanged();
            } else {
                this.attributesBuilder_.addMessage((AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addAttributes(int index, TaskAttribute.Builder builderForValue) {
            if (this.attributesBuilder_ == null) {
                this.ensureAttributesIsMutable();
                this.attributes_.add(index, builderForValue.build());
                this.onChanged();
            } else {
                this.attributesBuilder_.addMessage(index, (AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addAllAttributes(Iterable<? extends TaskAttribute> values) {
            if (this.attributesBuilder_ == null) {
                this.ensureAttributesIsMutable();
                AbstractMessageLite.Builder.addAll(values, this.attributes_);
                this.onChanged();
            } else {
                this.attributesBuilder_.addAllMessages(values);
            }
            return this;
        }

        public Builder clearAttributes() {
            if (this.attributesBuilder_ == null) {
                this.attributes_ = Collections.emptyList();
                this.bitField0_ &= 0xFFFFDFFF;
                this.onChanged();
            } else {
                this.attributesBuilder_.clear();
            }
            return this;
        }

        public Builder removeAttributes(int index) {
            if (this.attributesBuilder_ == null) {
                this.ensureAttributesIsMutable();
                this.attributes_.remove(index);
                this.onChanged();
            } else {
                this.attributesBuilder_.remove(index);
            }
            return this;
        }

        public TaskAttribute.Builder getAttributesBuilder(int index) {
            return (TaskAttribute.Builder)this.getAttributesFieldBuilder().getBuilder(index);
        }

        @Override
        public TaskAttributeOrBuilder getAttributesOrBuilder(int index) {
            if (this.attributesBuilder_ == null) {
                return this.attributes_.get(index);
            }
            return (TaskAttributeOrBuilder)this.attributesBuilder_.getMessageOrBuilder(index);
        }

        @Override
        public List<? extends TaskAttributeOrBuilder> getAttributesOrBuilderList() {
            if (this.attributesBuilder_ != null) {
                return this.attributesBuilder_.getMessageOrBuilderList();
            }
            return Collections.unmodifiableList(this.attributes_);
        }

        public TaskAttribute.Builder addAttributesBuilder() {
            return (TaskAttribute.Builder)this.getAttributesFieldBuilder().addBuilder((AbstractMessage)TaskAttribute.getDefaultInstance());
        }

        public TaskAttribute.Builder addAttributesBuilder(int index) {
            return (TaskAttribute.Builder)this.getAttributesFieldBuilder().addBuilder(index, (AbstractMessage)TaskAttribute.getDefaultInstance());
        }

        public List<TaskAttribute.Builder> getAttributesBuilderList() {
            return this.getAttributesFieldBuilder().getBuilderList();
        }

        private RepeatedFieldBuilderV3<TaskAttribute, TaskAttribute.Builder, TaskAttributeOrBuilder> getAttributesFieldBuilder() {
            if (this.attributesBuilder_ == null) {
                this.attributesBuilder_ = new RepeatedFieldBuilderV3(this.attributes_, (this.bitField0_ & 0x2000) != 0, (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.attributes_ = null;
            }
            return this.attributesBuilder_;
        }

        public final Builder setUnknownFields(UnknownFieldSet unknownFields) {
            return (Builder)super.setUnknownFields(unknownFields);
        }

        public final Builder mergeUnknownFields(UnknownFieldSet unknownFields) {
            return (Builder)super.mergeUnknownFields(unknownFields);
        }
    }
}

