/*
 * Decompiled with CFR 0.152.
 */
package com.google.maps.fleetengine.delivery.v1;

import com.google.maps.fleetengine.delivery.v1.DeliveryVehicleAttribute;
import com.google.maps.fleetengine.delivery.v1.DeliveryVehicleAttributeOrBuilder;
import com.google.maps.fleetengine.delivery.v1.DeliveryVehicleLocation;
import com.google.maps.fleetengine.delivery.v1.DeliveryVehicleLocationOrBuilder;
import com.google.maps.fleetengine.delivery.v1.DeliveryVehicleNavigationStatus;
import com.google.maps.fleetengine.delivery.v1.DeliveryVehicleOrBuilder;
import com.google.maps.fleetengine.delivery.v1.DeliveryVehicles;
import com.google.maps.fleetengine.delivery.v1.VehicleJourneySegment;
import com.google.maps.fleetengine.delivery.v1.VehicleJourneySegmentOrBuilder;
import com.google.protobuf.AbstractMessage;
import com.google.protobuf.AbstractMessageLite;
import com.google.protobuf.AbstractParser;
import com.google.protobuf.ByteString;
import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import com.google.protobuf.Descriptors;
import com.google.protobuf.Duration;
import com.google.protobuf.DurationOrBuilder;
import com.google.protobuf.ExtensionRegistryLite;
import com.google.protobuf.GeneratedMessageV3;
import com.google.protobuf.Int32Value;
import com.google.protobuf.Int32ValueOrBuilder;
import com.google.protobuf.Internal;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import com.google.protobuf.MessageLite;
import com.google.protobuf.Parser;
import com.google.protobuf.ProtocolMessageEnum;
import com.google.protobuf.RepeatedFieldBuilderV3;
import com.google.protobuf.SingleFieldBuilderV3;
import com.google.protobuf.UninitializedMessageException;
import com.google.protobuf.UnknownFieldSet;
import com.google.type.LatLng;
import com.google.type.LatLngOrBuilder;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class DeliveryVehicle
extends GeneratedMessageV3
implements DeliveryVehicleOrBuilder {
    private static final long serialVersionUID = 0L;
    private int bitField0_;
    public static final int NAME_FIELD_NUMBER = 1;
    private volatile Object name_ = "";
    public static final int LAST_LOCATION_FIELD_NUMBER = 2;
    private DeliveryVehicleLocation lastLocation_;
    public static final int PAST_LOCATIONS_FIELD_NUMBER = 12;
    private List<DeliveryVehicleLocation> pastLocations_;
    public static final int NAVIGATION_STATUS_FIELD_NUMBER = 3;
    private int navigationStatus_ = 0;
    public static final int CURRENT_ROUTE_SEGMENT_FIELD_NUMBER = 4;
    private ByteString currentRouteSegment_ = ByteString.EMPTY;
    public static final int CURRENT_ROUTE_SEGMENT_END_POINT_FIELD_NUMBER = 5;
    private LatLng currentRouteSegmentEndPoint_;
    public static final int REMAINING_DISTANCE_METERS_FIELD_NUMBER = 6;
    private Int32Value remainingDistanceMeters_;
    public static final int REMAINING_DURATION_FIELD_NUMBER = 7;
    private Duration remainingDuration_;
    public static final int REMAINING_VEHICLE_JOURNEY_SEGMENTS_FIELD_NUMBER = 8;
    private List<VehicleJourneySegment> remainingVehicleJourneySegments_;
    public static final int ATTRIBUTES_FIELD_NUMBER = 9;
    private List<DeliveryVehicleAttribute> attributes_;
    public static final int TYPE_FIELD_NUMBER = 10;
    private int type_ = 0;
    private byte memoizedIsInitialized = (byte)-1;
    private static final DeliveryVehicle DEFAULT_INSTANCE = new DeliveryVehicle();
    private static final Parser<DeliveryVehicle> PARSER = new AbstractParser<DeliveryVehicle>(){

        public DeliveryVehicle parsePartialFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            Builder builder = DeliveryVehicle.newBuilder();
            try {
                builder.mergeFrom(input, extensionRegistry);
            }
            catch (InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage((MessageLite)builder.buildPartial());
            }
            catch (UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException().setUnfinishedMessage((MessageLite)builder.buildPartial());
            }
            catch (IOException e) {
                throw new InvalidProtocolBufferException(e).setUnfinishedMessage((MessageLite)builder.buildPartial());
            }
            return builder.buildPartial();
        }
    };

    private DeliveryVehicle(GeneratedMessageV3.Builder<?> builder) {
        super(builder);
    }

    private DeliveryVehicle() {
        this.name_ = "";
        this.pastLocations_ = Collections.emptyList();
        this.navigationStatus_ = 0;
        this.currentRouteSegment_ = ByteString.EMPTY;
        this.remainingVehicleJourneySegments_ = Collections.emptyList();
        this.attributes_ = Collections.emptyList();
        this.type_ = 0;
    }

    protected Object newInstance(GeneratedMessageV3.UnusedPrivateParameter unused) {
        return new DeliveryVehicle();
    }

    public static final Descriptors.Descriptor getDescriptor() {
        return DeliveryVehicles.internal_static_maps_fleetengine_delivery_v1_DeliveryVehicle_descriptor;
    }

    protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
        return DeliveryVehicles.internal_static_maps_fleetengine_delivery_v1_DeliveryVehicle_fieldAccessorTable.ensureFieldAccessorsInitialized(DeliveryVehicle.class, Builder.class);
    }

    @Override
    public String getName() {
        Object ref = this.name_;
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s = bs.toStringUtf8();
        this.name_ = s;
        return s;
    }

    @Override
    public ByteString getNameBytes() {
        Object ref = this.name_;
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)((String)ref));
            this.name_ = b;
            return b;
        }
        return (ByteString)ref;
    }

    @Override
    public boolean hasLastLocation() {
        return (this.bitField0_ & 1) != 0;
    }

    @Override
    public DeliveryVehicleLocation getLastLocation() {
        return this.lastLocation_ == null ? DeliveryVehicleLocation.getDefaultInstance() : this.lastLocation_;
    }

    @Override
    public DeliveryVehicleLocationOrBuilder getLastLocationOrBuilder() {
        return this.lastLocation_ == null ? DeliveryVehicleLocation.getDefaultInstance() : this.lastLocation_;
    }

    @Override
    public List<DeliveryVehicleLocation> getPastLocationsList() {
        return this.pastLocations_;
    }

    @Override
    public List<? extends DeliveryVehicleLocationOrBuilder> getPastLocationsOrBuilderList() {
        return this.pastLocations_;
    }

    @Override
    public int getPastLocationsCount() {
        return this.pastLocations_.size();
    }

    @Override
    public DeliveryVehicleLocation getPastLocations(int index) {
        return this.pastLocations_.get(index);
    }

    @Override
    public DeliveryVehicleLocationOrBuilder getPastLocationsOrBuilder(int index) {
        return this.pastLocations_.get(index);
    }

    @Override
    public int getNavigationStatusValue() {
        return this.navigationStatus_;
    }

    @Override
    public DeliveryVehicleNavigationStatus getNavigationStatus() {
        DeliveryVehicleNavigationStatus result = DeliveryVehicleNavigationStatus.forNumber(this.navigationStatus_);
        return result == null ? DeliveryVehicleNavigationStatus.UNRECOGNIZED : result;
    }

    @Override
    public ByteString getCurrentRouteSegment() {
        return this.currentRouteSegment_;
    }

    @Override
    public boolean hasCurrentRouteSegmentEndPoint() {
        return (this.bitField0_ & 2) != 0;
    }

    @Override
    public LatLng getCurrentRouteSegmentEndPoint() {
        return this.currentRouteSegmentEndPoint_ == null ? LatLng.getDefaultInstance() : this.currentRouteSegmentEndPoint_;
    }

    @Override
    public LatLngOrBuilder getCurrentRouteSegmentEndPointOrBuilder() {
        return this.currentRouteSegmentEndPoint_ == null ? LatLng.getDefaultInstance() : this.currentRouteSegmentEndPoint_;
    }

    @Override
    public boolean hasRemainingDistanceMeters() {
        return (this.bitField0_ & 4) != 0;
    }

    @Override
    public Int32Value getRemainingDistanceMeters() {
        return this.remainingDistanceMeters_ == null ? Int32Value.getDefaultInstance() : this.remainingDistanceMeters_;
    }

    @Override
    public Int32ValueOrBuilder getRemainingDistanceMetersOrBuilder() {
        return this.remainingDistanceMeters_ == null ? Int32Value.getDefaultInstance() : this.remainingDistanceMeters_;
    }

    @Override
    public boolean hasRemainingDuration() {
        return (this.bitField0_ & 8) != 0;
    }

    @Override
    public Duration getRemainingDuration() {
        return this.remainingDuration_ == null ? Duration.getDefaultInstance() : this.remainingDuration_;
    }

    @Override
    public DurationOrBuilder getRemainingDurationOrBuilder() {
        return this.remainingDuration_ == null ? Duration.getDefaultInstance() : this.remainingDuration_;
    }

    @Override
    public List<VehicleJourneySegment> getRemainingVehicleJourneySegmentsList() {
        return this.remainingVehicleJourneySegments_;
    }

    @Override
    public List<? extends VehicleJourneySegmentOrBuilder> getRemainingVehicleJourneySegmentsOrBuilderList() {
        return this.remainingVehicleJourneySegments_;
    }

    @Override
    public int getRemainingVehicleJourneySegmentsCount() {
        return this.remainingVehicleJourneySegments_.size();
    }

    @Override
    public VehicleJourneySegment getRemainingVehicleJourneySegments(int index) {
        return this.remainingVehicleJourneySegments_.get(index);
    }

    @Override
    public VehicleJourneySegmentOrBuilder getRemainingVehicleJourneySegmentsOrBuilder(int index) {
        return this.remainingVehicleJourneySegments_.get(index);
    }

    @Override
    public List<DeliveryVehicleAttribute> getAttributesList() {
        return this.attributes_;
    }

    @Override
    public List<? extends DeliveryVehicleAttributeOrBuilder> getAttributesOrBuilderList() {
        return this.attributes_;
    }

    @Override
    public int getAttributesCount() {
        return this.attributes_.size();
    }

    @Override
    public DeliveryVehicleAttribute getAttributes(int index) {
        return this.attributes_.get(index);
    }

    @Override
    public DeliveryVehicleAttributeOrBuilder getAttributesOrBuilder(int index) {
        return this.attributes_.get(index);
    }

    @Override
    public int getTypeValue() {
        return this.type_;
    }

    @Override
    public DeliveryVehicleType getType() {
        DeliveryVehicleType result = DeliveryVehicleType.forNumber(this.type_);
        return result == null ? DeliveryVehicleType.UNRECOGNIZED : result;
    }

    public final boolean isInitialized() {
        byte isInitialized = this.memoizedIsInitialized;
        if (isInitialized == 1) {
            return true;
        }
        if (isInitialized == 0) {
            return false;
        }
        this.memoizedIsInitialized = 1;
        return true;
    }

    public void writeTo(CodedOutputStream output) throws IOException {
        int i;
        if (!GeneratedMessageV3.isStringEmpty((Object)this.name_)) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)1, (Object)this.name_);
        }
        if ((this.bitField0_ & 1) != 0) {
            output.writeMessage(2, (MessageLite)this.getLastLocation());
        }
        if (this.navigationStatus_ != DeliveryVehicleNavigationStatus.UNKNOWN_NAVIGATION_STATUS.getNumber()) {
            output.writeEnum(3, this.navigationStatus_);
        }
        if (!this.currentRouteSegment_.isEmpty()) {
            output.writeBytes(4, this.currentRouteSegment_);
        }
        if ((this.bitField0_ & 2) != 0) {
            output.writeMessage(5, (MessageLite)this.getCurrentRouteSegmentEndPoint());
        }
        if ((this.bitField0_ & 4) != 0) {
            output.writeMessage(6, (MessageLite)this.getRemainingDistanceMeters());
        }
        if ((this.bitField0_ & 8) != 0) {
            output.writeMessage(7, (MessageLite)this.getRemainingDuration());
        }
        for (i = 0; i < this.remainingVehicleJourneySegments_.size(); ++i) {
            output.writeMessage(8, (MessageLite)this.remainingVehicleJourneySegments_.get(i));
        }
        for (i = 0; i < this.attributes_.size(); ++i) {
            output.writeMessage(9, (MessageLite)this.attributes_.get(i));
        }
        if (this.type_ != DeliveryVehicleType.DELIVERY_VEHICLE_TYPE_UNSPECIFIED.getNumber()) {
            output.writeEnum(10, this.type_);
        }
        for (i = 0; i < this.pastLocations_.size(); ++i) {
            output.writeMessage(12, (MessageLite)this.pastLocations_.get(i));
        }
        this.getUnknownFields().writeTo(output);
    }

    public int getSerializedSize() {
        int i;
        int size = this.memoizedSize;
        if (size != -1) {
            return size;
        }
        size = 0;
        if (!GeneratedMessageV3.isStringEmpty((Object)this.name_)) {
            size += GeneratedMessageV3.computeStringSize((int)1, (Object)this.name_);
        }
        if ((this.bitField0_ & 1) != 0) {
            size += CodedOutputStream.computeMessageSize((int)2, (MessageLite)this.getLastLocation());
        }
        if (this.navigationStatus_ != DeliveryVehicleNavigationStatus.UNKNOWN_NAVIGATION_STATUS.getNumber()) {
            size += CodedOutputStream.computeEnumSize((int)3, (int)this.navigationStatus_);
        }
        if (!this.currentRouteSegment_.isEmpty()) {
            size += CodedOutputStream.computeBytesSize((int)4, (ByteString)this.currentRouteSegment_);
        }
        if ((this.bitField0_ & 2) != 0) {
            size += CodedOutputStream.computeMessageSize((int)5, (MessageLite)this.getCurrentRouteSegmentEndPoint());
        }
        if ((this.bitField0_ & 4) != 0) {
            size += CodedOutputStream.computeMessageSize((int)6, (MessageLite)this.getRemainingDistanceMeters());
        }
        if ((this.bitField0_ & 8) != 0) {
            size += CodedOutputStream.computeMessageSize((int)7, (MessageLite)this.getRemainingDuration());
        }
        for (i = 0; i < this.remainingVehicleJourneySegments_.size(); ++i) {
            size += CodedOutputStream.computeMessageSize((int)8, (MessageLite)((MessageLite)this.remainingVehicleJourneySegments_.get(i)));
        }
        for (i = 0; i < this.attributes_.size(); ++i) {
            size += CodedOutputStream.computeMessageSize((int)9, (MessageLite)((MessageLite)this.attributes_.get(i)));
        }
        if (this.type_ != DeliveryVehicleType.DELIVERY_VEHICLE_TYPE_UNSPECIFIED.getNumber()) {
            size += CodedOutputStream.computeEnumSize((int)10, (int)this.type_);
        }
        for (i = 0; i < this.pastLocations_.size(); ++i) {
            size += CodedOutputStream.computeMessageSize((int)12, (MessageLite)((MessageLite)this.pastLocations_.get(i)));
        }
        this.memoizedSize = size += this.getUnknownFields().getSerializedSize();
        return size;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof DeliveryVehicle)) {
            return super.equals(obj);
        }
        DeliveryVehicle other = (DeliveryVehicle)obj;
        if (!this.getName().equals(other.getName())) {
            return false;
        }
        if (this.hasLastLocation() != other.hasLastLocation()) {
            return false;
        }
        if (this.hasLastLocation() && !this.getLastLocation().equals(other.getLastLocation())) {
            return false;
        }
        if (!this.getPastLocationsList().equals(other.getPastLocationsList())) {
            return false;
        }
        if (this.navigationStatus_ != other.navigationStatus_) {
            return false;
        }
        if (!this.getCurrentRouteSegment().equals((Object)other.getCurrentRouteSegment())) {
            return false;
        }
        if (this.hasCurrentRouteSegmentEndPoint() != other.hasCurrentRouteSegmentEndPoint()) {
            return false;
        }
        if (this.hasCurrentRouteSegmentEndPoint() && !this.getCurrentRouteSegmentEndPoint().equals((Object)other.getCurrentRouteSegmentEndPoint())) {
            return false;
        }
        if (this.hasRemainingDistanceMeters() != other.hasRemainingDistanceMeters()) {
            return false;
        }
        if (this.hasRemainingDistanceMeters() && !this.getRemainingDistanceMeters().equals((Object)other.getRemainingDistanceMeters())) {
            return false;
        }
        if (this.hasRemainingDuration() != other.hasRemainingDuration()) {
            return false;
        }
        if (this.hasRemainingDuration() && !this.getRemainingDuration().equals((Object)other.getRemainingDuration())) {
            return false;
        }
        if (!this.getRemainingVehicleJourneySegmentsList().equals(other.getRemainingVehicleJourneySegmentsList())) {
            return false;
        }
        if (!this.getAttributesList().equals(other.getAttributesList())) {
            return false;
        }
        if (this.type_ != other.type_) {
            return false;
        }
        return this.getUnknownFields().equals((Object)other.getUnknownFields());
    }

    public int hashCode() {
        if (this.memoizedHashCode != 0) {
            return this.memoizedHashCode;
        }
        int hash = 41;
        hash = 19 * hash + DeliveryVehicle.getDescriptor().hashCode();
        hash = 37 * hash + 1;
        hash = 53 * hash + this.getName().hashCode();
        if (this.hasLastLocation()) {
            hash = 37 * hash + 2;
            hash = 53 * hash + this.getLastLocation().hashCode();
        }
        if (this.getPastLocationsCount() > 0) {
            hash = 37 * hash + 12;
            hash = 53 * hash + this.getPastLocationsList().hashCode();
        }
        hash = 37 * hash + 3;
        hash = 53 * hash + this.navigationStatus_;
        hash = 37 * hash + 4;
        hash = 53 * hash + this.getCurrentRouteSegment().hashCode();
        if (this.hasCurrentRouteSegmentEndPoint()) {
            hash = 37 * hash + 5;
            hash = 53 * hash + this.getCurrentRouteSegmentEndPoint().hashCode();
        }
        if (this.hasRemainingDistanceMeters()) {
            hash = 37 * hash + 6;
            hash = 53 * hash + this.getRemainingDistanceMeters().hashCode();
        }
        if (this.hasRemainingDuration()) {
            hash = 37 * hash + 7;
            hash = 53 * hash + this.getRemainingDuration().hashCode();
        }
        if (this.getRemainingVehicleJourneySegmentsCount() > 0) {
            hash = 37 * hash + 8;
            hash = 53 * hash + this.getRemainingVehicleJourneySegmentsList().hashCode();
        }
        if (this.getAttributesCount() > 0) {
            hash = 37 * hash + 9;
            hash = 53 * hash + this.getAttributesList().hashCode();
        }
        hash = 37 * hash + 10;
        hash = 53 * hash + this.type_;
        this.memoizedHashCode = hash = 29 * hash + this.getUnknownFields().hashCode();
        return hash;
    }

    public static DeliveryVehicle parseFrom(ByteBuffer data) throws InvalidProtocolBufferException {
        return (DeliveryVehicle)PARSER.parseFrom(data);
    }

    public static DeliveryVehicle parseFrom(ByteBuffer data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (DeliveryVehicle)PARSER.parseFrom(data, extensionRegistry);
    }

    public static DeliveryVehicle parseFrom(ByteString data) throws InvalidProtocolBufferException {
        return (DeliveryVehicle)PARSER.parseFrom(data);
    }

    public static DeliveryVehicle parseFrom(ByteString data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (DeliveryVehicle)PARSER.parseFrom(data, extensionRegistry);
    }

    public static DeliveryVehicle parseFrom(byte[] data) throws InvalidProtocolBufferException {
        return (DeliveryVehicle)PARSER.parseFrom(data);
    }

    public static DeliveryVehicle parseFrom(byte[] data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (DeliveryVehicle)PARSER.parseFrom(data, extensionRegistry);
    }

    public static DeliveryVehicle parseFrom(InputStream input) throws IOException {
        return (DeliveryVehicle)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input);
    }

    public static DeliveryVehicle parseFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (DeliveryVehicle)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public static DeliveryVehicle parseDelimitedFrom(InputStream input) throws IOException {
        return (DeliveryVehicle)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input);
    }

    public static DeliveryVehicle parseDelimitedFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (DeliveryVehicle)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public static DeliveryVehicle parseFrom(CodedInputStream input) throws IOException {
        return (DeliveryVehicle)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input);
    }

    public static DeliveryVehicle parseFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (DeliveryVehicle)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public Builder newBuilderForType() {
        return DeliveryVehicle.newBuilder();
    }

    public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(DeliveryVehicle prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    protected Builder newBuilderForType(GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
    }

    public static DeliveryVehicle getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public static Parser<DeliveryVehicle> parser() {
        return PARSER;
    }

    public Parser<DeliveryVehicle> getParserForType() {
        return PARSER;
    }

    public DeliveryVehicle getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
    }

    public static final class Builder
    extends GeneratedMessageV3.Builder<Builder>
    implements DeliveryVehicleOrBuilder {
        private int bitField0_;
        private Object name_ = "";
        private DeliveryVehicleLocation lastLocation_;
        private SingleFieldBuilderV3<DeliveryVehicleLocation, DeliveryVehicleLocation.Builder, DeliveryVehicleLocationOrBuilder> lastLocationBuilder_;
        private List<DeliveryVehicleLocation> pastLocations_ = Collections.emptyList();
        private RepeatedFieldBuilderV3<DeliveryVehicleLocation, DeliveryVehicleLocation.Builder, DeliveryVehicleLocationOrBuilder> pastLocationsBuilder_;
        private int navigationStatus_ = 0;
        private ByteString currentRouteSegment_ = ByteString.EMPTY;
        private LatLng currentRouteSegmentEndPoint_;
        private SingleFieldBuilderV3<LatLng, LatLng.Builder, LatLngOrBuilder> currentRouteSegmentEndPointBuilder_;
        private Int32Value remainingDistanceMeters_;
        private SingleFieldBuilderV3<Int32Value, Int32Value.Builder, Int32ValueOrBuilder> remainingDistanceMetersBuilder_;
        private Duration remainingDuration_;
        private SingleFieldBuilderV3<Duration, Duration.Builder, DurationOrBuilder> remainingDurationBuilder_;
        private List<VehicleJourneySegment> remainingVehicleJourneySegments_ = Collections.emptyList();
        private RepeatedFieldBuilderV3<VehicleJourneySegment, VehicleJourneySegment.Builder, VehicleJourneySegmentOrBuilder> remainingVehicleJourneySegmentsBuilder_;
        private List<DeliveryVehicleAttribute> attributes_ = Collections.emptyList();
        private RepeatedFieldBuilderV3<DeliveryVehicleAttribute, DeliveryVehicleAttribute.Builder, DeliveryVehicleAttributeOrBuilder> attributesBuilder_;
        private int type_ = 0;

        public static final Descriptors.Descriptor getDescriptor() {
            return DeliveryVehicles.internal_static_maps_fleetengine_delivery_v1_DeliveryVehicle_descriptor;
        }

        protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
            return DeliveryVehicles.internal_static_maps_fleetengine_delivery_v1_DeliveryVehicle_fieldAccessorTable.ensureFieldAccessorsInitialized(DeliveryVehicle.class, Builder.class);
        }

        private Builder() {
            this.maybeForceBuilderInitialization();
        }

        private Builder(GeneratedMessageV3.BuilderParent parent) {
            super(parent);
            this.maybeForceBuilderInitialization();
        }

        private void maybeForceBuilderInitialization() {
            if (alwaysUseFieldBuilders) {
                this.getLastLocationFieldBuilder();
                this.getPastLocationsFieldBuilder();
                this.getCurrentRouteSegmentEndPointFieldBuilder();
                this.getRemainingDistanceMetersFieldBuilder();
                this.getRemainingDurationFieldBuilder();
                this.getRemainingVehicleJourneySegmentsFieldBuilder();
                this.getAttributesFieldBuilder();
            }
        }

        public Builder clear() {
            super.clear();
            this.bitField0_ = 0;
            this.name_ = "";
            this.lastLocation_ = null;
            if (this.lastLocationBuilder_ != null) {
                this.lastLocationBuilder_.dispose();
                this.lastLocationBuilder_ = null;
            }
            if (this.pastLocationsBuilder_ == null) {
                this.pastLocations_ = Collections.emptyList();
            } else {
                this.pastLocations_ = null;
                this.pastLocationsBuilder_.clear();
            }
            this.bitField0_ &= 0xFFFFFFFB;
            this.navigationStatus_ = 0;
            this.currentRouteSegment_ = ByteString.EMPTY;
            this.currentRouteSegmentEndPoint_ = null;
            if (this.currentRouteSegmentEndPointBuilder_ != null) {
                this.currentRouteSegmentEndPointBuilder_.dispose();
                this.currentRouteSegmentEndPointBuilder_ = null;
            }
            this.remainingDistanceMeters_ = null;
            if (this.remainingDistanceMetersBuilder_ != null) {
                this.remainingDistanceMetersBuilder_.dispose();
                this.remainingDistanceMetersBuilder_ = null;
            }
            this.remainingDuration_ = null;
            if (this.remainingDurationBuilder_ != null) {
                this.remainingDurationBuilder_.dispose();
                this.remainingDurationBuilder_ = null;
            }
            if (this.remainingVehicleJourneySegmentsBuilder_ == null) {
                this.remainingVehicleJourneySegments_ = Collections.emptyList();
            } else {
                this.remainingVehicleJourneySegments_ = null;
                this.remainingVehicleJourneySegmentsBuilder_.clear();
            }
            this.bitField0_ &= 0xFFFFFEFF;
            if (this.attributesBuilder_ == null) {
                this.attributes_ = Collections.emptyList();
            } else {
                this.attributes_ = null;
                this.attributesBuilder_.clear();
            }
            this.bitField0_ &= 0xFFFFFDFF;
            this.type_ = 0;
            return this;
        }

        public Descriptors.Descriptor getDescriptorForType() {
            return DeliveryVehicles.internal_static_maps_fleetengine_delivery_v1_DeliveryVehicle_descriptor;
        }

        public DeliveryVehicle getDefaultInstanceForType() {
            return DeliveryVehicle.getDefaultInstance();
        }

        public DeliveryVehicle build() {
            DeliveryVehicle result = this.buildPartial();
            if (!result.isInitialized()) {
                throw Builder.newUninitializedMessageException((Message)result);
            }
            return result;
        }

        public DeliveryVehicle buildPartial() {
            DeliveryVehicle result = new DeliveryVehicle(this);
            this.buildPartialRepeatedFields(result);
            if (this.bitField0_ != 0) {
                this.buildPartial0(result);
            }
            this.onBuilt();
            return result;
        }

        private void buildPartialRepeatedFields(DeliveryVehicle result) {
            if (this.pastLocationsBuilder_ == null) {
                if ((this.bitField0_ & 4) != 0) {
                    this.pastLocations_ = Collections.unmodifiableList(this.pastLocations_);
                    this.bitField0_ &= 0xFFFFFFFB;
                }
                result.pastLocations_ = this.pastLocations_;
            } else {
                result.pastLocations_ = this.pastLocationsBuilder_.build();
            }
            if (this.remainingVehicleJourneySegmentsBuilder_ == null) {
                if ((this.bitField0_ & 0x100) != 0) {
                    this.remainingVehicleJourneySegments_ = Collections.unmodifiableList(this.remainingVehicleJourneySegments_);
                    this.bitField0_ &= 0xFFFFFEFF;
                }
                result.remainingVehicleJourneySegments_ = this.remainingVehicleJourneySegments_;
            } else {
                result.remainingVehicleJourneySegments_ = this.remainingVehicleJourneySegmentsBuilder_.build();
            }
            if (this.attributesBuilder_ == null) {
                if ((this.bitField0_ & 0x200) != 0) {
                    this.attributes_ = Collections.unmodifiableList(this.attributes_);
                    this.bitField0_ &= 0xFFFFFDFF;
                }
                result.attributes_ = this.attributes_;
            } else {
                result.attributes_ = this.attributesBuilder_.build();
            }
        }

        private void buildPartial0(DeliveryVehicle result) {
            int from_bitField0_ = this.bitField0_;
            if ((from_bitField0_ & 1) != 0) {
                result.name_ = this.name_;
            }
            int to_bitField0_ = 0;
            if ((from_bitField0_ & 2) != 0) {
                result.lastLocation_ = this.lastLocationBuilder_ == null ? this.lastLocation_ : (DeliveryVehicleLocation)this.lastLocationBuilder_.build();
                to_bitField0_ |= 1;
            }
            if ((from_bitField0_ & 8) != 0) {
                result.navigationStatus_ = this.navigationStatus_;
            }
            if ((from_bitField0_ & 0x10) != 0) {
                result.currentRouteSegment_ = this.currentRouteSegment_;
            }
            if ((from_bitField0_ & 0x20) != 0) {
                result.currentRouteSegmentEndPoint_ = this.currentRouteSegmentEndPointBuilder_ == null ? this.currentRouteSegmentEndPoint_ : (LatLng)this.currentRouteSegmentEndPointBuilder_.build();
                to_bitField0_ |= 2;
            }
            if ((from_bitField0_ & 0x40) != 0) {
                result.remainingDistanceMeters_ = this.remainingDistanceMetersBuilder_ == null ? this.remainingDistanceMeters_ : (Int32Value)this.remainingDistanceMetersBuilder_.build();
                to_bitField0_ |= 4;
            }
            if ((from_bitField0_ & 0x80) != 0) {
                result.remainingDuration_ = this.remainingDurationBuilder_ == null ? this.remainingDuration_ : (Duration)this.remainingDurationBuilder_.build();
                to_bitField0_ |= 8;
            }
            if ((from_bitField0_ & 0x400) != 0) {
                result.type_ = this.type_;
            }
            DeliveryVehicle deliveryVehicle = result;
            deliveryVehicle.bitField0_ = deliveryVehicle.bitField0_ | to_bitField0_;
        }

        public Builder clone() {
            return (Builder)super.clone();
        }

        public Builder setField(Descriptors.FieldDescriptor field, Object value) {
            return (Builder)super.setField(field, value);
        }

        public Builder clearField(Descriptors.FieldDescriptor field) {
            return (Builder)super.clearField(field);
        }

        public Builder clearOneof(Descriptors.OneofDescriptor oneof) {
            return (Builder)super.clearOneof(oneof);
        }

        public Builder setRepeatedField(Descriptors.FieldDescriptor field, int index, Object value) {
            return (Builder)super.setRepeatedField(field, index, value);
        }

        public Builder addRepeatedField(Descriptors.FieldDescriptor field, Object value) {
            return (Builder)super.addRepeatedField(field, value);
        }

        public Builder mergeFrom(Message other) {
            if (other instanceof DeliveryVehicle) {
                return this.mergeFrom((DeliveryVehicle)other);
            }
            super.mergeFrom(other);
            return this;
        }

        public Builder mergeFrom(DeliveryVehicle other) {
            if (other == DeliveryVehicle.getDefaultInstance()) {
                return this;
            }
            if (!other.getName().isEmpty()) {
                this.name_ = other.name_;
                this.bitField0_ |= 1;
                this.onChanged();
            }
            if (other.hasLastLocation()) {
                this.mergeLastLocation(other.getLastLocation());
            }
            if (this.pastLocationsBuilder_ == null) {
                if (!other.pastLocations_.isEmpty()) {
                    if (this.pastLocations_.isEmpty()) {
                        this.pastLocations_ = other.pastLocations_;
                        this.bitField0_ &= 0xFFFFFFFB;
                    } else {
                        this.ensurePastLocationsIsMutable();
                        this.pastLocations_.addAll(other.pastLocations_);
                    }
                    this.onChanged();
                }
            } else if (!other.pastLocations_.isEmpty()) {
                if (this.pastLocationsBuilder_.isEmpty()) {
                    this.pastLocationsBuilder_.dispose();
                    this.pastLocationsBuilder_ = null;
                    this.pastLocations_ = other.pastLocations_;
                    this.bitField0_ &= 0xFFFFFFFB;
                    this.pastLocationsBuilder_ = alwaysUseFieldBuilders ? this.getPastLocationsFieldBuilder() : null;
                } else {
                    this.pastLocationsBuilder_.addAllMessages((Iterable)other.pastLocations_);
                }
            }
            if (other.navigationStatus_ != 0) {
                this.setNavigationStatusValue(other.getNavigationStatusValue());
            }
            if (other.getCurrentRouteSegment() != ByteString.EMPTY) {
                this.setCurrentRouteSegment(other.getCurrentRouteSegment());
            }
            if (other.hasCurrentRouteSegmentEndPoint()) {
                this.mergeCurrentRouteSegmentEndPoint(other.getCurrentRouteSegmentEndPoint());
            }
            if (other.hasRemainingDistanceMeters()) {
                this.mergeRemainingDistanceMeters(other.getRemainingDistanceMeters());
            }
            if (other.hasRemainingDuration()) {
                this.mergeRemainingDuration(other.getRemainingDuration());
            }
            if (this.remainingVehicleJourneySegmentsBuilder_ == null) {
                if (!other.remainingVehicleJourneySegments_.isEmpty()) {
                    if (this.remainingVehicleJourneySegments_.isEmpty()) {
                        this.remainingVehicleJourneySegments_ = other.remainingVehicleJourneySegments_;
                        this.bitField0_ &= 0xFFFFFEFF;
                    } else {
                        this.ensureRemainingVehicleJourneySegmentsIsMutable();
                        this.remainingVehicleJourneySegments_.addAll(other.remainingVehicleJourneySegments_);
                    }
                    this.onChanged();
                }
            } else if (!other.remainingVehicleJourneySegments_.isEmpty()) {
                if (this.remainingVehicleJourneySegmentsBuilder_.isEmpty()) {
                    this.remainingVehicleJourneySegmentsBuilder_.dispose();
                    this.remainingVehicleJourneySegmentsBuilder_ = null;
                    this.remainingVehicleJourneySegments_ = other.remainingVehicleJourneySegments_;
                    this.bitField0_ &= 0xFFFFFEFF;
                    this.remainingVehicleJourneySegmentsBuilder_ = alwaysUseFieldBuilders ? this.getRemainingVehicleJourneySegmentsFieldBuilder() : null;
                } else {
                    this.remainingVehicleJourneySegmentsBuilder_.addAllMessages((Iterable)other.remainingVehicleJourneySegments_);
                }
            }
            if (this.attributesBuilder_ == null) {
                if (!other.attributes_.isEmpty()) {
                    if (this.attributes_.isEmpty()) {
                        this.attributes_ = other.attributes_;
                        this.bitField0_ &= 0xFFFFFDFF;
                    } else {
                        this.ensureAttributesIsMutable();
                        this.attributes_.addAll(other.attributes_);
                    }
                    this.onChanged();
                }
            } else if (!other.attributes_.isEmpty()) {
                if (this.attributesBuilder_.isEmpty()) {
                    this.attributesBuilder_.dispose();
                    this.attributesBuilder_ = null;
                    this.attributes_ = other.attributes_;
                    this.bitField0_ &= 0xFFFFFDFF;
                    this.attributesBuilder_ = alwaysUseFieldBuilders ? this.getAttributesFieldBuilder() : null;
                } else {
                    this.attributesBuilder_.addAllMessages((Iterable)other.attributes_);
                }
            }
            if (other.type_ != 0) {
                this.setTypeValue(other.getTypeValue());
            }
            this.mergeUnknownFields(other.getUnknownFields());
            this.onChanged();
            return this;
        }

        public final boolean isInitialized() {
            return true;
        }

        public Builder mergeFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            if (extensionRegistry == null) {
                throw new NullPointerException();
            }
            try {
                boolean done = false;
                block19: while (!done) {
                    int tag = input.readTag();
                    switch (tag) {
                        case 0: {
                            done = true;
                            continue block19;
                        }
                        case 10: {
                            this.name_ = input.readStringRequireUtf8();
                            this.bitField0_ |= 1;
                            continue block19;
                        }
                        case 18: {
                            input.readMessage((MessageLite.Builder)this.getLastLocationFieldBuilder().getBuilder(), extensionRegistry);
                            this.bitField0_ |= 2;
                            continue block19;
                        }
                        case 24: {
                            this.navigationStatus_ = input.readEnum();
                            this.bitField0_ |= 8;
                            continue block19;
                        }
                        case 34: {
                            this.currentRouteSegment_ = input.readBytes();
                            this.bitField0_ |= 0x10;
                            continue block19;
                        }
                        case 42: {
                            input.readMessage((MessageLite.Builder)this.getCurrentRouteSegmentEndPointFieldBuilder().getBuilder(), extensionRegistry);
                            this.bitField0_ |= 0x20;
                            continue block19;
                        }
                        case 50: {
                            input.readMessage((MessageLite.Builder)this.getRemainingDistanceMetersFieldBuilder().getBuilder(), extensionRegistry);
                            this.bitField0_ |= 0x40;
                            continue block19;
                        }
                        case 58: {
                            input.readMessage((MessageLite.Builder)this.getRemainingDurationFieldBuilder().getBuilder(), extensionRegistry);
                            this.bitField0_ |= 0x80;
                            continue block19;
                        }
                        case 66: {
                            GeneratedMessageV3 m = (VehicleJourneySegment)input.readMessage(VehicleJourneySegment.parser(), extensionRegistry);
                            if (this.remainingVehicleJourneySegmentsBuilder_ == null) {
                                this.ensureRemainingVehicleJourneySegmentsIsMutable();
                                this.remainingVehicleJourneySegments_.add((VehicleJourneySegment)m);
                                continue block19;
                            }
                            this.remainingVehicleJourneySegmentsBuilder_.addMessage((AbstractMessage)m);
                            continue block19;
                        }
                        case 74: {
                            GeneratedMessageV3 m = (DeliveryVehicleAttribute)input.readMessage(DeliveryVehicleAttribute.parser(), extensionRegistry);
                            if (this.attributesBuilder_ == null) {
                                this.ensureAttributesIsMutable();
                                this.attributes_.add((DeliveryVehicleAttribute)m);
                                continue block19;
                            }
                            this.attributesBuilder_.addMessage((AbstractMessage)m);
                            continue block19;
                        }
                        case 80: {
                            this.type_ = input.readEnum();
                            this.bitField0_ |= 0x400;
                            continue block19;
                        }
                        case 98: {
                            GeneratedMessageV3 m = (DeliveryVehicleLocation)input.readMessage(DeliveryVehicleLocation.parser(), extensionRegistry);
                            if (this.pastLocationsBuilder_ == null) {
                                this.ensurePastLocationsIsMutable();
                                this.pastLocations_.add((DeliveryVehicleLocation)m);
                                continue block19;
                            }
                            this.pastLocationsBuilder_.addMessage((AbstractMessage)m);
                            continue block19;
                        }
                    }
                    if (super.parseUnknownField(input, extensionRegistry, tag)) continue;
                    done = true;
                }
            }
            catch (InvalidProtocolBufferException e) {
                throw e.unwrapIOException();
            }
            finally {
                this.onChanged();
            }
            return this;
        }

        @Override
        public String getName() {
            Object ref = this.name_;
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                this.name_ = s;
                return s;
            }
            return (String)ref;
        }

        @Override
        public ByteString getNameBytes() {
            Object ref = this.name_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.name_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public Builder setName(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.name_ = value;
            this.bitField0_ |= 1;
            this.onChanged();
            return this;
        }

        public Builder clearName() {
            this.name_ = DeliveryVehicle.getDefaultInstance().getName();
            this.bitField0_ &= 0xFFFFFFFE;
            this.onChanged();
            return this;
        }

        public Builder setNameBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            DeliveryVehicle.checkByteStringIsUtf8((ByteString)value);
            this.name_ = value;
            this.bitField0_ |= 1;
            this.onChanged();
            return this;
        }

        @Override
        public boolean hasLastLocation() {
            return (this.bitField0_ & 2) != 0;
        }

        @Override
        public DeliveryVehicleLocation getLastLocation() {
            if (this.lastLocationBuilder_ == null) {
                return this.lastLocation_ == null ? DeliveryVehicleLocation.getDefaultInstance() : this.lastLocation_;
            }
            return (DeliveryVehicleLocation)this.lastLocationBuilder_.getMessage();
        }

        public Builder setLastLocation(DeliveryVehicleLocation value) {
            if (this.lastLocationBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.lastLocation_ = value;
            } else {
                this.lastLocationBuilder_.setMessage((AbstractMessage)value);
            }
            this.bitField0_ |= 2;
            this.onChanged();
            return this;
        }

        public Builder setLastLocation(DeliveryVehicleLocation.Builder builderForValue) {
            if (this.lastLocationBuilder_ == null) {
                this.lastLocation_ = builderForValue.build();
            } else {
                this.lastLocationBuilder_.setMessage((AbstractMessage)builderForValue.build());
            }
            this.bitField0_ |= 2;
            this.onChanged();
            return this;
        }

        public Builder mergeLastLocation(DeliveryVehicleLocation value) {
            if (this.lastLocationBuilder_ == null) {
                if ((this.bitField0_ & 2) != 0 && this.lastLocation_ != null && this.lastLocation_ != DeliveryVehicleLocation.getDefaultInstance()) {
                    this.getLastLocationBuilder().mergeFrom(value);
                } else {
                    this.lastLocation_ = value;
                }
            } else {
                this.lastLocationBuilder_.mergeFrom((AbstractMessage)value);
            }
            if (this.lastLocation_ != null) {
                this.bitField0_ |= 2;
                this.onChanged();
            }
            return this;
        }

        public Builder clearLastLocation() {
            this.bitField0_ &= 0xFFFFFFFD;
            this.lastLocation_ = null;
            if (this.lastLocationBuilder_ != null) {
                this.lastLocationBuilder_.dispose();
                this.lastLocationBuilder_ = null;
            }
            this.onChanged();
            return this;
        }

        public DeliveryVehicleLocation.Builder getLastLocationBuilder() {
            this.bitField0_ |= 2;
            this.onChanged();
            return (DeliveryVehicleLocation.Builder)this.getLastLocationFieldBuilder().getBuilder();
        }

        @Override
        public DeliveryVehicleLocationOrBuilder getLastLocationOrBuilder() {
            if (this.lastLocationBuilder_ != null) {
                return (DeliveryVehicleLocationOrBuilder)this.lastLocationBuilder_.getMessageOrBuilder();
            }
            return this.lastLocation_ == null ? DeliveryVehicleLocation.getDefaultInstance() : this.lastLocation_;
        }

        private SingleFieldBuilderV3<DeliveryVehicleLocation, DeliveryVehicleLocation.Builder, DeliveryVehicleLocationOrBuilder> getLastLocationFieldBuilder() {
            if (this.lastLocationBuilder_ == null) {
                this.lastLocationBuilder_ = new SingleFieldBuilderV3((AbstractMessage)this.getLastLocation(), (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.lastLocation_ = null;
            }
            return this.lastLocationBuilder_;
        }

        private void ensurePastLocationsIsMutable() {
            if ((this.bitField0_ & 4) == 0) {
                this.pastLocations_ = new ArrayList<DeliveryVehicleLocation>(this.pastLocations_);
                this.bitField0_ |= 4;
            }
        }

        @Override
        public List<DeliveryVehicleLocation> getPastLocationsList() {
            if (this.pastLocationsBuilder_ == null) {
                return Collections.unmodifiableList(this.pastLocations_);
            }
            return this.pastLocationsBuilder_.getMessageList();
        }

        @Override
        public int getPastLocationsCount() {
            if (this.pastLocationsBuilder_ == null) {
                return this.pastLocations_.size();
            }
            return this.pastLocationsBuilder_.getCount();
        }

        @Override
        public DeliveryVehicleLocation getPastLocations(int index) {
            if (this.pastLocationsBuilder_ == null) {
                return this.pastLocations_.get(index);
            }
            return (DeliveryVehicleLocation)this.pastLocationsBuilder_.getMessage(index);
        }

        public Builder setPastLocations(int index, DeliveryVehicleLocation value) {
            if (this.pastLocationsBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensurePastLocationsIsMutable();
                this.pastLocations_.set(index, value);
                this.onChanged();
            } else {
                this.pastLocationsBuilder_.setMessage(index, (AbstractMessage)value);
            }
            return this;
        }

        public Builder setPastLocations(int index, DeliveryVehicleLocation.Builder builderForValue) {
            if (this.pastLocationsBuilder_ == null) {
                this.ensurePastLocationsIsMutable();
                this.pastLocations_.set(index, builderForValue.build());
                this.onChanged();
            } else {
                this.pastLocationsBuilder_.setMessage(index, (AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addPastLocations(DeliveryVehicleLocation value) {
            if (this.pastLocationsBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensurePastLocationsIsMutable();
                this.pastLocations_.add(value);
                this.onChanged();
            } else {
                this.pastLocationsBuilder_.addMessage((AbstractMessage)value);
            }
            return this;
        }

        public Builder addPastLocations(int index, DeliveryVehicleLocation value) {
            if (this.pastLocationsBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensurePastLocationsIsMutable();
                this.pastLocations_.add(index, value);
                this.onChanged();
            } else {
                this.pastLocationsBuilder_.addMessage(index, (AbstractMessage)value);
            }
            return this;
        }

        public Builder addPastLocations(DeliveryVehicleLocation.Builder builderForValue) {
            if (this.pastLocationsBuilder_ == null) {
                this.ensurePastLocationsIsMutable();
                this.pastLocations_.add(builderForValue.build());
                this.onChanged();
            } else {
                this.pastLocationsBuilder_.addMessage((AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addPastLocations(int index, DeliveryVehicleLocation.Builder builderForValue) {
            if (this.pastLocationsBuilder_ == null) {
                this.ensurePastLocationsIsMutable();
                this.pastLocations_.add(index, builderForValue.build());
                this.onChanged();
            } else {
                this.pastLocationsBuilder_.addMessage(index, (AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addAllPastLocations(Iterable<? extends DeliveryVehicleLocation> values) {
            if (this.pastLocationsBuilder_ == null) {
                this.ensurePastLocationsIsMutable();
                AbstractMessageLite.Builder.addAll(values, this.pastLocations_);
                this.onChanged();
            } else {
                this.pastLocationsBuilder_.addAllMessages(values);
            }
            return this;
        }

        public Builder clearPastLocations() {
            if (this.pastLocationsBuilder_ == null) {
                this.pastLocations_ = Collections.emptyList();
                this.bitField0_ &= 0xFFFFFFFB;
                this.onChanged();
            } else {
                this.pastLocationsBuilder_.clear();
            }
            return this;
        }

        public Builder removePastLocations(int index) {
            if (this.pastLocationsBuilder_ == null) {
                this.ensurePastLocationsIsMutable();
                this.pastLocations_.remove(index);
                this.onChanged();
            } else {
                this.pastLocationsBuilder_.remove(index);
            }
            return this;
        }

        public DeliveryVehicleLocation.Builder getPastLocationsBuilder(int index) {
            return (DeliveryVehicleLocation.Builder)this.getPastLocationsFieldBuilder().getBuilder(index);
        }

        @Override
        public DeliveryVehicleLocationOrBuilder getPastLocationsOrBuilder(int index) {
            if (this.pastLocationsBuilder_ == null) {
                return this.pastLocations_.get(index);
            }
            return (DeliveryVehicleLocationOrBuilder)this.pastLocationsBuilder_.getMessageOrBuilder(index);
        }

        @Override
        public List<? extends DeliveryVehicleLocationOrBuilder> getPastLocationsOrBuilderList() {
            if (this.pastLocationsBuilder_ != null) {
                return this.pastLocationsBuilder_.getMessageOrBuilderList();
            }
            return Collections.unmodifiableList(this.pastLocations_);
        }

        public DeliveryVehicleLocation.Builder addPastLocationsBuilder() {
            return (DeliveryVehicleLocation.Builder)this.getPastLocationsFieldBuilder().addBuilder((AbstractMessage)DeliveryVehicleLocation.getDefaultInstance());
        }

        public DeliveryVehicleLocation.Builder addPastLocationsBuilder(int index) {
            return (DeliveryVehicleLocation.Builder)this.getPastLocationsFieldBuilder().addBuilder(index, (AbstractMessage)DeliveryVehicleLocation.getDefaultInstance());
        }

        public List<DeliveryVehicleLocation.Builder> getPastLocationsBuilderList() {
            return this.getPastLocationsFieldBuilder().getBuilderList();
        }

        private RepeatedFieldBuilderV3<DeliveryVehicleLocation, DeliveryVehicleLocation.Builder, DeliveryVehicleLocationOrBuilder> getPastLocationsFieldBuilder() {
            if (this.pastLocationsBuilder_ == null) {
                this.pastLocationsBuilder_ = new RepeatedFieldBuilderV3(this.pastLocations_, (this.bitField0_ & 4) != 0, (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.pastLocations_ = null;
            }
            return this.pastLocationsBuilder_;
        }

        @Override
        public int getNavigationStatusValue() {
            return this.navigationStatus_;
        }

        public Builder setNavigationStatusValue(int value) {
            this.navigationStatus_ = value;
            this.bitField0_ |= 8;
            this.onChanged();
            return this;
        }

        @Override
        public DeliveryVehicleNavigationStatus getNavigationStatus() {
            DeliveryVehicleNavigationStatus result = DeliveryVehicleNavigationStatus.forNumber(this.navigationStatus_);
            return result == null ? DeliveryVehicleNavigationStatus.UNRECOGNIZED : result;
        }

        public Builder setNavigationStatus(DeliveryVehicleNavigationStatus value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.bitField0_ |= 8;
            this.navigationStatus_ = value.getNumber();
            this.onChanged();
            return this;
        }

        public Builder clearNavigationStatus() {
            this.bitField0_ &= 0xFFFFFFF7;
            this.navigationStatus_ = 0;
            this.onChanged();
            return this;
        }

        @Override
        public ByteString getCurrentRouteSegment() {
            return this.currentRouteSegment_;
        }

        public Builder setCurrentRouteSegment(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.currentRouteSegment_ = value;
            this.bitField0_ |= 0x10;
            this.onChanged();
            return this;
        }

        public Builder clearCurrentRouteSegment() {
            this.bitField0_ &= 0xFFFFFFEF;
            this.currentRouteSegment_ = DeliveryVehicle.getDefaultInstance().getCurrentRouteSegment();
            this.onChanged();
            return this;
        }

        @Override
        public boolean hasCurrentRouteSegmentEndPoint() {
            return (this.bitField0_ & 0x20) != 0;
        }

        @Override
        public LatLng getCurrentRouteSegmentEndPoint() {
            if (this.currentRouteSegmentEndPointBuilder_ == null) {
                return this.currentRouteSegmentEndPoint_ == null ? LatLng.getDefaultInstance() : this.currentRouteSegmentEndPoint_;
            }
            return (LatLng)this.currentRouteSegmentEndPointBuilder_.getMessage();
        }

        public Builder setCurrentRouteSegmentEndPoint(LatLng value) {
            if (this.currentRouteSegmentEndPointBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.currentRouteSegmentEndPoint_ = value;
            } else {
                this.currentRouteSegmentEndPointBuilder_.setMessage((AbstractMessage)value);
            }
            this.bitField0_ |= 0x20;
            this.onChanged();
            return this;
        }

        public Builder setCurrentRouteSegmentEndPoint(LatLng.Builder builderForValue) {
            if (this.currentRouteSegmentEndPointBuilder_ == null) {
                this.currentRouteSegmentEndPoint_ = builderForValue.build();
            } else {
                this.currentRouteSegmentEndPointBuilder_.setMessage((AbstractMessage)builderForValue.build());
            }
            this.bitField0_ |= 0x20;
            this.onChanged();
            return this;
        }

        public Builder mergeCurrentRouteSegmentEndPoint(LatLng value) {
            if (this.currentRouteSegmentEndPointBuilder_ == null) {
                if ((this.bitField0_ & 0x20) != 0 && this.currentRouteSegmentEndPoint_ != null && this.currentRouteSegmentEndPoint_ != LatLng.getDefaultInstance()) {
                    this.getCurrentRouteSegmentEndPointBuilder().mergeFrom(value);
                } else {
                    this.currentRouteSegmentEndPoint_ = value;
                }
            } else {
                this.currentRouteSegmentEndPointBuilder_.mergeFrom((AbstractMessage)value);
            }
            if (this.currentRouteSegmentEndPoint_ != null) {
                this.bitField0_ |= 0x20;
                this.onChanged();
            }
            return this;
        }

        public Builder clearCurrentRouteSegmentEndPoint() {
            this.bitField0_ &= 0xFFFFFFDF;
            this.currentRouteSegmentEndPoint_ = null;
            if (this.currentRouteSegmentEndPointBuilder_ != null) {
                this.currentRouteSegmentEndPointBuilder_.dispose();
                this.currentRouteSegmentEndPointBuilder_ = null;
            }
            this.onChanged();
            return this;
        }

        public LatLng.Builder getCurrentRouteSegmentEndPointBuilder() {
            this.bitField0_ |= 0x20;
            this.onChanged();
            return (LatLng.Builder)this.getCurrentRouteSegmentEndPointFieldBuilder().getBuilder();
        }

        @Override
        public LatLngOrBuilder getCurrentRouteSegmentEndPointOrBuilder() {
            if (this.currentRouteSegmentEndPointBuilder_ != null) {
                return (LatLngOrBuilder)this.currentRouteSegmentEndPointBuilder_.getMessageOrBuilder();
            }
            return this.currentRouteSegmentEndPoint_ == null ? LatLng.getDefaultInstance() : this.currentRouteSegmentEndPoint_;
        }

        private SingleFieldBuilderV3<LatLng, LatLng.Builder, LatLngOrBuilder> getCurrentRouteSegmentEndPointFieldBuilder() {
            if (this.currentRouteSegmentEndPointBuilder_ == null) {
                this.currentRouteSegmentEndPointBuilder_ = new SingleFieldBuilderV3((AbstractMessage)this.getCurrentRouteSegmentEndPoint(), (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.currentRouteSegmentEndPoint_ = null;
            }
            return this.currentRouteSegmentEndPointBuilder_;
        }

        @Override
        public boolean hasRemainingDistanceMeters() {
            return (this.bitField0_ & 0x40) != 0;
        }

        @Override
        public Int32Value getRemainingDistanceMeters() {
            if (this.remainingDistanceMetersBuilder_ == null) {
                return this.remainingDistanceMeters_ == null ? Int32Value.getDefaultInstance() : this.remainingDistanceMeters_;
            }
            return (Int32Value)this.remainingDistanceMetersBuilder_.getMessage();
        }

        public Builder setRemainingDistanceMeters(Int32Value value) {
            if (this.remainingDistanceMetersBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.remainingDistanceMeters_ = value;
            } else {
                this.remainingDistanceMetersBuilder_.setMessage((AbstractMessage)value);
            }
            this.bitField0_ |= 0x40;
            this.onChanged();
            return this;
        }

        public Builder setRemainingDistanceMeters(Int32Value.Builder builderForValue) {
            if (this.remainingDistanceMetersBuilder_ == null) {
                this.remainingDistanceMeters_ = builderForValue.build();
            } else {
                this.remainingDistanceMetersBuilder_.setMessage((AbstractMessage)builderForValue.build());
            }
            this.bitField0_ |= 0x40;
            this.onChanged();
            return this;
        }

        public Builder mergeRemainingDistanceMeters(Int32Value value) {
            if (this.remainingDistanceMetersBuilder_ == null) {
                if ((this.bitField0_ & 0x40) != 0 && this.remainingDistanceMeters_ != null && this.remainingDistanceMeters_ != Int32Value.getDefaultInstance()) {
                    this.getRemainingDistanceMetersBuilder().mergeFrom(value);
                } else {
                    this.remainingDistanceMeters_ = value;
                }
            } else {
                this.remainingDistanceMetersBuilder_.mergeFrom((AbstractMessage)value);
            }
            if (this.remainingDistanceMeters_ != null) {
                this.bitField0_ |= 0x40;
                this.onChanged();
            }
            return this;
        }

        public Builder clearRemainingDistanceMeters() {
            this.bitField0_ &= 0xFFFFFFBF;
            this.remainingDistanceMeters_ = null;
            if (this.remainingDistanceMetersBuilder_ != null) {
                this.remainingDistanceMetersBuilder_.dispose();
                this.remainingDistanceMetersBuilder_ = null;
            }
            this.onChanged();
            return this;
        }

        public Int32Value.Builder getRemainingDistanceMetersBuilder() {
            this.bitField0_ |= 0x40;
            this.onChanged();
            return (Int32Value.Builder)this.getRemainingDistanceMetersFieldBuilder().getBuilder();
        }

        @Override
        public Int32ValueOrBuilder getRemainingDistanceMetersOrBuilder() {
            if (this.remainingDistanceMetersBuilder_ != null) {
                return (Int32ValueOrBuilder)this.remainingDistanceMetersBuilder_.getMessageOrBuilder();
            }
            return this.remainingDistanceMeters_ == null ? Int32Value.getDefaultInstance() : this.remainingDistanceMeters_;
        }

        private SingleFieldBuilderV3<Int32Value, Int32Value.Builder, Int32ValueOrBuilder> getRemainingDistanceMetersFieldBuilder() {
            if (this.remainingDistanceMetersBuilder_ == null) {
                this.remainingDistanceMetersBuilder_ = new SingleFieldBuilderV3((AbstractMessage)this.getRemainingDistanceMeters(), (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.remainingDistanceMeters_ = null;
            }
            return this.remainingDistanceMetersBuilder_;
        }

        @Override
        public boolean hasRemainingDuration() {
            return (this.bitField0_ & 0x80) != 0;
        }

        @Override
        public Duration getRemainingDuration() {
            if (this.remainingDurationBuilder_ == null) {
                return this.remainingDuration_ == null ? Duration.getDefaultInstance() : this.remainingDuration_;
            }
            return (Duration)this.remainingDurationBuilder_.getMessage();
        }

        public Builder setRemainingDuration(Duration value) {
            if (this.remainingDurationBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.remainingDuration_ = value;
            } else {
                this.remainingDurationBuilder_.setMessage((AbstractMessage)value);
            }
            this.bitField0_ |= 0x80;
            this.onChanged();
            return this;
        }

        public Builder setRemainingDuration(Duration.Builder builderForValue) {
            if (this.remainingDurationBuilder_ == null) {
                this.remainingDuration_ = builderForValue.build();
            } else {
                this.remainingDurationBuilder_.setMessage((AbstractMessage)builderForValue.build());
            }
            this.bitField0_ |= 0x80;
            this.onChanged();
            return this;
        }

        public Builder mergeRemainingDuration(Duration value) {
            if (this.remainingDurationBuilder_ == null) {
                if ((this.bitField0_ & 0x80) != 0 && this.remainingDuration_ != null && this.remainingDuration_ != Duration.getDefaultInstance()) {
                    this.getRemainingDurationBuilder().mergeFrom(value);
                } else {
                    this.remainingDuration_ = value;
                }
            } else {
                this.remainingDurationBuilder_.mergeFrom((AbstractMessage)value);
            }
            if (this.remainingDuration_ != null) {
                this.bitField0_ |= 0x80;
                this.onChanged();
            }
            return this;
        }

        public Builder clearRemainingDuration() {
            this.bitField0_ &= 0xFFFFFF7F;
            this.remainingDuration_ = null;
            if (this.remainingDurationBuilder_ != null) {
                this.remainingDurationBuilder_.dispose();
                this.remainingDurationBuilder_ = null;
            }
            this.onChanged();
            return this;
        }

        public Duration.Builder getRemainingDurationBuilder() {
            this.bitField0_ |= 0x80;
            this.onChanged();
            return (Duration.Builder)this.getRemainingDurationFieldBuilder().getBuilder();
        }

        @Override
        public DurationOrBuilder getRemainingDurationOrBuilder() {
            if (this.remainingDurationBuilder_ != null) {
                return (DurationOrBuilder)this.remainingDurationBuilder_.getMessageOrBuilder();
            }
            return this.remainingDuration_ == null ? Duration.getDefaultInstance() : this.remainingDuration_;
        }

        private SingleFieldBuilderV3<Duration, Duration.Builder, DurationOrBuilder> getRemainingDurationFieldBuilder() {
            if (this.remainingDurationBuilder_ == null) {
                this.remainingDurationBuilder_ = new SingleFieldBuilderV3((AbstractMessage)this.getRemainingDuration(), (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.remainingDuration_ = null;
            }
            return this.remainingDurationBuilder_;
        }

        private void ensureRemainingVehicleJourneySegmentsIsMutable() {
            if ((this.bitField0_ & 0x100) == 0) {
                this.remainingVehicleJourneySegments_ = new ArrayList<VehicleJourneySegment>(this.remainingVehicleJourneySegments_);
                this.bitField0_ |= 0x100;
            }
        }

        @Override
        public List<VehicleJourneySegment> getRemainingVehicleJourneySegmentsList() {
            if (this.remainingVehicleJourneySegmentsBuilder_ == null) {
                return Collections.unmodifiableList(this.remainingVehicleJourneySegments_);
            }
            return this.remainingVehicleJourneySegmentsBuilder_.getMessageList();
        }

        @Override
        public int getRemainingVehicleJourneySegmentsCount() {
            if (this.remainingVehicleJourneySegmentsBuilder_ == null) {
                return this.remainingVehicleJourneySegments_.size();
            }
            return this.remainingVehicleJourneySegmentsBuilder_.getCount();
        }

        @Override
        public VehicleJourneySegment getRemainingVehicleJourneySegments(int index) {
            if (this.remainingVehicleJourneySegmentsBuilder_ == null) {
                return this.remainingVehicleJourneySegments_.get(index);
            }
            return (VehicleJourneySegment)this.remainingVehicleJourneySegmentsBuilder_.getMessage(index);
        }

        public Builder setRemainingVehicleJourneySegments(int index, VehicleJourneySegment value) {
            if (this.remainingVehicleJourneySegmentsBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureRemainingVehicleJourneySegmentsIsMutable();
                this.remainingVehicleJourneySegments_.set(index, value);
                this.onChanged();
            } else {
                this.remainingVehicleJourneySegmentsBuilder_.setMessage(index, (AbstractMessage)value);
            }
            return this;
        }

        public Builder setRemainingVehicleJourneySegments(int index, VehicleJourneySegment.Builder builderForValue) {
            if (this.remainingVehicleJourneySegmentsBuilder_ == null) {
                this.ensureRemainingVehicleJourneySegmentsIsMutable();
                this.remainingVehicleJourneySegments_.set(index, builderForValue.build());
                this.onChanged();
            } else {
                this.remainingVehicleJourneySegmentsBuilder_.setMessage(index, (AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addRemainingVehicleJourneySegments(VehicleJourneySegment value) {
            if (this.remainingVehicleJourneySegmentsBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureRemainingVehicleJourneySegmentsIsMutable();
                this.remainingVehicleJourneySegments_.add(value);
                this.onChanged();
            } else {
                this.remainingVehicleJourneySegmentsBuilder_.addMessage((AbstractMessage)value);
            }
            return this;
        }

        public Builder addRemainingVehicleJourneySegments(int index, VehicleJourneySegment value) {
            if (this.remainingVehicleJourneySegmentsBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureRemainingVehicleJourneySegmentsIsMutable();
                this.remainingVehicleJourneySegments_.add(index, value);
                this.onChanged();
            } else {
                this.remainingVehicleJourneySegmentsBuilder_.addMessage(index, (AbstractMessage)value);
            }
            return this;
        }

        public Builder addRemainingVehicleJourneySegments(VehicleJourneySegment.Builder builderForValue) {
            if (this.remainingVehicleJourneySegmentsBuilder_ == null) {
                this.ensureRemainingVehicleJourneySegmentsIsMutable();
                this.remainingVehicleJourneySegments_.add(builderForValue.build());
                this.onChanged();
            } else {
                this.remainingVehicleJourneySegmentsBuilder_.addMessage((AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addRemainingVehicleJourneySegments(int index, VehicleJourneySegment.Builder builderForValue) {
            if (this.remainingVehicleJourneySegmentsBuilder_ == null) {
                this.ensureRemainingVehicleJourneySegmentsIsMutable();
                this.remainingVehicleJourneySegments_.add(index, builderForValue.build());
                this.onChanged();
            } else {
                this.remainingVehicleJourneySegmentsBuilder_.addMessage(index, (AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addAllRemainingVehicleJourneySegments(Iterable<? extends VehicleJourneySegment> values) {
            if (this.remainingVehicleJourneySegmentsBuilder_ == null) {
                this.ensureRemainingVehicleJourneySegmentsIsMutable();
                AbstractMessageLite.Builder.addAll(values, this.remainingVehicleJourneySegments_);
                this.onChanged();
            } else {
                this.remainingVehicleJourneySegmentsBuilder_.addAllMessages(values);
            }
            return this;
        }

        public Builder clearRemainingVehicleJourneySegments() {
            if (this.remainingVehicleJourneySegmentsBuilder_ == null) {
                this.remainingVehicleJourneySegments_ = Collections.emptyList();
                this.bitField0_ &= 0xFFFFFEFF;
                this.onChanged();
            } else {
                this.remainingVehicleJourneySegmentsBuilder_.clear();
            }
            return this;
        }

        public Builder removeRemainingVehicleJourneySegments(int index) {
            if (this.remainingVehicleJourneySegmentsBuilder_ == null) {
                this.ensureRemainingVehicleJourneySegmentsIsMutable();
                this.remainingVehicleJourneySegments_.remove(index);
                this.onChanged();
            } else {
                this.remainingVehicleJourneySegmentsBuilder_.remove(index);
            }
            return this;
        }

        public VehicleJourneySegment.Builder getRemainingVehicleJourneySegmentsBuilder(int index) {
            return (VehicleJourneySegment.Builder)this.getRemainingVehicleJourneySegmentsFieldBuilder().getBuilder(index);
        }

        @Override
        public VehicleJourneySegmentOrBuilder getRemainingVehicleJourneySegmentsOrBuilder(int index) {
            if (this.remainingVehicleJourneySegmentsBuilder_ == null) {
                return this.remainingVehicleJourneySegments_.get(index);
            }
            return (VehicleJourneySegmentOrBuilder)this.remainingVehicleJourneySegmentsBuilder_.getMessageOrBuilder(index);
        }

        @Override
        public List<? extends VehicleJourneySegmentOrBuilder> getRemainingVehicleJourneySegmentsOrBuilderList() {
            if (this.remainingVehicleJourneySegmentsBuilder_ != null) {
                return this.remainingVehicleJourneySegmentsBuilder_.getMessageOrBuilderList();
            }
            return Collections.unmodifiableList(this.remainingVehicleJourneySegments_);
        }

        public VehicleJourneySegment.Builder addRemainingVehicleJourneySegmentsBuilder() {
            return (VehicleJourneySegment.Builder)this.getRemainingVehicleJourneySegmentsFieldBuilder().addBuilder((AbstractMessage)VehicleJourneySegment.getDefaultInstance());
        }

        public VehicleJourneySegment.Builder addRemainingVehicleJourneySegmentsBuilder(int index) {
            return (VehicleJourneySegment.Builder)this.getRemainingVehicleJourneySegmentsFieldBuilder().addBuilder(index, (AbstractMessage)VehicleJourneySegment.getDefaultInstance());
        }

        public List<VehicleJourneySegment.Builder> getRemainingVehicleJourneySegmentsBuilderList() {
            return this.getRemainingVehicleJourneySegmentsFieldBuilder().getBuilderList();
        }

        private RepeatedFieldBuilderV3<VehicleJourneySegment, VehicleJourneySegment.Builder, VehicleJourneySegmentOrBuilder> getRemainingVehicleJourneySegmentsFieldBuilder() {
            if (this.remainingVehicleJourneySegmentsBuilder_ == null) {
                this.remainingVehicleJourneySegmentsBuilder_ = new RepeatedFieldBuilderV3(this.remainingVehicleJourneySegments_, (this.bitField0_ & 0x100) != 0, (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.remainingVehicleJourneySegments_ = null;
            }
            return this.remainingVehicleJourneySegmentsBuilder_;
        }

        private void ensureAttributesIsMutable() {
            if ((this.bitField0_ & 0x200) == 0) {
                this.attributes_ = new ArrayList<DeliveryVehicleAttribute>(this.attributes_);
                this.bitField0_ |= 0x200;
            }
        }

        @Override
        public List<DeliveryVehicleAttribute> getAttributesList() {
            if (this.attributesBuilder_ == null) {
                return Collections.unmodifiableList(this.attributes_);
            }
            return this.attributesBuilder_.getMessageList();
        }

        @Override
        public int getAttributesCount() {
            if (this.attributesBuilder_ == null) {
                return this.attributes_.size();
            }
            return this.attributesBuilder_.getCount();
        }

        @Override
        public DeliveryVehicleAttribute getAttributes(int index) {
            if (this.attributesBuilder_ == null) {
                return this.attributes_.get(index);
            }
            return (DeliveryVehicleAttribute)this.attributesBuilder_.getMessage(index);
        }

        public Builder setAttributes(int index, DeliveryVehicleAttribute value) {
            if (this.attributesBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureAttributesIsMutable();
                this.attributes_.set(index, value);
                this.onChanged();
            } else {
                this.attributesBuilder_.setMessage(index, (AbstractMessage)value);
            }
            return this;
        }

        public Builder setAttributes(int index, DeliveryVehicleAttribute.Builder builderForValue) {
            if (this.attributesBuilder_ == null) {
                this.ensureAttributesIsMutable();
                this.attributes_.set(index, builderForValue.build());
                this.onChanged();
            } else {
                this.attributesBuilder_.setMessage(index, (AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addAttributes(DeliveryVehicleAttribute value) {
            if (this.attributesBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureAttributesIsMutable();
                this.attributes_.add(value);
                this.onChanged();
            } else {
                this.attributesBuilder_.addMessage((AbstractMessage)value);
            }
            return this;
        }

        public Builder addAttributes(int index, DeliveryVehicleAttribute value) {
            if (this.attributesBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureAttributesIsMutable();
                this.attributes_.add(index, value);
                this.onChanged();
            } else {
                this.attributesBuilder_.addMessage(index, (AbstractMessage)value);
            }
            return this;
        }

        public Builder addAttributes(DeliveryVehicleAttribute.Builder builderForValue) {
            if (this.attributesBuilder_ == null) {
                this.ensureAttributesIsMutable();
                this.attributes_.add(builderForValue.build());
                this.onChanged();
            } else {
                this.attributesBuilder_.addMessage((AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addAttributes(int index, DeliveryVehicleAttribute.Builder builderForValue) {
            if (this.attributesBuilder_ == null) {
                this.ensureAttributesIsMutable();
                this.attributes_.add(index, builderForValue.build());
                this.onChanged();
            } else {
                this.attributesBuilder_.addMessage(index, (AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addAllAttributes(Iterable<? extends DeliveryVehicleAttribute> values) {
            if (this.attributesBuilder_ == null) {
                this.ensureAttributesIsMutable();
                AbstractMessageLite.Builder.addAll(values, this.attributes_);
                this.onChanged();
            } else {
                this.attributesBuilder_.addAllMessages(values);
            }
            return this;
        }

        public Builder clearAttributes() {
            if (this.attributesBuilder_ == null) {
                this.attributes_ = Collections.emptyList();
                this.bitField0_ &= 0xFFFFFDFF;
                this.onChanged();
            } else {
                this.attributesBuilder_.clear();
            }
            return this;
        }

        public Builder removeAttributes(int index) {
            if (this.attributesBuilder_ == null) {
                this.ensureAttributesIsMutable();
                this.attributes_.remove(index);
                this.onChanged();
            } else {
                this.attributesBuilder_.remove(index);
            }
            return this;
        }

        public DeliveryVehicleAttribute.Builder getAttributesBuilder(int index) {
            return (DeliveryVehicleAttribute.Builder)this.getAttributesFieldBuilder().getBuilder(index);
        }

        @Override
        public DeliveryVehicleAttributeOrBuilder getAttributesOrBuilder(int index) {
            if (this.attributesBuilder_ == null) {
                return this.attributes_.get(index);
            }
            return (DeliveryVehicleAttributeOrBuilder)this.attributesBuilder_.getMessageOrBuilder(index);
        }

        @Override
        public List<? extends DeliveryVehicleAttributeOrBuilder> getAttributesOrBuilderList() {
            if (this.attributesBuilder_ != null) {
                return this.attributesBuilder_.getMessageOrBuilderList();
            }
            return Collections.unmodifiableList(this.attributes_);
        }

        public DeliveryVehicleAttribute.Builder addAttributesBuilder() {
            return (DeliveryVehicleAttribute.Builder)this.getAttributesFieldBuilder().addBuilder((AbstractMessage)DeliveryVehicleAttribute.getDefaultInstance());
        }

        public DeliveryVehicleAttribute.Builder addAttributesBuilder(int index) {
            return (DeliveryVehicleAttribute.Builder)this.getAttributesFieldBuilder().addBuilder(index, (AbstractMessage)DeliveryVehicleAttribute.getDefaultInstance());
        }

        public List<DeliveryVehicleAttribute.Builder> getAttributesBuilderList() {
            return this.getAttributesFieldBuilder().getBuilderList();
        }

        private RepeatedFieldBuilderV3<DeliveryVehicleAttribute, DeliveryVehicleAttribute.Builder, DeliveryVehicleAttributeOrBuilder> getAttributesFieldBuilder() {
            if (this.attributesBuilder_ == null) {
                this.attributesBuilder_ = new RepeatedFieldBuilderV3(this.attributes_, (this.bitField0_ & 0x200) != 0, (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.attributes_ = null;
            }
            return this.attributesBuilder_;
        }

        @Override
        public int getTypeValue() {
            return this.type_;
        }

        public Builder setTypeValue(int value) {
            this.type_ = value;
            this.bitField0_ |= 0x400;
            this.onChanged();
            return this;
        }

        @Override
        public DeliveryVehicleType getType() {
            DeliveryVehicleType result = DeliveryVehicleType.forNumber(this.type_);
            return result == null ? DeliveryVehicleType.UNRECOGNIZED : result;
        }

        public Builder setType(DeliveryVehicleType value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.bitField0_ |= 0x400;
            this.type_ = value.getNumber();
            this.onChanged();
            return this;
        }

        public Builder clearType() {
            this.bitField0_ &= 0xFFFFFBFF;
            this.type_ = 0;
            this.onChanged();
            return this;
        }

        public final Builder setUnknownFields(UnknownFieldSet unknownFields) {
            return (Builder)super.setUnknownFields(unknownFields);
        }

        public final Builder mergeUnknownFields(UnknownFieldSet unknownFields) {
            return (Builder)super.mergeUnknownFields(unknownFields);
        }
    }

    public static enum DeliveryVehicleType implements ProtocolMessageEnum
    {
        DELIVERY_VEHICLE_TYPE_UNSPECIFIED(0),
        AUTO(1),
        TWO_WHEELER(2),
        BICYCLE(3),
        PEDESTRIAN(4),
        UNRECOGNIZED(-1);

        public static final int DELIVERY_VEHICLE_TYPE_UNSPECIFIED_VALUE = 0;
        public static final int AUTO_VALUE = 1;
        public static final int TWO_WHEELER_VALUE = 2;
        public static final int BICYCLE_VALUE = 3;
        public static final int PEDESTRIAN_VALUE = 4;
        private static final Internal.EnumLiteMap<DeliveryVehicleType> internalValueMap;
        private static final DeliveryVehicleType[] VALUES;
        private final int value;

        public final int getNumber() {
            if (this == UNRECOGNIZED) {
                throw new IllegalArgumentException("Can't get the number of an unknown enum value.");
            }
            return this.value;
        }

        @Deprecated
        public static DeliveryVehicleType valueOf(int value) {
            return DeliveryVehicleType.forNumber(value);
        }

        public static DeliveryVehicleType forNumber(int value) {
            switch (value) {
                case 0: {
                    return DELIVERY_VEHICLE_TYPE_UNSPECIFIED;
                }
                case 1: {
                    return AUTO;
                }
                case 2: {
                    return TWO_WHEELER;
                }
                case 3: {
                    return BICYCLE;
                }
                case 4: {
                    return PEDESTRIAN;
                }
            }
            return null;
        }

        public static Internal.EnumLiteMap<DeliveryVehicleType> internalGetValueMap() {
            return internalValueMap;
        }

        public final Descriptors.EnumValueDescriptor getValueDescriptor() {
            if (this == UNRECOGNIZED) {
                throw new IllegalStateException("Can't get the descriptor of an unrecognized enum value.");
            }
            return (Descriptors.EnumValueDescriptor)DeliveryVehicleType.getDescriptor().getValues().get(this.ordinal());
        }

        public final Descriptors.EnumDescriptor getDescriptorForType() {
            return DeliveryVehicleType.getDescriptor();
        }

        public static final Descriptors.EnumDescriptor getDescriptor() {
            return (Descriptors.EnumDescriptor)DeliveryVehicle.getDescriptor().getEnumTypes().get(0);
        }

        public static DeliveryVehicleType valueOf(Descriptors.EnumValueDescriptor desc) {
            if (desc.getType() != DeliveryVehicleType.getDescriptor()) {
                throw new IllegalArgumentException("EnumValueDescriptor is not for this type.");
            }
            if (desc.getIndex() == -1) {
                return UNRECOGNIZED;
            }
            return VALUES[desc.getIndex()];
        }

        private DeliveryVehicleType(int value) {
            this.value = value;
        }

        static {
            internalValueMap = new Internal.EnumLiteMap<DeliveryVehicleType>(){

                public DeliveryVehicleType findValueByNumber(int number) {
                    return DeliveryVehicleType.forNumber(number);
                }
            };
            VALUES = DeliveryVehicleType.values();
        }
    }
}

