/*
 * Decompiled with CFR 0.152.
 */
package com.google.maps.android.compose;

import android.content.Context;
import android.view.View;
import android.view.ViewParent;
import androidx.compose.runtime.Composable;
import androidx.compose.runtime.Composer;
import androidx.compose.runtime.CompositionContext;
import androidx.compose.runtime.internal.ComposableLambdaKt;
import androidx.compose.ui.platform.ComposeView;
import com.google.android.gms.maps.GoogleMap;
import com.google.android.gms.maps.MapView;
import com.google.android.gms.maps.model.Marker;
import com.google.maps.android.compose.MarkerNode;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0014\u0010\u0004\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0005\u00a2\u0006\u0002\u0010\bJ\u0012\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u0006H\u0016J\u0012\u0010\u0010\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u0006H\u0016J,\u0010\u0011\u001a\u00020\n*\u00020\n2\u0006\u0010\u0012\u001a\u00020\u00132\u0011\u0010\u0014\u001a\r\u0012\u0004\u0012\u00020\u00160\u0015\u00a2\u0006\u0002\b\u0017H\u0002\u00a2\u0006\u0002\u0010\u0018R\u0014\u0010\t\u001a\u00020\n8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0004\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/google/maps/android/compose/ComposeInfoWindowAdapter;", "Lcom/google/android/gms/maps/GoogleMap$InfoWindowAdapter;", "mapView", "Lcom/google/android/gms/maps/MapView;", "markerNodeFinder", "Lkotlin/Function1;", "Lcom/google/android/gms/maps/model/Marker;", "Lcom/google/maps/android/compose/MarkerNode;", "(Lcom/google/android/gms/maps/MapView;Lkotlin/jvm/functions/Function1;)V", "infoWindowView", "Landroidx/compose/ui/platform/ComposeView;", "getInfoWindowView", "()Landroidx/compose/ui/platform/ComposeView;", "getInfoContents", "Landroid/view/View;", "marker", "getInfoWindow", "applyAndRemove", "parentContext", "Landroidx/compose/runtime/CompositionContext;", "content", "Lkotlin/Function0;", "", "Landroidx/compose/runtime/Composable;", "(Landroidx/compose/ui/platform/ComposeView;Landroidx/compose/runtime/CompositionContext;Lkotlin/jvm/functions/Function2;)Landroidx/compose/ui/platform/ComposeView;", "maps-compose_release"})
public final class ComposeInfoWindowAdapter
implements GoogleMap.InfoWindowAdapter {
    @NotNull
    private final MapView mapView;
    @NotNull
    private final Function1<Marker, MarkerNode> markerNodeFinder;

    public ComposeInfoWindowAdapter(@NotNull MapView mapView, @NotNull Function1<? super Marker, MarkerNode> markerNodeFinder) {
        Intrinsics.checkNotNullParameter((Object)mapView, (String)"mapView");
        Intrinsics.checkNotNullParameter(markerNodeFinder, (String)"markerNodeFinder");
        this.mapView = mapView;
        this.markerNodeFinder = markerNodeFinder;
    }

    private final ComposeView getInfoWindowView() {
        Context context = this.mapView.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"mapView.context");
        Context $this$_get_infoWindowView__u24lambda_u2d0 = context = new ComposeView(context, null, 0, 6, null);
        boolean bl = false;
        this.mapView.addView((View)$this$_get_infoWindowView__u24lambda_u2d0);
        return context;
    }

    @Nullable
    public View getInfoContents(@NotNull Marker marker) {
        Intrinsics.checkNotNullParameter((Object)marker, (String)"marker");
        MarkerNode markerNode = (MarkerNode)this.markerNodeFinder.invoke((Object)marker);
        if (markerNode == null) {
            return null;
        }
        MarkerNode markerNode2 = markerNode;
        Function3<Marker, Composer, Integer, Unit> content = markerNode2.getInfoContent();
        if (content == null) {
            return null;
        }
        return (View)this.applyAndRemove(this.getInfoWindowView(), markerNode2.getCompositionContext(), (Function2<? super Composer, ? super Integer, Unit>)((Function2)ComposableLambdaKt.composableLambdaInstance((int)-546559146, (boolean)true, (Object)new Function2<Composer, Integer, Unit>(content, marker){
            final /* synthetic */ Function3<Marker, Composer, Integer, Unit> $content;
            final /* synthetic */ Marker $marker;
            {
                this.$content = $content;
                this.$marker = $marker;
                super(2);
            }

            @Composable
            public final void invoke(@Nullable Composer $composer, int $changed) {
                if (($changed & 0xB) != 2 || !$composer.getSkipping()) {
                    this.$content.invoke((Object)this.$marker, (Object)$composer, (Object)8);
                } else {
                    $composer.skipToGroupEnd();
                }
            }
        })));
    }

    @Nullable
    public View getInfoWindow(@NotNull Marker marker) {
        Intrinsics.checkNotNullParameter((Object)marker, (String)"marker");
        MarkerNode markerNode = (MarkerNode)this.markerNodeFinder.invoke((Object)marker);
        if (markerNode == null) {
            return null;
        }
        MarkerNode markerNode2 = markerNode;
        Function3<Marker, Composer, Integer, Unit> infoWindow = markerNode2.getInfoWindow();
        if (infoWindow == null) {
            return null;
        }
        return (View)this.applyAndRemove(this.getInfoWindowView(), markerNode2.getCompositionContext(), (Function2<? super Composer, ? super Integer, Unit>)((Function2)ComposableLambdaKt.composableLambdaInstance((int)10795116, (boolean)true, (Object)new Function2<Composer, Integer, Unit>(infoWindow, marker){
            final /* synthetic */ Function3<Marker, Composer, Integer, Unit> $infoWindow;
            final /* synthetic */ Marker $marker;
            {
                this.$infoWindow = $infoWindow;
                this.$marker = $marker;
                super(2);
            }

            @Composable
            public final void invoke(@Nullable Composer $composer, int $changed) {
                if (($changed & 0xB) != 2 || !$composer.getSkipping()) {
                    this.$infoWindow.invoke((Object)this.$marker, (Object)$composer, (Object)8);
                } else {
                    $composer.skipToGroupEnd();
                }
            }
        })));
    }

    private final ComposeView applyAndRemove(ComposeView $this$applyAndRemove, CompositionContext parentContext, Function2<? super Composer, ? super Integer, Unit> content) {
        ComposeView composeView;
        ComposeView $this$applyAndRemove_u24lambda_u2d1 = composeView = $this$applyAndRemove;
        boolean bl = false;
        $this$applyAndRemove_u24lambda_u2d1.setParentCompositionContext(parentContext);
        $this$applyAndRemove_u24lambda_u2d1.setContent(content);
        ComposeView result = composeView;
        ViewParent viewParent = $this$applyAndRemove.getParent();
        MapView mapView = viewParent instanceof MapView ? (MapView)viewParent : null;
        if (mapView != null) {
            mapView.removeView((View)$this$applyAndRemove);
        }
        return result;
    }
}

