/*
 * Decompiled with CFR 0.152.
 */
package com.google.maps.android.data.kml;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.os.AsyncTask;
import android.util.Log;
import androidx.annotation.Nullable;
import com.google.android.gms.maps.GoogleMap;
import com.google.android.gms.maps.model.BitmapDescriptor;
import com.google.android.gms.maps.model.GroundOverlay;
import com.google.android.gms.maps.model.GroundOverlayOptions;
import com.google.android.gms.maps.model.Marker;
import com.google.maps.android.collections.GroundOverlayManager;
import com.google.maps.android.collections.MarkerManager;
import com.google.maps.android.collections.PolygonManager;
import com.google.maps.android.collections.PolylineManager;
import com.google.maps.android.data.Feature;
import com.google.maps.android.data.Geometry;
import com.google.maps.android.data.MultiGeometry;
import com.google.maps.android.data.Renderer;
import com.google.maps.android.data.kml.KmlContainer;
import com.google.maps.android.data.kml.KmlGroundOverlay;
import com.google.maps.android.data.kml.KmlPlacemark;
import com.google.maps.android.data.kml.KmlStyle;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class KmlRenderer
extends Renderer {
    private static final String LOG_TAG = "KmlRenderer";
    private final Set<String> mGroundOverlayUrls = new HashSet<String>();
    private boolean mMarkerIconsDownloaded = false;
    private boolean mGroundOverlayImagesDownloaded = false;
    private ArrayList<KmlContainer> mContainers;

    KmlRenderer(GoogleMap map, Context context, MarkerManager markerManager, PolygonManager polygonManager, PolylineManager polylineManager, GroundOverlayManager groundOverlayManager, @Nullable Renderer.ImagesCache imagesCache) {
        super(map, context, markerManager, polygonManager, polylineManager, groundOverlayManager, imagesCache);
    }

    private void removePlacemarks(HashMap<? extends Feature, Object> placemarks) {
        this.removeFeatures(placemarks);
    }

    static boolean getContainerVisibility(KmlContainer kmlContainer, boolean isParentContainerVisible) {
        String placemarkVisibility;
        boolean isChildContainerVisible = true;
        if (kmlContainer.hasProperty("visibility") && Integer.parseInt(placemarkVisibility = kmlContainer.getProperty("visibility")) == 0) {
            isChildContainerVisible = false;
        }
        return isParentContainerVisible && isChildContainerVisible;
    }

    private void removeContainers(Iterable<KmlContainer> containers) {
        for (KmlContainer container : containers) {
            this.removePlacemarks(container.getPlacemarksHashMap());
            this.removeGroundOverlays(container.getGroundOverlayHashMap());
            this.removeContainers(container.getContainers());
        }
    }

    public void addLayerToMap() {
        this.setLayerVisibility(true);
        this.mContainers = this.getContainerList();
        this.putStyles();
        this.assignStyleMap(this.getStyleMaps(), this.getStylesRenderer());
        this.addGroundOverlays(this.getGroundOverlayMap(), this.mContainers);
        this.addContainerGroupToMap(this.mContainers, true);
        this.addPlacemarksToMap(this.getAllFeatures());
        if (!this.mGroundOverlayImagesDownloaded) {
            this.downloadGroundOverlays();
        }
        if (!this.mMarkerIconsDownloaded) {
            this.downloadMarkerIcons();
        }
        this.checkClearBitmapCache();
    }

    void storeKmlData(HashMap<String, KmlStyle> styles, HashMap<String, String> styleMaps, HashMap<KmlPlacemark, Object> features, ArrayList<KmlContainer> folders, HashMap<KmlGroundOverlay, GroundOverlay> groundOverlays) {
        this.storeData(styles, styleMaps, features, folders, groundOverlays);
    }

    void storeKmzData(HashMap<String, KmlStyle> styles, HashMap<String, String> styleMaps, HashMap<KmlPlacemark, Object> features, ArrayList<KmlContainer> folders, HashMap<KmlGroundOverlay, GroundOverlay> groundOverlays, HashMap<String, Bitmap> images) {
        this.storeData(styles, styleMaps, features, folders, groundOverlays);
        for (Map.Entry<String, Bitmap> entry : images.entrySet()) {
            this.cacheBitmap(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public void setMap(GoogleMap map) {
        this.removeLayerFromMap();
        super.setMap(map);
        this.addLayerToMap();
    }

    boolean hasKmlPlacemarks() {
        return this.hasFeatures();
    }

    Iterable<? extends Feature> getKmlPlacemarks() {
        return this.getFeatures();
    }

    public boolean hasNestedContainers() {
        return this.mContainers.size() > 0;
    }

    public Iterable<KmlContainer> getNestedContainers() {
        return this.mContainers;
    }

    public Iterable<KmlGroundOverlay> getGroundOverlays() {
        return this.getGroundOverlayMap().keySet();
    }

    public void removeLayerFromMap() {
        this.removePlacemarks(this.getAllFeatures());
        this.removeGroundOverlays(this.getGroundOverlayMap());
        if (this.hasNestedContainers()) {
            this.removeContainers(this.getNestedContainers());
        }
        this.setLayerVisibility(false);
        this.clearStylesRenderer();
    }

    private void addPlacemarksToMap(HashMap<? extends Feature, Object> placemarks) {
        for (Feature feature : placemarks.keySet()) {
            this.addFeature(feature);
        }
    }

    private void addContainerGroupToMap(Iterable<KmlContainer> kmlContainers, boolean containerVisibility) {
        for (KmlContainer container : kmlContainers) {
            boolean isContainerVisible = KmlRenderer.getContainerVisibility(container, containerVisibility);
            if (container.getStyles() != null) {
                this.putStyles(container.getStyles());
            }
            if (container.getStyleMap() != null) {
                super.assignStyleMap(container.getStyleMap(), this.getStylesRenderer());
            }
            this.addContainerObjectToMap(container, isContainerVisible);
            if (!container.hasContainers()) continue;
            this.addContainerGroupToMap(container.getContainers(), isContainerVisible);
        }
    }

    private void addContainerObjectToMap(KmlContainer kmlContainer, boolean isContainerVisible) {
        for (Feature feature : kmlContainer.getPlacemarks()) {
            boolean isObjectVisible;
            boolean isPlacemarkVisible = KmlRenderer.getPlacemarkVisibility(feature);
            boolean bl = isObjectVisible = isContainerVisible && isPlacemarkVisible;
            if (feature.getGeometry() == null) continue;
            String placemarkId = feature.getId();
            Geometry geometry = feature.getGeometry();
            KmlStyle style2 = this.getPlacemarkStyle(placemarkId);
            KmlStyle inlineStyle = ((KmlPlacemark)feature).getInlineStyle();
            Object mapObject = this.addKmlPlacemarkToMap((KmlPlacemark)feature, geometry, style2, inlineStyle, isObjectVisible);
            kmlContainer.setPlacemark((KmlPlacemark)feature, mapObject);
            this.putContainerFeature(mapObject, feature);
        }
    }

    private void downloadMarkerIcons() {
        this.mMarkerIconsDownloaded = true;
        Iterator<String> iterator = this.getMarkerIconUrls().iterator();
        while (iterator.hasNext()) {
            String markerIconUrl = iterator.next();
            new MarkerIconImageDownload(markerIconUrl).execute(new String[0]);
            iterator.remove();
        }
    }

    private void addIconToMarkers(String iconUrl, HashMap<KmlPlacemark, Object> placemarks) {
        for (Feature feature : placemarks.keySet()) {
            KmlStyle urlStyle = this.getStylesRenderer().get(feature.getId());
            KmlStyle inlineStyle = ((KmlPlacemark)feature).getInlineStyle();
            Geometry geometry = feature.getGeometry();
            Object object = placemarks.get(feature);
            this.addIconToGeometry(iconUrl, urlStyle, inlineStyle, geometry, object);
        }
    }

    private void addIconToGeometry(String iconUrl, KmlStyle urlStyle, KmlStyle inlineStyle, Geometry geometry, Object object) {
        if (geometry == null) {
            return;
        }
        if ("Point".equals(geometry.getGeometryType())) {
            this.addIconToMarker(iconUrl, urlStyle, inlineStyle, (Marker)object);
        } else if ("MultiGeometry".equals(geometry.getGeometryType())) {
            this.addIconToMultiGeometry(iconUrl, urlStyle, inlineStyle, (MultiGeometry)geometry, (List)object);
        }
    }

    private void addIconToMultiGeometry(String iconUrl, KmlStyle urlStyle, KmlStyle inlineStyle, MultiGeometry multiGeometry, List<Object> objects) {
        Iterator geometries = multiGeometry.getGeometryObject().iterator();
        Iterator<Object> objItr = objects.iterator();
        while (geometries.hasNext() && objItr.hasNext()) {
            Geometry geometry = (Geometry)geometries.next();
            Object object = objItr.next();
            this.addIconToGeometry(iconUrl, urlStyle, inlineStyle, geometry, object);
        }
    }

    private void addIconToMarker(String iconUrl, KmlStyle urlStyle, KmlStyle inlineStyle, Marker marker) {
        boolean isPlacemarkStyleIcon;
        boolean isInlineStyleIcon = inlineStyle != null && iconUrl.equals(inlineStyle.getIconUrl());
        boolean bl = isPlacemarkStyleIcon = urlStyle != null && iconUrl.equals(urlStyle.getIconUrl());
        if (isInlineStyleIcon) {
            this.scaleBitmap(inlineStyle, marker);
        } else if (isPlacemarkStyleIcon) {
            this.scaleBitmap(urlStyle, marker);
        }
    }

    private void scaleBitmap(KmlStyle style2, Marker marker) {
        double bitmapScale = style2.getIconScale();
        String bitmapUrl = style2.getIconUrl();
        BitmapDescriptor scaledBitmap = this.getCachedMarkerImage(bitmapUrl, bitmapScale);
        marker.setIcon(scaledBitmap);
    }

    private void addContainerGroupIconsToMarkers(String iconUrl, Iterable<KmlContainer> kmlContainers) {
        for (KmlContainer container : kmlContainers) {
            this.addIconToMarkers(iconUrl, container.getPlacemarksHashMap());
            if (!container.hasContainers()) continue;
            this.addContainerGroupIconsToMarkers(iconUrl, container.getContainers());
        }
    }

    private void addGroundOverlays(HashMap<KmlGroundOverlay, GroundOverlay> groundOverlays, Iterable<KmlContainer> kmlContainers) {
        this.addGroundOverlays(groundOverlays);
        for (KmlContainer container : kmlContainers) {
            this.addGroundOverlays(container.getGroundOverlayHashMap(), container.getContainers());
        }
    }

    private void addGroundOverlays(HashMap<KmlGroundOverlay, GroundOverlay> groundOverlays) {
        for (KmlGroundOverlay groundOverlay : groundOverlays.keySet()) {
            String groundOverlayUrl = groundOverlay.getImageUrl();
            if (groundOverlayUrl == null || groundOverlay.getLatLngBox() == null) continue;
            if (this.getCachedGroundOverlayImage(groundOverlayUrl) != null) {
                this.addGroundOverlayToMap(groundOverlayUrl, this.getGroundOverlayMap(), true);
                continue;
            }
            this.mGroundOverlayUrls.add(groundOverlayUrl);
        }
    }

    private void downloadGroundOverlays() {
        this.mGroundOverlayImagesDownloaded = true;
        Iterator<String> iterator = this.mGroundOverlayUrls.iterator();
        while (iterator.hasNext()) {
            String groundOverlayUrl = iterator.next();
            new GroundOverlayImageDownload(groundOverlayUrl).execute(new String[0]);
            iterator.remove();
        }
    }

    private void addGroundOverlayToMap(String groundOverlayUrl, HashMap<KmlGroundOverlay, GroundOverlay> groundOverlays, boolean containerVisibility) {
        BitmapDescriptor groundOverlayBitmap = this.getCachedGroundOverlayImage(groundOverlayUrl);
        for (KmlGroundOverlay kmlGroundOverlay : groundOverlays.keySet()) {
            if (!kmlGroundOverlay.getImageUrl().equals(groundOverlayUrl)) continue;
            GroundOverlayOptions groundOverlayOptions = kmlGroundOverlay.getGroundOverlayOptions().image(groundOverlayBitmap);
            GroundOverlay mapGroundOverlay = this.attachGroundOverlay(groundOverlayOptions);
            if (!containerVisibility) {
                mapGroundOverlay.setVisible(false);
            }
            groundOverlays.put(kmlGroundOverlay, mapGroundOverlay);
        }
    }

    private void addGroundOverlayInContainerGroups(String groundOverlayUrl, Iterable<KmlContainer> kmlContainers, boolean containerVisibility) {
        for (KmlContainer container : kmlContainers) {
            boolean isContainerVisible = KmlRenderer.getContainerVisibility(container, containerVisibility);
            this.addGroundOverlayToMap(groundOverlayUrl, container.getGroundOverlayHashMap(), isContainerVisible);
            if (!container.hasContainers()) continue;
            this.addGroundOverlayInContainerGroups(groundOverlayUrl, container.getContainers(), isContainerVisible);
        }
    }

    private Bitmap getBitmapFromUrl(String url) throws IOException {
        return BitmapFactory.decodeStream((InputStream)this.openConnectionCheckRedirects(new URL(url).openConnection()));
    }

    private InputStream openConnectionCheckRedirects(URLConnection c) throws IOException {
        InputStream in;
        boolean redir;
        int redirects = 0;
        do {
            HttpURLConnection http;
            int stat;
            if (c instanceof HttpURLConnection) {
                ((HttpURLConnection)c).setInstanceFollowRedirects(false);
            }
            in = c.getInputStream();
            redir = false;
            if (!(c instanceof HttpURLConnection) || (stat = (http = (HttpURLConnection)c).getResponseCode()) < 300 || stat > 307 || stat == 306 || stat == 304) continue;
            URL base = http.getURL();
            String loc = http.getHeaderField("Location");
            URL target = null;
            if (loc != null) {
                target = new URL(base, loc);
            }
            http.disconnect();
            if (target == null || !target.getProtocol().equals("http") && !target.getProtocol().equals("https") || redirects >= 5) {
                throw new SecurityException("illegal URL redirect");
            }
            redir = true;
            c = target.openConnection();
            ++redirects;
        } while (redir);
        return in;
    }

    private class GroundOverlayImageDownload
    extends AsyncTask<String, Void, Bitmap> {
        private final String mGroundOverlayUrl;

        public GroundOverlayImageDownload(String groundOverlayUrl) {
            this.mGroundOverlayUrl = groundOverlayUrl;
            KmlRenderer.this.downloadStarted();
        }

        protected Bitmap doInBackground(String ... params) {
            try {
                return KmlRenderer.this.getBitmapFromUrl(this.mGroundOverlayUrl);
            }
            catch (MalformedURLException e) {
                return BitmapFactory.decodeFile((String)this.mGroundOverlayUrl);
            }
            catch (IOException e) {
                Log.e((String)KmlRenderer.LOG_TAG, (String)("Image [" + this.mGroundOverlayUrl + "] download issue"), (Throwable)e);
                return null;
            }
        }

        protected void onPostExecute(Bitmap bitmap) {
            if (bitmap == null) {
                Log.e((String)KmlRenderer.LOG_TAG, (String)("Image at this URL could not be found " + this.mGroundOverlayUrl));
            } else {
                KmlRenderer.this.cacheBitmap(this.mGroundOverlayUrl, bitmap);
                if (KmlRenderer.this.isLayerOnMap()) {
                    KmlRenderer.this.addGroundOverlayToMap(this.mGroundOverlayUrl, KmlRenderer.this.getGroundOverlayMap(), true);
                    KmlRenderer.this.addGroundOverlayInContainerGroups(this.mGroundOverlayUrl, KmlRenderer.this.mContainers, true);
                }
            }
            KmlRenderer.this.downloadFinished();
        }
    }

    private class MarkerIconImageDownload
    extends AsyncTask<String, Void, Bitmap> {
        private final String mIconUrl;

        public MarkerIconImageDownload(String iconUrl) {
            this.mIconUrl = iconUrl;
            KmlRenderer.this.downloadStarted();
        }

        protected Bitmap doInBackground(String ... params) {
            try {
                return KmlRenderer.this.getBitmapFromUrl(this.mIconUrl);
            }
            catch (MalformedURLException e) {
                return BitmapFactory.decodeFile((String)this.mIconUrl);
            }
            catch (IOException e) {
                e.printStackTrace();
                return null;
            }
        }

        protected void onPostExecute(Bitmap bitmap) {
            if (bitmap == null) {
                Log.e((String)KmlRenderer.LOG_TAG, (String)("Image at this URL could not be found " + this.mIconUrl));
            } else {
                KmlRenderer.this.cacheBitmap(this.mIconUrl, bitmap);
                if (KmlRenderer.this.isLayerOnMap()) {
                    KmlRenderer.this.addIconToMarkers(this.mIconUrl, KmlRenderer.this.getAllFeatures());
                    KmlRenderer.this.addContainerGroupIconsToMarkers(this.mIconUrl, KmlRenderer.this.mContainers);
                }
            }
            KmlRenderer.this.downloadFinished();
        }
    }
}

